/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*             ImageFil.h - Image File Functions (c) 1998 PEZIK             */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#ifndef _IMAGEFIL
#define _IMAGEFIL

//#include "AbsI.h"
#include "Image.h"
#ifdef USE_LIBENTRY
# include <LibEntry.h>
#else
# define LIBENTRY
#endif

typedef struct ImageFileInfoStruct
{
    int XSize;
    int YSize;
    int RGB;
} ImageFileInfo;

#ifdef __cplusplus
extern "C" {
#endif

struct ImageFileStruct;
struct ImageAccess;

int LIBENTRY LoadImageAccessPos(struct ImageFileStruct * File,struct ImageAccess * Access,ImageStruct * Image,int XFile,int YFile,int XImage,int YImage,int XSize,int YSize,int (*Progress)(void * ProgressID,long Done,long Total),void * ProgressID);
int LIBENTRY LoadImageFilePos(char * Name,int FilterIndex,ImageStruct * Image,int XFile,int YFile,int XImage,int YImage,int XSize,int YSize,int (*Progress)(void * ProgressID,long Done,long Total),void * ProgressID);
int LIBENTRY LoadImageFile(char * Name,int FilterIndex,ImageStruct * Image,int (*Progress)(void * ProgressID,long Done,long Total),void * ProgressID);
ImageStruct * LIBENTRY CreateImageFile(char * Name,int FilterIndex,int (*Progress)(void * ProgressID,long Done,long Total),void * ProgressID);
int LIBENTRY GetImageFileInfo(char * Name,int FilterIndex,ImageFileInfo * FileInfo);
int LIBENTRY SaveImageAccessPos(struct ImageFileStruct * File,struct ImageAccess * Access,ImageStruct * Image,int XFile,int YFile,int XImage,int YImage,int XSize,int YSize,int (*Progress)(void * ProgressID,long Done,long Total),void * ProgressID);
int LIBENTRY SaveImageFilePos(char * Name,int FilterIndex,ImageStruct * Image,int XFile,int YFile,int XImage,int YImage,int XSize,int YSize,int (*Progress)(void * ProgressID,long Done,long Total),void * ProgressID);
int LIBENTRY SaveImageFile(char * Name,int FilterIndex,ImageStruct * Image,int (*Progress)(void * ProgressID,long Done,long Total),void * ProgressID);

int LIBENTRY GetImageInfo(char * Name,int FilterIndex,unsigned char * Info,unsigned Len);
int LIBENTRY PutImageInfo(char * Name,int FilterIndex,unsigned char * Info,unsigned Len);

#ifdef __cplusplus
}
#endif

#endif

