/*
 * File:     FIR.c, compiled by gcc
 * Date:     2009-02-02 21:02:43 
 * Author:   Bronislav Pribyl, xpriby12@stud.fit.vutbr.cz
 * Project:  Separable image resampling
 * Encoding: utf-8
 * Version:  1.5
 * Desc:     Module to handle FIR filter
 */

#include "FIR.h"
#include <stdio.h>


/**
 * Auxiliary function for dump of FIR filter coefficients.
 * @param fir_variants Number of variants of FIR filter
 * @param fir_length Length of FIR filter
 * @param fir 2D array of FIR filter self
 */
void print_fir(int fir_variants, int fir_length, const int fir[][fir_length])
{
		for(int i = 0; i < fir_variants; i++){
			printf("%2d: ", i);
		for(int j = 0; j < fir_length; j++){
			printf("%6d ", fir[i][j]);
		}
		printf("\n");
	}
	
	printf("\n");
	
	return;
}
 
/* end of file FIR.c */

