/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*     Image.h - Image Functions - Windows version (c) 1998-2002 PEZIK      */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#ifndef _IMAGE
#define _IMAGE

#if defined(__BORLANDC__) && !defined(MAKING_DLL)
 #pragma link "KernelLib.lib"
#endif

#include "LibEntry.h"

typedef unsigned char Image8Value;
typedef short Image16Value;
typedef long Image32Value;
typedef float ImageFloatValue;
typedef unsigned char ImageRGBValue;
typedef unsigned long ImageRGBValueRGB;
typedef struct { float Re; float Im; } ImageComplexValue;

typedef struct ImageStruct {
  unsigned char * Raster;
  char * Info;
  void * BinInfo;
  int BinInfoSize;
  void *ExtraInfo;
  int XSize;
  int YSize;
  int XOffset;
  int YOffset;
  int InfoSize;
  short PixelType;
  short ImageType;
  int References;
  union {
    struct {
      void (* Free)(void *);
    } Regular;
    struct {
      void (* Free)(void *);
      struct ImageStruct * Referenced;
    } Reference;
    struct {
      void (* Free)(void *);
      void (* FreeData)(void *);
      void * Data;
    } External;
  } Optional;
} ImageStruct;


#ifdef __cplusplus
extern "C" {
#endif

#define Image8Pixel(Image,X,Y) (*(Image8Value *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset))
#define SetImage8Pixel(Image,X,Y,Value) { Image8Pixel((Image),(X),(Y)) = (Value); }
#define Image8LinearPixel(Image,X,Y) (*(Image8Value *)((Image)->Raster+(X)*sizeof(Image8Value)+(Y)*(Image)->YOffset))
#define SetImage8LinearPixel(Image,X,Y,Value) { Image8LinearPixel((Image),(X),(Y)) = (Value); }

#define Image16Pixel(Image,X,Y) (*(Image16Value *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset))
#define SetImage16Pixel(Image,X,Y,Value) { Image16Pixel((Image),(X),(Y)) = (Value); }
#define Image16LinearPixel(Image,X,Y) (*(Image16Value *)((Image)->Raster+(X)*sizeof(Image16Value)+(Y)*(Image)->YOffset))
#define SetImage16LinearPixel(Image,X,Y,Value) { Image16LinearPixel((Image),(X),(Y)) = (Value); }

#define Image32Pixel(Image,X,Y) (*(Image32Value *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset))
#define SetImage32Pixel(Image,X,Y,Value) { Image32Pixel((Image),(X),(Y)) = (Value); }
#define Image32LinearPixel(Image,X,Y) (*(Image32Value *)((Image)->Raster+(X)*sizeof(Image32Value)+(Y)*(Image)->YOffset))
#define SetImage32LinearPixel(Image,X,Y,Value) { Image32Pixel((Image),(X),(Y)) = (Value); }

#define ImageFloatPixel(Image,X,Y) (*(ImageFloatValue *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset))
#define SetImageFloatPixel(Image,X,Y,Value) { ImageFloatPixel((Image),(X),(Y)) = (Value); }
#define ImageFloatLinearPixel(Image,X,Y) (*(ImageFloatValue *)((Image)->Raster+(X)*sizeof(ImageFloatValue)+(Y)*(Image)->YOffset))
#define SetImageFloatLinearPixel(Image,X,Y,Value) { ImageFloatLinearPixel((Image),(X),(Y)) = (Value); }

#define ImageRGBValueR(x) ((ImageRGBValue)((x&0xFF0000U)>>16))
#define ImageRGBValueG(x) ((ImageRGBValue)((x&0x00FF00U)>>8))
#define ImageRGBValueB(x) ((ImageRGBValue)((x&0x0000FFU)))
#define MakeImageRGBValueRGB(R,G,B) (((((ImageRGBValueRGB)R)&0xFFU)<<16) | ((((ImageRGBValueRGB)G)&0xFFU)<<8) | ((((ImageRGBValueRGB)B)&0xFFU)<<0))

#define ImageRGBPixelRGB(Image,X,Y) (*(ImageRGBValueRGB *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset))
#define ImageRGBPixelB(Image,X,Y) (*(ImageRGBValue *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset+0))
#define ImageRGBPixelG(Image,X,Y) (*(ImageRGBValue *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset+1))
#define ImageRGBPixelR(Image,X,Y) (*(ImageRGBValue *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset+2))
#define ImageRGBPixelA(Image,X,Y) (*(ImageRGBValue *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset+3))
#define SetImageRGBPixelRGB(Image,X,Y,Value) { ImageRGBPixelRGB((Image),(X),(Y)) = (Value); }
#define SetImageRGBPixel(Image,X,Y,R,G,B) { ImageRGBPixelB((Image),(X),(Y)) = (B), ImageRGBPixelG((Image),(X),(Y)) = (G), ImageRGBPixelR((Image),(X),(Y)) = (R), ImageRGBPixelA((Image),(X),(Y)) = 0; }
#define SetImageRGBPixelA(Image,X,Y,R,G,B,A) { ImageRGBPixelB((Image),(X),(Y)) = (B), ImageRGBPixelG((Image),(X),(Y)) = (G), ImageRGBPixelR((Image),(X),(Y)) = (R), ImageRGBPixelA((Image),(X),(Y)) = (A); }
#define ImageRGBLinearPixelRGB(Image,X,Y) (*(ImageRGBValueRGB *)((Image)->Raster+(X)*sizeof(ImageRGBValueRGB)+(Y)*(Image)->YOffset))
#define ImageRGBLinearPixelB(Image,X,Y) (*(ImageRGBValue *)((Image)->Raster+(X)*sizeof(ImageRGBValueRGB)+(Y)*(Image)->YOffset+0))
#define ImageRGBLinearPixelG(Image,X,Y) (*(ImageRGBValue *)((Image)->Raster+(X)*sizeof(ImageRGBValueRGB)+(Y)*(Image)->YOffset+1))
#define ImageRGBLinearPixelR(Image,X,Y) (*(ImageRGBValue *)((Image)->Raster+(X)*sizeof(ImageRGBValueRGB)+(Y)*(Image)->YOffset+2))
#define ImageRGBLinearPixelA(Image,X,Y) (*(ImageRGBValue *)((Image)->Raster+(X)*sizeof(ImageRGBValueRGB)+(Y)*(Image)->YOffset+3))
#define SetImageRGBLinearPixelRGB(Image,X,Y,Value) { ImageRGBPixelRGB((Image),(X),(Y)) = (Value); }
#define SetImageRGBLinearPixel(Image,X,Y,R,G,B) { ImageRGBPixelB((Image),(X),(Y)) = (B), ImageRGBPixelG((Image),(X),(Y)) = (G), ImageRGBPixelR((Image),(X),(Y)) = (R), ImageRGBPixelA((Image),(X),(Y)) = 0; }
#define SetImageRGBLinearPixelA(Image,X,Y,R,G,B,A) { ImageRGBPixelB((Image),(X),(Y)) = (B), ImageRGBPixelG((Image),(X),(Y)) = (G), ImageRGBPixelR((Image),(X),(Y)) = (R), ImageRGBPixelA((Image),(X),(Y)) = (A); }

#define ImageComplexPixel(Image,X,Y) (*(ImageComplexValue *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset))
#define ImageComplexPixelRe(Image,X,Y) (((ImageComplexValue *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset))->Re)
#define ImageComplexPixelIm(Image,X,Y) (((ImageComplexValue *)((Image)->Raster+(X)*(Image)->XOffset+(Y)*(Image)->YOffset))->Im)
#define SetImageComplexPixel(Image,X,Y,Value) { ImageComplexPixel((Image),(X),(Y)) = (Value); }
#define SetImageComplexPixelRe(Image,X,Y,Re) { ImageComplexPixelRe((Image),(X),(Y)) = (Re); }
#define SetImageComplexPixelIm(Image,X,Y,Im) { ImageComplexPixelIm((Image),(X),(Y)) = (Im); }
#define SetImageComplexPixelReIm(Image,X,Y,Re,Im) { ImageComplexPixelRe((Image),(X),(Y)) = (Re), ImageComplexPixelIm((Image),(X),(Y)) = (Im); }
#define ImageComplexLinearPixel(Image,X,Y) (*(ImageComplexValue *)((Image)->Raster+(X)*sizeof(ImageComplexValue)+(Y)*(Image)->YOffset))
#define ImageComplexLinearPixelRe(Image,X,Y) (((ImageComplexValue *)((Image)->Raster+(X)*sizeof(ImageComplexValue)+(Y)*(Image)->YOffset))->Re)
#define ImageComplexLinearPixelIm(Image,X,Y) (((ImageComplexValue *)((Image)->Raster+(X)*sizeof(ImageComplexValue)+(Y)*(Image)->YOffset))->Im)
#define SetImageComplexLinearPixel(Image,X,Y,Value) { ImageComplexLinearPixel((Image),(X),(Y)) = (Value); }
#define SetImageComplexLinearPixelRe(Image,X,Y,Re) { ImageComplexLinearPixelRe((Image),(X),(Y)) = (Re); }
#define SetImageComplexLinearPixelIm(Image,X,Y,Im) { ImageComplexLinearPixelIm((Image),(X),(Y)) = (Im); }
#define SetImageComplexLinearPixelReIm(Image,X,Y,Re,Im) { ImageComplexLinearPixelRe((Image),(X),(Y)) = (Re), ImageComplexLinearPixelIm((Image),(X),(Y)) = (Im); }

#define ImageXOffset(Image) ((Image)->XOffset)
#define ImageYOffset(Image) ((Image)->YOffset)

#define ImageXSize(Image) ((Image)->XSize)
#define ImageYSize(Image) ((Image)->YSize)

#define ImagePixelType(Image) ((Image)->PixelType)
#define ImageInfo(Image) ((Image)->Info)
#define ImageInfoSize(Image) ((Image)->InfoSize)
#define ImageBinInfo(Image) ((Image)->BinInfo)
#define ImageBinInfoSize(Image) ((Image)->BinInfoSize)
#define ImageExtraInfo(Image) ((Image)->ExtraInfo)

#define NewImage NewImage8
#define ImagePixel Image8Pixel
#define SetImagePixel SetImage8Pixel

#define NewImage8Grab NewImage8Continuous

ImageStruct * LIBENTRY NewImage8(unsigned XSize,unsigned YSize);
ImageStruct * LIBENTRY NewImage8Continuous(unsigned XSize,unsigned YSize,unsigned InfoSize,void * (* Alloc)(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImage16(unsigned XSize,unsigned YSize);
ImageStruct * LIBENTRY NewImage32(unsigned XSize,unsigned YSize);
ImageStruct * LIBENTRY NewImageFloat(unsigned XSize,unsigned YSize);
ImageStruct * LIBENTRY NewImageRGB(unsigned XSize,unsigned YSize);
ImageStruct * LIBENTRY NewImageComplex(unsigned XSize,unsigned YSize);

ImageStruct * LIBENTRY NewImage8Alloc(unsigned XSize,unsigned YSize,unsigned InfoSize,void * (* Alloc)(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImage16Alloc(unsigned XSize,unsigned YSize,unsigned InfoSize,void * (* Alloc)(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImage32Alloc(unsigned XSize,unsigned YSize,unsigned InfoSize,void * (* Alloc)(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImageFloatAlloc(unsigned XSize,unsigned YSize,unsigned InfoSize,void * (* Alloc)(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImageRGBAlloc(unsigned XSize,unsigned YSize,unsigned InfoSize,void * (* Alloc)(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImageComplexAlloc(unsigned XSize,unsigned YSize,unsigned InfoSize,void * (* Alloc)(unsigned Size),void (* Free)(void * Block));

ImageStruct * LIBENTRY NewImageTypeAlloc(unsigned XSize,unsigned YSize,unsigned InfoSize,void * (* Alloc)(unsigned Size),void (* Free)(void * Block),short PixelType);

ImageStruct * LIBENTRY NewImageClone(ImageStruct * FromImage);
ImageStruct * LIBENTRY NewImageReferenceUnchanged(ImageStruct * FromImage); /* Returns always FromImage */

ImageStruct * LIBENTRY NewImageReference(ImageStruct * FromImage,unsigned XPos,unsigned YPos,unsigned XSize,unsigned YSize);
ImageStruct * LIBENTRY NewImageReferenceStepAlloc(ImageStruct * FromImage,unsigned XPos,unsigned YPos,unsigned XSize,unsigned YSize,int XStep,int YStep,void * Alloc(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImageReferenceStepAllocType(ImageStruct * FromImage,unsigned XPos,unsigned YPos,unsigned XSize,unsigned YSize,int XStep,int YStep,int RasterShift,unsigned PixelType,void * Alloc(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImageReferenceTransposeAlloc(ImageStruct * FromImage,void * Alloc(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImageReferenceXMirrorAlloc(ImageStruct * FromImage,void * Alloc(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY NewImageReferenceYMirrorAlloc(ImageStruct * FromImage,void * Alloc(unsigned Size),void (* Free)(void * Block));

ImageStruct * LIBENTRY NewImageReferenceExternal(unsigned XSize,unsigned YSize,unsigned XOffset,unsigned YOffset,unsigned PixelType,void * Raster,void * Info,int InfoSize,void * Data,void (* FreeData)(void * Block));
ImageStruct * LIBENTRY NewImageReferenceExternalAlloc(unsigned XSize,unsigned YSize,unsigned XOffset,unsigned YOffset,unsigned PixelType,void * Raster,void * Info,int InfoSize,void * Data,void (* FreeData)(void * Block),void * Alloc(unsigned Size),void (* Free)(void * Block));
ImageStruct * LIBENTRY SetImageReferenceExternal(ImageStruct * New,unsigned XSize,unsigned YSize,unsigned XOffset,unsigned YOffset,unsigned PixelType,void * Raster,void * Info,int InfoSize,void * Data,void (* FreeData)(void * Block));

ImageStruct * LIBENTRY SetTempReference(ImageStruct * New,const ImageStruct * FromImage,unsigned XPos,unsigned YPos,unsigned XSize,unsigned YSize);
ImageStruct * LIBENTRY SetTempReferenceStep(ImageStruct * New,const ImageStruct * FromImage,unsigned XPos,unsigned YPos,unsigned XSize,unsigned YSize,int XStep,int YStep);
ImageStruct * LIBENTRY SetTempReferenceStepType(ImageStruct * New,const ImageStruct * FromImage,unsigned XPos,unsigned YPos,unsigned XSize,unsigned YSize,int XStep,int YStep,int RasterShift,unsigned PixelType);

int LIBENTRY MakeBinImageInfo(ImageStruct * Image, int size);

void LIBENTRY DeleteImage(ImageStruct * ToDelete);

const ImageStruct * LIBENTRY GetOriginalImage(const ImageStruct * Image);

void LIBENTRY FillImageWithTestData(ImageStruct *img);

#ifdef __cplusplus
}
#endif

/* Pixel Type Definitions */

#define Image8                 ((short)(0x0010|sizeof(Image8Value)))
#define Image8Linear           ((short)(0x0030|sizeof(Image8Value)))
#define Image16                ((short)(0x0040|sizeof(Image16Value)))
#define Image16Linear          ((short)(0x00C0|sizeof(Image16Value)))
#define Image32                ((short)(0x0100|sizeof(Image32Value)))
#define Image32Linear          ((short)(0x0300|sizeof(Image32Value)))
#define ImageFloat             ((short)(0x0400|sizeof(ImageFloatValue)))
#define ImageFloatLinear       ((short)(0x0C00|sizeof(ImageFloatValue)))
#define ImageRGB               ((short)(0x1000|sizeof(ImageRGBValueRGB)))
#define ImageRGBLinear         ((short)(0x3000|sizeof(ImageRGBValueRGB)))
#define ImageComplex           ((short)(0x4000|sizeof(ImageComplexValue)))
#define ImageComplexLinear     ((short)(0xC000|sizeof(ImageComplexValue)))

#define ImageLinearMask        ((short)(0xAAA0))
#define ImageValueMask         0xF

/* Image Type Definitions */

#define RegularImage           0x01
#define ReferenceImage         0x02
#define ExternalImage          0x04
#define TempImage              0x08

/* Info Definitions */

#define DefaultInfoSize        768

#endif

