/*
 * File:     FIR.h, compiled by gcc
 * Date:     2009-02-02 21:02:59 
 * Author:   Bronislav Pribyl, xpriby12@stud.fit.vutbr.cz
 * Project:  Separable image resampling
 * Encoding: utf-8
 * Version:  1.5
 * Desc:     Module to handle FIR filter
 */

#define FIR_ONE 16384 //2^14
#define FIR_VARIANTS 16
#define FIR_LENGTH 8

static const int FIR_LINEAR[FIR_VARIANTS][FIR_LENGTH] = {
//0
{0, 0, (int)(0.5*FIR_ONE), (int)(0.5*FIR_ONE), 0, 0, 0, 0},

//1
{0, 0, (int)(0.5*FIR_ONE - 1.0*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE + 1.0*FIR_ONE/FIR_VARIANTS), 0, 0, 0, 0},

//2
{0, 0, (int)(0.5*FIR_ONE - 2.0*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE + 2.0*FIR_ONE/FIR_VARIANTS), 0, 0, 0, 0},

//3
{0, 0, (int)(0.5*FIR_ONE - 3.0*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE + 3.0*FIR_ONE/FIR_VARIANTS), 0, 0, 0, 0},

//4
{0, 0, (int)(0.5*FIR_ONE - 4.0*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE + 4.0*FIR_ONE/FIR_VARIANTS), 0, 0, 0, 0},

//5
{0, 0, (int)(0.5*FIR_ONE - 5.0*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE + 5.0*FIR_ONE/FIR_VARIANTS), 0, 0, 0, 0},

//6
{0, 0, (int)(0.5*FIR_ONE - 6.0*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE + 6.0*FIR_ONE/FIR_VARIANTS), 0, 0, 0, 0},

//7
{0, 0, (int)(0.5*FIR_ONE - 7.0*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE + 7.0*FIR_ONE/FIR_VARIANTS), 0, 0, 0, 0},

//8
{0, 0, 0, FIR_ONE, 0, 0, 0, 0},

//9
{0, 0, 0, (int)(0.5*FIR_ONE - (9.0-FIR_VARIANTS)*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE - (FIR_VARIANTS-9.0)*FIR_ONE/FIR_VARIANTS), 0, 0, 0},

//10
{0, 0, 0, (int)(0.5*FIR_ONE - (10.0-FIR_VARIANTS)*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE - (FIR_VARIANTS-10.0)*FIR_ONE/FIR_VARIANTS), 0, 0, 0},

//11
{0, 0, 0, (int)(0.5*FIR_ONE - (11.0-FIR_VARIANTS)*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE - (FIR_VARIANTS-11.0)*FIR_ONE/FIR_VARIANTS), 0, 0, 0},

//12
{0, 0, 0, (int)(0.5*FIR_ONE - (12.0-FIR_VARIANTS)*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE - (FIR_VARIANTS-12.0)*FIR_ONE/FIR_VARIANTS), 0, 0, 0},

//13
{0, 0, 0, (int)(0.5*FIR_ONE - (13.0-FIR_VARIANTS)*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE - (FIR_VARIANTS-13.0)*FIR_ONE/FIR_VARIANTS), 0, 0, 0},

//14
{0, 0, 0, (int)(0.5*FIR_ONE - (14.0-FIR_VARIANTS)*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE - (FIR_VARIANTS-14.0)*FIR_ONE/FIR_VARIANTS), 0, 0, 0},

//15
{0, 0, 0, (int)(0.5*FIR_ONE - (15.0-FIR_VARIANTS)*FIR_ONE/FIR_VARIANTS), (int)(0.5*FIR_ONE - (FIR_VARIANTS-15.0)*FIR_ONE/FIR_VARIANTS), 0, 0, 0}
};



static const int FIR_SEQUENCE[FIR_VARIANTS][FIR_LENGTH] = {
//0
{0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0000},
//1
{0x0100, 0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0000},
//2
{0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0000},
//3
{0x0300, 0x0301, 0x0302, 0x0303, 0x0304, 0x0305, 0x0306, 0x0000},
//4
{0x0400, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0000},
//5
{0x0500, 0x0501, 0x0502, 0x0503, 0x0504, 0x0505, 0x0506, 0x0000},
//6
{0x0600, 0x0601, 0x0602, 0x0603, 0x0604, 0x0605, 0x0606, 0x0000},
//7
{0x0700, 0x0701, 0x0702, 0x0703, 0x0704, 0x0705, 0x0706, 0x0000},
//8
{0x0800, 0x0801, 0x0802, 0x0803, 0x0804, 0x0805, 0x0806, 0x0000},
//9
{0x0900, 0x0901, 0x0902, 0x0903, 0x0904, 0x0905, 0x0906, 0x0000},
//10
{0x0A00, 0x0A01, 0x0A02, 0x0A03, 0x0A04, 0x0A05, 0x0A06, 0x0000},
//11
{0x0B00, 0x0B01, 0x0B02, 0x0B03, 0x0B04, 0x0B05, 0x0B06, 0x0000},
//12
{0x0C00, 0x0C01, 0x0C02, 0x0C03, 0x0C04, 0x0C05, 0x0C06, 0x0000},
//13
{0x0D00, 0x0D01, 0x0D02, 0x0D03, 0x0D04, 0x0D05, 0x0D06, 0x0000},
//14
{0x0E00, 0x0E01, 0x0E02, 0x0E03, 0x0E04, 0x0E05, 0x0E06, 0x0000},
//15
{0x0F00, 0x0F01, 0x0F02, 0x0F03, 0x0F04, 0x0F05, 0x0F06, 0x0000}
};



static const int FIR_LANCZOS[FIR_VARIANTS][FIR_LENGTH] = {
//0
{  0,   0,     0, 16384,     0,     0,   0, 0},
//1
{  0, 190,  -772, 16267,   919,  -232,   7, 0},
//2
{  0, 335, -1391, 15921,  1975,  -501,  30, 0},
//3
{  0, 435, -1858, 15354,  3151,  -798,  68, 0},
//4
{  0, 492, -2177, 14583,  4427, -1111, 121, 0},
//5
{  0, 511, -2358, 13630,  5776, -1426, 184, 0},
//6
{  0, 497, -2413, 12521,  7170, -1728, 256, 0},
//7
{  0, 457, -2359, 11287,  8576, -1996, 329, 0},
//8
{  0, 398, -2213,  9960,  9960, -2213, 398, 0},
//9
{  0, 329, -1996,  8576, 11287, -2359, 457, 0},
//10
{  0, 256, -1728,  7170, 12521, -2413, 497, 0},
//11
{  0, 184, -1426,  5776, 13630, -2358, 511, 0},
//12
{  0, 121, -1111,  4427, 14583, -2177, 492, 0},
//13
{  0,  68,  -798,  3151, 15354, -1858, 435, 0},
//14
{  0,  30,  -501,  1975, 15921, -1391, 335, 0},
//15
{  0,   7,  -232,   919, 16267,  -772, 190, 0}

};



/**
 * Auxiliary function for dump of FIR filter coefficients.
 * @param fir_variants Number of variants of FIR filter
 * @param fir_length Length of FIR filter
 * @param fir 2D array of FIR filter self
 */
void print_fir(int fir_variants, int fir_length, const int fir[][fir_length]);

/* end of file FIR.h */

