#ifndef _VIDEOSEQUENCEDATA_H
#define _VIDEOSEQUENCEDATA_H


#include "KeyFrames.h"
#include "VideoSequence.h"


namespace vmatch {


class VideoSequenceData {
protected:
	static const std::string NODE_VIDEOSEQUENCE;
	static const std::string NODE_KEYFRAMES;
	static const std::string NODE_METADATA;
	static const std::string NODE_ADDITIONAL;

public:
	class Additional {
	public:
		Additional();
		virtual void read(cv::FileNode & nd);
		virtual void write(cv::FileStorage & fs) const;
	};

protected:
	KeyFrames keyFrames;
	VideoSequence::MetaData metaData;
	Additional additional;
	bool readOk;

	void init();

public:
	VideoSequenceData();
    VideoSequenceData(const KeyFrames keyFrames, const VideoSequence::MetaData metaData, const Additional additional = Additional());
	VideoSequenceData(const std::string & filename);
	void read(cv::FileNode & nd);
	void read(const std::string & filename);
	void write(cv::FileStorage & fs) const;
	void write(const std::string & filename) const;
	KeyFrames getKeyFrames() const;
	VideoSequence::MetaData getMetaData() const;
	Additional getAdditional() const;
};


typedef cv::Ptr<VideoSequenceData> VideoSequenceDataPtr;


}


#endif
