/*
								+---------------------------------+
								|                                 |
								|      ***   OpenGL2.0   ***      |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|           OpenGl20.cpp          |
								|                                 |
								+---------------------------------+
*/

/**
 *	@file gl2/OpenGl20.cpp
 *	@date 2005
 *	@author -tHE SWINe-
 *	@brief OpenGL 2.0
 *
 *	@date 2006-05-16
 *
 *	passed code revision
 *
 *	integers, contanining just true or false were changed to bool
 *
 *	@date 2006-07-15
 *
 *	passed code revision
 *
 *	some more integers, contanining just true or false were changed to bool
 *
 *	@date 2007-02-05
 *
 *	added support for GL_NV_fence extension
 *
 *	@date 2007-02-20
 *
 *	added support for following new (geForce8800 (or DX10)) extensions:
 *		- GL_ARB_occlusion_query
 *		- OpenGL 2.1
 *		- GL_EXT_timer_query
 *		- GL_EXT_draw_buffers2
 *		- GL_EXT_texture_integer
 *		- GL_EXT_gpu_shader4
 *		- GL_EXT_gpu_program_parameters
 *		- GL_EXT_bindable_uniform
 *		- GL_EXT_geometry_shader4
 *		- GL_EXT_draw_instanced
 *		- GL_EXT_texture_array
 *		- GL_EXT_texture_object
 *	removed outdated GL_EXT_texture_object extension (from 1995/10/03, promoted to core
 *	extension in OpenGL 1.1)
 *	removed dllexport attribute
 *
 *	@date 2007-10-29
 *
 *	added some documentation comments, clarified OpenGL 1.3 multitexture / ARB multitexture
 *	distinction and improved linux compatibility
 *
 *	@date 2007-11-10
 *
 *	improved linux compatibility
 *
 *	@date 2008-03-04
 *
 *	now using Integer.h header, hidden __stdcall into GLApi instead
 *	of defining __stdcall blank in linux
 *
 *	@date 2008-08-08
 *
 *	added \#ifdef for windows 64
 *
 *	@date 2008-08-19
 *
 *	gl.h is now included in OpenGL20.h (convenience)
 *
 *	@date 2009-05-03
 *
 *	added GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT enumerant
 *	(not defined in GL_EXT_packed_depth_stencil, nor in GL_EXT_framebuffer_object)
 *
 *	added CGLExtensionHandler::n_GetAllSupportedExtensionsFuncPointers()
 *
 *	@date 2009-05-04
 *
 *	fixed mixed windows / linux line endings
 *
 *	@date 2009-10-20
 *
 *	fixed some warnings when compiling under VC 2005, implemented "Security
 *	Enhancements in the CRT" for VC 2008. compare against MyProjects_2009-10-19_
 *
 */

#include "../NewFix.h"

#include "../CallStack.h"
#include <vector>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include "OpenGL20.h"

#if defined(_WIN32) || defined(_WIN64)
#include <windows.h>
#endif // _WIN32 || _WIN64
/*#define GL_GLEXT_LEGACY
#include <GL/gl.h>*/
#if defined(_WIN32) || defined(_WIN64)
#include <GL/wglext.h>
#else // _WIN32 || _WIN64
//#include "glxext.h"
// my glxext.h doesn't cope nicely with some unices; gotta get another version
#include <GL/glx.h>
#define glXGetProcAddress(x) (*glXGetProcAddressARB)((const GLubyte*)x)
#define wglGetProcAddress(x) (*glXGetProcAddress)((GLubyte*)(x))
#endif // _WIN32 || _WIN64

#ifdef NULL_FUNCTION_POINTERS
#define INIT_FUNC_POINTERS = 0
#else
#define INIT_FUNC_POINTERS 
#endif

/*
 *								=== CGLExtensionHandler ===
 */

/*
 *	static bool CGLExtensionHandler::b_Support_OpenGL(int n_min_major = 2, int n_min_minor = 0)
 *		- returns true in case OpenGL version  is greater or equal to n_min_major.n_min_minor
 *		- might return false on malformed OpenGL version string
 */
bool CGLExtensionHandler::b_Support_OpenGL(int n_min_major, int n_min_minor)
{
	__FuncGuard("CGLExtensionHandler::b_Support_OpenGL");

	int n_major = n_OpenGL_Version();
	int n_minor = n_major % 10;
	n_major /= 10;
	if(n_major > n_min_major)
		return true;
	if(n_major == n_min_major && n_minor >= n_min_minor)
		return true;
	return false;
}

/*
 *	static int CGLExtensionHandler::n_OpenGL_Version()
 *		- returns OpenGL version as major * 10 + minor (ie. for OpenGL 2.1 returns 21)
 */
int CGLExtensionHandler::n_OpenGL_Version()
{
	__FuncGuard("CGLExtensionHandler::n_OpenGL_Version");

	const char *p_s_version;
	int n_major, n_minor;

	p_s_version = (const char*)glGetString(GL_VERSION);
	if(!p_s_version) {
#if defined(_WIN32) || defined(_WIN64)
		MessageBoxA(0, "OpenGL extension string is 0!", "CGLExtensionHandler", MB_OK);
#endif
		return -1;
	}

#if defined(_MSC_VER) && !defined(__MWERKS__) && _MSC_VER >= 1400
	if(sscanf_s(p_s_version, "%d.%d", &n_major, &n_minor) != 2) {
#else // _MSC_VER && !__MWERKS__ && _MSC_VER >= 1400
	if(sscanf(p_s_version, "%d.%d", &n_major, &n_minor) != 2) {
#endif // _MSC_VER && !__MWERKS__ && _MSC_VER >= 1400
#if defined(_WIN32) || defined(_WIN64)
		MessageBoxA(0, "OpenGL version string malformed!", "CGLExtensionHandler", MB_OK);
#endif
		_ASSERTE(0); // error - OpenGL version string malformed!
		return -1;
	}
	_ASSERTE(n_minor >= 0 && n_minor < 10);

	return n_major * 10 + n_minor;
}

/*
 *	static bool CGLExtensionHandler::b_SupportedExtension(const char *p_s_extension_name)
 *		- returns true in case p_s_extension_name is supported, otherwise false
 *		- requires space in extension string before and after the extension name
 *		  (except on beginning / end of the string)
 */
bool CGLExtensionHandler::b_SupportedExtension(const char *p_s_extension_name)
{
	__FuncGuard("CGLExtensionHandler::b_SupportedExtension");

	const char *p_s_extensions, *p_s_search_str;

	p_s_extensions = (const char*)glGetString(GL_EXTENSIONS);
	_ASSERTE(p_s_extensions);
	p_s_search_str = p_s_extensions;

	do {
		if((p_s_search_str = strstr(p_s_search_str, p_s_extension_name))) {
			if(p_s_search_str > p_s_extensions && !isspace(*(p_s_search_str - 1)))
				continue;
			if(strlen(p_s_search_str + strlen(p_s_extension_name)) &&
			   !isspace(*(p_s_search_str + strlen(p_s_extension_name))))
				continue;

			return true;
		}
	} while(p_s_search_str && strlen(++ p_s_search_str));

	return false;
}

#if defined(_WIN32) || defined(_WIN64)

/*
 *	static bool CGLExtensionHandler::b_SupportedWGLExtension(const char *p_s_extension_name)
 *		- returns true in case WGL extension p_s_extension_name is supported, otherwise false
 *		- requires space in extension string before and after the extension name
 *		  (except on beginning / end of the string)
 */
bool CGLExtensionHandler::b_SupportedWGLExtension(const char *p_s_extension_name)
{
	__FuncGuard("CGLExtensionHandler::b_SupportedWGLExtension");

	const char *p_s_extensions, *p_s_search_str;

	PFNWGLGETEXTENSIONSSTRINGARBPROC wglGetExtensionsStringARB;
	if(!(wglGetExtensionsStringARB = (PFNWGLGETEXTENSIONSSTRINGARBPROC)wglGetProcAddress("wglGetExtensionsStringARB")))
		return false;

	p_s_extensions = (const char*)wglGetExtensionsStringARB(wglGetCurrentDC());
	p_s_search_str = p_s_extensions;

	do {
		if((p_s_search_str = strstr(p_s_search_str, p_s_extension_name))) {
			if(p_s_search_str > p_s_extensions && !isspace(*(p_s_search_str - 1)))
				continue;
			if(strlen(p_s_search_str + strlen(p_s_extension_name)) &&
			   !isspace(*(p_s_search_str + strlen(p_s_extension_name))))
				continue;

			return true;
		}
	} while(p_s_search_str && strlen(++ p_s_search_str));

	return false;
}

#endif

/*
 *	static int CGLExtensionHandler::n_GetAllSupportedExtensionsFuncPointers()
 *		- gets function pointers for all supported extensions and OpenGL versions
 *		- returns number of missing functions
 *		- note this is aimed at simple and test implementations without
 *		  much need for error checking. it is always better to call individual
 *		  functions, because in case this fails, there's no telling
 *		  which extension exactly failed to initialize
 */
int CGLExtensionHandler::n_GetAllSupportedExtensionsFuncPointers()
{
	return n_GetGL12FuncPointers() +
		n_GetGL13FuncPointers() +
		((n_GetMultitextureFuncPointers())? n_GetMultitextureARBFuncPointers() : 0) + // fallback to ARB_multitexture
		n_GetGL14FuncPointers() +
		n_GetGL15FuncPointers() +
		n_GetGL20FuncPointers() +
		n_GetGL21FuncPointers() +
		//n_GetCompressedTextureARBFuncPointers() + // n_GetTextureCompressionARBFuncPointers()
		n_GetVertexBlendARBFuncPointers() +
		n_GetMatrixPaletteARBFuncPointers() +
		n_GetFramebufferObjectEXTFuncPointers() +
		//n_GetCompiledArrayEXTFuncPointers() +
		n_GetColorBufferFloatARBFuncPointers() +
		n_GetVertexProgramARBFuncPointers() +
		n_GetFragmentProgramARBFuncPointers() +
		n_GetVertexShaderARBFuncPointers() +
		n_GetFragmentShaderARBFuncPointers() +
		//n_GetShaderObjectARBFuncPointers() + // n_GetShaderObjectsARBFuncPointers()
		n_GetVertexBufferObjectARBFuncPointers() +
		n_GetFenceNVFuncPointers() +
		n_GetOcclusionQueryARBFuncPointers() +
		n_GetTimerQueryEXTFuncPointers() +
		n_GetDrawBuffers2EXTFuncPointers() +
		n_GetTextureIntegerEXTFuncPointers() +
		n_GetGPUShader4EXTFuncPointers() +
		n_GetGPUProgramParametersEXTFuncPointers() +
		n_GetBindableUniformEXTFuncPointers() +
		n_GetGeometryShader4EXTFuncPointers() +
		n_GetDrawInstancedEXTFuncPointers() +
		n_GetTextureArrayEXTFuncPointers() + 
		n_GetTextureObjectEXTFuncPointers() +
		n_GetBlendMinMaxEXTFuncPointers() +
		n_GetCopyBufferARBFuncPointers() +
		n_GetDepthBufferFloatARBFuncPointers() +
		n_GetDepthClampARBFuncPointers() +
		n_GetDepthTextureARBFuncPointers() +
		n_GetDrawBuffersARBFuncPointers() +
		n_GetDrawElementsBaseVertexARBFuncPointers() +
		n_GetDrawInstancedARBFuncPointers() +
		n_GetFragmentCoordConventionsARBFuncPointers() +
		n_GetFragmentProgramShadowARBFuncPointers() +
		n_GetFramebufferObjectARBFuncPointers() +
		n_GetFramebufferSRGBARBFuncPointers() +
		n_GetGeometryShader4ARBFuncPointers() +
		n_GetHalfFloatPixelARBFuncPointers() +
		n_GetHalfFloatVertexARBFuncPointers() +
		n_GetMapBufferRangeARBFuncPointers() +
		n_GetMultisampleARBFuncPointers() +
		n_GetPixelBufferObjectARBFuncPointers() +
		n_GetPointParametersARBFuncPointers() +
		n_GetPointSpriteARBFuncPointers() +
		n_GetProvokingVertexARBFuncPointers() +
		n_GetSeamlessCubeMapARBFuncPointers() +
		n_GetShaderObjectsARBFuncPointers() +
		n_GetShadingLanguage100ARBFuncPointers() +
		n_GetShadowARBFuncPointers() +
		n_GetSyncARBFuncPointers() +
		n_GetTextureCompressionARBFuncPointers() +
		n_GetTextureBufferObjectARBFuncPointers() +
		n_GetTextureMultisampleARBFuncPointers() +
		n_GetTransposeMatrixARBFuncPointers() +
		n_GetUniformBufferObjectARBFuncPointers() +
		n_GetVertexArrayObjectARBFuncPointers() +
		n_GetWindowPosARBFuncPointers() +
		n_GetDrawBuffersATIFuncPointers() +
		n_GetBlendColorEXTFuncPointers() +
		n_GetBlendEquationSeparateEXTFuncPointers() +
		n_GetBlendFuncSeparateEXTFuncPointers() +
		//n_GetBlendMinmaxEXTFuncPointers() +
		n_GetDepthBoundsTestEXTFuncPointers() +
		n_GetDirectStateAccessEXTFuncPointers() +
		n_GetFogCoordEXTFuncPointers() +
		n_GetFramebufferBlitEXTFuncPointers() +
		n_GetFramebufferMultisampleEXTFuncPointers() +
		//n_GetGpuProgramParametersEXTFuncPointers() +
		//n_GetGpuShader4EXTFuncPointers() +
		n_GetMultiDrawArraysEXTFuncPointers() +
		n_GetPointParametersEXTFuncPointers() +
		n_GetProvokingVertexEXTFuncPointers() +
		n_GetSecondaryColorEXTFuncPointers() +
		n_GetSeparateShaderObjectsEXTFuncPointers() +
		n_GetStencilTwoSideEXTFuncPointers() +
		n_GetTexture3DEXTFuncPointers() +
		n_GetTextureBufferObjectEXTFuncPointers() +
		n_GetVertexArrayEXTFuncPointers() +
		n_GetConditionalRenderNVFuncPointers() +
		n_GetCopyImageNVFuncPointers() +
		n_GetDepthBufferFloatNVFuncPointers() +
		n_GetExplicitMultisampleNVFuncPointers() +
		n_GetFragmentProgramNVFuncPointers() +
		n_GetFramebufferMultisampleCoverageNVFuncPointers() +
		n_GetGpuProgram4NVFuncPointers() +
		n_GetHalfFloatNVFuncPointers() +
		n_GetOcclusionQueryNVFuncPointers() +
		n_GetParameterBufferObjectNVFuncPointers() +
		n_GetPixelDataRangeNVFuncPointers() +
		n_GetPointSpriteNVFuncPointers() +
		n_GetPrimitiveRestartNVFuncPointers() +
		n_GetRegisterCombinersNVFuncPointers() +
		n_GetRegisterCombiners2NVFuncPointers() +
		n_GetShaderBufferLoadNVFuncPointers() +
		n_GetTextureBarrierNVFuncPointers() +
		n_GetTransformFeedbackNVFuncPointers() +
		n_GetTransformFeedback2NVFuncPointers() +
		n_GetVertexArrayRangeNVFuncPointers() +
		n_GetVertexBufferUnifiedMemoryNVFuncPointers() +
		n_GetVertexProgramNVFuncPointers() +
		
		n_GetTextureBorderClampARBFuncPointers() +
		n_GetTextureCompressionRgtcARBFuncPointers() +
		n_GetTextureCubeMapARBFuncPointers() +
		n_GetTextureEnvAddARBFuncPointers() +
		n_GetTextureEnvCombineARBFuncPointers() +
		n_GetTextureEnvDot3ARBFuncPointers() +
		n_GetTextureFloatARBFuncPointers() +
		n_GetTextureMirroredRepeatARBFuncPointers() +
		n_GetTextureNonPowerOfTwoARBFuncPointers() +
		n_GetTextureRectangleARBFuncPointers() +
		n_GetTextureRgARBFuncPointers() +
		n_GetVertexArrayBgraARBFuncPointers() +
		n_GetTextureFloatATIFuncPointers() +
		n_GetTextureMirrorOnceATIFuncPointers() +
		n_GetS3tcS3FuncPointers() +
		n_GetTextureEnvAddEXTFuncPointers() +
		n_GetAbgrEXTFuncPointers() +
		n_GetBgraEXTFuncPointers() +
		n_GetBlendSubtractEXTFuncPointers() +
		n_GetFramebufferSRGBEXTFuncPointers() +
		n_GetPackedDepthStencilEXTFuncPointers() +
		n_GetPackedFloatEXTFuncPointers() +
		n_GetPackedPixelsEXTFuncPointers() +
		n_GetPixelBufferObjectEXTFuncPointers() +
		n_GetRescaleNormalEXTFuncPointers() +
		n_GetSeparateSpecularColorEXTFuncPointers() +
		n_GetShadowFuncsEXTFuncPointers() +
		n_GetStencilWrapEXTFuncPointers() +
		n_GetTextureCompressionLatcEXTFuncPointers() +
		n_GetTextureCompressionRgtcEXTFuncPointers() +
		n_GetTextureCompressionS3tcEXTFuncPointers() +
		n_GetTextureEnvCombineEXTFuncPointers() +
		n_GetTextureEnvDot3EXTFuncPointers() +
		n_GetTextureFilterAnisotropicEXTFuncPointers() +
		n_GetTextureLodBiasEXTFuncPointers() +
		n_GetTextureMirrorClampEXTFuncPointers() +
		n_GetTextureSharedExponentEXTFuncPointers() +
		n_GetTextureSRGBEXTFuncPointers() +
		n_GetTextureSwizzleEXTFuncPointers() +
		n_GetVertexArrayBgraEXTFuncPointers() +
		n_GetRasterposClipIBMFuncPointers() +
		n_GetTextureMirroredRepeatIBMFuncPointers() +
		n_GetBlendSquareNVFuncPointers() +
		n_GetCopyDepthToColorNVFuncPointers() +
		n_GetDepthClampNVFuncPointers() +
		n_GetFloatBufferNVFuncPointers() +
		n_GetFogDistanceNVFuncPointers() +
		n_GetFragmentProgramOptionNVFuncPointers() +
		n_GetFragmentProgram2NVFuncPointers() +
		n_GetGeometryShader4NVFuncPointers() +
		n_GetLightMaxExponentNVFuncPointers() +
		n_GetMultisampleFilterHintNVFuncPointers() +
		n_GetPackedDepthStencilNVFuncPointers() +
		n_GetParameterBufferObject2NVFuncPointers() +
		n_GetTexgenReflectionNVFuncPointers() +
		n_GetTextureCompressionVtcNVFuncPointers() +
		n_GetTextureEnvCombine4NVFuncPointers() +
		n_GetTextureExpandNormalNVFuncPointers() +
		n_GetTextureRectangleNVFuncPointers() +
		n_GetTextureShaderNVFuncPointers() +
		n_GetTextureShader2NVFuncPointers() +
		n_GetTextureShader3NVFuncPointers() +
		n_GetVertexArrayRange2NVFuncPointers() +
		n_GetVertexProgram11NVFuncPointers() +
		n_GetVertexProgram2NVFuncPointers() +
		n_GetVertexProgram2OptionNVFuncPointers() +
		n_GetVertexProgram3NVFuncPointers() +
		n_GetGenerateMipmapSGISFuncPointers() +
		n_GetTextureLodSGISFuncPointers() +
		n_GetDepthTextureSGIXFuncPointers() +
		n_GetShadowSGIXFuncPointers() +
		n_GetSliceAccumSUNFuncPointers();
}

/*
 *		--- opengl 1.2 core func pointers ---
 */

#ifdef __GENERATE_GL_12__

void (GLApi *glBlendColor)(GLclampf, GLclampf, GLclampf, GLclampf) INIT_FUNC_POINTERS;
void (GLApi *glBlendEquation)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glDrawRangeElements)(GLenum, GLuint, GLuint, GLsizei, GLenum, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glColorTable)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glColorTableParameterfv)(GLenum, GLenum, const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glColorTableParameteriv)(GLenum, GLenum, const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glCopyColorTable)(GLenum, GLenum, GLint, GLint, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glGetColorTable)(GLenum, GLenum, GLenum, GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glGetColorTableParameterfv)(GLenum, GLenum, GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glGetColorTableParameteriv)(GLenum, GLenum, GLint*) INIT_FUNC_POINTERS;
void (GLApi *glColorSubTable)(GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glCopyColorSubTable)(GLenum, GLsizei, GLint, GLint, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glConvolutionFilter1D)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glConvolutionFilter2D)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glConvolutionParameterf)(GLenum, GLenum, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glConvolutionParameterfv)(GLenum, GLenum, const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glConvolutionParameteri)(GLenum, GLenum, GLint) INIT_FUNC_POINTERS;
void (GLApi *glConvolutionParameteriv)(GLenum, GLenum, const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glCopyConvolutionFilter1D)(GLenum, GLenum, GLint, GLint, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glCopyConvolutionFilter2D)(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glGetConvolutionFilter)(GLenum, GLenum, GLenum, GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glGetConvolutionParameterfv)(GLenum, GLenum, GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glGetConvolutionParameteriv)(GLenum, GLenum, GLint*) INIT_FUNC_POINTERS;
void (GLApi *glGetSeparableFilter)(GLenum, GLenum, GLenum, GLvoid *, GLvoid *, GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glSeparableFilter2D)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glGetHistogram)(GLenum, GLboolean, GLenum, GLenum, GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glGetHistogramParameterfv)(GLenum, GLenum, GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glGetHistogramParameteriv)(GLenum, GLenum, GLint*) INIT_FUNC_POINTERS;
void (GLApi *glGetMinmax)(GLenum, GLboolean, GLenum, GLenum, GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glGetMinmaxParameterfv)(GLenum, GLenum, GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glGetMinmaxParameteriv)(GLenum, GLenum, GLint*) INIT_FUNC_POINTERS;
void (GLApi *glHistogram)(GLenum, GLsizei, GLenum, GLboolean) INIT_FUNC_POINTERS;
void (GLApi *glMinmax)(GLenum, GLenum, GLboolean) INIT_FUNC_POINTERS;
void (GLApi *glResetHistogram)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glResetMinmax)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glTexImage3D)(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glCopyTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_12__

/*
 *	static int CGLExtensionHandler::n_GetGL12FuncPointers()
 *		- gets OpenGL 1.2 core function pointers
 *		- returns number of missing functions
 */
int CGLExtensionHandler::n_GetGL12FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL12FuncPointers");

	int n_failed_functions = 0;

#ifdef __GENERATE_GL_12__

	if(!(glBlendColor = (void(GLApi*)(GLclampf, GLclampf, GLclampf, GLclampf))wglGetProcAddress("glBlendColor"))) ++ n_failed_functions;
	if(!(glBlendEquation = (void(GLApi*)(GLenum))wglGetProcAddress("glBlendEquation"))) ++ n_failed_functions;
	if(!(glDrawRangeElements = (void(GLApi*)(GLenum, GLuint, GLuint, GLsizei, GLenum, const GLvoid*))wglGetProcAddress("glDrawRangeElements"))) ++ n_failed_functions;
	if(!(glColorTable = (void(GLApi*)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glColorTable"))) ++ n_failed_functions;
	if(!(glColorTableParameterfv = (void(GLApi*)(GLenum, GLenum, const GLfloat*))wglGetProcAddress("glColorTableParameterfv"))) ++ n_failed_functions;
	if(!(glColorTableParameteriv = (void(GLApi*)(GLenum, GLenum, const GLint*))wglGetProcAddress("glColorTableParameteriv"))) ++ n_failed_functions;
	if(!(glCopyColorTable = (void(GLApi*)(GLenum, GLenum, GLint, GLint, GLsizei))wglGetProcAddress("glCopyColorTable"))) ++ n_failed_functions;
	if(!(glGetColorTable = (void(GLApi*)(GLenum, GLenum, GLenum, GLvoid*))wglGetProcAddress("glGetColorTable"))) ++ n_failed_functions;
	if(!(glGetColorTableParameterfv = (void(GLApi*)(GLenum, GLenum, GLfloat*))wglGetProcAddress("glGetColorTableParameterfv"))) ++ n_failed_functions;
	if(!(glGetColorTableParameteriv = (void(GLApi*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetColorTableParameteriv"))) ++ n_failed_functions;
	if(!(glColorSubTable = (void(GLApi*)(GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glColorSubTable"))) ++ n_failed_functions;
	if(!(glCopyColorSubTable = (void(GLApi*)(GLenum, GLsizei, GLint, GLint, GLsizei))wglGetProcAddress("glCopyColorSubTable"))) ++ n_failed_functions;
	if(!(glConvolutionFilter1D = (void(GLApi*)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glConvolutionFilter1D"))) ++ n_failed_functions;
	if(!(glConvolutionFilter2D = (void(GLApi*)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glConvolutionFilter2D"))) ++ n_failed_functions;
	if(!(glConvolutionParameterf = (void(GLApi*)(GLenum, GLenum, GLfloat))wglGetProcAddress("glConvolutionParameterf"))) ++ n_failed_functions;
	if(!(glConvolutionParameterfv = (void(GLApi*)(GLenum, GLenum, const GLfloat*))wglGetProcAddress("glConvolutionParameterfv"))) ++ n_failed_functions;
	if(!(glConvolutionParameteri = (void(GLApi*)(GLenum, GLenum, GLint))wglGetProcAddress("glConvolutionParameteri"))) ++ n_failed_functions;
	if(!(glConvolutionParameteriv = (void(GLApi*)(GLenum, GLenum, const GLint*))wglGetProcAddress("glConvolutionParameteriv"))) ++ n_failed_functions;
	if(!(glCopyConvolutionFilter1D = (void(GLApi*)(GLenum, GLenum, GLint, GLint, GLsizei))wglGetProcAddress("glCopyConvolutionFilter1D"))) ++ n_failed_functions;
	if(!(glCopyConvolutionFilter2D = (void(GLApi*)(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei))wglGetProcAddress("glCopyConvolutionFilter2D"))) ++ n_failed_functions;
	if(!(glGetConvolutionFilter = (void(GLApi*)(GLenum, GLenum, GLenum, GLvoid*))wglGetProcAddress("glGetConvolutionFilter"))) ++ n_failed_functions;
	if(!(glGetConvolutionParameterfv = (void(GLApi*)(GLenum, GLenum, GLfloat*))wglGetProcAddress("glGetConvolutionParameterfv"))) ++ n_failed_functions;
	if(!(glGetConvolutionParameteriv = (void(GLApi*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetConvolutionParameteriv"))) ++ n_failed_functions;
	if(!(glGetSeparableFilter = (void(GLApi*)(GLenum, GLenum, GLenum, GLvoid *, GLvoid *, GLvoid*))wglGetProcAddress("glGetSeparableFilter"))) ++ n_failed_functions;
	if(!(glSeparableFilter2D = (void(GLApi*)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, const GLvoid*))wglGetProcAddress("glSeparableFilter2D"))) ++ n_failed_functions;
	if(!(glGetHistogram = (void(GLApi*)(GLenum, GLboolean, GLenum, GLenum, GLvoid*))wglGetProcAddress("glGetHistogram"))) ++ n_failed_functions;
	if(!(glGetHistogramParameterfv = (void(GLApi*)(GLenum, GLenum, GLfloat*))wglGetProcAddress("glGetHistogramParameterfv"))) ++ n_failed_functions;
	if(!(glGetHistogramParameteriv = (void(GLApi*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetHistogramParameteriv"))) ++ n_failed_functions;
	if(!(glGetMinmax = (void(GLApi*)(GLenum, GLboolean, GLenum, GLenum, GLvoid*))wglGetProcAddress("glGetMinmax"))) ++ n_failed_functions;
	if(!(glGetMinmaxParameterfv = (void(GLApi*)(GLenum, GLenum, GLfloat*))wglGetProcAddress("glGetMinmaxParameterfv"))) ++ n_failed_functions;
	if(!(glGetMinmaxParameteriv = (void(GLApi*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetMinmaxParameteriv"))) ++ n_failed_functions;
	if(!(glHistogram = (void(GLApi*)(GLenum, GLsizei, GLenum, GLboolean))wglGetProcAddress("glHistogram"))) ++ n_failed_functions;
	if(!(glMinmax = (void(GLApi*)(GLenum, GLenum, GLboolean))wglGetProcAddress("glMinmax"))) ++ n_failed_functions;
	if(!(glResetHistogram = (void(GLApi*)(GLenum))wglGetProcAddress("glResetHistogram"))) ++ n_failed_functions;
	if(!(glResetMinmax = (void(GLApi*)(GLenum))wglGetProcAddress("glResetMinmax"))) ++ n_failed_functions;
	if(!(glTexImage3D = (void(GLApi*)(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glTexImage3D"))) ++ n_failed_functions;
	if(!(glTexSubImage3D = (void(GLApi*)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glTexSubImage3D"))) ++ n_failed_functions;
	if(!(glCopyTexSubImage3D = (void(GLApi*)(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei))wglGetProcAddress("glCopyTexSubImage3D"))) ++ n_failed_functions;

#endif // __GENERATE_GL_12__

	return n_failed_functions;
}

/*
 *		--- opengl 1.3 core func pointers ---
 */

#ifdef __GENERATE_GL_13__

void (GLApi *glLoadTransposeMatrixf)(const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glLoadTransposeMatrixd)(const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glMultTransposeMatrixf)(const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glMultTransposeMatrixd)(const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glSampleCoverage)(GLclampf, GLboolean) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexImage3D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexImage2D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexImage1D)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexSubImage2D)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexSubImage1D)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glGetCompressedTexImage)(GLenum, GLint, GLvoid*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_13__

/*
 *	static int CGLExtensionHandler::n_GetGL13FuncPointers()
 *		- gets OpenGL 1.3 core function pointers (including multitexture function pointers)
 *		- returns number of missing functions
 */
int CGLExtensionHandler::n_GetGL13FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL13FuncPointers");

	int n_failed_functions = 0;

#ifdef __GENERATE_GL_13__

	if(!(glLoadTransposeMatrixf = (void(GLApi*)(const GLfloat*))wglGetProcAddress("glLoadTransposeMatrixf"))) ++ n_failed_functions;
	if(!(glLoadTransposeMatrixd = (void(GLApi*)(const GLdouble*))wglGetProcAddress("glLoadTransposeMatrixd"))) ++ n_failed_functions;
	if(!(glMultTransposeMatrixf = (void(GLApi*)(const GLfloat*))wglGetProcAddress("glMultTransposeMatrixf"))) ++ n_failed_functions;
	if(!(glMultTransposeMatrixd = (void(GLApi*)(const GLdouble*))wglGetProcAddress("glMultTransposeMatrixd"))) ++ n_failed_functions;
	if(!(glSampleCoverage = (void(GLApi*)(GLclampf, GLboolean))wglGetProcAddress("glSampleCoverage"))) ++ n_failed_functions;
	if(!(glCompressedTexImage3D = (void(GLApi*)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage3D"))) ++ n_failed_functions;
	if(!(glCompressedTexImage2D = (void(GLApi*)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage2D"))) ++ n_failed_functions;
	if(!(glCompressedTexImage1D = (void(GLApi*)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage1D"))) ++ n_failed_functions;
	if(!(glCompressedTexSubImage3D = (void(GLApi*)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage3D"))) ++ n_failed_functions;
	if(!(glCompressedTexSubImage2D = (void(GLApi*)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage2D"))) ++ n_failed_functions;
	if(!(glCompressedTexSubImage1D = (void(GLApi*)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage1D"))) ++ n_failed_functions;
	if(!(glGetCompressedTexImage = (void(GLApi*)(GLenum, GLint, GLvoid*))wglGetProcAddress("glGetCompressedTexImage"))) ++ n_failed_functions;

#endif // __GENERATE_GL_13__

	return n_failed_functions + n_GetMultitextureFuncPointers();
}

/*
 *		--- Multitexture func pointers ---
 */

#ifdef __GENERATE_GL_13__

void (GLApi *glActiveTexture)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glClientActiveTexture)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1d)(GLenum, GLdouble) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1dv)(GLenum, const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1f)(GLenum, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1fv)(GLenum, const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1i)(GLenum, GLint) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1iv)(GLenum, const GLint *) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1s)(GLenum, GLshort) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1sv)(GLenum, const GLshort*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2d)(GLenum, GLdouble, GLdouble) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2dv)(GLenum, const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2f)(GLenum, GLfloat, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2fv)(GLenum, const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2i)(GLenum, GLint, GLint) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2iv)(GLenum, const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2s)(GLenum, GLshort, GLshort) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2sv)(GLenum, const GLshort*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3d)(GLenum, GLdouble, GLdouble, GLdouble) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3dv)(GLenum, const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3f)(GLenum, GLfloat, GLfloat, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3fv)(GLenum, const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3i)(GLenum, GLint, GLint, GLint) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3iv)(GLenum, const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3s)(GLenum, GLshort, GLshort, GLshort) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3sv)(GLenum, const GLshort*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4d)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4dv)(GLenum, const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4f)(GLenum, GLfloat, GLfloat, GLfloat, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4fv)(GLenum, const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4i)(GLenum, GLint, GLint, GLint, GLint) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4iv)(GLenum, const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4s)(GLenum, GLshort, GLshort, GLshort, GLshort) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4sv)(GLenum, const GLshort*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_13__

/*
 *	static int CGLExtensionHandler::n_GetMultitextureFuncPointers()
 *		- gets OpenGL 1.3 multitexture function pointers
 *		- returns number of missing functions
 */
int CGLExtensionHandler::n_GetMultitextureFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetMultitextureFuncPointers");

	int n_failed_functions = 0;

#ifdef __GENERATE_GL_13__

	if(!(glActiveTexture = (void(GLApi*)(GLenum))wglGetProcAddress("glActiveTexture"))) ++ n_failed_functions;
	if(!(glClientActiveTexture = (void(GLApi*)(GLenum))wglGetProcAddress("glClientActiveTexture"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1d = (void(GLApi*)(GLenum, GLdouble))wglGetProcAddress("glMultiTexCoord1d"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1dv = (void(GLApi*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord1dv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1f = (void(GLApi*)(GLenum, GLfloat))wglGetProcAddress("glMultiTexCoord1f"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1fv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord1fv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1i = (void(GLApi*)(GLenum, GLint))wglGetProcAddress("glMultiTexCoord1i"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1iv = (void(GLApi*)(GLenum, const GLint *))wglGetProcAddress("glMultiTexCoord1iv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1s = (void(GLApi*)(GLenum, GLshort))wglGetProcAddress("glMultiTexCoord1s"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1sv = (void(GLApi*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord1sv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2d = (void(GLApi*)(GLenum, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord2d"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2dv = (void(GLApi*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord2dv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2f = (void(GLApi*)(GLenum, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord2f"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2fv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord2fv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2i = (void(GLApi*)(GLenum, GLint, GLint))wglGetProcAddress("glMultiTexCoord2i"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2iv = (void(GLApi*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord2iv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2s = (void(GLApi*)(GLenum, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord2s"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2sv = (void(GLApi*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord2sv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3d = (void(GLApi*)(GLenum, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord3d"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3dv = (void(GLApi*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord3dv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3f = (void(GLApi*)(GLenum, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord3f"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3fv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord3fv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3i = (void(GLApi*)(GLenum, GLint, GLint, GLint))wglGetProcAddress("glMultiTexCoord3i"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3iv = (void(GLApi*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord3iv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3s = (void(GLApi*)(GLenum, GLshort, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord3s"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3sv = (void(GLApi*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord3sv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4d = (void(GLApi*)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord4d"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4dv = (void(GLApi*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord4dv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4f = (void(GLApi*)(GLenum, GLfloat, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord4f"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4fv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord4fv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4i = (void(GLApi*)(GLenum, GLint, GLint, GLint, GLint))wglGetProcAddress("glMultiTexCoord4i"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4iv = (void(GLApi*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord4iv"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4s = (void(GLApi*)(GLenum, GLshort, GLshort, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord4s"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4sv = (void(GLApi*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord4sv"))) ++ n_failed_functions;

#endif // __GENERATE_GL_13__

	return n_failed_functions;
}

/*
 *	static int CGLExtensionHandler::n_GetMultitextureARBFuncPointers()
 *		- gets GL_ARB_multitexture function pointers
 *		- note function names are ones of OpenGL 1.3 multitexture, no ARB suffix here
 *		- returns number of missing functions
 */
int CGLExtensionHandler::n_GetMultitextureARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetMultitextureARBFuncPointers");

	int n_failed_functions = 0;

#ifdef __GENERATE_GL_13__

	if(!(glActiveTexture = (void(GLApi*)(GLenum))wglGetProcAddress("glActiveTextureARB"))) ++ n_failed_functions;
	if(!(glClientActiveTexture = (void(GLApi*)(GLenum))wglGetProcAddress("glClientActiveTextureARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1d = (void(GLApi*)(GLenum, GLdouble))wglGetProcAddress("glMultiTexCoord1dARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1dv = (void(GLApi*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord1dvARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1f = (void(GLApi*)(GLenum, GLfloat))wglGetProcAddress("glMultiTexCoord1fARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1fv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord1fvARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1i = (void(GLApi*)(GLenum, GLint))wglGetProcAddress("glMultiTexCoord1iARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1iv = (void(GLApi*)(GLenum, const GLint *))wglGetProcAddress("glMultiTexCoord1ivARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1s = (void(GLApi*)(GLenum, GLshort))wglGetProcAddress("glMultiTexCoord1sARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1sv = (void(GLApi*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord1svARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2d = (void(GLApi*)(GLenum, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord2dARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2dv = (void(GLApi*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord2dvARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2f = (void(GLApi*)(GLenum, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord2fARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2fv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord2fvARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2i = (void(GLApi*)(GLenum, GLint, GLint))wglGetProcAddress("glMultiTexCoord2iARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2iv = (void(GLApi*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord2ivARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2s = (void(GLApi*)(GLenum, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord2sARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2sv = (void(GLApi*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord2svARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3d = (void(GLApi*)(GLenum, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord3dARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3dv = (void(GLApi*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord3dvARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3f = (void(GLApi*)(GLenum, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord3fARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3fv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord3fvARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3i = (void(GLApi*)(GLenum, GLint, GLint, GLint))wglGetProcAddress("glMultiTexCoord3iARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3iv = (void(GLApi*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord3ivARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3s = (void(GLApi*)(GLenum, GLshort, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord3sARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3sv = (void(GLApi*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord3svARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4d = (void(GLApi*)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord4dARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4dv = (void(GLApi*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord4dvARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4f = (void(GLApi*)(GLenum, GLfloat, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord4fARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4fv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord4fvARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4i = (void(GLApi*)(GLenum, GLint, GLint, GLint, GLint))wglGetProcAddress("glMultiTexCoord4iARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4iv = (void(GLApi*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord4ivARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4s = (void(GLApi*)(GLenum, GLshort, GLshort, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord4sARB"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4sv = (void(GLApi*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord4svARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_13__

	return n_failed_functions;
}

/*
 *		--- opengl 1.4 core func pointers ---
 */

#ifdef __GENERATE_GL_14__

void (GLApi *glBlendFuncSeparate)(GLenum, GLenum, GLenum, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordf)(GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordfv)(const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordd)(GLdouble) INIT_FUNC_POINTERS;
void (GLApi *glFogCoorddv)(const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordPointer)(GLenum, GLsizei, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glMultiDrawArrays)(GLenum, GLint *, GLsizei *, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glMultiDrawElements)(GLenum, const GLsizei *, GLenum, const GLvoid* *, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glPointParameterf)(GLenum, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glPointParameterfv)(GLenum, const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glPointParameteri)(GLenum, GLint) INIT_FUNC_POINTERS;
void (GLApi *glPointParameteriv)(GLenum, const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3b)(GLbyte, GLbyte, GLbyte) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3bv)(const GLbyte*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3d)(GLdouble, GLdouble, GLdouble) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3dv)(const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3f)(GLfloat, GLfloat, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3fv)(const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3i)(GLint, GLint, GLint) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3iv)(const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3s)(GLshort, GLshort, GLshort) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3sv)(const GLshort*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3ub)(GLubyte, GLubyte, GLubyte) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3ubv)(const GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3ui)(GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3uiv)(const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3us)(GLushort, GLushort, GLushort) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3usv)(const GLushort*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColorPointer)(GLint, GLenum, GLsizei, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2d)(GLdouble, GLdouble) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2dv)(const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2f)(GLfloat, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2fv)(const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2i)(GLint, GLint) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2iv)(const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2s)(GLshort, GLshort) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2sv)(const GLshort*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3d)(GLdouble, GLdouble, GLdouble) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3dv)(const GLdouble*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3f)(GLfloat, GLfloat, GLfloat) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3fv)(const GLfloat*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3i)(GLint, GLint, GLint) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3iv)(const GLint*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3s)(GLshort, GLshort, GLshort) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3sv)(const GLshort*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_14__

/*
 *	static int CGLExtensionHandler::n_GetGL14FuncPointers()
 *		- gets OpenGL 1.4 core function pointers
 *		- returns number of missing functions
 */
int CGLExtensionHandler::n_GetGL14FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL14FuncPointers");

	int n_failed_functions = 0;

#ifdef __GENERATE_GL_14__

	if(!(glBlendFuncSeparate = (void(GLApi*)(GLenum, GLenum, GLenum, GLenum))wglGetProcAddress("glBlendFuncSeparate"))) ++ n_failed_functions;
	if(!(glFogCoordf = (void(GLApi*)(GLfloat))wglGetProcAddress("glFogCoordf"))) ++ n_failed_functions;
	if(!(glFogCoordfv = (void(GLApi*)(const GLfloat*))wglGetProcAddress("glFogCoordfv"))) ++ n_failed_functions;
	if(!(glFogCoordd = (void(GLApi*)(GLdouble))wglGetProcAddress("glFogCoordd"))) ++ n_failed_functions;
	if(!(glFogCoorddv = (void(GLApi*)(const GLdouble*))wglGetProcAddress("glFogCoorddv"))) ++ n_failed_functions;
	if(!(glFogCoordPointer = (void(GLApi*)(GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glFogCoordPointer"))) ++ n_failed_functions;
	if(!(glMultiDrawArrays = (void(GLApi*)(GLenum, GLint *, GLsizei *, GLsizei))wglGetProcAddress("glMultiDrawArrays"))) ++ n_failed_functions;
	if(!(glMultiDrawElements = (void(GLApi*)(GLenum, const GLsizei *, GLenum, const GLvoid* *, GLsizei))wglGetProcAddress("glMultiDrawElements"))) ++ n_failed_functions;
	if(!(glPointParameterf = (void(GLApi*)(GLenum, GLfloat))wglGetProcAddress("glPointParameterf"))) ++ n_failed_functions;
	if(!(glPointParameterfv = (void(GLApi*)(GLenum, const GLfloat*))wglGetProcAddress("glPointParameterfv"))) ++ n_failed_functions;
	if(!(glPointParameteri = (void(GLApi*)(GLenum, GLint))wglGetProcAddress("glPointParameteri"))) ++ n_failed_functions;
	if(!(glPointParameteriv = (void(GLApi*)(GLenum, const GLint*))wglGetProcAddress("glPointParameteriv"))) ++ n_failed_functions;
	if(!(glSecondaryColor3b = (void(GLApi*)(GLbyte, GLbyte, GLbyte))wglGetProcAddress("glSecondaryColor3b"))) ++ n_failed_functions;
	if(!(glSecondaryColor3bv = (void(GLApi*)(const GLbyte*))wglGetProcAddress("glSecondaryColor3bv"))) ++ n_failed_functions;
	if(!(glSecondaryColor3d = (void(GLApi*)(GLdouble, GLdouble, GLdouble))wglGetProcAddress("glSecondaryColor3d"))) ++ n_failed_functions;
	if(!(glSecondaryColor3dv = (void(GLApi*)(const GLdouble*))wglGetProcAddress("glSecondaryColor3dv"))) ++ n_failed_functions;
	if(!(glSecondaryColor3f = (void(GLApi*)(GLfloat, GLfloat, GLfloat))wglGetProcAddress("glSecondaryColor3f"))) ++ n_failed_functions;
	if(!(glSecondaryColor3fv = (void(GLApi*)(const GLfloat*))wglGetProcAddress("glSecondaryColor3fv"))) ++ n_failed_functions;
	if(!(glSecondaryColor3i = (void(GLApi*)(GLint, GLint, GLint))wglGetProcAddress("glSecondaryColor3i"))) ++ n_failed_functions;
	if(!(glSecondaryColor3iv = (void(GLApi*)(const GLint*))wglGetProcAddress("glSecondaryColor3iv"))) ++ n_failed_functions;
	if(!(glSecondaryColor3s = (void(GLApi*)(GLshort, GLshort, GLshort))wglGetProcAddress("glSecondaryColor3s"))) ++ n_failed_functions;
	if(!(glSecondaryColor3sv = (void(GLApi*)(const GLshort*))wglGetProcAddress("glSecondaryColor3sv"))) ++ n_failed_functions;
	if(!(glSecondaryColor3ub = (void(GLApi*)(GLubyte, GLubyte, GLubyte))wglGetProcAddress("glSecondaryColor3ub"))) ++ n_failed_functions;
	if(!(glSecondaryColor3ubv = (void(GLApi*)(const GLubyte*))wglGetProcAddress("glSecondaryColor3ubv"))) ++ n_failed_functions;
	if(!(glSecondaryColor3ui = (void(GLApi*)(GLuint, GLuint, GLuint))wglGetProcAddress("glSecondaryColor3ui"))) ++ n_failed_functions;
	if(!(glSecondaryColor3uiv = (void(GLApi*)(const GLuint*))wglGetProcAddress("glSecondaryColor3uiv"))) ++ n_failed_functions;
	if(!(glSecondaryColor3us = (void(GLApi*)(GLushort, GLushort, GLushort))wglGetProcAddress("glSecondaryColor3us"))) ++ n_failed_functions;
	if(!(glSecondaryColor3usv = (void(GLApi*)(const GLushort*))wglGetProcAddress("glSecondaryColor3usv"))) ++ n_failed_functions;
	if(!(glSecondaryColorPointer = (void(GLApi*)(GLint, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glSecondaryColorPointer"))) ++ n_failed_functions;
	if(!(glWindowPos2d = (void(GLApi*)(GLdouble, GLdouble))wglGetProcAddress("glWindowPos2d"))) ++ n_failed_functions;
	if(!(glWindowPos2dv = (void(GLApi*)(const GLdouble*))wglGetProcAddress("glWindowPos2dv"))) ++ n_failed_functions;
	if(!(glWindowPos2f = (void(GLApi*)(GLfloat, GLfloat))wglGetProcAddress("glWindowPos2f"))) ++ n_failed_functions;
	if(!(glWindowPos2fv = (void(GLApi*)(const GLfloat*))wglGetProcAddress("glWindowPos2fv"))) ++ n_failed_functions;
	if(!(glWindowPos2i = (void(GLApi*)(GLint, GLint))wglGetProcAddress("glWindowPos2i"))) ++ n_failed_functions;
	if(!(glWindowPos2iv = (void(GLApi*)(const GLint*))wglGetProcAddress("glWindowPos2iv"))) ++ n_failed_functions;
	if(!(glWindowPos2s = (void(GLApi*)(GLshort, GLshort))wglGetProcAddress("glWindowPos2s"))) ++ n_failed_functions;
	if(!(glWindowPos2sv = (void(GLApi*)(const GLshort*))wglGetProcAddress("glWindowPos2sv"))) ++ n_failed_functions;
	if(!(glWindowPos3d = (void(GLApi*)(GLdouble, GLdouble, GLdouble))wglGetProcAddress("glWindowPos3d"))) ++ n_failed_functions;
	if(!(glWindowPos3dv = (void(GLApi*)(const GLdouble*))wglGetProcAddress("glWindowPos3dv"))) ++ n_failed_functions;
	if(!(glWindowPos3f = (void(GLApi*)(GLfloat, GLfloat, GLfloat))wglGetProcAddress("glWindowPos3f"))) ++ n_failed_functions;
	if(!(glWindowPos3fv = (void(GLApi*)(const GLfloat*))wglGetProcAddress("glWindowPos3fv"))) ++ n_failed_functions;
	if(!(glWindowPos3i = (void(GLApi*)(GLint, GLint, GLint))wglGetProcAddress("glWindowPos3i"))) ++ n_failed_functions;
	if(!(glWindowPos3iv = (void(GLApi*)(const GLint*))wglGetProcAddress("glWindowPos3iv"))) ++ n_failed_functions;
	if(!(glWindowPos3s = (void(GLApi*)(GLshort, GLshort, GLshort))wglGetProcAddress("glWindowPos3s"))) ++ n_failed_functions;
	if(!(glWindowPos3sv = (void(GLApi*)(const GLshort*))wglGetProcAddress("glWindowPos3sv"))) ++ n_failed_functions;

#endif // __GENERATE_GL_14__

	return n_failed_functions;
}

/*
 *		--- opengl 1.5 core func pointers ---
 */

#ifdef __GENERATE_GL_15__

void (GLApi *glGenQueries)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glDeleteQueries)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsQuery)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBeginQuery)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glEndQuery)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glGetQueryiv)(GLenum, GLenum, GLint*) INIT_FUNC_POINTERS;
void (GLApi *glGetQueryObjectiv)(GLuint, GLenum, GLint*) INIT_FUNC_POINTERS;
void (GLApi *glGetQueryObjectuiv)(GLuint, GLenum, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glBindBuffer)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteBuffers)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenBuffers)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsBuffer)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBufferData)(GLenum, GLsizeiptr, const GLvoid *, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glBufferSubData)(GLenum, GLintptr, GLsizeiptr, const GLvoid*) INIT_FUNC_POINTERS;
void (GLApi *glGetBufferSubData)(GLenum, GLintptr, GLsizeiptr, GLvoid*) INIT_FUNC_POINTERS;
GLvoid* (GLApi *glMapBuffer)(GLenum, GLenum) INIT_FUNC_POINTERS;
GLboolean (GLApi *glUnmapBuffer)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glGetBufferParameteriv)(GLenum, GLenum, GLint*) INIT_FUNC_POINTERS;
void (GLApi *glGetBufferPointerv)(GLenum, GLenum, GLvoid**) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_15__

/*
 *	static int CGLExtensionHandler::n_GetGL15FuncPointers()
 *		- gets OpenGL 1.5 core function pointers
 *		- returns number of missing functions
 */
int CGLExtensionHandler::n_GetGL15FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL15FuncPointers");

	int n_failed_functions = 0;

#ifdef __GENERATE_GL_15__

	if(!(glGenQueries = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenQueries"))) ++ n_failed_functions;
	if(!(glDeleteQueries = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteQueries"))) ++ n_failed_functions;
	if(!(glIsQuery = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsQuery"))) ++ n_failed_functions;
	if(!(glBeginQuery = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBeginQuery"))) ++ n_failed_functions;
	if(!(glEndQuery = (void(GLApi*)(GLenum))wglGetProcAddress("glEndQuery"))) ++ n_failed_functions;
	if(!(glGetQueryiv = (void(GLApi*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetQueryiv"))) ++ n_failed_functions;
	if(!(glGetQueryObjectiv = (void(GLApi*)(GLuint, GLenum, GLint*))wglGetProcAddress("glGetQueryObjectiv"))) ++ n_failed_functions;
	if(!(glGetQueryObjectuiv = (void(GLApi*)(GLuint, GLenum, GLuint*))wglGetProcAddress("glGetQueryObjectuiv"))) ++ n_failed_functions;
	if(!(glBindBuffer = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindBuffer"))) ++ n_failed_functions;
	if(!(glDeleteBuffers = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteBuffers"))) ++ n_failed_functions;
	if(!(glGenBuffers = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenBuffers"))) ++ n_failed_functions;
	if(!(glIsBuffer = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsBuffer"))) ++ n_failed_functions;
	if(!(glBufferData = (void(GLApi*)(GLenum, GLsizeiptr, const GLvoid *, GLenum))wglGetProcAddress("glBufferData"))) ++ n_failed_functions;
	if(!(glBufferSubData = (void(GLApi*)(GLenum, GLintptr, GLsizeiptr, const GLvoid*))wglGetProcAddress("glBufferSubData"))) ++ n_failed_functions;
	if(!(glGetBufferSubData = (void(GLApi*)(GLenum, GLintptr, GLsizeiptr, GLvoid*))wglGetProcAddress("glGetBufferSubData"))) ++ n_failed_functions;
	if(!(glMapBuffer = (GLvoid*(GLApi*)(GLenum, GLenum))wglGetProcAddress("glMapBuffer"))) ++ n_failed_functions;
	if(!(glUnmapBuffer = (GLboolean(GLApi*)(GLenum))wglGetProcAddress("glUnmapBuffer"))) ++ n_failed_functions;
	if(!(glGetBufferParameteriv = (void(GLApi*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetBufferParameteriv"))) ++ n_failed_functions;
	if(!(glGetBufferPointerv = (void(GLApi*)(GLenum, GLenum, GLvoid**))wglGetProcAddress("glGetBufferPointerv"))) ++ n_failed_functions;

#endif // __GENERATE_GL_15__

	return n_failed_functions;
}

/*
 *		--- GL20 func pointers ---
 */

#ifdef __GENERATE_GL_20__

// shader objects api
void (GLApi *glDeleteShader)(GLuint shader) INIT_FUNC_POINTERS;
void (GLApi *glDetachShader)(GLuint program, GLuint shader) INIT_FUNC_POINTERS;
GLuint (GLApi *glCreateShader)(GLenum type) INIT_FUNC_POINTERS;
void (GLApi *glShaderSource)(GLuint shader, GLsizei count, const GLchar* *string, const GLint *length) INIT_FUNC_POINTERS;
void (GLApi *glCompileShader)(GLuint shader) INIT_FUNC_POINTERS;

// program objects
GLuint (GLApi *glCreateProgram)(void) INIT_FUNC_POINTERS;
void (GLApi *glAttachShader)(GLuint program, GLuint shader) INIT_FUNC_POINTERS;
void (GLApi *glLinkProgram)(GLuint program) INIT_FUNC_POINTERS;
void (GLApi *glUseProgram)(GLuint program) INIT_FUNC_POINTERS;
void (GLApi *glDeleteProgram)(GLuint program) INIT_FUNC_POINTERS;
void (GLApi *glValidateProgram)(GLuint program) INIT_FUNC_POINTERS;

// uniforms
void (GLApi *glUniform1f)(GLint location, GLfloat v0) INIT_FUNC_POINTERS;
void (GLApi *glUniform2f)(GLint location, GLfloat v0, GLfloat v1) INIT_FUNC_POINTERS;
void (GLApi *glUniform3f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2) INIT_FUNC_POINTERS;
void (GLApi *glUniform4f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) INIT_FUNC_POINTERS;
void (GLApi *glUniform1i)(GLint location, GLint v0) INIT_FUNC_POINTERS;
void (GLApi *glUniform2i)(GLint location, GLint v0, GLint v1) INIT_FUNC_POINTERS;
void (GLApi *glUniform3i)(GLint location, GLint v0, GLint v1, GLint v2) INIT_FUNC_POINTERS;
void (GLApi *glUniform4i)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3) INIT_FUNC_POINTERS;
void (GLApi *glUniform1fv)(GLint location, GLsizei count, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniform2fv)(GLint location, GLsizei count, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniform3fv)(GLint location, GLsizei count, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniform4fv)(GLint location, GLsizei count, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniform1iv)(GLint location, GLsizei count, const GLint *value) INIT_FUNC_POINTERS;
void (GLApi *glUniform2iv)(GLint location, GLsizei count, const GLint *value) INIT_FUNC_POINTERS;
void (GLApi *glUniform3iv)(GLint location, GLsizei count, const GLint *value) INIT_FUNC_POINTERS;
void (GLApi *glUniform4iv)(GLint location, GLsizei count, const GLint *value) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix2fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix3fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;

// attrib locations
void (GLApi *glBindAttribLocation)(GLuint program, GLuint index, const GLchar *name) INIT_FUNC_POINTERS;
GLint (GLApi *glGetAttribLocation)(GLuint program, const GLchar *name) INIT_FUNC_POINTERS;

// vertex attributes
void (GLApi *glVertexAttrib1d)(GLuint index, GLdouble x) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1dv)(GLuint index, const GLdouble *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1f)(GLuint index, GLfloat x) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1fv)(GLuint index, const GLfloat *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1s)(GLuint index, GLshort x) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1sv)(GLuint index, const GLshort *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2d)(GLuint index, GLdouble x, GLdouble y) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2dv)(GLuint index, const GLdouble *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2f)(GLuint index, GLfloat x, GLfloat y) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2fv)(GLuint index, const GLfloat *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2s)(GLuint index, GLshort x, GLshort y) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2sv)(GLuint index, const GLshort *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3d)(GLuint index, GLdouble x, GLdouble y, GLdouble z) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3dv)(GLuint index, const GLdouble *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3f)(GLuint index, GLfloat x, GLfloat y, GLfloat z) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3fv)(GLuint index, const GLfloat *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3s)(GLuint index, GLshort x, GLshort y, GLshort z) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3sv)(GLuint index, const GLshort *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4Nbv)(GLuint index, const GLbyte *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4Niv)(GLuint index, const GLint *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4Nsv)(GLuint index, const GLshort *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4Nub)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4Nubv)(GLuint index, const GLubyte *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4Nuiv)(GLuint index, const GLuint *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4Nusv)(GLuint index, const GLushort *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4bv)(GLuint index, const GLbyte *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4d)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4dv)(GLuint index, const GLdouble *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4f)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4fv)(GLuint index, const GLfloat *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4iv)(GLuint index, const GLint *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4s)(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4sv)(GLuint index, const GLshort *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4ubv)(GLuint index, const GLubyte *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4uiv)(GLuint index, const GLuint *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4usv)(GLuint index, const GLushort *v) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribPointer)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer) INIT_FUNC_POINTERS;
void (GLApi *glEnableVertexAttribArray)(GLuint index) INIT_FUNC_POINTERS;
void (GLApi *glDisableVertexAttribArray)(GLuint index) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribdv)(GLuint index, GLenum pname, GLdouble *params) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribfv)(GLuint index, GLenum pname, GLfloat *params) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribiv)(GLuint index, GLenum pname, GLint *params) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribPointerv)(GLuint index, GLenum pname, GLvoid* *pointer) INIT_FUNC_POINTERS;

// queries
GLboolean (GLApi *glIsShader)(GLuint shader) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsProgram)(GLuint program) INIT_FUNC_POINTERS;
void (GLApi *glGetShaderiv)(GLuint program, GLenum pname, GLint *params) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramiv)(GLuint program, GLenum pname, GLint *params) INIT_FUNC_POINTERS;
void (GLApi *glGetAttachedShaders)(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders) INIT_FUNC_POINTERS;
void (GLApi *glGetShaderInfoLog)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramInfoLog)(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog) INIT_FUNC_POINTERS;
GLint (GLApi *glGetUniformLocation)(GLuint program, const GLchar *name) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveUniform)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name) INIT_FUNC_POINTERS;
void (GLApi *glGetUniformfv)(GLuint program, GLint location, GLfloat *params) INIT_FUNC_POINTERS;
void (GLApi *glGetUniformiv)(GLuint program, GLint location, GLint *params) INIT_FUNC_POINTERS;
void (GLApi *glGetShaderSource)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveAttrib)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name) INIT_FUNC_POINTERS;

// multiple draw buffers
void (GLApi *glDrawBuffers)(GLsizei n, const GLenum *bufs) INIT_FUNC_POINTERS;

// two-sided stencil
void (GLApi *glStencilFuncSeparate)(GLenum face, GLenum func, GLint ref, GLuint mask) INIT_FUNC_POINTERS;
void (GLApi *glStencilOpSeparate)(GLenum face, GLenum fail, GLenum zfail, GLenum zpass) INIT_FUNC_POINTERS;
void (GLApi *glStencilMaskSeparate)(GLenum face, GLuint mask) INIT_FUNC_POINTERS;

// separate alpha blending
void (GLApi *glBlendEquationSeparate)(GLenum modeRGB, GLenum modeAlpha) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_20__

/*
 *	static int CGLExtensionHandler::n_GetGL20FuncPointers()
 *		- gets OpenGL 2.0 core function pointers
 *		- returns number of missing functions
 */
int CGLExtensionHandler::n_GetGL20FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL20FuncPointers");

	int n_failed_functions = 0;

#ifdef __GENERATE_GL_20__

	if(!(glDeleteShader = (void(GLApi*)(GLuint))wglGetProcAddress("glDeleteShader"))) ++ n_failed_functions;
	if(!(glDetachShader = (void(GLApi*)(GLuint, GLuint))wglGetProcAddress("glDetachShader"))) ++ n_failed_functions;
	if(!(glCreateShader = (GLuint(GLApi*)(GLenum))wglGetProcAddress("glCreateShader"))) ++ n_failed_functions;
	if(!(glShaderSource = (void(GLApi*)(GLuint, GLsizei, const GLchar**, const GLint*))wglGetProcAddress("glShaderSource"))) ++ n_failed_functions;
	if(!(glCompileShader = (void(GLApi*)(GLuint))wglGetProcAddress("glCompileShader"))) ++ n_failed_functions;
	if(!(glCreateProgram = (GLuint(GLApi*)(void))wglGetProcAddress("glCreateProgram"))) ++ n_failed_functions;
	if(!(glAttachShader = (void(GLApi*)(GLuint, GLuint shader))wglGetProcAddress("glAttachShader"))) ++ n_failed_functions;
	if(!(glLinkProgram = (void(GLApi*)(GLuint))wglGetProcAddress("glLinkProgram"))) ++ n_failed_functions;
	if(!(glUseProgram = (void(GLApi*)(GLuint))wglGetProcAddress("glUseProgram"))) ++ n_failed_functions;
	if(!(glDeleteProgram = (void(GLApi*)(GLuint))wglGetProcAddress("glDeleteProgram"))) ++ n_failed_functions;
	if(!(glValidateProgram = (void(GLApi*)(GLuint))wglGetProcAddress("glValidateProgram"))) ++ n_failed_functions;
	if(!(glUniform1f = (void(GLApi*)(GLint, GLfloat))wglGetProcAddress("glUniform1f"))) ++ n_failed_functions;
	if(!(glUniform2f = (void(GLApi*)(GLint, GLfloat, GLfloat))wglGetProcAddress("glUniform2f"))) ++ n_failed_functions;
	if(!(glUniform3f = (void(GLApi*)(GLint, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glUniform3f"))) ++ n_failed_functions;
	if(!(glUniform4f = (void(GLApi*)(GLint, GLfloat, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glUniform4f"))) ++ n_failed_functions;
	if(!(glUniform1i = (void(GLApi*)(GLint, GLint))wglGetProcAddress("glUniform1i"))) ++ n_failed_functions;
	if(!(glUniform2i = (void(GLApi*)(GLint, GLint, GLint))wglGetProcAddress("glUniform2i"))) ++ n_failed_functions;
	if(!(glUniform3i = (void(GLApi*)(GLint, GLint, GLint, GLint))wglGetProcAddress("glUniform3i"))) ++ n_failed_functions;
	if(!(glUniform4i = (void(GLApi*)(GLint, GLint, GLint, GLint, GLint))wglGetProcAddress("glUniform4i"))) ++ n_failed_functions;
	if(!(glUniform1fv = (void(GLApi*)(GLint, GLsizei, const GLfloat*))wglGetProcAddress("glUniform1fv"))) ++ n_failed_functions;
	if(!(glUniform2fv = (void(GLApi*)(GLint, GLsizei, const GLfloat*))wglGetProcAddress("glUniform2fv"))) ++ n_failed_functions;
	if(!(glUniform3fv = (void(GLApi*)(GLint, GLsizei, const GLfloat*))wglGetProcAddress("glUniform3fv"))) ++ n_failed_functions;
	if(!(glUniform4fv = (void(GLApi*)(GLint, GLsizei, const GLfloat*))wglGetProcAddress("glUniform4fv"))) ++ n_failed_functions;
	if(!(glUniform1iv = (void(GLApi*)(GLint, GLsizei, const GLint*))wglGetProcAddress("glUniform1iv"))) ++ n_failed_functions;
	if(!(glUniform2iv = (void(GLApi*)(GLint, GLsizei, const GLint*))wglGetProcAddress("glUniform2iv"))) ++ n_failed_functions;
	if(!(glUniform3iv = (void(GLApi*)(GLint, GLsizei, const GLint*))wglGetProcAddress("glUniform3iv"))) ++ n_failed_functions;
	if(!(glUniform4iv = (void(GLApi*)(GLint, GLsizei, const GLint*))wglGetProcAddress("glUniform4iv"))) ++ n_failed_functions;
	if(!(glUniformMatrix2fv = (void(GLApi*)(GLint, GLsizei, GLboolean transpose, const GLfloat*))wglGetProcAddress("glUniformMatrix2fv"))) ++ n_failed_functions;
	if(!(glUniformMatrix3fv = (void(GLApi*)(GLint, GLsizei, GLboolean transpose, const GLfloat*))wglGetProcAddress("glUniformMatrix3fv"))) ++ n_failed_functions;
	if(!(glUniformMatrix4fv = (void(GLApi*)(GLint, GLsizei, GLboolean transpose, const GLfloat*))wglGetProcAddress("glUniformMatrix4fv"))) ++ n_failed_functions;
	if(!(glBindAttribLocation = (void(GLApi*)(GLuint, GLuint, const GLchar *name))wglGetProcAddress("glBindAttribLocation"))) ++ n_failed_functions;
	if(!(glGetAttribLocation = (GLint(GLApi*)(GLuint, const GLchar *name))wglGetProcAddress("glGetAttribLocation"))) ++ n_failed_functions;
	if(!(glVertexAttrib1d = (void(GLApi*)(GLuint, GLdouble))wglGetProcAddress("glVertexAttrib1d"))) ++ n_failed_functions;
	if(!(glVertexAttrib1dv = (void(GLApi*)(GLuint, const GLdouble*))wglGetProcAddress("glVertexAttrib1dv"))) ++ n_failed_functions;
	if(!(glVertexAttrib1f = (void(GLApi*)(GLuint, GLfloat))wglGetProcAddress("glVertexAttrib1f"))) ++ n_failed_functions;
	if(!(glVertexAttrib1fv = (void(GLApi*)(GLuint, const GLfloat*))wglGetProcAddress("glVertexAttrib1fv"))) ++ n_failed_functions;
	if(!(glVertexAttrib1s = (void(GLApi*)(GLuint, GLshort))wglGetProcAddress("glVertexAttrib1s"))) ++ n_failed_functions;
	if(!(glVertexAttrib1sv = (void(GLApi*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib1sv"))) ++ n_failed_functions;
	if(!(glVertexAttrib2d = (void(GLApi*)(GLuint, GLdouble, GLdouble))wglGetProcAddress("glVertexAttrib2d"))) ++ n_failed_functions;
	if(!(glVertexAttrib2dv = (void(GLApi*)(GLuint, const GLdouble*))wglGetProcAddress("glVertexAttrib2dv"))) ++ n_failed_functions;
	if(!(glVertexAttrib2f = (void(GLApi*)(GLuint, GLfloat, GLfloat))wglGetProcAddress("glVertexAttrib2f"))) ++ n_failed_functions;
	if(!(glVertexAttrib2fv = (void(GLApi*)(GLuint, const GLfloat*))wglGetProcAddress("glVertexAttrib2fv"))) ++ n_failed_functions;
	if(!(glVertexAttrib2s = (void(GLApi*)(GLuint, GLshort, GLshort))wglGetProcAddress("glVertexAttrib2s"))) ++ n_failed_functions;
	if(!(glVertexAttrib2sv = (void(GLApi*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib2sv"))) ++ n_failed_functions;
	if(!(glVertexAttrib3d = (void(GLApi*)(GLuint, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glVertexAttrib3d"))) ++ n_failed_functions;
	if(!(glVertexAttrib3dv = (void(GLApi*)(GLuint, const GLdouble*))wglGetProcAddress("glVertexAttrib3dv"))) ++ n_failed_functions;
	if(!(glVertexAttrib3f = (void(GLApi*)(GLuint, GLfloat, GLfloat, GLfloat z))wglGetProcAddress("glVertexAttrib3f"))) ++ n_failed_functions;
	if(!(glVertexAttrib3fv = (void(GLApi*)(GLuint, const GLfloat*))wglGetProcAddress("glVertexAttrib3fv"))) ++ n_failed_functions;
	if(!(glVertexAttrib3s = (void(GLApi*)(GLuint, GLshort, GLshort, GLshort z))wglGetProcAddress("glVertexAttrib3s"))) ++ n_failed_functions;
	if(!(glVertexAttrib3sv = (void(GLApi*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib3sv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4Nbv = (void(GLApi*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4Nbv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4Niv = (void(GLApi*)(GLuint, const GLint*))wglGetProcAddress("glVertexAttrib4Niv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4Nsv = (void(GLApi*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib4Nsv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4Nub = (void(GLApi*)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte))wglGetProcAddress("glVertexAttrib4Nub"))) ++ n_failed_functions;
	if(!(glVertexAttrib4Nubv = (void(GLApi*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4Nubv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4Nuiv = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4Nuiv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4Nusv = (void(GLApi*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4Nusv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4bv = (void(GLApi*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4bv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4d = (void(GLApi*)(GLuint, GLdouble, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glVertexAttrib4d"))) ++ n_failed_functions;
	if(!(glVertexAttrib4dv = (void(GLApi*)(GLuint, const GLdouble*))wglGetProcAddress("glVertexAttrib4dv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4f = (void(GLApi*)(GLuint, GLfloat, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glVertexAttrib4f"))) ++ n_failed_functions;
	if(!(glVertexAttrib4fv = (void(GLApi*)(GLuint, const GLfloat*))wglGetProcAddress("glVertexAttrib4fv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4iv = (void(GLApi*)(GLuint, const GLint*))wglGetProcAddress("glVertexAttrib4iv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4s = (void(GLApi*)(GLuint, GLshort, GLshort, GLshort, GLshort))wglGetProcAddress("glVertexAttrib4s"))) ++ n_failed_functions;
	if(!(glVertexAttrib4sv = (void(GLApi*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib4sv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4ubv = (void(GLApi*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4ubv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4uiv = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4uiv"))) ++ n_failed_functions;
	if(!(glVertexAttrib4usv = (void(GLApi*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4usv"))) ++ n_failed_functions;
	if(!(glVertexAttribPointer = (void(GLApi*)(GLuint, GLint, GLenum, GLboolean, GLsizei, const GLvoid*))wglGetProcAddress("glVertexAttribPointer"))) ++ n_failed_functions;
	if(!(glEnableVertexAttribArray = (void(GLApi*)(GLuint index))wglGetProcAddress("glEnableVertexAttribArray"))) ++ n_failed_functions;
	if(!(glDisableVertexAttribArray = (void(GLApi*)(GLuint index))wglGetProcAddress("glDisableVertexAttribArray"))) ++ n_failed_functions;
	if(!(glGetVertexAttribdv = (void(GLApi*)(GLuint, GLenum, GLdouble*))wglGetProcAddress("glGetVertexAttribdv"))) ++ n_failed_functions;
	if(!(glGetVertexAttribfv = (void(GLApi*)(GLuint, GLenum, GLfloat*))wglGetProcAddress("glGetVertexAttribfv"))) ++ n_failed_functions;
	if(!(glGetVertexAttribiv = (void(GLApi*)(GLuint, GLenum, GLint*))wglGetProcAddress("glGetVertexAttribiv"))) ++ n_failed_functions;
	if(!(glGetVertexAttribPointerv = (void(GLApi*)(GLuint, GLenum, GLvoid**))wglGetProcAddress("glGetVertexAttribPointerv"))) ++ n_failed_functions;
	if(!(glIsShader = (GLboolean(GLApi*)(GLuint shader))wglGetProcAddress("glIsShader"))) ++ n_failed_functions;
	if(!(glIsProgram = (GLboolean(GLApi*)(GLuint program))wglGetProcAddress("glIsProgram"))) ++ n_failed_functions;
	if(!(glGetShaderiv = (void(GLApi*)(GLuint, GLenum, GLint*))wglGetProcAddress("glGetShaderiv"))) ++ n_failed_functions;
	if(!(glGetProgramiv = (void(GLApi*)(GLuint, GLenum, GLint*))wglGetProcAddress("glGetProgramiv"))) ++ n_failed_functions;
	if(!(glGetAttachedShaders = (void(GLApi*)(GLuint, GLsizei maxCount, GLsizei *count, GLuint*))wglGetProcAddress("glGetAttachedShaders"))) ++ n_failed_functions;
	if(!(glGetShaderInfoLog = (void(GLApi*)(GLuint shader, GLsizei bufSize, GLsizei*, GLchar*))wglGetProcAddress("glGetShaderInfoLog"))) ++ n_failed_functions;
	if(!(glGetProgramInfoLog = (void(GLApi*)(GLuint, GLsizei bufSize, GLsizei*, GLchar*))wglGetProcAddress("glGetProgramInfoLog"))) ++ n_failed_functions;
	if(!(glGetUniformLocation = (GLint(GLApi*)(GLuint, const GLchar *name))wglGetProcAddress("glGetUniformLocation"))) ++ n_failed_functions;
	if(!(glGetActiveUniform = (void(GLApi*)(GLuint, GLuint, GLsizei bufSize, GLsizei*, GLsizei*, GLenum*, GLchar*))wglGetProcAddress("glGetActiveUniform"))) ++ n_failed_functions;
	if(!(glGetUniformfv = (void(GLApi*)(GLuint, GLint, GLfloat*))wglGetProcAddress("glGetUniformfv"))) ++ n_failed_functions;
	if(!(glGetUniformiv = (void(GLApi*)(GLuint, GLint, GLint*))wglGetProcAddress("glGetUniformiv"))) ++ n_failed_functions;
	if(!(glGetShaderSource = (void(GLApi*)(GLuint, GLsizei bufSize, GLsizei*, GLchar*))wglGetProcAddress("glGetShaderSource"))) ++ n_failed_functions;
	if(!(glGetActiveAttrib = (void(GLApi*)(GLuint, GLuint, GLsizei bufSize, GLsizei*, GLsizei*, GLenum*, GLchar*))wglGetProcAddress("glGetActiveAttrib"))) ++ n_failed_functions;
	if(!(glDrawBuffers = (void(GLApi*)(GLsizei, const GLenum*))wglGetProcAddress("glDrawBuffers"))) ++ n_failed_functions;
	if(!(glStencilFuncSeparate = (void(GLApi*)(GLenum, GLenum, GLint, GLuint))wglGetProcAddress("glStencilFuncSeparate"))) ++ n_failed_functions;
	if(!(glStencilOpSeparate = (void(GLApi*)(GLenum, GLenum, GLenum, GLenum))wglGetProcAddress("glStencilOpSeparate"))) ++ n_failed_functions;
	if(!(glStencilMaskSeparate = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glStencilMaskSeparate"))) ++ n_failed_functions;
	if(!(glBlendEquationSeparate = (void(GLApi*)(GLenum, GLenum))wglGetProcAddress("glBlendEquationSeparate"))) ++ n_failed_functions;

#endif // __GENERATE_GL_20__

	return n_failed_functions;
}

/*
 *								--- OpenGL 2.1 ---
 */

#ifdef __GENERATE_GL_21__

void (GLApi *glUniformMatrix2x3fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix3x2fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix2x4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix4x2fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix3x4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix4x3fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_21__

/*
 *	static int CGLExtensionHandler::n_GetGL21FuncPointers()
 *		- gets OpenGL 2.1 core function pointers
 *		- returns number of missing functions
 */
int CGLExtensionHandler::n_GetGL21FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL21FuncPointers");

	int n_failed_functions = 0;

#ifdef __GENERATE_GL_21__

	if(!(glUniformMatrix2x3fv = (void(GLApi*)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))wglGetProcAddress("glUniformMatrix2x3fv"))) ++ n_failed_functions;
	if(!(glUniformMatrix3x2fv = (void(GLApi*)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))wglGetProcAddress("glUniformMatrix3x2fv"))) ++ n_failed_functions;
	if(!(glUniformMatrix2x4fv = (void(GLApi*)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))wglGetProcAddress("glUniformMatrix2x4fv"))) ++ n_failed_functions;
	if(!(glUniformMatrix4x2fv = (void(GLApi*)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))wglGetProcAddress("glUniformMatrix4x2fv"))) ++ n_failed_functions;
	if(!(glUniformMatrix3x4fv = (void(GLApi*)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))wglGetProcAddress("glUniformMatrix3x4fv"))) ++ n_failed_functions;
	if(!(glUniformMatrix4x3fv = (void(GLApi*)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))wglGetProcAddress("glUniformMatrix4x3fv"))) ++ n_failed_functions;

#endif // __GENERATE_GL_21__

	return n_failed_functions;
}


/*
 *								--- GL_ARB_color_buffer_float ---
 */

bool GLEH_ARB_color_buffer_float = false;

#ifdef __GENERATE_GL_ARB_color_buffer_float

void (GLApi *glClampColorARB)(GLenum, GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_color_buffer_float

int CGLExtensionHandler::n_GetColorBufferFloatARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_color_buffer_float

	if(!(glClampColorARB = (void(GLApi*)(GLenum, GLenum))wglGetProcAddress("glClampColorARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_color_buffer_float

	GLEH_ARB_color_buffer_float = !n_failed_functions && b_SupportedExtension("GL_ARB_color_buffer_float");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_color_buffer_float ---
 */


/*
 *								--- GL_ARB_copy_buffer ---
 */

bool GLEH_ARB_copy_buffer = false;

#ifdef __GENERATE_GL_ARB_copy_buffer

void (GLApi *glCopyBufferSubData)(GLenum, GLenum, GLintptr, GLintptr, GLsizeiptr) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_copy_buffer

int CGLExtensionHandler::n_GetCopyBufferARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_copy_buffer

	if(!(glCopyBufferSubData = (void(GLApi*)(GLenum, GLenum, GLintptr, GLintptr, GLsizeiptr))wglGetProcAddress("glCopyBufferSubData"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_copy_buffer

	GLEH_ARB_copy_buffer = !n_failed_functions && b_SupportedExtension("GL_ARB_copy_buffer");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_copy_buffer ---
 */


/*
 *								--- GL_ARB_depth_buffer_float ---
 */

bool GLEH_ARB_depth_buffer_float = false;

int CGLExtensionHandler::n_GetDepthBufferFloatARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_depth_buffer_float = !n_failed_functions && b_SupportedExtension("GL_ARB_depth_buffer_float");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_depth_buffer_float ---
 */


/*
 *								--- GL_ARB_depth_clamp ---
 */

bool GLEH_ARB_depth_clamp = false;

int CGLExtensionHandler::n_GetDepthClampARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_depth_clamp = !n_failed_functions && b_SupportedExtension("GL_ARB_depth_clamp");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_depth_clamp ---
 */


/*
 *								--- GL_ARB_depth_texture ---
 */

bool GLEH_ARB_depth_texture = false;

int CGLExtensionHandler::n_GetDepthTextureARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_depth_texture = !n_failed_functions && b_SupportedExtension("GL_ARB_depth_texture");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_depth_texture ---
 */


/*
 *								--- GL_ARB_draw_buffers ---
 */

bool GLEH_ARB_draw_buffers = false;

#ifdef __GENERATE_GL_ARB_draw_buffers

void (GLApi *glDrawBuffersARB)(GLsizei, const GLenum*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_draw_buffers

int CGLExtensionHandler::n_GetDrawBuffersARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_draw_buffers

	if(!(glDrawBuffersARB = (void(GLApi*)(GLsizei, const GLenum*))wglGetProcAddress("glDrawBuffersARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_draw_buffers

	GLEH_ARB_draw_buffers = !n_failed_functions && b_SupportedExtension("GL_ARB_draw_buffers");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_draw_buffers ---
 */


/*
 *								--- GL_ARB_draw_elements_base_vertex ---
 */

bool GLEH_ARB_draw_elements_base_vertex = false;

#ifdef __GENERATE_GL_ARB_draw_elements_base_vertex

void (GLApi *glDrawElementsBaseVertex)(GLenum, GLsizei, GLenum, void*, int) INIT_FUNC_POINTERS;
void (GLApi *glDrawRangeElementsBaseVertex)(GLenum, GLuint, GLuint, GLsizei, GLenum, void*, int) INIT_FUNC_POINTERS;
void (GLApi *glDrawElementsInstancedBaseVertex)(GLenum, GLsizei, GLenum, const void*, GLsizei, int) INIT_FUNC_POINTERS;
void (GLApi *glMultiDrawElementsBaseVertex)(GLenum, GLsizei*, GLenum, void**, GLsizei, int*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_draw_elements_base_vertex

int CGLExtensionHandler::n_GetDrawElementsBaseVertexARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_draw_elements_base_vertex

	if(!(glDrawElementsBaseVertex = (void(GLApi*)(GLenum, GLsizei, GLenum, void*, int))wglGetProcAddress("glDrawElementsBaseVertex"))) ++ n_failed_functions;
	if(!(glDrawRangeElementsBaseVertex = (void(GLApi*)(GLenum, GLuint, GLuint, GLsizei, GLenum, void*, int))wglGetProcAddress("glDrawRangeElementsBaseVertex"))) ++ n_failed_functions;
	if(!(glDrawElementsInstancedBaseVertex = (void(GLApi*)(GLenum, GLsizei, GLenum, const void*, GLsizei, int))wglGetProcAddress("glDrawElementsInstancedBaseVertex"))) ++ n_failed_functions;
	if(!(glMultiDrawElementsBaseVertex = (void(GLApi*)(GLenum, GLsizei*, GLenum, void**, GLsizei, int*))wglGetProcAddress("glMultiDrawElementsBaseVertex"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_draw_elements_base_vertex

	GLEH_ARB_draw_elements_base_vertex = !n_failed_functions && b_SupportedExtension("GL_ARB_draw_elements_base_vertex");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_draw_elements_base_vertex ---
 */


/*
 *								--- GL_ARB_draw_instanced ---
 */

bool GLEH_ARB_draw_instanced = false;

#ifdef __GENERATE_GL_ARB_draw_instanced

void (GLApi *glDrawArraysInstancedARB)(GLenum, int, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glDrawElementsInstancedARB)(GLenum, GLsizei, GLenum, const void*, GLsizei) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_draw_instanced

int CGLExtensionHandler::n_GetDrawInstancedARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_draw_instanced

	if(!(glDrawArraysInstancedARB = (void(GLApi*)(GLenum, int, GLsizei, GLsizei))wglGetProcAddress("glDrawArraysInstancedARB"))) ++ n_failed_functions;
	if(!(glDrawElementsInstancedARB = (void(GLApi*)(GLenum, GLsizei, GLenum, const void*, GLsizei))wglGetProcAddress("glDrawElementsInstancedARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_draw_instanced

	GLEH_ARB_draw_instanced = !n_failed_functions && b_SupportedExtension("GL_ARB_draw_instanced");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_draw_instanced ---
 */


/*
 *								--- GL_ARB_fragment_coord_conventions ---
 */

bool GLEH_ARB_fragment_coord_conventions = false;

int CGLExtensionHandler::n_GetFragmentCoordConventionsARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_fragment_coord_conventions = !n_failed_functions && b_SupportedExtension("GL_ARB_fragment_coord_conventions");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_fragment_coord_conventions ---
 */


/*
 *								--- GL_ARB_fragment_program ---
 */

bool GLEH_ARB_fragment_program = false;

#ifdef __GENERATE_GL_ARB_fragment_program

void (GLApi *glProgramStringARB)(GLenum, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glBindProgramARB)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteProgramsARB)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenProgramsARB)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameter4dARB)(GLenum, GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameter4dvARB)(GLenum, GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameter4fARB)(GLenum, GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameter4fvARB)(GLenum, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4dARB)(GLenum, GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4dvARB)(GLenum, GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4fARB)(GLenum, GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4fvARB)(GLenum, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramEnvParameterdvARB)(GLenum, GLuint, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramEnvParameterfvARB)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramLocalParameterdvARB)(GLenum, GLuint, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramLocalParameterfvARB)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramivARB)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramStringARB)(GLenum, GLenum, void*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsProgramARB)(GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_fragment_program

int CGLExtensionHandler::n_GetFragmentProgramARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_fragment_program

	if(!(glProgramStringARB = (void(GLApi*)(GLenum, GLenum, GLsizei, const void*))wglGetProcAddress("glProgramStringARB"))) ++ n_failed_functions;
	if(!(glBindProgramARB = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindProgramARB"))) ++ n_failed_functions;
	if(!(glDeleteProgramsARB = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteProgramsARB"))) ++ n_failed_functions;
	if(!(glGenProgramsARB = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenProgramsARB"))) ++ n_failed_functions;
	if(!(glProgramEnvParameter4dARB = (void(GLApi*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramEnvParameter4dARB"))) ++ n_failed_functions;
	if(!(glProgramEnvParameter4dvARB = (void(GLApi*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramEnvParameter4dvARB"))) ++ n_failed_functions;
	if(!(glProgramEnvParameter4fARB = (void(GLApi*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramEnvParameter4fARB"))) ++ n_failed_functions;
	if(!(glProgramEnvParameter4fvARB = (void(GLApi*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramEnvParameter4fvARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4dARB = (void(GLApi*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramLocalParameter4dARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4dvARB = (void(GLApi*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramLocalParameter4dvARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4fARB = (void(GLApi*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramLocalParameter4fARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4fvARB = (void(GLApi*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramLocalParameter4fvARB"))) ++ n_failed_functions;
	if(!(glGetProgramEnvParameterdvARB = (void(GLApi*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramEnvParameterdvARB"))) ++ n_failed_functions;
	if(!(glGetProgramEnvParameterfvARB = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramEnvParameterfvARB"))) ++ n_failed_functions;
	if(!(glGetProgramLocalParameterdvARB = (void(GLApi*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramLocalParameterdvARB"))) ++ n_failed_functions;
	if(!(glGetProgramLocalParameterfvARB = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramLocalParameterfvARB"))) ++ n_failed_functions;
	if(!(glGetProgramivARB = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glGetProgramivARB"))) ++ n_failed_functions;
	if(!(glGetProgramStringARB = (void(GLApi*)(GLenum, GLenum, void*))wglGetProcAddress("glGetProgramStringARB"))) ++ n_failed_functions;
	if(!(glIsProgramARB = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsProgramARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_fragment_program

	GLEH_ARB_fragment_program = !n_failed_functions && b_SupportedExtension("GL_ARB_fragment_program");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_fragment_program ---
 */


/*
 *								--- GL_ARB_fragment_program_shadow ---
 */

bool GLEH_ARB_fragment_program_shadow = false;

int CGLExtensionHandler::n_GetFragmentProgramShadowARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_fragment_program_shadow = !n_failed_functions && b_SupportedExtension("GL_ARB_fragment_program_shadow");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_fragment_program_shadow ---
 */


/*
 *								--- GL_ARB_fragment_shader ---
 */

bool GLEH_ARB_fragment_shader = false;

int CGLExtensionHandler::n_GetFragmentShaderARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_fragment_shader = !n_failed_functions && b_SupportedExtension("GL_ARB_fragment_shader");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_fragment_shader ---
 */


/*
 *								--- GL_ARB_framebuffer_object ---
 */

bool GLEH_ARB_framebuffer_object = false;

#ifdef __GENERATE_GL_ARB_framebuffer_object

GLboolean (GLApi *glIsRenderbuffer)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBindRenderbuffer)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteRenderbuffers)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenRenderbuffers)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glRenderbufferStorage)(GLenum, GLenum, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glRenderbufferStorageMultisample)(GLenum, GLsizei, GLenum, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glGetRenderbufferParameteriv)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsFramebuffer)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBindFramebuffer)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteFramebuffers)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenFramebuffers)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
GLenum (GLApi *glCheckFramebufferStatus)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTexture1D)(GLenum, GLenum, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTexture2D)(GLenum, GLenum, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTexture3D)(GLenum, GLenum, GLenum, GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTextureLayer)(GLenum, GLenum, GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferRenderbuffer)(GLenum, GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetFramebufferAttachmentParameteriv)(GLenum, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glBlitFramebuffer)(int, int, int, int, int, int, int, int, GLbitfield, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glGenerateMipmap)(GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_framebuffer_object

int CGLExtensionHandler::n_GetFramebufferObjectARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_framebuffer_object

	if(!(glIsRenderbuffer = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsRenderbuffer"))) ++ n_failed_functions;
	if(!(glBindRenderbuffer = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindRenderbuffer"))) ++ n_failed_functions;
	if(!(glDeleteRenderbuffers = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteRenderbuffers"))) ++ n_failed_functions;
	if(!(glGenRenderbuffers = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenRenderbuffers"))) ++ n_failed_functions;
	if(!(glRenderbufferStorage = (void(GLApi*)(GLenum, GLenum, GLsizei, GLsizei))wglGetProcAddress("glRenderbufferStorage"))) ++ n_failed_functions;
	if(!(glRenderbufferStorageMultisample = (void(GLApi*)(GLenum, GLsizei, GLenum, GLsizei, GLsizei))wglGetProcAddress("glRenderbufferStorageMultisample"))) ++ n_failed_functions;
	if(!(glGetRenderbufferParameteriv = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glGetRenderbufferParameteriv"))) ++ n_failed_functions;
	if(!(glIsFramebuffer = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsFramebuffer"))) ++ n_failed_functions;
	if(!(glBindFramebuffer = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindFramebuffer"))) ++ n_failed_functions;
	if(!(glDeleteFramebuffers = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteFramebuffers"))) ++ n_failed_functions;
	if(!(glGenFramebuffers = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenFramebuffers"))) ++ n_failed_functions;
	if(!(glCheckFramebufferStatus = (GLenum(GLApi*)(GLenum))wglGetProcAddress("glCheckFramebufferStatus"))) ++ n_failed_functions;
	if(!(glFramebufferTexture1D = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint, int))wglGetProcAddress("glFramebufferTexture1D"))) ++ n_failed_functions;
	if(!(glFramebufferTexture2D = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint, int))wglGetProcAddress("glFramebufferTexture2D"))) ++ n_failed_functions;
	if(!(glFramebufferTexture3D = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint, int, int))wglGetProcAddress("glFramebufferTexture3D"))) ++ n_failed_functions;
	if(!(glFramebufferTextureLayer = (void(GLApi*)(GLenum, GLenum, GLuint, int, int))wglGetProcAddress("glFramebufferTextureLayer"))) ++ n_failed_functions;
	if(!(glFramebufferRenderbuffer = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint))wglGetProcAddress("glFramebufferRenderbuffer"))) ++ n_failed_functions;
	if(!(glGetFramebufferAttachmentParameteriv = (void(GLApi*)(GLenum, GLenum, GLenum, int*))wglGetProcAddress("glGetFramebufferAttachmentParameteriv"))) ++ n_failed_functions;
	if(!(glBlitFramebuffer = (void(GLApi*)(int, int, int, int, int, int, int, int, GLbitfield, GLenum))wglGetProcAddress("glBlitFramebuffer"))) ++ n_failed_functions;
	if(!(glGenerateMipmap = (void(GLApi*)(GLenum))wglGetProcAddress("glGenerateMipmap"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_framebuffer_object

	GLEH_ARB_framebuffer_object = !n_failed_functions && b_SupportedExtension("GL_ARB_framebuffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_framebuffer_object ---
 */


/*
 *								--- GL_ARB_framebuffer_sRGB ---
 */

bool GLEH_ARB_framebuffer_sRGB = false;

int CGLExtensionHandler::n_GetFramebufferSRGBARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_framebuffer_sRGB = !n_failed_functions && b_SupportedExtension("GL_ARB_framebuffer_sRGB");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_framebuffer_sRGB ---
 */


/*
 *								--- GL_ARB_geometry_shader4 ---
 */

bool GLEH_ARB_geometry_shader4 = false;

#ifdef __GENERATE_GL_ARB_geometry_shader4

void (GLApi *glProgramParameteriARB)(GLuint, GLenum, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTextureARB)(GLenum, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTextureLayerARB)(GLenum, GLenum, GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTextureFaceARB)(GLenum, GLenum, GLuint, int, GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_geometry_shader4

int CGLExtensionHandler::n_GetGeometryShader4ARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_geometry_shader4

	if(!(glProgramParameteriARB = (void(GLApi*)(GLuint, GLenum, int))wglGetProcAddress("glProgramParameteriARB"))) ++ n_failed_functions;
	if(!(glFramebufferTextureARB = (void(GLApi*)(GLenum, GLenum, GLuint, int))wglGetProcAddress("glFramebufferTextureARB"))) ++ n_failed_functions;
	if(!(glFramebufferTextureLayerARB = (void(GLApi*)(GLenum, GLenum, GLuint, int, int))wglGetProcAddress("glFramebufferTextureLayerARB"))) ++ n_failed_functions;
	if(!(glFramebufferTextureFaceARB = (void(GLApi*)(GLenum, GLenum, GLuint, int, GLenum))wglGetProcAddress("glFramebufferTextureFaceARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_geometry_shader4

	GLEH_ARB_geometry_shader4 = !n_failed_functions && b_SupportedExtension("GL_ARB_geometry_shader4");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_geometry_shader4 ---
 */


/*
 *								--- GL_ARB_half_float_pixel ---
 */

bool GLEH_ARB_half_float_pixel = false;

int CGLExtensionHandler::n_GetHalfFloatPixelARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_half_float_pixel = !n_failed_functions && b_SupportedExtension("GL_ARB_half_float_pixel");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_half_float_pixel ---
 */


/*
 *								--- GL_ARB_half_float_vertex ---
 */

bool GLEH_ARB_half_float_vertex = false;

int CGLExtensionHandler::n_GetHalfFloatVertexARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_half_float_vertex = !n_failed_functions && b_SupportedExtension("GL_ARB_half_float_vertex");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_half_float_vertex ---
 */


/*
 *								--- GL_ARB_map_buffer_range ---
 */

bool GLEH_ARB_map_buffer_range = false;

#ifdef __GENERATE_GL_ARB_map_buffer_range

void* (GLApi *glMapBufferRange)(GLenum, GLintptr, GLsizeiptr, GLbitfield) INIT_FUNC_POINTERS;
void (GLApi *glFlushMappedBufferRange)(GLenum, GLintptr, GLsizeiptr) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_map_buffer_range

int CGLExtensionHandler::n_GetMapBufferRangeARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_map_buffer_range

	if(!(glMapBufferRange = (void*(GLApi*)(GLenum, GLintptr, GLsizeiptr, GLbitfield))wglGetProcAddress("glMapBufferRange"))) ++ n_failed_functions;
	if(!(glFlushMappedBufferRange = (void(GLApi*)(GLenum, GLintptr, GLsizeiptr))wglGetProcAddress("glFlushMappedBufferRange"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_map_buffer_range

	GLEH_ARB_map_buffer_range = !n_failed_functions && b_SupportedExtension("GL_ARB_map_buffer_range");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_map_buffer_range ---
 */


/*
 *								--- GL_ARB_multisample ---
 */

bool GLEH_ARB_multisample = false;

#ifdef __GENERATE_GL_ARB_multisample

void (GLApi *glSampleCoverageARB)(GLclampf, GLboolean) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_multisample

int CGLExtensionHandler::n_GetMultisampleARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_multisample

	if(!(glSampleCoverageARB = (void(GLApi*)(GLclampf, GLboolean))wglGetProcAddress("glSampleCoverageARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_multisample

	GLEH_ARB_multisample = !n_failed_functions && b_SupportedExtension("GL_ARB_multisample");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_multisample ---
 */


/*
 *								--- GL_ARB_occlusion_query ---
 */

bool GLEH_ARB_occlusion_query = false;

#ifdef __GENERATE_GL_ARB_occlusion_query

void (GLApi *glGenQueriesARB)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glDeleteQueriesARB)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsQueryARB)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBeginQueryARB)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glEndQueryARB)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glGetQueryivARB)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetQueryObjectivARB)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetQueryObjectuivARB)(GLuint, GLenum, GLuint*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_occlusion_query

int CGLExtensionHandler::n_GetOcclusionQueryARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_occlusion_query

	if(!(glGenQueriesARB = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenQueriesARB"))) ++ n_failed_functions;
	if(!(glDeleteQueriesARB = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteQueriesARB"))) ++ n_failed_functions;
	if(!(glIsQueryARB = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsQueryARB"))) ++ n_failed_functions;
	if(!(glBeginQueryARB = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBeginQueryARB"))) ++ n_failed_functions;
	if(!(glEndQueryARB = (void(GLApi*)(GLenum))wglGetProcAddress("glEndQueryARB"))) ++ n_failed_functions;
	if(!(glGetQueryivARB = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glGetQueryivARB"))) ++ n_failed_functions;
	if(!(glGetQueryObjectivARB = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetQueryObjectivARB"))) ++ n_failed_functions;
	if(!(glGetQueryObjectuivARB = (void(GLApi*)(GLuint, GLenum, GLuint*))wglGetProcAddress("glGetQueryObjectuivARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_occlusion_query

	GLEH_ARB_occlusion_query = !n_failed_functions && b_SupportedExtension("GL_ARB_occlusion_query");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_occlusion_query ---
 */


/*
 *								--- GL_ARB_pixel_buffer_object ---
 */

bool GLEH_ARB_pixel_buffer_object = false;

int CGLExtensionHandler::n_GetPixelBufferObjectARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_pixel_buffer_object = !n_failed_functions && b_SupportedExtension("GL_ARB_pixel_buffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_pixel_buffer_object ---
 */


/*
 *								--- GL_ARB_point_parameters ---
 */

bool GLEH_ARB_point_parameters = false;

#ifdef __GENERATE_GL_ARB_point_parameters

void (GLApi *glPointParameterfARB)(GLenum, float) INIT_FUNC_POINTERS;
void (GLApi *glPointParameterfvARB)(GLenum, float*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_point_parameters

int CGLExtensionHandler::n_GetPointParametersARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_point_parameters

	if(!(glPointParameterfARB = (void(GLApi*)(GLenum, float))wglGetProcAddress("glPointParameterfARB"))) ++ n_failed_functions;
	if(!(glPointParameterfvARB = (void(GLApi*)(GLenum, float*))wglGetProcAddress("glPointParameterfvARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_point_parameters

	GLEH_ARB_point_parameters = !n_failed_functions && b_SupportedExtension("GL_ARB_point_parameters");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_point_parameters ---
 */


/*
 *								--- GL_ARB_point_sprite ---
 */

bool GLEH_ARB_point_sprite = false;

int CGLExtensionHandler::n_GetPointSpriteARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_point_sprite = !n_failed_functions && b_SupportedExtension("GL_ARB_point_sprite");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_point_sprite ---
 */


/*
 *								--- GL_ARB_provoking_vertex ---
 */

bool GLEH_ARB_provoking_vertex = false;

#ifdef __GENERATE_GL_ARB_provoking_vertex

void (GLApi *glProvokingVertex)(GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_provoking_vertex

int CGLExtensionHandler::n_GetProvokingVertexARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_provoking_vertex

	if(!(glProvokingVertex = (void(GLApi*)(GLenum))wglGetProcAddress("glProvokingVertex"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_provoking_vertex

	GLEH_ARB_provoking_vertex = !n_failed_functions && b_SupportedExtension("GL_ARB_provoking_vertex");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_provoking_vertex ---
 */


/*
 *								--- GL_ARB_seamless_cube_map ---
 */

bool GLEH_ARB_seamless_cube_map = false;

int CGLExtensionHandler::n_GetSeamlessCubeMapARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_seamless_cube_map = !n_failed_functions && b_SupportedExtension("GL_ARB_seamless_cube_map");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_seamless_cube_map ---
 */


/*
 *								--- GL_ARB_shader_objects ---
 */

bool GLEH_ARB_shader_objects = false;

#ifdef __GENERATE_GL_ARB_shader_objects

void (GLApi *glDeleteObjectARB)(GLhandleARB) INIT_FUNC_POINTERS;
GLhandleARB (GLApi *glGetHandleARB)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glDetachObjectARB)(GLhandleARB, GLhandleARB) INIT_FUNC_POINTERS;
GLhandleARB (GLApi *glCreateShaderObjectARB)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glShaderSourceARB)(GLhandleARB, GLsizei, const GLcharARB**, const int*) INIT_FUNC_POINTERS;
void (GLApi *glCompileShaderARB)(GLhandleARB) INIT_FUNC_POINTERS;
GLhandleARB (GLApi *glCreateProgramObjectARB)() INIT_FUNC_POINTERS;
void (GLApi *glAttachObjectARB)(GLhandleARB, GLhandleARB) INIT_FUNC_POINTERS;
void (GLApi *glLinkProgramARB)(GLhandleARB) INIT_FUNC_POINTERS;
void (GLApi *glUseProgramObjectARB)(GLhandleARB) INIT_FUNC_POINTERS;
void (GLApi *glValidateProgramARB)(GLhandleARB) INIT_FUNC_POINTERS;
void (GLApi *glUniform1fARB)(int, float) INIT_FUNC_POINTERS;
void (GLApi *glUniform2fARB)(int, float, float) INIT_FUNC_POINTERS;
void (GLApi *glUniform3fARB)(int, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glUniform4fARB)(int, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glUniform1iARB)(int, int) INIT_FUNC_POINTERS;
void (GLApi *glUniform2iARB)(int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glUniform3iARB)(int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glUniform4iARB)(int, int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glUniform1fvARB)(int, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glUniform2fvARB)(int, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glUniform3fvARB)(int, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glUniform4fvARB)(int, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glUniform1ivARB)(int, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glUniform2ivARB)(int, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glUniform3ivARB)(int, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glUniform4ivARB)(int, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix2fvARB)(int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix3fvARB)(int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glUniformMatrix4fvARB)(int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glGetObjectParameterfvARB)(GLhandleARB, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetObjectParameterivARB)(GLhandleARB, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetInfoLogARB)(GLhandleARB, GLsizei, GLsizei*, GLcharARB*) INIT_FUNC_POINTERS;
void (GLApi *glGetAttachedObjectsARB)(GLhandleARB, GLsizei, GLsizei*, GLhandleARB*) INIT_FUNC_POINTERS;
int (GLApi *glGetUniformLocationARB)(GLhandleARB, const GLcharARB*) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveUniformARB)(GLhandleARB, GLuint, GLsizei, GLsizei*, int*, GLenum*, GLcharARB*) INIT_FUNC_POINTERS;
void (GLApi *glGetUniformfvARB)(GLhandleARB, int, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetUniformivARB)(GLhandleARB, int, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetShaderSourceARB)(GLhandleARB, GLsizei, GLsizei*, GLcharARB*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_shader_objects

int CGLExtensionHandler::n_GetShaderObjectsARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_shader_objects

	if(!(glDeleteObjectARB = (void(GLApi*)(GLhandleARB))wglGetProcAddress("glDeleteObjectARB"))) ++ n_failed_functions;
	if(!(glGetHandleARB = (GLhandleARB(GLApi*)(GLenum))wglGetProcAddress("glGetHandleARB"))) ++ n_failed_functions;
	if(!(glDetachObjectARB = (void(GLApi*)(GLhandleARB, GLhandleARB))wglGetProcAddress("glDetachObjectARB"))) ++ n_failed_functions;
	if(!(glCreateShaderObjectARB = (GLhandleARB(GLApi*)(GLenum))wglGetProcAddress("glCreateShaderObjectARB"))) ++ n_failed_functions;
	if(!(glShaderSourceARB = (void(GLApi*)(GLhandleARB, GLsizei, const GLcharARB**, const int*))wglGetProcAddress("glShaderSourceARB"))) ++ n_failed_functions;
	if(!(glCompileShaderARB = (void(GLApi*)(GLhandleARB))wglGetProcAddress("glCompileShaderARB"))) ++ n_failed_functions;
	if(!(glCreateProgramObjectARB = (GLhandleARB(GLApi*)())wglGetProcAddress("glCreateProgramObjectARB"))) ++ n_failed_functions;
	if(!(glAttachObjectARB = (void(GLApi*)(GLhandleARB, GLhandleARB))wglGetProcAddress("glAttachObjectARB"))) ++ n_failed_functions;
	if(!(glLinkProgramARB = (void(GLApi*)(GLhandleARB))wglGetProcAddress("glLinkProgramARB"))) ++ n_failed_functions;
	if(!(glUseProgramObjectARB = (void(GLApi*)(GLhandleARB))wglGetProcAddress("glUseProgramObjectARB"))) ++ n_failed_functions;
	if(!(glValidateProgramARB = (void(GLApi*)(GLhandleARB))wglGetProcAddress("glValidateProgramARB"))) ++ n_failed_functions;
	if(!(glUniform1fARB = (void(GLApi*)(int, float))wglGetProcAddress("glUniform1fARB"))) ++ n_failed_functions;
	if(!(glUniform2fARB = (void(GLApi*)(int, float, float))wglGetProcAddress("glUniform2fARB"))) ++ n_failed_functions;
	if(!(glUniform3fARB = (void(GLApi*)(int, float, float, float))wglGetProcAddress("glUniform3fARB"))) ++ n_failed_functions;
	if(!(glUniform4fARB = (void(GLApi*)(int, float, float, float, float))wglGetProcAddress("glUniform4fARB"))) ++ n_failed_functions;
	if(!(glUniform1iARB = (void(GLApi*)(int, int))wglGetProcAddress("glUniform1iARB"))) ++ n_failed_functions;
	if(!(glUniform2iARB = (void(GLApi*)(int, int, int))wglGetProcAddress("glUniform2iARB"))) ++ n_failed_functions;
	if(!(glUniform3iARB = (void(GLApi*)(int, int, int, int))wglGetProcAddress("glUniform3iARB"))) ++ n_failed_functions;
	if(!(glUniform4iARB = (void(GLApi*)(int, int, int, int, int))wglGetProcAddress("glUniform4iARB"))) ++ n_failed_functions;
	if(!(glUniform1fvARB = (void(GLApi*)(int, GLsizei, const float*))wglGetProcAddress("glUniform1fvARB"))) ++ n_failed_functions;
	if(!(glUniform2fvARB = (void(GLApi*)(int, GLsizei, const float*))wglGetProcAddress("glUniform2fvARB"))) ++ n_failed_functions;
	if(!(glUniform3fvARB = (void(GLApi*)(int, GLsizei, const float*))wglGetProcAddress("glUniform3fvARB"))) ++ n_failed_functions;
	if(!(glUniform4fvARB = (void(GLApi*)(int, GLsizei, const float*))wglGetProcAddress("glUniform4fvARB"))) ++ n_failed_functions;
	if(!(glUniform1ivARB = (void(GLApi*)(int, GLsizei, const int*))wglGetProcAddress("glUniform1ivARB"))) ++ n_failed_functions;
	if(!(glUniform2ivARB = (void(GLApi*)(int, GLsizei, const int*))wglGetProcAddress("glUniform2ivARB"))) ++ n_failed_functions;
	if(!(glUniform3ivARB = (void(GLApi*)(int, GLsizei, const int*))wglGetProcAddress("glUniform3ivARB"))) ++ n_failed_functions;
	if(!(glUniform4ivARB = (void(GLApi*)(int, GLsizei, const int*))wglGetProcAddress("glUniform4ivARB"))) ++ n_failed_functions;
	if(!(glUniformMatrix2fvARB = (void(GLApi*)(int, GLsizei, GLboolean, const float*))wglGetProcAddress("glUniformMatrix2fvARB"))) ++ n_failed_functions;
	if(!(glUniformMatrix3fvARB = (void(GLApi*)(int, GLsizei, GLboolean, const float*))wglGetProcAddress("glUniformMatrix3fvARB"))) ++ n_failed_functions;
	if(!(glUniformMatrix4fvARB = (void(GLApi*)(int, GLsizei, GLboolean, const float*))wglGetProcAddress("glUniformMatrix4fvARB"))) ++ n_failed_functions;
	if(!(glGetObjectParameterfvARB = (void(GLApi*)(GLhandleARB, GLenum, float*))wglGetProcAddress("glGetObjectParameterfvARB"))) ++ n_failed_functions;
	if(!(glGetObjectParameterivARB = (void(GLApi*)(GLhandleARB, GLenum, int*))wglGetProcAddress("glGetObjectParameterivARB"))) ++ n_failed_functions;
	if(!(glGetInfoLogARB = (void(GLApi*)(GLhandleARB, GLsizei, GLsizei*, GLcharARB*))wglGetProcAddress("glGetInfoLogARB"))) ++ n_failed_functions;
	if(!(glGetAttachedObjectsARB = (void(GLApi*)(GLhandleARB, GLsizei, GLsizei*, GLhandleARB*))wglGetProcAddress("glGetAttachedObjectsARB"))) ++ n_failed_functions;
	if(!(glGetUniformLocationARB = (int(GLApi*)(GLhandleARB, const GLcharARB*))wglGetProcAddress("glGetUniformLocationARB"))) ++ n_failed_functions;
	if(!(glGetActiveUniformARB = (void(GLApi*)(GLhandleARB, GLuint, GLsizei, GLsizei*, int*, GLenum*, GLcharARB*))wglGetProcAddress("glGetActiveUniformARB"))) ++ n_failed_functions;
	if(!(glGetUniformfvARB = (void(GLApi*)(GLhandleARB, int, float*))wglGetProcAddress("glGetUniformfvARB"))) ++ n_failed_functions;
	if(!(glGetUniformivARB = (void(GLApi*)(GLhandleARB, int, int*))wglGetProcAddress("glGetUniformivARB"))) ++ n_failed_functions;
	if(!(glGetShaderSourceARB = (void(GLApi*)(GLhandleARB, GLsizei, GLsizei*, GLcharARB*))wglGetProcAddress("glGetShaderSourceARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_shader_objects

	GLEH_ARB_shader_objects = !n_failed_functions && b_SupportedExtension("GL_ARB_shader_objects");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_shader_objects ---
 */


/*
 *								--- GL_ARB_shading_language_100 ---
 */

bool GLEH_ARB_shading_language_100 = false;

int CGLExtensionHandler::n_GetShadingLanguage100ARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_shading_language_100 = !n_failed_functions && b_SupportedExtension("GL_ARB_shading_language_100");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_shading_language_100 ---
 */


/*
 *								--- GL_ARB_shadow ---
 */

bool GLEH_ARB_shadow = false;

int CGLExtensionHandler::n_GetShadowARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_shadow = !n_failed_functions && b_SupportedExtension("GL_ARB_shadow");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_shadow ---
 */


/*
 *								--- GL_ARB_sync ---
 */

bool GLEH_ARB_sync = false;

#ifdef __GENERATE_GL_ARB_sync

GLsync (GLApi *glFenceSync)(GLenum, GLbitfield) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsSync)(GLsync) INIT_FUNC_POINTERS;
void (GLApi *glDeleteSync)(GLsync) INIT_FUNC_POINTERS;
GLenum (GLApi *glClientWaitSync)(GLsync, GLbitfield, GLuint64) INIT_FUNC_POINTERS;
void (GLApi *glWaitSync)(GLsync, GLbitfield, GLuint64) INIT_FUNC_POINTERS;
void (GLApi *glGetInteger64v)(GLenum, GLint64*) INIT_FUNC_POINTERS;
void (GLApi *glGetSynciv)(GLsync, GLenum, GLsizei, GLsizei*, int*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_sync

int CGLExtensionHandler::n_GetSyncARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_sync

	if(!(glFenceSync = (GLsync(GLApi*)(GLenum, GLbitfield))wglGetProcAddress("glFenceSync"))) ++ n_failed_functions;
	if(!(glIsSync = (GLboolean(GLApi*)(GLsync))wglGetProcAddress("glIsSync"))) ++ n_failed_functions;
	if(!(glDeleteSync = (void(GLApi*)(GLsync))wglGetProcAddress("glDeleteSync"))) ++ n_failed_functions;
	if(!(glClientWaitSync = (GLenum(GLApi*)(GLsync, GLbitfield, GLuint64))wglGetProcAddress("glClientWaitSync"))) ++ n_failed_functions;
	if(!(glWaitSync = (void(GLApi*)(GLsync, GLbitfield, GLuint64))wglGetProcAddress("glWaitSync"))) ++ n_failed_functions;
	if(!(glGetInteger64v = (void(GLApi*)(GLenum, GLint64*))wglGetProcAddress("glGetInteger64v"))) ++ n_failed_functions;
	if(!(glGetSynciv = (void(GLApi*)(GLsync, GLenum, GLsizei, GLsizei*, int*))wglGetProcAddress("glGetSynciv"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_sync

	GLEH_ARB_sync = !n_failed_functions && b_SupportedExtension("GL_ARB_sync");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_sync ---
 */


/*
 *								--- GL_ARB_texture_border_clamp ---
 */

bool GLEH_ARB_texture_border_clamp = false;

int CGLExtensionHandler::n_GetTextureBorderClampARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_border_clamp = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_border_clamp");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_border_clamp ---
 */


/*
 *								--- GL_ARB_texture_buffer_object ---
 */

bool GLEH_ARB_texture_buffer_object = false;

#ifdef __GENERATE_GL_ARB_texture_buffer_object

void (GLApi *glTexBufferARB)(GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_texture_buffer_object

int CGLExtensionHandler::n_GetTextureBufferObjectARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_texture_buffer_object

	if(!(glTexBufferARB = (void(GLApi*)(GLenum, GLenum, GLuint))wglGetProcAddress("glTexBufferARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_texture_buffer_object

	GLEH_ARB_texture_buffer_object = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_buffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_buffer_object ---
 */


/*
 *								--- GL_ARB_texture_compression ---
 */

bool GLEH_ARB_texture_compression = false;

#ifdef __GENERATE_GL_ARB_texture_compression

void (GLApi *glCompressedTexImage3DARB)(GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexImage2DARB)(GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexImage1DARB)(GLenum, int, GLenum, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexSubImage3DARB)(GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexSubImage2DARB)(GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTexSubImage1DARB)(GLenum, int, int, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glGetCompressedTexImageARB)(GLenum, int, void*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_texture_compression

int CGLExtensionHandler::n_GetTextureCompressionARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_texture_compression

	if(!(glCompressedTexImage3DARB = (void(GLApi*)(GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedTexImage3DARB"))) ++ n_failed_functions;
	if(!(glCompressedTexImage2DARB = (void(GLApi*)(GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedTexImage2DARB"))) ++ n_failed_functions;
	if(!(glCompressedTexImage1DARB = (void(GLApi*)(GLenum, int, GLenum, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedTexImage1DARB"))) ++ n_failed_functions;
	if(!(glCompressedTexSubImage3DARB = (void(GLApi*)(GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedTexSubImage3DARB"))) ++ n_failed_functions;
	if(!(glCompressedTexSubImage2DARB = (void(GLApi*)(GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedTexSubImage2DARB"))) ++ n_failed_functions;
	if(!(glCompressedTexSubImage1DARB = (void(GLApi*)(GLenum, int, int, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedTexSubImage1DARB"))) ++ n_failed_functions;
	if(!(glGetCompressedTexImageARB = (void(GLApi*)(GLenum, int, void*))wglGetProcAddress("glGetCompressedTexImageARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_texture_compression

	GLEH_ARB_texture_compression = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_compression");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_compression ---
 */


/*
 *								--- GL_ARB_texture_compression_rgtc ---
 */

bool GLEH_ARB_texture_compression_rgtc = false;

int CGLExtensionHandler::n_GetTextureCompressionRgtcARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_compression_rgtc = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_compression_rgtc");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_compression_rgtc ---
 */


/*
 *								--- GL_ARB_texture_cube_map ---
 */

bool GLEH_ARB_texture_cube_map = false;

int CGLExtensionHandler::n_GetTextureCubeMapARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_cube_map = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_cube_map");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_cube_map ---
 */


/*
 *								--- GL_ARB_texture_env_add ---
 */

bool GLEH_ARB_texture_env_add = false;

int CGLExtensionHandler::n_GetTextureEnvAddARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_env_add = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_env_add");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_env_add ---
 */


/*
 *								--- GL_ARB_texture_env_combine ---
 */

bool GLEH_ARB_texture_env_combine = false;

int CGLExtensionHandler::n_GetTextureEnvCombineARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_env_combine = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_env_combine");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_env_combine ---
 */


/*
 *								--- GL_ARB_texture_env_dot3 ---
 */

bool GLEH_ARB_texture_env_dot3 = false;

int CGLExtensionHandler::n_GetTextureEnvDot3ARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_env_dot3 = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_env_dot3");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_env_dot3 ---
 */


/*
 *								--- GL_ARB_texture_float ---
 */

bool GLEH_ARB_texture_float = false;

int CGLExtensionHandler::n_GetTextureFloatARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_float = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_float");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_float ---
 */


/*
 *								--- GL_ARB_texture_mirrored_repeat ---
 */

bool GLEH_ARB_texture_mirrored_repeat = false;

int CGLExtensionHandler::n_GetTextureMirroredRepeatARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_mirrored_repeat = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_mirrored_repeat");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_mirrored_repeat ---
 */


/*
 *								--- GL_ARB_texture_multisample ---
 */

bool GLEH_ARB_texture_multisample = false;

#ifdef __GENERATE_GL_ARB_texture_multisample

void (GLApi *glTexImage2DMultisample)(GLenum, GLsizei, int, GLsizei, GLsizei, GLboolean) INIT_FUNC_POINTERS;
void (GLApi *glTexImage3DMultisample)(GLenum, GLsizei, int, GLsizei, GLsizei, GLsizei, GLboolean) INIT_FUNC_POINTERS;
void (GLApi *glGetMultisamplefv)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glSampleMaski)(GLuint, GLbitfield) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_texture_multisample

int CGLExtensionHandler::n_GetTextureMultisampleARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_texture_multisample

	if(!(glTexImage2DMultisample = (void(GLApi*)(GLenum, GLsizei, int, GLsizei, GLsizei, GLboolean))wglGetProcAddress("glTexImage2DMultisample"))) ++ n_failed_functions;
	if(!(glTexImage3DMultisample = (void(GLApi*)(GLenum, GLsizei, int, GLsizei, GLsizei, GLsizei, GLboolean))wglGetProcAddress("glTexImage3DMultisample"))) ++ n_failed_functions;
	if(!(glGetMultisamplefv = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetMultisamplefv"))) ++ n_failed_functions;
	if(!(glSampleMaski = (void(GLApi*)(GLuint, GLbitfield))wglGetProcAddress("glSampleMaski"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_texture_multisample

	GLEH_ARB_texture_multisample = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_multisample");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_multisample ---
 */


/*
 *								--- GL_ARB_texture_non_power_of_two ---
 */

bool GLEH_ARB_texture_non_power_of_two = false;

int CGLExtensionHandler::n_GetTextureNonPowerOfTwoARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_non_power_of_two = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_non_power_of_two");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_non_power_of_two ---
 */


/*
 *								--- GL_ARB_texture_rectangle ---
 */

bool GLEH_ARB_texture_rectangle = false;

int CGLExtensionHandler::n_GetTextureRectangleARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_rectangle = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_rectangle");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_rectangle ---
 */


/*
 *								--- GL_ARB_texture_rg ---
 */

bool GLEH_ARB_texture_rg = false;

int CGLExtensionHandler::n_GetTextureRgARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_texture_rg = !n_failed_functions && b_SupportedExtension("GL_ARB_texture_rg");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_texture_rg ---
 */


/*
 *								--- GL_ARB_transpose_matrix ---
 */

bool GLEH_ARB_transpose_matrix = false;

#ifdef __GENERATE_GL_ARB_transpose_matrix

void (GLApi *glLoadTransposeMatrixfARB)(float*) INIT_FUNC_POINTERS;
void (GLApi *glLoadTransposeMatrixdARB)(double*) INIT_FUNC_POINTERS;
void (GLApi *glMultTransposeMatrixfARB)(float*) INIT_FUNC_POINTERS;
void (GLApi *glMultTransposeMatrixdARB)(double*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_transpose_matrix

int CGLExtensionHandler::n_GetTransposeMatrixARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_transpose_matrix

	if(!(glLoadTransposeMatrixfARB = (void(GLApi*)(float*))wglGetProcAddress("glLoadTransposeMatrixfARB"))) ++ n_failed_functions;
	if(!(glLoadTransposeMatrixdARB = (void(GLApi*)(double*))wglGetProcAddress("glLoadTransposeMatrixdARB"))) ++ n_failed_functions;
	if(!(glMultTransposeMatrixfARB = (void(GLApi*)(float*))wglGetProcAddress("glMultTransposeMatrixfARB"))) ++ n_failed_functions;
	if(!(glMultTransposeMatrixdARB = (void(GLApi*)(double*))wglGetProcAddress("glMultTransposeMatrixdARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_transpose_matrix

	GLEH_ARB_transpose_matrix = !n_failed_functions && b_SupportedExtension("GL_ARB_transpose_matrix");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_transpose_matrix ---
 */


/*
 *								--- GL_ARB_uniform_buffer_object ---
 */

bool GLEH_ARB_uniform_buffer_object = false;

#ifdef __GENERATE_GL_ARB_uniform_buffer_object

void (GLApi *glGetUniformIndices)(GLuint, GLsizei, const GLchar**, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveUniformsiv)(GLuint, GLsizei, const GLuint*, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveUniformName)(GLuint, GLuint, GLsizei, GLsizei*, GLchar*) INIT_FUNC_POINTERS;
GLuint (GLApi *glGetUniformBlockIndex)(GLuint, const GLchar*) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveUniformBlockiv)(GLuint, GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveUniformBlockName)(GLuint, GLuint, GLsizei, GLsizei*, GLchar*) INIT_FUNC_POINTERS;
void (GLApi *glBindBufferRange)(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr) INIT_FUNC_POINTERS;
void (GLApi *glBindBufferBase)(GLenum, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetIntegeri_v)(GLenum, GLuint, int*) INIT_FUNC_POINTERS;
void (GLApi *glUniformBlockBinding)(GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_uniform_buffer_object

int CGLExtensionHandler::n_GetUniformBufferObjectARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_uniform_buffer_object

	if(!(glGetUniformIndices = (void(GLApi*)(GLuint, GLsizei, const GLchar**, GLuint*))wglGetProcAddress("glGetUniformIndices"))) ++ n_failed_functions;
	if(!(glGetActiveUniformsiv = (void(GLApi*)(GLuint, GLsizei, const GLuint*, GLenum, int*))wglGetProcAddress("glGetActiveUniformsiv"))) ++ n_failed_functions;
	if(!(glGetActiveUniformName = (void(GLApi*)(GLuint, GLuint, GLsizei, GLsizei*, GLchar*))wglGetProcAddress("glGetActiveUniformName"))) ++ n_failed_functions;
	if(!(glGetUniformBlockIndex = (GLuint(GLApi*)(GLuint, const GLchar*))wglGetProcAddress("glGetUniformBlockIndex"))) ++ n_failed_functions;
	if(!(glGetActiveUniformBlockiv = (void(GLApi*)(GLuint, GLuint, GLenum, int*))wglGetProcAddress("glGetActiveUniformBlockiv"))) ++ n_failed_functions;
	if(!(glGetActiveUniformBlockName = (void(GLApi*)(GLuint, GLuint, GLsizei, GLsizei*, GLchar*))wglGetProcAddress("glGetActiveUniformBlockName"))) ++ n_failed_functions;
	if(!(glBindBufferRange = (void(GLApi*)(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr))wglGetProcAddress("glBindBufferRange"))) ++ n_failed_functions;
	if(!(glBindBufferBase = (void(GLApi*)(GLenum, GLuint, GLuint))wglGetProcAddress("glBindBufferBase"))) ++ n_failed_functions;
	if(!(glGetIntegeri_v = (void(GLApi*)(GLenum, GLuint, int*))wglGetProcAddress("glGetIntegeri_v"))) ++ n_failed_functions;
	if(!(glUniformBlockBinding = (void(GLApi*)(GLuint, GLuint, GLuint))wglGetProcAddress("glUniformBlockBinding"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_uniform_buffer_object

	GLEH_ARB_uniform_buffer_object = !n_failed_functions && b_SupportedExtension("GL_ARB_uniform_buffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_uniform_buffer_object ---
 */


/*
 *								--- GL_ARB_vertex_array_bgra ---
 */

bool GLEH_ARB_vertex_array_bgra = false;

int CGLExtensionHandler::n_GetVertexArrayBgraARBFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ARB_vertex_array_bgra = !n_failed_functions && b_SupportedExtension("GL_ARB_vertex_array_bgra");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_vertex_array_bgra ---
 */


/*
 *								--- GL_ARB_vertex_array_object ---
 */

bool GLEH_ARB_vertex_array_object = false;

#ifdef __GENERATE_GL_ARB_vertex_array_object

void (GLApi *glBindVertexArray)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteVertexArrays)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenVertexArrays)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsVertexArray)(GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_vertex_array_object

int CGLExtensionHandler::n_GetVertexArrayObjectARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_vertex_array_object

	if(!(glBindVertexArray = (void(GLApi*)(GLuint))wglGetProcAddress("glBindVertexArray"))) ++ n_failed_functions;
	if(!(glDeleteVertexArrays = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteVertexArrays"))) ++ n_failed_functions;
	if(!(glGenVertexArrays = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenVertexArrays"))) ++ n_failed_functions;
	if(!(glIsVertexArray = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsVertexArray"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_vertex_array_object

	GLEH_ARB_vertex_array_object = !n_failed_functions && b_SupportedExtension("GL_ARB_vertex_array_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_vertex_array_object ---
 */


/*
 *								--- GL_ARB_vertex_buffer_object ---
 */

bool GLEH_ARB_vertex_buffer_object = false;

#ifdef __GENERATE_GL_ARB_vertex_buffer_object

void (GLApi *glBindBufferARB)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteBuffersARB)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenBuffersARB)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsBufferARB)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBufferDataARB)(GLenum, GLsizeiptrARB, const void*, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glBufferSubDataARB)(GLenum, GLintptrARB, GLsizeiptrARB, const void*) INIT_FUNC_POINTERS;
void (GLApi *glGetBufferSubDataARB)(GLenum, GLintptrARB, GLsizeiptrARB, void*) INIT_FUNC_POINTERS;
void* (GLApi *glMapBufferARB)(GLenum, GLenum) INIT_FUNC_POINTERS;
GLboolean (GLApi *glUnmapBufferARB)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glGetBufferParameterivARB)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetBufferPointervARB)(GLenum, GLenum, void**) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_vertex_buffer_object

int CGLExtensionHandler::n_GetVertexBufferObjectARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_vertex_buffer_object

	if(!(glBindBufferARB = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindBufferARB"))) ++ n_failed_functions;
	if(!(glDeleteBuffersARB = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteBuffersARB"))) ++ n_failed_functions;
	if(!(glGenBuffersARB = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenBuffersARB"))) ++ n_failed_functions;
	if(!(glIsBufferARB = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsBufferARB"))) ++ n_failed_functions;
	if(!(glBufferDataARB = (void(GLApi*)(GLenum, GLsizeiptrARB, const void*, GLenum))wglGetProcAddress("glBufferDataARB"))) ++ n_failed_functions;
	if(!(glBufferSubDataARB = (void(GLApi*)(GLenum, GLintptrARB, GLsizeiptrARB, const void*))wglGetProcAddress("glBufferSubDataARB"))) ++ n_failed_functions;
	if(!(glGetBufferSubDataARB = (void(GLApi*)(GLenum, GLintptrARB, GLsizeiptrARB, void*))wglGetProcAddress("glGetBufferSubDataARB"))) ++ n_failed_functions;
	if(!(glMapBufferARB = (void*(GLApi*)(GLenum, GLenum))wglGetProcAddress("glMapBufferARB"))) ++ n_failed_functions;
	if(!(glUnmapBufferARB = (GLboolean(GLApi*)(GLenum))wglGetProcAddress("glUnmapBufferARB"))) ++ n_failed_functions;
	if(!(glGetBufferParameterivARB = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glGetBufferParameterivARB"))) ++ n_failed_functions;
	if(!(glGetBufferPointervARB = (void(GLApi*)(GLenum, GLenum, void**))wglGetProcAddress("glGetBufferPointervARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_vertex_buffer_object

	GLEH_ARB_vertex_buffer_object = !n_failed_functions && b_SupportedExtension("GL_ARB_vertex_buffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_vertex_buffer_object ---
 */


/*
 *								--- GL_ARB_vertex_program ---
 */

bool GLEH_ARB_vertex_program = false;

#ifdef __GENERATE_GL_ARB_vertex_program

void (GLApi *glVertexAttrib1sARB)(GLuint, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1fARB)(GLuint, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1dARB)(GLuint, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2sARB)(GLuint, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2fARB)(GLuint, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2dARB)(GLuint, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3sARB)(GLuint, short, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3fARB)(GLuint, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3dARB)(GLuint, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4sARB)(GLuint, short, short, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4fARB)(GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4dARB)(GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NubARB)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1svARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1fvARB)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1dvARB)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2svARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2fvARB)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2dvARB)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3svARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3fvARB)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3dvARB)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4bvARB)(GLuint, const GLbyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4svARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4ivARB)(GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4ubvARB)(GLuint, const GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4usvARB)(GLuint, const GLushort*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4uivARB)(GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4fvARB)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4dvARB)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NbvARB)(GLuint, const GLbyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NsvARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NivARB)(GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NubvARB)(GLuint, const GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NusvARB)(GLuint, const GLushort*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NuivARB)(GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribPointerARB)(GLuint, int, GLenum, GLboolean, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glEnableVertexAttribArrayARB)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDisableVertexAttribArrayARB)(GLuint) INIT_FUNC_POINTERS;
/*void (GLApi *glProgramStringARB)(GLenum, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glBindProgramARB)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteProgramsARB)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenProgramsARB)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameter4dARB)(GLenum, GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameter4dvARB)(GLenum, GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameter4fARB)(GLenum, GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameter4fvARB)(GLenum, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4dARB)(GLenum, GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4dvARB)(GLenum, GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4fARB)(GLenum, GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4fvARB)(GLenum, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramEnvParameterdvARB)(GLenum, GLuint, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramEnvParameterfvARB)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramLocalParameterdvARB)(GLenum, GLuint, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramLocalParameterfvARB)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramivARB)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramStringARB)(GLenum, GLenum, void*) INIT_FUNC_POINTERS;*/
void (GLApi *glGetVertexAttribdvARB)(GLuint, GLenum, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribfvARB)(GLuint, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribivARB)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribPointervARB)(GLuint, GLenum, void**) INIT_FUNC_POINTERS;
//GLboolean (GLApi *glIsProgramARB)(GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_vertex_program

int CGLExtensionHandler::n_GetVertexProgramARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_vertex_program

	if(!(glVertexAttrib1sARB = (void(GLApi*)(GLuint, short))wglGetProcAddress("glVertexAttrib1sARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1fARB = (void(GLApi*)(GLuint, float))wglGetProcAddress("glVertexAttrib1fARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1dARB = (void(GLApi*)(GLuint, double))wglGetProcAddress("glVertexAttrib1dARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2sARB = (void(GLApi*)(GLuint, short, short))wglGetProcAddress("glVertexAttrib2sARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2fARB = (void(GLApi*)(GLuint, float, float))wglGetProcAddress("glVertexAttrib2fARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2dARB = (void(GLApi*)(GLuint, double, double))wglGetProcAddress("glVertexAttrib2dARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3sARB = (void(GLApi*)(GLuint, short, short, short))wglGetProcAddress("glVertexAttrib3sARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3fARB = (void(GLApi*)(GLuint, float, float, float))wglGetProcAddress("glVertexAttrib3fARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3dARB = (void(GLApi*)(GLuint, double, double, double))wglGetProcAddress("glVertexAttrib3dARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4sARB = (void(GLApi*)(GLuint, short, short, short, short))wglGetProcAddress("glVertexAttrib4sARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4fARB = (void(GLApi*)(GLuint, float, float, float, float))wglGetProcAddress("glVertexAttrib4fARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4dARB = (void(GLApi*)(GLuint, double, double, double, double))wglGetProcAddress("glVertexAttrib4dARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NubARB = (void(GLApi*)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte))wglGetProcAddress("glVertexAttrib4NubARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1svARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib1svARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1fvARB = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib1fvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1dvARB = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib1dvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2svARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib2svARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2fvARB = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib2fvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2dvARB = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib2dvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3svARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib3svARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3fvARB = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib3fvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3dvARB = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib3dvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4bvARB = (void(GLApi*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4bvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4svARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4svARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4ivARB = (void(GLApi*)(GLuint, const int*))wglGetProcAddress("glVertexAttrib4ivARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4ubvARB = (void(GLApi*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4ubvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4usvARB = (void(GLApi*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4usvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4uivARB = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4uivARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4fvARB = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib4fvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4dvARB = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib4dvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NbvARB = (void(GLApi*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4NbvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NsvARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4NsvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NivARB = (void(GLApi*)(GLuint, const int*))wglGetProcAddress("glVertexAttrib4NivARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NubvARB = (void(GLApi*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4NubvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NusvARB = (void(GLApi*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4NusvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NuivARB = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4NuivARB"))) ++ n_failed_functions;
	if(!(glVertexAttribPointerARB = (void(GLApi*)(GLuint, int, GLenum, GLboolean, GLsizei, const void*))wglGetProcAddress("glVertexAttribPointerARB"))) ++ n_failed_functions;
	if(!(glEnableVertexAttribArrayARB = (void(GLApi*)(GLuint))wglGetProcAddress("glEnableVertexAttribArrayARB"))) ++ n_failed_functions;
	if(!(glDisableVertexAttribArrayARB = (void(GLApi*)(GLuint))wglGetProcAddress("glDisableVertexAttribArrayARB"))) ++ n_failed_functions;
	if(!(glProgramStringARB = (void(GLApi*)(GLenum, GLenum, GLsizei, const void*))wglGetProcAddress("glProgramStringARB"))) ++ n_failed_functions;
	if(!(glBindProgramARB = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindProgramARB"))) ++ n_failed_functions;
	if(!(glDeleteProgramsARB = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteProgramsARB"))) ++ n_failed_functions;
	if(!(glGenProgramsARB = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenProgramsARB"))) ++ n_failed_functions;
	if(!(glProgramEnvParameter4dARB = (void(GLApi*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramEnvParameter4dARB"))) ++ n_failed_functions;
	if(!(glProgramEnvParameter4dvARB = (void(GLApi*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramEnvParameter4dvARB"))) ++ n_failed_functions;
	if(!(glProgramEnvParameter4fARB = (void(GLApi*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramEnvParameter4fARB"))) ++ n_failed_functions;
	if(!(glProgramEnvParameter4fvARB = (void(GLApi*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramEnvParameter4fvARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4dARB = (void(GLApi*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramLocalParameter4dARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4dvARB = (void(GLApi*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramLocalParameter4dvARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4fARB = (void(GLApi*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramLocalParameter4fARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4fvARB = (void(GLApi*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramLocalParameter4fvARB"))) ++ n_failed_functions;
	if(!(glGetProgramEnvParameterdvARB = (void(GLApi*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramEnvParameterdvARB"))) ++ n_failed_functions;
	if(!(glGetProgramEnvParameterfvARB = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramEnvParameterfvARB"))) ++ n_failed_functions;
	if(!(glGetProgramLocalParameterdvARB = (void(GLApi*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramLocalParameterdvARB"))) ++ n_failed_functions;
	if(!(glGetProgramLocalParameterfvARB = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramLocalParameterfvARB"))) ++ n_failed_functions;
	if(!(glGetProgramivARB = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glGetProgramivARB"))) ++ n_failed_functions;
	if(!(glGetProgramStringARB = (void(GLApi*)(GLenum, GLenum, void*))wglGetProcAddress("glGetProgramStringARB"))) ++ n_failed_functions;
	if(!(glGetVertexAttribdvARB = (void(GLApi*)(GLuint, GLenum, double*))wglGetProcAddress("glGetVertexAttribdvARB"))) ++ n_failed_functions;
	if(!(glGetVertexAttribfvARB = (void(GLApi*)(GLuint, GLenum, float*))wglGetProcAddress("glGetVertexAttribfvARB"))) ++ n_failed_functions;
	if(!(glGetVertexAttribivARB = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetVertexAttribivARB"))) ++ n_failed_functions;
	if(!(glGetVertexAttribPointervARB = (void(GLApi*)(GLuint, GLenum, void**))wglGetProcAddress("glGetVertexAttribPointervARB"))) ++ n_failed_functions;
	if(!(glIsProgramARB = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsProgramARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_vertex_program

	GLEH_ARB_vertex_program = !n_failed_functions && b_SupportedExtension("GL_ARB_vertex_program");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_vertex_program ---
 */


/*
 *								--- GL_ARB_vertex_shader ---
 */

bool GLEH_ARB_vertex_shader = false;

#ifdef __GENERATE_GL_ARB_vertex_shader

/*void (GLApi *glVertexAttrib1fARB)(GLuint, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1sARB)(GLuint, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1dARB)(GLuint, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2fARB)(GLuint, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2sARB)(GLuint, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2dARB)(GLuint, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3fARB)(GLuint, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3sARB)(GLuint, short, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3dARB)(GLuint, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4fARB)(GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4sARB)(GLuint, short, short, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4dARB)(GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NubARB)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1fvARB)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1svARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1dvARB)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2fvARB)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2svARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2dvARB)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3fvARB)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3svARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3dvARB)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4fvARB)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4svARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4dvARB)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4ivARB)(GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4bvARB)(GLuint, const GLbyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4ubvARB)(GLuint, const GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4usvARB)(GLuint, const GLushort*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4uivARB)(GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NbvARB)(GLuint, const GLbyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NsvARB)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NivARB)(GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NubvARB)(GLuint, const GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NusvARB)(GLuint, const GLushort*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4NuivARB)(GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribPointerARB)(GLuint, int, GLenum, GLboolean, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glEnableVertexAttribArrayARB)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDisableVertexAttribArrayARB)(GLuint) INIT_FUNC_POINTERS;*/
void (GLApi *glBindAttribLocationARB)(GLhandleARB, GLuint, const GLcharARB*) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveAttribARB)(GLhandleARB, GLuint, GLsizei, GLsizei*, int*, GLenum*, GLcharARB*) INIT_FUNC_POINTERS;
int (GLApi *glGetAttribLocationARB)(GLhandleARB, const GLcharARB*) INIT_FUNC_POINTERS;
/*void (GLApi *glGetVertexAttribdvARB)(GLuint, GLenum, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribfvARB)(GLuint, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribivARB)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribPointervARB)(GLuint, GLenum, void**) INIT_FUNC_POINTERS;*/

#endif // __GENERATE_GL_ARB_vertex_shader

int CGLExtensionHandler::n_GetVertexShaderARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_vertex_shader

	if(!(glVertexAttrib1fARB = (void(GLApi*)(GLuint, float))wglGetProcAddress("glVertexAttrib1fARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1sARB = (void(GLApi*)(GLuint, short))wglGetProcAddress("glVertexAttrib1sARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1dARB = (void(GLApi*)(GLuint, double))wglGetProcAddress("glVertexAttrib1dARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2fARB = (void(GLApi*)(GLuint, float, float))wglGetProcAddress("glVertexAttrib2fARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2sARB = (void(GLApi*)(GLuint, short, short))wglGetProcAddress("glVertexAttrib2sARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2dARB = (void(GLApi*)(GLuint, double, double))wglGetProcAddress("glVertexAttrib2dARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3fARB = (void(GLApi*)(GLuint, float, float, float))wglGetProcAddress("glVertexAttrib3fARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3sARB = (void(GLApi*)(GLuint, short, short, short))wglGetProcAddress("glVertexAttrib3sARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3dARB = (void(GLApi*)(GLuint, double, double, double))wglGetProcAddress("glVertexAttrib3dARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4fARB = (void(GLApi*)(GLuint, float, float, float, float))wglGetProcAddress("glVertexAttrib4fARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4sARB = (void(GLApi*)(GLuint, short, short, short, short))wglGetProcAddress("glVertexAttrib4sARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4dARB = (void(GLApi*)(GLuint, double, double, double, double))wglGetProcAddress("glVertexAttrib4dARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NubARB = (void(GLApi*)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte))wglGetProcAddress("glVertexAttrib4NubARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1fvARB = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib1fvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1svARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib1svARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib1dvARB = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib1dvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2fvARB = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib2fvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2svARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib2svARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib2dvARB = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib2dvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3fvARB = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib3fvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3svARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib3svARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib3dvARB = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib3dvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4fvARB = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib4fvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4svARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4svARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4dvARB = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib4dvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4ivARB = (void(GLApi*)(GLuint, const int*))wglGetProcAddress("glVertexAttrib4ivARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4bvARB = (void(GLApi*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4bvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4ubvARB = (void(GLApi*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4ubvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4usvARB = (void(GLApi*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4usvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4uivARB = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4uivARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NbvARB = (void(GLApi*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4NbvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NsvARB = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4NsvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NivARB = (void(GLApi*)(GLuint, const int*))wglGetProcAddress("glVertexAttrib4NivARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NubvARB = (void(GLApi*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4NubvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NusvARB = (void(GLApi*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4NusvARB"))) ++ n_failed_functions;
	if(!(glVertexAttrib4NuivARB = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4NuivARB"))) ++ n_failed_functions;
	if(!(glVertexAttribPointerARB = (void(GLApi*)(GLuint, int, GLenum, GLboolean, GLsizei, const void*))wglGetProcAddress("glVertexAttribPointerARB"))) ++ n_failed_functions;
	if(!(glEnableVertexAttribArrayARB = (void(GLApi*)(GLuint))wglGetProcAddress("glEnableVertexAttribArrayARB"))) ++ n_failed_functions;
	if(!(glDisableVertexAttribArrayARB = (void(GLApi*)(GLuint))wglGetProcAddress("glDisableVertexAttribArrayARB"))) ++ n_failed_functions;
	if(!(glBindAttribLocationARB = (void(GLApi*)(GLhandleARB, GLuint, const GLcharARB*))wglGetProcAddress("glBindAttribLocationARB"))) ++ n_failed_functions;
	if(!(glGetActiveAttribARB = (void(GLApi*)(GLhandleARB, GLuint, GLsizei, GLsizei*, int*, GLenum*, GLcharARB*))wglGetProcAddress("glGetActiveAttribARB"))) ++ n_failed_functions;
	if(!(glGetAttribLocationARB = (int(GLApi*)(GLhandleARB, const GLcharARB*))wglGetProcAddress("glGetAttribLocationARB"))) ++ n_failed_functions;
	if(!(glGetVertexAttribdvARB = (void(GLApi*)(GLuint, GLenum, double*))wglGetProcAddress("glGetVertexAttribdvARB"))) ++ n_failed_functions;
	if(!(glGetVertexAttribfvARB = (void(GLApi*)(GLuint, GLenum, float*))wglGetProcAddress("glGetVertexAttribfvARB"))) ++ n_failed_functions;
	if(!(glGetVertexAttribivARB = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetVertexAttribivARB"))) ++ n_failed_functions;
	if(!(glGetVertexAttribPointervARB = (void(GLApi*)(GLuint, GLenum, void**))wglGetProcAddress("glGetVertexAttribPointervARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_vertex_shader

	GLEH_ARB_vertex_shader = !n_failed_functions && b_SupportedExtension("GL_ARB_vertex_shader");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_vertex_shader ---
 */


/*
 *								--- GL_ARB_window_pos ---
 */

bool GLEH_ARB_window_pos = false;

#ifdef __GENERATE_GL_ARB_window_pos

void (GLApi *glWindowPos2dARB)(double, double) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2fARB)(float, float) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2iARB)(int, int) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2sARB)(short, short) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2dvARB)(const double*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2fvARB)(const float*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2ivARB)(const int*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos2svARB)(const short*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3dARB)(double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3fARB)(float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3iARB)(int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3sARB)(short, short, short) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3dvARB)(const double*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3fvARB)(const float*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3ivARB)(const int*) INIT_FUNC_POINTERS;
void (GLApi *glWindowPos3svARB)(const short*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_window_pos

int CGLExtensionHandler::n_GetWindowPosARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_window_pos

	if(!(glWindowPos2dARB = (void(GLApi*)(double, double))wglGetProcAddress("glWindowPos2dARB"))) ++ n_failed_functions;
	if(!(glWindowPos2fARB = (void(GLApi*)(float, float))wglGetProcAddress("glWindowPos2fARB"))) ++ n_failed_functions;
	if(!(glWindowPos2iARB = (void(GLApi*)(int, int))wglGetProcAddress("glWindowPos2iARB"))) ++ n_failed_functions;
	if(!(glWindowPos2sARB = (void(GLApi*)(short, short))wglGetProcAddress("glWindowPos2sARB"))) ++ n_failed_functions;
	if(!(glWindowPos2dvARB = (void(GLApi*)(const double*))wglGetProcAddress("glWindowPos2dvARB"))) ++ n_failed_functions;
	if(!(glWindowPos2fvARB = (void(GLApi*)(const float*))wglGetProcAddress("glWindowPos2fvARB"))) ++ n_failed_functions;
	if(!(glWindowPos2ivARB = (void(GLApi*)(const int*))wglGetProcAddress("glWindowPos2ivARB"))) ++ n_failed_functions;
	if(!(glWindowPos2svARB = (void(GLApi*)(const short*))wglGetProcAddress("glWindowPos2svARB"))) ++ n_failed_functions;
	if(!(glWindowPos3dARB = (void(GLApi*)(double, double, double))wglGetProcAddress("glWindowPos3dARB"))) ++ n_failed_functions;
	if(!(glWindowPos3fARB = (void(GLApi*)(float, float, float))wglGetProcAddress("glWindowPos3fARB"))) ++ n_failed_functions;
	if(!(glWindowPos3iARB = (void(GLApi*)(int, int, int))wglGetProcAddress("glWindowPos3iARB"))) ++ n_failed_functions;
	if(!(glWindowPos3sARB = (void(GLApi*)(short, short, short))wglGetProcAddress("glWindowPos3sARB"))) ++ n_failed_functions;
	if(!(glWindowPos3dvARB = (void(GLApi*)(const double*))wglGetProcAddress("glWindowPos3dvARB"))) ++ n_failed_functions;
	if(!(glWindowPos3fvARB = (void(GLApi*)(const float*))wglGetProcAddress("glWindowPos3fvARB"))) ++ n_failed_functions;
	if(!(glWindowPos3ivARB = (void(GLApi*)(const int*))wglGetProcAddress("glWindowPos3ivARB"))) ++ n_failed_functions;
	if(!(glWindowPos3svARB = (void(GLApi*)(const short*))wglGetProcAddress("glWindowPos3svARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_window_pos

	GLEH_ARB_window_pos = !n_failed_functions && b_SupportedExtension("GL_ARB_window_pos");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_window_pos ---
 */


/*
 *								--- GL_ATI_draw_buffers ---
 */

bool GLEH_ATI_draw_buffers = false;

#ifdef __GENERATE_GL_ATI_draw_buffers

void (GLApi *glDrawBuffersATI)(GLsizei, const GLenum*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ATI_draw_buffers

int CGLExtensionHandler::n_GetDrawBuffersATIFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ATI_draw_buffers

	if(!(glDrawBuffersATI = (void(GLApi*)(GLsizei, const GLenum*))wglGetProcAddress("glDrawBuffersATI"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ATI_draw_buffers

	GLEH_ATI_draw_buffers = !n_failed_functions && b_SupportedExtension("GL_ATI_draw_buffers");

	return n_failed_functions;
}

/*
 *								--- ~GL_ATI_draw_buffers ---
 */


/*
 *								--- GL_ATI_texture_float ---
 */

bool GLEH_ATI_texture_float = false;

int CGLExtensionHandler::n_GetTextureFloatATIFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ATI_texture_float = !n_failed_functions && b_SupportedExtension("GL_ATI_texture_float");

	return n_failed_functions;
}

/*
 *								--- ~GL_ATI_texture_float ---
 */


/*
 *								--- GL_ATI_texture_mirror_once ---
 */

bool GLEH_ATI_texture_mirror_once = false;

int CGLExtensionHandler::n_GetTextureMirrorOnceATIFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_ATI_texture_mirror_once = !n_failed_functions && b_SupportedExtension("GL_ATI_texture_mirror_once");

	return n_failed_functions;
}

/*
 *								--- ~GL_ATI_texture_mirror_once ---
 */


/*
 *								--- GL_S3_s3tc ---
 */

bool GLEH_S3_s3tc = false;

int CGLExtensionHandler::n_GetS3tcS3FuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_S3_s3tc = !n_failed_functions && b_SupportedExtension("GL_S3_s3tc");

	return n_failed_functions;
}

/*
 *								--- ~GL_S3_s3tc ---
 */


/*
 *								--- GL_EXT_texture_env_add ---
 */

bool GLEH_EXT_texture_env_add = false;

int CGLExtensionHandler::n_GetTextureEnvAddEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_env_add = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_env_add");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_env_add ---
 */


/*
 *								--- GL_EXT_abgr ---
 */

bool GLEH_EXT_abgr = false;

int CGLExtensionHandler::n_GetAbgrEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_abgr = !n_failed_functions && b_SupportedExtension("GL_EXT_abgr");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_abgr ---
 */


/*
 *								--- GL_EXT_bgra ---
 */

bool GLEH_EXT_bgra = false;

int CGLExtensionHandler::n_GetBgraEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_bgra = !n_failed_functions && b_SupportedExtension("GL_EXT_bgra");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_bgra ---
 */


/*
 *								--- GL_EXT_bindable_uniform ---
 */

bool GLEH_EXT_bindable_uniform = false;

#ifdef __GENERATE_GL_EXT_bindable_uniform

void (GLApi *glUniformBufferEXT)(GLuint, int, GLuint) INIT_FUNC_POINTERS;
int (GLApi *glGetUniformBufferSizeEXT)(GLuint, int) INIT_FUNC_POINTERS;
GLintptr (GLApi *glGetUniformOffsetEXT)(GLuint, int) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_bindable_uniform

int CGLExtensionHandler::n_GetBindableUniformEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_bindable_uniform

	if(!(glUniformBufferEXT = (void(GLApi*)(GLuint, int, GLuint))wglGetProcAddress("glUniformBufferEXT"))) ++ n_failed_functions;
	if(!(glGetUniformBufferSizeEXT = (int(GLApi*)(GLuint, int))wglGetProcAddress("glGetUniformBufferSizeEXT"))) ++ n_failed_functions;
	if(!(glGetUniformOffsetEXT = (GLintptr(GLApi*)(GLuint, int))wglGetProcAddress("glGetUniformOffsetEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_bindable_uniform

	GLEH_EXT_bindable_uniform = !n_failed_functions && b_SupportedExtension("GL_EXT_bindable_uniform");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_bindable_uniform ---
 */


/*
 *								--- GL_EXT_blend_color ---
 */

bool GLEH_EXT_blend_color = false;

#ifdef __GENERATE_GL_EXT_blend_color

void (GLApi *glBlendColorEXT)(GLclampf, GLclampf, GLclampf, GLclampf) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_blend_color

int CGLExtensionHandler::n_GetBlendColorEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_blend_color

	if(!(glBlendColorEXT = (void(GLApi*)(GLclampf, GLclampf, GLclampf, GLclampf))wglGetProcAddress("glBlendColorEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_blend_color

	GLEH_EXT_blend_color = !n_failed_functions && b_SupportedExtension("GL_EXT_blend_color");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_blend_color ---
 */


/*
 *								--- GL_EXT_blend_equation_separate ---
 */

bool GLEH_EXT_blend_equation_separate = false;

#ifdef __GENERATE_GL_EXT_blend_equation_separate

void (GLApi *glBlendEquationSeparateEXT)(GLenum, GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_blend_equation_separate

int CGLExtensionHandler::n_GetBlendEquationSeparateEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_blend_equation_separate

	if(!(glBlendEquationSeparateEXT = (void(GLApi*)(GLenum, GLenum))wglGetProcAddress("glBlendEquationSeparateEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_blend_equation_separate

	GLEH_EXT_blend_equation_separate = !n_failed_functions && b_SupportedExtension("GL_EXT_blend_equation_separate");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_blend_equation_separate ---
 */


/*
 *								--- GL_EXT_blend_func_separate ---
 */

bool GLEH_EXT_blend_func_separate = false;

#ifdef __GENERATE_GL_EXT_blend_func_separate

void (GLApi *glBlendFuncSeparateEXT)(GLenum, GLenum, GLenum, GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_blend_func_separate

int CGLExtensionHandler::n_GetBlendFuncSeparateEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_blend_func_separate

	if(!(glBlendFuncSeparateEXT = (void(GLApi*)(GLenum, GLenum, GLenum, GLenum))wglGetProcAddress("glBlendFuncSeparateEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_blend_func_separate

	GLEH_EXT_blend_func_separate = !n_failed_functions && b_SupportedExtension("GL_EXT_blend_func_separate");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_blend_func_separate ---
 */


/*
 *								--- GL_EXT_blend_minmax ---
 */

bool GLEH_EXT_blend_minmax = false;

#ifdef __GENERATE_GL_EXT_blend_minmax

void (GLApi *glBlendEquationEXT)(GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_blend_minmax

int CGLExtensionHandler::n_GetBlendMinMaxEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_blend_minmax

	if(!(glBlendEquationEXT = (void(GLApi*)(GLenum))wglGetProcAddress("glBlendEquationEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_blend_minmax

	GLEH_EXT_blend_minmax = !n_failed_functions && b_SupportedExtension("GL_EXT_blend_minmax");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_blend_minmax ---
 */


/*
 *								--- GL_EXT_blend_subtract ---
 */

bool GLEH_EXT_blend_subtract = false;

int CGLExtensionHandler::n_GetBlendSubtractEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_blend_subtract = !n_failed_functions && b_SupportedExtension("GL_EXT_blend_subtract");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_blend_subtract ---
 */


/*
 *								--- GL_EXT_depth_bounds_test ---
 */

bool GLEH_EXT_depth_bounds_test = false;

#ifdef __GENERATE_GL_EXT_depth_bounds_test

void (GLApi *glDepthBoundsEXT)(GLclampd, GLclampd) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_depth_bounds_test

int CGLExtensionHandler::n_GetDepthBoundsTestEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_depth_bounds_test

	if(!(glDepthBoundsEXT = (void(GLApi*)(GLclampd, GLclampd))wglGetProcAddress("glDepthBoundsEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_depth_bounds_test

	GLEH_EXT_depth_bounds_test = !n_failed_functions && b_SupportedExtension("GL_EXT_depth_bounds_test");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_depth_bounds_test ---
 */


/*
 *								--- GL_EXT_direct_state_access ---
 */

bool GLEH_EXT_direct_state_access = false;

#ifdef __GENERATE_GL_EXT_direct_state_access

void (GLApi *glClientAttribDefaultEXT)(GLbitfield) INIT_FUNC_POINTERS;
void (GLApi *glPushClientAttribDefaultEXT)(GLbitfield) INIT_FUNC_POINTERS;
void (GLApi *glMatrixLoadfEXT)(GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixLoaddEXT)(GLenum, const double*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixMultfEXT)(GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixMultdEXT)(GLenum, const double*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixLoadIdentityEXT)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glMatrixRotatefEXT)(GLenum, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glMatrixRotatedEXT)(GLenum, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glMatrixScalefEXT)(GLenum, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glMatrixScaledEXT)(GLenum, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glMatrixTranslatefEXT)(GLenum, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glMatrixTranslatedEXT)(GLenum, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glMatrixOrthoEXT)(GLenum, double, double, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glMatrixFrustumEXT)(GLenum, double, double, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glMatrixPushEXT)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glMatrixPopEXT)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glTextureParameteriEXT)(GLuint, GLenum, GLenum, int) INIT_FUNC_POINTERS;
void (GLApi *glTextureParameterivEXT)(GLuint, GLenum, GLenum, const int*) INIT_FUNC_POINTERS;
void (GLApi *glTextureParameterfEXT)(GLuint, GLenum, GLenum, float) INIT_FUNC_POINTERS;
void (GLApi *glTextureParameterfvEXT)(GLuint, GLenum, GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glTextureImage1DEXT)(GLuint, GLenum, int, int, GLsizei, int, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glTextureImage2DEXT)(GLuint, GLenum, int, int, GLsizei, GLsizei, int, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glTextureSubImage1DEXT)(GLuint, GLenum, int, int, GLsizei, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glTextureSubImage2DEXT)(GLuint, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCopyTextureImage1DEXT)(GLuint, GLenum, int, GLenum, int, int, GLsizei, int) INIT_FUNC_POINTERS;
void (GLApi *glCopyTextureImage2DEXT)(GLuint, GLenum, int, GLenum, int, int, GLsizei, GLsizei, int) INIT_FUNC_POINTERS;
void (GLApi *glCopyTextureSubImage1DEXT)(GLuint, GLenum, int, int, int, int, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glCopyTextureSubImage2DEXT)(GLuint, GLenum, int, int, int, int, int, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glGetTextureImageEXT)(GLuint, GLenum, int, GLenum, GLenum, void*) INIT_FUNC_POINTERS;
void (GLApi *glGetTextureParameterfvEXT)(GLuint, GLenum, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetTextureParameterivEXT)(GLuint, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetTextureLevelParameterfvEXT)(GLuint, GLenum, int, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetTextureLevelParameterivEXT)(GLuint, GLenum, int, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glTextureImage3DEXT)(GLuint, GLenum, int, int, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glTextureSubImage3DEXT)(GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCopyTextureSubImage3DEXT)(GLuint, GLenum, int, int, int, int, int, int, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glBindMultiTextureEXT)(GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoordPointerEXT)(GLenum, int, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexEnvfEXT)(GLenum, GLenum, GLenum, float) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexEnvfvEXT)(GLenum, GLenum, GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexEnviEXT)(GLenum, GLenum, GLenum, int) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexEnvivEXT)(GLenum, GLenum, GLenum, const int*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexGendEXT)(GLenum, GLenum, GLenum, double) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexGendvEXT)(GLenum, GLenum, GLenum, const double*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexGenfEXT)(GLenum, GLenum, GLenum, float) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexGenfvEXT)(GLenum, GLenum, GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexGeniEXT)(GLenum, GLenum, GLenum, int) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexGenivEXT)(GLenum, GLenum, GLenum, const int*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexEnvfvEXT)(GLenum, GLenum, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexEnvivEXT)(GLenum, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexGendvEXT)(GLenum, GLenum, GLenum, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexGenfvEXT)(GLenum, GLenum, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexGenivEXT)(GLenum, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexParameteriEXT)(GLenum, GLenum, GLenum, int) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexParameterivEXT)(GLenum, GLenum, GLenum, const int*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexParameterfEXT)(GLenum, GLenum, GLenum, float) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexParameterfvEXT)(GLenum, GLenum, GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexImage1DEXT)(GLenum, GLenum, int, int, GLsizei, int, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexImage2DEXT)(GLenum, GLenum, int, int, GLsizei, GLsizei, int, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexSubImage1DEXT)(GLenum, GLenum, int, int, GLsizei, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexSubImage2DEXT)(GLenum, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCopyMultiTexImage1DEXT)(GLenum, GLenum, int, GLenum, int, int, GLsizei, int) INIT_FUNC_POINTERS;
void (GLApi *glCopyMultiTexImage2DEXT)(GLenum, GLenum, int, GLenum, int, int, GLsizei, GLsizei, int) INIT_FUNC_POINTERS;
void (GLApi *glCopyMultiTexSubImage1DEXT)(GLenum, GLenum, int, int, int, int, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glCopyMultiTexSubImage2DEXT)(GLenum, GLenum, int, int, int, int, int, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexImageEXT)(GLenum, GLenum, int, GLenum, GLenum, void*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexParameterfvEXT)(GLenum, GLenum, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexParameterivEXT)(GLenum, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexLevelParameterfvEXT)(GLenum, GLenum, int, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexLevelParameterivEXT)(GLenum, GLenum, int, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexImage3DEXT)(GLenum, GLenum, int, int, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexSubImage3DEXT)(GLenum, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCopyMultiTexSubImage3DEXT)(GLenum, GLenum, int, int, int, int, int, int, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glEnableClientStateIndexedEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDisableClientStateIndexedEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glEnableClientStateiEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDisableClientStateiEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetFloatIndexedvEXT)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetDoubleIndexedvEXT)(GLenum, GLuint, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetPointerIndexedvEXT)(GLenum, GLuint, void**) INIT_FUNC_POINTERS;
void (GLApi *glGetFloati_vEXT)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetDoublei_vEXT)(GLenum, GLuint, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetPointeri_vEXT)(GLenum, GLuint, void**) INIT_FUNC_POINTERS;
void (GLApi *glEnableIndexedEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDisableIndexedEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsEnabledIndexedEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetIntegerIndexedvEXT)(GLenum, GLuint, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetBooleanIndexedvEXT)(GLenum, GLuint, GLboolean*) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramStringEXT)(GLuint, GLenum, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameter4dEXT)(GLuint, GLenum, GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameter4dvEXT)(GLuint, GLenum, GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameter4fEXT)(GLuint, GLenum, GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameter4fvEXT)(GLuint, GLenum, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedProgramLocalParameterdvEXT)(GLuint, GLenum, GLuint, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedProgramLocalParameterfvEXT)(GLuint, GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedProgramivEXT)(GLuint, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedProgramStringEXT)(GLuint, GLenum, GLenum, void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTextureImage3DEXT)(GLuint, GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTextureImage2DEXT)(GLuint, GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTextureImage1DEXT)(GLuint, GLenum, int, GLenum, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTextureSubImage3DEXT)(GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTextureSubImage2DEXT)(GLuint, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedTextureSubImage1DEXT)(GLuint, GLenum, int, int, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glGetCompressedTextureImageEXT)(GLuint, GLenum, int, void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedMultiTexImage3DEXT)(GLenum, GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedMultiTexImage2DEXT)(GLenum, GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedMultiTexImage1DEXT)(GLenum, GLenum, int, GLenum, GLsizei, int, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedMultiTexSubImage3DEXT)(GLenum, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedMultiTexSubImage2DEXT)(GLenum, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glCompressedMultiTexSubImage1DEXT)(GLenum, GLenum, int, int, GLsizei, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glGetCompressedMultiTexImageEXT)(GLenum, GLenum, int, void*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixLoadTransposefEXT)(GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixLoadTransposedEXT)(GLenum, const double*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixMultTransposefEXT)(GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixMultTransposedEXT)(GLenum, const double*) INIT_FUNC_POINTERS;
void (GLApi *glNamedBufferDataEXT)(GLuint, GLsizeiptr, const void*, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glNamedBufferSubDataEXT)(GLuint, GLintptr, GLsizeiptr, const void*) INIT_FUNC_POINTERS;
void* (GLApi *glMapNamedBufferEXT)(GLuint, GLenum) INIT_FUNC_POINTERS;
GLboolean (GLApi *glUnmapNamedBufferEXT)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedBufferParameterivEXT)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedBufferPointervEXT)(GLuint, GLenum, void**) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedBufferSubDataEXT)(GLuint, GLintptr, GLsizeiptr, void*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform1fEXT)(GLuint, int, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform2fEXT)(GLuint, int, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform3fEXT)(GLuint, int, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform4fEXT)(GLuint, int, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform1iEXT)(GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform2iEXT)(GLuint, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform3iEXT)(GLuint, int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform4iEXT)(GLuint, int, int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform1fvEXT)(GLuint, int, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform2fvEXT)(GLuint, int, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform3fvEXT)(GLuint, int, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform4fvEXT)(GLuint, int, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform1ivEXT)(GLuint, int, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform2ivEXT)(GLuint, int, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform3ivEXT)(GLuint, int, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform4ivEXT)(GLuint, int, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix2fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix3fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix4fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix2x3fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix3x2fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix2x4fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix4x2fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix3x4fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformMatrix4x3fvEXT)(GLuint, int, GLsizei, GLboolean, const float*) INIT_FUNC_POINTERS;
void (GLApi *glTextureBufferEXT)(GLuint, GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexBufferEXT)(GLenum, GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glTextureParameterIivEXT)(GLuint, GLenum, GLenum, const int*) INIT_FUNC_POINTERS;
void (GLApi *glTextureParameterIuivEXT)(GLuint, GLenum, GLenum, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetTextureParameterIivEXT)(GLuint, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetTextureParameterIuivEXT)(GLuint, GLenum, GLenum, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexParameterIivEXT)(GLenum, GLenum, GLenum, const int*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexParameterIuivEXT)(GLenum, GLenum, GLenum, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexParameterIivEXT)(GLenum, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetMultiTexParameterIuivEXT)(GLenum, GLenum, GLenum, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform1uiEXT)(GLuint, int, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform2uiEXT)(GLuint, int, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform3uiEXT)(GLuint, int, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform4uiEXT)(GLuint, int, GLuint, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform1uivEXT)(GLuint, int, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform2uivEXT)(GLuint, int, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform3uivEXT)(GLuint, int, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniform4uivEXT)(GLuint, int, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameters4fvEXT)(GLuint, GLenum, GLuint, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameterI4iEXT)(GLuint, GLenum, GLuint, int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameterI4ivEXT)(GLuint, GLenum, GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParametersI4ivEXT)(GLuint, GLenum, GLuint, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameterI4uiEXT)(GLuint, GLenum, GLuint, GLuint, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParameterI4uivEXT)(GLuint, GLenum, GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glNamedProgramLocalParametersI4uivEXT)(GLuint, GLenum, GLuint, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedProgramLocalParameterIivEXT)(GLuint, GLenum, GLuint, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedProgramLocalParameterIuivEXT)(GLuint, GLenum, GLuint, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glNamedRenderbufferStorageEXT)(GLuint, GLenum, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedRenderbufferParameterivEXT)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glNamedRenderbufferStorageMultisampleEXT)(GLuint, GLsizei, GLenum, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glNamedRenderbufferStorageMultisampleCoverageEXT)(GLuint, GLsizei, GLsizei, GLenum, GLsizei, GLsizei) INIT_FUNC_POINTERS;
GLenum (GLApi *glCheckNamedFramebufferStatusEXT)(GLuint, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glNamedFramebufferTexture1DEXT)(GLuint, GLenum, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glNamedFramebufferTexture2DEXT)(GLuint, GLenum, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glNamedFramebufferTexture3DEXT)(GLuint, GLenum, GLenum, GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glNamedFramebufferRenderbufferEXT)(GLuint, GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedFramebufferAttachmentParameterivEXT)(GLuint, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGenerateTextureMipmapEXT)(GLuint, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glGenerateMultiTexMipmapEXT)(GLenum, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferDrawBufferEXT)(GLuint, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferDrawBuffersEXT)(GLuint, GLsizei, const GLenum*) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferReadBufferEXT)(GLuint, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glGetFramebufferParameterivEXT)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glNamedCopyBufferSubDataEXT)(GLuint, GLuint, GLintptr, GLintptr, GLsizeiptr) INIT_FUNC_POINTERS;
void (GLApi *glNamedFramebufferTextureEXT)(GLuint, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glNamedFramebufferTextureLayerEXT)(GLuint, GLenum, GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glNamedFramebufferTextureFaceEXT)(GLuint, GLenum, GLuint, int, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glTextureRenderbufferEXT)(GLuint, GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexRenderbufferEXT)(GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayVertexOffsetEXT)(GLuint, GLuint, int, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayColorOffsetEXT)(GLuint, GLuint, int, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayEdgeFlagOffsetEXT)(GLuint, GLuint, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayIndexOffsetEXT)(GLuint, GLuint, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayNormalOffsetEXT)(GLuint, GLuint, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayTexCoordOffsetEXT)(GLuint, GLuint, int, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayMultiTexCoordOffsetEXT)(GLuint, GLuint, GLenum, int, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayFogCoordOffsetEXT)(GLuint, GLuint, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArraySecondaryColorOffsetEXT)(GLuint, GLuint, int, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayVertexAttribOffsetEXT)(GLuint, GLuint, GLuint, int, GLenum, GLboolean, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexArrayVertexAttribIOffsetEXT)(GLuint, GLuint, GLuint, int, GLenum, GLsizei, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glEnableVertexArrayEXT)(GLuint, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glDisableVertexArrayEXT)(GLuint, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glEnableVertexArrayAttribEXT)(GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDisableVertexArrayAttribEXT)(GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexArrayIntegervEXT)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexArrayPointervEXT)(GLuint, GLenum, void**) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexArrayIntegeri_vEXT)(GLuint, GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexArrayPointeri_vEXT)(GLuint, GLuint, GLenum, void**) INIT_FUNC_POINTERS;
void* (GLApi *glMapNamedBufferRangeEXT)(GLuint, GLintptr, GLsizeiptr, GLbitfield) INIT_FUNC_POINTERS;
void (GLApi *glFlushMappedNamedBufferRangeEXT)(GLuint, GLintptr, GLsizeiptr) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_direct_state_access

int CGLExtensionHandler::n_GetDirectStateAccessEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_direct_state_access

	if(!(glClientAttribDefaultEXT = (void(GLApi*)(GLbitfield))wglGetProcAddress("glClientAttribDefaultEXT"))) ++ n_failed_functions;
	if(!(glPushClientAttribDefaultEXT = (void(GLApi*)(GLbitfield))wglGetProcAddress("glPushClientAttribDefaultEXT"))) ++ n_failed_functions;
	if(!(glMatrixLoadfEXT = (void(GLApi*)(GLenum, const float*))wglGetProcAddress("glMatrixLoadfEXT"))) ++ n_failed_functions;
	if(!(glMatrixLoaddEXT = (void(GLApi*)(GLenum, const double*))wglGetProcAddress("glMatrixLoaddEXT"))) ++ n_failed_functions;
	if(!(glMatrixMultfEXT = (void(GLApi*)(GLenum, const float*))wglGetProcAddress("glMatrixMultfEXT"))) ++ n_failed_functions;
	if(!(glMatrixMultdEXT = (void(GLApi*)(GLenum, const double*))wglGetProcAddress("glMatrixMultdEXT"))) ++ n_failed_functions;
	if(!(glMatrixLoadIdentityEXT = (void(GLApi*)(GLenum))wglGetProcAddress("glMatrixLoadIdentityEXT"))) ++ n_failed_functions;
	if(!(glMatrixRotatefEXT = (void(GLApi*)(GLenum, float, float, float, float))wglGetProcAddress("glMatrixRotatefEXT"))) ++ n_failed_functions;
	if(!(glMatrixRotatedEXT = (void(GLApi*)(GLenum, double, double, double, double))wglGetProcAddress("glMatrixRotatedEXT"))) ++ n_failed_functions;
	if(!(glMatrixScalefEXT = (void(GLApi*)(GLenum, float, float, float))wglGetProcAddress("glMatrixScalefEXT"))) ++ n_failed_functions;
	if(!(glMatrixScaledEXT = (void(GLApi*)(GLenum, double, double, double))wglGetProcAddress("glMatrixScaledEXT"))) ++ n_failed_functions;
	if(!(glMatrixTranslatefEXT = (void(GLApi*)(GLenum, float, float, float))wglGetProcAddress("glMatrixTranslatefEXT"))) ++ n_failed_functions;
	if(!(glMatrixTranslatedEXT = (void(GLApi*)(GLenum, double, double, double))wglGetProcAddress("glMatrixTranslatedEXT"))) ++ n_failed_functions;
	if(!(glMatrixOrthoEXT = (void(GLApi*)(GLenum, double, double, double, double, double, double))wglGetProcAddress("glMatrixOrthoEXT"))) ++ n_failed_functions;
	if(!(glMatrixFrustumEXT = (void(GLApi*)(GLenum, double, double, double, double, double, double))wglGetProcAddress("glMatrixFrustumEXT"))) ++ n_failed_functions;
	if(!(glMatrixPushEXT = (void(GLApi*)(GLenum))wglGetProcAddress("glMatrixPushEXT"))) ++ n_failed_functions;
	if(!(glMatrixPopEXT = (void(GLApi*)(GLenum))wglGetProcAddress("glMatrixPopEXT"))) ++ n_failed_functions;
	if(!(glTextureParameteriEXT = (void(GLApi*)(GLuint, GLenum, GLenum, int))wglGetProcAddress("glTextureParameteriEXT"))) ++ n_failed_functions;
	if(!(glTextureParameterivEXT = (void(GLApi*)(GLuint, GLenum, GLenum, const int*))wglGetProcAddress("glTextureParameterivEXT"))) ++ n_failed_functions;
	if(!(glTextureParameterfEXT = (void(GLApi*)(GLuint, GLenum, GLenum, float))wglGetProcAddress("glTextureParameterfEXT"))) ++ n_failed_functions;
	if(!(glTextureParameterfvEXT = (void(GLApi*)(GLuint, GLenum, GLenum, const float*))wglGetProcAddress("glTextureParameterfvEXT"))) ++ n_failed_functions;
	if(!(glTextureImage1DEXT = (void(GLApi*)(GLuint, GLenum, int, int, GLsizei, int, GLenum, GLenum, const void*))wglGetProcAddress("glTextureImage1DEXT"))) ++ n_failed_functions;
	if(!(glTextureImage2DEXT = (void(GLApi*)(GLuint, GLenum, int, int, GLsizei, GLsizei, int, GLenum, GLenum, const void*))wglGetProcAddress("glTextureImage2DEXT"))) ++ n_failed_functions;
	if(!(glTextureSubImage1DEXT = (void(GLApi*)(GLuint, GLenum, int, int, GLsizei, GLenum, GLenum, const void*))wglGetProcAddress("glTextureSubImage1DEXT"))) ++ n_failed_functions;
	if(!(glTextureSubImage2DEXT = (void(GLApi*)(GLuint, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLenum, const void*))wglGetProcAddress("glTextureSubImage2DEXT"))) ++ n_failed_functions;
	if(!(glCopyTextureImage1DEXT = (void(GLApi*)(GLuint, GLenum, int, GLenum, int, int, GLsizei, int))wglGetProcAddress("glCopyTextureImage1DEXT"))) ++ n_failed_functions;
	if(!(glCopyTextureImage2DEXT = (void(GLApi*)(GLuint, GLenum, int, GLenum, int, int, GLsizei, GLsizei, int))wglGetProcAddress("glCopyTextureImage2DEXT"))) ++ n_failed_functions;
	if(!(glCopyTextureSubImage1DEXT = (void(GLApi*)(GLuint, GLenum, int, int, int, int, GLsizei))wglGetProcAddress("glCopyTextureSubImage1DEXT"))) ++ n_failed_functions;
	if(!(glCopyTextureSubImage2DEXT = (void(GLApi*)(GLuint, GLenum, int, int, int, int, int, GLsizei, GLsizei))wglGetProcAddress("glCopyTextureSubImage2DEXT"))) ++ n_failed_functions;
	if(!(glGetTextureImageEXT = (void(GLApi*)(GLuint, GLenum, int, GLenum, GLenum, void*))wglGetProcAddress("glGetTextureImageEXT"))) ++ n_failed_functions;
	if(!(glGetTextureParameterfvEXT = (void(GLApi*)(GLuint, GLenum, GLenum, float*))wglGetProcAddress("glGetTextureParameterfvEXT"))) ++ n_failed_functions;
	if(!(glGetTextureParameterivEXT = (void(GLApi*)(GLuint, GLenum, GLenum, int*))wglGetProcAddress("glGetTextureParameterivEXT"))) ++ n_failed_functions;
	if(!(glGetTextureLevelParameterfvEXT = (void(GLApi*)(GLuint, GLenum, int, GLenum, float*))wglGetProcAddress("glGetTextureLevelParameterfvEXT"))) ++ n_failed_functions;
	if(!(glGetTextureLevelParameterivEXT = (void(GLApi*)(GLuint, GLenum, int, GLenum, int*))wglGetProcAddress("glGetTextureLevelParameterivEXT"))) ++ n_failed_functions;
	if(!(glTextureImage3DEXT = (void(GLApi*)(GLuint, GLenum, int, int, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*))wglGetProcAddress("glTextureImage3DEXT"))) ++ n_failed_functions;
	if(!(glTextureSubImage3DEXT = (void(GLApi*)(GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void*))wglGetProcAddress("glTextureSubImage3DEXT"))) ++ n_failed_functions;
	if(!(glCopyTextureSubImage3DEXT = (void(GLApi*)(GLuint, GLenum, int, int, int, int, int, int, GLsizei, GLsizei))wglGetProcAddress("glCopyTextureSubImage3DEXT"))) ++ n_failed_functions;
	if(!(glBindMultiTextureEXT = (void(GLApi*)(GLenum, GLenum, GLuint))wglGetProcAddress("glBindMultiTextureEXT"))) ++ n_failed_functions;
	if(!(glMultiTexCoordPointerEXT = (void(GLApi*)(GLenum, int, GLenum, GLsizei, const void*))wglGetProcAddress("glMultiTexCoordPointerEXT"))) ++ n_failed_functions;
	if(!(glMultiTexEnvfEXT = (void(GLApi*)(GLenum, GLenum, GLenum, float))wglGetProcAddress("glMultiTexEnvfEXT"))) ++ n_failed_functions;
	if(!(glMultiTexEnvfvEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const float*))wglGetProcAddress("glMultiTexEnvfvEXT"))) ++ n_failed_functions;
	if(!(glMultiTexEnviEXT = (void(GLApi*)(GLenum, GLenum, GLenum, int))wglGetProcAddress("glMultiTexEnviEXT"))) ++ n_failed_functions;
	if(!(glMultiTexEnvivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const int*))wglGetProcAddress("glMultiTexEnvivEXT"))) ++ n_failed_functions;
	if(!(glMultiTexGendEXT = (void(GLApi*)(GLenum, GLenum, GLenum, double))wglGetProcAddress("glMultiTexGendEXT"))) ++ n_failed_functions;
	if(!(glMultiTexGendvEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const double*))wglGetProcAddress("glMultiTexGendvEXT"))) ++ n_failed_functions;
	if(!(glMultiTexGenfEXT = (void(GLApi*)(GLenum, GLenum, GLenum, float))wglGetProcAddress("glMultiTexGenfEXT"))) ++ n_failed_functions;
	if(!(glMultiTexGenfvEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const float*))wglGetProcAddress("glMultiTexGenfvEXT"))) ++ n_failed_functions;
	if(!(glMultiTexGeniEXT = (void(GLApi*)(GLenum, GLenum, GLenum, int))wglGetProcAddress("glMultiTexGeniEXT"))) ++ n_failed_functions;
	if(!(glMultiTexGenivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const int*))wglGetProcAddress("glMultiTexGenivEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexEnvfvEXT = (void(GLApi*)(GLenum, GLenum, GLenum, float*))wglGetProcAddress("glGetMultiTexEnvfvEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexEnvivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, int*))wglGetProcAddress("glGetMultiTexEnvivEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexGendvEXT = (void(GLApi*)(GLenum, GLenum, GLenum, double*))wglGetProcAddress("glGetMultiTexGendvEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexGenfvEXT = (void(GLApi*)(GLenum, GLenum, GLenum, float*))wglGetProcAddress("glGetMultiTexGenfvEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexGenivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, int*))wglGetProcAddress("glGetMultiTexGenivEXT"))) ++ n_failed_functions;
	if(!(glMultiTexParameteriEXT = (void(GLApi*)(GLenum, GLenum, GLenum, int))wglGetProcAddress("glMultiTexParameteriEXT"))) ++ n_failed_functions;
	if(!(glMultiTexParameterivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const int*))wglGetProcAddress("glMultiTexParameterivEXT"))) ++ n_failed_functions;
	if(!(glMultiTexParameterfEXT = (void(GLApi*)(GLenum, GLenum, GLenum, float))wglGetProcAddress("glMultiTexParameterfEXT"))) ++ n_failed_functions;
	if(!(glMultiTexParameterfvEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const float*))wglGetProcAddress("glMultiTexParameterfvEXT"))) ++ n_failed_functions;
	if(!(glMultiTexImage1DEXT = (void(GLApi*)(GLenum, GLenum, int, int, GLsizei, int, GLenum, GLenum, const void*))wglGetProcAddress("glMultiTexImage1DEXT"))) ++ n_failed_functions;
	if(!(glMultiTexImage2DEXT = (void(GLApi*)(GLenum, GLenum, int, int, GLsizei, GLsizei, int, GLenum, GLenum, const void*))wglGetProcAddress("glMultiTexImage2DEXT"))) ++ n_failed_functions;
	if(!(glMultiTexSubImage1DEXT = (void(GLApi*)(GLenum, GLenum, int, int, GLsizei, GLenum, GLenum, const void*))wglGetProcAddress("glMultiTexSubImage1DEXT"))) ++ n_failed_functions;
	if(!(glMultiTexSubImage2DEXT = (void(GLApi*)(GLenum, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLenum, const void*))wglGetProcAddress("glMultiTexSubImage2DEXT"))) ++ n_failed_functions;
	if(!(glCopyMultiTexImage1DEXT = (void(GLApi*)(GLenum, GLenum, int, GLenum, int, int, GLsizei, int))wglGetProcAddress("glCopyMultiTexImage1DEXT"))) ++ n_failed_functions;
	if(!(glCopyMultiTexImage2DEXT = (void(GLApi*)(GLenum, GLenum, int, GLenum, int, int, GLsizei, GLsizei, int))wglGetProcAddress("glCopyMultiTexImage2DEXT"))) ++ n_failed_functions;
	if(!(glCopyMultiTexSubImage1DEXT = (void(GLApi*)(GLenum, GLenum, int, int, int, int, GLsizei))wglGetProcAddress("glCopyMultiTexSubImage1DEXT"))) ++ n_failed_functions;
	if(!(glCopyMultiTexSubImage2DEXT = (void(GLApi*)(GLenum, GLenum, int, int, int, int, int, GLsizei, GLsizei))wglGetProcAddress("glCopyMultiTexSubImage2DEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexImageEXT = (void(GLApi*)(GLenum, GLenum, int, GLenum, GLenum, void*))wglGetProcAddress("glGetMultiTexImageEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexParameterfvEXT = (void(GLApi*)(GLenum, GLenum, GLenum, float*))wglGetProcAddress("glGetMultiTexParameterfvEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexParameterivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, int*))wglGetProcAddress("glGetMultiTexParameterivEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexLevelParameterfvEXT = (void(GLApi*)(GLenum, GLenum, int, GLenum, float*))wglGetProcAddress("glGetMultiTexLevelParameterfvEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexLevelParameterivEXT = (void(GLApi*)(GLenum, GLenum, int, GLenum, int*))wglGetProcAddress("glGetMultiTexLevelParameterivEXT"))) ++ n_failed_functions;
	if(!(glMultiTexImage3DEXT = (void(GLApi*)(GLenum, GLenum, int, int, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*))wglGetProcAddress("glMultiTexImage3DEXT"))) ++ n_failed_functions;
	if(!(glMultiTexSubImage3DEXT = (void(GLApi*)(GLenum, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void*))wglGetProcAddress("glMultiTexSubImage3DEXT"))) ++ n_failed_functions;
	if(!(glCopyMultiTexSubImage3DEXT = (void(GLApi*)(GLenum, GLenum, int, int, int, int, int, int, GLsizei, GLsizei))wglGetProcAddress("glCopyMultiTexSubImage3DEXT"))) ++ n_failed_functions;
	if(!(glEnableClientStateIndexedEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glEnableClientStateIndexedEXT"))) ++ n_failed_functions;
	if(!(glDisableClientStateIndexedEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glDisableClientStateIndexedEXT"))) ++ n_failed_functions;
	if(!(glEnableClientStateiEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glEnableClientStateiEXT"))) ++ n_failed_functions;
	if(!(glDisableClientStateiEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glDisableClientStateiEXT"))) ++ n_failed_functions;
	if(!(glGetFloatIndexedvEXT = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetFloatIndexedvEXT"))) ++ n_failed_functions;
	if(!(glGetDoubleIndexedvEXT = (void(GLApi*)(GLenum, GLuint, double*))wglGetProcAddress("glGetDoubleIndexedvEXT"))) ++ n_failed_functions;
	if(!(glGetPointerIndexedvEXT = (void(GLApi*)(GLenum, GLuint, void**))wglGetProcAddress("glGetPointerIndexedvEXT"))) ++ n_failed_functions;
	if(!(glGetFloati_vEXT = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetFloati_vEXT"))) ++ n_failed_functions;
	if(!(glGetDoublei_vEXT = (void(GLApi*)(GLenum, GLuint, double*))wglGetProcAddress("glGetDoublei_vEXT"))) ++ n_failed_functions;
	if(!(glGetPointeri_vEXT = (void(GLApi*)(GLenum, GLuint, void**))wglGetProcAddress("glGetPointeri_vEXT"))) ++ n_failed_functions;
	if(!(glEnableIndexedEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glEnableIndexedEXT"))) ++ n_failed_functions;
	if(!(glDisableIndexedEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glDisableIndexedEXT"))) ++ n_failed_functions;
	if(!(glIsEnabledIndexedEXT = (GLboolean(GLApi*)(GLenum, GLuint))wglGetProcAddress("glIsEnabledIndexedEXT"))) ++ n_failed_functions;
	if(!(glGetIntegerIndexedvEXT = (void(GLApi*)(GLenum, GLuint, int*))wglGetProcAddress("glGetIntegerIndexedvEXT"))) ++ n_failed_functions;
	if(!(glGetBooleanIndexedvEXT = (void(GLApi*)(GLenum, GLuint, GLboolean*))wglGetProcAddress("glGetBooleanIndexedvEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramStringEXT = (void(GLApi*)(GLuint, GLenum, GLenum, GLsizei, const void*))wglGetProcAddress("glNamedProgramStringEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameter4dEXT = (void(GLApi*)(GLuint, GLenum, GLuint, double, double, double, double))wglGetProcAddress("glNamedProgramLocalParameter4dEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameter4dvEXT = (void(GLApi*)(GLuint, GLenum, GLuint, const double*))wglGetProcAddress("glNamedProgramLocalParameter4dvEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameter4fEXT = (void(GLApi*)(GLuint, GLenum, GLuint, float, float, float, float))wglGetProcAddress("glNamedProgramLocalParameter4fEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameter4fvEXT = (void(GLApi*)(GLuint, GLenum, GLuint, const float*))wglGetProcAddress("glNamedProgramLocalParameter4fvEXT"))) ++ n_failed_functions;
	if(!(glGetNamedProgramLocalParameterdvEXT = (void(GLApi*)(GLuint, GLenum, GLuint, double*))wglGetProcAddress("glGetNamedProgramLocalParameterdvEXT"))) ++ n_failed_functions;
	if(!(glGetNamedProgramLocalParameterfvEXT = (void(GLApi*)(GLuint, GLenum, GLuint, float*))wglGetProcAddress("glGetNamedProgramLocalParameterfvEXT"))) ++ n_failed_functions;
	if(!(glGetNamedProgramivEXT = (void(GLApi*)(GLuint, GLenum, GLenum, int*))wglGetProcAddress("glGetNamedProgramivEXT"))) ++ n_failed_functions;
	if(!(glGetNamedProgramStringEXT = (void(GLApi*)(GLuint, GLenum, GLenum, void*))wglGetProcAddress("glGetNamedProgramStringEXT"))) ++ n_failed_functions;
	if(!(glCompressedTextureImage3DEXT = (void(GLApi*)(GLuint, GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedTextureImage3DEXT"))) ++ n_failed_functions;
	if(!(glCompressedTextureImage2DEXT = (void(GLApi*)(GLuint, GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedTextureImage2DEXT"))) ++ n_failed_functions;
	if(!(glCompressedTextureImage1DEXT = (void(GLApi*)(GLuint, GLenum, int, GLenum, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedTextureImage1DEXT"))) ++ n_failed_functions;
	if(!(glCompressedTextureSubImage3DEXT = (void(GLApi*)(GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedTextureSubImage3DEXT"))) ++ n_failed_functions;
	if(!(glCompressedTextureSubImage2DEXT = (void(GLApi*)(GLuint, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedTextureSubImage2DEXT"))) ++ n_failed_functions;
	if(!(glCompressedTextureSubImage1DEXT = (void(GLApi*)(GLuint, GLenum, int, int, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedTextureSubImage1DEXT"))) ++ n_failed_functions;
	if(!(glGetCompressedTextureImageEXT = (void(GLApi*)(GLuint, GLenum, int, void*))wglGetProcAddress("glGetCompressedTextureImageEXT"))) ++ n_failed_functions;
	if(!(glCompressedMultiTexImage3DEXT = (void(GLApi*)(GLenum, GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedMultiTexImage3DEXT"))) ++ n_failed_functions;
	if(!(glCompressedMultiTexImage2DEXT = (void(GLApi*)(GLenum, GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedMultiTexImage2DEXT"))) ++ n_failed_functions;
	if(!(glCompressedMultiTexImage1DEXT = (void(GLApi*)(GLenum, GLenum, int, GLenum, GLsizei, int, GLsizei, const void*))wglGetProcAddress("glCompressedMultiTexImage1DEXT"))) ++ n_failed_functions;
	if(!(glCompressedMultiTexSubImage3DEXT = (void(GLApi*)(GLenum, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedMultiTexSubImage3DEXT"))) ++ n_failed_functions;
	if(!(glCompressedMultiTexSubImage2DEXT = (void(GLApi*)(GLenum, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedMultiTexSubImage2DEXT"))) ++ n_failed_functions;
	if(!(glCompressedMultiTexSubImage1DEXT = (void(GLApi*)(GLenum, GLenum, int, int, GLsizei, GLenum, GLsizei, const void*))wglGetProcAddress("glCompressedMultiTexSubImage1DEXT"))) ++ n_failed_functions;
	if(!(glGetCompressedMultiTexImageEXT = (void(GLApi*)(GLenum, GLenum, int, void*))wglGetProcAddress("glGetCompressedMultiTexImageEXT"))) ++ n_failed_functions;
	if(!(glMatrixLoadTransposefEXT = (void(GLApi*)(GLenum, const float*))wglGetProcAddress("glMatrixLoadTransposefEXT"))) ++ n_failed_functions;
	if(!(glMatrixLoadTransposedEXT = (void(GLApi*)(GLenum, const double*))wglGetProcAddress("glMatrixLoadTransposedEXT"))) ++ n_failed_functions;
	if(!(glMatrixMultTransposefEXT = (void(GLApi*)(GLenum, const float*))wglGetProcAddress("glMatrixMultTransposefEXT"))) ++ n_failed_functions;
	if(!(glMatrixMultTransposedEXT = (void(GLApi*)(GLenum, const double*))wglGetProcAddress("glMatrixMultTransposedEXT"))) ++ n_failed_functions;
	if(!(glNamedBufferDataEXT = (void(GLApi*)(GLuint, GLsizeiptr, const void*, GLenum))wglGetProcAddress("glNamedBufferDataEXT"))) ++ n_failed_functions;
	if(!(glNamedBufferSubDataEXT = (void(GLApi*)(GLuint, GLintptr, GLsizeiptr, const void*))wglGetProcAddress("glNamedBufferSubDataEXT"))) ++ n_failed_functions;
	if(!(glMapNamedBufferEXT = (void*(GLApi*)(GLuint, GLenum))wglGetProcAddress("glMapNamedBufferEXT"))) ++ n_failed_functions;
	if(!(glUnmapNamedBufferEXT = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glUnmapNamedBufferEXT"))) ++ n_failed_functions;
	if(!(glGetNamedBufferParameterivEXT = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetNamedBufferParameterivEXT"))) ++ n_failed_functions;
	if(!(glGetNamedBufferPointervEXT = (void(GLApi*)(GLuint, GLenum, void**))wglGetProcAddress("glGetNamedBufferPointervEXT"))) ++ n_failed_functions;
	if(!(glGetNamedBufferSubDataEXT = (void(GLApi*)(GLuint, GLintptr, GLsizeiptr, void*))wglGetProcAddress("glGetNamedBufferSubDataEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform1fEXT = (void(GLApi*)(GLuint, int, float))wglGetProcAddress("glProgramUniform1fEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform2fEXT = (void(GLApi*)(GLuint, int, float, float))wglGetProcAddress("glProgramUniform2fEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform3fEXT = (void(GLApi*)(GLuint, int, float, float, float))wglGetProcAddress("glProgramUniform3fEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform4fEXT = (void(GLApi*)(GLuint, int, float, float, float, float))wglGetProcAddress("glProgramUniform4fEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform1iEXT = (void(GLApi*)(GLuint, int, int))wglGetProcAddress("glProgramUniform1iEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform2iEXT = (void(GLApi*)(GLuint, int, int, int))wglGetProcAddress("glProgramUniform2iEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform3iEXT = (void(GLApi*)(GLuint, int, int, int, int))wglGetProcAddress("glProgramUniform3iEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform4iEXT = (void(GLApi*)(GLuint, int, int, int, int, int))wglGetProcAddress("glProgramUniform4iEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform1fvEXT = (void(GLApi*)(GLuint, int, GLsizei, const float*))wglGetProcAddress("glProgramUniform1fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform2fvEXT = (void(GLApi*)(GLuint, int, GLsizei, const float*))wglGetProcAddress("glProgramUniform2fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform3fvEXT = (void(GLApi*)(GLuint, int, GLsizei, const float*))wglGetProcAddress("glProgramUniform3fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform4fvEXT = (void(GLApi*)(GLuint, int, GLsizei, const float*))wglGetProcAddress("glProgramUniform4fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform1ivEXT = (void(GLApi*)(GLuint, int, GLsizei, const int*))wglGetProcAddress("glProgramUniform1ivEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform2ivEXT = (void(GLApi*)(GLuint, int, GLsizei, const int*))wglGetProcAddress("glProgramUniform2ivEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform3ivEXT = (void(GLApi*)(GLuint, int, GLsizei, const int*))wglGetProcAddress("glProgramUniform3ivEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform4ivEXT = (void(GLApi*)(GLuint, int, GLsizei, const int*))wglGetProcAddress("glProgramUniform4ivEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix2fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix2fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix3fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix3fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix4fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix4fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix2x3fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix2x3fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix3x2fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix3x2fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix2x4fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix2x4fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix4x2fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix4x2fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix3x4fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix3x4fvEXT"))) ++ n_failed_functions;
	if(!(glProgramUniformMatrix4x3fvEXT = (void(GLApi*)(GLuint, int, GLsizei, GLboolean, const float*))wglGetProcAddress("glProgramUniformMatrix4x3fvEXT"))) ++ n_failed_functions;
	if(!(glTextureBufferEXT = (void(GLApi*)(GLuint, GLenum, GLenum, GLuint))wglGetProcAddress("glTextureBufferEXT"))) ++ n_failed_functions;
	if(!(glMultiTexBufferEXT = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint))wglGetProcAddress("glMultiTexBufferEXT"))) ++ n_failed_functions;
	if(!(glTextureParameterIivEXT = (void(GLApi*)(GLuint, GLenum, GLenum, const int*))wglGetProcAddress("glTextureParameterIivEXT"))) ++ n_failed_functions;
	if(!(glTextureParameterIuivEXT = (void(GLApi*)(GLuint, GLenum, GLenum, const GLuint*))wglGetProcAddress("glTextureParameterIuivEXT"))) ++ n_failed_functions;
	if(!(glGetTextureParameterIivEXT = (void(GLApi*)(GLuint, GLenum, GLenum, int*))wglGetProcAddress("glGetTextureParameterIivEXT"))) ++ n_failed_functions;
	if(!(glGetTextureParameterIuivEXT = (void(GLApi*)(GLuint, GLenum, GLenum, GLuint*))wglGetProcAddress("glGetTextureParameterIuivEXT"))) ++ n_failed_functions;
	if(!(glMultiTexParameterIivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const int*))wglGetProcAddress("glMultiTexParameterIivEXT"))) ++ n_failed_functions;
	if(!(glMultiTexParameterIuivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, const GLuint*))wglGetProcAddress("glMultiTexParameterIuivEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexParameterIivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, int*))wglGetProcAddress("glGetMultiTexParameterIivEXT"))) ++ n_failed_functions;
	if(!(glGetMultiTexParameterIuivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint*))wglGetProcAddress("glGetMultiTexParameterIuivEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform1uiEXT = (void(GLApi*)(GLuint, int, GLuint))wglGetProcAddress("glProgramUniform1uiEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform2uiEXT = (void(GLApi*)(GLuint, int, GLuint, GLuint))wglGetProcAddress("glProgramUniform2uiEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform3uiEXT = (void(GLApi*)(GLuint, int, GLuint, GLuint, GLuint))wglGetProcAddress("glProgramUniform3uiEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform4uiEXT = (void(GLApi*)(GLuint, int, GLuint, GLuint, GLuint, GLuint))wglGetProcAddress("glProgramUniform4uiEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform1uivEXT = (void(GLApi*)(GLuint, int, GLsizei, const GLuint*))wglGetProcAddress("glProgramUniform1uivEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform2uivEXT = (void(GLApi*)(GLuint, int, GLsizei, const GLuint*))wglGetProcAddress("glProgramUniform2uivEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform3uivEXT = (void(GLApi*)(GLuint, int, GLsizei, const GLuint*))wglGetProcAddress("glProgramUniform3uivEXT"))) ++ n_failed_functions;
	if(!(glProgramUniform4uivEXT = (void(GLApi*)(GLuint, int, GLsizei, const GLuint*))wglGetProcAddress("glProgramUniform4uivEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameters4fvEXT = (void(GLApi*)(GLuint, GLenum, GLuint, GLsizei, const float*))wglGetProcAddress("glNamedProgramLocalParameters4fvEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameterI4iEXT = (void(GLApi*)(GLuint, GLenum, GLuint, int, int, int, int))wglGetProcAddress("glNamedProgramLocalParameterI4iEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameterI4ivEXT = (void(GLApi*)(GLuint, GLenum, GLuint, const int*))wglGetProcAddress("glNamedProgramLocalParameterI4ivEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParametersI4ivEXT = (void(GLApi*)(GLuint, GLenum, GLuint, GLsizei, const int*))wglGetProcAddress("glNamedProgramLocalParametersI4ivEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameterI4uiEXT = (void(GLApi*)(GLuint, GLenum, GLuint, GLuint, GLuint, GLuint, GLuint))wglGetProcAddress("glNamedProgramLocalParameterI4uiEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParameterI4uivEXT = (void(GLApi*)(GLuint, GLenum, GLuint, const GLuint*))wglGetProcAddress("glNamedProgramLocalParameterI4uivEXT"))) ++ n_failed_functions;
	if(!(glNamedProgramLocalParametersI4uivEXT = (void(GLApi*)(GLuint, GLenum, GLuint, GLsizei, const GLuint*))wglGetProcAddress("glNamedProgramLocalParametersI4uivEXT"))) ++ n_failed_functions;
	if(!(glGetNamedProgramLocalParameterIivEXT = (void(GLApi*)(GLuint, GLenum, GLuint, int*))wglGetProcAddress("glGetNamedProgramLocalParameterIivEXT"))) ++ n_failed_functions;
	if(!(glGetNamedProgramLocalParameterIuivEXT = (void(GLApi*)(GLuint, GLenum, GLuint, GLuint*))wglGetProcAddress("glGetNamedProgramLocalParameterIuivEXT"))) ++ n_failed_functions;
	if(!(glNamedRenderbufferStorageEXT = (void(GLApi*)(GLuint, GLenum, GLsizei, GLsizei))wglGetProcAddress("glNamedRenderbufferStorageEXT"))) ++ n_failed_functions;
	if(!(glGetNamedRenderbufferParameterivEXT = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetNamedRenderbufferParameterivEXT"))) ++ n_failed_functions;
	if(!(glNamedRenderbufferStorageMultisampleEXT = (void(GLApi*)(GLuint, GLsizei, GLenum, GLsizei, GLsizei))wglGetProcAddress("glNamedRenderbufferStorageMultisampleEXT"))) ++ n_failed_functions;
	if(!(glNamedRenderbufferStorageMultisampleCoverageEXT = (void(GLApi*)(GLuint, GLsizei, GLsizei, GLenum, GLsizei, GLsizei))wglGetProcAddress("glNamedRenderbufferStorageMultisampleCoverageEXT"))) ++ n_failed_functions;
	if(!(glCheckNamedFramebufferStatusEXT = (GLenum(GLApi*)(GLuint, GLenum))wglGetProcAddress("glCheckNamedFramebufferStatusEXT"))) ++ n_failed_functions;
	if(!(glNamedFramebufferTexture1DEXT = (void(GLApi*)(GLuint, GLenum, GLenum, GLuint, int))wglGetProcAddress("glNamedFramebufferTexture1DEXT"))) ++ n_failed_functions;
	if(!(glNamedFramebufferTexture2DEXT = (void(GLApi*)(GLuint, GLenum, GLenum, GLuint, int))wglGetProcAddress("glNamedFramebufferTexture2DEXT"))) ++ n_failed_functions;
	if(!(glNamedFramebufferTexture3DEXT = (void(GLApi*)(GLuint, GLenum, GLenum, GLuint, int, int))wglGetProcAddress("glNamedFramebufferTexture3DEXT"))) ++ n_failed_functions;
	if(!(glNamedFramebufferRenderbufferEXT = (void(GLApi*)(GLuint, GLenum, GLenum, GLuint))wglGetProcAddress("glNamedFramebufferRenderbufferEXT"))) ++ n_failed_functions;
	if(!(glGetNamedFramebufferAttachmentParameterivEXT = (void(GLApi*)(GLuint, GLenum, GLenum, int*))wglGetProcAddress("glGetNamedFramebufferAttachmentParameterivEXT"))) ++ n_failed_functions;
	if(!(glGenerateTextureMipmapEXT = (void(GLApi*)(GLuint, GLenum))wglGetProcAddress("glGenerateTextureMipmapEXT"))) ++ n_failed_functions;
	if(!(glGenerateMultiTexMipmapEXT = (void(GLApi*)(GLenum, GLenum))wglGetProcAddress("glGenerateMultiTexMipmapEXT"))) ++ n_failed_functions;
	if(!(glFramebufferDrawBufferEXT = (void(GLApi*)(GLuint, GLenum))wglGetProcAddress("glFramebufferDrawBufferEXT"))) ++ n_failed_functions;
	if(!(glFramebufferDrawBuffersEXT = (void(GLApi*)(GLuint, GLsizei, const GLenum*))wglGetProcAddress("glFramebufferDrawBuffersEXT"))) ++ n_failed_functions;
	if(!(glFramebufferReadBufferEXT = (void(GLApi*)(GLuint, GLenum))wglGetProcAddress("glFramebufferReadBufferEXT"))) ++ n_failed_functions;
	if(!(glGetFramebufferParameterivEXT = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetFramebufferParameterivEXT"))) ++ n_failed_functions;
	if(!(glNamedCopyBufferSubDataEXT = (void(GLApi*)(GLuint, GLuint, GLintptr, GLintptr, GLsizeiptr))wglGetProcAddress("glNamedCopyBufferSubDataEXT"))) ++ n_failed_functions;
	if(!(glNamedFramebufferTextureEXT = (void(GLApi*)(GLuint, GLenum, GLuint, int))wglGetProcAddress("glNamedFramebufferTextureEXT"))) ++ n_failed_functions;
	if(!(glNamedFramebufferTextureLayerEXT = (void(GLApi*)(GLuint, GLenum, GLuint, int, int))wglGetProcAddress("glNamedFramebufferTextureLayerEXT"))) ++ n_failed_functions;
	if(!(glNamedFramebufferTextureFaceEXT = (void(GLApi*)(GLuint, GLenum, GLuint, int, GLenum))wglGetProcAddress("glNamedFramebufferTextureFaceEXT"))) ++ n_failed_functions;
	if(!(glTextureRenderbufferEXT = (void(GLApi*)(GLuint, GLenum, GLuint))wglGetProcAddress("glTextureRenderbufferEXT"))) ++ n_failed_functions;
	if(!(glMultiTexRenderbufferEXT = (void(GLApi*)(GLenum, GLenum, GLuint))wglGetProcAddress("glMultiTexRenderbufferEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayVertexOffsetEXT = (void(GLApi*)(GLuint, GLuint, int, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayVertexOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayColorOffsetEXT = (void(GLApi*)(GLuint, GLuint, int, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayColorOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayEdgeFlagOffsetEXT = (void(GLApi*)(GLuint, GLuint, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayEdgeFlagOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayIndexOffsetEXT = (void(GLApi*)(GLuint, GLuint, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayIndexOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayNormalOffsetEXT = (void(GLApi*)(GLuint, GLuint, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayNormalOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayTexCoordOffsetEXT = (void(GLApi*)(GLuint, GLuint, int, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayTexCoordOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayMultiTexCoordOffsetEXT = (void(GLApi*)(GLuint, GLuint, GLenum, int, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayMultiTexCoordOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayFogCoordOffsetEXT = (void(GLApi*)(GLuint, GLuint, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayFogCoordOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArraySecondaryColorOffsetEXT = (void(GLApi*)(GLuint, GLuint, int, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArraySecondaryColorOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayVertexAttribOffsetEXT = (void(GLApi*)(GLuint, GLuint, GLuint, int, GLenum, GLboolean, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayVertexAttribOffsetEXT"))) ++ n_failed_functions;
	if(!(glVertexArrayVertexAttribIOffsetEXT = (void(GLApi*)(GLuint, GLuint, GLuint, int, GLenum, GLsizei, GLintptr))wglGetProcAddress("glVertexArrayVertexAttribIOffsetEXT"))) ++ n_failed_functions;
	if(!(glEnableVertexArrayEXT = (void(GLApi*)(GLuint, GLenum))wglGetProcAddress("glEnableVertexArrayEXT"))) ++ n_failed_functions;
	if(!(glDisableVertexArrayEXT = (void(GLApi*)(GLuint, GLenum))wglGetProcAddress("glDisableVertexArrayEXT"))) ++ n_failed_functions;
	if(!(glEnableVertexArrayAttribEXT = (void(GLApi*)(GLuint, GLuint))wglGetProcAddress("glEnableVertexArrayAttribEXT"))) ++ n_failed_functions;
	if(!(glDisableVertexArrayAttribEXT = (void(GLApi*)(GLuint, GLuint))wglGetProcAddress("glDisableVertexArrayAttribEXT"))) ++ n_failed_functions;
	if(!(glGetVertexArrayIntegervEXT = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetVertexArrayIntegervEXT"))) ++ n_failed_functions;
	if(!(glGetVertexArrayPointervEXT = (void(GLApi*)(GLuint, GLenum, void**))wglGetProcAddress("glGetVertexArrayPointervEXT"))) ++ n_failed_functions;
	if(!(glGetVertexArrayIntegeri_vEXT = (void(GLApi*)(GLuint, GLuint, GLenum, int*))wglGetProcAddress("glGetVertexArrayIntegeri_vEXT"))) ++ n_failed_functions;
	if(!(glGetVertexArrayPointeri_vEXT = (void(GLApi*)(GLuint, GLuint, GLenum, void**))wglGetProcAddress("glGetVertexArrayPointeri_vEXT"))) ++ n_failed_functions;
	if(!(glMapNamedBufferRangeEXT = (void*(GLApi*)(GLuint, GLintptr, GLsizeiptr, GLbitfield))wglGetProcAddress("glMapNamedBufferRangeEXT"))) ++ n_failed_functions;
	if(!(glFlushMappedNamedBufferRangeEXT = (void(GLApi*)(GLuint, GLintptr, GLsizeiptr))wglGetProcAddress("glFlushMappedNamedBufferRangeEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_direct_state_access

	GLEH_EXT_direct_state_access = !n_failed_functions && b_SupportedExtension("GL_EXT_direct_state_access");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_direct_state_access ---
 */


/*
 *								--- GL_EXT_draw_buffers2 ---
 */

bool GLEH_EXT_draw_buffers2 = false;

#ifdef __GENERATE_GL_EXT_draw_buffers2

void (GLApi *glColorMaskIndexedEXT)(GLuint, GLboolean, GLboolean, GLboolean, GLboolean) INIT_FUNC_POINTERS;
/*void (GLApi *glGetBooleanIndexedvEXT)(GLenum, GLuint, GLboolean*) INIT_FUNC_POINTERS;
void (GLApi *glGetIntegerIndexedvEXT)(GLenum, GLuint, int*) INIT_FUNC_POINTERS;
void (GLApi *glEnableIndexedEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDisableIndexedEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsEnabledIndexedEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;*/

#endif // __GENERATE_GL_EXT_draw_buffers2

int CGLExtensionHandler::n_GetDrawBuffers2EXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_draw_buffers2

	if(!(glColorMaskIndexedEXT = (void(GLApi*)(GLuint, GLboolean, GLboolean, GLboolean, GLboolean))wglGetProcAddress("glColorMaskIndexedEXT"))) ++ n_failed_functions;
	if(!(glGetBooleanIndexedvEXT = (void(GLApi*)(GLenum, GLuint, GLboolean*))wglGetProcAddress("glGetBooleanIndexedvEXT"))) ++ n_failed_functions;
	if(!(glGetIntegerIndexedvEXT = (void(GLApi*)(GLenum, GLuint, int*))wglGetProcAddress("glGetIntegerIndexedvEXT"))) ++ n_failed_functions;
	if(!(glEnableIndexedEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glEnableIndexedEXT"))) ++ n_failed_functions;
	if(!(glDisableIndexedEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glDisableIndexedEXT"))) ++ n_failed_functions;
	if(!(glIsEnabledIndexedEXT = (GLboolean(GLApi*)(GLenum, GLuint))wglGetProcAddress("glIsEnabledIndexedEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_draw_buffers2

	GLEH_EXT_draw_buffers2 = !n_failed_functions && b_SupportedExtension("GL_EXT_draw_buffers2");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_draw_buffers2 ---
 */


/*
 *								--- GL_EXT_draw_instanced ---
 */

bool GLEH_EXT_draw_instanced = false;

#ifdef __GENERATE_GL_EXT_draw_instanced

void (GLApi *glDrawArraysInstancedEXT)(GLenum, int, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glDrawElementsInstancedEXT)(GLenum, GLsizei, GLenum, const void*, GLsizei) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_draw_instanced

int CGLExtensionHandler::n_GetDrawInstancedEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_draw_instanced

	if(!(glDrawArraysInstancedEXT = (void(GLApi*)(GLenum, int, GLsizei, GLsizei))wglGetProcAddress("glDrawArraysInstancedEXT"))) ++ n_failed_functions;
	if(!(glDrawElementsInstancedEXT = (void(GLApi*)(GLenum, GLsizei, GLenum, const void*, GLsizei))wglGetProcAddress("glDrawElementsInstancedEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_draw_instanced

	GLEH_EXT_draw_instanced = !n_failed_functions && b_SupportedExtension("GL_EXT_draw_instanced");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_draw_instanced ---
 */


/*
 *								--- GL_EXT_fog_coord ---
 */

bool GLEH_EXT_fog_coord = false;

#ifdef __GENERATE_GL_EXT_fog_coord

void (GLApi *glFogCoordfEXT)(float) INIT_FUNC_POINTERS;
void (GLApi *glFogCoorddEXT)(double) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordfvEXT)(float) INIT_FUNC_POINTERS;
void (GLApi *glFogCoorddvEXT)(double) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordPointerEXT)(GLenum, GLsizei, void*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_fog_coord

int CGLExtensionHandler::n_GetFogCoordEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_fog_coord

	if(!(glFogCoordfEXT = (void(GLApi*)(float))wglGetProcAddress("glFogCoordfEXT"))) ++ n_failed_functions;
	if(!(glFogCoorddEXT = (void(GLApi*)(double))wglGetProcAddress("glFogCoorddEXT"))) ++ n_failed_functions;
	if(!(glFogCoordfvEXT = (void(GLApi*)(float))wglGetProcAddress("glFogCoordfvEXT"))) ++ n_failed_functions;
	if(!(glFogCoorddvEXT = (void(GLApi*)(double))wglGetProcAddress("glFogCoorddvEXT"))) ++ n_failed_functions;
	if(!(glFogCoordPointerEXT = (void(GLApi*)(GLenum, GLsizei, void*))wglGetProcAddress("glFogCoordPointerEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_fog_coord

	GLEH_EXT_fog_coord = !n_failed_functions && b_SupportedExtension("GL_EXT_fog_coord");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_fog_coord ---
 */


/*
 *								--- GL_EXT_framebuffer_blit ---
 */

bool GLEH_EXT_framebuffer_blit = false;

#ifdef __GENERATE_GL_EXT_framebuffer_blit

void (GLApi *glBlitFramebufferEXT)(int, int, int, int, int, int, int, int, GLbitfield, GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_framebuffer_blit

int CGLExtensionHandler::n_GetFramebufferBlitEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_framebuffer_blit

	if(!(glBlitFramebufferEXT = (void(GLApi*)(int, int, int, int, int, int, int, int, GLbitfield, GLenum))wglGetProcAddress("glBlitFramebufferEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_framebuffer_blit

	GLEH_EXT_framebuffer_blit = !n_failed_functions && b_SupportedExtension("GL_EXT_framebuffer_blit");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_framebuffer_blit ---
 */


/*
 *								--- GL_EXT_framebuffer_multisample ---
 */

bool GLEH_EXT_framebuffer_multisample = false;

#ifdef __GENERATE_GL_EXT_framebuffer_multisample

void (GLApi *glRenderbufferStorageMultisampleEXT)(GLenum, GLsizei, GLenum, GLsizei, GLsizei) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_framebuffer_multisample

int CGLExtensionHandler::n_GetFramebufferMultisampleEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_framebuffer_multisample

	if(!(glRenderbufferStorageMultisampleEXT = (void(GLApi*)(GLenum, GLsizei, GLenum, GLsizei, GLsizei))wglGetProcAddress("glRenderbufferStorageMultisampleEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_framebuffer_multisample

	GLEH_EXT_framebuffer_multisample = !n_failed_functions && b_SupportedExtension("GL_EXT_framebuffer_multisample");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_framebuffer_multisample ---
 */


/*
 *								--- GL_EXT_framebuffer_object ---
 */

bool GLEH_EXT_framebuffer_object = false;

#ifdef __GENERATE_GL_EXT_framebuffer_object

GLboolean (GLApi *glIsRenderbufferEXT)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBindRenderbufferEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteRenderbuffersEXT)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenRenderbuffersEXT)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glRenderbufferStorageEXT)(GLenum, GLenum, GLsizei, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glGetRenderbufferParameterivEXT)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsFramebufferEXT)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBindFramebufferEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteFramebuffersEXT)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenFramebuffersEXT)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
GLenum (GLApi *glCheckFramebufferStatusEXT)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTexture1DEXT)(GLenum, GLenum, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTexture2DEXT)(GLenum, GLenum, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTexture3DEXT)(GLenum, GLenum, GLenum, GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferRenderbufferEXT)(GLenum, GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetFramebufferAttachmentParameterivEXT)(GLenum, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGenerateMipmapEXT)(GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_framebuffer_object

int CGLExtensionHandler::n_GetFramebufferObjectEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_framebuffer_object

	if(!(glIsRenderbufferEXT = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsRenderbufferEXT"))) ++ n_failed_functions;
	if(!(glBindRenderbufferEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindRenderbufferEXT"))) ++ n_failed_functions;
	if(!(glDeleteRenderbuffersEXT = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteRenderbuffersEXT"))) ++ n_failed_functions;
	if(!(glGenRenderbuffersEXT = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenRenderbuffersEXT"))) ++ n_failed_functions;
	if(!(glRenderbufferStorageEXT = (void(GLApi*)(GLenum, GLenum, GLsizei, GLsizei))wglGetProcAddress("glRenderbufferStorageEXT"))) ++ n_failed_functions;
	if(!(glGetRenderbufferParameterivEXT = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glGetRenderbufferParameterivEXT"))) ++ n_failed_functions;
	if(!(glIsFramebufferEXT = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsFramebufferEXT"))) ++ n_failed_functions;
	if(!(glBindFramebufferEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindFramebufferEXT"))) ++ n_failed_functions;
	if(!(glDeleteFramebuffersEXT = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteFramebuffersEXT"))) ++ n_failed_functions;
	if(!(glGenFramebuffersEXT = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenFramebuffersEXT"))) ++ n_failed_functions;
	if(!(glCheckFramebufferStatusEXT = (GLenum(GLApi*)(GLenum))wglGetProcAddress("glCheckFramebufferStatusEXT"))) ++ n_failed_functions;
	if(!(glFramebufferTexture1DEXT = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint, int))wglGetProcAddress("glFramebufferTexture1DEXT"))) ++ n_failed_functions;
	if(!(glFramebufferTexture2DEXT = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint, int))wglGetProcAddress("glFramebufferTexture2DEXT"))) ++ n_failed_functions;
	if(!(glFramebufferTexture3DEXT = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint, int, int))wglGetProcAddress("glFramebufferTexture3DEXT"))) ++ n_failed_functions;
	if(!(glFramebufferRenderbufferEXT = (void(GLApi*)(GLenum, GLenum, GLenum, GLuint))wglGetProcAddress("glFramebufferRenderbufferEXT"))) ++ n_failed_functions;
	if(!(glGetFramebufferAttachmentParameterivEXT = (void(GLApi*)(GLenum, GLenum, GLenum, int*))wglGetProcAddress("glGetFramebufferAttachmentParameterivEXT"))) ++ n_failed_functions;
	if(!(glGenerateMipmapEXT = (void(GLApi*)(GLenum))wglGetProcAddress("glGenerateMipmapEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_framebuffer_object

	GLEH_EXT_framebuffer_object = !n_failed_functions && b_SupportedExtension("GL_EXT_framebuffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_framebuffer_object ---
 */


/*
 *								--- GL_EXT_framebuffer_sRGB ---
 */

bool GLEH_EXT_framebuffer_sRGB = false;

int CGLExtensionHandler::n_GetFramebufferSRGBEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_framebuffer_sRGB = !n_failed_functions && b_SupportedExtension("GL_EXT_framebuffer_sRGB");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_framebuffer_sRGB ---
 */


/*
 *								--- GL_EXT_geometry_shader4 ---
 */

bool GLEH_EXT_geometry_shader4 = false;

#ifdef __GENERATE_GL_EXT_geometry_shader4

void (GLApi *glProgramParameteriEXT)(GLuint, GLenum, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTextureEXT)(GLenum, GLenum, GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTextureLayerEXT)(GLenum, GLenum, GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glFramebufferTextureFaceEXT)(GLenum, GLenum, GLuint, int, GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_geometry_shader4

int CGLExtensionHandler::n_GetGeometryShader4EXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_geometry_shader4

	if(!(glProgramParameteriEXT = (void(GLApi*)(GLuint, GLenum, int))wglGetProcAddress("glProgramParameteriEXT"))) ++ n_failed_functions;
	if(!(glFramebufferTextureEXT = (void(GLApi*)(GLenum, GLenum, GLuint, int))wglGetProcAddress("glFramebufferTextureEXT"))) ++ n_failed_functions;
	if(!(glFramebufferTextureLayerEXT = (void(GLApi*)(GLenum, GLenum, GLuint, int, int))wglGetProcAddress("glFramebufferTextureLayerEXT"))) ++ n_failed_functions;
	if(!(glFramebufferTextureFaceEXT = (void(GLApi*)(GLenum, GLenum, GLuint, int, GLenum))wglGetProcAddress("glFramebufferTextureFaceEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_geometry_shader4

	GLEH_EXT_geometry_shader4 = !n_failed_functions && b_SupportedExtension("GL_EXT_geometry_shader4");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_geometry_shader4 ---
 */


/*
 *								--- GL_EXT_gpu_program_parameters ---
 */

bool GLEH_EXT_gpu_program_parameters = false;

#ifdef __GENERATE_GL_EXT_gpu_program_parameters

void (GLApi *glProgramEnvParameters4fvEXT)(GLenum, GLuint, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameters4fvEXT)(GLenum, GLuint, GLsizei, const float*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_gpu_program_parameters

int CGLExtensionHandler::n_GetGPUProgramParametersEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_gpu_program_parameters

	if(!(glProgramEnvParameters4fvEXT = (void(GLApi*)(GLenum, GLuint, GLsizei, const float*))wglGetProcAddress("glProgramEnvParameters4fvEXT"))) ++ n_failed_functions;
	if(!(glProgramLocalParameters4fvEXT = (void(GLApi*)(GLenum, GLuint, GLsizei, const float*))wglGetProcAddress("glProgramLocalParameters4fvEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_gpu_program_parameters

	GLEH_EXT_gpu_program_parameters = !n_failed_functions && b_SupportedExtension("GL_EXT_gpu_program_parameters");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_gpu_program_parameters ---
 */


/*
 *								--- GL_EXT_gpu_shader4 ---
 */

bool GLEH_EXT_gpu_shader4 = false;

#ifdef __GENERATE_GL_EXT_gpu_shader4

void (GLApi *glVertexAttribI1iEXT)(GLuint, int) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI2iEXT)(GLuint, int, int) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI3iEXT)(GLuint, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI4iEXT)(GLuint, int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI1uiEXT)(GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI2uiEXT)(GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI3uiEXT)(GLuint, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI4uiEXT)(GLuint, GLuint, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI1ivEXT)(GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI2ivEXT)(GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI3ivEXT)(GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI4ivEXT)(GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI1uivEXT)(GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI2uivEXT)(GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI3uivEXT)(GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI4uivEXT)(GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI4bvEXT)(GLuint, const GLbyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI4svEXT)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI4ubvEXT)(GLuint, const GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribI4usvEXT)(GLuint, const GLushort*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribIPointerEXT)(GLuint, int, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribIivEXT)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribIuivEXT)(GLuint, GLenum, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glUniform1uiEXT)(int, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glUniform2uiEXT)(int, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glUniform3uiEXT)(int, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glUniform4uiEXT)(int, GLuint, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glUniform1uivEXT)(int, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glUniform2uivEXT)(int, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glUniform3uivEXT)(int, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glUniform4uivEXT)(int, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetUniformuivEXT)(GLuint, int, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glBindFragDataLocationEXT)(GLuint, GLuint, const GLchar*) INIT_FUNC_POINTERS;
int (GLApi *glGetFragDataLocationEXT)(GLuint, const GLchar*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_gpu_shader4

int CGLExtensionHandler::n_GetGPUShader4EXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_gpu_shader4

	if(!(glVertexAttribI1iEXT = (void(GLApi*)(GLuint, int))wglGetProcAddress("glVertexAttribI1iEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI2iEXT = (void(GLApi*)(GLuint, int, int))wglGetProcAddress("glVertexAttribI2iEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI3iEXT = (void(GLApi*)(GLuint, int, int, int))wglGetProcAddress("glVertexAttribI3iEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI4iEXT = (void(GLApi*)(GLuint, int, int, int, int))wglGetProcAddress("glVertexAttribI4iEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI1uiEXT = (void(GLApi*)(GLuint, GLuint))wglGetProcAddress("glVertexAttribI1uiEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI2uiEXT = (void(GLApi*)(GLuint, GLuint, GLuint))wglGetProcAddress("glVertexAttribI2uiEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI3uiEXT = (void(GLApi*)(GLuint, GLuint, GLuint, GLuint))wglGetProcAddress("glVertexAttribI3uiEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI4uiEXT = (void(GLApi*)(GLuint, GLuint, GLuint, GLuint, GLuint))wglGetProcAddress("glVertexAttribI4uiEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI1ivEXT = (void(GLApi*)(GLuint, const int*))wglGetProcAddress("glVertexAttribI1ivEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI2ivEXT = (void(GLApi*)(GLuint, const int*))wglGetProcAddress("glVertexAttribI2ivEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI3ivEXT = (void(GLApi*)(GLuint, const int*))wglGetProcAddress("glVertexAttribI3ivEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI4ivEXT = (void(GLApi*)(GLuint, const int*))wglGetProcAddress("glVertexAttribI4ivEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI1uivEXT = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttribI1uivEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI2uivEXT = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttribI2uivEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI3uivEXT = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttribI3uivEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI4uivEXT = (void(GLApi*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttribI4uivEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI4bvEXT = (void(GLApi*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttribI4bvEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI4svEXT = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttribI4svEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI4ubvEXT = (void(GLApi*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttribI4ubvEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribI4usvEXT = (void(GLApi*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttribI4usvEXT"))) ++ n_failed_functions;
	if(!(glVertexAttribIPointerEXT = (void(GLApi*)(GLuint, int, GLenum, GLsizei, const void*))wglGetProcAddress("glVertexAttribIPointerEXT"))) ++ n_failed_functions;
	if(!(glGetVertexAttribIivEXT = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetVertexAttribIivEXT"))) ++ n_failed_functions;
	if(!(glGetVertexAttribIuivEXT = (void(GLApi*)(GLuint, GLenum, GLuint*))wglGetProcAddress("glGetVertexAttribIuivEXT"))) ++ n_failed_functions;
	if(!(glUniform1uiEXT = (void(GLApi*)(int, GLuint))wglGetProcAddress("glUniform1uiEXT"))) ++ n_failed_functions;
	if(!(glUniform2uiEXT = (void(GLApi*)(int, GLuint, GLuint))wglGetProcAddress("glUniform2uiEXT"))) ++ n_failed_functions;
	if(!(glUniform3uiEXT = (void(GLApi*)(int, GLuint, GLuint, GLuint))wglGetProcAddress("glUniform3uiEXT"))) ++ n_failed_functions;
	if(!(glUniform4uiEXT = (void(GLApi*)(int, GLuint, GLuint, GLuint, GLuint))wglGetProcAddress("glUniform4uiEXT"))) ++ n_failed_functions;
	if(!(glUniform1uivEXT = (void(GLApi*)(int, GLsizei, const GLuint*))wglGetProcAddress("glUniform1uivEXT"))) ++ n_failed_functions;
	if(!(glUniform2uivEXT = (void(GLApi*)(int, GLsizei, const GLuint*))wglGetProcAddress("glUniform2uivEXT"))) ++ n_failed_functions;
	if(!(glUniform3uivEXT = (void(GLApi*)(int, GLsizei, const GLuint*))wglGetProcAddress("glUniform3uivEXT"))) ++ n_failed_functions;
	if(!(glUniform4uivEXT = (void(GLApi*)(int, GLsizei, const GLuint*))wglGetProcAddress("glUniform4uivEXT"))) ++ n_failed_functions;
	if(!(glGetUniformuivEXT = (void(GLApi*)(GLuint, int, GLuint*))wglGetProcAddress("glGetUniformuivEXT"))) ++ n_failed_functions;
	if(!(glBindFragDataLocationEXT = (void(GLApi*)(GLuint, GLuint, const GLchar*))wglGetProcAddress("glBindFragDataLocationEXT"))) ++ n_failed_functions;
	if(!(glGetFragDataLocationEXT = (int(GLApi*)(GLuint, const GLchar*))wglGetProcAddress("glGetFragDataLocationEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_gpu_shader4

	GLEH_EXT_gpu_shader4 = !n_failed_functions && b_SupportedExtension("GL_EXT_gpu_shader4");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_gpu_shader4 ---
 */


/*
 *								--- GL_EXT_multi_draw_arrays ---
 */

bool GLEH_EXT_multi_draw_arrays = false;

#ifdef __GENERATE_GL_EXT_multi_draw_arrays

void (GLApi *glglMultiDrawArraysEXT)(GLenum, int*, GLsizei*, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glglMultiDrawElementsEXT)(GLenum, GLsizei*, GLenum, const void**, GLsizei) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_multi_draw_arrays

int CGLExtensionHandler::n_GetMultiDrawArraysEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_multi_draw_arrays

	if(!(glglMultiDrawArraysEXT = (void(GLApi*)(GLenum, int*, GLsizei*, GLsizei))wglGetProcAddress("glglMultiDrawArraysEXT"))) ++ n_failed_functions;
	if(!(glglMultiDrawElementsEXT = (void(GLApi*)(GLenum, GLsizei*, GLenum, const void**, GLsizei))wglGetProcAddress("glglMultiDrawElementsEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_multi_draw_arrays

	GLEH_EXT_multi_draw_arrays = !n_failed_functions && b_SupportedExtension("GL_EXT_multi_draw_arrays");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_multi_draw_arrays ---
 */


/*
 *								--- GL_EXT_packed_depth_stencil ---
 */

bool GLEH_EXT_packed_depth_stencil = false;

int CGLExtensionHandler::n_GetPackedDepthStencilEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_packed_depth_stencil = !n_failed_functions && b_SupportedExtension("GL_EXT_packed_depth_stencil");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_packed_depth_stencil ---
 */


/*
 *								--- GL_EXT_packed_float ---
 */

bool GLEH_EXT_packed_float = false;

int CGLExtensionHandler::n_GetPackedFloatEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_packed_float = !n_failed_functions && b_SupportedExtension("GL_EXT_packed_float");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_packed_float ---
 */


/*
 *								--- GL_EXT_packed_pixels ---
 */

bool GLEH_EXT_packed_pixels = false;

int CGLExtensionHandler::n_GetPackedPixelsEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_packed_pixels = !n_failed_functions && b_SupportedExtension("GL_EXT_packed_pixels");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_packed_pixels ---
 */


/*
 *								--- GL_EXT_pixel_buffer_object ---
 */

bool GLEH_EXT_pixel_buffer_object = false;

int CGLExtensionHandler::n_GetPixelBufferObjectEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_pixel_buffer_object = !n_failed_functions && b_SupportedExtension("GL_EXT_pixel_buffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_pixel_buffer_object ---
 */


/*
 *								--- GL_EXT_point_parameters ---
 */

bool GLEH_EXT_point_parameters = false;

#ifdef __GENERATE_GL_EXT_point_parameters

void (GLApi *glglPointParameterfEXT)(GLenum, float) INIT_FUNC_POINTERS;
void (GLApi *glglPointParameterfvEXT)(GLenum, float*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_point_parameters

int CGLExtensionHandler::n_GetPointParametersEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_point_parameters

	if(!(glglPointParameterfEXT = (void(GLApi*)(GLenum, float))wglGetProcAddress("glglPointParameterfEXT"))) ++ n_failed_functions;
	if(!(glglPointParameterfvEXT = (void(GLApi*)(GLenum, float*))wglGetProcAddress("glglPointParameterfvEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_point_parameters

	GLEH_EXT_point_parameters = !n_failed_functions && b_SupportedExtension("GL_EXT_point_parameters");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_point_parameters ---
 */


/*
 *								--- GL_EXT_provoking_vertex ---
 */

bool GLEH_EXT_provoking_vertex = false;

#ifdef __GENERATE_GL_EXT_provoking_vertex

void (GLApi *glProvokingVertexEXT)(GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_provoking_vertex

int CGLExtensionHandler::n_GetProvokingVertexEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_provoking_vertex

	if(!(glProvokingVertexEXT = (void(GLApi*)(GLenum))wglGetProcAddress("glProvokingVertexEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_provoking_vertex

	GLEH_EXT_provoking_vertex = !n_failed_functions && b_SupportedExtension("GL_EXT_provoking_vertex");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_provoking_vertex ---
 */


/*
 *								--- GL_EXT_rescale_normal ---
 */

bool GLEH_EXT_rescale_normal = false;

int CGLExtensionHandler::n_GetRescaleNormalEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_rescale_normal = !n_failed_functions && b_SupportedExtension("GL_EXT_rescale_normal");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_rescale_normal ---
 */


/*
 *								--- GL_EXT_secondary_color ---
 */

bool GLEH_EXT_secondary_color = false;

#ifdef __GENERATE_GL_EXT_secondary_color

void (GLApi *glSecondaryColor3bEXT)(GLbyte) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3sEXT)(short) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3iEXT)(int) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3fEXT)(float) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3dEXT)(double) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3ubEXT)(GLubyte) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3usEXT)(GLushort) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3uiEXT)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3bvEXT)(GLbyte) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3svEXT)(short) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3ivEXT)(int) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3fvEXT)(float) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3dvEXT)(double) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3ubvEXT)(GLubyte) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3usvEXT)(GLushort) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3uivEXT)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColorPointerEXT)(int, GLenum, GLsizei, void*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_secondary_color

int CGLExtensionHandler::n_GetSecondaryColorEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_secondary_color

	if(!(glSecondaryColor3bEXT = (void(GLApi*)(GLbyte))wglGetProcAddress("glSecondaryColor3bEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3sEXT = (void(GLApi*)(short))wglGetProcAddress("glSecondaryColor3sEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3iEXT = (void(GLApi*)(int))wglGetProcAddress("glSecondaryColor3iEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3fEXT = (void(GLApi*)(float))wglGetProcAddress("glSecondaryColor3fEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3dEXT = (void(GLApi*)(double))wglGetProcAddress("glSecondaryColor3dEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3ubEXT = (void(GLApi*)(GLubyte))wglGetProcAddress("glSecondaryColor3ubEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3usEXT = (void(GLApi*)(GLushort))wglGetProcAddress("glSecondaryColor3usEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3uiEXT = (void(GLApi*)(GLuint))wglGetProcAddress("glSecondaryColor3uiEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3bvEXT = (void(GLApi*)(GLbyte))wglGetProcAddress("glSecondaryColor3bvEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3svEXT = (void(GLApi*)(short))wglGetProcAddress("glSecondaryColor3svEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3ivEXT = (void(GLApi*)(int))wglGetProcAddress("glSecondaryColor3ivEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3fvEXT = (void(GLApi*)(float))wglGetProcAddress("glSecondaryColor3fvEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3dvEXT = (void(GLApi*)(double))wglGetProcAddress("glSecondaryColor3dvEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3ubvEXT = (void(GLApi*)(GLubyte))wglGetProcAddress("glSecondaryColor3ubvEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3usvEXT = (void(GLApi*)(GLushort))wglGetProcAddress("glSecondaryColor3usvEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColor3uivEXT = (void(GLApi*)(GLuint))wglGetProcAddress("glSecondaryColor3uivEXT"))) ++ n_failed_functions;
	if(!(glSecondaryColorPointerEXT = (void(GLApi*)(int, GLenum, GLsizei, void*))wglGetProcAddress("glSecondaryColorPointerEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_secondary_color

	GLEH_EXT_secondary_color = !n_failed_functions && b_SupportedExtension("GL_EXT_secondary_color");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_secondary_color ---
 */


/*
 *								--- GL_EXT_separate_shader_objects ---
 */

bool GLEH_EXT_separate_shader_objects = false;

#ifdef __GENERATE_GL_EXT_separate_shader_objects

void (GLApi *glUseShaderProgramEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glActiveProgramEXT)(GLuint) INIT_FUNC_POINTERS;
GLuint (GLApi *glCreateShaderProgramEXT)(GLenum, const GLchar*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_separate_shader_objects

int CGLExtensionHandler::n_GetSeparateShaderObjectsEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_separate_shader_objects

	if(!(glUseShaderProgramEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glUseShaderProgramEXT"))) ++ n_failed_functions;
	if(!(glActiveProgramEXT = (void(GLApi*)(GLuint))wglGetProcAddress("glActiveProgramEXT"))) ++ n_failed_functions;
	if(!(glCreateShaderProgramEXT = (GLuint(GLApi*)(GLenum, const GLchar*))wglGetProcAddress("glCreateShaderProgramEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_separate_shader_objects

	GLEH_EXT_separate_shader_objects = !n_failed_functions && b_SupportedExtension("GL_EXT_separate_shader_objects");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_separate_shader_objects ---
 */


/*
 *								--- GL_EXT_separate_specular_color ---
 */

bool GLEH_EXT_separate_specular_color = false;

int CGLExtensionHandler::n_GetSeparateSpecularColorEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_separate_specular_color = !n_failed_functions && b_SupportedExtension("GL_EXT_separate_specular_color");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_separate_specular_color ---
 */


/*
 *								--- GL_EXT_shadow_funcs ---
 */

bool GLEH_EXT_shadow_funcs = false;

int CGLExtensionHandler::n_GetShadowFuncsEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_shadow_funcs = !n_failed_functions && b_SupportedExtension("GL_EXT_shadow_funcs");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_shadow_funcs ---
 */


/*
 *								--- GL_EXT_stencil_two_side ---
 */

bool GLEH_EXT_stencil_two_side = false;

#ifdef __GENERATE_GL_EXT_stencil_two_side

void (GLApi *glActiveStencilFaceEXT)(GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_stencil_two_side

int CGLExtensionHandler::n_GetStencilTwoSideEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_stencil_two_side

	if(!(glActiveStencilFaceEXT = (void(GLApi*)(GLenum))wglGetProcAddress("glActiveStencilFaceEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_stencil_two_side

	GLEH_EXT_stencil_two_side = !n_failed_functions && b_SupportedExtension("GL_EXT_stencil_two_side");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_stencil_two_side ---
 */


/*
 *								--- GL_EXT_stencil_wrap ---
 */

bool GLEH_EXT_stencil_wrap = false;

int CGLExtensionHandler::n_GetStencilWrapEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_stencil_wrap = !n_failed_functions && b_SupportedExtension("GL_EXT_stencil_wrap");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_stencil_wrap ---
 */


/*
 *								--- GL_EXT_texture3D ---
 */

bool GLEH_EXT_texture3D = false;

#ifdef __GENERATE_GL_EXT_texture3D

void (GLApi *glTexImage3DEXT)(GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_texture3D

int CGLExtensionHandler::n_GetTexture3DEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_texture3D

	if(!(glTexImage3DEXT = (void(GLApi*)(GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*))wglGetProcAddress("glTexImage3DEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_texture3D

	GLEH_EXT_texture3D = !n_failed_functions && b_SupportedExtension("GL_EXT_texture3D");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture3D ---
 */


/*
 *								--- GL_EXT_texture_array ---
 */

bool GLEH_EXT_texture_array = false;

#ifdef __GENERATE_GL_EXT_texture_array

//void (GLApi *glFramebufferTextureLayerEXT)(GLenum, GLenum, GLuint, int, int) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_texture_array

int CGLExtensionHandler::n_GetTextureArrayEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_texture_array

	if(!(glFramebufferTextureLayerEXT = (void(GLApi*)(GLenum, GLenum, GLuint, int, int))wglGetProcAddress("glFramebufferTextureLayerEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_texture_array

	GLEH_EXT_texture_array = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_array");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_array ---
 */


/*
 *								--- GL_EXT_texture_buffer_object ---
 */

bool GLEH_EXT_texture_buffer_object = false;

#ifdef __GENERATE_GL_EXT_texture_buffer_object

void (GLApi *glTexBufferEXT)(GLenum, GLenum, GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_texture_buffer_object

int CGLExtensionHandler::n_GetTextureBufferObjectEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_texture_buffer_object

	if(!(glTexBufferEXT = (void(GLApi*)(GLenum, GLenum, GLuint))wglGetProcAddress("glTexBufferEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_texture_buffer_object

	GLEH_EXT_texture_buffer_object = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_buffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_buffer_object ---
 */


/*
 *								--- GL_EXT_texture_compression_latc ---
 */

bool GLEH_EXT_texture_compression_latc = false;

int CGLExtensionHandler::n_GetTextureCompressionLatcEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_compression_latc = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_compression_latc");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_compression_latc ---
 */


/*
 *								--- GL_EXT_texture_compression_rgtc ---
 */

bool GLEH_EXT_texture_compression_rgtc = false;

int CGLExtensionHandler::n_GetTextureCompressionRgtcEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_compression_rgtc = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_compression_rgtc");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_compression_rgtc ---
 */


/*
 *								--- GL_EXT_texture_compression_s3tc ---
 */

bool GLEH_EXT_texture_compression_s3tc = false;

int CGLExtensionHandler::n_GetTextureCompressionS3tcEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_compression_s3tc = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_compression_s3tc");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_compression_s3tc ---
 */


/*
 *								--- GL_EXT_texture_env_combine ---
 */

bool GLEH_EXT_texture_env_combine = false;

int CGLExtensionHandler::n_GetTextureEnvCombineEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_env_combine = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_env_combine");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_env_combine ---
 */


/*
 *								--- GL_EXT_texture_env_dot3 ---
 */

bool GLEH_EXT_texture_env_dot3 = false;

int CGLExtensionHandler::n_GetTextureEnvDot3EXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_env_dot3 = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_env_dot3");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_env_dot3 ---
 */


/*
 *								--- GL_EXT_texture_filter_anisotropic ---
 */

bool GLEH_EXT_texture_filter_anisotropic = false;

int CGLExtensionHandler::n_GetTextureFilterAnisotropicEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_filter_anisotropic = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_filter_anisotropic");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_filter_anisotropic ---
 */


/*
 *								--- GL_EXT_texture_integer ---
 */

bool GLEH_EXT_texture_integer = false;

#ifdef __GENERATE_GL_EXT_texture_integer

void (GLApi *glClearColorIiEXT)(int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glClearColorIuiEXT)(GLuint, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glTexParameterIivEXT)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glTexParameterIuivEXT)(GLenum, GLenum, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetTexParameterIivEXT)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetTexParameterIuivEXT)(GLenum, GLenum, GLuint*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_texture_integer

int CGLExtensionHandler::n_GetTextureIntegerEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_texture_integer

	if(!(glClearColorIiEXT = (void(GLApi*)(int, int, int, int))wglGetProcAddress("glClearColorIiEXT"))) ++ n_failed_functions;
	if(!(glClearColorIuiEXT = (void(GLApi*)(GLuint, GLuint, GLuint, GLuint))wglGetProcAddress("glClearColorIuiEXT"))) ++ n_failed_functions;
	if(!(glTexParameterIivEXT = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glTexParameterIivEXT"))) ++ n_failed_functions;
	if(!(glTexParameterIuivEXT = (void(GLApi*)(GLenum, GLenum, GLuint*))wglGetProcAddress("glTexParameterIuivEXT"))) ++ n_failed_functions;
	if(!(glGetTexParameterIivEXT = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glGetTexParameterIivEXT"))) ++ n_failed_functions;
	if(!(glGetTexParameterIuivEXT = (void(GLApi*)(GLenum, GLenum, GLuint*))wglGetProcAddress("glGetTexParameterIuivEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_texture_integer

	GLEH_EXT_texture_integer = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_integer");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_integer ---
 */


/*
 *								--- GL_EXT_texture_lod_bias ---
 */

bool GLEH_EXT_texture_lod_bias = false;

int CGLExtensionHandler::n_GetTextureLodBiasEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_lod_bias = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_lod_bias");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_lod_bias ---
 */


/*
 *								--- GL_EXT_texture_mirror_clamp ---
 */

bool GLEH_EXT_texture_mirror_clamp = false;

int CGLExtensionHandler::n_GetTextureMirrorClampEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_mirror_clamp = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_mirror_clamp");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_mirror_clamp ---
 */


/*
 *								--- GL_EXT_texture_object ---
 */

bool GLEH_EXT_texture_object = false;

#ifdef __GENERATE_GL_EXT_texture_object

void (GLApi *glGenTexturesEXT)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glDeleteTexturesEXT)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glBindTextureEXT)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glPrioritizeTexturesEXT)(GLsizei, const GLuint*, const GLclampf*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glAreTexturesResidentEXT)(GLsizei, const GLuint*, GLboolean*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsTextureEXT)(GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_texture_object

int CGLExtensionHandler::n_GetTextureObjectEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_texture_object

	if(!(glGenTexturesEXT = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenTexturesEXT"))) ++ n_failed_functions;
	if(!(glDeleteTexturesEXT = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteTexturesEXT"))) ++ n_failed_functions;
	if(!(glBindTextureEXT = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindTextureEXT"))) ++ n_failed_functions;
	if(!(glPrioritizeTexturesEXT = (void(GLApi*)(GLsizei, const GLuint*, const GLclampf*))wglGetProcAddress("glPrioritizeTexturesEXT"))) ++ n_failed_functions;
	if(!(glAreTexturesResidentEXT = (GLboolean(GLApi*)(GLsizei, const GLuint*, GLboolean*))wglGetProcAddress("glAreTexturesResidentEXT"))) ++ n_failed_functions;
	if(!(glIsTextureEXT = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsTextureEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_texture_object

	GLEH_EXT_texture_object = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_object ---
 */


/*
 *								--- GL_EXT_texture_shared_exponent ---
 */

bool GLEH_EXT_texture_shared_exponent = false;

int CGLExtensionHandler::n_GetTextureSharedExponentEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_shared_exponent = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_shared_exponent");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_shared_exponent ---
 */


/*
 *								--- GL_EXT_texture_sRGB ---
 */

bool GLEH_EXT_texture_sRGB = false;

int CGLExtensionHandler::n_GetTextureSRGBEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_sRGB = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_sRGB");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_sRGB ---
 */


/*
 *								--- GL_EXT_texture_swizzle ---
 */

bool GLEH_EXT_texture_swizzle = false;

int CGLExtensionHandler::n_GetTextureSwizzleEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_texture_swizzle = !n_failed_functions && b_SupportedExtension("GL_EXT_texture_swizzle");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_texture_swizzle ---
 */


/*
 *								--- GL_EXT_timer_query ---
 */

bool GLEH_EXT_timer_query = false;

#ifdef __GENERATE_GL_EXT_timer_query

void (GLApi *glGetQueryObjecti64vEXT)(GLuint, GLenum, GLint64EXT*) INIT_FUNC_POINTERS;
void (GLApi *glGetQueryObjectui64vEXT)(GLuint, GLenum, GLuint64EXT*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_timer_query

int CGLExtensionHandler::n_GetTimerQueryEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_timer_query

	if(!(glGetQueryObjecti64vEXT = (void(GLApi*)(GLuint, GLenum, GLint64EXT*))wglGetProcAddress("glGetQueryObjecti64vEXT"))) ++ n_failed_functions;
	if(!(glGetQueryObjectui64vEXT = (void(GLApi*)(GLuint, GLenum, GLuint64EXT*))wglGetProcAddress("glGetQueryObjectui64vEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_timer_query

	GLEH_EXT_timer_query = !n_failed_functions && b_SupportedExtension("GL_EXT_timer_query");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_timer_query ---
 */


/*
 *								--- GL_EXT_vertex_array ---
 */

bool GLEH_EXT_vertex_array = false;

#ifdef __GENERATE_GL_EXT_vertex_array

void (GLApi *glArrayElementEXT)(int) INIT_FUNC_POINTERS;
void (GLApi *glDrawArraysEXT)(GLenum, int, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glVertexPointerEXT)(int, GLenum, GLsizei, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glNormalPointerEXT)(GLenum, GLsizei, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glColorPointerEXT)(int, GLenum, GLsizei, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glIndexPointerEXT)(GLenum, GLsizei, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glTexCoordPointerEXT)(int, GLenum, GLsizei, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glEdgeFlagPointerEXT)(GLsizei, GLsizei, const GLboolean*) INIT_FUNC_POINTERS;
void (GLApi *glGetPointervEXT)(GLenum, void**) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_EXT_vertex_array

int CGLExtensionHandler::n_GetVertexArrayEXTFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_EXT_vertex_array

	if(!(glArrayElementEXT = (void(GLApi*)(int))wglGetProcAddress("glArrayElementEXT"))) ++ n_failed_functions;
	if(!(glDrawArraysEXT = (void(GLApi*)(GLenum, int, GLsizei))wglGetProcAddress("glDrawArraysEXT"))) ++ n_failed_functions;
	if(!(glVertexPointerEXT = (void(GLApi*)(int, GLenum, GLsizei, GLsizei, const void*))wglGetProcAddress("glVertexPointerEXT"))) ++ n_failed_functions;
	if(!(glNormalPointerEXT = (void(GLApi*)(GLenum, GLsizei, GLsizei, const void*))wglGetProcAddress("glNormalPointerEXT"))) ++ n_failed_functions;
	if(!(glColorPointerEXT = (void(GLApi*)(int, GLenum, GLsizei, GLsizei, const void*))wglGetProcAddress("glColorPointerEXT"))) ++ n_failed_functions;
	if(!(glIndexPointerEXT = (void(GLApi*)(GLenum, GLsizei, GLsizei, const void*))wglGetProcAddress("glIndexPointerEXT"))) ++ n_failed_functions;
	if(!(glTexCoordPointerEXT = (void(GLApi*)(int, GLenum, GLsizei, GLsizei, const void*))wglGetProcAddress("glTexCoordPointerEXT"))) ++ n_failed_functions;
	if(!(glEdgeFlagPointerEXT = (void(GLApi*)(GLsizei, GLsizei, const GLboolean*))wglGetProcAddress("glEdgeFlagPointerEXT"))) ++ n_failed_functions;
	if(!(glGetPointervEXT = (void(GLApi*)(GLenum, void**))wglGetProcAddress("glGetPointervEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_EXT_vertex_array

	GLEH_EXT_vertex_array = !n_failed_functions && b_SupportedExtension("GL_EXT_vertex_array");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_vertex_array ---
 */


/*
 *								--- GL_EXT_vertex_array_bgra ---
 */

bool GLEH_EXT_vertex_array_bgra = false;

int CGLExtensionHandler::n_GetVertexArrayBgraEXTFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_EXT_vertex_array_bgra = !n_failed_functions && b_SupportedExtension("GL_EXT_vertex_array_bgra");

	return n_failed_functions;
}

/*
 *								--- ~GL_EXT_vertex_array_bgra ---
 */


/*
 *								--- GL_IBM_rasterpos_clip ---
 */

bool GLEH_IBM_rasterpos_clip = false;

int CGLExtensionHandler::n_GetRasterposClipIBMFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_IBM_rasterpos_clip = !n_failed_functions && b_SupportedExtension("GL_IBM_rasterpos_clip");

	return n_failed_functions;
}

/*
 *								--- ~GL_IBM_rasterpos_clip ---
 */


/*
 *								--- GL_IBM_texture_mirrored_repeat ---
 */

bool GLEH_IBM_texture_mirrored_repeat = false;

int CGLExtensionHandler::n_GetTextureMirroredRepeatIBMFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_IBM_texture_mirrored_repeat = !n_failed_functions && b_SupportedExtension("GL_IBM_texture_mirrored_repeat");

	return n_failed_functions;
}

/*
 *								--- ~GL_IBM_texture_mirrored_repeat ---
 */


/*
 *								--- GL_NV_blend_square ---
 */

bool GLEH_NV_blend_square = false;

int CGLExtensionHandler::n_GetBlendSquareNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_blend_square = !n_failed_functions && b_SupportedExtension("GL_NV_blend_square");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_blend_square ---
 */


/*
 *								--- GL_NV_conditional_render ---
 */

bool GLEH_NV_conditional_render = false;

#ifdef __GENERATE_GL_NV_conditional_render

void (GLApi *glBeginConditionalRenderNV)(GLuint, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glEndConditionalRenderNV)() INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_conditional_render

int CGLExtensionHandler::n_GetConditionalRenderNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_conditional_render

	if(!(glBeginConditionalRenderNV = (void(GLApi*)(GLuint, GLenum))wglGetProcAddress("glBeginConditionalRenderNV"))) ++ n_failed_functions;
	if(!(glEndConditionalRenderNV = (void(GLApi*)())wglGetProcAddress("glEndConditionalRenderNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_conditional_render

	GLEH_NV_conditional_render = !n_failed_functions && b_SupportedExtension("GL_NV_conditional_render");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_conditional_render ---
 */


/*
 *								--- GL_NV_copy_depth_to_color ---
 */

bool GLEH_NV_copy_depth_to_color = false;

int CGLExtensionHandler::n_GetCopyDepthToColorNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_copy_depth_to_color = !n_failed_functions && b_SupportedExtension("GL_NV_copy_depth_to_color");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_copy_depth_to_color ---
 */


/*
 *								--- GL_NV_copy_image ---
 */

bool GLEH_NV_copy_image = false;

#ifdef __GENERATE_GL_NV_copy_image

void (GLApi *glCopyImageSubDataNV)(GLuint, GLenum, int, int, int, int, GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_copy_image

int CGLExtensionHandler::n_GetCopyImageNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_copy_image

	if(!(glCopyImageSubDataNV = (void(GLApi*)(GLuint, GLenum, int, int, int, int, GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei))wglGetProcAddress("glCopyImageSubDataNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_copy_image

	GLEH_NV_copy_image = !n_failed_functions && b_SupportedExtension("GL_NV_copy_image");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_copy_image ---
 */


/*
 *								--- GL_NV_depth_buffer_float ---
 */

bool GLEH_NV_depth_buffer_float = false;

#ifdef __GENERATE_GL_NV_depth_buffer_float

void (GLApi *glDepthRangedNV)(double, double) INIT_FUNC_POINTERS;
void (GLApi *glClearDepthdNV)(double) INIT_FUNC_POINTERS;
void (GLApi *glDepthBoundsdNV)(double, double) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_depth_buffer_float

int CGLExtensionHandler::n_GetDepthBufferFloatNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_depth_buffer_float

	if(!(glDepthRangedNV = (void(GLApi*)(double, double))wglGetProcAddress("glDepthRangedNV"))) ++ n_failed_functions;
	if(!(glClearDepthdNV = (void(GLApi*)(double))wglGetProcAddress("glClearDepthdNV"))) ++ n_failed_functions;
	if(!(glDepthBoundsdNV = (void(GLApi*)(double, double))wglGetProcAddress("glDepthBoundsdNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_depth_buffer_float

	GLEH_NV_depth_buffer_float = !n_failed_functions && b_SupportedExtension("GL_NV_depth_buffer_float");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_depth_buffer_float ---
 */


/*
 *								--- GL_NV_depth_clamp ---
 */

bool GLEH_NV_depth_clamp = false;

int CGLExtensionHandler::n_GetDepthClampNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_depth_clamp = !n_failed_functions && b_SupportedExtension("GL_NV_depth_clamp");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_depth_clamp ---
 */


/*
 *								--- GL_NV_explicit_multisample ---
 */

bool GLEH_NV_explicit_multisample = false;

#ifdef __GENERATE_GL_NV_explicit_multisample

/*void (GLApi *glGetBooleanIndexedvEXT)(GLenum, GLuint, GLboolean*) INIT_FUNC_POINTERS;
void (GLApi *glGetIntegerIndexedvEXT)(GLenum, GLuint, int*) INIT_FUNC_POINTERS;*/
void (GLApi *glGetMultisamplefvNV)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;
void (GLApi *glSampleMaskIndexedNV)(GLuint, GLbitfield) INIT_FUNC_POINTERS;
void (GLApi *glTexRenderbufferNV)(GLenum, GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_explicit_multisample

int CGLExtensionHandler::n_GetExplicitMultisampleNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_explicit_multisample

	if(!(glGetBooleanIndexedvEXT = (void(GLApi*)(GLenum, GLuint, GLboolean*))wglGetProcAddress("glGetBooleanIndexedvEXT"))) ++ n_failed_functions;
	if(!(glGetIntegerIndexedvEXT = (void(GLApi*)(GLenum, GLuint, int*))wglGetProcAddress("glGetIntegerIndexedvEXT"))) ++ n_failed_functions;
	if(!(glGetMultisamplefvNV = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetMultisamplefvNV"))) ++ n_failed_functions;
	if(!(glSampleMaskIndexedNV = (void(GLApi*)(GLuint, GLbitfield))wglGetProcAddress("glSampleMaskIndexedNV"))) ++ n_failed_functions;
	if(!(glTexRenderbufferNV = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glTexRenderbufferNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_explicit_multisample

	GLEH_NV_explicit_multisample = !n_failed_functions && b_SupportedExtension("GL_NV_explicit_multisample");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_explicit_multisample ---
 */


/*
 *								--- GL_NV_fence ---
 */

bool GLEH_NV_fence = false;

#ifdef __GENERATE_GL_NV_fence

void (GLApi *glGenFencesNV)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glDeleteFencesNV)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glSetFenceNV)(GLuint, GLenum) INIT_FUNC_POINTERS;
GLboolean (GLApi *glTestFenceNV)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glFinishFenceNV)(GLuint) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsFenceNV)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetFenceivNV)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_fence

int CGLExtensionHandler::n_GetFenceNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_fence

	if(!(glGenFencesNV = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenFencesNV"))) ++ n_failed_functions;
	if(!(glDeleteFencesNV = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteFencesNV"))) ++ n_failed_functions;
	if(!(glSetFenceNV = (void(GLApi*)(GLuint, GLenum))wglGetProcAddress("glSetFenceNV"))) ++ n_failed_functions;
	if(!(glTestFenceNV = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glTestFenceNV"))) ++ n_failed_functions;
	if(!(glFinishFenceNV = (void(GLApi*)(GLuint))wglGetProcAddress("glFinishFenceNV"))) ++ n_failed_functions;
	if(!(glIsFenceNV = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsFenceNV"))) ++ n_failed_functions;
	if(!(glGetFenceivNV = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetFenceivNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_fence

	GLEH_NV_fence = !n_failed_functions && b_SupportedExtension("GL_NV_fence");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_fence ---
 */


/*
 *								--- GL_NV_float_buffer ---
 */

bool GLEH_NV_float_buffer = false;

int CGLExtensionHandler::n_GetFloatBufferNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_float_buffer = !n_failed_functions && b_SupportedExtension("GL_NV_float_buffer");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_float_buffer ---
 */


/*
 *								--- GL_NV_fog_distance ---
 */

bool GLEH_NV_fog_distance = false;

int CGLExtensionHandler::n_GetFogDistanceNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_fog_distance = !n_failed_functions && b_SupportedExtension("GL_NV_fog_distance");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_fog_distance ---
 */


/*
 *								--- GL_NV_fragment_program ---
 */

bool GLEH_NV_fragment_program = false;

#ifdef __GENERATE_GL_NV_fragment_program

void (GLApi *glProgramNamedParameter4fNV)(GLuint, GLsizei, const GLubyte*, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramNamedParameter4dNV)(GLuint, GLsizei, const GLubyte*, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glProgramNamedParameter4fvNV)(GLuint, GLsizei, const GLubyte*, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramNamedParameter4dvNV)(GLuint, GLsizei, const GLubyte*, const double*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramNamedParameterfvNV)(GLuint, GLsizei, const GLubyte*, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramNamedParameterdvNV)(GLuint, GLsizei, const GLubyte*, double*) INIT_FUNC_POINTERS;
/*void (GLApi *glProgramLocalParameter4dARB)(GLenum, GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4dvARB)(GLenum, GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4fARB)(GLenum, GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameter4fvARB)(GLenum, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramLocalParameterdvARB)(GLenum, GLuint, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramLocalParameterfvARB)(GLenum, GLuint, float*) INIT_FUNC_POINTERS;*/

#endif // __GENERATE_GL_NV_fragment_program

int CGLExtensionHandler::n_GetFragmentProgramNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_fragment_program

	if(!(glProgramNamedParameter4fNV = (void(GLApi*)(GLuint, GLsizei, const GLubyte*, float, float, float, float))wglGetProcAddress("glProgramNamedParameter4fNV"))) ++ n_failed_functions;
	if(!(glProgramNamedParameter4dNV = (void(GLApi*)(GLuint, GLsizei, const GLubyte*, double, double, double, double))wglGetProcAddress("glProgramNamedParameter4dNV"))) ++ n_failed_functions;
	if(!(glProgramNamedParameter4fvNV = (void(GLApi*)(GLuint, GLsizei, const GLubyte*, const float*))wglGetProcAddress("glProgramNamedParameter4fvNV"))) ++ n_failed_functions;
	if(!(glProgramNamedParameter4dvNV = (void(GLApi*)(GLuint, GLsizei, const GLubyte*, const double*))wglGetProcAddress("glProgramNamedParameter4dvNV"))) ++ n_failed_functions;
	if(!(glGetProgramNamedParameterfvNV = (void(GLApi*)(GLuint, GLsizei, const GLubyte*, float*))wglGetProcAddress("glGetProgramNamedParameterfvNV"))) ++ n_failed_functions;
	if(!(glGetProgramNamedParameterdvNV = (void(GLApi*)(GLuint, GLsizei, const GLubyte*, double*))wglGetProcAddress("glGetProgramNamedParameterdvNV"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4dARB = (void(GLApi*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramLocalParameter4dARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4dvARB = (void(GLApi*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramLocalParameter4dvARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4fARB = (void(GLApi*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramLocalParameter4fARB"))) ++ n_failed_functions;
	if(!(glProgramLocalParameter4fvARB = (void(GLApi*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramLocalParameter4fvARB"))) ++ n_failed_functions;
	if(!(glGetProgramLocalParameterdvARB = (void(GLApi*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramLocalParameterdvARB"))) ++ n_failed_functions;
	if(!(glGetProgramLocalParameterfvARB = (void(GLApi*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramLocalParameterfvARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_fragment_program

	GLEH_NV_fragment_program = !n_failed_functions && b_SupportedExtension("GL_NV_fragment_program");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_fragment_program ---
 */


/*
 *								--- GL_NV_fragment_program_option ---
 */

bool GLEH_NV_fragment_program_option = false;

int CGLExtensionHandler::n_GetFragmentProgramOptionNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_fragment_program_option = !n_failed_functions && b_SupportedExtension("GL_NV_fragment_program_option");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_fragment_program_option ---
 */


/*
 *								--- GL_NV_fragment_program2 ---
 */

bool GLEH_NV_fragment_program2 = false;

int CGLExtensionHandler::n_GetFragmentProgram2NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_fragment_program2 = !n_failed_functions && b_SupportedExtension("GL_NV_fragment_program2");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_fragment_program2 ---
 */


/*
 *								--- GL_NV_framebuffer_multisample_coverage ---
 */

bool GLEH_NV_framebuffer_multisample_coverage = false;

#ifdef __GENERATE_GL_NV_framebuffer_multisample_coverage

void (GLApi *glRenderbufferStorageMultisampleCoverageNV)(GLenum, GLsizei, GLsizei, GLenum, GLsizei, GLsizei) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_framebuffer_multisample_coverage

int CGLExtensionHandler::n_GetFramebufferMultisampleCoverageNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_framebuffer_multisample_coverage

	if(!(glRenderbufferStorageMultisampleCoverageNV = (void(GLApi*)(GLenum, GLsizei, GLsizei, GLenum, GLsizei, GLsizei))wglGetProcAddress("glRenderbufferStorageMultisampleCoverageNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_framebuffer_multisample_coverage

	GLEH_NV_framebuffer_multisample_coverage = !n_failed_functions && b_SupportedExtension("GL_NV_framebuffer_multisample_coverage");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_framebuffer_multisample_coverage ---
 */


/*
 *								--- GL_NV_geometry_shader4 ---
 */

bool GLEH_NV_geometry_shader4 = false;

int CGLExtensionHandler::n_GetGeometryShader4NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_geometry_shader4 = !n_failed_functions && b_SupportedExtension("GL_NV_geometry_shader4");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_geometry_shader4 ---
 */


/*
 *								--- GL_NV_gpu_program4 ---
 */

bool GLEH_NV_gpu_program4 = false;

#ifdef __GENERATE_GL_NV_gpu_program4

void (GLApi *glProgramLocalParameterI4iNV)(GLenum, GLuint, int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameterI4ivNV)(GLenum, GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParametersI4ivNV)(GLenum, GLuint, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameterI4uiNV)(GLenum, GLuint, GLuint, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParameterI4uivNV)(GLenum, GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramLocalParametersI4uivNV)(GLenum, GLuint, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameterI4iNV)(GLenum, GLuint, int, int, int, int) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameterI4ivNV)(GLenum, GLuint, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParametersI4ivNV)(GLenum, GLuint, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameterI4uiNV)(GLenum, GLuint, GLuint, GLuint, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParameterI4uivNV)(GLenum, GLuint, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glProgramEnvParametersI4uivNV)(GLenum, GLuint, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramLocalParameterIivNV)(GLenum, GLuint, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramLocalParameterIuivNV)(GLenum, GLuint, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramEnvParameterIivNV)(GLenum, GLuint, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramEnvParameterIuivNV)(GLenum, GLuint, GLuint*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_gpu_program4

int CGLExtensionHandler::n_GetGpuProgram4NVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_gpu_program4

	if(!(glProgramLocalParameterI4iNV = (void(GLApi*)(GLenum, GLuint, int, int, int, int))wglGetProcAddress("glProgramLocalParameterI4iNV"))) ++ n_failed_functions;
	if(!(glProgramLocalParameterI4ivNV = (void(GLApi*)(GLenum, GLuint, const int*))wglGetProcAddress("glProgramLocalParameterI4ivNV"))) ++ n_failed_functions;
	if(!(glProgramLocalParametersI4ivNV = (void(GLApi*)(GLenum, GLuint, GLsizei, const int*))wglGetProcAddress("glProgramLocalParametersI4ivNV"))) ++ n_failed_functions;
	if(!(glProgramLocalParameterI4uiNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLuint, GLuint, GLuint))wglGetProcAddress("glProgramLocalParameterI4uiNV"))) ++ n_failed_functions;
	if(!(glProgramLocalParameterI4uivNV = (void(GLApi*)(GLenum, GLuint, const GLuint*))wglGetProcAddress("glProgramLocalParameterI4uivNV"))) ++ n_failed_functions;
	if(!(glProgramLocalParametersI4uivNV = (void(GLApi*)(GLenum, GLuint, GLsizei, const GLuint*))wglGetProcAddress("glProgramLocalParametersI4uivNV"))) ++ n_failed_functions;
	if(!(glProgramEnvParameterI4iNV = (void(GLApi*)(GLenum, GLuint, int, int, int, int))wglGetProcAddress("glProgramEnvParameterI4iNV"))) ++ n_failed_functions;
	if(!(glProgramEnvParameterI4ivNV = (void(GLApi*)(GLenum, GLuint, const int*))wglGetProcAddress("glProgramEnvParameterI4ivNV"))) ++ n_failed_functions;
	if(!(glProgramEnvParametersI4ivNV = (void(GLApi*)(GLenum, GLuint, GLsizei, const int*))wglGetProcAddress("glProgramEnvParametersI4ivNV"))) ++ n_failed_functions;
	if(!(glProgramEnvParameterI4uiNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLuint, GLuint, GLuint))wglGetProcAddress("glProgramEnvParameterI4uiNV"))) ++ n_failed_functions;
	if(!(glProgramEnvParameterI4uivNV = (void(GLApi*)(GLenum, GLuint, const GLuint*))wglGetProcAddress("glProgramEnvParameterI4uivNV"))) ++ n_failed_functions;
	if(!(glProgramEnvParametersI4uivNV = (void(GLApi*)(GLenum, GLuint, GLsizei, const GLuint*))wglGetProcAddress("glProgramEnvParametersI4uivNV"))) ++ n_failed_functions;
	if(!(glGetProgramLocalParameterIivNV = (void(GLApi*)(GLenum, GLuint, int*))wglGetProcAddress("glGetProgramLocalParameterIivNV"))) ++ n_failed_functions;
	if(!(glGetProgramLocalParameterIuivNV = (void(GLApi*)(GLenum, GLuint, GLuint*))wglGetProcAddress("glGetProgramLocalParameterIuivNV"))) ++ n_failed_functions;
	if(!(glGetProgramEnvParameterIivNV = (void(GLApi*)(GLenum, GLuint, int*))wglGetProcAddress("glGetProgramEnvParameterIivNV"))) ++ n_failed_functions;
	if(!(glGetProgramEnvParameterIuivNV = (void(GLApi*)(GLenum, GLuint, GLuint*))wglGetProcAddress("glGetProgramEnvParameterIuivNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_gpu_program4

	GLEH_NV_gpu_program4 = !n_failed_functions && b_SupportedExtension("GL_NV_gpu_program4");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_gpu_program4 ---
 */


/*
 *								--- GL_NV_half_float ---
 */

bool GLEH_NV_half_float = false;

#ifdef __GENERATE_GL_NV_half_float

void (GLApi *glVertex2hNV)(GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glVertex2hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertex3hNV)(GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glVertex3hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertex4hNV)(GLhalf, GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glVertex4hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glNormal3hNV)(GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glNormal3hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glColor3hNV)(GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glColor3hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glColor4hNV)(GLhalf, GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glColor4hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glTexCoord1hNV)(GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glTexCoord1hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glTexCoord2hNV)(GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glTexCoord2hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glTexCoord3hNV)(GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glTexCoord3hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glTexCoord4hNV)(GLhalf, GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glTexCoord4hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1hNV)(GLenum, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord1hvNV)(GLenum, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2hNV)(GLenum, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord2hvNV)(GLenum, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3hNV)(GLenum, GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord3hvNV)(GLenum, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4hNV)(GLenum, GLhalf, GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glMultiTexCoord4hvNV)(GLenum, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordhNV)(GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordhvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3hNV)(GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColor3hvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexWeighthNV)(GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glVertexWeighthvNV)(const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1hNV)(GLuint, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1hvNV)(GLuint, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2hNV)(GLuint, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2hvNV)(GLuint, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3hNV)(GLuint, GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3hvNV)(GLuint, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4hNV)(GLuint, GLhalf, GLhalf, GLhalf, GLhalf) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4hvNV)(GLuint, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs1hvNV)(GLuint, GLsizei, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs2hvNV)(GLuint, GLsizei, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs3hvNV)(GLuint, GLsizei, const GLhalf*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs4hvNV)(GLuint, GLsizei, const GLhalf*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_half_float

int CGLExtensionHandler::n_GetHalfFloatNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_half_float

	if(!(glVertex2hNV = (void(GLApi*)(GLhalf, GLhalf))wglGetProcAddress("glVertex2hNV"))) ++ n_failed_functions;
	if(!(glVertex2hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glVertex2hvNV"))) ++ n_failed_functions;
	if(!(glVertex3hNV = (void(GLApi*)(GLhalf, GLhalf, GLhalf))wglGetProcAddress("glVertex3hNV"))) ++ n_failed_functions;
	if(!(glVertex3hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glVertex3hvNV"))) ++ n_failed_functions;
	if(!(glVertex4hNV = (void(GLApi*)(GLhalf, GLhalf, GLhalf, GLhalf))wglGetProcAddress("glVertex4hNV"))) ++ n_failed_functions;
	if(!(glVertex4hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glVertex4hvNV"))) ++ n_failed_functions;
	if(!(glNormal3hNV = (void(GLApi*)(GLhalf, GLhalf, GLhalf))wglGetProcAddress("glNormal3hNV"))) ++ n_failed_functions;
	if(!(glNormal3hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glNormal3hvNV"))) ++ n_failed_functions;
	if(!(glColor3hNV = (void(GLApi*)(GLhalf, GLhalf, GLhalf))wglGetProcAddress("glColor3hNV"))) ++ n_failed_functions;
	if(!(glColor3hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glColor3hvNV"))) ++ n_failed_functions;
	if(!(glColor4hNV = (void(GLApi*)(GLhalf, GLhalf, GLhalf, GLhalf))wglGetProcAddress("glColor4hNV"))) ++ n_failed_functions;
	if(!(glColor4hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glColor4hvNV"))) ++ n_failed_functions;
	if(!(glTexCoord1hNV = (void(GLApi*)(GLhalf))wglGetProcAddress("glTexCoord1hNV"))) ++ n_failed_functions;
	if(!(glTexCoord1hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glTexCoord1hvNV"))) ++ n_failed_functions;
	if(!(glTexCoord2hNV = (void(GLApi*)(GLhalf, GLhalf))wglGetProcAddress("glTexCoord2hNV"))) ++ n_failed_functions;
	if(!(glTexCoord2hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glTexCoord2hvNV"))) ++ n_failed_functions;
	if(!(glTexCoord3hNV = (void(GLApi*)(GLhalf, GLhalf, GLhalf))wglGetProcAddress("glTexCoord3hNV"))) ++ n_failed_functions;
	if(!(glTexCoord3hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glTexCoord3hvNV"))) ++ n_failed_functions;
	if(!(glTexCoord4hNV = (void(GLApi*)(GLhalf, GLhalf, GLhalf, GLhalf))wglGetProcAddress("glTexCoord4hNV"))) ++ n_failed_functions;
	if(!(glTexCoord4hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glTexCoord4hvNV"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1hNV = (void(GLApi*)(GLenum, GLhalf))wglGetProcAddress("glMultiTexCoord1hNV"))) ++ n_failed_functions;
	if(!(glMultiTexCoord1hvNV = (void(GLApi*)(GLenum, const GLhalf*))wglGetProcAddress("glMultiTexCoord1hvNV"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2hNV = (void(GLApi*)(GLenum, GLhalf, GLhalf))wglGetProcAddress("glMultiTexCoord2hNV"))) ++ n_failed_functions;
	if(!(glMultiTexCoord2hvNV = (void(GLApi*)(GLenum, const GLhalf*))wglGetProcAddress("glMultiTexCoord2hvNV"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3hNV = (void(GLApi*)(GLenum, GLhalf, GLhalf, GLhalf))wglGetProcAddress("glMultiTexCoord3hNV"))) ++ n_failed_functions;
	if(!(glMultiTexCoord3hvNV = (void(GLApi*)(GLenum, const GLhalf*))wglGetProcAddress("glMultiTexCoord3hvNV"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4hNV = (void(GLApi*)(GLenum, GLhalf, GLhalf, GLhalf, GLhalf))wglGetProcAddress("glMultiTexCoord4hNV"))) ++ n_failed_functions;
	if(!(glMultiTexCoord4hvNV = (void(GLApi*)(GLenum, const GLhalf*))wglGetProcAddress("glMultiTexCoord4hvNV"))) ++ n_failed_functions;
	if(!(glFogCoordhNV = (void(GLApi*)(GLhalf))wglGetProcAddress("glFogCoordhNV"))) ++ n_failed_functions;
	if(!(glFogCoordhvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glFogCoordhvNV"))) ++ n_failed_functions;
	if(!(glSecondaryColor3hNV = (void(GLApi*)(GLhalf, GLhalf, GLhalf))wglGetProcAddress("glSecondaryColor3hNV"))) ++ n_failed_functions;
	if(!(glSecondaryColor3hvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glSecondaryColor3hvNV"))) ++ n_failed_functions;
	if(!(glVertexWeighthNV = (void(GLApi*)(GLhalf))wglGetProcAddress("glVertexWeighthNV"))) ++ n_failed_functions;
	if(!(glVertexWeighthvNV = (void(GLApi*)(const GLhalf*))wglGetProcAddress("glVertexWeighthvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib1hNV = (void(GLApi*)(GLuint, GLhalf))wglGetProcAddress("glVertexAttrib1hNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib1hvNV = (void(GLApi*)(GLuint, const GLhalf*))wglGetProcAddress("glVertexAttrib1hvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib2hNV = (void(GLApi*)(GLuint, GLhalf, GLhalf))wglGetProcAddress("glVertexAttrib2hNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib2hvNV = (void(GLApi*)(GLuint, const GLhalf*))wglGetProcAddress("glVertexAttrib2hvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib3hNV = (void(GLApi*)(GLuint, GLhalf, GLhalf, GLhalf))wglGetProcAddress("glVertexAttrib3hNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib3hvNV = (void(GLApi*)(GLuint, const GLhalf*))wglGetProcAddress("glVertexAttrib3hvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4hNV = (void(GLApi*)(GLuint, GLhalf, GLhalf, GLhalf, GLhalf))wglGetProcAddress("glVertexAttrib4hNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4hvNV = (void(GLApi*)(GLuint, const GLhalf*))wglGetProcAddress("glVertexAttrib4hvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs1hvNV = (void(GLApi*)(GLuint, GLsizei, const GLhalf*))wglGetProcAddress("glVertexAttribs1hvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs2hvNV = (void(GLApi*)(GLuint, GLsizei, const GLhalf*))wglGetProcAddress("glVertexAttribs2hvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs3hvNV = (void(GLApi*)(GLuint, GLsizei, const GLhalf*))wglGetProcAddress("glVertexAttribs3hvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs4hvNV = (void(GLApi*)(GLuint, GLsizei, const GLhalf*))wglGetProcAddress("glVertexAttribs4hvNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_half_float

	GLEH_NV_half_float = !n_failed_functions && b_SupportedExtension("GL_NV_half_float");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_half_float ---
 */


/*
 *								--- GL_NV_light_max_exponent ---
 */

bool GLEH_NV_light_max_exponent = false;

int CGLExtensionHandler::n_GetLightMaxExponentNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_light_max_exponent = !n_failed_functions && b_SupportedExtension("GL_NV_light_max_exponent");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_light_max_exponent ---
 */


/*
 *								--- GL_NV_multisample_filter_hint ---
 */

bool GLEH_NV_multisample_filter_hint = false;

int CGLExtensionHandler::n_GetMultisampleFilterHintNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_multisample_filter_hint = !n_failed_functions && b_SupportedExtension("GL_NV_multisample_filter_hint");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_multisample_filter_hint ---
 */


/*
 *								--- GL_NV_occlusion_query ---
 */

bool GLEH_NV_occlusion_query = false;

#ifdef __GENERATE_GL_NV_occlusion_query

void (GLApi *glGenOcclusionQueriesNV)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glDeleteOcclusionQueriesNV)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsOcclusionQueryNV)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glBeginOcclusionQueryNV)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glEndOcclusionQueryNV)() INIT_FUNC_POINTERS;
void (GLApi *glGetOcclusionQueryivNV)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetOcclusionQueryuivNV)(GLuint, GLenum, GLuint*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_occlusion_query

int CGLExtensionHandler::n_GetOcclusionQueryNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_occlusion_query

	if(!(glGenOcclusionQueriesNV = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenOcclusionQueriesNV"))) ++ n_failed_functions;
	if(!(glDeleteOcclusionQueriesNV = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteOcclusionQueriesNV"))) ++ n_failed_functions;
	if(!(glIsOcclusionQueryNV = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsOcclusionQueryNV"))) ++ n_failed_functions;
	if(!(glBeginOcclusionQueryNV = (void(GLApi*)(GLuint))wglGetProcAddress("glBeginOcclusionQueryNV"))) ++ n_failed_functions;
	if(!(glEndOcclusionQueryNV = (void(GLApi*)())wglGetProcAddress("glEndOcclusionQueryNV"))) ++ n_failed_functions;
	if(!(glGetOcclusionQueryivNV = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetOcclusionQueryivNV"))) ++ n_failed_functions;
	if(!(glGetOcclusionQueryuivNV = (void(GLApi*)(GLuint, GLenum, GLuint*))wglGetProcAddress("glGetOcclusionQueryuivNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_occlusion_query

	GLEH_NV_occlusion_query = !n_failed_functions && b_SupportedExtension("GL_NV_occlusion_query");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_occlusion_query ---
 */


/*
 *								--- GL_NV_packed_depth_stencil ---
 */

bool GLEH_NV_packed_depth_stencil = false;

int CGLExtensionHandler::n_GetPackedDepthStencilNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_packed_depth_stencil = !n_failed_functions && b_SupportedExtension("GL_NV_packed_depth_stencil");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_packed_depth_stencil ---
 */


/*
 *								--- GL_NV_parameter_buffer_object ---
 */

bool GLEH_NV_parameter_buffer_object = false;

#ifdef __GENERATE_GL_NV_parameter_buffer_object

void (GLApi *glBindBufferRangeNV)(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr) INIT_FUNC_POINTERS;
void (GLApi *glBindBufferOffsetNV)(GLenum, GLuint, GLuint, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glBindBufferBaseNV)(GLenum, GLuint, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glProgramBufferParametersfvNV)(GLenum, GLuint, GLuint, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramBufferParametersIivNV)(GLenum, GLuint, GLuint, GLsizei, const int*) INIT_FUNC_POINTERS;
void (GLApi *glProgramBufferParametersIuivNV)(GLenum, GLuint, GLuint, GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetIntegerIndexedvNV)(GLenum, GLuint, GLboolean*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_parameter_buffer_object

int CGLExtensionHandler::n_GetParameterBufferObjectNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_parameter_buffer_object

	if(!(glBindBufferRangeNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr))wglGetProcAddress("glBindBufferRangeNV"))) ++ n_failed_functions;
	if(!(glBindBufferOffsetNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLintptr))wglGetProcAddress("glBindBufferOffsetNV"))) ++ n_failed_functions;
	if(!(glBindBufferBaseNV = (void(GLApi*)(GLenum, GLuint, GLuint))wglGetProcAddress("glBindBufferBaseNV"))) ++ n_failed_functions;
	if(!(glProgramBufferParametersfvNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLsizei, const float*))wglGetProcAddress("glProgramBufferParametersfvNV"))) ++ n_failed_functions;
	if(!(glProgramBufferParametersIivNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLsizei, const int*))wglGetProcAddress("glProgramBufferParametersIivNV"))) ++ n_failed_functions;
	if(!(glProgramBufferParametersIuivNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLsizei, const GLuint*))wglGetProcAddress("glProgramBufferParametersIuivNV"))) ++ n_failed_functions;
	if(!(glGetIntegerIndexedvNV = (void(GLApi*)(GLenum, GLuint, GLboolean*))wglGetProcAddress("glGetIntegerIndexedvEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_parameter_buffer_object

	GLEH_NV_parameter_buffer_object = !n_failed_functions && b_SupportedExtension("GL_NV_parameter_buffer_object");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_parameter_buffer_object ---
 */


/*
 *								--- GL_NV_parameter_buffer_object2 ---
 */

bool GLEH_NV_parameter_buffer_object2 = false;

int CGLExtensionHandler::n_GetParameterBufferObject2NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_parameter_buffer_object2 = !n_failed_functions && b_SupportedExtension("GL_NV_parameter_buffer_object2");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_parameter_buffer_object2 ---
 */


/*
 *								--- GL_NV_pixel_data_range ---
 */

bool GLEH_NV_pixel_data_range = false;

#ifdef __GENERATE_GL_NV_pixel_data_range

void (GLApi *glPixelDataRangeNV)(GLenum, GLsizei, void*) INIT_FUNC_POINTERS;
void (GLApi *glFlushPixelDataRangeNV)(GLenum) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_pixel_data_range

int CGLExtensionHandler::n_GetPixelDataRangeNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_pixel_data_range

	if(!(glPixelDataRangeNV = (void(GLApi*)(GLenum, GLsizei, void*))wglGetProcAddress("glPixelDataRangeNV"))) ++ n_failed_functions;
	if(!(glFlushPixelDataRangeNV = (void(GLApi*)(GLenum))wglGetProcAddress("glFlushPixelDataRangeNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_pixel_data_range

	GLEH_NV_pixel_data_range = !n_failed_functions && b_SupportedExtension("GL_NV_pixel_data_range");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_pixel_data_range ---
 */


/*
 *								--- GL_NV_point_sprite ---
 */

bool GLEH_NV_point_sprite = false;

#ifdef __GENERATE_GL_NV_point_sprite

void (GLApi *glPointParameteriNV)(GLenum, int) INIT_FUNC_POINTERS;
void (GLApi *glPointParameterivNV)(GLenum, const int*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_point_sprite

int CGLExtensionHandler::n_GetPointSpriteNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_point_sprite

	if(!(glPointParameteriNV = (void(GLApi*)(GLenum, int))wglGetProcAddress("glPointParameteriNV"))) ++ n_failed_functions;
	if(!(glPointParameterivNV = (void(GLApi*)(GLenum, const int*))wglGetProcAddress("glPointParameterivNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_point_sprite

	GLEH_NV_point_sprite = !n_failed_functions && b_SupportedExtension("GL_NV_point_sprite");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_point_sprite ---
 */


/*
 *								--- GL_NV_primitive_restart ---
 */

bool GLEH_NV_primitive_restart = false;

#ifdef __GENERATE_GL_NV_primitive_restart

void (GLApi *glPrimitiveRestartNV)() INIT_FUNC_POINTERS;
void (GLApi *glPrimitiveRestartIndexNV)(GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_primitive_restart

int CGLExtensionHandler::n_GetPrimitiveRestartNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_primitive_restart

	if(!(glPrimitiveRestartNV = (void(GLApi*)())wglGetProcAddress("glPrimitiveRestartNV"))) ++ n_failed_functions;
	if(!(glPrimitiveRestartIndexNV = (void(GLApi*)(GLuint))wglGetProcAddress("glPrimitiveRestartIndexNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_primitive_restart

	GLEH_NV_primitive_restart = !n_failed_functions && b_SupportedExtension("GL_NV_primitive_restart");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_primitive_restart ---
 */


/*
 *								--- GL_NV_register_combiners ---
 */

bool GLEH_NV_register_combiners = false;

#ifdef __GENERATE_GL_NV_register_combiners

void (GLApi *glCombinerParameterfvNV)(GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glCombinerParameterivNV)(GLenum, const int*) INIT_FUNC_POINTERS;
void (GLApi *glCombinerParameterfNV)(GLenum, float) INIT_FUNC_POINTERS;
void (GLApi *glCombinerParameteriNV)(GLenum, int) INIT_FUNC_POINTERS;
void (GLApi *glCombinerInputNV)(GLenum, GLenum, GLenum, GLenum, GLenum, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glCombinerOutputNV)(GLenum, GLenum, GLenum, GLenum, GLenum, GLenum, GLenum, GLboolean, GLboolean, GLboolean) INIT_FUNC_POINTERS;
void (GLApi *glFinalCombinerInputNV)(GLenum, GLenum, GLenum, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glGetCombinerInputParameterfvNV)(GLenum, GLenum, GLenum, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetCombinerInputParameterivNV)(GLenum, GLenum, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetCombinerOutputParameterfvNV)(GLenum, GLenum, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetCombinerOutputParameterivNV)(GLenum, GLenum, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetFinalCombinerInputParameterfvNV)(GLenum, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetFinalCombinerInputParameterivNV)(GLenum, GLenum, int*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_register_combiners

int CGLExtensionHandler::n_GetRegisterCombinersNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_register_combiners

	if(!(glCombinerParameterfvNV = (void(GLApi*)(GLenum, const float*))wglGetProcAddress("glCombinerParameterfvNV"))) ++ n_failed_functions;
	if(!(glCombinerParameterivNV = (void(GLApi*)(GLenum, const int*))wglGetProcAddress("glCombinerParameterivNV"))) ++ n_failed_functions;
	if(!(glCombinerParameterfNV = (void(GLApi*)(GLenum, float))wglGetProcAddress("glCombinerParameterfNV"))) ++ n_failed_functions;
	if(!(glCombinerParameteriNV = (void(GLApi*)(GLenum, int))wglGetProcAddress("glCombinerParameteriNV"))) ++ n_failed_functions;
	if(!(glCombinerInputNV = (void(GLApi*)(GLenum, GLenum, GLenum, GLenum, GLenum, GLenum))wglGetProcAddress("glCombinerInputNV"))) ++ n_failed_functions;
	if(!(glCombinerOutputNV = (void(GLApi*)(GLenum, GLenum, GLenum, GLenum, GLenum, GLenum, GLenum, GLboolean, GLboolean, GLboolean))wglGetProcAddress("glCombinerOutputNV"))) ++ n_failed_functions;
	if(!(glFinalCombinerInputNV = (void(GLApi*)(GLenum, GLenum, GLenum, GLenum))wglGetProcAddress("glFinalCombinerInputNV"))) ++ n_failed_functions;
	if(!(glGetCombinerInputParameterfvNV = (void(GLApi*)(GLenum, GLenum, GLenum, GLenum, float*))wglGetProcAddress("glGetCombinerInputParameterfvNV"))) ++ n_failed_functions;
	if(!(glGetCombinerInputParameterivNV = (void(GLApi*)(GLenum, GLenum, GLenum, GLenum, int*))wglGetProcAddress("glGetCombinerInputParameterivNV"))) ++ n_failed_functions;
	if(!(glGetCombinerOutputParameterfvNV = (void(GLApi*)(GLenum, GLenum, GLenum, float*))wglGetProcAddress("glGetCombinerOutputParameterfvNV"))) ++ n_failed_functions;
	if(!(glGetCombinerOutputParameterivNV = (void(GLApi*)(GLenum, GLenum, GLenum, int*))wglGetProcAddress("glGetCombinerOutputParameterivNV"))) ++ n_failed_functions;
	if(!(glGetFinalCombinerInputParameterfvNV = (void(GLApi*)(GLenum, GLenum, float*))wglGetProcAddress("glGetFinalCombinerInputParameterfvNV"))) ++ n_failed_functions;
	if(!(glGetFinalCombinerInputParameterivNV = (void(GLApi*)(GLenum, GLenum, int*))wglGetProcAddress("glGetFinalCombinerInputParameterivNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_register_combiners

	GLEH_NV_register_combiners = !n_failed_functions && b_SupportedExtension("GL_NV_register_combiners");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_register_combiners ---
 */


/*
 *								--- GL_NV_register_combiners2 ---
 */

bool GLEH_NV_register_combiners2 = false;

#ifdef __GENERATE_GL_NV_register_combiners2

void (GLApi *glCombinerStageParameterfvNV)(GLenum, GLenum, const float*) INIT_FUNC_POINTERS;
void (GLApi *glGetCombinerStageParameterfvNV)(GLenum, GLenum, float*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_register_combiners2

int CGLExtensionHandler::n_GetRegisterCombiners2NVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_register_combiners2

	if(!(glCombinerStageParameterfvNV = (void(GLApi*)(GLenum, GLenum, const float*))wglGetProcAddress("glCombinerStageParameterfvNV"))) ++ n_failed_functions;
	if(!(glGetCombinerStageParameterfvNV = (void(GLApi*)(GLenum, GLenum, float*))wglGetProcAddress("glGetCombinerStageParameterfvNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_register_combiners2

	GLEH_NV_register_combiners2 = !n_failed_functions && b_SupportedExtension("GL_NV_register_combiners2");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_register_combiners2 ---
 */


/*
 *								--- GL_NV_shader_buffer_load ---
 */

bool GLEH_NV_shader_buffer_load = false;

#ifdef __GENERATE_GL_NV_shader_buffer_load

void (GLApi *glMakeBufferResidentNV)(GLenum, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glMakeBufferNonResidentNV)(GLenum) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsBufferResidentNV)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glMakeNamedBufferResidentNV)(GLuint, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glMakeNamedBufferNonResidentNV)(GLuint) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsNamedBufferResidentNV)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glGetBufferParameterui64vNV)(GLenum, GLenum, GLuint64EXT*) INIT_FUNC_POINTERS;
void (GLApi *glGetNamedBufferParameterui64vNV)(GLuint, GLenum, GLuint64EXT*) INIT_FUNC_POINTERS;
void (GLApi *glGetIntegerui64vNV)(GLenum, GLuint64EXT*) INIT_FUNC_POINTERS;
void (GLApi *glUniformui64NV)(int, GLuint64EXT) INIT_FUNC_POINTERS;
void (GLApi *glUniformui64vNV)(int, GLsizei, const GLuint64EXT*) INIT_FUNC_POINTERS;
void (GLApi *glGetUniformui64vNV)(GLuint, int, GLuint64EXT*) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformui64NV)(GLuint, int, GLuint64EXT) INIT_FUNC_POINTERS;
void (GLApi *glProgramUniformui64vNV)(GLuint, int, GLsizei, const GLuint64EXT*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_shader_buffer_load

int CGLExtensionHandler::n_GetShaderBufferLoadNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_shader_buffer_load

	if(!(glMakeBufferResidentNV = (void(GLApi*)(GLenum, GLenum))wglGetProcAddress("glMakeBufferResidentNV"))) ++ n_failed_functions;
	if(!(glMakeBufferNonResidentNV = (void(GLApi*)(GLenum))wglGetProcAddress("glMakeBufferNonResidentNV"))) ++ n_failed_functions;
	if(!(glIsBufferResidentNV = (GLboolean(GLApi*)(GLenum))wglGetProcAddress("glIsBufferResidentNV"))) ++ n_failed_functions;
	if(!(glMakeNamedBufferResidentNV = (void(GLApi*)(GLuint, GLenum))wglGetProcAddress("glMakeNamedBufferResidentNV"))) ++ n_failed_functions;
	if(!(glMakeNamedBufferNonResidentNV = (void(GLApi*)(GLuint))wglGetProcAddress("glMakeNamedBufferNonResidentNV"))) ++ n_failed_functions;
	if(!(glIsNamedBufferResidentNV = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsNamedBufferResidentNV"))) ++ n_failed_functions;
	if(!(glGetBufferParameterui64vNV = (void(GLApi*)(GLenum, GLenum, GLuint64EXT*))wglGetProcAddress("glGetBufferParameterui64vNV"))) ++ n_failed_functions;
	if(!(glGetNamedBufferParameterui64vNV = (void(GLApi*)(GLuint, GLenum, GLuint64EXT*))wglGetProcAddress("glGetNamedBufferParameterui64vNV"))) ++ n_failed_functions;
	if(!(glGetIntegerui64vNV = (void(GLApi*)(GLenum, GLuint64EXT*))wglGetProcAddress("glGetIntegerui64vNV"))) ++ n_failed_functions;
	if(!(glUniformui64NV = (void(GLApi*)(int, GLuint64EXT))wglGetProcAddress("glUniformui64NV"))) ++ n_failed_functions;
	if(!(glUniformui64vNV = (void(GLApi*)(int, GLsizei, const GLuint64EXT*))wglGetProcAddress("glUniformui64vNV"))) ++ n_failed_functions;
	if(!(glGetUniformui64vNV = (void(GLApi*)(GLuint, int, GLuint64EXT*))wglGetProcAddress("glGetUniformui64vNV"))) ++ n_failed_functions;
	if(!(glProgramUniformui64NV = (void(GLApi*)(GLuint, int, GLuint64EXT))wglGetProcAddress("glProgramUniformui64NV"))) ++ n_failed_functions;
	if(!(glProgramUniformui64vNV = (void(GLApi*)(GLuint, int, GLsizei, const GLuint64EXT*))wglGetProcAddress("glProgramUniformui64vNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_shader_buffer_load

	GLEH_NV_shader_buffer_load = !n_failed_functions && b_SupportedExtension("GL_NV_shader_buffer_load");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_shader_buffer_load ---
 */


/*
 *								--- GL_NV_texgen_reflection ---
 */

bool GLEH_NV_texgen_reflection = false;

int CGLExtensionHandler::n_GetTexgenReflectionNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_texgen_reflection = !n_failed_functions && b_SupportedExtension("GL_NV_texgen_reflection");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texgen_reflection ---
 */


/*
 *								--- GL_NV_texture_barrier ---
 */

bool GLEH_NV_texture_barrier = false;

#ifdef __GENERATE_GL_NV_texture_barrier

void (GLApi *glTextureBarrierNV)() INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_texture_barrier

int CGLExtensionHandler::n_GetTextureBarrierNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_texture_barrier

	if(!(glTextureBarrierNV = (void(GLApi*)())wglGetProcAddress("glTextureBarrierNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_texture_barrier

	GLEH_NV_texture_barrier = !n_failed_functions && b_SupportedExtension("GL_NV_texture_barrier");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texture_barrier ---
 */


/*
 *								--- GL_NV_texture_compression_vtc ---
 */

bool GLEH_NV_texture_compression_vtc = false;

int CGLExtensionHandler::n_GetTextureCompressionVtcNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_texture_compression_vtc = !n_failed_functions && b_SupportedExtension("GL_NV_texture_compression_vtc");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texture_compression_vtc ---
 */


/*
 *								--- GL_NV_texture_env_combine4 ---
 */

bool GLEH_NV_texture_env_combine4 = false;

int CGLExtensionHandler::n_GetTextureEnvCombine4NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_texture_env_combine4 = !n_failed_functions && b_SupportedExtension("GL_NV_texture_env_combine4");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texture_env_combine4 ---
 */


/*
 *								--- GL_NV_texture_expand_normal ---
 */

bool GLEH_NV_texture_expand_normal = false;

int CGLExtensionHandler::n_GetTextureExpandNormalNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_texture_expand_normal = !n_failed_functions && b_SupportedExtension("GL_NV_texture_expand_normal");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texture_expand_normal ---
 */


/*
 *								--- GL_NV_texture_rectangle ---
 */

bool GLEH_NV_texture_rectangle = false;

int CGLExtensionHandler::n_GetTextureRectangleNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_texture_rectangle = !n_failed_functions && b_SupportedExtension("GL_NV_texture_rectangle");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texture_rectangle ---
 */


/*
 *								--- GL_NV_texture_shader ---
 */

bool GLEH_NV_texture_shader = false;

int CGLExtensionHandler::n_GetTextureShaderNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_texture_shader = !n_failed_functions && b_SupportedExtension("GL_NV_texture_shader");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texture_shader ---
 */


/*
 *								--- GL_NV_texture_shader2 ---
 */

bool GLEH_NV_texture_shader2 = false;

int CGLExtensionHandler::n_GetTextureShader2NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_texture_shader2 = !n_failed_functions && b_SupportedExtension("GL_NV_texture_shader2");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texture_shader2 ---
 */


/*
 *								--- GL_NV_texture_shader3 ---
 */

bool GLEH_NV_texture_shader3 = false;

int CGLExtensionHandler::n_GetTextureShader3NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_texture_shader3 = !n_failed_functions && b_SupportedExtension("GL_NV_texture_shader3");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_texture_shader3 ---
 */


/*
 *								--- GL_NV_transform_feedback ---
 */

bool GLEH_NV_transform_feedback = false;

#ifdef __GENERATE_GL_NV_transform_feedback

/*void (GLApi *glBindBufferRangeNV)(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr) INIT_FUNC_POINTERS;
void (GLApi *glBindBufferOffsetNV)(GLenum, GLuint, GLuint, GLintptr) INIT_FUNC_POINTERS;
void (GLApi *glBindBufferBaseNV)(GLenum, GLuint, GLuint) INIT_FUNC_POINTERS;*/
void (GLApi *glTransformFeedbackAttribsNV)(GLsizei, const int*, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glTransformFeedbackVaryingsNV)(GLuint, GLsizei, const int*, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glBeginTransformFeedbackNV)(GLenum) INIT_FUNC_POINTERS;
void (GLApi *glEndTransformFeedbackNV)() INIT_FUNC_POINTERS;
int (GLApi *glGetVaryingLocationNV)(GLuint, const GLchar*) INIT_FUNC_POINTERS;
void (GLApi *glGetActiveVaryingNV)(GLuint, GLuint, GLsizei, GLsizei*, GLsizei*, GLenum*, GLchar*) INIT_FUNC_POINTERS;
void (GLApi *glActiveVaryingNV)(GLuint, const GLchar*) INIT_FUNC_POINTERS;
void (GLApi *glGetTransformFeedbackVaryingNV)(GLuint, GLuint, int*) INIT_FUNC_POINTERS;
/*void (GLApi *glGetIntegerIndexedvEXT)(GLenum, GLuint, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetBooleanIndexedvEXT)(GLenum, GLuint, GLboolean*) INIT_FUNC_POINTERS;*/

#endif // __GENERATE_GL_NV_transform_feedback

int CGLExtensionHandler::n_GetTransformFeedbackNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_transform_feedback

	if(!(glBindBufferRangeNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr))wglGetProcAddress("glBindBufferRangeNV"))) ++ n_failed_functions;
	if(!(glBindBufferOffsetNV = (void(GLApi*)(GLenum, GLuint, GLuint, GLintptr))wglGetProcAddress("glBindBufferOffsetNV"))) ++ n_failed_functions;
	if(!(glBindBufferBaseNV = (void(GLApi*)(GLenum, GLuint, GLuint))wglGetProcAddress("glBindBufferBaseNV"))) ++ n_failed_functions;
	if(!(glTransformFeedbackAttribsNV = (void(GLApi*)(GLsizei, const int*, GLenum))wglGetProcAddress("glTransformFeedbackAttribsNV"))) ++ n_failed_functions;
	if(!(glTransformFeedbackVaryingsNV = (void(GLApi*)(GLuint, GLsizei, const int*, GLenum))wglGetProcAddress("glTransformFeedbackVaryingsNV"))) ++ n_failed_functions;
	if(!(glBeginTransformFeedbackNV = (void(GLApi*)(GLenum))wglGetProcAddress("glBeginTransformFeedbackNV"))) ++ n_failed_functions;
	if(!(glEndTransformFeedbackNV = (void(GLApi*)())wglGetProcAddress("glEndTransformFeedbackNV"))) ++ n_failed_functions;
	if(!(glGetVaryingLocationNV = (int(GLApi*)(GLuint, const GLchar*))wglGetProcAddress("glGetVaryingLocationNV"))) ++ n_failed_functions;
	if(!(glGetActiveVaryingNV = (void(GLApi*)(GLuint, GLuint, GLsizei, GLsizei*, GLsizei*, GLenum*, GLchar*))wglGetProcAddress("glGetActiveVaryingNV"))) ++ n_failed_functions;
	if(!(glActiveVaryingNV = (void(GLApi*)(GLuint, const GLchar*))wglGetProcAddress("glActiveVaryingNV"))) ++ n_failed_functions;
	if(!(glGetTransformFeedbackVaryingNV = (void(GLApi*)(GLuint, GLuint, int*))wglGetProcAddress("glGetTransformFeedbackVaryingNV"))) ++ n_failed_functions;
	if(!(glGetIntegerIndexedvEXT = (void(GLApi*)(GLenum, GLuint, int*))wglGetProcAddress("glGetIntegerIndexedvEXT"))) ++ n_failed_functions;
	if(!(glGetBooleanIndexedvEXT = (void(GLApi*)(GLenum, GLuint, GLboolean*))wglGetProcAddress("glGetBooleanIndexedvEXT"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_transform_feedback

	GLEH_NV_transform_feedback = !n_failed_functions && b_SupportedExtension("GL_NV_transform_feedback");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_transform_feedback ---
 */


/*
 *								--- GL_NV_transform_feedback2 ---
 */

bool GLEH_NV_transform_feedback2 = false;

#ifdef __GENERATE_GL_NV_transform_feedback2

void (GLApi *glBindTransformFeedbackNV)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteTransformFeedbacksNV)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGenTransformFeedbacksNV)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsTransformFeedbackNV)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glPauseTransformFeedbackNV)() INIT_FUNC_POINTERS;
void (GLApi *glResumeTransformFeedbackNV)() INIT_FUNC_POINTERS;
void (GLApi *glDrawTransformFeedbackNV)(GLenum, GLuint) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_transform_feedback2

int CGLExtensionHandler::n_GetTransformFeedback2NVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_transform_feedback2

	if(!(glBindTransformFeedbackNV = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindTransformFeedbackNV"))) ++ n_failed_functions;
	if(!(glDeleteTransformFeedbacksNV = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteTransformFeedbacksNV"))) ++ n_failed_functions;
	if(!(glGenTransformFeedbacksNV = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenTransformFeedbacksNV"))) ++ n_failed_functions;
	if(!(glIsTransformFeedbackNV = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsTransformFeedbackNV"))) ++ n_failed_functions;
	if(!(glPauseTransformFeedbackNV = (void(GLApi*)())wglGetProcAddress("glPauseTransformFeedbackNV"))) ++ n_failed_functions;
	if(!(glResumeTransformFeedbackNV = (void(GLApi*)())wglGetProcAddress("glResumeTransformFeedbackNV"))) ++ n_failed_functions;
	if(!(glDrawTransformFeedbackNV = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glDrawTransformFeedbackNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_transform_feedback2

	GLEH_NV_transform_feedback2 = !n_failed_functions && b_SupportedExtension("GL_NV_transform_feedback2");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_transform_feedback2 ---
 */


/*
 *								--- GL_NV_vertex_array_range ---
 */

bool GLEH_NV_vertex_array_range = false;

#ifdef __GENERATE_GL_NV_vertex_array_range

void (GLApi *glVertexArrayRangeNV)(GLsizei, void*) INIT_FUNC_POINTERS;
void (GLApi *glFlushVertexArrayRangeNV)() INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_vertex_array_range

int CGLExtensionHandler::n_GetVertexArrayRangeNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_vertex_array_range

	if(!(glVertexArrayRangeNV = (void(GLApi*)(GLsizei, void*))wglGetProcAddress("glVertexArrayRangeNV"))) ++ n_failed_functions;
	if(!(glFlushVertexArrayRangeNV = (void(GLApi*)())wglGetProcAddress("glFlushVertexArrayRangeNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_vertex_array_range

	GLEH_NV_vertex_array_range = !n_failed_functions && b_SupportedExtension("GL_NV_vertex_array_range");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_vertex_array_range ---
 */


/*
 *								--- GL_NV_vertex_array_range2 ---
 */

bool GLEH_NV_vertex_array_range2 = false;

int CGLExtensionHandler::n_GetVertexArrayRange2NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_vertex_array_range2 = !n_failed_functions && b_SupportedExtension("GL_NV_vertex_array_range2");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_vertex_array_range2 ---
 */


/*
 *								--- GL_NV_vertex_buffer_unified_memory ---
 */

bool GLEH_NV_vertex_buffer_unified_memory = false;

#ifdef __GENERATE_GL_NV_vertex_buffer_unified_memory

void (GLApi *glBufferAddressRangeNV)(GLenum, GLuint, GLuint64EXT, GLsizeiptr) INIT_FUNC_POINTERS;
void (GLApi *glVertexFormatNV)(int, GLenum, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glNormalFormatNV)(GLenum, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glColorFormatNV)(int, GLenum, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glIndexFormatNV)(GLenum, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glTexCoordFormatNV)(int, GLenum, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glEdgeFlagFormatNV)(GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glSecondaryColorFormatNV)(int, GLenum, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glFogCoordFormatNV)(GLenum, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribFormatNV)(GLuint, int, GLenum, GLboolean, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribIFormatNV)(GLuint, int, GLenum, GLsizei) INIT_FUNC_POINTERS;
void (GLApi *glGetIntegerui64i_vNV)(GLenum, GLuint, GLuint64EXT*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_vertex_buffer_unified_memory

int CGLExtensionHandler::n_GetVertexBufferUnifiedMemoryNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_vertex_buffer_unified_memory

	if(!(glBufferAddressRangeNV = (void(GLApi*)(GLenum, GLuint, GLuint64EXT, GLsizeiptr))wglGetProcAddress("glBufferAddressRangeNV"))) ++ n_failed_functions;
	if(!(glVertexFormatNV = (void(GLApi*)(int, GLenum, GLsizei))wglGetProcAddress("glVertexFormatNV"))) ++ n_failed_functions;
	if(!(glNormalFormatNV = (void(GLApi*)(GLenum, GLsizei))wglGetProcAddress("glNormalFormatNV"))) ++ n_failed_functions;
	if(!(glColorFormatNV = (void(GLApi*)(int, GLenum, GLsizei))wglGetProcAddress("glColorFormatNV"))) ++ n_failed_functions;
	if(!(glIndexFormatNV = (void(GLApi*)(GLenum, GLsizei))wglGetProcAddress("glIndexFormatNV"))) ++ n_failed_functions;
	if(!(glTexCoordFormatNV = (void(GLApi*)(int, GLenum, GLsizei))wglGetProcAddress("glTexCoordFormatNV"))) ++ n_failed_functions;
	if(!(glEdgeFlagFormatNV = (void(GLApi*)(GLsizei))wglGetProcAddress("glEdgeFlagFormatNV"))) ++ n_failed_functions;
	if(!(glSecondaryColorFormatNV = (void(GLApi*)(int, GLenum, GLsizei))wglGetProcAddress("glSecondaryColorFormatNV"))) ++ n_failed_functions;
	if(!(glFogCoordFormatNV = (void(GLApi*)(GLenum, GLsizei))wglGetProcAddress("glFogCoordFormatNV"))) ++ n_failed_functions;
	if(!(glVertexAttribFormatNV = (void(GLApi*)(GLuint, int, GLenum, GLboolean, GLsizei))wglGetProcAddress("glVertexAttribFormatNV"))) ++ n_failed_functions;
	if(!(glVertexAttribIFormatNV = (void(GLApi*)(GLuint, int, GLenum, GLsizei))wglGetProcAddress("glVertexAttribIFormatNV"))) ++ n_failed_functions;
	if(!(glGetIntegerui64i_vNV = (void(GLApi*)(GLenum, GLuint, GLuint64EXT*))wglGetProcAddress("glGetIntegerui64i_vNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_vertex_buffer_unified_memory

	GLEH_NV_vertex_buffer_unified_memory = !n_failed_functions && b_SupportedExtension("GL_NV_vertex_buffer_unified_memory");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_vertex_buffer_unified_memory ---
 */


/*
 *								--- GL_NV_vertex_program ---
 */

bool GLEH_NV_vertex_program = false;

#ifdef __GENERATE_GL_NV_vertex_program

void (GLApi *glBindProgramNV)(GLenum, GLuint) INIT_FUNC_POINTERS;
void (GLApi *glDeleteProgramsNV)(GLsizei, const GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glExecuteProgramNV)(GLenum, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glGenProgramsNV)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
GLboolean (GLApi *glAreProgramsResidentNV)(GLsizei, const GLuint*, GLboolean*) INIT_FUNC_POINTERS;
void (GLApi *glRequestResidentProgramsNV)(GLsizei, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramParameterfvNV)(GLenum, GLuint, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramParameterdvNV)(GLenum, GLuint, GLenum, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramivNV)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetProgramStringNV)(GLuint, GLenum, GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glGetTrackMatrixivNV)(GLenum, GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribdvNV)(GLuint, GLenum, double*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribfvNV)(GLuint, GLenum, float*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribivNV)(GLuint, GLenum, int*) INIT_FUNC_POINTERS;
void (GLApi *glGetVertexAttribPointervNV)(GLuint, GLenum, void**) INIT_FUNC_POINTERS;
GLboolean (GLApi *glIsProgramNV)(GLuint) INIT_FUNC_POINTERS;
void (GLApi *glLoadProgramNV)(GLenum, GLuint, GLsizei, const GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glProgramParameter4fNV)(GLenum, GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glProgramParameter4dNV)(GLenum, GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glProgramParameter4dvNV)(GLenum, GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glProgramParameter4fvNV)(GLenum, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glProgramParameters4dvNV)(GLenum, GLuint, GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glProgramParameters4fvNV)(GLenum, GLuint, GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glTrackMatrixNV)(GLenum, GLuint, GLenum, GLenum) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribPointerNV)(GLuint, int, GLenum, GLsizei, const void*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1sNV)(GLuint, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1fNV)(GLuint, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1dNV)(GLuint, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2sNV)(GLuint, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2fNV)(GLuint, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2dNV)(GLuint, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3sNV)(GLuint, short, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3fNV)(GLuint, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3dNV)(GLuint, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4sNV)(GLuint, short, short, short, short) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4fNV)(GLuint, float, float, float, float) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4dNV)(GLuint, double, double, double, double) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4ubNV)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1svNV)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1fvNV)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib1dvNV)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2svNV)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2fvNV)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib2dvNV)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3svNV)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3fvNV)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib3dvNV)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4svNV)(GLuint, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4fvNV)(GLuint, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4dvNV)(GLuint, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttrib4ubvNV)(GLuint, const GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs1svNV)(GLuint, GLsizei, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs1fvNV)(GLuint, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs1dvNV)(GLuint, GLsizei, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs2svNV)(GLuint, GLsizei, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs2fvNV)(GLuint, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs2dvNV)(GLuint, GLsizei, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs3svNV)(GLuint, GLsizei, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs3fvNV)(GLuint, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs3dvNV)(GLuint, GLsizei, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs4svNV)(GLuint, GLsizei, const short*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs4fvNV)(GLuint, GLsizei, const float*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs4dvNV)(GLuint, GLsizei, const double*) INIT_FUNC_POINTERS;
void (GLApi *glVertexAttribs4ubvNV)(GLuint, GLsizei, const GLubyte*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_NV_vertex_program

int CGLExtensionHandler::n_GetVertexProgramNVFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_NV_vertex_program

	if(!(glBindProgramNV = (void(GLApi*)(GLenum, GLuint))wglGetProcAddress("glBindProgramNV"))) ++ n_failed_functions;
	if(!(glDeleteProgramsNV = (void(GLApi*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteProgramsNV"))) ++ n_failed_functions;
	if(!(glExecuteProgramNV = (void(GLApi*)(GLenum, GLuint, const float*))wglGetProcAddress("glExecuteProgramNV"))) ++ n_failed_functions;
	if(!(glGenProgramsNV = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glGenProgramsNV"))) ++ n_failed_functions;
	if(!(glAreProgramsResidentNV = (GLboolean(GLApi*)(GLsizei, const GLuint*, GLboolean*))wglGetProcAddress("glAreProgramsResidentNV"))) ++ n_failed_functions;
	if(!(glRequestResidentProgramsNV = (void(GLApi*)(GLsizei, GLuint*))wglGetProcAddress("glRequestResidentProgramsNV"))) ++ n_failed_functions;
	if(!(glGetProgramParameterfvNV = (void(GLApi*)(GLenum, GLuint, GLenum, float*))wglGetProcAddress("glGetProgramParameterfvNV"))) ++ n_failed_functions;
	if(!(glGetProgramParameterdvNV = (void(GLApi*)(GLenum, GLuint, GLenum, double*))wglGetProcAddress("glGetProgramParameterdvNV"))) ++ n_failed_functions;
	if(!(glGetProgramivNV = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetProgramivNV"))) ++ n_failed_functions;
	if(!(glGetProgramStringNV = (void(GLApi*)(GLuint, GLenum, GLubyte*))wglGetProcAddress("glGetProgramStringNV"))) ++ n_failed_functions;
	if(!(glGetTrackMatrixivNV = (void(GLApi*)(GLenum, GLuint, GLenum, int*))wglGetProcAddress("glGetTrackMatrixivNV"))) ++ n_failed_functions;
	if(!(glGetVertexAttribdvNV = (void(GLApi*)(GLuint, GLenum, double*))wglGetProcAddress("glGetVertexAttribdvNV"))) ++ n_failed_functions;
	if(!(glGetVertexAttribfvNV = (void(GLApi*)(GLuint, GLenum, float*))wglGetProcAddress("glGetVertexAttribfvNV"))) ++ n_failed_functions;
	if(!(glGetVertexAttribivNV = (void(GLApi*)(GLuint, GLenum, int*))wglGetProcAddress("glGetVertexAttribivNV"))) ++ n_failed_functions;
	if(!(glGetVertexAttribPointervNV = (void(GLApi*)(GLuint, GLenum, void**))wglGetProcAddress("glGetVertexAttribPointervNV"))) ++ n_failed_functions;
	if(!(glIsProgramNV = (GLboolean(GLApi*)(GLuint))wglGetProcAddress("glIsProgramNV"))) ++ n_failed_functions;
	if(!(glLoadProgramNV = (void(GLApi*)(GLenum, GLuint, GLsizei, const GLubyte*))wglGetProcAddress("glLoadProgramNV"))) ++ n_failed_functions;
	if(!(glProgramParameter4fNV = (void(GLApi*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramParameter4fNV"))) ++ n_failed_functions;
	if(!(glProgramParameter4dNV = (void(GLApi*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramParameter4dNV"))) ++ n_failed_functions;
	if(!(glProgramParameter4dvNV = (void(GLApi*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramParameter4dvNV"))) ++ n_failed_functions;
	if(!(glProgramParameter4fvNV = (void(GLApi*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramParameter4fvNV"))) ++ n_failed_functions;
	if(!(glProgramParameters4dvNV = (void(GLApi*)(GLenum, GLuint, GLuint, const double*))wglGetProcAddress("glProgramParameters4dvNV"))) ++ n_failed_functions;
	if(!(glProgramParameters4fvNV = (void(GLApi*)(GLenum, GLuint, GLuint, const float*))wglGetProcAddress("glProgramParameters4fvNV"))) ++ n_failed_functions;
	if(!(glTrackMatrixNV = (void(GLApi*)(GLenum, GLuint, GLenum, GLenum))wglGetProcAddress("glTrackMatrixNV"))) ++ n_failed_functions;
	if(!(glVertexAttribPointerNV = (void(GLApi*)(GLuint, int, GLenum, GLsizei, const void*))wglGetProcAddress("glVertexAttribPointerNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib1sNV = (void(GLApi*)(GLuint, short))wglGetProcAddress("glVertexAttrib1sNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib1fNV = (void(GLApi*)(GLuint, float))wglGetProcAddress("glVertexAttrib1fNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib1dNV = (void(GLApi*)(GLuint, double))wglGetProcAddress("glVertexAttrib1dNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib2sNV = (void(GLApi*)(GLuint, short, short))wglGetProcAddress("glVertexAttrib2sNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib2fNV = (void(GLApi*)(GLuint, float, float))wglGetProcAddress("glVertexAttrib2fNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib2dNV = (void(GLApi*)(GLuint, double, double))wglGetProcAddress("glVertexAttrib2dNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib3sNV = (void(GLApi*)(GLuint, short, short, short))wglGetProcAddress("glVertexAttrib3sNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib3fNV = (void(GLApi*)(GLuint, float, float, float))wglGetProcAddress("glVertexAttrib3fNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib3dNV = (void(GLApi*)(GLuint, double, double, double))wglGetProcAddress("glVertexAttrib3dNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4sNV = (void(GLApi*)(GLuint, short, short, short, short))wglGetProcAddress("glVertexAttrib4sNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4fNV = (void(GLApi*)(GLuint, float, float, float, float))wglGetProcAddress("glVertexAttrib4fNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4dNV = (void(GLApi*)(GLuint, double, double, double, double))wglGetProcAddress("glVertexAttrib4dNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4ubNV = (void(GLApi*)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte))wglGetProcAddress("glVertexAttrib4ubNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib1svNV = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib1svNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib1fvNV = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib1fvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib1dvNV = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib1dvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib2svNV = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib2svNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib2fvNV = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib2fvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib2dvNV = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib2dvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib3svNV = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib3svNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib3fvNV = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib3fvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib3dvNV = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib3dvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4svNV = (void(GLApi*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4svNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4fvNV = (void(GLApi*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib4fvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4dvNV = (void(GLApi*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib4dvNV"))) ++ n_failed_functions;
	if(!(glVertexAttrib4ubvNV = (void(GLApi*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4ubvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs1svNV = (void(GLApi*)(GLuint, GLsizei, const short*))wglGetProcAddress("glVertexAttribs1svNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs1fvNV = (void(GLApi*)(GLuint, GLsizei, const float*))wglGetProcAddress("glVertexAttribs1fvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs1dvNV = (void(GLApi*)(GLuint, GLsizei, const double*))wglGetProcAddress("glVertexAttribs1dvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs2svNV = (void(GLApi*)(GLuint, GLsizei, const short*))wglGetProcAddress("glVertexAttribs2svNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs2fvNV = (void(GLApi*)(GLuint, GLsizei, const float*))wglGetProcAddress("glVertexAttribs2fvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs2dvNV = (void(GLApi*)(GLuint, GLsizei, const double*))wglGetProcAddress("glVertexAttribs2dvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs3svNV = (void(GLApi*)(GLuint, GLsizei, const short*))wglGetProcAddress("glVertexAttribs3svNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs3fvNV = (void(GLApi*)(GLuint, GLsizei, const float*))wglGetProcAddress("glVertexAttribs3fvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs3dvNV = (void(GLApi*)(GLuint, GLsizei, const double*))wglGetProcAddress("glVertexAttribs3dvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs4svNV = (void(GLApi*)(GLuint, GLsizei, const short*))wglGetProcAddress("glVertexAttribs4svNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs4fvNV = (void(GLApi*)(GLuint, GLsizei, const float*))wglGetProcAddress("glVertexAttribs4fvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs4dvNV = (void(GLApi*)(GLuint, GLsizei, const double*))wglGetProcAddress("glVertexAttribs4dvNV"))) ++ n_failed_functions;
	if(!(glVertexAttribs4ubvNV = (void(GLApi*)(GLuint, GLsizei, const GLubyte*))wglGetProcAddress("glVertexAttribs4ubvNV"))) ++ n_failed_functions;

#endif // __GENERATE_GL_NV_vertex_program

	GLEH_NV_vertex_program = !n_failed_functions && b_SupportedExtension("GL_NV_vertex_program");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_vertex_program ---
 */


/*
 *								--- GL_NV_vertex_program1_1 ---
 */

bool GLEH_NV_vertex_program1_1 = false;

int CGLExtensionHandler::n_GetVertexProgram11NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_vertex_program1_1 = !n_failed_functions && b_SupportedExtension("GL_NV_vertex_program1_1");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_vertex_program1_1 ---
 */


/*
 *								--- GL_NV_vertex_program2 ---
 */

bool GLEH_NV_vertex_program2 = false;

int CGLExtensionHandler::n_GetVertexProgram2NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_vertex_program2 = !n_failed_functions && b_SupportedExtension("GL_NV_vertex_program2");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_vertex_program2 ---
 */


/*
 *								--- GL_NV_vertex_program2_option ---
 */

bool GLEH_NV_vertex_program2_option = false;

int CGLExtensionHandler::n_GetVertexProgram2OptionNVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_vertex_program2_option = !n_failed_functions && b_SupportedExtension("GL_NV_vertex_program2_option");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_vertex_program2_option ---
 */


/*
 *								--- GL_NV_vertex_program3 ---
 */

bool GLEH_NV_vertex_program3 = false;

int CGLExtensionHandler::n_GetVertexProgram3NVFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_NV_vertex_program3 = !n_failed_functions && b_SupportedExtension("GL_NV_vertex_program3");

	return n_failed_functions;
}

/*
 *								--- ~GL_NV_vertex_program3 ---
 */


/*
 *								--- GL_SGIS_generate_mipmap ---
 */

bool GLEH_SGIS_generate_mipmap = false;

int CGLExtensionHandler::n_GetGenerateMipmapSGISFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_SGIS_generate_mipmap = !n_failed_functions && b_SupportedExtension("GL_SGIS_generate_mipmap");

	return n_failed_functions;
}

/*
 *								--- ~GL_SGIS_generate_mipmap ---
 */


/*
 *								--- GL_SGIS_texture_lod ---
 */

bool GLEH_SGIS_texture_lod = false;

int CGLExtensionHandler::n_GetTextureLodSGISFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_SGIS_texture_lod = !n_failed_functions && b_SupportedExtension("GL_SGIS_texture_lod");

	return n_failed_functions;
}

/*
 *								--- ~GL_SGIS_texture_lod ---
 */


/*
 *								--- GL_SGIX_depth_texture ---
 */

bool GLEH_SGIX_depth_texture = false;

int CGLExtensionHandler::n_GetDepthTextureSGIXFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_SGIX_depth_texture = !n_failed_functions && b_SupportedExtension("GL_SGIX_depth_texture");

	return n_failed_functions;
}

/*
 *								--- ~GL_SGIX_depth_texture ---
 */


/*
 *								--- GL_SGIX_shadow ---
 */

bool GLEH_SGIX_shadow = false;

int CGLExtensionHandler::n_GetShadowSGIXFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_SGIX_shadow = !n_failed_functions && b_SupportedExtension("GL_SGIX_shadow");

	return n_failed_functions;
}

/*
 *								--- ~GL_SGIX_shadow ---
 */


/*
 *								--- GL_SUN_slice_accum ---
 */

bool GLEH_SUN_slice_accum = false;

int CGLExtensionHandler::n_GetSliceAccumSUNFuncPointers()
{
	int n_failed_functions = 0;

	// no new functions or procedures here

	GLEH_SUN_slice_accum = !n_failed_functions && b_SupportedExtension("GL_SUN_slice_accum");

	return n_failed_functions;
}

/*
 *								--- ~GL_SUN_slice_accum ---
 */


/*
 *								--- GL_ARB_vertex_blend ---
 */

bool GLEH_ARB_vertex_blend = false;

#ifdef __GENERATE_GL_ARB_vertex_blend

void (GLApi *glWeightbvARB)(int, GLbyte*) INIT_FUNC_POINTERS;
void (GLApi *glWeightsvARB)(int, short*) INIT_FUNC_POINTERS;
void (GLApi *glWeightivARB)(int, int*) INIT_FUNC_POINTERS;
void (GLApi *glWeightfvARB)(int, float*) INIT_FUNC_POINTERS;
void (GLApi *glWeightdvARB)(int, double*) INIT_FUNC_POINTERS;
void (GLApi *glWeightubvARB)(int, GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glWeightusvARB)(int, GLushort*) INIT_FUNC_POINTERS;
void (GLApi *glWeightuivARB)(int, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glWeightPointerARB)(int, GLenum, GLsizei, void*) INIT_FUNC_POINTERS;
void (GLApi *glVertexBlendARB)(int) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_vertex_blend

int CGLExtensionHandler::n_GetVertexBlendARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_vertex_blend

	if(!(glWeightbvARB = (void(GLApi*)(int, GLbyte*))wglGetProcAddress("glWeightbvARB"))) ++ n_failed_functions;
	if(!(glWeightsvARB = (void(GLApi*)(int, short*))wglGetProcAddress("glWeightsvARB"))) ++ n_failed_functions;
	if(!(glWeightivARB = (void(GLApi*)(int, int*))wglGetProcAddress("glWeightivARB"))) ++ n_failed_functions;
	if(!(glWeightfvARB = (void(GLApi*)(int, float*))wglGetProcAddress("glWeightfvARB"))) ++ n_failed_functions;
	if(!(glWeightdvARB = (void(GLApi*)(int, double*))wglGetProcAddress("glWeightdvARB"))) ++ n_failed_functions;
	if(!(glWeightubvARB = (void(GLApi*)(int, GLubyte*))wglGetProcAddress("glWeightubvARB"))) ++ n_failed_functions;
	if(!(glWeightusvARB = (void(GLApi*)(int, GLushort*))wglGetProcAddress("glWeightusvARB"))) ++ n_failed_functions;
	if(!(glWeightuivARB = (void(GLApi*)(int, GLuint*))wglGetProcAddress("glWeightuivARB"))) ++ n_failed_functions;
	if(!(glWeightPointerARB = (void(GLApi*)(int, GLenum, GLsizei, void*))wglGetProcAddress("glWeightPointerARB"))) ++ n_failed_functions;
	if(!(glVertexBlendARB = (void(GLApi*)(int))wglGetProcAddress("glVertexBlendARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_vertex_blend

	GLEH_ARB_vertex_blend = !n_failed_functions && b_SupportedExtension("GL_ARB_vertex_blend");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_vertex_blend ---
 */


/*
 *								--- GL_ARB_matrix_palette ---
 */

bool GLEH_ARB_matrix_palette = false;

#ifdef __GENERATE_GL_ARB_matrix_palette

void (GLApi *glCurrentPaletteMatrixARB)(int) INIT_FUNC_POINTERS;
void (GLApi *glMatrixIndexubvARB)(int, GLubyte*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixIndexusvARB)(int, GLushort*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixIndexuivARB)(int, GLuint*) INIT_FUNC_POINTERS;
void (GLApi *glMatrixIndexPointerARB)(int, GLenum, GLsizei, void*) INIT_FUNC_POINTERS;

#endif // __GENERATE_GL_ARB_matrix_palette

int CGLExtensionHandler::n_GetMatrixPaletteARBFuncPointers()
{
	int n_failed_functions = 0;

#ifdef __GENERATE_GL_ARB_matrix_palette

	if(!(glCurrentPaletteMatrixARB = (void(GLApi*)(int))wglGetProcAddress("glCurrentPaletteMatrixARB"))) ++ n_failed_functions;
	if(!(glMatrixIndexubvARB = (void(GLApi*)(int, GLubyte*))wglGetProcAddress("glMatrixIndexubvARB"))) ++ n_failed_functions;
	if(!(glMatrixIndexusvARB = (void(GLApi*)(int, GLushort*))wglGetProcAddress("glMatrixIndexusvARB"))) ++ n_failed_functions;
	if(!(glMatrixIndexuivARB = (void(GLApi*)(int, GLuint*))wglGetProcAddress("glMatrixIndexuivARB"))) ++ n_failed_functions;
	if(!(glMatrixIndexPointerARB = (void(GLApi*)(int, GLenum, GLsizei, void*))wglGetProcAddress("glMatrixIndexPointerARB"))) ++ n_failed_functions;

#endif // __GENERATE_GL_ARB_matrix_palette

	GLEH_ARB_matrix_palette = !n_failed_functions && b_SupportedExtension("GL_ARB_matrix_palette");

	return n_failed_functions;
}

/*
 *								--- ~GL_ARB_matrix_palette ---
 */

/*
 *								=== ~CGLExtensionHandler ===
 */
