#include "Segments.h"


namespace vmatch {


Segment::Segment(int startRef, int endRef, int startQuery, int endQuery) {
	CV_Assert(startRef >= 0);
	CV_Assert(endRef >= 0);
	CV_Assert(startQuery >= 0);
	CV_Assert(endQuery >= 0);
	
	this->startRef = startRef;
	this->startQuery = startQuery;
	this->endRef = endRef;
	this->endQuery = endQuery;
}


int Segment::getStartRef() const {
	return startRef;
}


int Segment::getStartQuery() const {
	return startQuery;
}


int Segment::getEndRef() const {
	return endRef;
}


int Segment::getEndQuery() const {
	return endQuery;
}


Segments::Segments() {
}


Segments::Segments(const VideoSequence::MetaData & metaRef, const VideoSequence::MetaData & metaQuery) : vector<SegmentPtr>() {
	this->metaRef = metaRef;
	this->metaQuery = metaQuery;
}


VideoSequence::MetaData Segments::getMetaDataRef() const {
	return metaRef;
}


VideoSequence::MetaData Segments::getMetaDataQuery() const {
	return metaQuery;
}


void Segments::sort() {
	std::sort(begin(), end(), CompareSegments());
}


bool Segments::CompareSegments::operator()(SegmentPtr A, SegmentPtr B) const {
	CV_Assert(A != NULL);
	CV_Assert(B != NULL);
	
	return A->getStartRef() < B->getStartRef();
}


}
