#pragma once
#ifndef _KEYSEGMENTS_H
#define _KEYSEGMENTS_H


#include "KeyFrames.h"


namespace vmatch {


class KeySegmentDescriptor : public FrameDescriptor {
protected:
	KeyFramePtrVector keyframes;
	int id;
	int descriptorType;

public:
	KeySegmentDescriptor(const KeyFramePtrVector & keyframes);
	virtual double compare(const FrameDescriptor & second) const;
	virtual void read(cv::FileNode & nd);
	virtual void write(cv::FileStorage & fs) const;

};


typedef cv::Ptr<KeySegmentDescriptor> KeySegmentDescriptorPtr;


class KeySegment : public KeyFrame {
protected:
	int start;
	int end;

public:
	KeySegment(const KeyFramePtrVector & keyframes, int segmentId);
	int getStart() const;
	int getEnd() const;
};


typedef cv::Ptr<KeySegment> KeySegmentPtr;


class KeySegments : public KeyFrames {
public:
	KeySegments(const KeyFrames & kf);
};


typedef cv::Ptr<KeySegments> KeySegmentsPtr;


}


#endif
