#ifndef _FRAMEDESCRIPTOR_H
#define _FRAMEDESCRIPTOR_H


#include <map>
#include <opencv2/opencv.hpp>


namespace vmatch {


class FrameDescriptor {
public:
	enum CommonTypes {
		_GROUP = -2,
		_NULL = -1,
		UNKNOWN = 0,
		COLHIST,
		GRADHIST,
		GRADRGHIST,
		REF,
		QUICKHIST,
		LOCAL_SURF,
		VITA_COLHIST
	};

protected:
	int type;

public:
	FrameDescriptor(int type);
	int getType() const;
	virtual double compare(const FrameDescriptor & second) const = 0;
	virtual bool isVector() const;
	virtual const cv::Mat & getVector() const;
	virtual void read(cv::FileNode & nd) = 0;
	virtual void write(cv::FileStorage & fs) const = 0;
};


class VectorFrameDescriptor : public FrameDescriptor {
protected:
	static const std::string NODE_VECTOR;

	cv::Mat data;

public:
	VectorFrameDescriptor(int type, cv::Mat data);
	virtual double compare(const FrameDescriptor & second) const;
	virtual bool isVector() const;
	virtual const cv::Mat & getVector() const;
	virtual void read(cv::FileNode & nd);
	virtual void write(cv::FileStorage & fs) const;
};


typedef cv::Ptr<FrameDescriptor> FrameDescriptorPtr;
typedef std::map<int, FrameDescriptorPtr> FrameDescriptorPtrs;


}


#endif
