/*
*3DSMAX_ASCIIEXPORT	200
*COMMENT "AsciiExport Version  2,00 - Mon May 07 01:36:29 2007"
*SCENE {
	*SCENE_FILENAME "island_palm.max"
	*SCENE_FIRSTFRAME 0
	*SCENE_LASTFRAME 100
	*SCENE_FRAMESPEED 30
	*SCENE_TICKSPERFRAME 160
	*SCENE_BACKGROUND_STATIC 0.000	0.000	0.000
	*SCENE_AMBIENT_STATIC 0.745	0.745	0.745
}
*/

#include "Scene.h"
#include "../UberLame_src/lml/PlatPrim.h"
// for compiller to link externs with arrays

const int n_vertex_num = 1195;
const int n_tex_vertex_num = 2515;
const int n_face_num = 2260;
const int n_tex_face_num = 2260;

// in scene.cpp:
extern const float p_vertex[][3];
extern const unsigned short p_face_index[][3];
extern const float p_texcoord[][2];
extern const unsigned short p_tex_face[][3];

CGLIslandScene::CGLIslandScene()
	:m_n_index_num(0), m_texture("lightmap.png")
{
	_ASSERTE(n_face_num == n_tex_face_num); // whatever
	CPolyMesh mesh;
	if(!mesh.Alloc(n_face_num * 3, n_face_num))
		return;
	for(int i = 0; i < n_face_num; ++ i) {
		for(int j = 0; j < 3; ++ j) {
			mesh.r_Vertex(i * 3 + j).v_position.x = p_vertex[p_face_index[i][2 - j]][0];
			mesh.r_Vertex(i * 3 + j).v_position.y = p_vertex[p_face_index[i][2 - j]][2];
			mesh.r_Vertex(i * 3 + j).v_position.z = p_vertex[p_face_index[i][2 - j]][1];
			mesh.r_Vertex(i * 3 + j).v_position *= .1f; // it is quite large
			mesh.r_Vertex(i * 3 + j).v_position.x += 10; // behind the buoys
			mesh.r_Vertex(i * 3 + j).v_position.z += 20; // behind the buoys
			mesh.r_Vertex(i * 3 + j).p_texture_coord[0].x = p_texcoord[p_tex_face[i][2 - j]][0];
			mesh.r_Vertex(i * 3 + j).p_texture_coord[0].y = 1 - p_texcoord[p_tex_face[i][2 - j]][1];
		}
		CPolyMesh::_TyRefVertex p_vertex[3] = {
			mesh.t_RefVertex(i * 3 + 0), mesh.t_RefVertex(i * 3 + 1), mesh.t_RefVertex(i * 3 + 2)
		};
		mesh.r_Polygon(i).Insert_Vertex(p_vertex, p_vertex + 3); // throws
	}
#ifdef _DEBUG
	if(!mesh.OptimizeVertices(false, false, 1, 1e-3f)) // slow
		return;
#endif // !_DEBUG
	{
		CPolyMesh seafloor;
		CPlatonicPrimitives::MakePlane(seafloor, 100, 100);
		Matrix4f t_transform;
		t_transform.Identity();
		t_transform.Translate(0, -1.11f, 0);
		t_transform.Scale(500);
		seafloor.Transform(t_transform);
		for(size_t i = 0, n = seafloor.n_Vertex_Num(); i < n; ++ i) {
			seafloor.r_Vertex(i).p_texture_coord[0] = Vector4f(.82f, .82f, 0, 1);
			const Vector3f v_center(0, 0, -10);
			const float f_radius = 15, f_depth = 5;
			if((v_center - seafloor.r_Vertex(i).v_position).f_Length() < f_radius)
				seafloor.r_Vertex(i).v_position.y -= (f_radius - (v_center - seafloor.r_Vertex(i).v_position).f_Length()) * f_depth;
		}
		seafloor.MakeTris();
		mesh.Merge(seafloor);
	}
	std::vector<uint32_t> index_buffer;
	std::vector<float> vertex_buffer;
	if(!mesh.Build_DrawBuffers(index_buffer, vertex_buffer, false, false, 2))
		return;

	m_vao.Bind();
	{
		m_index_buffer.Bind();
		m_index_buffer.BufferData(index_buffer.size() * sizeof(uint32_t), &index_buffer[0]);
		m_vertex_buffer.Bind();
		m_vertex_buffer.BufferData(vertex_buffer.size() * sizeof(float), &vertex_buffer[0]);

		glEnableVertexAttribArray(0);
		glEnableVertexAttribArray(1);
		glVertexAttribPointer(0, 3, GL_FLOAT, false, 5 * sizeof(float),
			m_vertex_buffer.p_OffsetPointer(0)); // pos
		glVertexAttribPointer(1, 2, GL_FLOAT, false, 5 * sizeof(float),
			m_vertex_buffer.p_OffsetPointer(3 * sizeof(float))); // texcoord
	}
	CGLVertexArrayObject::Release();

	if(!m_shader.Compile() || !m_uw_shader.Compile())
		return;

	m_n_index_num = index_buffer.size();
}

const float p_vertex[][3] = {
	{-100.000f, -100.000f, -11.142f},
	{-60.000f, -100.000f, -11.142f},
	{-20.000f, -100.000f, -11.142f},
	{20.000f, -100.000f, -11.142f},
	{60.000f, -100.000f, -11.142f},
	{100.000f, -100.000f, -11.142f},
	{-100.000f, -60.000f, -11.142f},
	{-60.000f, -60.000f, -10.629f},
	{-20.000f, -60.000f, -5.543f},
	{20.000f, -60.000f, 4.478f},
	{60.000f, -60.000f, -8.624f},
	{100.000f, -60.000f, -11.142f},
	{-100.000f, -20.000f, -11.142f},
	{-60.000f, -20.000f, -5.733f},
	{-20.000f, -20.000f, 14.675f},
	{20.000f, -20.000f, 16.076f},
	{60.000f, -20.000f, -7.205f},
	{100.000f, -20.000f, -11.142f},
	{-100.000f, 20.000f, -11.142f},
	{-60.000f, 20.000f, 5.990f},
	{-20.000f, 20.000f, 18.461f},
	{20.000f, 20.000f, 14.445f},
	{60.000f, 20.000f, -7.539f},
	{100.000f, 20.000f, -11.142f},
	{-100.000f, 60.000f, -11.142f},
	{-60.000f, 60.000f, 7.110f},
	{-20.000f, 60.000f, 8.212f},
	{20.000f, 60.000f, -5.346f},
	{60.000f, 60.000f, -10.627f},
	{100.000f, 60.000f, -11.142f},
	{-100.000f, 100.000f, -11.142f},
	{-60.000f, 100.000f, -11.142f},
	{-20.000f, 100.000f, -11.142f},
	{20.000f, 100.000f, -11.142f},
	{60.000f, 100.000f, -11.142f},
	{100.000f, 100.000f, -11.142f},
	{-80.000f, -80.000f, -11.142f},
	{-40.000f, -80.000f, -11.142f},
	{0.000f, -80.000f, -5.801f},
	{40.000f, -80.000f, -5.801f},
	{80.000f, -80.000f, -11.142f},
	{-80.000f, -40.000f, -11.142f},
	{-40.000f, -40.000f, -2.925f},
	{0.000f, -40.000f, 10.653f},
	{40.000f, -40.000f, 2.435f},
	{80.000f, -40.000f, -11.142f},
	{-80.000f, -0.000f, -6.308f},
	{-40.000f, -0.000f, 10.145f},
	{0.000f, -0.000f, 21.783f},
	{40.000f, -0.000f, 5.330f},
	{80.000f, 0.000f, -11.142f},
	{-80.000f, 40.000f, -0.206f},
	{-40.000f, 40.000f, 13.879f},
	{0.000f, 40.000f, 11.179f},
	{40.000f, 40.000f, -2.906f},
	{80.000f, 40.000f, -11.142f},
	{-80.000f, 80.000f, -5.039f},
	{-40.000f, 80.000f, 0.810f},
	{0.000f, 80.000f, -5.293f},
	{40.000f, 80.000f, -11.142f},
	{80.000f, 80.000f, -11.142f},
	{-100.000f, -80.000f, -11.142f},
	{-80.000f, -60.000f, -11.142f},
	{-60.000f, -80.000f, -11.142f},
	{-80.000f, -100.000f, -11.142f},
	{-40.000f, -60.000f, -9.088f},
	{-20.000f, -80.000f, -9.807f},
	{-40.000f, -100.000f, -11.142f},
	{0.000f, -60.000f, 0.983f},
	{20.000f, -80.000f, -3.130f},
	{0.000f, -100.000f, -11.142f},
	{40.000f, -60.000f, -1.071f},
	{60.000f, -80.000f, -9.807f},
	{40.000f, -100.000f, -11.142f},
	{80.000f, -60.000f, -11.142f},
	{100.000f, -80.000f, -11.142f},
	{80.000f, -100.000f, -11.142f},
	{-100.000f, -40.000f, -11.142f},
	{-80.000f, -20.000f, -9.934f},
	{-60.000f, -40.000f, -9.088f},
	{-40.000f, -20.000f, 4.452f},
	{-20.000f, -40.000f, 4.579f},
	{0.000f, -20.000f, 18.991f},
	{20.000f, -40.000f, 11.278f},
	{40.000f, -20.000f, 4.606f},
	{60.000f, -40.000f, -7.748f},
	{80.000f, -20.000f, -11.142f},
	{100.000f, -40.000f, -11.142f},
	{-100.000f, 0.000f, -11.142f},
	{-80.000f, 20.000f, -2.366f},
	{-60.000f, -0.000f, 0.222f},
	{-40.000f, 20.000f, 13.505f},
	{-20.000f, -0.000f, 18.864f},
	{0.000f, 20.000f, 19.141f},
	{20.000f, -0.000f, 17.679f},
	{40.000f, 20.000f, 3.271f},
	{60.000f, -0.000f, -7.024f},
	{80.000f, 20.000f, -11.142f},
	{100.000f, 0.000f, -11.142f},
	{-100.000f, 40.000f, -11.142f},
	{-80.000f, 60.000f, -0.779f},
	{-60.000f, 40.000f, 8.784f},
	{-40.000f, 60.000f, 10.053f},
	{-20.000f, 40.000f, 14.778f},
	{0.000f, 60.000f, 1.749f},
	{20.000f, 40.000f, 4.733f},
	{40.000f, 60.000f, -9.083f},
	{60.000f, 40.000f, -9.083f},
	{80.000f, 60.000f, -11.142f},
	{100.000f, 40.000f, -11.142f},
	{-100.000f, 80.000f, -11.142f},
	{-80.000f, 100.000f, -11.142f},
	{-60.000f, 80.000f, -0.526f},
	{-40.000f, 100.000f, -11.142f},
	{-20.000f, 80.000f, -0.843f},
	{0.000f, 100.000f, -11.142f},
	{20.000f, 80.000f, -9.680f},
	{40.000f, 100.000f, -11.142f},
	{60.000f, 80.000f, -11.142f},
	{80.000f, 100.000f, -11.142f},
	{100.000f, 80.000f, -11.142f},
	{-37.544f, 25.997f, 0.000f},
	{-28.929f, 25.997f, 0.000f},
	{-29.223f, 28.227f, 0.000f},
	{-30.084f, 30.304f, 0.000f},
	{-31.453f, 32.088f, 0.000f},
	{-33.237f, 33.457f, 0.000f},
	{-35.314f, 34.318f, 0.000f},
	{-37.544f, 34.612f, 0.000f},
	{-39.774f, 34.318f, 0.000f},
	{-41.851f, 33.457f, 0.000f},
	{-43.635f, 32.088f, 0.000f},
	{-45.004f, 30.304f, 0.000f},
	{-45.865f, 28.227f, 0.000f},
	{-46.158f, 25.997f, 0.000f},
	{-45.865f, 23.768f, 0.000f},
	{-45.004f, 21.690f, 0.000f},
	{-43.635f, 19.906f, 0.000f},
	{-41.851f, 18.537f, 0.000f},
	{-39.774f, 17.676f, 0.000f},
	{-37.544f, 17.383f, 0.000f},
	{-35.314f, 17.676f, 0.000f},
	{-33.237f, 18.537f, 0.000f},
	{-31.453f, 19.906f, 0.000f},
	{-30.084f, 21.690f, 0.000f},
	{-29.223f, 23.768f, 0.000f},
	{-29.749f, 25.997f, 15.676f},
	{-29.993f, 27.859f, 15.695f},
	{-30.709f, 29.594f, 15.750f},
	{-31.849f, 31.083f, 15.837f},
	{-33.335f, 32.227f, 15.952f},
	{-35.064f, 32.945f, 16.085f},
	{-36.921f, 33.190f, 16.228f},
	{-38.777f, 32.945f, 16.371f},
	{-40.507f, 32.227f, 16.504f},
	{-41.992f, 31.083f, 16.618f},
	{-43.132f, 29.594f, 16.706f},
	{-43.848f, 27.859f, 16.761f},
	{-44.093f, 25.997f, 16.780f},
	{-43.848f, 24.135f, 16.761f},
	{-43.132f, 22.401f, 16.706f},
	{-41.992f, 20.911f, 16.618f},
	{-40.507f, 19.768f, 16.504f},
	{-38.777f, 19.049f, 16.371f},
	{-36.921f, 18.804f, 16.228f},
	{-35.064f, 19.049f, 16.085f},
	{-33.335f, 19.768f, 15.952f},
	{-31.849f, 20.911f, 15.837f},
	{-30.709f, 22.401f, 15.750f},
	{-29.993f, 24.135f, 15.695f},
	{-29.350f, 25.997f, 31.477f},
	{-29.544f, 27.491f, 31.507f},
	{-30.114f, 28.883f, 31.595f},
	{-31.021f, 30.078f, 31.735f},
	{-32.202f, 30.996f, 31.918f},
	{-33.578f, 31.572f, 32.131f},
	{-35.054f, 31.769f, 32.360f},
	{-36.530f, 31.572f, 32.588f},
	{-37.906f, 30.996f, 32.801f},
	{-39.087f, 30.078f, 32.984f},
	{-39.994f, 28.883f, 33.124f},
	{-40.564f, 27.491f, 33.213f},
	{-40.758f, 25.997f, 33.243f},
	{-40.564f, 24.503f, 33.213f},
	{-39.994f, 23.111f, 33.124f},
	{-39.087f, 21.916f, 32.984f},
	{-37.906f, 20.999f, 32.801f},
	{-36.530f, 20.422f, 32.588f},
	{-35.054f, 20.225f, 32.360f},
	{-33.578f, 20.422f, 32.131f},
	{-32.202f, 20.999f, 31.918f},
	{-31.021f, 21.916f, 31.735f},
	{-30.114f, 23.111f, 31.595f},
	{-29.544f, 24.503f, 31.507f},
	{-27.720f, 25.997f, 47.308f},
	{-27.864f, 27.123f, 47.341f},
	{-28.287f, 28.172f, 47.441f},
	{-28.960f, 29.073f, 47.599f},
	{-29.838f, 29.765f, 47.804f},
	{-30.859f, 30.199f, 48.044f},
	{-31.955f, 30.348f, 48.301f},
	{-33.052f, 30.199f, 48.558f},
	{-34.073f, 29.765f, 48.798f},
	{-34.950f, 29.073f, 49.003f},
	{-35.623f, 28.172f, 49.161f},
	{-36.047f, 27.123f, 49.261f},
	{-36.191f, 25.997f, 49.294f},
	{-36.047f, 24.871f, 49.261f},
	{-35.623f, 23.822f, 49.161f},
	{-34.950f, 22.921f, 49.003f},
	{-34.073f, 22.229f, 48.798f},
	{-33.052f, 21.795f, 48.558f},
	{-31.955f, 21.647f, 48.301f},
	{-30.859f, 21.795f, 48.044f},
	{-29.838f, 22.229f, 47.804f},
	{-28.960f, 22.921f, 47.599f},
	{-28.287f, 23.822f, 47.441f},
	{-27.864f, 24.871f, 47.341f},
	{-24.851f, 25.997f, 63.072f},
	{-24.946f, 26.755f, 63.102f},
	{-25.225f, 27.462f, 63.191f},
	{-25.668f, 28.068f, 63.331f},
	{-26.247f, 28.534f, 63.515f},
	{-26.920f, 28.827f, 63.728f},
	{-27.643f, 28.926f, 63.958f},
	{-28.365f, 28.827f, 64.187f},
	{-29.039f, 28.534f, 64.400f},
	{-29.617f, 28.068f, 64.584f},
	{-30.061f, 27.462f, 64.725f},
	{-30.340f, 26.755f, 64.813f},
	{-30.435f, 25.997f, 64.843f},
	{-30.340f, 25.239f, 64.813f},
	{-30.061f, 24.532f, 64.725f},
	{-29.617f, 23.926f, 64.584f},
	{-29.039f, 23.460f, 64.400f},
	{-28.365f, 23.168f, 64.187f},
	{-27.643f, 23.068f, 63.958f},
	{-26.920f, 23.168f, 63.728f},
	{-26.247f, 23.460f, 63.515f},
	{-25.668f, 23.926f, 63.331f},
	{-25.225f, 24.532f, 63.191f},
	{-24.946f, 25.239f, 63.102f},
	{-20.744f, 25.997f, 78.672f},
	{-20.791f, 26.387f, 78.692f},
	{-20.931f, 26.751f, 78.748f},
	{-21.153f, 27.063f, 78.838f},
	{-21.443f, 27.303f, 78.955f},
	{-21.780f, 27.454f, 79.091f},
	{-22.142f, 27.505f, 79.237f},
	{-22.504f, 27.454f, 79.383f},
	{-22.841f, 27.303f, 79.520f},
	{-23.130f, 27.063f, 79.637f},
	{-23.353f, 26.751f, 79.726f},
	{-23.492f, 26.387f, 79.783f},
	{-23.540f, 25.997f, 79.802f},
	{-23.492f, 25.607f, 79.783f},
	{-23.353f, 25.243f, 79.726f},
	{-23.130f, 24.931f, 79.637f},
	{-22.841f, 24.691f, 79.520f},
	{-22.504f, 24.541f, 79.383f},
	{-22.142f, 24.489f, 79.237f},
	{-21.780f, 24.541f, 79.091f},
	{-21.443f, 24.691f, 78.955f},
	{-21.153f, 24.931f, 78.838f},
	{-20.931f, 25.243f, 78.748f},
	{-20.791f, 25.607f, 78.692f},
	{-22.142f, 25.997f, 79.237f},
	{-23.337f, 25.694f, 78.752f},
	{-26.765f, 17.727f, 78.217f},
	{-26.220f, 14.158f, 77.777f},
	{-24.645f, 7.130f, 75.929f},
	{-21.489f, -0.100f, 72.312f},
	{-17.951f, -4.890f, 68.383f},
	{-11.482f, -7.767f, 64.203f},
	{-22.035f, 26.082f, 78.921f},
	{-20.519f, 19.360f, 82.681f},
	{-19.357f, 15.637f, 82.274f},
	{-16.891f, 8.194f, 80.355f},
	{-13.974f, 0.152f, 76.342f},
	{-11.696f, -5.544f, 71.852f},
	{-9.897f, -8.029f, 63.683f},
	{-20.684f, 26.485f, 79.096f},
	{-13.732f, 21.610f, 79.906f},
	{-11.954f, 18.409f, 79.625f},
	{-8.957f, 11.804f, 77.961f},
	{-6.525f, 4.359f, 74.250f},
	{-6.367f, -1.438f, 69.884f},
	{-8.829f, -6.976f, 64.547f},
	{-23.485f, 25.761f, 79.739f},
	{-26.866f, 17.634f, 79.208f},
	{-26.294f, 13.980f, 78.758f},
	{-24.663f, 6.782f, 76.866f},
	{-21.440f, -0.631f, 73.157f},
	{-17.850f, -5.552f, 69.126f},
	{-11.334f, -8.534f, 64.827f},
	{-22.183f, 26.149f, 79.908f},
	{-20.620f, 19.268f, 83.671f},
	{-19.431f, 15.459f, 83.255f},
	{-16.909f, 7.847f, 81.293f},
	{-13.926f, -0.379f, 77.188f},
	{-11.595f, -6.205f, 72.595f},
	{-9.742f, -8.810f, 64.288f},
	{-20.832f, 26.552f, 80.083f},
	{-13.833f, 21.517f, 80.896f},
	{-12.028f, 18.231f, 80.606f},
	{-8.975f, 11.457f, 78.899f},
	{-6.476f, 3.828f, 75.096f},
	{-6.266f, -2.100f, 70.627f},
	{-8.681f, -7.743f, 65.171f},
	{-22.576f, 24.798f, 78.738f},
	{-15.985f, 19.214f, 77.788f},
	{-12.521f, 18.668f, 76.825f},
	{-5.729f, 17.945f, 73.887f},
	{1.379f, 18.453f, 68.933f},
	{6.216f, 19.976f, 63.915f},
	{9.959f, 24.798f, 58.408f},
	{-22.576f, 26.168f, 78.738f},
	{-15.168f, 26.168f, 81.336f},
	{-11.390f, 26.168f, 80.286f},
	{-3.981f, 26.168f, 77.081f},
	{3.771f, 26.168f, 71.678f},
	{9.047f, 26.168f, 66.205f},
	{10.539f, 26.168f, 57.607f},
	{-22.576f, 27.588f, 78.738f},
	{-15.985f, 32.918f, 77.788f},
	{-12.521f, 33.668f, 76.825f},
	{-5.729f, 34.441f, 73.887f},
	{1.379f, 34.187f, 68.933f},
	{6.216f, 32.156f, 63.915f},
	{9.959f, 27.588f, 58.408f},
	{-22.516f, 24.798f, 79.737f},
	{-15.761f, 19.214f, 78.762f},
	{-12.211f, 18.668f, 77.776f},
	{-5.249f, 17.945f, 74.764f},
	{2.036f, 18.453f, 69.687f},
	{6.993f, 19.976f, 64.544f},
	{10.830f, 24.798f, 58.900f},
	{-22.516f, 26.168f, 79.737f},
	{-14.944f, 26.168f, 82.311f},
	{-11.079f, 26.168f, 81.236f},
	{-3.501f, 26.168f, 77.959f},
	{4.428f, 26.168f, 72.432f},
	{9.824f, 26.168f, 66.834f},
	{11.422f, 26.168f, 58.077f},
	{-22.516f, 27.588f, 79.737f},
	{-15.761f, 32.918f, 78.762f},
	{-12.211f, 33.668f, 77.776f},
	{-5.249f, 34.441f, 74.764f},
	{2.036f, 34.187f, 69.687f},
	{6.993f, 32.156f, 64.544f},
	{10.830f, 27.588f, 58.900f},
	{-21.508f, 25.022f, 79.300f},
	{-13.083f, 24.068f, 81.203f},
	{-9.864f, 25.642f, 81.824f},
	{-3.390f, 29.289f, 82.099f},
	{3.310f, 34.628f, 80.712f},
	{7.765f, 39.653f, 78.303f},
	{9.683f, 46.948f, 75.032f},
	{-22.294f, 26.143f, 79.322f},
	{-17.691f, 29.259f, 84.866f},
	{-14.522f, 31.465f, 85.552f},
	{-7.913f, 36.088f, 85.864f},
	{-0.287f, 41.457f, 84.343f},
	{5.524f, 45.578f, 81.689f},
	{9.606f, 48.574f, 74.581f},
	{-23.108f, 27.307f, 79.344f},
	{-20.942f, 35.291f, 81.420f},
	{-18.467f, 37.928f, 82.061f},
	{-12.850f, 42.799f, 82.360f},
	{-5.714f, 47.514f, 80.961f},
	{0.778f, 49.629f, 78.495f},
	{8.083f, 49.232f, 75.076f},
	{-21.809f, 24.793f, 80.226f},
	{-13.253f, 23.930f, 82.179f},
	{-9.962f, 25.554f, 82.815f},
	{-3.337f, 29.307f, 83.097f},
	{3.537f, 34.768f, 81.676f},
	{8.124f, 39.887f, 79.206f},
	{10.160f, 47.265f, 75.851f},
	{-22.594f, 25.915f, 80.248f},
	{-17.862f, 29.121f, 85.841f},
	{-14.621f, 31.377f, 86.543f},
	{-7.860f, 36.106f, 86.863f},
	{-0.060f, 41.598f, 85.307f},
	{5.883f, 45.812f, 82.592f},
	{10.098f, 48.903f, 75.387f},
	{-23.409f, 27.078f, 80.270f},
	{-21.113f, 35.153f, 82.396f},
	{-18.565f, 37.840f, 83.052f},
	{-12.797f, 42.817f, 83.358f},
	{-5.487f, 47.654f, 81.925f},
	{1.138f, 49.863f, 79.398f},
	{8.560f, 49.550f, 75.895f},
	{-19.627f, 26.590f, 78.591f},
	{-12.443f, 31.146f, 76.816f},
	{-10.978f, 34.241f, 75.591f},
	{-8.530f, 40.373f, 72.171f},
	{-7.334f, 47.092f, 66.811f},
	{-7.783f, 51.953f, 61.609f},
	{-11.738f, 56.747f, 56.226f},
	{-20.929f, 27.003f, 78.688f},
	{-18.500f, 34.166f, 80.789f},
	{-17.469f, 37.722f, 79.496f},
	{-15.548f, 44.648f, 75.822f},
	{-13.717f, 51.810f, 69.936f},
	{-12.629f, 56.611f, 64.143f},
	{-12.938f, 57.679f, 55.488f},
	{-22.280f, 27.431f, 78.790f},
	{-25.472f, 35.278f, 77.791f},
	{-25.240f, 38.764f, 76.660f},
	{-24.213f, 45.347f, 73.346f},
	{-22.293f, 51.837f, 67.932f},
	{-19.365f, 55.626f, 62.476f},
	{-14.391f, 57.588f, 56.424f},
	{-19.522f, 26.689f, 79.580f},
	{-12.291f, 31.399f, 77.771f},
	{-10.802f, 34.576f, 76.517f},
	{-8.310f, 40.866f, 73.013f},
	{-7.072f, 47.749f, 67.519f},
	{-7.497f, 52.720f, 62.184f},
	{-11.436f, 57.597f, 56.658f},
	{-20.824f, 27.101f, 79.678f},
	{-18.348f, 34.420f, 81.744f},
	{-17.294f, 38.057f, 80.422f},
	{-15.329f, 45.141f, 76.663f},
	{-13.456f, 52.467f, 70.644f},
	{-12.342f, 57.377f, 64.718f},
	{-12.635f, 58.539f, 55.898f},
	{-22.174f, 27.530f, 79.779f},
	{-25.320f, 35.532f, 78.747f},
	{-25.064f, 39.099f, 77.585f},
	{-23.994f, 45.840f, 74.188f},
	{-22.032f, 52.494f, 68.639f},
	{-19.078f, 56.392f, 63.051f},
	{-14.089f, 58.438f, 56.857f},
	{-20.806f, 26.257f, 79.241f},
	{-17.379f, 34.185f, 80.202f},
	{-17.924f, 37.773f, 80.436f},
	{-19.498f, 45.023f, 79.932f},
	{-22.655f, 52.800f, 77.728f},
	{-26.192f, 58.240f, 74.762f},
	{-32.662f, 61.846f, 71.193f},
	{-22.109f, 25.844f, 79.334f},
	{-23.625f, 31.747f, 84.283f},
	{-24.787f, 35.481f, 84.578f},
	{-27.253f, 43.151f, 84.082f},
	{-30.169f, 51.800f, 81.640f},
	{-32.448f, 58.234f, 78.292f},
	{-34.247f, 62.201f, 70.731f},
	{-23.459f, 25.416f, 79.431f},
	{-30.411f, 30.055f, 81.136f},
	{-32.190f, 33.252f, 81.458f},
	{-35.186f, 40.051f, 81.056f},
	{-37.619f, 48.058f, 78.800f},
	{-37.777f, 54.568f, 75.593f},
	{-35.315f, 61.005f, 71.383f},
	{-20.659f, 26.008f, 80.198f},
	{-17.278f, 34.091f, 81.193f},
	{-17.850f, 37.764f, 81.433f},
	{-19.480f, 45.189f, 80.918f},
	{-22.704f, 53.164f, 78.658f},
	{-26.293f, 58.751f, 75.616f},
	{-32.809f, 62.483f, 71.949f},
	{-21.961f, 25.595f, 80.291f},
	{-23.524f, 31.653f, 85.273f},
	{-24.712f, 35.472f, 85.575f},
	{-27.235f, 43.317f, 85.068f},
	{-30.218f, 52.164f, 82.570f},
	{-32.549f, 58.745f, 79.146f},
	{-34.401f, 62.855f, 71.471f},
	{-23.312f, 25.167f, 80.388f},
	{-30.311f, 29.961f, 82.127f},
	{-32.116f, 33.243f, 82.455f},
	{-35.168f, 40.217f, 82.042f},
	{-37.667f, 48.422f, 79.730f},
	{-37.878f, 55.079f, 76.446f},
	{-35.463f, 61.642f, 72.139f},
	{-21.256f, 27.612f, 78.785f},
	{-23.984f, 35.782f, 77.632f},
	{-26.640f, 38.025f, 76.562f},
	{-32.000f, 42.106f, 73.414f},
	{-38.210f, 45.265f, 68.241f},
	{-43.001f, 46.381f, 63.074f},
	{-48.549f, 44.101f, 57.451f},
	{-21.964f, 26.440f, 78.784f},
	{-28.373f, 30.307f, 81.150f},
	{-31.577f, 32.243f, 79.983f},
	{-37.830f, 36.020f, 76.549f},
	{-44.318f, 39.940f, 70.907f},
	{-48.685f, 42.579f, 65.272f},
	{-49.731f, 43.215f, 56.632f},
	{-22.698f, 25.224f, 78.784f},
	{-31.067f, 24.051f, 77.626f},
	{-34.393f, 25.183f, 76.555f},
	{-40.525f, 27.984f, 73.407f},
	{-46.342f, 31.796f, 68.234f},
	{-49.297f, 35.954f, 63.069f},
	{-49.991f, 41.712f, 57.450f},
	{-21.335f, 27.659f, 79.781f},
	{-24.203f, 35.913f, 78.599f},
	{-26.931f, 38.200f, 77.502f},
	{-32.434f, 42.367f, 74.276f},
	{-38.793f, 45.616f, 68.974f},
	{-43.683f, 46.793f, 63.679f},
	{-49.307f, 44.558f, 57.916f},
	{-22.043f, 26.486f, 79.780f},
	{-28.591f, 30.439f, 82.117f},
	{-31.869f, 32.418f, 80.923f},
	{-38.264f, 36.282f, 77.411f},
	{-44.901f, 40.291f, 71.640f},
	{-49.367f, 42.991f, 65.876f},
	{-50.499f, 43.679f, 57.074f},
	{-22.777f, 25.270f, 79.779f},
	{-31.285f, 24.182f, 78.593f},
	{-34.684f, 25.359f, 77.496f},
	{-40.959f, 28.246f, 74.269f},
	{-46.925f, 32.147f, 68.967f},
	{-49.979f, 36.366f, 63.673f},
	{-50.749f, 42.170f, 57.914f},
	{-21.813f, 27.303f, 80.419f},
	{-28.221f, 32.887f, 82.232f},
	{-31.777f, 33.434f, 82.761f},
	{-39.177f, 34.156f, 82.840f},
	{-47.685f, 33.648f, 81.205f},
	{-54.145f, 32.125f, 78.588f},
	{-59.805f, 27.303f, 75.080f},
	{-21.813f, 25.934f, 80.419f},
	{-27.524f, 25.934f, 85.805f},
	{-31.403f, 25.934f, 86.383f},
	{-39.474f, 25.934f, 86.469f},
	{-48.754f, 25.934f, 84.686f},
	{-55.800f, 25.934f, 81.832f},
	{-60.660f, 25.934f, 74.584f},
	{-21.813f, 24.513f, 80.419f},
	{-28.221f, 19.183f, 82.232f},
	{-31.777f, 18.434f, 82.761f},
	{-39.177f, 17.661f, 82.840f},
	{-47.685f, 17.914f, 81.205f},
	{-54.145f, 19.945f, 78.588f},
	{-59.805f, 24.513f, 75.080f},
	{-21.462f, 27.303f, 81.356f},
	{-28.029f, 32.887f, 83.213f},
	{-31.674f, 33.434f, 83.756f},
	{-39.259f, 34.156f, 83.836f},
	{-47.978f, 33.648f, 82.161f},
	{-54.599f, 32.125f, 79.479f},
	{-60.400f, 27.303f, 75.883f},
	{-21.462f, 25.934f, 81.356f},
	{-27.332f, 25.934f, 86.787f},
	{-31.300f, 25.934f, 87.378f},
	{-39.556f, 25.934f, 87.465f},
	{-49.047f, 25.934f, 85.642f},
	{-56.254f, 25.934f, 82.722f},
	{-61.275f, 25.934f, 75.372f},
	{-21.462f, 24.513f, 81.356f},
	{-28.029f, 19.183f, 83.213f},
	{-31.674f, 18.434f, 83.756f},
	{-39.259f, 17.661f, 83.836f},
	{-47.978f, 17.914f, 82.161f},
	{-54.599f, 19.945f, 79.479f},
	{-60.400f, 24.513f, 75.883f},
	{-24.093f, 28.072f, 79.087f},
	{-32.775f, 27.884f, 78.755f},
	{-35.790f, 26.027f, 77.925f},
	{-41.546f, 22.173f, 75.222f},
	{-46.868f, 17.283f, 70.418f},
	{-49.829f, 13.152f, 65.412f},
	{-49.825f, 7.314f, 59.623f},
	{-23.186f, 27.052f, 78.975f},
	{-28.522f, 22.003f, 81.744f},
	{-31.415f, 19.534f, 80.790f},
	{-37.171f, 14.744f, 77.777f},
	{-43.343f, 9.823f, 72.582f},
	{-47.673f, 6.554f, 67.257f},
	{-49.408f, 5.944f, 58.727f},
	{-22.245f, 25.994f, 78.860f},
	{-23.698f, 17.679f, 77.639f},
	{-25.854f, 14.857f, 76.702f},
	{-30.619f, 9.889f, 73.877f},
	{-36.446f, 5.566f, 69.136f},
	{-41.761f, 4.081f, 64.419f},
	{-47.977f, 5.237f, 59.395f},
	{-24.066f, 27.987f, 80.083f},
	{-32.872f, 27.691f, 79.732f},
	{-35.953f, 25.778f, 78.880f},
	{-41.840f, 21.814f, 76.108f},
	{-47.303f, 16.812f, 71.185f},
	{-50.363f, 12.607f, 66.057f},
	{-50.439f, 6.712f, 60.134f},
	{-23.159f, 26.967f, 79.971f},
	{-28.618f, 21.810f, 82.720f},
	{-31.578f, 19.285f, 81.744f},
	{-37.466f, 14.385f, 78.663f},
	{-43.778f, 9.352f, 73.350f},
	{-48.207f, 6.008f, 67.903f},
	{-50.032f, 5.335f, 59.217f},
	{-22.218f, 25.910f, 79.856f},
	{-23.795f, 17.486f, 78.615f},
	{-26.017f, 14.607f, 77.657f},
	{-30.914f, 9.530f, 74.763f},
	{-36.881f, 5.095f, 69.903f},
	{-42.295f, 3.536f, 65.064f},
	{-48.591f, 4.635f, 59.906f},
	{-23.665f, 25.819f, 77.702f},
	{-30.858f, 21.749f, 80.389f},
	{-32.444f, 18.639f, 81.408f},
	{-35.392f, 11.903f, 82.516f},
	{-37.583f, 3.517f, 82.081f},
	{-38.224f, -3.384f, 80.389f},
	{-35.520f, -10.669f, 77.702f},
	{-22.362f, 25.396f, 77.702f},
	{-23.878f, 20.730f, 83.831f},
	{-25.040f, 17.153f, 84.942f},
	{-27.507f, 9.563f, 86.151f},
	{-30.423f, 0.588f, 85.677f},
	{-32.702f, -6.426f, 83.831f},
	{-34.501f, -11.963f, 77.330f},
	{-21.012f, 24.957f, 77.702f},
	{-17.825f, 17.515f, 80.389f},
	{-18.178f, 14.004f, 81.408f},
	{-19.704f, 6.806f, 82.516f},
	{-22.619f, -1.345f, 82.081f},
	{-26.639f, -7.148f, 80.389f},
	{-32.867f, -11.531f, 77.702f},
	{-23.517f, 26.273f, 78.581f},
	{-30.757f, 22.059f, 81.334f},
	{-32.369f, 18.868f, 82.378f},
	{-35.374f, 11.958f, 83.514f},
	{-37.631f, 3.368f, 83.069f},
	{-38.324f, -3.694f, 81.334f},
	{-35.668f, -11.123f, 78.581f},
	{-22.215f, 25.850f, 78.581f},
	{-23.778f, 21.040f, 84.776f},
	{-24.966f, 17.382f, 85.913f},
	{-27.489f, 9.618f, 87.149f},
	{-30.472f, 0.438f, 86.664f},
	{-32.803f, -6.736f, 84.776f},
	{-34.655f, -12.438f, 78.196f},
	{-20.864f, 25.411f, 78.581f},
	{-17.725f, 17.825f, 81.334f},
	{-18.104f, 14.232f, 82.378f},
	{-19.686f, 6.861f, 83.514f},
	{-22.668f, -1.495f, 83.069f},
	{-26.740f, -7.458f, 81.334f},
	{-33.015f, -11.985f, 78.581f},
	{-22.533f, 24.680f, 77.702f},
	{-20.885f, 16.581f, 80.389f},
	{-18.417f, 14.112f, 81.408f},
	{-12.922f, 9.227f, 82.516f},
	{-5.624f, 4.552f, 82.081f},
	{0.741f, 1.809f, 80.389f},
	{8.505f, 2.129f, 77.702f},
	{-21.728f, 25.788f, 77.702f},
	{-17.759f, 22.904f, 83.831f},
	{-14.717f, 20.694f, 84.942f},
	{-8.260f, 16.002f, 86.151f},
	{-0.625f, 10.455f, 85.677f},
	{5.341f, 6.121f, 83.831f},
	{10.051f, 2.699f, 77.330f},
	{-20.893f, 26.937f, 77.702f},
	{-12.831f, 27.667f, 80.389f},
	{-9.601f, 26.247f, 81.408f},
	{-3.226f, 22.572f, 82.516f},
	{3.624f, 17.280f, 82.081f},
	{7.901f, 11.664f, 80.389f},
	{10.145f, 4.386f, 77.702f},
	{-22.919f, 24.961f, 78.581f},
	{-21.149f, 16.773f, 81.334f},
	{-18.612f, 14.253f, 82.378f},
	{-12.969f, 9.261f, 83.514f},
	{-5.496f, 4.459f, 83.069f},
	{1.005f, 1.618f, 81.334f},
	{8.892f, 1.848f, 78.581f},
	{-22.115f, 26.068f, 78.581f},
	{-18.023f, 23.096f, 84.776f},
	{-14.911f, 20.835f, 85.913f},
	{-8.307f, 16.036f, 87.149f},
	{-0.497f, 10.363f, 86.664f},
	{5.605f, 5.929f, 84.776f},
	{10.455f, 2.405f, 78.196f},
	{-21.280f, 27.217f, 78.581f},
	{-13.095f, 27.859f, 81.334f},
	{-9.795f, 26.388f, 82.378f},
	{-3.273f, 22.606f, 83.514f},
	{3.752f, 17.188f, 83.069f},
	{8.165f, 11.472f, 81.334f},
	{10.532f, 4.105f, 78.581f},
	{-90.081f, -113.087f, 8.551f},
	{-16.386f, -22.964f, 8.551f},
	{-117.298f, -90.831f, 8.551f},
	{-43.602f, -0.709f, 8.551f},
	{-90.081f, -113.087f, 12.765f},
	{-16.386f, -22.964f, 12.765f},
	{-117.298f, -90.831f, 12.765f},
	{-43.602f, -0.709f, 12.765f},
	{-34.786f, -46.858f, 18.182f},
	{-32.720f, -49.047f, 17.349f},
	{-31.908f, -47.721f, 17.490f},
	{-31.894f, -46.169f, 17.785f},
	{-32.685f, -44.800f, 18.109f},
	{-34.037f, -43.980f, 18.359f},
	{-35.564f, -43.955f, 18.516f},
	{-36.880f, -44.712f, 18.657f},
	{-37.664f, -46.042f, 18.735f},
	{-37.704f, -47.590f, 18.609f},
	{-36.963f, -48.940f, 18.253f},
	{-35.636f, -49.736f, 17.809f},
	{-34.085f, -49.784f, 17.459f},
	{-31.976f, -49.892f, 16.179f},
	{-30.908f, -48.155f, 16.390f},
	{-30.896f, -46.133f, 16.791f},
	{-31.958f, -44.345f, 17.206f},
	{-33.741f, -43.254f, 17.492f},
	{-35.719f, -43.192f, 17.643f},
	{-37.409f, -44.152f, 17.843f},
	{-38.425f, -45.881f, 18.005f},
	{-38.484f, -47.910f, 17.880f},
	{-37.515f, -49.701f, 17.393f},
	{-35.776f, -50.769f, 16.777f},
	{-33.757f, -50.853f, 16.305f},
	{-32.008f, -48.400f, -15.077f},
	{-31.369f, -46.406f, -14.866f},
	{-31.808f, -44.622f, -14.465f},
	{-33.182f, -43.505f, -14.050f},
	{-35.073f, -43.269f, -13.764f},
	{-36.951f, -43.871f, -13.613f},
	{-38.335f, -45.231f, -13.413f},
	{-38.904f, -47.095f, -13.251f},
	{-38.531f, -48.999f, -13.376f},
	{-37.293f, -50.400f, -13.864f},
	{-35.470f, -50.816f, -14.480f},
	{-33.528f, -50.046f, -14.951f},
	{-32.699f, -47.992f, -15.673f},
	{-32.226f, -46.469f, -15.533f},
	{-32.563f, -45.100f, -15.237f},
	{-33.605f, -44.232f, -14.913f},
	{-35.048f, -44.041f, -14.663f},
	{-36.492f, -44.517f, -14.507f},
	{-37.561f, -45.581f, -14.365f},
	{-37.996f, -47.019f, -14.288f},
	{-37.694f, -48.467f, -14.413f},
	{-36.724f, -49.518f, -14.769f},
	{-35.318f, -49.820f, -15.213f},
	{-33.840f, -49.240f, -15.563f},
	{-35.111f, -46.930f, -14.840f},
	{-49.666f, -60.449f, 18.824f},
	{-47.164f, -61.887f, 18.263f},
	{-46.780f, -60.470f, 18.356f},
	{-47.141f, -59.003f, 18.636f},
	{-48.160f, -57.912f, 18.978f},
	{-49.585f, -57.561f, 19.203f},
	{-51.045f, -58.077f, 19.228f},
	{-52.139f, -59.285f, 19.116f},
	{-52.552f, -60.797f, 18.966f},
	{-52.164f, -62.177f, 18.826f},
	{-51.089f, -63.083f, 18.682f},
	{-49.635f, -63.337f, 18.513f},
	{-48.202f, -62.911f, 18.346f},
	{-46.327f, -62.343f, 17.174f},
	{-45.825f, -60.521f, 17.273f},
	{-46.286f, -58.578f, 17.658f},
	{-47.604f, -57.092f, 18.143f},
	{-49.459f, -56.587f, 18.442f},
	{-51.371f, -57.259f, 18.439f},
	{-52.813f, -58.861f, 18.255f},
	{-53.363f, -60.849f, 18.060f},
	{-52.857f, -62.638f, 17.909f},
	{-51.449f, -63.797f, 17.757f},
	{-49.548f, -64.129f, 17.553f},
	{-47.678f, -63.618f, 17.319f},
	{-45.359f, -64.306f, -14.082f},
	{-44.979f, -62.475f, -13.983f},
	{-45.585f, -60.541f, -13.598f},
	{-47.006f, -59.027f, -13.113f},
	{-48.897f, -58.360f, -12.814f},
	{-50.777f, -58.744f, -12.817f},
	{-52.117f, -60.069f, -13.001f},
	{-52.523f, -61.942f, -13.196f},
	{-51.892f, -63.838f, -13.347f},
	{-50.417f, -65.270f, -13.499f},
	{-48.499f, -65.893f, -13.703f},
	{-46.645f, -65.550f, -13.937f},
	{-46.071f, -63.746f, -14.759f},
	{-45.760f, -62.339f, -14.666f},
	{-46.213f, -60.862f, -14.387f},
	{-47.304f, -59.715f, -14.044f},
	{-48.757f, -59.217f, -13.820f},
	{-50.192f, -59.513f, -13.794f},
	{-51.214f, -60.520f, -13.907f},
	{-51.536f, -61.949f, -14.056f},
	{-51.073f, -63.405f, -14.196f},
	{-49.960f, -64.510f, -14.341f},
	{-48.496f, -64.986f, -14.509f},
	{-47.072f, -64.711f, -14.676f},
	{-48.648f, -62.101f, -14.198f},
	{-61.580f, -78.950f, 17.444f},
	{-59.111f, -79.913f, 17.878f},
	{-58.694f, -78.370f, 17.888f},
	{-59.098f, -77.019f, 17.821f},
	{-60.192f, -76.200f, 17.667f},
	{-61.654f, -76.060f, 17.433f},
	{-63.080f, -76.585f, 17.189f},
	{-64.099f, -77.723f, 17.062f},
	{-64.466f, -79.195f, 17.045f},
	{-64.108f, -80.612f, 17.129f},
	{-63.098f, -81.588f, 17.330f},
	{-61.676f, -81.840f, 17.593f},
	{-60.213f, -81.210f, 17.787f},
	{-58.429f, -80.055f, 17.110f},
	{-57.856f, -78.028f, 17.112f},
	{-58.373f, -76.275f, 17.037f},
	{-59.800f, -75.238f, 16.856f},
	{-61.709f, -75.086f, 16.560f},
	{-63.572f, -75.770f, 16.256f},
	{-64.904f, -77.252f, 16.118f},
	{-65.393f, -79.170f, 16.109f},
	{-64.954f, -81.024f, 16.221f},
	{-63.667f, -82.304f, 16.473f},
	{-61.823f, -82.635f, 16.793f},
	{-59.900f, -81.783f, 17.018f},
	{-58.755f, -79.858f, -14.146f},
	{-57.827f, -77.928f, -14.144f},
	{-58.009f, -76.085f, -14.219f},
	{-59.222f, -74.845f, -14.400f},
	{-61.059f, -74.580f, -14.697f},
	{-62.988f, -75.329f, -15.000f},
	{-64.528f, -76.802f, -15.138f},
	{-65.351f, -78.704f, -15.147f},
	{-65.268f, -80.573f, -15.035f},
	{-64.214f, -81.864f, -14.783f},
	{-62.448f, -82.130f, -14.463f},
	{-60.453f, -81.381f, -14.238f},
	{-59.527f, -79.430f, -15.144f},
	{-58.831f, -77.951f, -15.134f},
	{-58.958f, -76.541f, -15.201f},
	{-59.861f, -75.589f, -15.355f},
	{-61.254f, -75.372f, -15.589f},
	{-62.743f, -75.938f, -15.833f},
	{-63.949f, -77.080f, -15.960f},
	{-64.592f, -78.545f, -15.978f},
	{-64.515f, -79.969f, -15.893f},
	{-63.693f, -80.942f, -15.692f},
	{-62.337f, -81.152f, -15.429f},
	{-60.813f, -80.594f, -15.235f},
	{-61.711f, -78.262f, -15.578f},
	{-74.560f, -95.097f, 18.679f},
	{-71.941f, -96.640f, 19.217f},
	{-71.671f, -95.206f, 19.096f},
	{-72.140f, -93.754f, 18.883f},
	{-73.233f, -92.665f, 18.636f},
	{-74.685f, -92.212f, 18.398f},
	{-76.121f, -92.508f, 18.179f},
	{-77.142f, -93.486f, 18.012f},
	{-77.448f, -94.897f, 17.999f},
	{-76.945f, -96.370f, 18.221f},
	{-75.782f, -97.504f, 18.611f},
	{-74.294f, -97.982f, 18.983f},
	{-72.892f, -97.663f, 19.194f},
	{-71.453f, -97.025f, 18.447f},
	{-71.094f, -95.144f, 18.281f},
	{-71.678f, -93.256f, 18.010f},
	{-73.070f, -91.849f, 17.708f},
	{-74.950f, -91.270f, 17.435f},
	{-76.840f, -91.664f, 17.170f},
	{-78.208f, -92.944f, 16.926f},
	{-78.638f, -94.788f, 16.870f},
	{-77.989f, -96.710f, 17.158f},
	{-76.463f, -98.189f, 17.698f},
	{-74.516f, -98.805f, 18.196f},
	{-72.689f, -98.376f, 18.445f},
	{-71.749f, -96.170f, -12.810f},
	{-71.664f, -94.328f, -12.975f},
	{-72.479f, -92.404f, -13.246f},
	{-73.999f, -90.906f, -13.548f},
	{-75.916f, -90.234f, -13.821f},
	{-77.771f, -90.589f, -14.086f},
	{-79.016f, -91.882f, -14.330f},
	{-79.218f, -93.742f, -14.387f},
	{-78.295f, -95.650f, -14.098f},
	{-76.555f, -97.113f, -13.558f},
	{-74.527f, -97.766f, -13.060f},
	{-72.775f, -97.429f, -12.811f},
	{-72.268f, -95.572f, -13.805f},
	{-72.231f, -94.159f, -13.926f},
	{-72.908f, -92.688f, -14.139f},
	{-74.131f, -91.554f, -14.386f},
	{-75.626f, -91.064f, -14.624f},
	{-77.022f, -91.360f, -14.843f},
	{-77.916f, -92.363f, -15.010f},
	{-78.017f, -93.789f, -15.023f},
	{-77.281f, -95.248f, -14.801f},
	{-75.938f, -96.356f, -14.412f},
	{-74.382f, -96.833f, -14.039f},
	{-73.043f, -96.550f, -13.829f},
	{-75.124f, -93.948f, -14.343f},
	{-86.360f, -110.026f, 19.126f},
	{-84.186f, -111.551f, 19.669f},
	{-83.480f, -110.132f, 19.451f},
	{-83.598f, -108.667f, 19.044f},
	{-84.508f, -107.560f, 18.597f},
	{-85.911f, -107.139f, 18.355f},
	{-87.391f, -107.540f, 18.443f},
	{-88.589f, -108.628f, 18.710f},
	{-89.240f, -110.086f, 18.981f},
	{-89.174f, -111.515f, 19.199f},
	{-88.371f, -112.540f, 19.389f},
	{-87.025f, -112.912f, 19.553f},
	{-85.492f, -112.557f, 19.676f},
	{-83.752f, -112.058f, 18.958f},
	{-82.848f, -110.205f, 18.698f},
	{-83.039f, -108.291f, 18.161f},
	{-84.284f, -106.845f, 17.532f},
	{-86.147f, -106.305f, 17.184f},
	{-88.052f, -106.857f, 17.335f},
	{-89.560f, -108.309f, 17.722f},
	{-90.372f, -110.226f, 18.055f},
	{-90.266f, -112.081f, 18.284f},
	{-89.202f, -113.389f, 18.501f},
	{-87.435f, -113.844f, 18.722f},
	{-85.441f, -113.371f, 18.923f},
	{-82.798f, -111.549f, -12.298f},
	{-82.020f, -109.620f, -12.558f},
	{-82.349f, -107.776f, -13.095f},
	{-83.681f, -106.549f, -13.724f},
	{-85.568f, -106.353f, -14.072f},
	{-87.450f, -107.254f, -13.921f},
	{-88.874f, -108.928f, -13.534f},
	{-89.550f, -110.918f, -13.202f},
	{-89.316f, -112.705f, -12.972f},
	{-88.183f, -113.798f, -12.755f},
	{-86.399f, -113.907f, -12.534f},
	{-84.421f, -113.087f, -12.333f},
	{-83.248f, -111.304f, -13.353f},
	{-82.614f, -109.814f, -13.572f},
	{-82.814f, -108.414f, -13.978f},
	{-83.781f, -107.499f, -14.425f},
	{-85.203f, -107.359f, -14.667f},
	{-86.665f, -108.033f, -14.579f},
	{-87.808f, -109.300f, -14.312f},
	{-88.378f, -110.819f, -14.041f},
	{-88.238f, -112.192f, -13.824f},
	{-87.395f, -113.043f, -13.633f},
	{-86.037f, -113.143f, -13.469f},
	{-84.514f, -112.506f, -13.347f},
	{-85.496f, -110.251f, -13.896f},
	{-114.777f, -84.337f, -12.587f},
	{-112.372f, -86.119f, -12.288f},
	{-111.894f, -84.764f, -12.857f},
	{-112.111f, -83.239f, -13.391f},
	{-113.000f, -81.993f, -13.706f},
	{-114.372f, -81.452f, -13.756f},
	{-115.881f, -81.799f, -13.578f},
	{-117.103f, -82.889f, -13.254f},
	{-117.661f, -84.357f, -12.861f},
	{-117.370f, -85.777f, -12.455f},
	{-116.330f, -86.799f, -12.086f},
	{-114.881f, -87.222f, -11.857f},
	{-113.444f, -86.984f, -11.909f},
	{-111.730f, -87.160f, -11.405f},
	{-111.055f, -85.407f, -12.164f},
	{-111.264f, -83.400f, -12.867f},
	{-112.362f, -81.724f, -13.251f},
	{-114.132f, -80.973f, -13.276f},
	{-116.124f, -81.408f, -13.026f},
	{-117.780f, -82.831f, -12.615f},
	{-118.584f, -84.750f, -12.145f},
	{-118.255f, -86.602f, -11.660f},
	{-116.913f, -87.937f, -11.194f},
	{-115.022f, -88.506f, -10.867f},
	{-113.144f, -88.241f, -10.908f},
	{-110.683f, -87.640f, 19.852f},
	{-110.054f, -85.844f, 19.092f},
	{-110.403f, -83.877f, 18.389f},
	{-111.664f, -82.270f, 18.006f},
	{-113.506f, -81.522f, 17.980f},
	{-115.430f, -82.036f, 18.231f},
	{-116.927f, -83.551f, 18.642f},
	{-117.587f, -85.509f, 19.111f},
	{-117.208f, -87.326f, 19.597f},
	{-115.891f, -88.569f, 20.062f},
	{-114.022f, -89.057f, 20.389f},
	{-112.123f, -88.788f, 20.348f},
	{-111.221f, -86.755f, 20.734f},
	{-110.765f, -85.377f, 20.165f},
	{-111.064f, -83.874f, 19.631f},
	{-112.051f, -82.653f, 19.316f},
	{-113.468f, -82.105f, 19.266f},
	{-114.935f, -82.491f, 19.444f},
	{-116.060f, -83.631f, 19.769f},
	{-116.534f, -85.121f, 20.161f},
	{-116.218f, -86.521f, 20.568f},
	{-115.198f, -87.493f, 20.936f},
	{-113.764f, -87.875f, 21.165f},
	{-112.312f, -87.644f, 21.114f},
	{-113.649f, -84.990f, 20.436f},
	{-100.042f, -71.636f, -19.431f},
	{-97.564f, -73.420f, -18.951f},
	{-97.155f, -72.008f, -18.898f},
	{-97.555f, -70.536f, -18.954f},
	{-98.641f, -69.367f, -19.130f},
	{-100.098f, -68.755f, -19.372f},
	{-101.528f, -68.839f, -19.593f},
	{-102.556f, -69.629f, -19.701f},
	{-102.928f, -70.965f, -19.646f},
	{-102.562f, -72.508f, -19.474f},
	{-101.548f, -73.826f, -19.293f},
	{-100.127f, -74.517f, -19.162f},
	{-98.663f, -74.360f, -19.054f},
	{-96.752f, -74.071f, -17.887f},
	{-96.245f, -72.191f, -17.796f},
	{-96.810f, -70.303f, -17.856f},
	{-98.263f, -68.859f, -18.084f},
	{-100.180f, -68.139f, -18.405f},
	{-102.035f, -68.291f, -18.704f},
	{-103.342f, -69.336f, -18.853f},
	{-103.785f, -71.082f, -18.765f},
	{-103.280f, -73.096f, -18.509f},
	{-101.950f, -74.805f, -18.273f},
	{-100.097f, -75.666f, -18.138f},
	{-98.183f, -75.383f, -18.025f},
	{-97.666f, -73.046f, 13.369f},
	{-97.276f, -71.152f, 13.460f},
	{-97.885f, -69.276f, 13.401f},
	{-99.326f, -67.902f, 13.173f},
	{-101.230f, -67.347f, 12.851f},
	{-103.097f, -67.732f, 12.552f},
	{-104.417f, -68.979f, 12.404f},
	{-104.819f, -70.805f, 12.492f},
	{-104.199f, -72.744f, 12.747f},
	{-102.737f, -74.255f, 12.983f},
	{-100.823f, -74.882f, 13.118f},
	{-98.965f, -74.430f, 13.231f},
	{-98.478f, -72.363f, 14.071f},
	{-98.191f, -70.925f, 14.124f},
	{-98.670f, -69.477f, 14.068f},
	{-99.786f, -68.395f, 13.892f},
	{-101.249f, -67.943f, 13.651f},
	{-102.674f, -68.227f, 13.430f},
	{-103.672f, -69.184f, 13.322f},
	{-103.968f, -70.585f, 13.376f},
	{-103.481f, -72.068f, 13.549f},
	{-102.350f, -73.222f, 13.729f},
	{-100.879f, -73.712f, 13.860f},
	{-99.462f, -73.393f, 13.968f},
	{-101.079f, -70.828f, 13.592f},
	{-87.605f, -55.180f, -15.669f},
	{-85.255f, -56.185f, -15.560f},
	{-84.723f, -54.687f, -15.625f},
	{-84.897f, -53.295f, -15.696f},
	{-85.806f, -52.402f, -15.708f},
	{-87.198f, -52.288f, -15.733f},
	{-88.688f, -52.963f, -15.828f},
	{-89.889f, -54.222f, -15.939f},
	{-90.488f, -55.736f, -15.936f},
	{-90.251f, -57.113f, -15.864f},
	{-89.258f, -57.973f, -15.737f},
	{-87.830f, -58.073f, -15.601f},
	{-86.373f, -57.410f, -15.544f},
	{-84.647f, -56.410f, -14.672f},
	{-83.950f, -54.470f, -14.761f},
	{-84.154f, -52.636f, -14.838f},
	{-85.335f, -51.441f, -14.814f},
	{-87.153f, -51.287f, -14.813f},
	{-89.099f, -52.195f, -14.940f},
	{-90.673f, -53.858f, -15.130f},
	{-91.478f, -55.841f, -15.162f},
	{-91.171f, -57.635f, -15.089f},
	{-89.855f, -58.738f, -14.922f},
	{-87.979f, -58.842f, -14.723f},
	{-86.086f, -57.980f, -14.645f},
	{-85.094f, -56.806f, 16.584f},
	{-84.406f, -54.948f, 16.495f},
	{-84.649f, -53.038f, 16.418f},
	{-85.714f, -51.609f, 16.442f},
	{-87.460f, -51.100f, 16.444f},
	{-89.473f, -51.678f, 16.317f},
	{-91.165f, -53.141f, 16.126f},
	{-91.936f, -55.059f, 16.094f},
	{-91.617f, -56.912f, 16.168f},
	{-90.351f, -58.210f, 16.334f},
	{-88.503f, -58.640f, 16.533f},
	{-86.584f, -58.136f, 16.611f},
	{-85.901f, -56.301f, 17.462f},
	{-85.374f, -54.877f, 17.397f},
	{-85.583f, -53.416f, 17.326f},
	{-86.434f, -52.323f, 17.315f},
	{-87.786f, -51.927f, 17.290f},
	{-89.314f, -52.346f, 17.194f},
	{-90.574f, -53.442f, 17.083f},
	{-91.141f, -54.902f, 17.087f},
	{-90.896f, -56.330f, 17.159f},
	{-89.932f, -57.347f, 17.285f},
	{-88.520f, -57.701f, 17.421f},
	{-87.048f, -57.321f, 17.478f},
	{-88.257f, -54.814f, 17.353f},
	{-74.331f, -38.687f, -17.057f},
	{-71.744f, -40.305f, -17.104f},
	{-71.443f, -38.891f, -17.167f},
	{-71.928f, -37.420f, -17.214f},
	{-73.060f, -36.287f, -17.250f},
	{-74.532f, -35.802f, -17.231f},
	{-75.949f, -36.108f, -17.101f},
	{-76.931f, -37.121f, -16.895f},
	{-77.219f, -38.552f, -16.726f},
	{-76.746f, -40.006f, -16.681f},
	{-75.639f, -41.105f, -16.751f},
	{-74.180f, -41.572f, -16.878f},
	{-72.751f, -41.283f, -17.006f},
	{-70.981f, -40.894f, -16.214f},
	{-70.596f, -39.055f, -16.276f},
	{-71.247f, -37.128f, -16.327f},
	{-72.739f, -35.627f, -16.393f},
	{-74.665f, -34.959f, -16.399f},
	{-76.512f, -35.327f, -16.234f},
	{-77.781f, -36.635f, -15.937f},
	{-78.140f, -38.501f, -15.701f},
	{-77.514f, -40.403f, -15.654f},
	{-76.071f, -41.852f, -15.765f},
	{-74.170f, -42.492f, -15.939f},
	{-72.300f, -42.150f, -16.101f},
	{-69.236f, -41.799f, 15.042f},
	{-68.672f, -39.923f, 14.980f},
	{-69.289f, -38.030f, 14.930f},
	{-70.854f, -36.611f, 14.864f},
	{-72.828f, -36.018f, 14.857f},
	{-74.629f, -36.400f, 15.023f},
	{-75.824f, -37.674f, 15.319f},
	{-76.213f, -39.517f, 15.556f},
	{-75.760f, -41.440f, 15.603f},
	{-74.527f, -42.924f, 15.491f},
	{-72.719f, -43.552f, 15.317f},
	{-70.762f, -43.138f, 15.155f},
	{-70.059f, -41.405f, 15.918f},
	{-69.623f, -39.974f, 15.855f},
	{-70.056f, -38.519f, 15.808f},
	{-71.206f, -37.421f, 15.772f},
	{-72.696f, -36.956f, 15.792f},
	{-74.095f, -37.242f, 15.921f},
	{-75.058f, -38.213f, 16.128f},
	{-75.396f, -39.623f, 16.296f},
	{-75.055f, -41.097f, 16.341f},
	{-74.094f, -42.237f, 16.271f},
	{-72.699f, -42.725f, 16.144f},
	{-71.210f, -42.418f, 16.016f},
	{-72.509f, -39.840f, 15.965f},
	{-61.085f, -23.143f, -14.573f},
	{-58.933f, -24.287f, -15.056f},
	{-58.206f, -22.804f, -14.732f},
	{-58.244f, -21.398f, -14.322f},
	{-59.054f, -20.457f, -14.031f},
	{-60.409f, -20.253f, -13.990f},
	{-61.934f, -20.787f, -14.226f},
	{-63.231f, -21.902f, -14.607f},
	{-63.964f, -23.358f, -14.958f},
	{-63.920f, -24.790f, -15.169f},
	{-63.097f, -25.790f, -15.228f},
	{-61.735f, -26.034f, -15.213f},
	{-60.217f, -25.462f, -15.189f},
	{-58.386f, -24.715f, -14.400f},
	{-57.450f, -22.778f, -13.973f},
	{-57.514f, -20.941f, -13.399f},
	{-58.594f, -19.717f, -13.005f},
	{-60.376f, -19.471f, -12.967f},
	{-62.356f, -20.173f, -13.309f},
	{-64.028f, -21.610f, -13.826f},
	{-64.971f, -23.500f, -14.277f},
	{-64.901f, -25.380f, -14.522f},
	{-63.802f, -26.706f, -14.549f},
	{-62.007f, -27.021f, -14.502f},
	{-60.039f, -26.254f, -14.518f},
	{-59.632f, -25.029f, 16.856f},
	{-59.612f, -23.010f, 17.284f},
	{-60.503f, -21.250f, 17.857f},
	{-62.084f, -20.181f, 18.251f},
	{-64.023f, -19.952f, 18.289f},
	{-65.857f, -20.611f, 17.947f},
	{-67.043f, -22.084f, 17.430f},
	{-67.168f, -23.998f, 16.980f},
	{-66.179f, -25.855f, 16.734f},
	{-64.402f, -27.145f, 16.707f},
	{-62.364f, -27.498f, 16.754f},
	{-60.622f, -26.723f, 16.738f},
	{-60.337f, -24.867f, 17.966f},
	{-60.310f, -23.333f, 18.290f},
	{-61.005f, -21.974f, 18.700f},
	{-62.245f, -21.124f, 18.991f},
	{-63.746f, -20.924f, 19.032f},
	{-65.136f, -21.428f, 18.796f},
	{-66.014f, -22.560f, 18.415f},
	{-66.097f, -24.029f, 18.065f},
	{-65.349f, -25.448f, 17.853f},
	{-64.003f, -26.431f, 17.794f},
	{-62.448f, -26.701f, 17.810f},
	{-61.109f, -26.132f, 17.833f},
	{-63.203f, -23.813f, 18.449f}
};

const unsigned short p_face_index[][3] = {
	{6, 61, 36}, //66136
	{36, 62,  6}, //36626
	{0, 64, 36}, //06436
	{36, 61,  0}, //36610
	{1, 63, 36}, //16336
	{36, 64,  1}, //36641
	{7, 62, 36}, //76236
	{36, 63,  7}, //36637
	{7, 63, 37}, //76337
	{37, 65,  7}, //37657
	{1, 67, 37}, //16737
	{37, 63,  1}, //37631
	{2, 66, 37}, //26637
	{37, 67,  2}, //37672
	{8, 65, 37}, //86537
	{37, 66,  8}, //37668
	{8, 66, 38}, //86638
	{38, 68,  8}, //38688
	{2, 70, 38}, //27038
	{38, 66,  2}, //38662
	{3, 69, 38}, //36938
	{38, 70,  3}, //38703
	{9, 68, 38}, //96838
	{38, 69,  9}, //38699
	{9, 69, 39}, //96939
	{39, 71,  9}, //39719
	{3, 73, 39}, //37339
	{39, 69,  3}, //39693
	{4, 72, 39}, //47239
	{39, 73,  4}, //39734
	{10, 71, 39}, //107139
	{39, 72, 10}, //397210
	{10, 72, 40}, //107240
	{40, 74, 10}, //407410
	{4, 76, 40}, //47640
	{40, 72,  4}, //40724
	{5, 75, 40}, //57540
	{40, 76,  5}, //40765
	{11, 74, 40}, //117440
	{40, 75, 11}, //407511
	{12, 77, 41}, //127741
	{41, 78, 12}, //417812
	{6, 62, 41}, //66241
	{41, 77,  6}, //41776
	{7, 79, 41}, //77941
	{41, 62,  7}, //41627
	{13, 78, 41}, //137841
	{41, 79, 13}, //417913
	{13, 79, 42}, //137942
	{42, 80, 13}, //428013
	{7, 65, 42}, //76542
	{42, 79,  7}, //42797
	{8, 81, 42}, //88142
	{42, 65,  8}, //42658
	{14, 80, 42}, //148042
	{42, 81, 14}, //428114
	{14, 81, 43}, //148143
	{43, 82, 14}, //438214
	{8, 68, 43}, //86843
	{43, 81,  8}, //43818
	{9, 83, 43}, //98343
	{43, 68,  9}, //43689
	{15, 82, 43}, //158243
	{43, 83, 15}, //438315
	{15, 83, 44}, //158344
	{44, 84, 15}, //448415
	{9, 71, 44}, //97144
	{44, 83,  9}, //44839
	{10, 85, 44}, //108544
	{44, 71, 10}, //447110
	{16, 84, 44}, //168444
	{44, 85, 16}, //448516
	{16, 85, 45}, //168545
	{45, 86, 16}, //458616
	{10, 74, 45}, //107445
	{45, 85, 10}, //458510
	{11, 87, 45}, //118745
	{45, 74, 11}, //457411
	{17, 86, 45}, //178645
	{45, 87, 17}, //458717
	{18, 88, 46}, //188846
	{46, 89, 18}, //468918
	{12, 78, 46}, //127846
	{46, 88, 12}, //468812
	{13, 90, 46}, //139046
	{46, 78, 13}, //467813
	{19, 89, 46}, //198946
	{46, 90, 19}, //469019
	{19, 90, 47}, //199047
	{47, 91, 19}, //479119
	{13, 80, 47}, //138047
	{47, 90, 13}, //479013
	{14, 92, 47}, //149247
	{47, 80, 14}, //478014
	{20, 91, 47}, //209147
	{47, 92, 20}, //479220
	{20, 92, 48}, //209248
	{48, 93, 20}, //489320
	{14, 82, 48}, //148248
	{48, 92, 14}, //489214
	{15, 94, 48}, //159448
	{48, 82, 15}, //488215
	{21, 93, 48}, //219348
	{48, 94, 21}, //489421
	{21, 94, 49}, //219449
	{49, 95, 21}, //499521
	{15, 84, 49}, //158449
	{49, 94, 15}, //499415
	{16, 96, 49}, //169649
	{49, 84, 16}, //498416
	{22, 95, 49}, //229549
	{49, 96, 22}, //499622
	{22, 96, 50}, //229650
	{50, 97, 22}, //509722
	{16, 86, 50}, //168650
	{50, 96, 16}, //509616
	{17, 98, 50}, //179850
	{50, 86, 17}, //508617
	{23, 97, 50}, //239750
	{50, 98, 23}, //509823
	{24, 99, 51}, //249951
	{51, 100, 24}, //5110024
	{18, 89, 51}, //188951
	{51, 99, 18}, //519918
	{19, 101, 51}, //1910151
	{51, 89, 19}, //518919
	{25, 100, 51}, //2510051
	{51, 101, 25}, //5110125
	{25, 101, 52}, //2510152
	{52, 102, 25}, //5210225
	{19, 91, 52}, //199152
	{52, 101, 19}, //5210119
	{20, 103, 52}, //2010352
	{52, 91, 20}, //529120
	{26, 102, 52}, //2610252
	{52, 103, 26}, //5210326
	{26, 103, 53}, //2610353
	{53, 104, 26}, //5310426
	{20, 93, 53}, //209353
	{53, 103, 20}, //5310320
	{21, 105, 53}, //2110553
	{53, 93, 21}, //539321
	{27, 104, 53}, //2710453
	{53, 105, 27}, //5310527
	{27, 105, 54}, //2710554
	{54, 106, 27}, //5410627
	{21, 95, 54}, //219554
	{54, 105, 21}, //5410521
	{22, 107, 54}, //2210754
	{54, 95, 22}, //549522
	{28, 106, 54}, //2810654
	{54, 107, 28}, //5410728
	{28, 107, 55}, //2810755
	{55, 108, 28}, //5510828
	{22, 97, 55}, //229755
	{55, 107, 22}, //5510722
	{23, 109, 55}, //2310955
	{55, 97, 23}, //559723
	{29, 108, 55}, //2910855
	{55, 109, 29}, //5510929
	{30, 110, 56}, //3011056
	{56, 111, 30}, //5611130
	{24, 100, 56}, //2410056
	{56, 110, 24}, //5611024
	{25, 112, 56}, //2511256
	{56, 100, 25}, //5610025
	{31, 111, 56}, //3111156
	{56, 112, 31}, //5611231
	{31, 112, 57}, //3111257
	{57, 113, 31}, //5711331
	{25, 102, 57}, //2510257
	{57, 112, 25}, //5711225
	{26, 114, 57}, //2611457
	{57, 102, 26}, //5710226
	{32, 113, 57}, //3211357
	{57, 114, 32}, //5711432
	{32, 114, 58}, //3211458
	{58, 115, 32}, //5811532
	{26, 104, 58}, //2610458
	{58, 114, 26}, //5811426
	{27, 116, 58}, //2711658
	{58, 104, 27}, //5810427
	{33, 115, 58}, //3311558
	{58, 116, 33}, //5811633
	{33, 116, 59}, //3311659
	{59, 117, 33}, //5911733
	{27, 106, 59}, //2710659
	{59, 116, 27}, //5911627
	{28, 118, 59}, //2811859
	{59, 106, 28}, //5910628
	{34, 117, 59}, //3411759
	{59, 118, 34}, //5911834
	{34, 118, 60}, //3411860
	{60, 119, 34}, //6011934
	{28, 108, 60}, //2810860
	{60, 118, 28}, //6011828
	{29, 120, 60}, //2912060
	{60, 108, 29}, //6010829
	{35, 119, 60}, //3511960
	{60, 120, 35}, //6012035
	{121, 123, 122}, //121123122
	{121, 124, 123}, //121124123
	{121, 125, 124}, //121125124
	{121, 126, 125}, //121126125
	{121, 127, 126}, //121127126
	{121, 128, 127}, //121128127
	{121, 129, 128}, //121129128
	{121, 130, 129}, //121130129
	{121, 131, 130}, //121131130
	{121, 132, 131}, //121132131
	{121, 133, 132}, //121133132
	{121, 134, 133}, //121134133
	{121, 135, 134}, //121135134
	{121, 136, 135}, //121136135
	{121, 137, 136}, //121137136
	{121, 138, 137}, //121138137
	{121, 139, 138}, //121139138
	{121, 140, 139}, //121140139
	{121, 141, 140}, //121141140
	{121, 142, 141}, //121142141
	{121, 143, 142}, //121143142
	{121, 144, 143}, //121144143
	{121, 145, 144}, //121145144
	{121, 122, 145}, //121122145
	{122, 147, 146}, //146192172
	{122, 123, 147}, //146147192
	{123, 148, 147}, //147193192
	{123, 124, 148}, //147148193
	{124, 149, 148}, //148194193
	{124, 125, 149}, //148168194
	{125, 150, 149}, //149174173
	{125, 126, 150}, //149150174
	{126, 151, 150}, //150175174
	{126, 127, 151}, //150151175
	{127, 152, 151}, //151176175
	{127, 128, 152}, //151152176
	{128, 153, 152}, //152177176
	{128, 129, 153}, //152153177
	{129, 154, 153}, //153178177
	{129, 130, 154}, //153154178
	{130, 155, 154}, //154179178
	{130, 131, 155}, //154155179
	{131, 156, 155}, //156183182
	{131, 132, 156}, //156157183
	{132, 157, 156}, //157184183
	{132, 133, 157}, //157158184
	{133, 158, 157}, //158204184
	{133, 134, 158}, //158159204
	{134, 159, 158}, //159205204
	{134, 135, 159}, //159160205
	{135, 160, 159}, //160206205
	{135, 136, 160}, //160180206
	{136, 161, 160}, //180207206
	{136, 137, 161}, //180181207
	{137, 162, 161}, //161186185
	{137, 138, 162}, //161162186
	{138, 163, 162}, //162187186
	{138, 139, 163}, //162163187
	{139, 164, 163}, //163188187
	{139, 140, 164}, //163164188
	{140, 165, 164}, //164189188
	{140, 141, 165}, //164165189
	{141, 166, 165}, //165190189
	{141, 142, 166}, //165166190
	{142, 167, 166}, //166191190
	{142, 143, 167}, //166167191
	{143, 168, 167}, //169196195
	{143, 144, 168}, //169170196
	{144, 169, 168}, //170216196
	{144, 145, 169}, //170171216
	{145, 146, 169}, //171172216
	{145, 122, 146}, //171146172
	{146, 171, 170}, //172218217
	{146, 147, 171}, //172192218
	{147, 172, 171}, //192219218
	{147, 148, 172}, //192193219
	{148, 173, 172}, //193220219
	{148, 149, 173}, //193194220
	{149, 174, 173}, //173198197
	{149, 150, 174}, //173174198
	{150, 175, 174}, //174199198
	{150, 151, 175}, //174175199
	{151, 176, 175}, //175200199
	{151, 152, 176}, //175176200
	{152, 177, 176}, //176201200
	{152, 153, 177}, //176177201
	{153, 178, 177}, //177202201
	{153, 154, 178}, //177178202
	{154, 179, 178}, //178203202
	{154, 155, 179}, //178179203
	{155, 180, 179}, //182228208
	{155, 156, 180}, //182183228
	{156, 181, 180}, //183229228
	{156, 157, 181}, //183184229
	{157, 182, 181}, //184230229
	{157, 158, 182}, //184204230
	{158, 183, 182}, //204231230
	{158, 159, 183}, //204205231
	{159, 184, 183}, //205232231
	{159, 160, 184}, //205206232
	{160, 185, 184}, //2061484232
	{160, 161, 185}, //2062071484
	{161, 186, 185}, //185210209
	{161, 162, 186}, //185186210
	{162, 187, 186}, //186211210
	{162, 163, 187}, //186187211
	{163, 188, 187}, //187212211
	{163, 164, 188}, //187188212
	{164, 189, 188}, //188213212
	{164, 165, 189}, //188189213
	{165, 190, 189}, //189214213
	{165, 166, 190}, //189190214
	{166, 191, 190}, //190215214
	{166, 167, 191}, //190191215
	{167, 192, 191}, //195241240
	{167, 168, 192}, //195196241
	{168, 193, 192}, //1961462241
	{168, 169, 193}, //1962161462
	{169, 170, 193}, //2162171462
	{169, 146, 170}, //216172217
	{170, 195, 194}, //21714641463
	{170, 171, 195}, //2172181464
	{171, 196, 195}, //21814651464
	{171, 172, 196}, //2182191465
	{172, 197, 196}, //21914661465
	{172, 173, 197}, //2192201466
	{173, 198, 197}, //197222221
	{173, 174, 198}, //197198222
	{174, 199, 198}, //198223222
	{174, 175, 199}, //198199223
	{175, 200, 199}, //199224223
	{175, 176, 200}, //199200224
	{176, 201, 200}, //200225224
	{176, 177, 201}, //200201225
	{177, 202, 201}, //201226225
	{177, 178, 202}, //201202226
	{178, 203, 202}, //202227226
	{178, 179, 203}, //202203227
	{179, 204, 203}, //20814861485
	{179, 180, 204}, //2082281486
	{180, 205, 204}, //22814871486
	{180, 181, 205}, //2282291487
	{181, 206, 205}, //22914881487
	{181, 182, 206}, //2292301488
	{182, 207, 206}, //23014891488
	{182, 183, 207}, //2302311489
	{183, 208, 207}, //23114901489
	{183, 184, 208}, //2312321490
	{184, 209, 208}, //23214911490
	{184, 185, 209}, //23214841491
	{185, 210, 209}, //209234233
	{185, 186, 210}, //209210234
	{186, 211, 210}, //210235234
	{186, 187, 211}, //210211235
	{187, 212, 211}, //211236235
	{187, 188, 212}, //211212236
	{188, 213, 212}, //212237236
	{188, 189, 213}, //212213237
	{189, 214, 213}, //213238237
	{189, 190, 214}, //213214238
	{190, 215, 214}, //214239238
	{190, 191, 215}, //214215239
	{191, 216, 215}, //24014681467
	{191, 192, 216}, //2402411468
	{192, 217, 216}, //24114691468
	{192, 193, 217}, //24114621469
	{193, 194, 217}, //146214631469
	{193, 170, 194}, //14622171463
	{194, 219, 218}, //146314711470
	{194, 195, 219}, //146314641471
	{195, 220, 219}, //146414721471
	{195, 196, 220}, //146414651472
	{196, 221, 220}, //146514731472
	{196, 197, 221}, //146514661473
	{197, 222, 221}, //221269268
	{197, 198, 222}, //221222269
	{198, 223, 222}, //222270269
	{198, 199, 223}, //222223270
	{199, 224, 223}, //223271270
	{199, 200, 224}, //223224271
	{200, 225, 224}, //224272271
	{200, 201, 225}, //224225272
	{201, 226, 225}, //225273272
	{201, 202, 226}, //225226273
	{202, 227, 226}, //226274273
	{202, 203, 227}, //226227274
	{203, 228, 227}, //148514931492
	{203, 204, 228}, //148514861493
	{204, 229, 228}, //148614941493
	{204, 205, 229}, //148614871494
	{205, 230, 229}, //148714951494
	{205, 206, 230}, //148714881495
	{206, 231, 230}, //148814961495
	{206, 207, 231}, //148814891496
	{207, 232, 231}, //148914971496
	{207, 208, 232}, //148914901497
	{208, 233, 232}, //149014981497
	{208, 209, 233}, //149014911498
	{209, 234, 233}, //2331506282
	{209, 210, 234}, //2332341506
	{210, 235, 234}, //23415071506
	{210, 211, 235}, //2342351507
	{211, 236, 235}, //23515081507
	{211, 212, 236}, //2352361508
	{212, 237, 236}, //23615091508
	{212, 213, 237}, //2362371509
	{213, 238, 237}, //23715101509
	{213, 214, 238}, //2372381510
	{214, 239, 238}, //23815111510
	{214, 215, 239}, //2382391511
	{215, 240, 239}, //146714751474
	{215, 216, 240}, //146714681475
	{216, 241, 240}, //146814761475
	{216, 217, 241}, //146814691476
	{217, 218, 241}, //146914701476
	{217, 194, 218}, //146914631470
	{218, 243, 242}, //147014781477
	{218, 219, 243}, //147014711478
	{219, 244, 243}, //147114791478
	{219, 220, 244}, //147114721479
	{220, 245, 244}, //147214801479
	{220, 221, 245}, //147214731480
	{221, 246, 245}, //268276275
	{221, 222, 246}, //268269276
	{222, 247, 246}, //269277276
	{222, 223, 247}, //269270277
	{223, 248, 247}, //270278277
	{223, 224, 248}, //270271278
	{224, 249, 248}, //271279278
	{224, 225, 249}, //271272279
	{225, 250, 249}, //272280279
	{225, 226, 250}, //272273280
	{226, 251, 250}, //273281280
	{226, 227, 251}, //273274281
	{227, 252, 251}, //149215001499
	{227, 228, 252}, //149214931500
	{228, 253, 252}, //149315011500
	{228, 229, 253}, //149314941501
	{229, 254, 253}, //149415021501
	{229, 230, 254}, //149414951502
	{230, 255, 254}, //149515031502
	{230, 231, 255}, //149514961503
	{231, 256, 255}, //149615041503
	{231, 232, 256}, //149614971504
	{232, 257, 256}, //149715051504
	{232, 233, 257}, //149714981505
	{233, 258, 257}, //28215131512
	{233, 234, 258}, //28215061513
	{234, 259, 258}, //150615141513
	{234, 235, 259}, //150615071514
	{235, 260, 259}, //150715151514
	{235, 236, 260}, //150715081515
	{236, 261, 260}, //150815161515
	{236, 237, 261}, //150815091516
	{237, 262, 261}, //150915171516
	{237, 238, 262}, //150915101517
	{238, 263, 262}, //151015181517
	{238, 239, 263}, //151015111518
	{239, 264, 263}, //147414821481
	{239, 240, 264}, //147414751482
	{240, 265, 264}, //147514831482
	{240, 241, 265}, //147514761483
	{241, 242, 265}, //147614771483
	{241, 218, 242}, //147614701477
	{266, 242, 243}, //266242243
	{266, 243, 244}, //266243244
	{266, 244, 245}, //266244245
	{266, 245, 246}, //266245246
	{266, 246, 247}, //266246247
	{266, 247, 248}, //266247248
	{266, 248, 249}, //266248249
	{266, 249, 250}, //266249250
	{266, 250, 251}, //266250251
	{266, 251, 252}, //266251252
	{266, 252, 253}, //266252253
	{266, 253, 254}, //266253254
	{266, 254, 255}, //266254255
	{266, 255, 256}, //266255256
	{266, 256, 257}, //266256257
	{266, 257, 258}, //266257258
	{266, 258, 259}, //266258259
	{266, 259, 260}, //266259260
	{266, 260, 261}, //266260261
	{266, 261, 262}, //266261262
	{266, 262, 263}, //266262263
	{266, 263, 264}, //266263264
	{266, 264, 265}, //266264265
	{266, 265, 242}, //266265242
	{267, 274, 275}, //30715901591
	{275, 268, 267}, //1591314307
	{268, 275, 276}, //31415911592
	{276, 269, 268}, //1592321314
	{269, 276, 277}, //32115921593
	{277, 270, 269}, //15931588321
	{270, 277, 278}, //158815931594
	{278, 271, 270}, //159415891588
	{271, 278, 279}, //30621342135
	{279, 272, 271}, //1888305304
	{272, 279, 280}, //30518881889
	{280, 273, 272}, //1889311305
	{274, 281, 282}, //159015951596
	{282, 275, 274}, //159615911590
	{275, 282, 283}, //159115961597
	{283, 276, 275}, //159715921591
	{276, 283, 284}, //159215971598
	{284, 277, 276}, //159815931592
	{277, 284, 285}, //159315981599
	{285, 278, 277}, //159915941593
	{278, 285, 286}, //312318319
	{286, 279, 278}, //212621252124
	{279, 286, 287}, //313319320
	{287, 280, 279}, //189018891888
	{288, 289, 296}, //157315741579
	{296, 295, 288}, //157915781573
	{289, 290, 297}, //157415751580
	{297, 296, 289}, //158015791574
	{290, 291, 298}, //157515761581
	{298, 297, 290}, //158115801575
	{291, 292, 299}, //157615771582
	{299, 298, 291}, //158215811576
	{292, 293, 300}, //3093101891
	{300, 299, 292}, //21372136308
	{293, 294, 301}, //3103171892
	{301, 300, 293}, //18921891310
	{295, 296, 303}, //157815791584
	{303, 302, 295}, //158415831578
	{296, 297, 304}, //157915801585
	{304, 303, 296}, //158515841579
	{297, 298, 305}, //158015811586
	{305, 304, 297}, //158615851580
	{298, 299, 306}, //158115821587
	{306, 305, 298}, //158715861581
	{299, 300, 307}, //211621172118
	{307, 306, 299}, //323322315
	{300, 301, 308}, //189118921893
	{308, 307, 300}, //324323316
	{267, 268, 289}, //290291299
	{289, 288, 267}, //299298290
	{268, 269, 290}, //291292300
	{290, 289, 268}, //300299291
	{269, 270, 291}, //292293301
	{291, 290, 269}, //301300292
	{270, 271, 292}, //2932941768
	{292, 291, 270}, //1768301293
	{271, 272, 293}, //2942971769
	{293, 292, 271}, //17691768294
	{272, 273, 294}, //284287295
	{294, 293, 272}, //295288284
	{273, 280, 301}, //28521292130
	{301, 294, 273}, //296295287
	{280, 287, 308}, //26715231530
	{308, 301, 280}, //15301524267
	{287, 286, 307}, //152315221529
	{307, 308, 287}, //152915301523
	{286, 285, 306}, //152215211528
	{306, 307, 286}, //152815291522
	{285, 284, 305}, //152115201527
	{305, 306, 285}, //152715281521
	{284, 283, 304}, //152015191526
	{304, 305, 284}, //152615271520
	{283, 282, 303}, //15192831525
	{303, 304, 283}, //152515261519
	{282, 281, 302}, //186918681872
	{302, 303, 282}, //187218731869
	{281, 274, 295}, //18682891871
	{295, 302, 281}, //187118721868
	{274, 267, 288}, //2892861870
	{288, 295, 274}, //18701871289
	{309, 316, 317}, //34816351636
	{317, 310, 309}, //1636355348
	{310, 317, 318}, //35516361637
	{318, 311, 310}, //1637362355
	{311, 318, 319}, //36216371638
	{319, 312, 311}, //16381633362
	{312, 319, 320}, //163316381639
	{320, 313, 312}, //163916341633
	{313, 320, 321}, //302346347
	{321, 314, 313}, //347303302
	{314, 321, 322}, //3453591908
	{322, 315, 314}, //1908352345
	{316, 323, 324}, //163516401641
	{324, 317, 316}, //164116361635
	{317, 324, 325}, //163616411642
	{325, 318, 317}, //164216371636
	{318, 325, 326}, //163716421643
	{326, 319, 318}, //164316381637
	{319, 326, 327}, //163816431644
	{327, 320, 319}, //164416391638
	{320, 327, 328}, //36120702071
	{328, 321, 320}, //360354353
	{321, 328, 329}, //35919091910
	{329, 322, 321}, //19101908359
	{330, 331, 338}, //161816191624
	{338, 337, 330}, //162416231618
	{331, 332, 339}, //161916201625
	{339, 338, 331}, //162516241619
	{332, 333, 340}, //162016211626
	{340, 339, 332}, //162616251620
	{333, 334, 341}, //162116221627
	{341, 340, 333}, //162716261621
	{334, 335, 342}, //3493502139
	{342, 341, 334}, //21392138349
	{335, 336, 343}, //3513581884
	{343, 342, 335}, //1884365351
	{337, 338, 345}, //162316241629
	{345, 344, 337}, //162916281623
	{338, 339, 346}, //162416251630
	{346, 345, 338}, //163016291624
	{339, 340, 347}, //162516261631
	{347, 346, 339}, //163116301625
	{340, 341, 348}, //162616271632
	{348, 347, 340}, //163216311626
	{341, 342, 349}, //356357364
	{349, 348, 341}, //20972096363
	{342, 343, 350}, //36518841886
	{350, 349, 342}, //18861885365
	{309, 310, 331}, //331332339
	{331, 330, 309}, //339338331
	{310, 311, 332}, //332333340
	{332, 331, 310}, //340339332
	{311, 312, 333}, //333334341
	{333, 332, 311}, //341340333
	{312, 313, 334}, //334335342
	{334, 333, 312}, //342341334
	{313, 314, 335}, //335336343
	{335, 334, 313}, //343342335
	{314, 315, 336}, //336337344
	{336, 335, 314}, //344343336
	{315, 322, 343}, //3263272127
	{343, 336, 315}, //329328325
	{322, 329, 350}, //3273302128
	{350, 343, 322}, //21282127327
	{329, 328, 349}, //155115501557
	{349, 350, 329}, //155715581551
	{328, 327, 348}, //155015491556
	{348, 349, 328}, //155615571550
	{327, 326, 347}, //154915481555
	{347, 348, 327}, //155515561549
	{326, 325, 346}, //154815471554
	{346, 347, 326}, //155415551548
	{325, 324, 345}, //154715461553
	{345, 346, 325}, //155315541547
	{324, 323, 344}, //154615451552
	{344, 345, 324}, //155215531546
	{323, 316, 337}, //161416131616
	{337, 344, 323}, //161616171614
	{316, 309, 330}, //161316121615
	{330, 337, 316}, //161516161613
	{351, 358, 359}, //213121322133
	{359, 352, 351}, //2140392391
	{352, 359, 360}, //388397402
	{360, 353, 352}, //402389388
	{353, 360, 361}, //389402403
	{361, 354, 353}, //403390389
	{354, 361, 362}, //390403404
	{362, 355, 354}, //404395390
	{355, 362, 363}, //3954041925
	{363, 356, 355}, //1925396395
	{356, 363, 364}, //66819771978
	{364, 357, 356}, //210721062105
	{358, 365, 366}, //189718981899
	{366, 359, 358}, //20832082405
	{359, 366, 367}, //39719261927
	{367, 360, 359}, //1927402397
	{360, 367, 368}, //40219271928
	{368, 361, 360}, //1928403402
	{361, 368, 369}, //40319281929
	{369, 362, 361}, //1929404403
	{362, 369, 370}, //40419291930
	{370, 363, 362}, //19301925404
	{363, 370, 371}, //40120752076
	{371, 364, 363}, //2141400393
	{372, 373, 380}, //386387394
	{380, 379, 372}, //212321222121
	{373, 374, 381}, //6106111916
	{381, 380, 373}, //19161915610
	{374, 375, 382}, //61119121917
	{382, 381, 374}, //19171916611
	{375, 376, 383}, //191219131918
	{383, 382, 375}, //191819171912
	{376, 377, 384}, //191319141919
	{384, 383, 376}, //191919181913
	{377, 378, 385}, //210221032104
	{385, 384, 377}, //200720062005
	{379, 380, 387}, //204720482049
	{387, 386, 379}, //189618951894
	{380, 381, 388}, //191519161921
	{388, 387, 380}, //192119201915
	{381, 382, 389}, //191619171922
	{389, 388, 381}, //192219211916
	{382, 383, 390}, //191719181923
	{390, 389, 382}, //192319221917
	{383, 384, 391}, //191819191924
	{391, 390, 383}, //192419231918
	{384, 385, 392}, //398399406
	{392, 391, 384}, //18281827381
	{351, 352, 373}, //178017811786
	{373, 372, 351}, //178617851780
	{352, 353, 374}, //178117821787
	{374, 373, 352}, //178717861781
	{353, 354, 375}, //178217831788
	{375, 374, 353}, //178817871782
	{354, 355, 376}, //178317841789
	{376, 375, 354}, //178917881783
	{355, 356, 377}, //366367377
	{377, 376, 355}, //377376366
	{356, 357, 378}, //367369378
	{378, 377, 356}, //378377367
	{357, 364, 385}, //369370383
	{385, 378, 357}, //383378369
	{364, 371, 392}, //3723801828
	{392, 385, 364}, //1828382372
	{371, 370, 391}, //3803791827
	{391, 392, 371}, //18271828380
	{370, 369, 390}, //3793751826
	{390, 391, 370}, //18261827379
	{369, 368, 389}, //3753741825
	{389, 390, 369}, //18251826375
	{368, 367, 388}, //3743731824
	{388, 389, 368}, //18241825374
	{367, 366, 387}, //186218611866
	{387, 388, 367}, //186618671862
	{366, 365, 386}, //186118601865
	{386, 387, 366}, //186518661861
	{365, 358, 379}, //18603711864
	{379, 386, 365}, //186418651860
	{358, 351, 372}, //3713681863
	{372, 379, 358}, //18631864371
	{393, 400, 401}, //4434471847
	{401, 394, 393}, //1847444443
	{394, 401, 402}, //44418471848
	{402, 395, 394}, //1848445444
	{395, 402, 403}, //44518481849
	{403, 396, 395}, //1849446445
	{396, 403, 404}, //4294362142
	{404, 397, 396}, //2142435429
	{397, 404, 405}, //43521422143
	{405, 398, 397}, //2084434428
	{398, 405, 406}, //43420842085
	{406, 399, 398}, //20542053427
	{400, 407, 408}, //44718511852
	{408, 401, 400}, //18521847447
	{401, 408, 409}, //184718521853
	{409, 402, 401}, //185318481847
	{402, 409, 410}, //184818531854
	{410, 403, 402}, //185418491848
	{403, 410, 411}, //184918541855
	{411, 404, 403}, //185518501849
	{404, 411, 412}, //166516681669
	{412, 405, 404}, //166916661665
	{405, 412, 413}, //166616691670
	{413, 406, 405}, //167016671666
	{414, 415, 422}, //4414421838
	{422, 421, 414}, //18381837441
	{415, 416, 423}, //44218351839
	{423, 422, 415}, //18391838442
	{416, 417, 424}, //183518361840
	{424, 423, 416}, //184018391835
	{417, 418, 425}, //430431438
	{425, 424, 417}, //438437430
	{418, 419, 426}, //42618171819
	{426, 425, 418}, //439438431
	{419, 420, 427}, //432433440
	{427, 426, 419}, //182018191817
	{421, 422, 429}, //183718381843
	{429, 428, 421}, //184318421837
	{422, 423, 430}, //183818391844
	{430, 429, 422}, //184418431838
	{423, 424, 431}, //183918401845
	{431, 430, 423}, //184518441839
	{424, 425, 432}, //184018411846
	{432, 431, 424}, //184618451840
	{425, 426, 433}, //171417151718
	{433, 432, 425}, //171817171714
	{426, 427, 434}, //171517161719
	{434, 433, 426}, //171917181715
	{393, 394, 415}, //4134141875
	{415, 414, 393}, //18751874413
	{394, 395, 416}, //415416424
	{416, 415, 394}, //424423415
	{395, 396, 417}, //416417425
	{417, 416, 395}, //425424416
	{396, 397, 418}, //417418426
	{418, 417, 396}, //426425417
	{397, 398, 419}, //4184191817
	{419, 418, 397}, //1817426418
	{398, 399, 420}, //4194221818
	{420, 419, 398}, //18181817419
	{399, 406, 427}, //4074102120
	{427, 420, 399}, //21202119407
	{406, 413, 434}, //408409412
	{434, 427, 406}, //412411408
	{413, 412, 433}, //170617051712
	{433, 434, 413}, //171217131706
	{412, 411, 432}, //170517041711
	{432, 433, 412}, //171117121705
	{411, 410, 431}, //170417031710
	{431, 432, 411}, //171017111704
	{410, 409, 430}, //170317021709
	{430, 431, 410}, //170917101703
	{409, 408, 429}, //170217011708
	{429, 430, 409}, //170817091702
	{408, 407, 428}, //170117001707
	{428, 429, 408}, //170717081701
	{407, 400, 421}, //4214201876
	{421, 428, 407}, //18761877421
	{400, 393, 414}, //4204131874
	{414, 421, 400}, //18741876420
	{435, 442, 443}, //471485486
	{443, 436, 435}, //486477471
	{436, 443, 444}, //4774861807
	{444, 437, 436}, //1807478477
	{437, 444, 445}, //47818071808
	{445, 438, 437}, //1808479478
	{438, 445, 446}, //47918081809
	{446, 439, 438}, //1809484479
	{439, 446, 447}, //48418091810
	{447, 440, 439}, //2144470469
	{440, 447, 448}, //198319841985
	{448, 441, 440}, //2115475468
	{442, 449, 450}, //48518111812
	{450, 443, 442}, //1812486485
	{443, 450, 451}, //48618121813
	{451, 444, 443}, //18131807486
	{444, 451, 452}, //180718131814
	{452, 445, 444}, //181418081807
	{445, 452, 453}, //180818141815
	{453, 446, 445}, //181518091808
	{446, 453, 454}, //180918151816
	{454, 447, 446}, //181618101809
	{447, 454, 455}, //476482483
	{455, 448, 447}, //198619851984
	{456, 457, 464}, //179017911796
	{464, 463, 456}, //179617951790
	{457, 458, 465}, //179117921797
	{465, 464, 457}, //179717961791
	{458, 459, 466}, //179217931798
	{466, 465, 458}, //179817971792
	{459, 460, 467}, //179317941799
	{467, 466, 459}, //179917981793
	{460, 461, 468}, //4724732145
	{468, 467, 460}, //180017991794
	{461, 462, 469}, //4744812114
	{469, 468, 461}, //198119801979
	{463, 464, 471}, //179517961802
	{471, 470, 463}, //180218011795
	{464, 465, 472}, //179617971803
	{472, 471, 464}, //180318021796
	{465, 466, 473}, //179717981804
	{473, 472, 465}, //180418031797
	{466, 467, 474}, //179817991805
	{474, 473, 466}, //180518041798
	{467, 468, 475}, //179918001806
	{475, 474, 467}, //180618051799
	{468, 469, 476}, //198019811982
	{476, 475, 468}, //488487480
	{435, 436, 457}, //454455463
	{457, 456, 435}, //463462454
	{436, 437, 458}, //455456464
	{458, 457, 436}, //464463455
	{437, 438, 459}, //456457465
	{459, 458, 437}, //465464456
	{438, 439, 460}, //4574581698
	{460, 459, 438}, //1698465457
	{439, 440, 461}, //4584611699
	{461, 460, 439}, //16991698458
	{440, 441, 462}, //459460467
	{462, 461, 440}, //21092108466
	{441, 448, 469}, //448449452
	{469, 462, 441}, //452451448
	{448, 455, 476}, //153115371544
	{476, 469, 448}, //154415381531
	{455, 454, 475}, //153715361543
	{475, 476, 455}, //154315441537
	{454, 453, 474}, //153615351542
	{474, 475, 454}, //154215431536
	{453, 452, 473}, //153515341541
	{473, 474, 453}, //154115421535
	{452, 451, 472}, //153415331540
	{472, 473, 452}, //154015411534
	{451, 450, 471}, //153315321539
	{471, 472, 451}, //153915401533
	{450, 449, 470}, //194719461950
	{470, 471, 450}, //195019511947
	{449, 442, 463}, //19464531949
	{463, 470, 449}, //194919501946
	{442, 435, 456}, //4534501948
	{456, 463, 442}, //19481949453
	{477, 484, 485}, //51217461747
	{485, 478, 477}, //1747519512
	{478, 485, 486}, //51917471748
	{486, 479, 478}, //1748525519
	{479, 486, 487}, //52517481749
	{487, 480, 479}, //1749526525
	{480, 487, 488}, //52617491750
	{488, 481, 480}, //17501745526
	{481, 488, 489}, //5115182011
	{489, 482, 481}, //2011517511
	{482, 489, 490}, //51720112012
	{490, 483, 482}, //516510509
	{484, 491, 492}, //174617511752
	{492, 485, 484}, //175217471746
	{485, 492, 493}, //174717521753
	{493, 486, 485}, //175317481747
	{486, 493, 494}, //174817531754
	{494, 487, 486}, //175417491748
	{487, 494, 495}, //174917541755
	{495, 488, 487}, //175517501749
	{488, 495, 496}, //164516481649
	{496, 489, 488}, //164916461645
	{489, 496, 497}, //164616491650
	{497, 490, 489}, //165016471646
	{498, 499, 506}, //5235241736
	{506, 505, 498}, //17361735523
	{499, 500, 507}, //52417321737
	{507, 506, 499}, //17371736524
	{500, 501, 508}, //173217331738
	{508, 507, 500}, //173817371732
	{501, 502, 509}, //173317341739
	{509, 508, 501}, //173917381733
	{502, 503, 510}, //5085131944
	{510, 509, 502}, //1944521508
	{503, 504, 511}, //514515522
	{511, 510, 503}, //19451944513
	{505, 506, 513}, //173517361741
	{513, 512, 505}, //174117401735
	{506, 507, 514}, //173617371742
	{514, 513, 506}, //174217411736
	{507, 508, 515}, //173717381743
	{515, 514, 507}, //174317421737
	{508, 509, 516}, //173817391744
	{516, 515, 508}, //174417431738
	{509, 510, 517}, //5275281822
	{517, 516, 509}, //18221821527
	{510, 511, 518}, //5285291823
	{518, 517, 510}, //18231822528
	{477, 478, 499}, //190019011905
	{499, 498, 477}, //190519041900
	{478, 479, 500}, //497498506
	{500, 499, 478}, //506505497
	{479, 480, 501}, //498499507
	{501, 500, 479}, //507506498
	{480, 481, 502}, //499500508
	{502, 501, 480}, //508507499
	{481, 482, 503}, //500501513
	{503, 502, 481}, //513508500
	{482, 483, 504}, //501504520
	{504, 503, 482}, //520513501
	{483, 490, 511}, //489490493
	{511, 504, 483}, //493492489
	{490, 497, 518}, //490491494
	{518, 511, 490}, //494493490
	{497, 496, 517}, //20984962099
	{517, 518, 497}, //502503495
	{496, 495, 516}, //172517241730
	{516, 517, 496}, //173017311725
	{495, 494, 515}, //172417231729
	{515, 516, 495}, //172917301724
	{494, 493, 514}, //172317221728
	{514, 515, 494}, //172817291723
	{493, 492, 513}, //172217211727
	{513, 514, 493}, //172717281722
	{492, 491, 512}, //172117201726
	{512, 513, 492}, //172617271721
	{491, 484, 505}, //190319021906
	{505, 512, 491}, //190619071903
	{484, 477, 498}, //190219001904
	{498, 505, 484}, //190419061902
	{519, 526, 527}, //552566567
	{527, 520, 519}, //567553552
	{520, 527, 528}, //553567568
	{528, 521, 520}, //568554553
	{521, 528, 529}, //5545681969
	{529, 522, 521}, //1969559554
	{522, 529, 530}, //55919691970
	{530, 523, 522}, //1970560559
	{523, 530, 531}, //56019701971
	{531, 524, 523}, //1971561560
	{524, 531, 532}, //56420432044
	{532, 525, 524}, //2113551550
	{526, 533, 534}, //188118821883
	{534, 527, 526}, //21472146563
	{527, 534, 535}, //56719721973
	{535, 528, 527}, //1973568567
	{528, 535, 536}, //56819731974
	{536, 529, 528}, //19741969568
	{529, 536, 537}, //196919741975
	{537, 530, 529}, //197519701969
	{530, 537, 538}, //197019751976
	{538, 531, 530}, //197619711970
	{531, 538, 539}, //204320452046
	{539, 532, 531}, //204620442043
	{540, 541, 548}, //195219531959
	{548, 547, 540}, //195919581952
	{541, 542, 549}, //195319541960
	{549, 548, 541}, //196019591953
	{542, 543, 550}, //195419551961
	{550, 549, 542}, //196119601954
	{543, 544, 551}, //195519561962
	{551, 550, 543}, //196219611955
	{544, 545, 552}, //195619571963
	{552, 551, 544}, //196319621956
	{545, 546, 553}, //5555562112
	{553, 552, 545}, //1993385384
	{547, 548, 555}, //557558565
	{555, 554, 547}, //188018791878
	{548, 549, 556}, //195919601965
	{556, 555, 548}, //196519641959
	{549, 550, 557}, //196019611966
	{557, 556, 549}, //196619651960
	{550, 551, 558}, //196119621967
	{558, 557, 550}, //196719661961
	{551, 552, 559}, //196219631968
	{559, 558, 551}, //196819671962
	{552, 553, 560}, //38519931994
	{560, 559, 552}, //570569562
	{519, 520, 541}, //536537544
	{541, 540, 519}, //544543536
	{520, 521, 542}, //537538545
	{542, 541, 520}, //545544537
	{521, 522, 543}, //538539546
	{543, 542, 521}, //546545538
	{522, 523, 544}, //539540547
	{544, 543, 522}, //547546539
	{523, 524, 545}, //540541548
	{545, 544, 523}, //548547540
	{524, 525, 546}, //541542549
	{546, 545, 524}, //549548541
	{525, 532, 553}, //5305332149
	{553, 546, 525}, //21492148530
	{532, 539, 560}, //531532535
	{560, 553, 532}, //535534531
	{539, 538, 559}, //156515641571
	{559, 560, 539}, //157115721565
	{538, 537, 558}, //156415631570
	{558, 559, 538}, //157015711564
	{537, 536, 557}, //156315621569
	{557, 558, 537}, //156915701563
	{536, 535, 556}, //156215611568
	{556, 557, 536}, //156815691562
	{535, 534, 555}, //156115601567
	{555, 556, 535}, //156715681561
	{534, 533, 554}, //156015591566
	{554, 555, 534}, //156615671560
	{533, 526, 547}, //193319321935
	{547, 554, 533}, //193519361933
	{526, 519, 540}, //193219311934
	{540, 547, 526}, //193419351932
	{561, 568, 569}, //59416881689
	{569, 562, 561}, //1689601594
	{562, 569, 570}, //60116891690
	{570, 563, 562}, //1690608601
	{563, 570, 571}, //60816901691
	{571, 564, 563}, //16911686608
	{564, 571, 572}, //168616911692
	{572, 565, 564}, //169216871686
	{565, 572, 573}, //59318571858
	{573, 566, 565}, //18581856593
	{566, 573, 574}, //185618581859
	{574, 567, 566}, //598592591
	{568, 575, 576}, //168816931694
	{576, 569, 568}, //169416891688
	{569, 576, 577}, //168916941695
	{577, 570, 569}, //169516901689
	{570, 577, 578}, //169016951696
	{578, 571, 570}, //169616911690
	{571, 578, 579}, //169116961697
	{579, 572, 571}, //169716921691
	{572, 579, 580}, //599606607
	{580, 573, 572}, //607600599
	{573, 580, 581}, //6006071911
	{581, 574, 573}, //1911605600
	{582, 583, 590}, //167116721677
	{590, 589, 582}, //167716761671
	{583, 584, 591}, //167216731678
	{591, 590, 583}, //167816771672
	{584, 585, 592}, //167316741679
	{592, 591, 584}, //167916781673
	{585, 586, 593}, //167416751680
	{593, 592, 585}, //168016791674
	{586, 587, 594}, //583588595
	{594, 593, 586}, //595590583
	{587, 588, 595}, //596597604
	{595, 594, 587}, //1887595588
	{589, 590, 597}, //167616771682
	{597, 596, 589}, //168216811676
	{590, 591, 598}, //167716781683
	{598, 597, 590}, //168316821677
	{591, 592, 599}, //167816791684
	{599, 598, 591}, //168416831678
	{592, 593, 600}, //167916801685
	{600, 599, 592}, //168516841679
	{593, 594, 601}, //584585603
	{601, 600, 593}, //603602584
	{594, 595, 602}, //585586609
	{602, 601, 594}, //609603585
	{561, 562, 583}, //165516561661
	{583, 582, 561}, //166116601655
	{562, 563, 584}, //165616571662
	{584, 583, 562}, //166216611656
	{563, 564, 585}, //165716581663
	{585, 584, 563}, //166316621657
	{564, 565, 586}, //165816591664
	{586, 585, 564}, //166416631658
	{565, 566, 587}, //571574588
	{587, 586, 565}, //588583571
	{566, 567, 588}, //574581589
	{588, 587, 566}, //589588574
	{567, 574, 595}, //5815821887
	{595, 588, 567}, //1887589581
	{574, 581, 602}, //572573576
	{602, 595, 574}, //576575572
	{581, 580, 601}, //580579603
	{601, 602, 581}, //603609580
	{580, 579, 600}, //579578602
	{600, 601, 580}, //602603579
	{579, 578, 599}, //578577587
	{599, 600, 579}, //587602578
	{578, 577, 598}, //176117601766
	{598, 599, 578}, //176617671761
	{577, 576, 597}, //176017591765
	{597, 598, 577}, //176517661760
	{576, 575, 596}, //175917581764
	{596, 597, 576}, //176417651759
	{575, 568, 589}, //175817571763
	{589, 596, 575}, //176317641758
	{568, 561, 582}, //175717561762
	{582, 589, 568}, //176217631757
	{603, 610, 611}, //208820902091
	{611, 604, 603}, //209120892088
	{604, 611, 612}, //202820332034
	{612, 605, 604}, //203420292028
	{605, 612, 613}, //202920342035
	{613, 606, 605}, //203520302029
	{606, 613, 614}, //203020352036
	{614, 607, 606}, //203620312030
	{607, 614, 615}, //203120362037
	{615, 608, 607}, //203720322031
	{608, 615, 616}, //63321502151
	{616, 609, 608}, //20812080632
	{610, 617, 618}, //199019911992
	{618, 611, 610}, //21532152651
	{611, 618, 619}, //203320382039
	{619, 612, 611}, //203920342033
	{612, 619, 620}, //203420392040
	{620, 613, 612}, //204020352034
	{613, 620, 621}, //203520402041
	{621, 614, 613}, //204120362035
	{614, 621, 622}, //203620412042
	{622, 615, 614}, //204220372036
	{615, 622, 623}, //64620512052
	{623, 616, 615}, //20522050646
	{624, 625, 632}, //199719982000
	{632, 631, 624}, //200019991997
	{625, 626, 633}, //634635648
	{633, 632, 625}, //648643634
	{626, 627, 634}, //635636649
	{634, 633, 626}, //649648635
	{627, 628, 635}, //636641650
	{635, 634, 627}, //650649636
	{628, 629, 636}, //6416422055
	{636, 635, 628}, //2055650641
	{629, 630, 637}, //63820922093
	{637, 636, 629}, //645644637
	{631, 632, 639}, //639640647
	{639, 638, 631}, //198919881987
	{632, 633, 640}, //6436482057
	{640, 639, 632}, //20572056643
	{633, 634, 641}, //6486492058
	{641, 640, 633}, //20582057648
	{634, 635, 642}, //6496502059
	{642, 641, 634}, //20592058649
	{635, 636, 643}, //65020552060
	{643, 642, 635}, //20602059650
	{636, 637, 644}, //617618625
	{644, 643, 636}, //625619617
	{603, 604, 625}, //6126151998
	{625, 624, 603}, //19981997612
	{604, 605, 626}, //620621630
	{626, 625, 604}, //630629620
	{605, 606, 627}, //621622631
	{627, 626, 605}, //631630621
	{606, 607, 628}, //6226231651
	{628, 627, 606}, //1651631622
	{607, 608, 629}, //6236241652
	{629, 628, 607}, //16521651623
	{608, 609, 630}, //6246271653
	{630, 629, 608}, //16531652624
	{609, 616, 637}, //6276281654
	{637, 630, 609}, //16541653627
	{616, 623, 644}, //613616625
	{644, 637, 616}, //625618613
	{623, 622, 643}, //616614619
	{643, 644, 623}, //619625616
	{622, 621, 642}, //160516041610
	{642, 643, 622}, //161016111605
	{621, 620, 641}, //160416031609
	{641, 642, 621}, //160916101604
	{620, 619, 640}, //160316021608
	{640, 641, 620}, //160816091603
	{619, 618, 639}, //160216011607
	{639, 640, 619}, //160716081602
	{618, 617, 638}, //160116001606
	{638, 639, 618}, //160616071601
	{617, 610, 631}, //199619951999
	{631, 638, 617}, //199920011996
	{610, 603, 624}, //19956121997
	{624, 631, 610}, //199719991995
	{645, 652, 653}, //679685686
	{653, 646, 645}, //206920682067
	{646, 653, 654}, //675684689
	{654, 647, 646}, //689676675
	{647, 654, 655}, //676689690
	{655, 648, 647}, //690677676
	{648, 655, 656}, //677690691
	{656, 649, 648}, //691682677
	{649, 656, 657}, //6826912061
	{657, 650, 649}, //2061683682
	{650, 657, 658}, //207220732074
	{658, 651, 650}, //20952094674
	{652, 659, 660}, //69320032004
	{660, 653, 652}, //21112110692
	{653, 660, 661}, //68420622063
	{661, 654, 653}, //2063689684
	{654, 661, 662}, //68920632064
	{662, 655, 654}, //2064690689
	{655, 662, 663}, //69020642065
	{663, 656, 655}, //2065691690
	{656, 663, 664}, //69120652066
	{664, 657, 656}, //20662061691
	{657, 664, 665}, //68720092010
	{665, 658, 657}, //20102008687
	{666, 667, 674}, //193919401942
	{674, 673, 666}, //681680673
	{667, 668, 675}, //201320142019
	{675, 674, 667}, //201920182013
	{668, 669, 676}, //201420152020
	{676, 675, 668}, //202020192014
	{669, 670, 677}, //201520162021
	{677, 676, 669}, //202120202015
	{670, 671, 678}, //201620172022
	{678, 677, 670}, //202220212016
	{671, 672, 679}, //207720782079
	{679, 678, 671}, //21012100678
	{673, 674, 681}, //68820862087
	{681, 680, 673}, //2002652626
	{674, 675, 682}, //201820192024
	{682, 681, 674}, //202420232018
	{675, 676, 683}, //201920202025
	{683, 682, 675}, //202520242019
	{676, 677, 684}, //202020212026
	{684, 683, 676}, //202620252020
	{677, 678, 685}, //202120222027
	{685, 684, 677}, //202720262021
	{678, 679, 686}, //659660667
	{686, 685, 678}, //667666659
	{645, 646, 667}, //6536561940
	{667, 666, 645}, //19401939653
	{646, 647, 668}, //6626631829
	{668, 667, 646}, //1829672662
	{647, 648, 669}, //6636641830
	{669, 668, 647}, //18301829663
	{648, 649, 670}, //6646651831
	{670, 669, 648}, //18311830664
	{649, 650, 671}, //6656691832
	{671, 670, 649}, //18321831665
	{650, 651, 672}, //6696701833
	{672, 671, 650}, //18331832669
	{651, 658, 679}, //6706711834
	{679, 672, 651}, //18341833670
	{658, 665, 686}, //654658667
	{686, 679, 658}, //667660654
	{665, 664, 685}, //658657666
	{685, 686, 665}, //666667658
	{664, 663, 684}, //657655661
	{684, 685, 664}, //661666657
	{663, 662, 683}, //177417731778
	{683, 684, 663}, //177817791774
	{662, 661, 682}, //177317721777
	{682, 683, 662}, //177717781773
	{661, 660, 681}, //177217711776
	{681, 682, 661}, //177617771772
	{660, 659, 680}, //177117701775
	{680, 681, 660}, //177517761771
	{659, 652, 673}, //193819371941
	{673, 680, 659}, //194119431938
	{652, 645, 666}, //19376531939
	{666, 673, 652}, //193919411937
	{687, 689, 690}, //702704705
	{690, 688, 687}, //705703702
	{691, 692, 694}, //217321742176
	{694, 693, 691}, //217621752173
	{687, 688, 692}, //698699701
	{692, 691, 687}, //701700698
	{688, 690, 694}, //249524962498
	{694, 692, 688}, //249824972495
	{690, 689, 693}, //247924782480
	{693, 694, 690}, //248024812479
	{689, 687, 691}, //695694696
	{691, 693, 689}, //696697695
	{695, 696, 697}, //706715716
	{695, 697, 698}, //706716717
	{695, 698, 699}, //706717727
	{695, 699, 700}, //706727728
	{695, 700, 701}, //706728729
	{695, 701, 702}, //7067292352
	{695, 702, 703}, //70623522353
	{695, 703, 704}, //70623532354
	{695, 704, 705}, //70623542355
	{695, 705, 706}, //70623552356
	{695, 706, 707}, //70623562357
	{695, 707, 696}, //7062357715
	{696, 708, 709}, //707720721
	{696, 709, 697}, //707721708
	{697, 709, 710}, //708721730
	{697, 710, 698}, //708730709
	{698, 710, 711}, //7097302507
	{698, 711, 699}, //7092507718
	{699, 711, 712}, //710722723
	{699, 712, 700}, //710723711
	{700, 712, 713}, //735748749
	{700, 713, 701}, //735749736
	{701, 713, 714}, //712724725
	{701, 714, 702}, //712725713
	{702, 714, 715}, //713725726
	{702, 715, 703}, //713726714
	{703, 715, 716}, //235323582359
	{703, 716, 704}, //235323592354
	{704, 716, 717}, //235423592360
	{704, 717, 705}, //235423602355
	{705, 717, 718}, //235523602361
	{705, 718, 706}, //235523612356
	{706, 718, 719}, //7407542169
	{706, 719, 707}, //7402169741
	{707, 719, 708}, //7192508720
	{707, 708, 696}, //719720707
	{708, 720, 721}, //7317452154
	{708, 721, 709}, //7312154732
	{709, 721, 722}, //73221542155
	{709, 722, 710}, //7322155744
	{710, 722, 723}, //733746747
	{710, 723, 711}, //73424772476
	{711, 723, 724}, //73721622163
	{711, 724, 712}, //7372163748
	{712, 724, 725}, //74821632164
	{712, 725, 713}, //7482164749
	{713, 725, 726}, //74921642165
	{713, 726, 714}, //7492165750
	{714, 726, 727}, //7387642156
	{714, 727, 715}, //7382156739
	{715, 727, 728}, //73921562157
	{715, 728, 716}, //7392157751
	{716, 728, 729}, //75121572158
	{716, 729, 717}, //7512158752
	{717, 729, 730}, //75321702171
	{717, 730, 718}, //7532171754
	{718, 730, 731}, //75421712172
	{718, 731, 719}, //75421722169
	{719, 731, 720}, //742756755
	{719, 720, 708}, //24842485743
	{720, 732, 733}, //757773776
	{720, 733, 721}, //757776758
	{721, 733, 734}, //758776779
	{721, 734, 722}, //758779767
	{722, 734, 735}, //7597722509
	{722, 735, 723}, //7592509760
	{723, 735, 736}, //216221662167
	{723, 736, 724}, //216221672163
	{724, 736, 737}, //216321672168
	{724, 737, 725}, //7612510771
	{725, 737, 738}, //762774775
	{725, 738, 726}, //762775763
	{726, 738, 739}, //76421592160
	{726, 739, 727}, //76421602156
	{727, 739, 740}, //215621602161
	{727, 740, 728}, //215621612157
	{728, 740, 741}, //765777778
	{728, 741, 729}, //765778766
	{729, 741, 742}, //76823662367
	{729, 742, 730}, //7682367769
	{730, 742, 743}, //76923672368
	{730, 743, 731}, //7692368770
	{731, 743, 732}, //7702368773
	{731, 732, 720}, //770773757
	{732, 744, 733}, //7732369776
	{733, 744, 734}, //7762369779
	{734, 744, 735}, //7792369780
	{735, 744, 736}, //7802369781
	{736, 744, 737}, //78123692362
	{737, 744, 738}, //236223692363
	{738, 744, 739}, //236323692364
	{739, 744, 740}, //236423692365
	{740, 744, 741}, //236523692366
	{741, 744, 742}, //236623692367
	{742, 744, 743}, //236723692368
	{743, 744, 732}, //23682369773
	{745, 746, 747}, //782786787
	{745, 747, 748}, //782787799
	{745, 748, 749}, //7827992315
	{745, 749, 750}, //78223152316
	{745, 750, 751}, //78223162317
	{745, 751, 752}, //78223172318
	{745, 752, 753}, //78223182319
	{745, 753, 754}, //78223192320
	{745, 754, 755}, //78223202321
	{745, 755, 756}, //78223212322
	{745, 756, 757}, //78223222323
	{745, 757, 746}, //7822323786
	{746, 758, 759}, //784808809
	{746, 759, 747}, //784809796
	{747, 759, 760}, //796809820
	{747, 760, 748}, //796820807
	{748, 760, 761}, //785797798
	{748, 761, 749}, //79923242315
	{749, 761, 762}, //231523242325
	{749, 762, 750}, //231523252316
	{750, 762, 763}, //231623252326
	{750, 763, 751}, //231623262317
	{751, 763, 764}, //7888012511
	{751, 764, 752}, //7882511789
	{752, 764, 765}, //802814815
	{752, 765, 753}, //802815812
	{753, 765, 766}, //812815826
	{753, 766, 754}, //7902512800
	{754, 766, 767}, //791803804
	{754, 767, 755}, //791804792
	{755, 767, 768}, //793819829
	{755, 768, 756}, //793829805
	{756, 768, 769}, //805829830
	{756, 769, 757}, //805830816
	{757, 769, 758}, //794806795
	{757, 758, 746}, //794795783
	{758, 770, 771}, //8088222433
	{758, 771, 759}, //8082433809
	{759, 771, 772}, //80924332434
	{759, 772, 760}, //8092434820
	{760, 772, 773}, //82024342435
	{760, 773, 761}, //8202435821
	{761, 773, 774}, //810824825
	{761, 774, 762}, //810825811
	{762, 774, 775}, //811825837
	{762, 775, 763}, //811837823
	{763, 775, 776}, //823837849
	{763, 776, 764}, //813827814
	{764, 776, 777}, //814827828
	{764, 777, 765}, //814828815
	{765, 777, 778}, //8158282456
	{765, 778, 766}, //8152456826
	{766, 778, 779}, //8188322414
	{766, 779, 767}, //8182414819
	{767, 779, 780}, //81924142415
	{767, 780, 768}, //8192415829
	{768, 780, 781}, //82924152416
	{768, 781, 769}, //8292416830
	{769, 781, 770}, //8302416831
	{769, 770, 758}, //830831817
	{770, 782, 783}, //833853854
	{770, 783, 771}, //833854839
	{771, 783, 784}, //834846847
	{771, 784, 772}, //834847835
	{772, 784, 785}, //835847848
	{772, 785, 773}, //835848836
	{773, 785, 786}, //82424382439
	{773, 786, 774}, //8242439825
	{774, 786, 787}, //82524392440
	{774, 787, 775}, //8252440837
	{775, 787, 788}, //838850851
	{775, 788, 776}, //8402328841
	{776, 788, 789}, //84123282329
	{776, 789, 777}, //8412329842
	{777, 789, 790}, //84223292330
	{777, 790, 778}, //8422330843
	{778, 790, 791}, //84323302331
	{778, 791, 779}, //8432331844
	{779, 791, 792}, //84423312332
	{779, 792, 780}, //8442332845
	{780, 792, 793}, //84523322333
	{780, 793, 781}, //8452333852
	{781, 793, 782}, //8522333853
	{781, 782, 770}, //852853833
	{782, 794, 783}, //8532334854
	{783, 794, 784}, //8542334855
	{784, 794, 785}, //8552334856
	{785, 794, 786}, //8562334857
	{786, 794, 787}, //85723342327
	{787, 794, 788}, //232723342328
	{788, 794, 789}, //232823342329
	{789, 794, 790}, //232923342330
	{790, 794, 791}, //233023342331
	{791, 794, 792}, //233123342332
	{792, 794, 793}, //233223342333
	{793, 794, 782}, //23332334853
	{795, 796, 797}, //858860861
	{795, 797, 798}, //858861862
	{795, 798, 799}, //858862863
	{795, 799, 800}, //858863872
	{795, 800, 801}, //858872873
	{795, 801, 802}, //858873874
	{795, 802, 803}, //858874875
	{795, 803, 804}, //858875880
	{795, 804, 805}, //8588802381
	{795, 805, 806}, //85823812382
	{795, 806, 807}, //85823822383
	{795, 807, 796}, //8582383860
	{796, 808, 809}, //883885895
	{796, 809, 797}, //883895884
	{797, 809, 810}, //86123842385
	{797, 810, 798}, //8612385862
	{798, 810, 811}, //86223852386
	{798, 811, 799}, //8622386863
	{799, 811, 812}, //86323862387
	{799, 812, 800}, //8632387872
	{800, 812, 813}, //87223872388
	{800, 813, 801}, //8722388873
	{801, 813, 814}, //864876877
	{801, 814, 802}, //864877865
	{802, 814, 815}, //865877878
	{802, 815, 803}, //865878866
	{803, 815, 816}, //866878879
	{803, 816, 804}, //866879867
	{804, 816, 817}, //88023892390
	{804, 817, 805}, //88023902381
	{805, 817, 818}, //238123902391
	{805, 818, 806}, //868881869
	{806, 818, 819}, //891905906
	{806, 819, 807}, //891906892
	{807, 819, 808}, //870882871
	{807, 808, 796}, //870871859
	{808, 820, 821}, //885898899
	{808, 821, 809}, //885899895
	{809, 821, 822}, //8958992300
	{809, 822, 810}, //8952300896
	{810, 822, 823}, //89623002301
	{810, 823, 811}, //886901887
	{811, 823, 824}, //887901902
	{811, 824, 812}, //887902888
	{812, 824, 825}, //888902913
	{812, 825, 813}, //888913900
	{813, 825, 826}, //9009132188
	{813, 826, 814}, //889916890
	{814, 826, 827}, //8909162182
	{814, 827, 815}, //8902182903
	{815, 827, 828}, //90321822183
	{815, 828, 816}, //9032183904
	{816, 828, 829}, //90421832184
	{816, 829, 817}, //893908894
	{817, 829, 830}, //8949082313
	{817, 830, 818}, //8942313905
	{818, 830, 831}, //90523132314
	{818, 831, 819}, //9052314906
	{819, 831, 820}, //9062314907
	{819, 820, 808}, //897898885
	{820, 832, 833}, //909921922
	{820, 833, 821}, //909922910
	{821, 833, 834}, //91123922393
	{821, 834, 822}, //89923022300
	{822, 834, 835}, //91723932394
	{822, 835, 823}, //9172394923
	{823, 835, 836}, //912925926
	{823, 836, 824}, //9012189902
	{824, 836, 837}, //90221892190
	{824, 837, 825}, //9022190913
	{825, 837, 838}, //92425132514
	{825, 838, 826}, //914927915
	{826, 838, 839}, //91621852186
	{826, 839, 827}, //91621862182
	{827, 839, 840}, //218221862187
	{827, 840, 828}, //218221872183
	{828, 840, 841}, //92823992400
	{828, 841, 829}, //9282400929
	{829, 841, 842}, //918930931
	{829, 842, 830}, //250425062505
	{830, 842, 843}, //919931932
	{830, 843, 831}, //919932920
	{831, 843, 832}, //920932921
	{831, 832, 820}, //920921909
	{832, 844, 833}, //93324032392
	{833, 844, 834}, //239224032393
	{834, 844, 835}, //239324032394
	{835, 844, 836}, //239424032395
	{836, 844, 837}, //239524032396
	{837, 844, 838}, //239624032397
	{838, 844, 839}, //239724032398
	{839, 844, 840}, //239824032399
	{840, 844, 841}, //239924032400
	{841, 844, 842}, //240024032401
	{842, 844, 843}, //240124032402
	{843, 844, 832}, //24022403933
	{845, 846, 847}, //934936939
	{845, 847, 848}, //934939940
	{845, 848, 849}, //934940941
	{845, 849, 850}, //934941942
	{845, 850, 851}, //934942943
	{845, 851, 852}, //934943944
	{845, 852, 853}, //934944951
	{845, 853, 854}, //934951952
	{845, 854, 855}, //934952953
	{845, 855, 856}, //934953954
	{845, 856, 857}, //934954955
	{845, 857, 846}, //934955936
	{846, 858, 859}, //948971972
	{846, 859, 847}, //948972959
	{847, 859, 860}, //959972973
	{847, 860, 848}, //959973960
	{848, 860, 861}, //937949950
	{848, 861, 849}, //937950938
	{849, 861, 862}, //96324062407
	{849, 862, 850}, //9632407976
	{850, 862, 863}, //942956957
	{850, 863, 851}, //942957943
	{851, 863, 864}, //9439572441
	{851, 864, 852}, //9432441944
	{852, 864, 865}, //94424412442
	{852, 865, 853}, //9442442951
	{853, 865, 866}, //95124422443
	{853, 866, 854}, //9512443952
	{854, 866, 867}, //95224432444
	{854, 867, 855}, //9522444953
	{855, 867, 868}, //95324442445
	{855, 868, 856}, //9532445954
	{856, 868, 869}, //95424452446
	{856, 869, 857}, //945958946
	{857, 869, 858}, //946958947
	{857, 858, 846}, //946947935
	{858, 870, 871}, //9719862217
	{858, 871, 859}, //9712217972
	{859, 871, 872}, //97222172218
	{859, 872, 860}, //9722218973
	{860, 872, 873}, //949961962
	{860, 873, 861}, //949962950
	{861, 873, 874}, //240624092410
	{861, 874, 862}, //240624102407
	{862, 874, 875}, //240724102411
	{862, 875, 863}, //240724112408
	{863, 875, 876}, //964974975
	{863, 876, 864}, //964975965
	{864, 876, 877}, //96623042305
	{864, 877, 865}, //9662305979
	{865, 877, 878}, //97923052306
	{865, 878, 866}, //97923062303
	{866, 878, 879}, //967980981
	{866, 879, 867}, //967981968
	{867, 879, 880}, //968981982
	{867, 880, 868}, //968982969
	{868, 880, 881}, //969982983
	{868, 881, 869}, //969983970
	{869, 881, 870}, //9842219986
	{869, 870, 858}, //984986971
	{870, 882, 883}, //98622202221
	{870, 883, 871}, //98622212217
	{871, 883, 884}, //221722212222
	{871, 884, 872}, //221722222218
	{872, 884, 885}, //977987988
	{872, 885, 873}, //977988978
	{873, 885, 886}, //240924122413
	{873, 886, 874}, //240924132410
	{874, 886, 887}, //98910051009
	{874, 887, 875}, //9891009990
	{875, 887, 888}, //99010092426
	{875, 888, 876}, //9902426991
	{876, 888, 889}, //99124262427
	{876, 889, 877}, //9912427992
	{877, 889, 890}, //99224272428
	{877, 890, 878}, //9922428993
	{878, 890, 891}, //99324282429
	{878, 891, 879}, //9932429998
	{879, 891, 892}, //9819941006
	{879, 892, 880}, //9811006982
	{880, 892, 893}, //98210061007
	{880, 893, 881}, //995999996
	{881, 893, 882}, //996999997
	{881, 882, 870}, //996997985
	{882, 894, 883}, //100124321002
	{883, 894, 884}, //100224321003
	{884, 894, 885}, //100324321004
	{885, 894, 886}, //100424321005
	{886, 894, 887}, //100524321009
	{887, 894, 888}, //100924322426
	{888, 894, 889}, //242624322427
	{889, 894, 890}, //242724322428
	{890, 894, 891}, //242824322429
	{891, 894, 892}, //242924322430
	{892, 894, 893}, //243024322431
	{893, 894, 882}, //243124321001
	{895, 896, 897}, //101010121015
	{895, 897, 898}, //101010151019
	{895, 898, 899}, //101010191020
	{895, 899, 900}, //101010201021
	{895, 900, 901}, //101010211031
	{895, 901, 902}, //101010311032
	{895, 902, 903}, //101010321033
	{895, 903, 904}, //101010332417
	{895, 904, 905}, //101024172418
	{895, 905, 906}, //101024182419
	{895, 906, 907}, //101024192420
	{895, 907, 896}, //101024201012
	{896, 908, 909}, //102410481049
	{896, 909, 897}, //102410491035
	{897, 909, 910}, //103510491062
	{897, 910, 898}, //103510621036
	{898, 910, 911}, //100010131014
	{898, 911, 899}, //100010141008
	{899, 911, 912}, //102723072308
	{899, 912, 900}, //102723081039
	{900, 912, 913}, //103923082309
	{900, 913, 901}, //103923091052
	{901, 913, 914}, //101610281029
	{901, 914, 902}, //101610291017
	{902, 914, 915}, //250125022503
	{902, 915, 903}, //101710301018
	{903, 915, 916}, //103324212422
	{903, 916, 904}, //103324222417
	{904, 916, 917}, //241724222423
	{904, 917, 905}, //241724232418
	{905, 917, 918}, //241824232424
	{905, 918, 906}, //241824242419
	{906, 918, 919}, //241924242425
	{906, 919, 907}, //241924252420
	{907, 919, 908}, //102210341023
	{907, 908, 896}, //102210231011
	{908, 920, 921}, //104823352336
	{908, 921, 909}, //104823361049
	{909, 921, 922}, //104923362337
	{909, 922, 910}, //104923371062
	{910, 922, 923}, //101310251026
	{910, 923, 911}, //101310261014
	{911, 923, 924}, //230723102311
	{911, 924, 912}, //230723112308
	{912, 924, 925}, //230823112312
	{912, 925, 913}, //230823122309
	{913, 925, 926}, //102810371038
	{913, 926, 914}, //102810381029
	{914, 926, 927}, //104222712272
	{914, 927, 915}, //104222721055
	{915, 927, 928}, //105522722273
	{915, 928, 916}, //105522732270
	{916, 928, 929}, //104010411043
	{916, 929, 917}, //104424942493
	{917, 929, 930}, //104610601071
	{917, 930, 918}, //104610711047
	{918, 930, 931}, //104710712237
	{918, 931, 919}, //104722371058
	{919, 931, 920}, //105822371059
	{919, 920, 908}, //105810591045
	{920, 932, 933}, //233523382339
	{920, 933, 921}, //233523392336
	{921, 933, 934}, //233623392340
	{921, 934, 922}, //233623402337
	{922, 934, 935}, //105010531054
	{922, 935, 923}, //105010541051
	{923, 935, 936}, //106510801081
	{923, 936, 924}, //106510811066
	{924, 936, 937}, //106610811082
	{924, 937, 925}, //106610821067
	{925, 937, 938}, //106710821083
	{925, 938, 926}, //106710831068
	{926, 938, 939}, //106810831085
	{926, 939, 927}, //106810851069
	{927, 939, 940}, //106910852447
	{927, 940, 928}, //106924471070
	{928, 940, 941}, //107024472448
	{928, 941, 929}, //107024481074
	{929, 941, 942}, //106022382239
	{929, 942, 930}, //106022391071
	{930, 942, 943}, //107122392240
	{930, 943, 931}, //107122402237
	{931, 943, 932}, //105710631061
	{931, 932, 920}, //105710611056
	{932, 944, 933}, //107724511078
	{933, 944, 934}, //107824511079
	{934, 944, 935}, //107924511080
	{935, 944, 936}, //108024511081
	{936, 944, 937}, //108124511082
	{937, 944, 938}, //108224511083
	{938, 944, 939}, //108324511085
	{939, 944, 940}, //108524512447
	{940, 944, 941}, //244724512448
	{941, 944, 942}, //244824512449
	{942, 944, 943}, //244924512450
	{943, 944, 932}, //245024511077
	{945, 947, 946}, //108610881087
	{945, 948, 947}, //108610891088
	{945, 949, 948}, //108610901089
	{945, 950, 949}, //108610911090
	{945, 951, 950}, //108610941091
	{945, 952, 951}, //108610951094
	{945, 953, 952}, //108610961095
	{945, 954, 953}, //108610971096
	{945, 955, 954}, //108610981097
	{945, 956, 955}, //108610991098
	{945, 957, 956}, //108611001099
	{945, 946, 957}, //108610871100
	{946, 959, 958}, //108711021101
	{946, 947, 959}, //108710881102
	{947, 960, 959}, //108811031102
	{947, 948, 960}, //108810891103
	{948, 961, 960}, //108911061103
	{948, 949, 961}, //108910901106
	{949, 962, 961}, //109011071106
	{949, 950, 962}, //109010911107
	{950, 963, 962}, //111411411128
	{950, 951, 963}, //111411151141
	{951, 964, 963}, //106410751073
	{951, 952, 964}, //106410721075
	{952, 965, 964}, //109511091108
	{952, 953, 965}, //109510961109
	{953, 966, 965}, //109611101109
	{953, 954, 966}, //1096	1097	1110
	{954, 967, 966}, //	1097	2490	1110
	{954, 955, 967}, //	1097	1098	2490
	{955, 968, 967}, //	1098	2491	2490
	{955, 956, 968}, //	1098	1099	2491
	{956, 969, 968}, //	1099	2492	2491
	{956, 957, 969}, //	1099	1100	2492
	{957, 958, 969}, //	1100	1101	2492
	{957, 946, 958}, //	1100	1087	1101
	{958, 971, 970}, //	1111	1126	1125
	{958, 959, 971}, //	1111	1112	1126
	{959, 972, 971}, //	1112	1138	1126
	{959, 960, 972}, //	1112	1113	1138
	{960, 973, 972}, //	1113	2266	1138
	{960, 961, 973}, //	1113	1124	2266
	{961, 974, 973}, //	1127	2458	2457
	{961, 962, 974}, //	1127	1128	2458
	{962, 975, 974}, //	1128	2459	2458
	{962, 963, 975}, //	1128	1141	2459
	{963, 976, 975}, //	1073	1084	1076
	{963, 964, 976}, //	1073	1075	1084
	{964, 977, 976}, //	1118	1144	1132
	{964, 965, 977}, //	1118	1119	1144
	{965, 978, 977}, //	1119	1278	1144
	{965, 966, 978}, //	1119	1131	1278
	{966, 979, 978}, //	1121	1136	1135
	{966, 967, 979}, //	1121	1122	1136
	{967, 980, 979}, //	1122	2278	1136
	{967, 968, 980}, //	1122	1123	2278
	{968, 981, 980}, //	1123	2279	2278
	{968, 969, 981}, //	1123	1133	2279
	{969, 970, 981}, //	1133	1134	2279
	{969, 958, 970}, //	1133	1120	1134
	{970, 983, 982}, //	1125	2268	2267
	{970, 971, 983}, //	1125	1126	2268
	{971, 984, 983}, //	1126	2269	2268
	{971, 972, 984}, //	1126	1138	2269
	{972, 985, 984}, //	1092	1105	1104
	{972, 973, 985}, //	1092	1093	1105
	{973, 986, 985}, //	2457	2461	2460
	{973, 974, 986}, //	2457	2458	2461
	{974, 987, 986}, //	2458	2462	2461
	{974, 975, 987}, //	2458	2459	2462
	{975, 988, 987}, //	1116	1130	1129
	{975, 976, 988}, //	1116	1117	1130
	{976, 989, 988}, //	1132	1288	1279
	{976, 977, 989}, //	1132	1144	1288
	{977, 990, 989}, //	1144	2370	1288
	{977, 978, 990}, //	1144	1278	2370
	{978, 991, 990}, //	1145	2486	1161
	{978, 979, 991}, //	1145	1146	2486
	{979, 992, 991}, //	1146	2487	2486
	{979, 980, 992}, //	1146	1147	2487
	{980, 993, 992}, //	1147	2488	2487
	{980, 981, 993}, //	1147	1148	2488
	{981, 982, 993}, //	1148	1149	2488
	{981, 970, 982}, //	1148	1137	1149
	{982, 983, 994}, //	1149	1150	2489
	{983, 984, 994}, //	1150	1153	2489
	{984, 985, 994}, //	1153	1156	2489
	{985, 986, 994}, //	1156	1157	2489
	{986, 987, 994}, //	1157	1158	2489
	{987, 988, 994}, //	1158	1159	2489
	{988, 989, 994}, //	1159	1160	2489
	{989, 990, 994}, //	1160	1161	2489
	{990, 991, 994}, //	1161	2486	2489
	{991, 992, 994}, //	2486	2487	2489
	{992, 993, 994}, //	2487	2488	2489
	{993, 982, 994}, //	2488	1149	2489
	{995, 997, 996}, //	1162	1173	1167
	{995, 998, 997}, //	1162	1185	1173
	{995, 999, 998}, //	1162	1186	1185
	{995, 1000, 999}, //	1162	2288	1186
	{995, 1001, 1000}, //	1162	2289	2288
	{995, 1002, 1001}, //	1162	2290	2289
	{995, 1003, 1002}, //	1162	2291	2290
	{995, 1004, 1003}, //	1162	2292	2291
	{995, 1005, 1004}, //	1162	2293	2292
	{995, 1006, 1005}, //	1162	2294	2293
	{995, 1007, 1006}, //	1162	2295	2294
	{995, 996, 1007}, //	1162	1167	2295
	{996, 1009, 1008}, //	1164	1189	1188
	{996, 997, 1009}, //	1164	1176	1189
	{997, 1010, 1009}, //	1176	1200	1189
	{997, 998, 1010}, //	1176	1187	1200
	{998, 1011, 1010}, //	1139	1143	1142
	{998, 999, 1011}, //	1139	1140	1143
	{999, 1012, 1011}, //	1179	1204	1203
	{999, 1000, 1012}, //	1179	1190	1204
	{1000, 1013, 1012}, //	1190	1205	1204
	{1000, 1001, 1013}, //	1190	1191	1205
	{1001, 1014, 1013}, //	1151	1165	1155
	{1001, 1002, 1014}, //	1151	1152	1165
	{1002, 1015, 1014}, //	1152	1166	1165
	{1002, 1003, 1015}, //	1152	1154	1166
	{1003, 1016, 1015}, //	1168	1172	1171
	{1003, 1004, 1016}, //	1168	1169	1172
	{1004, 1017, 1016}, //	1169	1177	1172
	{1004, 1005, 1017}, //	1169	1170	1177
	{1005, 1018, 1017}, //	2293	2298	2297
	{1005, 1006, 1018}, //	2293	2294	2298
	{1006, 1019, 1018}, //	2294	2299	2298
	{1006, 1007, 1019}, //	2294	2295	2299
	{1007, 1008, 1019}, //	2295	2296	2299
	{1007, 996, 1008}, //	1174	1163	1175
	{1008, 1021, 1020}, //	1188	1202	1201
	{1008, 1009, 1021}, //	1188	1189	1202
	{1009, 1022, 1021}, //	1189	2404	1202
	{1009, 1010, 1022}, //	1189	1200	2404
	{1010, 1023, 1022}, //	1192	2230	2229
	{1010, 1011, 1023}, //	1192	1203	2230
	{1011, 1024, 1023}, //	1203	2231	2230
	{1011, 1012, 1024}, //	1203	1204	2231
	{1012, 1025, 1024}, //	1204	2232	2231
	{1012, 1013, 1025}, //	1204	1205	2232
	{1013, 1026, 1025}, //	1205	2233	2232
	{1013, 1014, 1026}, //	1205	1217	2233
	{1014, 1027, 1026}, //	1193	1207	1206
	{1014, 1015, 1027}, //	1193	1194	1207
	{1015, 1028, 1027}, //	1194	1208	1207
	{1015, 1016, 1028}, //	1194	1195	1208
	{1016, 1029, 1028}, //	1195	1209	1208
	{1016, 1017, 1029}, //	1195	1196	1209
	{1017, 1030, 1029}, //	1197	2350	2349
	{1017, 1018, 1030}, //	1197	1210	2350
	{1018, 1031, 1030}, //	1210	2351	2350
	{1018, 1019, 1031}, //	1210	2348	2351
	{1019, 1020, 1031}, //	1180	1181	1182
	{1019, 1008, 1020}, //	1180	1178	1181
	{1020, 1033, 1032}, //	1213	1234	1229
	{1020, 1021, 1033}, //	1213	1214	1234
	{1021, 1034, 1033}, //	1214	1235	1234
	{1021, 1022, 1034}, //	1214	1221	1235
	{1022, 1035, 1034}, //	1183	1199	1198
	{1022, 1023, 1035}, //	1183	1184	1199
	{1023, 1036, 1035}, //	2230	2235	2234
	{1023, 1024, 1036}, //	2230	2231	2235
	{1024, 1037, 1036}, //	2231	2236	2235
	{1024, 1025, 1037}, //	2231	2232	2236
	{1025, 1038, 1037}, //	1211	1218	1216
	{1025, 1026, 1038}, //	1211	1212	1218
	{1026, 1039, 1038}, //	1206	2437	2436
	{1026, 1027, 1039}, //	1206	1207	2437
	{1027, 1040, 1039}, //	1215	1220	1219
	{1027, 1028, 1040}, //	1222	1223	2283
	{1028, 1041, 1040}, //	1223	2284	2283
	{1028, 1029, 1041}, //	1223	1224	2284
	{1029, 1042, 1041}, //	1224	2285	2284
	{1029, 1030, 1042}, //	1224	1225	2285
	{1030, 1043, 1042}, //	1225	2286	2285
	{1030, 1031, 1043}, //	1225	1226	2286
	{1031, 1032, 1043}, //	1226	1229	2286
	{1031, 1020, 1032}, //	1226	1213	1229
	{1032, 1033, 1044}, //	1229	1234	2287
	{1033, 1034, 1044}, //	1234	1235	2287
	{1034, 1035, 1044}, //	1235	1236	2287
	{1035, 1036, 1044}, //	1236	1237	2287
	{1036, 1037, 1044}, //	1237	2280	2287
	{1037, 1038, 1044}, //	2280	2281	2287
	{1038, 1039, 1044}, //	2281	2282	2287
	{1039, 1040, 1044}, //	2282	2283	2287
	{1040, 1041, 1044}, //	2283	2284	2287
	{1041, 1042, 1044}, //	2284	2285	2287
	{1042, 1043, 1044}, //	2285	2286	2287
	{1043, 1032, 1044}, //	2286	1229	2287
	{1045, 1047, 1046}, //	1238	1246	1242
	{1045, 1048, 1047}, //	1238	1247	1246
	{1045, 1049, 1048}, //	1238	1248	1247
	{1045, 1050, 1049}, //	1238	1249	1248
	{1045, 1051, 1050}, //	1238	1254	1249
	{1045, 1052, 1051}, //	1238	1258	1254
	{1045, 1053, 1052}, //	1238	1259	1258
	{1045, 1054, 1053}, //	1238	1260	1259
	{1045, 1055, 1054}, //	1238	2207	1260
	{1045, 1056, 1055}, //	1238	2208	2207
	{1045, 1057, 1056}, //	1238	2209	2208
	{1045, 1046, 1057}, //	1238	1242	2209
	{1046, 1059, 1058}, //	1240	1263	1253
	{1046, 1047, 1059}, //	1240	1241	1263
	{1047, 1060, 1059}, //	1241	1264	1263
	{1047, 1048, 1060}, //	1241	1252	1264
	{1048, 1061, 1060}, //	1247	2211	2210
	{1048, 1049, 1061}, //	1247	1248	2211
	{1049, 1062, 1061}, //	1248	2212	2211
	{1049, 1050, 1062}, //	1248	1249	2212
	{1050, 1063, 1062}, //	1227	1232	1231
	{1050, 1051, 1063}, //	1227	1228	1232
	{1051, 1064, 1063}, //	1228	1233	1232
	{1051, 1052, 1064}, //	1228	1230	1233
	{1052, 1065, 1064}, //	1258	2214	2213
	{1052, 1053, 1065}, //	1258	1259	2214
	{1053, 1066, 1065}, //	1259	2215	2214
	{1053, 1054, 1066}, //	1259	1260	2215
	{1054, 1067, 1066}, //	1260	2216	2215
	{1054, 1055, 1067}, //	1260	2207	2216
	{1055, 1068, 1067}, //	1261	2191	1287
	{1055, 1056, 1068}, //	1261	1272	2191
	{1056, 1069, 1068}, //	1272	2192	2191
	{1056, 1057, 1069}, //	1272	1273	2192
	{1057, 1058, 1069}, //	1243	1244	1245
	{1057, 1046, 1058}, //	1243	1239	1244
	{1058, 1071, 1070}, //	1253	1275	1274
	{1058, 1059, 1071}, //	1253	1263	1275
	{1059, 1072, 1071}, //	1263	1276	1275
	{1059, 1060, 1072}, //	1263	1264	1276
	{1060, 1073, 1072}, //	1264	1277	1276
	{1060, 1061, 1073}, //	1264	1265	1277
	{1061, 1074, 1073}, //	1267	1305	1293
	{1061, 1062, 1074}, //	1267	1280	1305
	{1062, 1075, 1074}, //	1280	2274	1305
	{1062, 1063, 1075}, //	1280	1281	2274
	{1063, 1076, 1075}, //	1281	2275	2274
	{1063, 1064, 1076}, //	1268	1269	1282
	{1064, 1077, 1076}, //	1269	1283	1282
	{1064, 1065, 1077}, //	1269	1270	1283
	{1065, 1078, 1077}, //	1270	1284	1283
	{1065, 1066, 1078}, //	1270	1271	1284
	{1066, 1079, 1078}, //	1271	1285	1284
	{1066, 1067, 1079}, //	1286	1287	2194
	{1067, 1080, 1079}, //	1287	2195	2194
	{1067, 1068, 1080}, //	1287	2191	2195
	{1068, 1081, 1080}, //	2191	2196	2195
	{1068, 1069, 1081}, //	2191	2192	2196
	{1069, 1070, 1081}, //	2192	2193	2196
	{1069, 1058, 1070}, //	1266	1253	1274
	{1070, 1083, 1082}, //	1289	1312	1304
	{1070, 1071, 1083}, //	1289	1290	1312
	{1071, 1084, 1083}, //	1290	1313	1312
	{1071, 1072, 1084}, //	1290	1291	1313
	{1072, 1085, 1084}, //	1291	2197	1313
	{1072, 1073, 1085}, //	1291	1292	2197
	{1073, 1086, 1085}, //	1292	2198	2197
	{1073, 1074, 1086}, //	1292	1300	2198
	{1074, 1087, 1086}, //	1305	2277	2276
	{1074, 1075, 1087}, //	1305	2274	2277
	{1075, 1088, 1087}, //	1250	1256	1255
	{1075, 1076, 1088}, //	1250	1251	1256
	{1076, 1089, 1088}, //	1282	1308	1296
	{1076, 1077, 1089}, //	1282	1283	1308
	{1077, 1090, 1089}, //	1283	2341	1308
	{1077, 1078, 1090}, //	1283	1284	2341
	{1078, 1091, 1090}, //	1257	1297	1295
	{1078, 1079, 1091}, //	1257	1262	1297
	{1079, 1092, 1091}, //	1301	2204	2203
	{1079, 1080, 1092}, //	1262	1294	1298
	{1080, 1093, 1092}, //	1302	2205	2204
	{1080, 1081, 1093}, //	1302	1303	2205
	{1081, 1082, 1093}, //	1303	1304	2205
	{1081, 1070, 1082}, //	1303	1289	1304
	{1082, 1083, 1094}, //	1304	1312	2206
	{1083, 1084, 1094}, //	1312	1313	2206
	{1084, 1085, 1094}, //	1313	2197	2206
	{1085, 1086, 1094}, //	2197	2198	2206
	{1086, 1087, 1094}, //	2198	2199	2206
	{1087, 1088, 1094}, //	2199	2200	2206
	{1088, 1089, 1094}, //	2200	2201	2206
	{1089, 1090, 1094}, //	2201	2202	2206
	{1090, 1091, 1094}, //	2202	2203	2206
	{1091, 1092, 1094}, //	2203	2204	2206
	{1092, 1093, 1094}, //	2204	2205	2206
	{1093, 1082, 1094}, //	2205	1304	2206
	{1095, 1097, 1096}, //	1314	1326	1320
	{1095, 1098, 1097}, //	1314	1332	1326
	{1095, 1099, 1098}, //	1314	2252	1332
	{1095, 1100, 1099}, //	1314	2253	2252
	{1095, 1101, 1100}, //	1314	2254	2253
	{1095, 1102, 1101}, //	1314	2255	2254
	{1095, 1103, 1102}, //	1314	2256	2255
	{1095, 1104, 1103}, //	1314	2257	2256
	{1095, 1105, 1104}, //	1314	2258	2257
	{1095, 1106, 1105}, //	1314	2259	2258
	{1095, 1107, 1106}, //	1314	2260	2259
	{1095, 1096, 1107}, //	1314	1320	2260
	{1096, 1109, 1108}, //	1299	1311	1310
	{1096, 1097, 1109}, //	1299	1306	1311
	{1097, 1110, 1109}, //	1339	2452	1353
	{1097, 1098, 1110}, //	1339	1340	2452
	{1098, 1111, 1110}, //	1307	1316	1315
	{1098, 1099, 1111}, //	1307	1309	1316
	{1099, 1112, 1111}, //	1343	2371	1356
	{1099, 1100, 1112}, //	1317	1318	1319
	{1100, 1113, 1112}, //	2253	2263	2262
	{1100, 1101, 1113}, //	2253	2254	2263
	{1101, 1114, 1113}, //	2254	2264	2263
	{1101, 1102, 1114}, //	2254	2255	2264
	{1102, 1115, 1114}, //	1321	1345	1344
	{1102, 1103, 1115}, //	1321	1322	1345
	{1103, 1116, 1115}, //	1322	1346	1345
	{1103, 1104, 1116}, //	1322	1333	1346
	{1104, 1117, 1116}, //	1323	1328	1327
	{1104, 1105, 1117}, //	1323	1324	1328
	{1105, 1118, 1117}, //	1324	1329	1328
	{1105, 1106, 1118}, //	1324	1325	1329
	{1106, 1119, 1118}, //	1338	1351	1350
	{1106, 1107, 1119}, //	2259	2260	2265
	{1107, 1108, 1119}, //	2260	2261	2265
	{1107, 1096, 1108}, //	2260	1320	2261
	{1108, 1121, 1120}, //	1352	2454	2453
	{1108, 1109, 1121}, //	1352	1353	2454
	{1109, 1122, 1121}, //	1353	2455	2454
	{1109, 1110, 1122}, //	1353	2452	2455
	{1110, 1123, 1122}, //	1330	1336	1335
	{1110, 1111, 1123}, //	1330	1331	1336
	{1111, 1124, 1123}, //	1356	2374	2373
	{1111, 1112, 1124}, //	1356	2371	2374
	{1112, 1125, 1124}, //	2371	2375	2374
	{1112, 1113, 1125}, //	2371	2372	2375
	{1113, 1126, 1125}, //	1334	1358	1357
	{1113, 1114, 1126}, //	1334	1344	1358
	{1114, 1127, 1126}, //	1344	1359	1358
	{1114, 1115, 1127}, //	1344	1345	1359
	{1115, 1128, 1127}, //	1345	1360	1359
	{1115, 1116, 1128}, //	1345	1346	1360
	{1116, 1129, 1128}, //	1346	2405	1360
	{1116, 1117, 1129}, //	1346	1347	2405
	{1117, 1130, 1129}, //	1349	1363	1362
	{1117, 1118, 1130}, //	1349	1350	1363
	{1118, 1131, 1130}, //	1350	1364	1363
	{1118, 1119, 1131}, //	1350	1351	1364
	{1119, 1120, 1131}, //	1351	1361	1364
	{1119, 1108, 1120}, //	1351	1348	1361
	{1120, 1133, 1132}, //	1366	1389	1385
	{1120, 1121, 1133}, //	1366	1370	1389
	{1121, 1134, 1133}, //	1370	2241	1389
	{1121, 1122, 1134}, //	1370	1371	2241
	{1122, 1135, 1134}, //	1341	1367	1355
	{1122, 1123, 1135}, //	1335	1336	1337
	{1123, 1136, 1135}, //	1342	1368	1367
	{1123, 1124, 1136}, //	1342	1354	1368
	{1124, 1137, 1136}, //	1372	2244	2243
	{1124, 1125, 1137}, //	1372	1373	2244
	{1125, 1138, 1137}, //	1373	2245	2244
	{1125, 1126, 1138}, //	1373	1378	2245
	{1126, 1139, 1138}, //	1378	2246	2245
	{1126, 1127, 1139}, //	1378	1382	2246
	{1127, 1140, 1139}, //	1382	2247	2246
	{1127, 1128, 1140}, //	1382	1383	2247
	{1128, 1141, 1140}, //	1383	2248	2247
	{1128, 1129, 1141}, //	1383	1384	2248
	{1129, 1142, 1141}, //	1369	1379	1377
	{1129, 1130, 1142}, //	1369	1374	1379
	{1130, 1143, 1142}, //	1374	1380	1379
	{1130, 1131, 1143}, //	1374	1375	1380
	{1131, 1132, 1143}, //	1375	1376	1380
	{1131, 1120, 1132}, //	1375	1365	1376
	{1132, 1133, 1144}, //	1385	1389	2251
	{1133, 1134, 1144}, //	1389	2241	2251
	{1134, 1135, 1144}, //	2241	2242	2251
	{1135, 1136, 1144}, //	2242	2243	2251
	{1136, 1137, 1144}, //	2243	2244	2251
	{1137, 1138, 1144}, //	2244	2245	2251
	{1138, 1139, 1144}, //	2245	2246	2251
	{1139, 1140, 1144}, //	2246	2247	2251
	{1140, 1141, 1144}, //	2247	2248	2251
	{1141, 1142, 1144}, //	2248	2249	2251
	{1142, 1143, 1144}, //	2249	2250	2251
	{1143, 1132, 1144}, //	2250	1385	2251
	{1145, 1147, 1146}, //	1390	1398	1395
	{1145, 1148, 1147}, //	1390	1399	1398
	{1145, 1149, 1148}, //	1390	1400	1399
	{1145, 1150, 1149}, //	1390	1401	1400
	{1145, 1151, 1150}, //	1390	1402	1401
	{1145, 1152, 1151}, //	1390	1410	1402
	{1145, 1153, 1152}, //	1390	1411	1410
	{1145, 1154, 1153}, //	1390	1412	1411
	{1145, 1155, 1154}, //	1390	1413	1412
	{1145, 1156, 1155}, //	1390	1414	1413
	{1145, 1157, 1156}, //	1390	2468	1414
	{1145, 1146, 1157}, //	1390	1395	2468
	{1146, 1159, 1158}, //	1381	1391	1388
	{1146, 1147, 1159}, //	1381	1386	1391
	{1147, 1160, 1159}, //	1386	1392	1391
	{1147, 1148, 1160}, //	1386	1387	1392
	{1148, 1161, 1160}, //	1393	1404	1403
	{1148, 1149, 1161}, //	1393	1394	1404
	{1149, 1162, 1161}, //	1407	2343	2342
	{1149, 1150, 1162}, //	1407	1419	2343
	{1150, 1163, 1162}, //	1419	2344	2343
	{1150, 1151, 1163}, //	1419	1432	2344
	{1151, 1164, 1163}, //	1396	1406	1405
	{1151, 1152, 1164}, //	1396	1397	1406
	{1152, 1165, 1164}, //	1410	2471	2470
	{1152, 1153, 1165}, //	1410	1411	2471
	{1153, 1166, 1165}, //	1411	2472	2471
	{1153, 1154, 1166}, //	1411	1412	2472
	{1154, 1167, 1166}, //	1412	2473	2472
	{1154, 1155, 1167}, //	1412	1413	2473
	{1155, 1168, 1167}, //	1413	2474	2473
	{1155, 1156, 1168}, //	1413	1414	2474
	{1156, 1169, 1168}, //	1414	2475	2474
	{1156, 1157, 1169}, //	1414	2468	2475
	{1157, 1158, 1169}, //	2468	2469	2475
	{1157, 1146, 1158}, //	2468	1395	2469
	{1158, 1171, 1170}, //	1415	1442	1441
	{1158, 1159, 1171}, //	1415	1416	1442
	{1159, 1172, 1171}, //	1416	2177	1442
	{1159, 1160, 1172}, //	1416	1428	2177
	{1160, 1173, 1172}, //	1430	2483	2482
	{1160, 1161, 1173}, //	1417	1418	1431
	{1161, 1174, 1173}, //	2342	2346	2345
	{1161, 1162, 1174}, //	2342	2343	2346
	{1162, 1175, 1174}, //	2343	2347	2346
	{1162, 1163, 1175}, //	2343	2344	2347
	{1163, 1176, 1175}, //	1405	1409	1408
	{1163, 1164, 1176}, //	1405	1406	1409
	{1164, 1177, 1176}, //	1422	2225	2224
	{1164, 1165, 1177}, //	1422	1435	2225
	{1165, 1178, 1177}, //	1435	2226	2225
	{1165, 1166, 1178}, //	1435	2223	2226
	{1166, 1179, 1178}, //	1436	2500	2499
	{1166, 1167, 1179}, //	1423	1424	1437
	{1167, 1180, 1179}, //	1425	2376	1451
	{1167, 1168, 1180}, //	1425	1438	2376
	{1168, 1181, 1180}, //	1438	2377	2376
	{1168, 1169, 1181}, //	1438	1439	2377
	{1169, 1170, 1181}, //	1429	1441	2178
	{1169, 1158, 1170}, //	1421	1420	1426
	{1170, 1183, 1182}, //	1441	2180	2179
	{1170, 1171, 1183}, //	1441	1442	2180
	{1171, 1184, 1183}, //	1442	2181	2180
	{1171, 1172, 1184}, //	1442	2177	2181
	{1172, 1185, 1184}, //	1443	1457	1456
	{1172, 1173, 1185}, //	1443	1444	1457
	{1173, 1186, 1185}, //	1444	1458	1457
	{1173, 1174, 1186}, //	1444	1445	1458
	{1174, 1187, 1186}, //	1445	1459	1458
	{1174, 1175, 1187}, //	1445	1446	1459
	{1175, 1188, 1187}, //	1446	1460	1459
	{1175, 1176, 1188}, //	1446	1447	1460
	{1176, 1189, 1188}, //	2224	2228	2227
	{1176, 1177, 1189}, //	2224	2225	2228
	{1177, 1190, 1189}, //	1440	1452	1450
	{1177, 1178, 1190}, //	1440	1448	1452
	{1178, 1191, 1190}, //	1448	1453	1452
	{1178, 1179, 1191}, //	1448	1449	1453
	{1179, 1192, 1191}, //	1451	2379	2378
	{1179, 1180, 1192}, //	1451	2376	2379
	{1180, 1193, 1192}, //	2376	2380	2379
	{1180, 1181, 1193}, //	2376	2377	2380
	{1181, 1182, 1193}, //	1427	1433	1434
	{1181, 1170, 1182}, //	2178	1441	2179
	{1182, 1183, 1194}, //	1454	1455	2467
	{1183, 1184, 1194}, //	1455	1456	2467
	{1184, 1185, 1194}, //	1456	1457	2467
	{1185, 1186, 1194}, //	1457	1458	2467
	{1186, 1187, 1194}, //	1458	1459	2467
	{1187, 1188, 1194}, //	1459	1460	2467
	{1188, 1189, 1194}, //	1460	1461	2467
	{1189, 1190, 1194}, //	1461	2463	2467
	{1190, 1191, 1194}, //	2463	2464	2467
	{1191, 1192, 1194}, //	2464	2465	2467
	{1192, 1193, 1194}, //	2465	2466	2467
	{1193, 1182, 1194}  //	2466	1454	2467
};

const float p_texcoord[][2] = {
	{0.526f, 0.020f}, 
	{0.597f, 0.020f}, 
	{0.667f, 0.020f}, 
	{0.737f, 0.020f}, 
	{0.808f, 0.020f}, 
	{0.878f, 0.020f}, 
	{0.526f, 0.090f}, 
	{0.597f, 0.090f}, 
	{0.667f, 0.090f}, 
	{0.737f, 0.090f}, 
	{0.808f, 0.090f}, 
	{0.878f, 0.090f}, 
	{0.526f, 0.161f}, 
	{0.597f, 0.161f}, 
	{0.667f, 0.161f}, 
	{0.737f, 0.161f}, 
	{0.808f, 0.161f}, 
	{0.878f, 0.161f}, 
	{0.526f, 0.231f}, 
	{0.597f, 0.231f}, 
	{0.667f, 0.231f}, 
	{0.737f, 0.231f}, 
	{0.808f, 0.231f}, 
	{0.878f, 0.231f}, 
	{0.526f, 0.301f}, 
	{0.597f, 0.301f}, 
	{0.667f, 0.301f}, 
	{0.737f, 0.301f}, 
	{0.808f, 0.301f}, 
	{0.878f, 0.301f}, 
	{0.526f, 0.372f}, 
	{0.597f, 0.372f}, 
	{0.667f, 0.372f}, 
	{0.737f, 0.372f}, 
	{0.808f, 0.372f}, 
	{0.878f, 0.372f}, 
	{0.562f, 0.055f}, 
	{0.632f, 0.055f}, 
	{0.702f, 0.055f}, 
	{0.773f, 0.055f}, 
	{0.843f, 0.055f}, 
	{0.562f, 0.125f}, 
	{0.632f, 0.125f}, 
	{0.702f, 0.125f}, 
	{0.773f, 0.125f}, 
	{0.843f, 0.125f}, 
	{0.562f, 0.196f}, 
	{0.632f, 0.196f}, 
	{0.702f, 0.196f}, 
	{0.773f, 0.196f}, 
	{0.843f, 0.196f}, 
	{0.562f, 0.266f}, 
	{0.632f, 0.266f}, 
	{0.702f, 0.266f}, 
	{0.773f, 0.266f}, 
	{0.843f, 0.266f}, 
	{0.562f, 0.336f}, 
	{0.632f, 0.336f}, 
	{0.702f, 0.336f}, 
	{0.773f, 0.336f}, 
	{0.843f, 0.336f}, 
	{0.526f, 0.055f}, 
	{0.562f, 0.090f}, 
	{0.597f, 0.055f}, 
	{0.562f, 0.020f}, 
	{0.632f, 0.090f}, 
	{0.667f, 0.055f}, 
	{0.632f, 0.020f}, 
	{0.702f, 0.090f}, 
	{0.737f, 0.055f}, 
	{0.702f, 0.020f}, 
	{0.773f, 0.090f}, 
	{0.808f, 0.055f}, 
	{0.773f, 0.020f}, 
	{0.843f, 0.090f}, 
	{0.878f, 0.055f}, 
	{0.843f, 0.020f}, 
	{0.526f, 0.125f}, 
	{0.562f, 0.161f}, 
	{0.597f, 0.125f}, 
	{0.632f, 0.161f}, 
	{0.667f, 0.125f}, 
	{0.702f, 0.161f}, 
	{0.737f, 0.125f}, 
	{0.773f, 0.161f}, 
	{0.808f, 0.125f}, 
	{0.843f, 0.161f}, 
	{0.878f, 0.125f}, 
	{0.526f, 0.196f}, 
	{0.562f, 0.231f}, 
	{0.597f, 0.196f}, 
	{0.632f, 0.231f}, 
	{0.667f, 0.196f}, 
	{0.702f, 0.231f}, 
	{0.737f, 0.196f}, 
	{0.773f, 0.231f}, 
	{0.808f, 0.196f}, 
	{0.843f, 0.231f}, 
	{0.878f, 0.196f}, 
	{0.526f, 0.266f}, 
	{0.562f, 0.301f}, 
	{0.597f, 0.266f}, 
	{0.632f, 0.301f}, 
	{0.667f, 0.266f}, 
	{0.702f, 0.301f}, 
	{0.737f, 0.266f}, 
	{0.773f, 0.301f}, 
	{0.808f, 0.266f}, 
	{0.843f, 0.301f}, 
	{0.878f, 0.266f}, 
	{0.526f, 0.336f}, 
	{0.562f, 0.372f}, 
	{0.597f, 0.336f}, 
	{0.632f, 0.372f}, 
	{0.667f, 0.336f}, 
	{0.702f, 0.372f}, 
	{0.737f, 0.336f}, 
	{0.773f, 0.372f}, 
	{0.808f, 0.336f}, 
	{0.843f, 0.372f}, 
	{0.878f, 0.336f}, 
	{0.676f, 0.655f}, 
	{0.664f, 0.646f}, 
	{0.662f, 0.649f}, 
	{0.661f, 0.653f}, 
	{0.661f, 0.657f}, 
	{0.662f, 0.661f}, 
	{0.664f, 0.665f}, 
	{0.667f, 0.667f}, 
	{0.670f, 0.669f}, 
	{0.674f, 0.670f}, 
	{0.678f, 0.670f}, 
	{0.682f, 0.669f}, 
	{0.685f, 0.667f}, 
	{0.688f, 0.664f}, 
	{0.690f, 0.661f}, 
	{0.691f, 0.657f}, 
	{0.691f, 0.653f}, 
	{0.690f, 0.649f}, 
	{0.688f, 0.646f}, 
	{0.685f, 0.643f}, 
	{0.682f, 0.641f}, 
	{0.678f, 0.640f}, 
	{0.674f, 0.640f}, 
	{0.670f, 0.641f}, 
	{0.667f, 0.643f}, 
	{0.641f, 0.670f}, 
	{0.637f, 0.670f}, 
	{0.633f, 0.670f}, 
	{0.567f, 0.530f}, 
	{0.571f, 0.529f}, 
	{0.574f, 0.529f}, 
	{0.578f, 0.528f}, 
	{0.582f, 0.527f}, 
	{0.586f, 0.527f}, 
	{0.589f, 0.526f}, 
	{0.621f, 0.670f}, 
	{0.618f, 0.670f}, 
	{0.614f, 0.670f}, 
	{0.610f, 0.670f}, 
	{0.606f, 0.670f}, 
	{0.535f, 0.527f}, 
	{0.538f, 0.527f}, 
	{0.542f, 0.528f}, 
	{0.546f, 0.528f}, 
	{0.549f, 0.529f}, 
	{0.553f, 0.529f}, 
	{0.556f, 0.530f}, 
	{0.630f, 0.670f}, 
	{0.652f, 0.670f}, 
	{0.649f, 0.670f}, 
	{0.645f, 0.670f}, 
	{0.641f, 0.643f}, 
	{0.572f, 0.557f}, 
	{0.575f, 0.557f}, 
	{0.578f, 0.557f}, 
	{0.581f, 0.556f}, 
	{0.585f, 0.556f}, 
	{0.588f, 0.556f}, 
	{0.590f, 0.556f}, 
	{0.603f, 0.670f}, 
	{0.600f, 0.670f}, 
	{0.619f, 0.641f}, 
	{0.617f, 0.641f}, 
	{0.614f, 0.641f}, 
	{0.534f, 0.556f}, 
	{0.537f, 0.557f}, 
	{0.540f, 0.557f}, 
	{0.543f, 0.557f}, 
	{0.547f, 0.557f}, 
	{0.550f, 0.557f}, 
	{0.552f, 0.557f}, 
	{0.638f, 0.643f}, 
	{0.635f, 0.643f}, 
	{0.632f, 0.642f}, 
	{0.650f, 0.642f}, 
	{0.647f, 0.643f}, 
	{0.575f, 0.585f}, 
	{0.577f, 0.585f}, 
	{0.580f, 0.585f}, 
	{0.582f, 0.585f}, 
	{0.585f, 0.585f}, 
	{0.587f, 0.585f}, 
	{0.590f, 0.585f}, 
	{0.610f, 0.641f}, 
	{0.607f, 0.641f}, 
	{0.604f, 0.641f}, 
	{0.601f, 0.641f}, 
	{0.617f, 0.612f}, 
	{0.536f, 0.586f}, 
	{0.538f, 0.585f}, 
	{0.541f, 0.585f}, 
	{0.543f, 0.585f}, 
	{0.546f, 0.585f}, 
	{0.548f, 0.585f}, 
	{0.551f, 0.585f}, 
	{0.644f, 0.643f}, 
	{0.641f, 0.615f}, 
	{0.638f, 0.615f}, 
	{0.636f, 0.615f}, 
	{0.634f, 0.614f}, 
	{0.576f, 0.613f}, 
	{0.578f, 0.613f}, 
	{0.579f, 0.613f}, 
	{0.581f, 0.613f}, 
	{0.583f, 0.614f}, 
	{0.585f, 0.614f}, 
	{0.587f, 0.614f}, 
	{0.615f, 0.612f}, 
	{0.613f, 0.612f}, 
	{0.610f, 0.612f}, 
	{0.608f, 0.612f}, 
	{0.605f, 0.612f}, 
	{0.540f, 0.614f}, 
	{0.542f, 0.614f}, 
	{0.544f, 0.614f}, 
	{0.546f, 0.614f}, 
	{0.547f, 0.614f}, 
	{0.549f, 0.613f}, 
	{0.551f, 0.613f}, 
	{0.648f, 0.614f}, 
	{0.646f, 0.615f}, 
	{0.587f, 0.670f}, 
	{0.587f, 0.670f}, 
	{0.586f, 0.670f}, 
	{0.586f, 0.669f}, 
	{0.585f, 0.669f}, 
	{0.585f, 0.668f}, 
	{0.585f, 0.668f}, 
	{0.585f, 0.667f}, 
	{0.585f, 0.666f}, 
	{0.586f, 0.666f}, 
	{0.587f, 0.666f}, 
	{0.587f, 0.665f}, 
	{0.588f, 0.665f}, 
	{0.589f, 0.666f}, 
	{0.589f, 0.666f}, 
	{0.590f, 0.666f}, 
	{0.590f, 0.667f}, 
	{0.590f, 0.667f}, 
	{0.590f, 0.668f}, 
	{0.590f, 0.669f}, 
	{0.590f, 0.669f}, 
	{0.589f, 0.670f}, 
	{0.589f, 0.670f}, 
	{0.588f, 0.670f}, 
	{0.588f, 0.668f}, 
	{0.070f, 0.700f}, 
	{0.574f, 0.641f}, 
	{0.575f, 0.641f}, 
	{0.577f, 0.642f}, 
	{0.578f, 0.642f}, 
	{0.579f, 0.642f}, 
	{0.581f, 0.642f}, 
	{0.582f, 0.642f}, 
	{0.571f, 0.669f}, 
	{0.571f, 0.670f}, 
	{0.572f, 0.670f}, 
	{0.573f, 0.670f}, 
	{0.573f, 0.670f}, 
	{0.574f, 0.670f}, 
	{0.574f, 0.670f}, 
	{0.546f, 0.643f}, 
	{0.072f, 0.759f}, 
	{0.347f, 0.697f}, 
	{0.022f, 0.671f}, 
	{0.198f, 0.544f}, 
	{0.347f, 0.711f}, 
	{0.345f, 0.697f}, 
	{0.198f, 0.547f}, 
	{0.253f, 0.640f}, 
	{0.249f, 0.653f}, 
	{0.248f, 0.659f}, 
	{0.247f, 0.672f}, 
	{0.248f, 0.686f}, 
	{0.345f, 0.711f}, 
	{0.345f, 0.714f}, 
	{0.252f, 0.697f}, 
	{0.252f, 0.639f}, 
	{0.248f, 0.653f}, 
	{0.246f, 0.659f}, 
	{0.245f, 0.672f}, 
	{0.418f, 0.831f}, 
	{0.406f, 0.833f}, 
	{0.254f, 0.581f}, 
	{0.256f, 0.572f}, 
	{0.107f, 0.624f}, 
	{0.165f, 0.798f}, 
	{0.383f, 0.806f}, 
	{0.301f, 0.617f}, 
	{0.304f, 0.626f}, 
	{0.256f, 0.558f}, 
	{0.423f, 0.890f}, 
	{0.423f, 0.903f}, 
	{0.154f, 0.808f}, 
	{0.293f, 0.683f}, 
	{0.293f, 0.669f}, 
	{0.304f, 0.640f}, 
	{0.439f, 0.890f}, 
	{0.436f, 0.903f}, 
	{0.429f, 0.915f}, 
	{0.152f, 0.814f}, 
	{0.308f, 0.683f}, 
	{0.305f, 0.670f}, 
	{0.299f, 0.658f}, 
	{0.041f, 0.975f}, 
	{0.298f, 0.945f}, 
	{0.295f, 0.944f}, 
	{0.040f, 0.976f}, 
	{0.041f, 0.978f}, 
	{0.293f, 0.945f}, 
	{0.256f, 0.712f}, 
	{0.251f, 0.723f}, 
	{0.249f, 0.729f}, 
	{0.247f, 0.742f}, 
	{0.247f, 0.757f}, 
	{0.250f, 0.769f}, 
	{0.255f, 0.780f}, 
	{0.254f, 0.711f}, 
	{0.249f, 0.722f}, 
	{0.247f, 0.728f}, 
	{0.245f, 0.742f}, 
	{0.246f, 0.757f}, 
	{0.248f, 0.769f}, 
	{0.253f, 0.780f}, 
	{0.374f, 0.963f}, 
	{0.418f, 0.846f}, 
	{0.405f, 0.846f}, 
	{0.252f, 0.934f}, 
	{0.306f, 0.603f}, 
	{0.294f, 0.601f}, 
	{0.377f, 0.846f}, 
	{0.372f, 0.976f}, 
	{0.409f, 0.738f}, 
	{0.409f, 0.725f}, 
	{0.243f, 0.945f}, 
	{0.429f, 0.806f}, 
	{0.428f, 0.793f}, 
	{0.375f, 0.833f}, 
	{0.384f, 0.969f}, 
	{0.397f, 0.725f}, 
	{0.464f, 0.723f}, 
	{0.242f, 0.951f}, 
	{0.370f, 0.652f}, 
	{0.440f, 0.793f}, 
	{0.387f, 0.841f}, 
	{0.046f, 0.703f}, 
	{0.045f, 0.694f}, 
	{0.109f, 0.848f}, 
	{0.045f, 0.679f}, 
	{0.046f, 0.677f}, 
	{0.108f, 0.850f}, 
	{0.118f, 0.776f}, 
	{0.117f, 0.827f}, 
	{0.114f, 0.817f}, 
	{0.114f, 0.805f}, 
	{0.047f, 0.704f}, 
	{0.047f, 0.694f}, 
	{0.047f, 0.680f}, 
	{0.115f, 0.792f}, 
	{0.118f, 0.779f}, 
	{0.106f, 0.785f}, 
	{0.117f, 0.775f}, 
	{0.047f, 0.677f}, 
	{0.412f, 0.699f}, 
	{0.413f, 0.687f}, 
	{0.414f, 0.791f}, 
	{0.414f, 0.806f}, 
	{0.248f, 0.866f}, 
	{0.247f, 0.872f}, 
	{0.245f, 0.885f}, 
	{0.433f, 0.838f}, 
	{0.445f, 0.846f}, 
	{0.325f, 0.723f}, 
	{0.402f, 0.799f}, 
	{0.245f, 0.900f}, 
	{0.248f, 0.912f}, 
	{0.260f, 0.865f}, 
	{0.275f, 0.682f}, 
	{0.275f, 0.697f}, 
	{0.325f, 0.708f}, 
	{0.464f, 0.834f}, 
	{0.260f, 0.872f}, 
	{0.259f, 0.886f}, 
	{0.259f, 0.902f}, 
	{0.378f, 0.617f}, 
	{0.272f, 0.696f}, 
	{0.346f, 0.934f}, 
	{0.023f, 0.900f}, 
	{0.023f, 0.903f}, 
	{0.347f, 0.937f}, 
	{0.021f, 0.900f}, 
	{0.021f, 0.903f}, 
	{0.176f, 0.578f}, 
	{0.176f, 0.565f}, 
	{0.208f, 0.653f}, 
	{0.207f, 0.659f}, 
	{0.205f, 0.671f}, 
	{0.205f, 0.686f}, 
	{0.207f, 0.699f}, 
	{0.176f, 0.580f}, 
	{0.176f, 0.583f}, 
	{0.210f, 0.711f}, 
	{0.207f, 0.653f}, 
	{0.205f, 0.658f}, 
	{0.203f, 0.671f}, 
	{0.203f, 0.686f}, 
	{0.472f, 0.634f}, 
	{0.116f, 0.670f}, 
	{0.149f, 0.602f}, 
	{0.404f, 0.884f}, 
	{0.405f, 0.900f}, 
	{0.229f, 0.667f}, 
	{0.229f, 0.679f}, 
	{0.115f, 0.657f}, 
	{0.150f, 0.617f}, 
	{0.165f, 0.602f}, 
	{0.389f, 0.884f}, 
	{0.390f, 0.901f}, 
	{0.392f, 0.915f}, 
	{0.229f, 0.681f}, 
	{0.209f, 0.733f}, 
	{0.221f, 0.743f}, 
	{0.162f, 0.779f}, 
	{0.174f, 0.769f}, 
	{0.175f, 0.763f}, 
	{0.178f, 0.752f}, 
	{0.160f, 0.778f}, 
	{0.318f, 0.934f}, 
	{0.318f, 0.937f}, 
	{0.271f, 0.564f}, 
	{0.317f, 0.934f}, 
	{0.317f, 0.937f}, 
	{0.271f, 0.566f}, 
	{0.198f, 0.633f}, 
	{0.202f, 0.619f}, 
	{0.203f, 0.613f}, 
	{0.203f, 0.601f}, 
	{0.201f, 0.586f}, 
	{0.457f, 0.634f}, 
	{0.456f, 0.619f}, 
	{0.197f, 0.576f}, 
	{0.200f, 0.634f}, 
	{0.203f, 0.620f}, 
	{0.205f, 0.613f}, 
	{0.205f, 0.600f}, 
	{0.271f, 0.544f}, 
	{0.457f, 0.619f}, 
	{0.106f, 0.827f}, 
	{0.107f, 0.557f}, 
	{0.114f, 0.547f}, 
	{0.122f, 0.980f}, 
	{0.378f, 0.738f}, 
	{0.370f, 0.728f}, 
	{0.418f, 0.550f}, 
	{0.107f, 0.814f}, 
	{0.445f, 0.772f}, 
	{0.132f, 0.969f}, 
	{0.133f, 0.963f}, 
	{0.135f, 0.950f}, 
	{0.245f, 0.541f}, 
	{0.418f, 0.563f}, 
	{0.432f, 0.772f}, 
	{0.439f, 0.760f}, 
	{0.135f, 0.935f}, 
	{0.119f, 0.980f}, 
	{0.120f, 0.969f}, 
	{0.256f, 0.536f}, 
	{0.245f, 0.526f}, 
	{0.223f, 0.628f}, 
	{0.222f, 0.631f}, 
	{0.223f, 0.633f}, 
	{0.222f, 0.628f}, 
	{0.221f, 0.631f}, 
	{0.222f, 0.633f}, 
	{0.176f, 0.546f}, 
	{0.439f, 0.601f}, 
	{0.120f, 0.847f}, 
	{0.119f, 0.852f}, 
	{0.117f, 0.863f}, 
	{0.118f, 0.877f}, 
	{0.120f, 0.889f}, 
	{0.177f, 0.532f}, 
	{0.177f, 0.546f}, 
	{0.122f, 0.903f}, 
	{0.119f, 0.846f}, 
	{0.117f, 0.851f}, 
	{0.116f, 0.862f}, 
	{0.116f, 0.877f}, 
	{0.346f, 0.606f}, 
	{0.346f, 0.596f}, 
	{0.074f, 0.637f}, 
	{0.357f, 0.915f}, 
	{0.119f, 0.889f}, 
	{0.092f, 0.798f}, 
	{0.092f, 0.809f}, 
	{0.345f, 0.594f}, 
	{0.074f, 0.625f}, 
	{0.063f, 0.634f}, 
	{0.367f, 0.903f}, 
	{0.121f, 0.903f}, 
	{0.106f, 0.883f}, 
	{0.091f, 0.811f}, 
	{0.308f, 0.868f}, 
	{0.319f, 0.879f}, 
	{0.368f, 0.897f}, 
	{0.370f, 0.886f}, 
	{0.106f, 0.751f}, 
	{0.109f, 0.740f}, 
	{0.117f, 0.727f}, 
	{0.046f, 0.975f}, 
	{0.028f, 0.903f}, 
	{0.028f, 0.900f}, 
	{0.049f, 0.975f}, 
	{0.030f, 0.903f}, 
	{0.030f, 0.900f}, 
	{0.022f, 0.703f}, 
	{0.026f, 0.692f}, 
	{0.028f, 0.686f}, 
	{0.029f, 0.673f}, 
	{0.028f, 0.658f}, 
	{0.025f, 0.646f}, 
	{0.020f, 0.636f}, 
	{0.023f, 0.704f}, 
	{0.028f, 0.693f}, 
	{0.029f, 0.686f}, 
	{0.031f, 0.673f}, 
	{0.030f, 0.658f}, 
	{0.027f, 0.646f}, 
	{0.022f, 0.635f}, 
	{0.046f, 0.647f}, 
	{0.045f, 0.660f}, 
	{0.037f, 0.905f}, 
	{0.047f, 0.893f}, 
	{0.048f, 0.887f}, 
	{0.324f, 0.638f}, 
	{0.324f, 0.651f}, 
	{0.230f, 0.592f}, 
	{0.219f, 0.583f}, 
	{0.049f, 0.874f}, 
	{0.048f, 0.859f}, 
	{0.045f, 0.848f}, 
	{0.382f, 0.686f}, 
	{0.106f, 0.576f}, 
	{0.074f, 0.590f}, 
	{0.230f, 0.575f}, 
	{0.035f, 0.905f}, 
	{0.035f, 0.895f}, 
	{0.035f, 0.888f}, 
	{0.370f, 0.686f}, 
	{0.376f, 0.699f}, 
	{0.331f, 0.951f}, 
	{0.389f, 0.865f}, 
	{0.389f, 0.862f}, 
	{0.331f, 0.963f}, 
	{0.390f, 0.865f}, 
	{0.390f, 0.863f}, 
	{0.284f, 0.937f}, 
	{0.284f, 0.950f}, 
	{0.283f, 0.963f}, 
	{0.284f, 0.977f}, 
	{0.329f, 0.977f}, 
	{0.328f, 0.980f}, 
	{0.329f, 0.951f}, 
	{0.298f, 0.956f}, 
	{0.295f, 0.968f}, 
	{0.286f, 0.980f}, 
	{0.285f, 0.937f}, 
	{0.329f, 0.963f}, 
	{0.328f, 0.977f}, 
	{0.317f, 0.956f}, 
	{0.198f, 0.664f}, 
	{0.197f, 0.679f}, 
	{0.358f, 0.980f}, 
	{0.263f, 0.846f}, 
	{0.318f, 0.967f}, 
	{0.345f, 0.660f}, 
	{0.346f, 0.675f}, 
	{0.198f, 0.682f}, 
	{0.119f, 0.708f}, 
	{0.117f, 0.696f}, 
	{0.272f, 0.833f}, 
	{0.285f, 0.950f}, 
	{0.285f, 0.963f}, 
	{0.346f, 0.678f}, 
	{0.108f, 0.684f}, 
	{0.106f, 0.713f}, 
	{0.106f, 0.701f}, 
	{0.273f, 0.827f}, 
	{0.285f, 0.977f}, 
	{0.224f, 0.930f}, 
	{0.225f, 0.937f}, 
	{0.408f, 0.975f}, 
	{0.413f, 0.772f}, 
	{0.401f, 0.763f}, 
	{0.418f, 0.965f}, 
	{0.410f, 0.771f}, 
	{0.413f, 0.759f}, 
	{0.413f, 0.771f}, 
	{0.402f, 0.762f}, 
	{0.323f, 0.845f}, 
	{0.325f, 0.840f}, 
	{0.328f, 0.829f}, 
	{0.329f, 0.814f}, 
	{0.328f, 0.801f}, 
	{0.411f, 0.769f}, 
	{0.465f, 0.980f}, 
	{0.325f, 0.788f}, 
	{0.324f, 0.786f}, 
	{0.324f, 0.846f}, 
	{0.327f, 0.841f}, 
	{0.330f, 0.829f}, 
	{0.418f, 0.585f}, 
	{0.382f, 0.770f}, 
	{0.175f, 0.930f}, 
	{0.176f, 0.936f}, 
	{0.178f, 0.950f}, 
	{0.076f, 0.538f}, 
	{0.091f, 0.825f}, 
	{0.382f, 0.931f}, 
	{0.385f, 0.945f}, 
	{0.178f, 0.965f}, 
	{0.176f, 0.977f}, 
	{0.163f, 0.929f}, 
	{0.063f, 0.537f}, 
	{0.067f, 0.553f}, 
	{0.398f, 0.667f}, 
	{0.372f, 0.944f}, 
	{0.163f, 0.935f}, 
	{0.164f, 0.950f}, 
	{0.165f, 0.967f}, 
	{0.306f, 0.564f}, 
	{0.467f, 0.978f}, 
	{0.031f, 0.531f}, 
	{0.230f, 0.606f}, 
	{0.230f, 0.633f}, 
	{0.031f, 0.546f}, 
	{0.230f, 0.623f}, 
	{0.230f, 0.609f}, 
	{0.219f, 0.616f}, 
	{0.229f, 0.606f}, 
	{0.228f, 0.634f}, 
	{0.174f, 0.714f}, 
	{0.176f, 0.710f}, 
	{0.179f, 0.700f}, 
	{0.180f, 0.688f}, 
	{0.228f, 0.623f}, 
	{0.229f, 0.609f}, 
	{0.293f, 0.533f}, 
	{0.178f, 0.676f}, 
	{0.175f, 0.662f}, 
	{0.175f, 0.659f}, 
	{0.176f, 0.715f}, 
	{0.464f, 0.772f}, 
	{0.370f, 0.547f}, 
	{0.152f, 0.862f}, 
	{0.151f, 0.868f}, 
	{0.149f, 0.880f}, 
	{0.436f, 0.721f}, 
	{0.467f, 0.948f}, 
	{0.466f, 0.772f}, 
	{0.466f, 0.758f}, 
	{0.150f, 0.896f}, 
	{0.152f, 0.908f}, 
	{0.164f, 0.860f}, 
	{0.465f, 0.948f}, 
	{0.465f, 0.934f}, 
	{0.471f, 0.806f}, 
	{0.397f, 0.634f}, 
	{0.164f, 0.866f}, 
	{0.164f, 0.880f}, 
	{0.163f, 0.897f}, 
	{0.468f, 0.699f}, 
	{0.324f, 0.689f}, 
	{0.266f, 0.240f}, 
	{0.218f, 0.240f}, 
	{0.266f, 0.248f}, 
	{0.218f, 0.248f}, 
	{0.095f, 0.474f}, 
	{0.253f, 0.474f}, 
	{0.095f, 0.481f}, 
	{0.253f, 0.481f}, 
	{0.273f, 0.466f}, 
	{0.477f, 0.481f}, 
	{0.277f, 0.405f}, 
	{0.481f, 0.420f}, 
	{0.187f, 0.081f}, 
	{0.084f, 0.133f}, 
	{0.081f, 0.134f}, 
	{0.079f, 0.133f}, 
	{0.107f, 0.062f}, 
	{0.105f, 0.062f}, 
	{0.133f, 0.302f}, 
	{0.136f, 0.301f}, 
	{0.139f, 0.301f}, 
	{0.188f, 0.076f}, 
	{0.191f, 0.077f}, 
	{0.192f, 0.079f}, 
	{0.077f, 0.132f}, 
	{0.086f, 0.131f}, 
	{0.085f, 0.135f}, 
	{0.082f, 0.136f}, 
	{0.108f, 0.064f}, 
	{0.104f, 0.064f}, 
	{0.133f, 0.300f}, 
	{0.136f, 0.299f}, 
	{0.139f, 0.300f}, 
	{0.192f, 0.082f}, 
	{0.191f, 0.085f}, 
	{0.189f, 0.086f}, 
	{0.078f, 0.136f}, 
	{0.279f, 0.129f}, 
	{0.278f, 0.132f}, 
	{0.183f, 0.300f}, 
	{0.204f, 0.133f}, 
	{0.423f, 0.217f}, 
	{0.423f, 0.219f}, 
	{0.425f, 0.213f}, 
	{0.269f, 0.270f}, 
	{0.268f, 0.273f}, 
	{0.191f, 0.189f}, 
	{0.192f, 0.192f}, 
	{0.116f, 0.192f}, 
	{0.354f, 0.082f}, 
	{0.278f, 0.136f}, 
	{0.334f, 0.130f}, 
	{0.238f, 0.299f}, 
	{0.237f, 0.302f}, 
	{0.424f, 0.216f}, 
	{0.424f, 0.219f}, 
	{0.424f, 0.222f}, 
	{0.269f, 0.276f}, 
	{0.270f, 0.279f}, 
	{0.192f, 0.186f}, 
	{0.193f, 0.189f}, 
	{0.172f, 0.193f}, 
	{0.171f, 0.189f}, 
	{0.027f, 0.182f}, 
	{0.024f, 0.182f}, 
	{0.259f, 0.023f}, 
	{0.256f, 0.022f}, 
	{0.253f, 0.022f}, 
	{0.084f, 0.062f}, 
	{0.080f, 0.062f}, 
	{0.323f, 0.269f}, 
	{0.114f, 0.301f}, 
	{0.118f, 0.302f}, 
	{0.021f, 0.183f}, 
	{0.033f, 0.190f}, 
	{0.033f, 0.187f}, 
	{0.031f, 0.184f}, 
	{0.250f, 0.023f}, 
	{0.258f, 0.025f}, 
	{0.027f, 0.184f}, 
	{0.083f, 0.064f}, 
	{0.081f, 0.064f}, 
	{0.024f, 0.183f}, 
	{0.115f, 0.299f}, 
	{0.118f, 0.299f}, 
	{0.022f, 0.184f}, 
	{0.021f, 0.187f}, 
	{0.021f, 0.189f}, 
	{0.156f, 0.081f}, 
	{0.084f, 0.107f}, 
	{0.481f, 0.246f}, 
	{0.080f, 0.086f}, 
	{0.157f, 0.086f}, 
	{0.154f, 0.086f}, 
	{0.473f, 0.030f}, 
	{0.476f, 0.029f}, 
	{0.479f, 0.029f}, 
	{0.108f, 0.028f}, 
	{0.105f, 0.028f}, 
	{0.423f, 0.271f}, 
	{0.087f, 0.107f}, 
	{0.083f, 0.109f}, 
	{0.481f, 0.243f}, 
	{0.081f, 0.084f}, 
	{0.084f, 0.086f}, 
	{0.152f, 0.085f}, 
	{0.480f, 0.030f}, 
	{0.472f, 0.029f}, 
	{0.424f, 0.158f}, 
	{0.108f, 0.031f}, 
	{0.105f, 0.030f}, 
	{0.424f, 0.274f}, 
	{0.087f, 0.109f}, 
	{0.481f, 0.241f}, 
	{0.479f, 0.246f}, 
	{0.479f, 0.243f}, 
	{0.346f, 0.185f}, 
	{0.346f, 0.188f}, 
	{0.424f, 0.161f}, 
	{0.425f, 0.154f}, 
	{0.425f, 0.157f}, 
	{0.426f, 0.161f}, 
	{0.424f, 0.276f}, 
	{0.426f, 0.279f}, 
	{0.425f, 0.268f}, 
	{0.425f, 0.270f}, 
	{0.480f, 0.240f}, 
	{0.481f, 0.237f}, 
	{0.424f, 0.248f}, 
	{0.346f, 0.192f}, 
	{0.401f, 0.184f}, 
	{0.401f, 0.187f}, 
	{0.426f, 0.164f}, 
	{0.480f, 0.155f}, 
	{0.481f, 0.158f}, 
	{0.426f, 0.274f}, 
	{0.426f, 0.277f}, 
	{0.481f, 0.279f}, 
	{0.480f, 0.267f}, 
	{0.395f, 0.033f}, 
	{0.056f, 0.135f}, 
	{0.053f, 0.134f}, 
	{0.049f, 0.135f}, 
	{0.401f, 0.191f}, 
	{0.036f, 0.084f}, 
	{0.397f, 0.036f}, 
	{0.409f, 0.034f}, 
	{0.409f, 0.031f}, 
	{0.407f, 0.028f}, 
	{0.404f, 0.026f}, 
	{0.401f, 0.026f}, 
	{0.397f, 0.028f}, 
	{0.056f, 0.136f}, 
	{0.053f, 0.136f}, 
	{0.050f, 0.136f}, 
	{0.401f, 0.193f}, 
	{0.035f, 0.086f}, 
	{0.033f, 0.084f}, 
	{0.395f, 0.030f}, 
	{0.397f, 0.033f}, 
	{0.398f, 0.035f}, 
	{0.401f, 0.037f}, 
	{0.403f, 0.037f}, 
	{0.406f, 0.036f}, 
	{0.441f, 0.088f}, 
	{0.160f, 0.022f}, 
	{0.442f, 0.093f}, 
	{0.439f, 0.093f}, 
	{0.437f, 0.091f}, 
	{0.436f, 0.089f}, 
	{0.022f, 0.385f}, 
	{0.025f, 0.384f}, 
	{0.027f, 0.384f}, 
	{0.029f, 0.385f}, 
	{0.058f, 0.047f}, 
	{0.060f, 0.047f}, 
	{0.157f, 0.022f}, 
	{0.161f, 0.020f}, 
	{0.437f, 0.087f}, 
	{0.438f, 0.084f}, 
	{0.441f, 0.083f}, 
	{0.443f, 0.083f}, 
	{0.021f, 0.383f}, 
	{0.024f, 0.382f}, 
	{0.027f, 0.382f}, 
	{0.030f, 0.383f}, 
	{0.445f, 0.085f}, 
	{0.060f, 0.045f}, 
	{0.157f, 0.020f}, 
	{0.125f, 0.347f}, 
	{0.125f, 0.350f}, 
	{0.126f, 0.347f}, 
	{0.047f, 0.345f}, 
	{0.047f, 0.347f}, 
	{0.048f, 0.350f}, 
	{0.115f, 0.270f}, 
	{0.115f, 0.273f}, 
	{0.192f, 0.276f}, 
	{0.192f, 0.279f}, 
	{0.194f, 0.270f}, 
	{0.194f, 0.273f}, 
	{0.126f, 0.350f}, 
	{0.126f, 0.353f}, 
	{0.126f, 0.344f}, 
	{0.181f, 0.345f}, 
	{0.181f, 0.348f}, 
	{0.049f, 0.354f}, 
	{0.102f, 0.344f}, 
	{0.103f, 0.347f}, 
	{0.115f, 0.276f}, 
	{0.115f, 0.279f}, 
	{0.193f, 0.276f}, 
	{0.193f, 0.279f}, 
	{0.248f, 0.279f}, 
	{0.249f, 0.270f}, 
	{0.024f, 0.321f}, 
	{0.021f, 0.322f}, 
	{0.176f, 0.101f}, 
	{0.440f, 0.030f}, 
	{0.103f, 0.351f}, 
	{0.068f, 0.108f}, 
	{0.065f, 0.108f}, 
	{0.170f, 0.270f}, 
	{0.174f, 0.104f}, 
	{0.033f, 0.322f}, 
	{0.032f, 0.321f}, 
	{0.028f, 0.320f}, 
	{0.025f, 0.323f}, 
	{0.023f, 0.324f}, 
	{0.174f, 0.107f}, 
	{0.446f, 0.031f}, 
	{0.442f, 0.028f}, 
	{0.444f, 0.029f}, 
	{0.065f, 0.109f}, 
	{0.188f, 0.106f}, 
	{0.188f, 0.103f}, 
	{0.032f, 0.324f}, 
	{0.031f, 0.323f}, 
	{0.028f, 0.322f}, 
	{0.179f, 0.101f}, 
	{0.252f, 0.080f}, 
	{0.104f, 0.084f}, 
	{0.246f, 0.078f}, 
	{0.435f, 0.114f}, 
	{0.436f, 0.117f}, 
	{0.248f, 0.076f}, 
	{0.250f, 0.075f}, 
	{0.253f, 0.075f}, 
	{0.255f, 0.076f}, 
	{0.257f, 0.079f}, 
	{0.257f, 0.081f}, 
	{0.108f, 0.084f}, 
	{0.106f, 0.084f}, 
	{0.103f, 0.085f}, 
	{0.423f, 0.187f}, 
	{0.437f, 0.114f}, 
	{0.438f, 0.117f}, 
	{0.255f, 0.083f}, 
	{0.253f, 0.084f}, 
	{0.250f, 0.084f}, 
	{0.248f, 0.083f}, 
	{0.246f, 0.081f}, 
	{0.257f, 0.076f}, 
	{0.259f, 0.078f}, 
	{0.106f, 0.086f}, 
	{0.423f, 0.190f}, 
	{0.423f, 0.192f}, 
	{0.481f, 0.114f}, 
	{0.481f, 0.118f}, 
	{0.273f, 0.158f}, 
	{0.278f, 0.106f}, 
	{0.279f, 0.109f}, 
	{0.307f, 0.302f}, 
	{0.124f, 0.420f}, 
	{0.123f, 0.422f}, 
	{0.122f, 0.426f}, 
	{0.122f, 0.429f}, 
	{0.424f, 0.186f}, 
	{0.424f, 0.190f}, 
	{0.425f, 0.193f}, 
	{0.333f, 0.106f}, 
	{0.334f, 0.109f}, 
	{0.274f, 0.160f}, 
	{0.095f, 0.300f}, 
	{0.091f, 0.300f}, 
	{0.307f, 0.298f}, 
	{0.179f, 0.419f}, 
	{0.178f, 0.422f}, 
	{0.177f, 0.426f}, 
	{0.177f, 0.429f}, 
	{0.424f, 0.184f}, 
	{0.156f, 0.037f}, 
	{0.479f, 0.186f}, 
	{0.094f, 0.302f}, 
	{0.091f, 0.301f}, 
	{0.223f, 0.086f}, 
	{0.225f, 0.083f}, 
	{0.225f, 0.080f}, 
	{0.224f, 0.077f}, 
	{0.220f, 0.076f}, 
	{0.179f, 0.423f}, 
	{0.161f, 0.038f}, 
	{0.158f, 0.037f}, 
	{0.155f, 0.039f}, 
	{0.216f, 0.076f}, 
	{0.157f, 0.039f}, 
	{0.053f, 0.190f},
	{0.212f, 0.083f},
	{0.214f, 0.085f},
	{0.216f, 0.086f},
	{0.219f, 0.086f},
	{0.222f, 0.085f},
	{0.179f, 0.426f},
	{0.178f, 0.428f},
	{0.054f, 0.193f},
	{0.223f, 0.083f},
	{0.218f, 0.050f},
	{0.071f, 0.302f},
	{0.217f, 0.055f},
	{0.055f, 0.190f},
	{0.056f, 0.193f},
	{0.214f, 0.054f},
	{0.479f, 0.140f},
	{0.480f, 0.137f},
	{0.481f, 0.134f},
	{0.212f, 0.052f},
	{0.212f, 0.049f},
	{0.214f, 0.047f},
	{0.068f, 0.302f},
	{0.071f, 0.300f},
	{0.272f, 0.216f},
	{0.100f, 0.189f},
	{0.101f, 0.192f},
	{0.352f, 0.158f},
	{0.477f, 0.139f},
	{0.478f, 0.136f},
	{0.480f, 0.133f},
	{0.216f, 0.046f},
	{0.219f, 0.046f},
	{0.222f, 0.047f},
	{0.067f, 0.300f},
	{0.272f, 0.218f},
	{0.273f, 0.221f},
	{0.436f, 0.138f},
	{0.437f, 0.134f},
	{0.352f, 0.160f},
	{0.279f, 0.083f},
	{0.334f, 0.083f},
	{0.354f, 0.130f},
	{0.333f, 0.086f},
	{0.354f, 0.057f},
	{0.045f, 0.429f},
	{0.045f, 0.419f},
	{0.045f, 0.422f},
	{0.273f, 0.215f},
	{0.274f, 0.218f},
	{0.129f, 0.032f},
	{0.126f, 0.032f},
	{0.352f, 0.163f},
	{0.129f, 0.034f},
	{0.126f, 0.034f},
	{0.354f, 0.133f},
	{0.025f, 0.429f},
	{0.021f, 0.429f},
	{0.045f, 0.426f},
	{0.100f, 0.428f},
	{0.100f, 0.419f},
	{0.025f, 0.427f},
	{0.275f, 0.221f},
	{0.022f, 0.427f},
	{0.101f, 0.160f},
	{0.023f, 0.162f},
	{0.026f, 0.164f},
	{0.030f, 0.164f},
	{0.033f, 0.162f},
	{0.036f, 0.159f},
	{0.037f, 0.156f},
	{0.100f, 0.422f},
	{0.100f, 0.163f},
	{0.099f, 0.160f},
	{0.036f, 0.154f},
	{0.098f, 0.164f},
	{0.057f, 0.160f},
	{0.026f, 0.154f},
	{0.024f, 0.156f},
	{0.023f, 0.159f},
	{0.024f, 0.161f},
	{0.026f, 0.162f},
	{0.029f, 0.162f},
	{0.032f, 0.161f},
	{0.057f, 0.164f},
	{0.034f, 0.159f},
	{0.474f, 0.089f},
	{0.472f, 0.084f},
	{0.470f, 0.086f},
	{0.469f, 0.088f},
	{0.469f, 0.091f},
	{0.471f, 0.093f},
	{0.110f, 0.109f},
	{0.106f, 0.109f},
	{0.474f, 0.094f},
	{0.476f, 0.093f},
	{0.479f, 0.091f},
	{0.479f, 0.089f},
	{0.479f, 0.087f},
	{0.477f, 0.085f},
	{0.474f, 0.084f},
	{0.472f, 0.082f},
	{0.469f, 0.084f},
	{0.468f, 0.088f},
	{0.110f, 0.107f},
	{0.107f, 0.107f},
	{0.468f, 0.091f},
	{0.470f, 0.094f},
	{0.477f, 0.094f},
	{0.480f, 0.092f},
	{0.481f, 0.088f},
	{0.176f, 0.450f},
	{0.178f, 0.453f},
	{0.179f, 0.456f},
	{0.095f, 0.275f},
	{0.095f, 0.278f},
	{0.026f, 0.134f},
	{0.029f, 0.134f},
	{0.201f, 0.324f},
	{0.202f, 0.321f},
	{0.204f, 0.340f},
	{0.203f, 0.352f},
	{0.204f, 0.349f},
	{0.205f, 0.346f},
	{0.179f, 0.459f},
	{0.121f, 0.449f},
	{0.123f, 0.452f},
	{0.094f, 0.272f},
	{0.094f, 0.275f},
	{0.026f, 0.136f},
	{0.029f, 0.136f},
	{0.203f, 0.318f},
	{0.256f, 0.325f},
	{0.205f, 0.343f},
	{0.259f, 0.340f},
	{0.258f, 0.352f},
	{0.259f, 0.350f},
	{0.445f, 0.062f},
	{0.124f, 0.455f},
	{0.128f, 0.068f},
	{0.126f, 0.068f},
	{0.094f, 0.278f},
	{0.129f, 0.066f},
	{0.126f, 0.066f},
	{0.257f, 0.322f},
	{0.447f, 0.051f},
	{0.449f, 0.053f},
	{0.449f, 0.057f},
	{0.447f, 0.060f},
	{0.444f, 0.061f},
	{0.441f, 0.061f},
	{0.187f, 0.031f},
	{0.189f, 0.031f},
	{0.439f, 0.059f},
	{0.191f, 0.031f},
	{0.187f, 0.033f},
	{0.437f, 0.057f},
	{0.437f, 0.055f},
	{0.438f, 0.052f},
	{0.441f, 0.051f},
	{0.443f, 0.051f},
	{0.446f, 0.052f},
	{0.328f, 0.027f},
	{0.058f, 0.084f},
	{0.023f, 0.480f},
	{0.190f, 0.033f},
	{0.192f, 0.033f},
	{0.324f, 0.031f},
	{0.218f, 0.023f},
	{0.221f, 0.024f},
	{0.224f, 0.023f},
	{0.218f, 0.026f},
	{0.222f, 0.026f},
	{0.327f, 0.032f},
	{0.056f, 0.086f},
	{0.060f, 0.086f},
	{0.023f, 0.477f},
	{0.225f, 0.025f},
	{0.097f, 0.222f},
	{0.195f, 0.455f},
	{0.098f, 0.219f},
	{0.042f, 0.222f},
	{0.043f, 0.219f},
	{0.060f, 0.064f},
	{0.057f, 0.064f},
	{0.329f, 0.032f},
	{0.332f, 0.031f},
	{0.023f, 0.475f},
	{0.024f, 0.481f},
	{0.025f, 0.478f},
	{0.195f, 0.453f},
	{0.194f, 0.450f},
	{0.197f, 0.459f},
	{0.106f, 0.375f},
	{0.106f, 0.378f},
	{0.106f, 0.382f},
	{0.105f, 0.385f},
	{0.409f, 0.102f},
	{0.060f, 0.062f},
	{0.057f, 0.062f},
	{0.025f, 0.474f},
	{0.079f, 0.481f},
	{0.080f, 0.478f},
	{0.197f, 0.456f},
	{0.196f, 0.453f},
	{0.196f, 0.450f},
	{0.052f, 0.375f},
	{0.051f, 0.378f},
	{0.051f, 0.381f},
	{0.050f, 0.384f},
	{0.409f, 0.105f},
	{0.159f, 0.108f},
	{0.156f, 0.109f},
	{0.334f, 0.057f},
	{0.333f, 0.060f},
	{0.153f, 0.109f},
	{0.158f, 0.106f},
	{0.196f, 0.447f},
	{0.156f, 0.107f},
	{0.153f, 0.107f},
	{0.152f, 0.106f},
	{0.331f, 0.063f},
	{0.320f, 0.056f},
	{0.323f, 0.054f},
	{0.326f, 0.052f},
	{0.329f, 0.052f},
	{0.332f, 0.054f},
	{0.191f, 0.056f},
	{0.188f, 0.055f},
	{0.332f, 0.058f},
	{0.185f, 0.056f},
	{0.192f, 0.054f},
	{0.188f, 0.053f},
	{0.185f, 0.054f},
	{0.331f, 0.060f},
	{0.330f, 0.062f},
	{0.327f, 0.063f},
	{0.325f, 0.063f},
	{0.293f, 0.059f},
	{0.129f, 0.049f},
	{0.183f, 0.377f},
	{0.183f, 0.379f},
	{0.295f, 0.063f},
	{0.126f, 0.049f},
	{0.129f, 0.051f},
	{0.125f, 0.051f},
	{0.298f, 0.061f},
	{0.299f, 0.059f},
	{0.299f, 0.057f},
	{0.297f, 0.055f},
	{0.024f, 0.248f},
	{0.020f, 0.248f},
	{0.183f, 0.382f},
	{0.181f, 0.376f},
	{0.294f, 0.055f},
	{0.024f, 0.246f},
	{0.021f, 0.246f},
	{0.123f, 0.084f},
	{0.291f, 0.055f},
	{0.288f, 0.057f},
	{0.287f, 0.059f},
	{0.346f, 0.218f},
	{0.126f, 0.083f},
	{0.181f, 0.380f},
	{0.181f, 0.383f},
	{0.181f, 0.385f},
	{0.181f, 0.374f},
	{0.280f, 0.246f},
	{0.043f, 0.459f},
	{0.043f, 0.456f},
	{0.043f, 0.452f},
	{0.043f, 0.449f},
	{0.346f, 0.216f},
	{0.346f, 0.213f},
	{0.126f, 0.376f},
	{0.126f, 0.379f},
	{0.127f, 0.382f},
	{0.127f, 0.385f},
	{0.258f, 0.319f},
	{0.258f, 0.325f},
	{0.281f, 0.243f},
	{0.280f, 0.240f},
	{0.098f, 0.459f},
	{0.098f, 0.456f},
	{0.098f, 0.452f},
	{0.099f, 0.450f},
	{0.347f, 0.222f},
	{0.347f, 0.219f},
	{0.259f, 0.323f},
	{0.112f, 0.126f},
	{0.115f, 0.128f},
	{0.116f, 0.131f},
	{0.116f, 0.134f},
	{0.335f, 0.248f},
	{0.129f, 0.084f},
	{0.124f, 0.086f},
	{0.100f, 0.459f},
	{0.126f, 0.085f},
	{0.128f, 0.086f},
	{0.299f, 0.034f},
	{0.114f, 0.136f},
	{0.103f, 0.129f},
	{0.105f, 0.126f},
	{0.108f, 0.125f},
	{0.111f, 0.127f},
	{0.336f, 0.245f},
	{0.297f, 0.033f},
	{0.294f, 0.033f},
	{0.100f, 0.456f},
	{0.292f, 0.034f},
	{0.301f, 0.032f},
	{0.298f, 0.031f},
	{0.113f, 0.129f},
	{0.114f, 0.131f},
	{0.046f, 0.243f},
	{0.294f, 0.031f},
	{0.291f, 0.032f},
	{0.046f, 0.109f},
	{0.048f, 0.108f},
	{0.050f, 0.109f},
	{0.041f, 0.244f},
	{0.260f, 0.375f},
	{0.260f, 0.377f},
	{0.155f, 0.054f},
	{0.158f, 0.054f},
	{0.160f, 0.054f},
	{0.042f, 0.246f},
	{0.154f, 0.056f},
	{0.157f, 0.057f},
	{0.161f, 0.056f},
	{0.253f, 0.402f},
	{0.253f, 0.406f},
	{0.044f, 0.248f},
	{0.260f, 0.380f},
	{0.259f, 0.372f},
	{0.198f, 0.403f},
	{0.198f, 0.406f},
	{0.196f, 0.406f},
	{0.352f, 0.244f},
	{0.174f, 0.219f},
	{0.174f, 0.221f},
	{0.027f, 0.353f},
	{0.023f, 0.354f},
	{0.105f, 0.317f},
	{0.258f, 0.374f},
	{0.258f, 0.377f},
	{0.258f, 0.381f},
	{0.258f, 0.383f},
	{0.353f, 0.239f},
	{0.354f, 0.248f},
	{0.354f, 0.244f},
	{0.353f, 0.241f},
	{0.172f, 0.215f},
	{0.173f, 0.219f},
	{0.020f, 0.353f},
	{0.026f, 0.351f},
	{0.103f, 0.317f},
	{0.204f, 0.374f},
	{0.203f, 0.376f},
	{0.203f, 0.379f},
	{0.203f, 0.382f},
	{0.408f, 0.238f},
	{0.409f, 0.247f},
	{0.409f, 0.244f},
	{0.408f, 0.240f},
	{0.163f, 0.300f},
	{0.480f, 0.050f},
	{0.024f, 0.351f},
	{0.021f, 0.351f},
	{0.154f, 0.300f},
	{0.481f, 0.053f},
	{0.481f, 0.057f},
	{0.476f, 0.062f},
	{0.473f, 0.062f},
	{0.157f, 0.298f},
	{0.160f, 0.298f},
	{0.162f, 0.301f},
	{0.155f, 0.302f},
	{0.470f, 0.060f},
	{0.157f, 0.300f},
	{0.160f, 0.300f},
	{0.132f, 0.109f},
	{0.469f, 0.057f},
	{0.469f, 0.054f},
	{0.470f, 0.051f},
	{0.478f, 0.051f},
	{0.129f, 0.109f},
	{0.126f, 0.109f},
	{0.132f, 0.108f},
	{0.480f, 0.054f},
	{0.253f, 0.049f},
	{0.128f, 0.107f},
	{0.125f, 0.108f},
	{0.081f, 0.040f},
	{0.083f, 0.040f},
	{0.256f, 0.053f},
	{0.137f, 0.136f},
	{0.136f, 0.133f},
	{0.258f, 0.050f},
	{0.259f, 0.048f},
	{0.258f, 0.046f},
	{0.256f, 0.045f},
	{0.253f, 0.045f},
	{0.081f, 0.042f},
	{0.084f, 0.042f},
	{0.139f, 0.136f},
	{0.138f, 0.132f},
	{0.253f, 0.427f},
	{0.183f, 0.136f},
	{0.182f, 0.133f},
	{0.250f, 0.046f},
	{0.248f, 0.048f},
	{0.247f, 0.050f},
	{0.248f, 0.053f},
	{0.250f, 0.054f},
	{0.403f, 0.273f},
	{0.403f, 0.276f},
	{0.128f, 0.246f},
	{0.127f, 0.248f},
	{0.252f, 0.429f},
	{0.253f, 0.164f},
	{0.253f, 0.160f},
	{0.251f, 0.215f},
	{0.203f, 0.109f},
	{0.203f, 0.107f},
	{0.326f, 0.185f},
	{0.198f, 0.164f},
	{0.198f, 0.161f},
	{0.402f, 0.279f},
	{0.404f, 0.270f},
	{0.120f, 0.163f},
	{0.073f, 0.247f},
	{0.252f, 0.432f},
	{0.196f, 0.163f},
	{0.197f, 0.161f},
	{0.252f, 0.218f},
	{0.203f, 0.245f},
	{0.258f, 0.108f},
	{0.326f, 0.188f},
	{0.326f, 0.192f},
	{0.021f, 0.457f},
	{0.348f, 0.272f},
	{0.348f, 0.276f},
	{0.375f, 0.026f},
	{0.378f, 0.027f},
	{0.380f, 0.030f},
	{0.380f, 0.034f},
	{0.379f, 0.037f},
	{0.025f, 0.456f},
	{0.028f, 0.457f},
	{0.022f, 0.459f},
	{0.271f, 0.186f},
	{0.025f, 0.459f},
	{0.028f, 0.459f},
	{0.369f, 0.028f},
	{0.372f, 0.027f},
	{0.375f, 0.027f},
	{0.377f, 0.028f},
	{0.378f, 0.031f},
	{0.379f, 0.033f},
	{0.377f, 0.036f},
	{0.375f, 0.037f},
	{0.644f, 0.615f},
	{0.641f, 0.587f},
	{0.639f, 0.587f},
	{0.637f, 0.587f},
	{0.636f, 0.587f},
	{0.646f, 0.587f},
	{0.645f, 0.587f},
	{0.643f, 0.587f},
	{0.641f, 0.559f},
	{0.640f, 0.559f},
	{0.638f, 0.559f},
	{0.637f, 0.559f},
	{0.645f, 0.559f},
	{0.644f, 0.559f},
	{0.642f, 0.559f},
	{0.641f, 0.532f},
	{0.640f, 0.532f},
	{0.640f, 0.532f},
	{0.639f, 0.532f},
	{0.643f, 0.532f},
	{0.642f, 0.532f},
	{0.642f, 0.532f},
	{0.603f, 0.612f},
	{0.616f, 0.584f},
	{0.614f, 0.584f},
	{0.612f, 0.584f},
	{0.610f, 0.584f},
	{0.608f, 0.584f},
	{0.606f, 0.584f},
	{0.605f, 0.584f},
	{0.614f, 0.557f},
	{0.613f, 0.556f},
	{0.612f, 0.556f},
	{0.610f, 0.556f},
	{0.609f, 0.556f},
	{0.608f, 0.556f},
	{0.607f, 0.557f},
	{0.612f, 0.530f},
	{0.612f, 0.530f},
	{0.611f, 0.530f},
	{0.610f, 0.530f},
	{0.610f, 0.530f},
	{0.609f, 0.530f},
	{0.608f, 0.530f},
	{0.547f, 0.642f},
	{0.549f, 0.642f},
	{0.550f, 0.642f},
	{0.551f, 0.642f},
	{0.552f, 0.641f},
	{0.553f, 0.641f},
	{0.555f, 0.670f},
	{0.555f, 0.670f},
	{0.556f, 0.670f},
	{0.556f, 0.670f},
	{0.557f, 0.670f},
	{0.558f, 0.669f},
	{0.558f, 0.669f},
	{0.069f, 0.754f},
	{0.066f, 0.742f},
	{0.065f, 0.728f},
	{0.066f, 0.715f},
	{0.069f, 0.702f},
	{0.068f, 0.699f},
	{0.070f, 0.760f},
	{0.068f, 0.755f},
	{0.064f, 0.743f},
	{0.063f, 0.728f},
	{0.065f, 0.715f},
	{0.068f, 0.701f},
	{0.301f, 0.698f},
	{0.300f, 0.757f},
	{0.298f, 0.752f},
	{0.295f, 0.741f},
	{0.294f, 0.726f},
	{0.296f, 0.713f},
	{0.300f, 0.700f},
	{0.299f, 0.697f},
	{0.299f, 0.758f},
	{0.296f, 0.753f},
	{0.293f, 0.741f},
	{0.293f, 0.726f},
	{0.295f, 0.713f},
	{0.298f, 0.700f},
	{0.302f, 0.845f},
	{0.298f, 0.834f},
	{0.296f, 0.828f},
	{0.295f, 0.815f},
	{0.296f, 0.800f},
	{0.299f, 0.788f},
	{0.304f, 0.778f},
	{0.301f, 0.846f},
	{0.296f, 0.835f},
	{0.294f, 0.829f},
	{0.293f, 0.816f},
	{0.294f, 0.800f},
	{0.297f, 0.788f},
	{0.302f, 0.777f},
	{0.149f, 0.646f},
	{0.154f, 0.657f},
	{0.156f, 0.663f},
	{0.158f, 0.676f},
	{0.158f, 0.691f},
	{0.155f, 0.703f},
	{0.150f, 0.714f},
	{0.151f, 0.645f},
	{0.156f, 0.656f},
	{0.158f, 0.663f},
	{0.160f, 0.676f},
	{0.159f, 0.691f},
	{0.156f, 0.704f},
	{0.152f, 0.715f},
	{0.077f, 0.856f},
	{0.088f, 0.867f},
	{0.090f, 0.873f},
	{0.092f, 0.886f},
	{0.091f, 0.900f},
	{0.075f, 0.856f},
	{0.077f, 0.868f},
	{0.078f, 0.875f},
	{0.078f, 0.889f},
	{0.079f, 0.905f},
	{0.073f, 0.856f},
	{0.064f, 0.869f},
	{0.064f, 0.876f},
	{0.063f, 0.889f},
	{0.064f, 0.903f},
	{0.149f, 0.827f},
	{0.149f, 0.840f},
	{0.167f, 0.798f},
	{0.165f, 0.810f},
	{0.164f, 0.817f},
	{0.163f, 0.830f},
	{0.162f, 0.845f},
	{0.170f, 0.798f},
	{0.177f, 0.811f},
	{0.178f, 0.818f},
	{0.178f, 0.830f},
	{0.176f, 0.844f},
	{0.272f, 0.723f},
	{0.275f, 0.737f},
	{0.276f, 0.743f},
	{0.276f, 0.756f},
	{0.274f, 0.770f},
	{0.270f, 0.780f},
	{0.273f, 0.722f},
	{0.277f, 0.736f},
	{0.278f, 0.743f},
	{0.278f, 0.756f},
	{0.276f, 0.770f},
	{0.271f, 0.780f},
	{0.176f, 0.736f},
	{0.176f, 0.739f},
	{0.176f, 0.741f},
	{0.178f, 0.736f},
	{0.178f, 0.739f},
	{0.178f, 0.741f},
	{0.037f, 0.718f},
	{0.047f, 0.730f},
	{0.048f, 0.736f},
	{0.049f, 0.748f},
	{0.048f, 0.761f},
	{0.035f, 0.718f},
	{0.035f, 0.731f},
	{0.035f, 0.738f},
	{0.035f, 0.751f},
	{0.035f, 0.765f},
	{0.032f, 0.718f},
	{0.023f, 0.730f},
	{0.021f, 0.736f},
	{0.020f, 0.748f},
	{0.020f, 0.761f},
	{0.240f, 0.963f},
	{0.241f, 0.976f},
	{0.255f, 0.934f},
	{0.255f, 0.947f},
	{0.255f, 0.953f},
	{0.255f, 0.966f},
	{0.255f, 0.980f},
	{0.257f, 0.934f},
	{0.267f, 0.945f},
	{0.268f, 0.951f},
	{0.269f, 0.963f},
	{0.269f, 0.976f},
	{0.063f, 0.657f},
	{0.066f, 0.668f},
	{0.075f, 0.680f},
	{0.077f, 0.652f},
	{0.077f, 0.663f},
	{0.076f, 0.677f},
	{0.331f, 0.814f},
	{0.330f, 0.801f},
	{0.326f, 0.788f},
	{0.326f, 0.785f},
	{0.156f, 0.540f},
	{0.151f, 0.554f},
	{0.151f, 0.560f},
	{0.152f, 0.571f},
	{0.157f, 0.582f},
	{0.154f, 0.539f},
	{0.150f, 0.554f},
	{0.149f, 0.559f},
	{0.150f, 0.571f},
	{0.155f, 0.583f},
	{0.261f, 0.620f},
	{0.260f, 0.610f},
	{0.256f, 0.595f},
	{0.245f, 0.620f},
	{0.248f, 0.610f},
	{0.254f, 0.597f},
	{0.215f, 0.798f},
	{0.224f, 0.810f},
	{0.225f, 0.817f},
	{0.226f, 0.829f},
	{0.225f, 0.842f},
	{0.212f, 0.798f},
	{0.211f, 0.811f},
	{0.211f, 0.818f},
	{0.211f, 0.832f},
	{0.211f, 0.846f},
	{0.210f, 0.798f},
	{0.200f, 0.810f},
	{0.199f, 0.816f},
	{0.197f, 0.828f},
	{0.198f, 0.841f},
	{0.274f, 0.815f},
	{0.273f, 0.802f},
	{0.261f, 0.846f},
	{0.260f, 0.833f},
	{0.259f, 0.826f},
	{0.259f, 0.813f},
	{0.259f, 0.799f},
	{0.259f, 0.846f},
	{0.249f, 0.835f},
	{0.247f, 0.829f},
	{0.245f, 0.817f},
	{0.245f, 0.804f},
	{0.203f, 0.586f},
	{0.199f, 0.576f},
	{0.075f, 0.841f},
	{0.069f, 0.828f},
	{0.067f, 0.822f},
	{0.065f, 0.809f},
	{0.066f, 0.795f},
	{0.070f, 0.784f},
	{0.077f, 0.775f},
	{0.074f, 0.842f},
	{0.067f, 0.829f},
	{0.065f, 0.823f},
	{0.063f, 0.810f},
	{0.064f, 0.794f},
	{0.069f, 0.783f},
	{0.075f, 0.774f},
	{0.361f, 0.820f},
	{0.361f, 0.831f},
	{0.357f, 0.846f},
	{0.345f, 0.821f},
	{0.349f, 0.832f},
	{0.355f, 0.844f},
	{0.030f, 0.620f},
	{0.024f, 0.606f},
	{0.022f, 0.600f},
	{0.022f, 0.588f},
	{0.024f, 0.575f},
	{0.029f, 0.565f},
	{0.028f, 0.620f},
	{0.022f, 0.607f},
	{0.021f, 0.600f},
	{0.020f, 0.588f},
	{0.023f, 0.574f},
	{0.028f, 0.565f},
	{0.320f, 0.885f},
	{0.322f, 0.897f},
	{0.322f, 0.910f},
	{0.306f, 0.868f},
	{0.307f, 0.881f},
	{0.307f, 0.888f},
	{0.308f, 0.901f},
	{0.308f, 0.915f},
	{0.304f, 0.868f},
	{0.295f, 0.880f},
	{0.294f, 0.886f},
	{0.293f, 0.899f},
	{0.294f, 0.911f},
	{0.369f, 0.873f},
	{0.355f, 0.915f},
	{0.355f, 0.902f},
	{0.355f, 0.895f},
	{0.355f, 0.882f},
	{0.355f, 0.869f},
	{0.353f, 0.915f},
	{0.343f, 0.903f},
	{0.342f, 0.897f},
	{0.341f, 0.885f},
	{0.341f, 0.873f},
	{0.328f, 0.771f},
	{0.327f, 0.769f},
	{0.327f, 0.767f},
	{0.324f, 0.752f},
	{0.325f, 0.747f},
	{0.327f, 0.737f},
	{0.326f, 0.771f},
	{0.325f, 0.769f},
	{0.325f, 0.767f},
	{0.323f, 0.753f},
	{0.323f, 0.747f},
	{0.325f, 0.737f},
	{0.247f, 0.687f},
	{0.250f, 0.697f},
	{0.459f, 0.870f},
	{0.460f, 0.885f},
	{0.461f, 0.891f},
	{0.461f, 0.903f},
	{0.458f, 0.914f},
	{0.460f, 0.870f},
	{0.462f, 0.885f},
	{0.463f, 0.891f},
	{0.463f, 0.903f},
	{0.459f, 0.915f},
	{0.346f, 0.806f},
	{0.348f, 0.791f},
	{0.349f, 0.785f},
	{0.349f, 0.774f},
	{0.345f, 0.762f},
	{0.348f, 0.806f},
	{0.350f, 0.791f},
	{0.351f, 0.785f},
	{0.350f, 0.773f},
	{0.347f, 0.762f},
	{0.078f, 0.980f},
	{0.067f, 0.969f},
	{0.065f, 0.963f},
	{0.063f, 0.949f},
	{0.063f, 0.934f},
	{0.080f, 0.980f},
	{0.079f, 0.969f},
	{0.078f, 0.962f},
	{0.077f, 0.947f},
	{0.076f, 0.931f},
	{0.076f, 0.919f},
	{0.083f, 0.980f},
	{0.091f, 0.967f},
	{0.092f, 0.961f},
	{0.092f, 0.947f},
	{0.091f, 0.932f},
	{0.087f, 0.921f},
	{0.121f, 0.962f},
	{0.121f, 0.948f},
	{0.121f, 0.932f},
	{0.122f, 0.920f},
	{0.117f, 0.980f},
	{0.108f, 0.968f},
	{0.107f, 0.962f},
	{0.106f, 0.949f},
	{0.107f, 0.934f},
	{0.111f, 0.923f},
	{0.206f, 0.699f},
	{0.208f, 0.712f},
	{0.197f, 0.703f},
	{0.208f, 0.714f},
	{0.120f, 0.756f},
	{0.120f, 0.744f},
	{0.118f, 0.730f},
	{0.115f, 0.827f},
	{0.112f, 0.818f},
	{0.112f, 0.805f},
	{0.114f, 0.792f},
	{0.117f, 0.778f},
	{0.178f, 0.710f},
	{0.181f, 0.701f},
	{0.182f, 0.688f},
	{0.180f, 0.676f},
	{0.177f, 0.662f},
	{0.177f, 0.659f},
	{0.223f, 0.748f},
	{0.226f, 0.760f},
	{0.207f, 0.733f},
	{0.210f, 0.747f},
	{0.211f, 0.753f},
	{0.213f, 0.766f},
	{0.215f, 0.779f},
	{0.205f, 0.734f},
	{0.197f, 0.747f},
	{0.197f, 0.753f},
	{0.198f, 0.765f},
	{0.200f, 0.777f},
	{0.162f, 0.765f},
	{0.163f, 0.759f},
	{0.165f, 0.746f},
	{0.166f, 0.733f},
	{0.157f, 0.778f},
	{0.150f, 0.765f},
	{0.149f, 0.759f},
	{0.149f, 0.747f},
	{0.151f, 0.736f},
	{0.357f, 0.969f},
	{0.345f, 0.975f},
	{0.346f, 0.964f},
	{0.354f, 0.952f},
	{0.108f, 0.852f},
	{0.109f, 0.867f},
	{0.109f, 0.872f},
	{0.110f, 0.848f},
	{0.110f, 0.850f},
	{0.110f, 0.852f},
	{0.111f, 0.867f},
	{0.111f, 0.872f},
	{0.198f, 0.549f},
	{0.197f, 0.561f},
	{0.200f, 0.544f},
	{0.200f, 0.547f},
	{0.200f, 0.549f},
	{0.199f, 0.561f},
	{0.178f, 0.578f},
	{0.177f, 0.565f},
	{0.178f, 0.580f},
	{0.178f, 0.583f},
	{0.276f, 0.604f},
	{0.275f, 0.605f},
	{0.276f, 0.620f},
	{0.370f, 0.582f},
	{0.371f, 0.584f},
	{0.370f, 0.598f},
	{0.375f, 0.830f},
	{0.391f, 0.830f},
	{0.378f, 0.829f},
	{0.327f, 0.980f},
	{0.245f, 0.566f},
	{0.255f, 0.556f},
	{0.253f, 0.555f},
	{0.293f, 0.632f},
	{0.303f, 0.643f},
	{0.301f, 0.644f},
	{0.133f, 0.713f},
	{0.135f, 0.712f},
	{0.134f, 0.697f},
	{0.274f, 0.667f},
	{0.272f, 0.666f},
	{0.274f, 0.651f},
	{0.229f, 0.710f},
	{0.229f, 0.695f},
	{0.229f, 0.712f},
	{0.229f, 0.714f},
	{0.231f, 0.710f},
	{0.230f, 0.695f},
	{0.231f, 0.712f},
	{0.230f, 0.714f},
	{0.372f, 0.979f},
	{0.388f, 0.980f},
	{0.375f, 0.980f},
	{0.107f, 0.687f},
	{0.226f, 0.950f},
	{0.225f, 0.965f},
	{0.222f, 0.977f},
	{0.212f, 0.929f},
	{0.212f, 0.936f},
	{0.212f, 0.950f},
	{0.212f, 0.967f},
	{0.212f, 0.980f},
	{0.200f, 0.930f},
	{0.198f, 0.937f},
	{0.197f, 0.950f},
	{0.198f, 0.966f},
	{0.201f, 0.977f},
	{0.258f, 0.915f},
	{0.272f, 0.867f},
	{0.273f, 0.873f},
	{0.274f, 0.886f},
	{0.273f, 0.901f},
	{0.269f, 0.912f},
	{0.224f, 0.774f},
	{0.224f, 0.777f},
	{0.224f, 0.779f},
	{0.226f, 0.774f},
	{0.226f, 0.777f},
	{0.226f, 0.779f},
	{0.030f, 0.529f},
	{0.030f, 0.527f},
	{0.029f, 0.531f},
	{0.029f, 0.546f},
	{0.029f, 0.529f},
	{0.020f, 0.537f},
	{0.028f, 0.527f},
	{0.109f, 0.895f},
	{0.121f, 0.906f},
	{0.271f, 0.568f},
	{0.271f, 0.581f},
	{0.273f, 0.564f},
	{0.273f, 0.566f},
	{0.272f, 0.568f},
	{0.273f, 0.581f},
	{0.032f, 0.980f},
	{0.022f, 0.968f},
	{0.021f, 0.962f},
	{0.020f, 0.949f},
	{0.021f, 0.933f},
	{0.024f, 0.922f},
	{0.034f, 0.980f},
	{0.034f, 0.970f},
	{0.034f, 0.963f},
	{0.034f, 0.948f},
	{0.034f, 0.932f},
	{0.034f, 0.919f},
	{0.046f, 0.968f},
	{0.048f, 0.962f},
	{0.049f, 0.949f},
	{0.049f, 0.933f},
	{0.045f, 0.922f},
	{0.035f, 0.874f},
	{0.035f, 0.857f},
	{0.035f, 0.845f},
	{0.023f, 0.893f},
	{0.021f, 0.887f},
	{0.020f, 0.874f},
	{0.020f, 0.859f},
	{0.024f, 0.848f},
	{0.305f, 0.533f},
	{0.303f, 0.546f},
	{0.434f, 0.979f},
	{0.447f, 0.980f},
	{0.444f, 0.966f},
	{0.446f, 0.967f},
	{0.406f, 0.938f},
	{0.419f, 0.938f},
	{0.415f, 0.951f},
	{0.418f, 0.951f},
	{0.397f, 0.602f},
	{0.399f, 0.600f},
	{0.398f, 0.585f},
	{0.135f, 0.557f},
	{0.133f, 0.555f},
	{0.135f, 0.541f},
	{0.401f, 0.693f},
	{0.401f, 0.690f},
	{0.407f, 0.977f},
	{0.406f, 0.979f},
	{0.410f, 0.976f},
	{0.419f, 0.966f},
	{0.409f, 0.978f},
	{0.420f, 0.980f},
	{0.408f, 0.980f},
	{0.466f, 0.964f},
	{0.323f, 0.687f},
	{0.324f, 0.673f},
	{0.434f, 0.947f},
	{0.446f, 0.948f},
	{0.445f, 0.934f},
	{0.470f, 0.793f},
	{0.459f, 0.806f},
	{0.468f, 0.795f},
	{0.064f, 0.621f},
	{0.073f, 0.609f},
	{0.046f, 0.781f},
	{0.047f, 0.787f},
	{0.049f, 0.800f},
	{0.049f, 0.816f},
	{0.047f, 0.828f},
	{0.033f, 0.779f},
	{0.034f, 0.786f},
	{0.035f, 0.801f},
	{0.035f, 0.818f},
	{0.036f, 0.831f},
	{0.022f, 0.782f},
	{0.021f, 0.788f},
	{0.020f, 0.802f},
	{0.021f, 0.817f},
	{0.025f, 0.829f},
	{0.224f, 0.913f},
	{0.225f, 0.907f},
	{0.226f, 0.894f},
	{0.225f, 0.879f},
	{0.223f, 0.867f},
	{0.212f, 0.915f},
	{0.212f, 0.908f},
	{0.212f, 0.894f},
	{0.212f, 0.878f},
	{0.212f, 0.865f},
	{0.200f, 0.913f},
	{0.198f, 0.907f},
	{0.197f, 0.894f},
	{0.198f, 0.878f},
	{0.201f, 0.867f},
	{0.064f, 0.583f},
	{0.075f, 0.577f},
	{0.063f, 0.571f},
	{0.073f, 0.575f},
	{0.438f, 0.699f},
	{0.427f, 0.699f},
	{0.427f, 0.687f},
	{0.410f, 0.667f},
	{0.401f, 0.655f},
	{0.409f, 0.664f},
	{0.472f, 0.622f},
	{0.472f, 0.620f},
	{0.165f, 0.980f},
	{0.151f, 0.931f},
	{0.150f, 0.938f},
	{0.149f, 0.951f},
	{0.150f, 0.966f},
	{0.155f, 0.978f},
	{0.163f, 0.910f},
	{0.176f, 0.862f},
	{0.177f, 0.868f},
	{0.178f, 0.881f},
	{0.178f, 0.896f},
	{0.174f, 0.908f},
	{0.436f, 0.667f},
	{0.427f, 0.655f},
	{0.424f, 0.667f},
	{0.465f, 0.738f},
	{0.455f, 0.738f},
	{0.355f, 0.743f},
	{0.345f, 0.743f},
	{0.346f, 0.728f},
	{0.474f, 0.836f},
	{0.465f, 0.846f},
	{0.398f, 0.567f},
	{0.397f, 0.553f},
	{0.398f, 0.550f},
	{0.418f, 0.599f},
	{0.418f, 0.602f},
	{0.370f, 0.625f},
	{0.378f, 0.634f},
	{0.106f, 0.655f},
	{0.115f, 0.643f},
	{0.397f, 0.621f},
	{0.407f, 0.621f},
	{0.220f, 0.552f},
	{0.230f, 0.561f},
	{0.219f, 0.550f},
	{0.230f, 0.548f},
	{0.092f, 0.839f},
	{0.091f, 0.842f},
	{0.370f, 0.560f},
	{0.371f, 0.563f},
	{0.370f, 0.667f},
	{0.379f, 0.667f},
	{0.438f, 0.587f},
	{0.437f, 0.602f},
	{0.428f, 0.726f},
	{0.436f, 0.738f},
	{0.345f, 0.641f},
	{0.345f, 0.628f},
	{0.346f, 0.625f},
	{0.091f, 0.760f},
	{0.092f, 0.747f},
	{0.091f, 0.744f},
	{0.272f, 0.545f},
	{0.272f, 0.532f},
	{0.468f, 0.686f},
	{0.457f, 0.687f},
	{0.323f, 0.654f},
	{0.046f, 0.662f},
	{0.418f, 0.566f},
	{0.106f, 0.812f},
	{0.461f, 0.667f},
	{0.450f, 0.667f},
	{0.453f, 0.656f},
	{0.345f, 0.935f},
	{0.345f, 0.937f},
	{0.426f, 0.861f},
	{0.423f, 0.861f},
	{0.424f, 0.871f},
	{0.437f, 0.625f},
	{0.426f, 0.622f},
	{0.426f, 0.634f},
	{0.295f, 0.943f},
	{0.293f, 0.944f},
	{0.023f, 0.673f},
	{0.022f, 0.674f},
	{0.325f, 0.619f},
	{0.323f, 0.619f},
	{0.325f, 0.609f},
	{0.106f, 0.609f},
	{0.120f, 0.609f},
	{0.383f, 0.791f},
	{0.370f, 0.792f},
	{0.306f, 0.588f},
	{0.293f, 0.588f},
	{0.446f, 0.832f},
	{0.323f, 0.709f},
	{0.165f, 0.618f},
	{0.163f, 0.631f},
	{0.106f, 0.538f},
	{0.377f, 0.718f},
	{0.106f, 0.590f},
	{0.119f, 0.587f},
	{0.046f, 0.977f},
	{0.049f, 0.977f},
	{0.370f, 0.772f},
	{0.370f, 0.757f},
	{0.293f, 0.560f},
	{0.293f, 0.574f},
	{0.333f, 0.133f},
	{0.333f, 0.136f},
	{0.323f, 0.273f},
	{0.324f, 0.276f},
	{0.325f, 0.278f},
	{0.325f, 0.270f},
	{0.325f, 0.272f},
	{0.325f, 0.275f},
	{0.480f, 0.213f},
	{0.479f, 0.216f},
	{0.479f, 0.220f},
	{0.479f, 0.222f},
	{0.481f, 0.214f},
	{0.481f, 0.216f},
	{0.481f, 0.219f},
	{0.194f, 0.193f},
	{0.247f, 0.186f},
	{0.248f, 0.190f},
	{0.249f, 0.193f},
	{0.275f, 0.323f},
	{0.479f, 0.316f},
	{0.277f, 0.385f},
	{0.481f, 0.378f},
	{0.347f, 0.279f},
	{0.349f, 0.269f},
	{0.347f, 0.272f},
	{0.346f, 0.275f},
	{0.345f, 0.277f},
	{0.170f, 0.273f},
	{0.170f, 0.276f},
	{0.170f, 0.279f},
	{0.172f, 0.270f},
	{0.172f, 0.273f},
	{0.172f, 0.275f},
	{0.104f, 0.353f},
	{0.104f, 0.348f},
	{0.105f, 0.350f},
	{0.348f, 0.216f},
	{0.348f, 0.213f},
	{0.403f, 0.213f},
	{0.402f, 0.222f},
	{0.403f, 0.219f},
	{0.403f, 0.216f},
	{0.114f, 0.133f},
	{0.113f, 0.135f},
	{0.110f, 0.136f},
	{0.107f, 0.136f},
	{0.105f, 0.135f},
	{0.104f, 0.132f},
	{0.104f, 0.130f},
	{0.106f, 0.128f},
	{0.108f, 0.127f},
	{0.109f, 0.132f},
	{0.288f, 0.061f},
	{0.290f, 0.063f},
	{0.292f, 0.063f},
	{0.301f, 0.059f},
	{0.300f, 0.056f},
	{0.298f, 0.054f},
	{0.290f, 0.054f},
	{0.287f, 0.056f},
	{0.285f, 0.059f},
	{0.286f, 0.062f},
	{0.479f, 0.189f},
	{0.480f, 0.192f},
	{0.479f, 0.184f},
	{0.481f, 0.187f},
	{0.481f, 0.189f},
	{0.481f, 0.192f},
	{0.252f, 0.222f},
	{0.196f, 0.216f},
	{0.197f, 0.219f},
	{0.197f, 0.222f},
	{0.194f, 0.217f},
	{0.195f, 0.219f},
	{0.252f, 0.459f},
	{0.252f, 0.457f},
	{0.251f, 0.453f},
	{0.251f, 0.450f},
	{0.251f, 0.448f},
	{0.253f, 0.456f},
	{0.253f, 0.453f},
	{0.252f, 0.451f},
	{0.100f, 0.426f},
	{0.102f, 0.420f},
	{0.102f, 0.423f},
	{0.102f, 0.425f},
	{0.480f, 0.056f},
	{0.478f, 0.059f},
	{0.476f, 0.060f},
	{0.473f, 0.060f},
	{0.471f, 0.059f},
	{0.470f, 0.057f},
	{0.470f, 0.054f},
	{0.471f, 0.052f},
	{0.473f, 0.050f},
	{0.476f, 0.050f},
	{0.475f, 0.055f},
	{0.047f, 0.248f},
	{0.050f, 0.247f},
	{0.051f, 0.244f},
	{0.051f, 0.242f},
	{0.050f, 0.240f},
	{0.047f, 0.238f},
	{0.045f, 0.238f},
	{0.042f, 0.240f},
	{0.041f, 0.242f},
	{0.039f, 0.244f},
	{0.051f, 0.247f},
	{0.053f, 0.245f},
	{0.053f, 0.241f},
	{0.039f, 0.241f},
	{0.124f, 0.458f},
	{0.120f, 0.450f},
	{0.121f, 0.453f},
	{0.122f, 0.455f},
	{0.353f, 0.136f},
	{0.409f, 0.129f},
	{0.409f, 0.132f},
	{0.408f, 0.135f},
	{0.335f, 0.241f},
	{0.335f, 0.238f},
	{0.337f, 0.244f},
	{0.337f, 0.241f},
	{0.260f, 0.346f},
	{0.260f, 0.343f},
	{0.322f, 0.062f},
	{0.321f, 0.060f},
	{0.322f, 0.057f},
	{0.323f, 0.055f},
	{0.326f, 0.054f},
	{0.329f, 0.054f},
	{0.331f, 0.055f},
	{0.327f, 0.059f},
	{0.333f, 0.028f},
	{0.334f, 0.026f},
	{0.333f, 0.024f},
	{0.330f, 0.023f},
	{0.328f, 0.023f},
	{0.325f, 0.024f},
	{0.323f, 0.026f},
	{0.323f, 0.029f},
	{0.323f, 0.032f},
	{0.323f, 0.023f},
	{0.321f, 0.026f},
	{0.321f, 0.029f},
	{0.181f, 0.352f},
	{0.182f, 0.354f},
	{0.183f, 0.351f},
	{0.308f, 0.295f},
	{0.252f, 0.301f},
	{0.252f, 0.298f},
	{0.253f, 0.295f},
	{0.353f, 0.157f},
	{0.354f, 0.160f},
	{0.354f, 0.164f},
	{0.408f, 0.156f},
	{0.409f, 0.159f},
	{0.409f, 0.163f},
	{0.248f, 0.273f},
	{0.248f, 0.276f},
	{0.151f, 0.082f},
	{0.151f, 0.080f},
	{0.152f, 0.078f},
	{0.155f, 0.076f},
	{0.158f, 0.076f},
	{0.160f, 0.078f},
	{0.161f, 0.080f},
	{0.161f, 0.082f},
	{0.159f, 0.085f},
	{0.149f, 0.083f},
	{0.149f, 0.080f},
	{0.151f, 0.077f},
	{0.407f, 0.034f},
	{0.407f, 0.031f},
	{0.406f, 0.029f},
	{0.404f, 0.028f},
	{0.401f, 0.028f},
	{0.398f, 0.029f},
	{0.397f, 0.031f},
	{0.402f, 0.032f},
	{0.328f, 0.216f},
	{0.329f, 0.219f},
	{0.330f, 0.222f},
	{0.330f, 0.216f},
	{0.330f, 0.219f},
	{0.331f, 0.221f},
	{0.100f, 0.454f},
	{0.251f, 0.426f},
	{0.251f, 0.429f},
	{0.251f, 0.432f},
	{0.196f, 0.421f},
	{0.196f, 0.425f},
	{0.196f, 0.428f},
	{0.409f, 0.108f},
	{0.354f, 0.102f},
	{0.354f, 0.106f},
	{0.354f, 0.109f},
	{0.186f, 0.086f},
	{0.184f, 0.085f},
	{0.182f, 0.082f},
	{0.182f, 0.080f},
	{0.183f, 0.077f},
	{0.186f, 0.076f},
	{0.183f, 0.086f},
	{0.181f, 0.083f},
	{0.181f, 0.079f},
	{0.182f, 0.076f},
	{0.023f, 0.191f},
	{0.025f, 0.193f},
	{0.027f, 0.193f},
	{0.030f, 0.192f},
	{0.031f, 0.190f},
	{0.031f, 0.187f},
	{0.030f, 0.185f},
	{0.026f, 0.188f},
	{0.260f, 0.320f},
	{0.104f, 0.320f},
	{0.104f, 0.323f},
	{0.048f, 0.318f},
	{0.049f, 0.321f},
	{0.049f, 0.324f},
	{0.271f, 0.190f},
	{0.271f, 0.193f},
	{0.269f, 0.187f},
	{0.269f, 0.190f},
	{0.269f, 0.192f},
	{0.447f, 0.087f},
	{0.446f, 0.089f},
	{0.445f, 0.091f},
	{0.438f, 0.094f},
	{0.435f, 0.092f},
	{0.434f, 0.089f},
	{0.435f, 0.086f},
	{0.437f, 0.083f},
	{0.447f, 0.083f},
	{0.448f, 0.086f},
	{0.448f, 0.089f},
	{0.177f, 0.102f},
	{0.175f, 0.104f},
	{0.175f, 0.106f},
	{0.177f, 0.108f},
	{0.180f, 0.109f},
	{0.183f, 0.109f},
	{0.185f, 0.108f},
	{0.187f, 0.106f},
	{0.187f, 0.104f},
	{0.185f, 0.102f},
	{0.183f, 0.101f},
	{0.181f, 0.105f},
	{0.080f, 0.475f},
	{0.203f, 0.385f},
	{0.275f, 0.157f},
	{0.275f, 0.161f},
	{0.276f, 0.164f},
	{0.330f, 0.157f},
	{0.330f, 0.160f},
	{0.331f, 0.163f},
	{0.331f, 0.157f},
	{0.332f, 0.160f},
	{0.480f, 0.270f},
	{0.480f, 0.273f},
	{0.481f, 0.277f},
	{0.223f, 0.049f},
	{0.223f, 0.052f},
	{0.222f, 0.054f},
	{0.219f, 0.055f},
	{0.223f, 0.046f},
	{0.225f, 0.049f},
	{0.225f, 0.052f},
	{0.223f, 0.054f},
	{0.220f, 0.056f},
	{0.223f, 0.081f},
	{0.222f, 0.079f},
	{0.219f, 0.077f},
	{0.216f, 0.077f},
	{0.214f, 0.079f},
	{0.212f, 0.080f},
	{0.218f, 0.082f},
	{0.424f, 0.244f},
	{0.425f, 0.241f},
	{0.426f, 0.238f},
	{0.050f, 0.375f},
	{0.050f, 0.378f},
	{0.403f, 0.185f},
	{0.402f, 0.187f},
	{0.402f, 0.190f},
	{0.259f, 0.082f},
	{0.257f, 0.084f},
	{0.254f, 0.086f},
	{0.250f, 0.086f},
	{0.247f, 0.084f},
	{0.245f, 0.081f},
	{0.035f, 0.156f},
	{0.034f, 0.154f},
	{0.032f, 0.153f},
	{0.029f, 0.153f},
	{0.029f, 0.158f},
	{0.173f, 0.222f},
	{0.117f, 0.216f},
	{0.118f, 0.219f},
	{0.118f, 0.222f},
	{0.481f, 0.162f},
	{0.039f, 0.273f},
	{0.039f, 0.276f},
	{0.039f, 0.279f},
	{0.037f, 0.273f},
	{0.037f, 0.276f},
	{0.037f, 0.278f},
	{0.372f, 0.037f},
	{0.370f, 0.035f},
	{0.368f, 0.033f},
	{0.368f, 0.031f},
	{0.373f, 0.032f},
	{0.253f, 0.054f},
	{0.257f, 0.054f},
	{0.249f, 0.045f},
	{0.246f, 0.048f},
	{0.245f, 0.051f},
	{0.246f, 0.054f},
	{0.249f, 0.055f},
	{0.253f, 0.055f},
	{0.203f, 0.136f},
	{0.258f, 0.136f},
	{0.481f, 0.294f},
	{0.323f, 0.294f},
	{0.481f, 0.302f},
	{0.323f, 0.302f},
	{0.176f, 0.164f},
	{0.177f, 0.161f},
	{0.354f, 0.079f},
	{0.409f, 0.080f},
	{0.447f, 0.054f},
	{0.447f, 0.057f},
	{0.446f, 0.059f},
	{0.442f, 0.056f},
	{0.480f, 0.085f},
	{0.478f, 0.083f},
	{0.475f, 0.082f},
	{0.354f, 0.059f},
	{0.409f, 0.058f},
	{0.135f, 0.316f},
	{0.183f, 0.316f},
	{0.135f, 0.324f},
	{0.183f, 0.324f},
	{0.148f, 0.245f},
	{0.148f, 0.248f},
	{0.104f, 0.047f},
	{0.105f, 0.045f},
	{0.108f, 0.047f},
	{0.052f, 0.300f},
	{0.049f, 0.300f},
	{0.049f, 0.302f},
	{0.076f, 0.133f},
	{0.088f, 0.133f},
	{0.256f, 0.024f},
	{0.251f, 0.025f},
	{0.476f, 0.027f},
	{0.481f, 0.028f},
	{0.447f, 0.029f},
	{0.449f, 0.028f}
};

const unsigned short p_tex_face[][3] = {
	{6, 61, 36},
	{36, 62, 6},
	{0, 64, 36},
	{36, 61, 0},
	{1, 63, 36},
	{36, 64, 1},
	{7, 62, 36},
	{36, 63, 7},
	{7, 63, 37},
	{37, 65, 7},
	{1, 67, 37},
	{37, 63, 1},
	{2, 66, 37},
	{37, 67, 2},
	{8, 65, 37},
	{37, 66, 8},
	{8, 66, 38},
	{38, 68, 8},
	{2, 70, 38},
	{38, 66, 2},
	{3, 69, 38},
	{38, 70, 3},
	{9, 68, 38},
	{38, 69, 9},
	{9, 69, 39},
	{39, 71, 9},
	{3, 73, 39},
	{39, 69, 3},
	{4, 72, 39},
	{39, 73, 4},
	{10, 71, 39},
	{39, 72, 10},
	{10, 72, 40},
	{40, 74, 10},
	{4, 76, 40},
	{40, 72, 4},
	{5, 75, 40},
	{40, 76, 5},
	{11, 74, 40},
	{40, 75, 11},
	{12, 77, 41},
	{41, 78, 12},
	{6, 62, 41},
	{41, 77, 6},
	{7, 79, 41},
	{41, 62, 7},
	{13, 78, 41},
	{41, 79, 13},
	{13, 79, 42},
	{42, 80, 13},
	{7, 65, 42},
	{42, 79, 7},
	{8, 81, 42},
	{42, 65, 8},
	{14, 80, 42},
	{42, 81, 14},
	{14, 81, 43},
	{43, 82, 14},
	{8, 68, 43},
	{43, 81, 8},
	{9, 83, 43},
	{43, 68, 9},
	{15, 82, 43},
	{43, 83, 15},
	{15, 83, 44},
	{44, 84, 15},
	{9, 71, 44},
	{44, 83, 9},
	{10, 85, 44},
	{44, 71, 10},
	{16, 84, 44},
	{44, 85, 16},
	{16, 85, 45},
	{45, 86, 16},
	{10, 74, 45},
	{45, 85, 10},
	{11, 87, 45},
	{45, 74, 11},
	{17, 86, 45},
	{45, 87, 17},
	{18, 88, 46},
	{46, 89, 18},
	{12, 78, 46},
	{46, 88, 12},
	{13, 90, 46},
	{46, 78, 13},
	{19, 89, 46},
	{46, 90, 19},
	{19, 90, 47},
	{47, 91, 19},
	{13, 80, 47},
	{47, 90, 13},
	{14, 92, 47},
	{47, 80, 14},
	{20, 91, 47},
	{47, 92, 20},
	{20, 92, 48},
	{48, 93, 20},
	{14, 82, 48},
	{48, 92, 14},
	{15, 94, 48},
	{48, 82, 15},
	{21, 93, 48},
	{48, 94, 21},
	{21, 94, 49},
	{49, 95, 21},
	{15, 84, 49},
	{49, 94, 15},
	{16, 96, 49},
	{49, 84, 16},
	{22, 95, 49},
	{49, 96, 22},
	{22, 96, 50},
	{50, 97, 22},
	{16, 86, 50},
	{50, 96, 16},
	{17, 98, 50},
	{50, 86, 17},
	{23, 97, 50},
	{50, 98, 23},
	{24, 99, 51},
	{51, 100, 24},
	{18, 89, 51},
	{51, 99, 18},
	{19, 101, 51},
	{51, 89, 19},
	{25, 100, 51},
	{51, 101, 25},
	{25, 101, 52},
	{52, 102, 25},
	{19, 91, 52},
	{52, 101, 19},
	{20, 103, 52},
	{52, 91, 20},
	{26, 102, 52},
	{52, 103, 26},
	{26, 103, 53},
	{53, 104, 26},
	{20, 93, 53},
	{53, 103, 20},
	{21, 105, 53},
	{53, 93, 21},
	{27, 104, 53},
	{53, 105, 27},
	{27, 105, 54},
	{54, 106, 27},
	{21, 95, 54},
	{54, 105, 21},
	{22, 107, 54},
	{54, 95, 22},
	{28, 106, 54},
	{54, 107, 28},
	{28, 107, 55},
	{55, 108, 28},
	{22, 97, 55},
	{55, 107, 22},
	{23, 109, 55},
	{55, 97, 23},
	{29, 108, 55},
	{55, 109, 29},
	{30, 110, 56},
	{56, 111, 30},
	{24, 100, 56},
	{56, 110, 24},
	{25, 112, 56},
	{56, 100, 25},
	{31, 111, 56},
	{56, 112, 31},
	{31, 112, 57},
	{57, 113, 31},
	{25, 102, 57},
	{57, 112, 25},
	{26, 114, 57},
	{57, 102, 26},
	{32, 113, 57},
	{57, 114, 32},
	{32, 114, 58},
	{58, 115, 32},
	{26, 104, 58},
	{58, 114, 26},
	{27, 116, 58},
	{58, 104, 27},
	{33, 115, 58},
	{58, 116, 33},
	{33, 116, 59},
	{59, 117, 33},
	{27, 106, 59},
	{59, 116, 27},
	{28, 118, 59},
	{59, 106, 28},
	{34, 117, 59},
	{59, 118, 34},
	{34, 118, 60},
	{60, 119, 34},
	{28, 108, 60},
	{60, 118, 28},
	{29, 120, 60},
	{60, 108, 29},
	{35, 119, 60},
	{60, 120, 35},
	{121, 123, 122},
	{121, 124, 123},
	{121, 125, 124},
	{121, 126, 125},
	{121, 127, 126},
	{121, 128, 127},
	{121, 129, 128},
	{121, 130, 129},
	{121, 131, 130},
	{121, 132, 131},
	{121, 133, 132},
	{121, 134, 133},
	{121, 135, 134},
	{121, 136, 135},
	{121, 137, 136},
	{121, 138, 137},
	{121, 139, 138},
	{121, 140, 139},
	{121, 141, 140},
	{121, 142, 141},
	{121, 143, 142},
	{121, 144, 143},
	{121, 145, 144},
	{121, 122, 145},
	{146, 192, 172},
	{146, 147, 192},
	{147, 193, 192},
	{147, 148, 193},
	{148, 194, 193},
	{148, 168, 194},
	{149, 174, 173},
	{149, 150, 174},
	{150, 175, 174},
	{150, 151, 175},
	{151, 176, 175},
	{151, 152, 176},
	{152, 177, 176},
	{152, 153, 177},
	{153, 178, 177},
	{153, 154, 178},
	{154, 179, 178},
	{154, 155, 179},
	{156, 183, 182},
	{156, 157, 183},
	{157, 184, 183},
	{157, 158, 184},
	{158, 204, 184},
	{158, 159, 204},
	{159, 205, 204},
	{159, 160, 205},
	{160, 206, 205},
	{160, 180, 206},
	{180, 207, 206},
	{180, 181, 207},
	{161, 186, 185},
	{161, 162, 186},
	{162, 187, 186},
	{162, 163, 187},
	{163, 188, 187},
	{163, 164, 188},
	{164, 189, 188},
	{164, 165, 189},
	{165, 190, 189},
	{165, 166, 190},
	{166, 191, 190},
	{166, 167, 191},
	{169, 196, 195},
	{169, 170, 196},
	{170, 216, 196},
	{170, 171, 216},
	{171, 172, 216},
	{171, 146, 172},
	{172, 218, 217},
	{172, 192, 218},
	{192, 219, 218},
	{192, 193, 219},
	{193, 220, 219},
	{193, 194, 220},
	{173, 198, 197},
	{173, 174, 198},
	{174, 199, 198},
	{174, 175, 199},
	{175, 200, 199},
	{175, 176, 200},
	{176, 201, 200},
	{176, 177, 201},
	{177, 202, 201},
	{177, 178, 202},
	{178, 203, 202},
	{178, 179, 203},
	{182, 228, 208},
	{182, 183, 228},
	{183, 229, 228},
	{183, 184, 229},
	{184, 230, 229},
	{184, 204, 230},
	{204, 231, 230},
	{204, 205, 231},
	{205, 232, 231},
	{205, 206, 232},
	{206, 1484, 232},
	{206, 207, 1484},
	{185, 210, 209},
	{185, 186, 210},
	{186, 211, 210},
	{186, 187, 211},
	{187, 212, 211},
	{187, 188, 212},
	{188, 213, 212},
	{188, 189, 213},
	{189, 214, 213},
	{189, 190, 214},
	{190, 215, 214},
	{190, 191, 215},
	{195, 241, 240},
	{195, 196, 241},
	{196, 1462, 241},
	{196, 216, 1462},
	{216, 217, 1462},
	{216, 172, 217},
	{217, 1464, 1463},
	{217, 218, 1464},
	{218, 1465, 1464},
	{218, 219, 1465},
	{219, 1466, 1465},
	{219, 220, 1466},
	{197, 222, 221},
	{197, 198, 222},
	{198, 223, 222},
	{198, 199, 223},
	{199, 224, 223},
	{199, 200, 224},
	{200, 225, 224},
	{200, 201, 225},
	{201, 226, 225},
	{201, 202, 226},
	{202, 227, 226},
	{202, 203, 227},
	{208, 1486, 1485},
	{208, 228, 1486},
	{228, 1487, 1486},
	{228, 229, 1487},
	{229, 1488, 1487},
	{229, 230, 1488},
	{230, 1489, 1488},
	{230, 231, 1489},
	{231, 1490, 1489},
	{231, 232, 1490},
	{232, 1491, 1490},
	{232, 1484, 1491},
	{209, 234, 233},
	{209, 210, 234},
	{210, 235, 234},
	{210, 211, 235},
	{211, 236, 235},
	{211, 212, 236},
	{212, 237, 236},
	{212, 213, 237},
	{213, 238, 237},
	{213, 214, 238},
	{214, 239, 238},
	{214, 215, 239},
	{240, 1468, 1467},
	{240, 241, 1468},
	{241, 1469, 1468},
	{241, 1462, 1469},
	{1462, 1463, 1469},
	{1462, 217, 1463},
	{1463, 1471, 1470},
	{1463, 1464, 1471},
	{1464, 1472, 1471},
	{1464, 1465, 1472},
	{1465, 1473, 1472},
	{1465, 1466, 1473},
	{221, 269, 268},
	{221, 222, 269},
	{222, 270, 269},
	{222, 223, 270},
	{223, 271, 270},
	{223, 224, 271},
	{224, 272, 271},
	{224, 225, 272},
	{225, 273, 272},
	{225, 226, 273},
	{226, 274, 273},
	{226, 227, 274},
	{1485, 1493, 1492},
	{1485, 1486, 1493},
	{1486, 1494, 1493},
	{1486, 1487, 1494},
	{1487, 1495, 1494},
	{1487, 1488, 1495},
	{1488, 1496, 1495},
	{1488, 1489, 1496},
	{1489, 1497, 1496},
	{1489, 1490, 1497},
	{1490, 1498, 1497},
	{1490, 1491, 1498},
	{233, 1506, 282},
	{233, 234, 1506},
	{234, 1507, 1506},
	{234, 235, 1507},
	{235, 1508, 1507},
	{235, 236, 1508},
	{236, 1509, 1508},
	{236, 237, 1509},
	{237, 1510, 1509},
	{237, 238, 1510},
	{238, 1511, 1510},
	{238, 239, 1511},
	{1467, 1475, 1474},
	{1467, 1468, 1475},
	{1468, 1476, 1475},
	{1468, 1469, 1476},
	{1469, 1470, 1476},
	{1469, 1463, 1470},
	{1470, 1478, 1477},
	{1470, 1471, 1478},
	{1471, 1479, 1478},
	{1471, 1472, 1479},
	{1472, 1480, 1479},
	{1472, 1473, 1480},
	{268, 276, 275},
	{268, 269, 276},
	{269, 277, 276},
	{269, 270, 277},
	{270, 278, 277},
	{270, 271, 278},
	{271, 279, 278},
	{271, 272, 279},
	{272, 280, 279},
	{272, 273, 280},
	{273, 281, 280},
	{273, 274, 281},
	{1492, 1500, 1499},
	{1492, 1493, 1500},
	{1493, 1501, 1500},
	{1493, 1494, 1501},
	{1494, 1502, 1501},
	{1494, 1495, 1502},
	{1495, 1503, 1502},
	{1495, 1496, 1503},
	{1496, 1504, 1503},
	{1496, 1497, 1504},
	{1497, 1505, 1504},
	{1497, 1498, 1505},
	{282, 1513, 1512},
	{282, 1506, 1513},
	{1506, 1514, 1513},
	{1506, 1507, 1514},
	{1507, 1515, 1514},
	{1507, 1508, 1515},
	{1508, 1516, 1515},
	{1508, 1509, 1516},
	{1509, 1517, 1516},
	{1509, 1510, 1517},
	{1510, 1518, 1517},
	{1510, 1511, 1518},
	{1474, 1482, 1481},
	{1474, 1475, 1482},
	{1475, 1483, 1482},
	{1475, 1476, 1483},
	{1476, 1477, 1483},
	{1476, 1470, 1477},
	{266, 242, 243},
	{266, 243, 244},
	{266, 244, 245},
	{266, 245, 246},
	{266, 246, 247},
	{266, 247, 248},
	{266, 248, 249},
	{266, 249, 250},
	{266, 250, 251},
	{266, 251, 252},
	{266, 252, 253},
	{266, 253, 254},
	{266, 254, 255},
	{266, 255, 256},
	{266, 256, 257},
	{266, 257, 258},
	{266, 258, 259},
	{266, 259, 260},
	{266, 260, 261},
	{266, 261, 262},
	{266, 262, 263},
	{266, 263, 264},
	{266, 264, 265},
	{266, 265, 242},
	{307, 1590, 1591},
	{1591, 314, 307},
	{314, 1591, 1592},
	{1592, 321, 314},
	{321, 1592, 1593},
	{1593, 1588, 321},
	{1588, 1593, 1594},
	{1594, 1589, 1588},
	{306, 2134, 2135},
	{1888, 305, 304},
	{305, 1888, 1889},
	{1889, 311, 305},
	{1590, 1595, 1596},
	{1596, 1591, 1590},
	{1591, 1596, 1597},
	{1597, 1592, 1591},
	{1592, 1597, 1598},
	{1598, 1593, 1592},
	{1593, 1598, 1599},
	{1599, 1594, 1593},
	{312, 318, 319},
	{2126, 2125, 2124},
	{313, 319, 320},
	{1890, 1889, 1888},
	{1573, 1574, 1579},
	{1579, 1578, 1573},
	{1574, 1575, 1580},
	{1580, 1579, 1574},
	{1575, 1576, 1581},
	{1581, 1580, 1575},
	{1576, 1577, 1582},
	{1582, 1581, 1576},
	{309, 310, 1891},
	{2137, 2136, 308},
	{310, 317, 1892},
	{1892, 1891, 310},
	{1578, 1579, 1584},
	{1584, 1583, 1578},
	{1579, 1580, 1585},
	{1585, 1584, 1579},
	{1580, 1581, 1586},
	{1586, 1585, 1580},
	{1581, 1582, 1587},
	{1587, 1586, 1581},
	{2116, 2117, 2118},
	{323, 322, 315},
	{1891, 1892, 1893},
	{324, 323, 316},
	{290, 291, 299},
	{299, 298, 290},
	{291, 292, 300},
	{300, 299, 291},
	{292, 293, 301},
	{301, 300, 292},
	{293, 294, 1768},
	{1768, 301, 293},
	{294, 297, 1769},
	{1769, 1768, 294},
	{284, 287, 295},
	{295, 288, 284},
	{285, 2129, 2130},
	{296, 295, 287},
	{267, 1523, 1530},
	{1530, 1524, 267},
	{1523, 1522, 1529},
	{1529, 1530, 1523},
	{1522, 1521, 1528},
	{1528, 1529, 1522},
	{1521, 1520, 1527},
	{1527, 1528, 1521},
	{1520, 1519, 1526},
	{1526, 1527, 1520},
	{1519, 283, 1525},
	{1525, 1526, 1519},
	{1869, 1868, 1872},
	{1872, 1873, 1869},
	{1868, 289, 1871},
	{1871, 1872, 1868},
	{289, 286, 1870},
	{1870, 1871, 289},
	{348, 1635, 1636},
	{1636, 355, 348},
	{355, 1636, 1637},
	{1637, 362, 355},
	{362, 1637, 1638},
	{1638, 1633, 362},
	{1633, 1638, 1639},
	{1639, 1634, 1633},
	{302, 346, 347},
	{347, 303, 302},
	{345, 359, 1908},
	{1908, 352, 345},
	{1635, 1640, 1641},
	{1641, 1636, 1635},
	{1636, 1641, 1642},
	{1642, 1637, 1636},
	{1637, 1642, 1643},
	{1643, 1638, 1637},
	{1638, 1643, 1644},
	{1644, 1639, 1638},
	{361, 2070, 2071},
	{360, 354, 353},
	{359, 1909, 1910},
	{1910, 1908, 359},
	{1618, 1619, 1624},
	{1624, 1623, 1618},
	{1619, 1620, 1625},
	{1625, 1624, 1619},
	{1620, 1621, 1626},
	{1626, 1625, 1620},
	{1621, 1622, 1627},
	{1627, 1626, 1621},
	{349, 350, 2139},
	{2139, 2138, 349},
	{351, 358, 1884},
	{1884, 365, 351},
	{1623, 1624, 1629},
	{1629, 1628, 1623},
	{1624, 1625, 1630},
	{1630, 1629, 1624},
	{1625, 1626, 1631},
	{1631, 1630, 1625},
	{1626, 1627, 1632},
	{1632, 1631, 1626},
	{356, 357, 364},
	{2097, 2096, 363},
	{365, 1884, 1886},
	{1886, 1885, 365},
	{331, 332, 339},
	{339, 338, 331},
	{332, 333, 340},
	{340, 339, 332},
	{333, 334, 341},
	{341, 340, 333},
	{334, 335, 342},
	{342, 341, 334},
	{335, 336, 343},
	{343, 342, 335},
	{336, 337, 344},
	{344, 343, 336},
	{326, 327, 2127},
	{329, 328, 325},
	{327, 330, 2128},
	{2128, 2127, 327},
	{1551, 1550, 1557},
	{1557, 1558, 1551},
	{1550, 1549, 1556},
	{1556, 1557, 1550},
	{1549, 1548, 1555},
	{1555, 1556, 1549},
	{1548, 1547, 1554},
	{1554, 1555, 1548},
	{1547, 1546, 1553},
	{1553, 1554, 1547},
	{1546, 1545, 1552},
	{1552, 1553, 1546},
	{1614, 1613, 1616},
	{1616, 1617, 1614},
	{1613, 1612, 1615},
	{1615, 1616, 1613},
	{2131, 2132, 2133},
	{2140, 392, 391},
	{388, 397, 402},
	{402, 389, 388},
	{389, 402, 403},
	{403, 390, 389},
	{390, 403, 404},
	{404, 395, 390},
	{395, 404, 1925},
	{1925, 396, 395},
	{668, 1977, 1978},
	{2107, 2106, 2105},
	{1897, 1898, 1899},
	{2083, 2082, 405},
	{397, 1926, 1927},
	{1927, 402, 397},
	{402, 1927, 1928},
	{1928, 403, 402},
	{403, 1928, 1929},
	{1929, 404, 403},
	{404, 1929, 1930},
	{1930, 1925, 404},
	{401, 2075, 2076},
	{2141, 400, 393},
	{386, 387, 394},
	{2123, 2122, 2121},
	{610, 611, 1916},
	{1916, 1915, 610},
	{611, 1912, 1917},
	{1917, 1916, 611},
	{1912, 1913, 1918},
	{1918, 1917, 1912},
	{1913, 1914, 1919},
	{1919, 1918, 1913},
	{2102, 2103, 2104},
	{2007, 2006, 2005},
	{2047, 2048, 2049},
	{1896, 1895, 1894},
	{1915, 1916, 1921},
	{1921, 1920, 1915},
	{1916, 1917, 1922},
	{1922, 1921, 1916},
	{1917, 1918, 1923},
	{1923, 1922, 1917},
	{1918, 1919, 1924},
	{1924, 1923, 1918},
	{398, 399, 406},
	{1828, 1827, 381},
	{1780, 1781, 1786},
	{1786, 1785, 1780},
	{1781, 1782, 1787},
	{1787, 1786, 1781},
	{1782, 1783, 1788},
	{1788, 1787, 1782},
	{1783, 1784, 1789},
	{1789, 1788, 1783},
	{366, 367, 377},
	{377, 376, 366},
	{367, 369, 378},
	{378, 377, 367},
	{369, 370, 383},
	{383, 378, 369},
	{372, 380, 1828},
	{1828, 382, 372},
	{380, 379, 1827},
	{1827, 1828, 380},
	{379, 375, 1826},
	{1826, 1827, 379},
	{375, 374, 1825},
	{1825, 1826, 375},
	{374, 373, 1824},
	{1824, 1825, 374},
	{1862, 1861, 1866},
	{1866, 1867, 1862},
	{1861, 1860, 1865},
	{1865, 1866, 1861},
	{1860, 371, 1864},
	{1864, 1865, 1860},
	{371, 368, 1863},
	{1863, 1864, 371},
	{443, 447, 1847},
	{1847, 444, 443},
	{444, 1847, 1848},
	{1848, 445, 444},
	{445, 1848, 1849},
	{1849, 446, 445},
	{429, 436, 2142},
	{2142, 435, 429},
	{435, 2142, 2143},
	{2084, 434, 428},
	{434, 2084, 2085},
	{2054, 2053, 427},
	{447, 1851, 1852},
	{1852, 1847, 447},
	{1847, 1852, 1853},
	{1853, 1848, 1847},
	{1848, 1853, 1854},
	{1854, 1849, 1848},
	{1849, 1854, 1855},
	{1855, 1850, 1849},
	{1665, 1668, 1669},
	{1669, 1666, 1665},
	{1666, 1669, 1670},
	{1670, 1667, 1666},
	{441, 442, 1838},
	{1838, 1837, 441},
	{442, 1835, 1839},
	{1839, 1838, 442},
	{1835, 1836, 1840},
	{1840, 1839, 1835},
	{430, 431, 438},
	{438, 437, 430},
	{426, 1817, 1819},
	{439, 438, 431},
	{432, 433, 440},
	{1820, 1819, 1817},
	{1837, 1838, 1843},
	{1843, 1842, 1837},
	{1838, 1839, 1844},
	{1844, 1843, 1838},
	{1839, 1840, 1845},
	{1845, 1844, 1839},
	{1840, 1841, 1846},
	{1846, 1845, 1840},
	{1714, 1715, 1718},
	{1718, 1717, 1714},
	{1715, 1716, 1719},
	{1719, 1718, 1715},
	{413, 414, 1875},
	{1875, 1874, 413},
	{415, 416, 424},
	{424, 423, 415},
	{416, 417, 425},
	{425, 424, 416},
	{417, 418, 426},
	{426, 425, 417},
	{418, 419, 1817},
	{1817, 426, 418},
	{419, 422, 1818},
	{1818, 1817, 419},
	{407, 410, 2120},
	{2120, 2119, 407},
	{408, 409, 412},
	{412, 411, 408},
	{1706, 1705, 1712},
	{1712, 1713, 1706},
	{1705, 1704, 1711},
	{1711, 1712, 1705},
	{1704, 1703, 1710},
	{1710, 1711, 1704},
	{1703, 1702, 1709},
	{1709, 1710, 1703},
	{1702, 1701, 1708},
	{1708, 1709, 1702},
	{1701, 1700, 1707},
	{1707, 1708, 1701},
	{421, 420, 1876},
	{1876, 1877, 421},
	{420, 413, 1874},
	{1874, 1876, 420},
	{471, 485, 486},
	{486, 477, 471},
	{477, 486, 1807},
	{1807, 478, 477},
	{478, 1807, 1808},
	{1808, 479, 478},
	{479, 1808, 1809},
	{1809, 484, 479},
	{484, 1809, 1810},
	{2144, 470, 469},
	{1983, 1984, 1985},
	{2115, 475, 468},
	{485, 1811, 1812},
	{1812, 486, 485},
	{486, 1812, 1813},
	{1813, 1807, 486},
	{1807, 1813, 1814},
	{1814, 1808, 1807},
	{1808, 1814, 1815},
	{1815, 1809, 1808},
	{1809, 1815, 1816},
	{1816, 1810, 1809},
	{476, 482, 483},
	{1986, 1985, 1984},
	{1790, 1791, 1796},
	{1796, 1795, 1790},
	{1791, 1792, 1797},
	{1797, 1796, 1791},
	{1792, 1793, 1798},
	{1798, 1797, 1792},
	{1793, 1794, 1799},
	{1799, 1798, 1793},
	{472, 473, 2145},
	{1800, 1799, 1794},
	{474, 481, 2114},
	{1981, 1980, 1979},
	{1795, 1796, 1802},
	{1802, 1801, 1795},
	{1796, 1797, 1803},
	{1803, 1802, 1796},
	{1797, 1798, 1804},
	{1804, 1803, 1797},
	{1798, 1799, 1805},
	{1805, 1804, 1798},
	{1799, 1800, 1806},
	{1806, 1805, 1799},
	{1980, 1981, 1982},
	{488, 487, 480},
	{454, 455, 463},
	{463, 462, 454},
	{455, 456, 464},
	{464, 463, 455},
	{456, 457, 465},
	{465, 464, 456},
	{457, 458, 1698},
	{1698, 465, 457},
	{458, 461, 1699},
	{1699, 1698, 458},
	{459, 460, 467},
	{2109, 2108, 466},
	{448, 449, 452},
	{452, 451, 448},
	{1531, 1537, 1544},
	{1544, 1538, 1531},
	{1537, 1536, 1543},
	{1543, 1544, 1537},
	{1536, 1535, 1542},
	{1542, 1543, 1536},
	{1535, 1534, 1541},
	{1541, 1542, 1535},
	{1534, 1533, 1540},
	{1540, 1541, 1534},
	{1533, 1532, 1539},
	{1539, 1540, 1533},
	{1947, 1946, 1950},
	{1950, 1951, 1947},
	{1946, 453, 1949},
	{1949, 1950, 1946},
	{453, 450, 1948},
	{1948, 1949, 453},
	{512, 1746, 1747},
	{1747, 519, 512},
	{519, 1747, 1748},
	{1748, 525, 519},
	{525, 1748, 1749},
	{1749, 526, 525},
	{526, 1749, 1750},
	{1750, 1745, 526},
	{511, 518, 2011},
	{2011, 517, 511},
	{517, 2011, 2012},
	{516, 510, 509},
	{1746, 1751, 1752},
	{1752, 1747, 1746},
	{1747, 1752, 1753},
	{1753, 1748, 1747},
	{1748, 1753, 1754},
	{1754, 1749, 1748},
	{1749, 1754, 1755},
	{1755, 1750, 1749},
	{1645, 1648, 1649},
	{1649, 1646, 1645},
	{1646, 1649, 1650},
	{1650, 1647, 1646},
	{523, 524, 1736},
	{1736, 1735, 523},
	{524, 1732, 1737},
	{1737, 1736, 524},
	{1732, 1733, 1738},
	{1738, 1737, 1732},
	{1733, 1734, 1739},
	{1739, 1738, 1733},
	{508, 513, 1944},
	{1944, 521, 508},
	{514, 515, 522},
	{1945, 1944, 513},
	{1735, 1736, 1741},
	{1741, 1740, 1735},
	{1736, 1737, 1742},
	{1742, 1741, 1736},
	{1737, 1738, 1743},
	{1743, 1742, 1737},
	{1738, 1739, 1744},
	{1744, 1743, 1738},
	{527, 528, 1822},
	{1822, 1821, 527},
	{528, 529, 1823},
	{1823, 1822, 528},
	{1900, 1901, 1905},
	{1905, 1904, 1900},
	{497, 498, 506},
	{506, 505, 497},
	{498, 499, 507},
	{507, 506, 498},
	{499, 500, 508},
	{508, 507, 499},
	{500, 501, 513},
	{513, 508, 500},
	{501, 504, 520},
	{520, 513, 501},
	{489, 490, 493},
	{493, 492, 489},
	{490, 491, 494},
	{494, 493, 490},
	{2098, 496, 2099},
	{502, 503, 495},
	{1725, 1724, 1730},
	{1730, 1731, 1725},
	{1724, 1723, 1729},
	{1729, 1730, 1724},
	{1723, 1722, 1728},
	{1728, 1729, 1723},
	{1722, 1721, 1727},
	{1727, 1728, 1722},
	{1721, 1720, 1726},
	{1726, 1727, 1721},
	{1903, 1902, 1906},
	{1906, 1907, 1903},
	{1902, 1900, 1904},
	{1904, 1906, 1902},
	{552, 566, 567},
	{567, 553, 552},
	{553, 567, 568},
	{568, 554, 553},
	{554, 568, 1969},
	{1969, 559, 554},
	{559, 1969, 1970},
	{1970, 560, 559},
	{560, 1970, 1971},
	{1971, 561, 560},
	{564, 2043, 2044},
	{2113, 551, 550},
	{1881, 1882, 1883},
	{2147, 2146, 563},
	{567, 1972, 1973},
	{1973, 568, 567},
	{568, 1973, 1974},
	{1974, 1969, 568},
	{1969, 1974, 1975},
	{1975, 1970, 1969},
	{1970, 1975, 1976},
	{1976, 1971, 1970},
	{2043, 2045, 2046},
	{2046, 2044, 2043},
	{1952, 1953, 1959},
	{1959, 1958, 1952},
	{1953, 1954, 1960},
	{1960, 1959, 1953},
	{1954, 1955, 1961},
	{1961, 1960, 1954},
	{1955, 1956, 1962},
	{1962, 1961, 1955},
	{1956, 1957, 1963},
	{1963, 1962, 1956},
	{555, 556, 2112},
	{1993, 385, 384},
	{557, 558, 565},
	{1880, 1879, 1878},
	{1959, 1960, 1965},
	{1965, 1964, 1959},
	{1960, 1961, 1966},
	{1966, 1965, 1960},
	{1961, 1962, 1967},
	{1967, 1966, 1961},
	{1962, 1963, 1968},
	{1968, 1967, 1962},
	{385, 1993, 1994},
	{570, 569, 562},
	{536, 537, 544},
	{544, 543, 536},
	{537, 538, 545},
	{545, 544, 537},
	{538, 539, 546},
	{546, 545, 538},
	{539, 540, 547},
	{547, 546, 539},
	{540, 541, 548},
	{548, 547, 540},
	{541, 542, 549},
	{549, 548, 541},
	{530, 533, 2149},
	{2149, 2148, 530},
	{531, 532, 535},
	{535, 534, 531},
	{1565, 1564, 1571},
	{1571, 1572, 1565},
	{1564, 1563, 1570},
	{1570, 1571, 1564},
	{1563, 1562, 1569},
	{1569, 1570, 1563},
	{1562, 1561, 1568},
	{1568, 1569, 1562},
	{1561, 1560, 1567},
	{1567, 1568, 1561},
	{1560, 1559, 1566},
	{1566, 1567, 1560},
	{1933, 1932, 1935},
	{1935, 1936, 1933},
	{1932, 1931, 1934},
	{1934, 1935, 1932},
	{594, 1688, 1689},
	{1689, 601, 594},
	{601, 1689, 1690},
	{1690, 608, 601},
	{608, 1690, 1691},
	{1691, 1686, 608},
	{1686, 1691, 1692},
	{1692, 1687, 1686},
	{593, 1857, 1858},
	{1858, 1856, 593},
	{1856, 1858, 1859},
	{598, 592, 591},
	{1688, 1693, 1694},
	{1694, 1689, 1688},
	{1689, 1694, 1695},
	{1695, 1690, 1689},
	{1690, 1695, 1696},
	{1696, 1691, 1690},
	{1691, 1696, 1697},
	{1697, 1692, 1691},
	{599, 606, 607},
	{607, 600, 599},
	{600, 607, 1911},
	{1911, 605, 600},
	{1671, 1672, 1677},
	{1677, 1676, 1671},
	{1672, 1673, 1678},
	{1678, 1677, 1672},
	{1673, 1674, 1679},
	{1679, 1678, 1673},
	{1674, 1675, 1680},
	{1680, 1679, 1674},
	{583, 588, 595},
	{595, 590, 583},
	{596, 597, 604},
	{1887, 595, 588},
	{1676, 1677, 1682},
	{1682, 1681, 1676},
	{1677, 1678, 1683},
	{1683, 1682, 1677},
	{1678, 1679, 1684},
	{1684, 1683, 1678},
	{1679, 1680, 1685},
	{1685, 1684, 1679},
	{584, 585, 603},
	{603, 602, 584},
	{585, 586, 609},
	{609, 603, 585},
	{1655, 1656, 1661},
	{1661, 1660, 1655},
	{1656, 1657, 1662},
	{1662, 1661, 1656},
	{1657, 1658, 1663},
	{1663, 1662, 1657},
	{1658, 1659, 1664},
	{1664, 1663, 1658},
	{571, 574, 588},
	{588, 583, 571},
	{574, 581, 589},
	{589, 588, 574},
	{581, 582, 1887},
	{1887, 589, 581},
	{572, 573, 576},
	{576, 575, 572},
	{580, 579, 603},
	{603, 609, 580},
	{579, 578, 602},
	{602, 603, 579},
	{578, 577, 587},
	{587, 602, 578},
	{1761, 1760, 1766},
	{1766, 1767, 1761},
	{1760, 1759, 1765},
	{1765, 1766, 1760},
	{1759, 1758, 1764},
	{1764, 1765, 1759},
	{1758, 1757, 1763},
	{1763, 1764, 1758},
	{1757, 1756, 1762},
	{1762, 1763, 1757},
	{2088, 2090, 2091},
	{2091, 2089, 2088},
	{2028, 2033, 2034},
	{2034, 2029, 2028},
	{2029, 2034, 2035},
	{2035, 2030, 2029},
	{2030, 2035, 2036},
	{2036, 2031, 2030},
	{2031, 2036, 2037},
	{2037, 2032, 2031},
	{633, 2150, 2151},
	{2081, 2080, 632},
	{1990, 1991, 1992},
	{2153, 2152, 651},
	{2033, 2038, 2039},
	{2039, 2034, 2033},
	{2034, 2039, 2040},
	{2040, 2035, 2034},
	{2035, 2040, 2041},
	{2041, 2036, 2035},
	{2036, 2041, 2042},
	{2042, 2037, 2036},
	{646, 2051, 2052},
	{2052, 2050, 646},
	{1997, 1998, 2000},
	{2000, 1999, 1997},
	{634, 635, 648},
	{648, 643, 634},
	{635, 636, 649},
	{649, 648, 635},
	{636, 641, 650},
	{650, 649, 636},
	{641, 642, 2055},
	{2055, 650, 641},
	{638, 2092, 2093},
	{645, 644, 637},
	{639, 640, 647},
	{1989, 1988, 1987},
	{643, 648, 2057},
	{2057, 2056, 643},
	{648, 649, 2058},
	{2058, 2057, 648},
	{649, 650, 2059},
	{2059, 2058, 649},
	{650, 2055, 2060},
	{2060, 2059, 650},
	{617, 618, 625},
	{625, 619, 617},
	{612, 615, 1998},
	{1998, 1997, 612},
	{620, 621, 630},
	{630, 629, 620},
	{621, 622, 631},
	{631, 630, 621},
	{622, 623, 1651},
	{1651, 631, 622},
	{623, 624, 1652},
	{1652, 1651, 623},
	{624, 627, 1653},
	{1653, 1652, 624},
	{627, 628, 1654},
	{1654, 1653, 627},
	{613, 616, 625},
	{625, 618, 613},
	{616, 614, 619},
	{619, 625, 616},
	{1605, 1604, 1610},
	{1610, 1611, 1605},
	{1604, 1603, 1609},
	{1609, 1610, 1604},
	{1603, 1602, 1608},
	{1608, 1609, 1603},
	{1602, 1601, 1607},
	{1607, 1608, 1602},
	{1601, 1600, 1606},
	{1606, 1607, 1601},
	{1996, 1995, 1999},
	{1999, 2001, 1996},
	{1995, 612, 1997},
	{1997, 1999, 1995},
	{679, 685, 686},
	{2069, 2068, 2067},
	{675, 684, 689},
	{689, 676, 675},
	{676, 689, 690},
	{690, 677, 676},
	{677, 690, 691},
	{691, 682, 677},
	{682, 691, 2061},
	{2061, 683, 682},
	{2072, 2073, 2074},
	{2095, 2094, 674},
	{693, 2003, 2004},
	{2111, 2110, 692},
	{684, 2062, 2063},
	{2063, 689, 684},
	{689, 2063, 2064},
	{2064, 690, 689},
	{690, 2064, 2065},
	{2065, 691, 690},
	{691, 2065, 2066},
	{2066, 2061, 691},
	{687, 2009, 2010},
	{2010, 2008, 687},
	{1939, 1940, 1942},
	{681, 680, 673},
	{2013, 2014, 2019},
	{2019, 2018, 2013},
	{2014, 2015, 2020},
	{2020, 2019, 2014},
	{2015, 2016, 2021},
	{2021, 2020, 2015},
	{2016, 2017, 2022},
	{2022, 2021, 2016},
	{2077, 2078, 2079},
	{2101, 2100, 678},
	{688, 2086, 2087},
	{2002, 652, 626},
	{2018, 2019, 2024},
	{2024, 2023, 2018},
	{2019, 2020, 2025},
	{2025, 2024, 2019},
	{2020, 2021, 2026},
	{2026, 2025, 2020},
	{2021, 2022, 2027},
	{2027, 2026, 2021},
	{659, 660, 667},
	{667, 666, 659},
	{653, 656, 1940},
	{1940, 1939, 653},
	{662, 663, 1829},
	{1829, 672, 662},
	{663, 664, 1830},
	{1830, 1829, 663},
	{664, 665, 1831},
	{1831, 1830, 664},
	{665, 669, 1832},
	{1832, 1831, 665},
	{669, 670, 1833},
	{1833, 1832, 669},
	{670, 671, 1834},
	{1834, 1833, 670},
	{654, 658, 667},
	{667, 660, 654},
	{658, 657, 666},
	{666, 667, 658},
	{657, 655, 661},
	{661, 666, 657},
	{1774, 1773, 1778},
	{1778, 1779, 1774},
	{1773, 1772, 1777},
	{1777, 1778, 1773},
	{1772, 1771, 1776},
	{1776, 1777, 1772},
	{1771, 1770, 1775},
	{1775, 1776, 1771},
	{1938, 1937, 1941},
	{1941, 1943, 1938},
	{1937, 653, 1939},
	{1939, 1941, 1937},
	{702, 704, 705},
	{705, 703, 702},
	{2173, 2174, 2176},
	{2176, 2175, 2173},
	{698, 699, 701},
	{701, 700, 698},
	{2495, 2496, 2498},
	{2498, 2497, 2495},
	{2479, 2478, 2480},
	{2480, 2481, 2479},
	{695, 694, 696},
	{696, 697, 695},
	{706, 715, 716},
	{706, 716, 717},
	{706, 717, 727},
	{706, 727, 728},
	{706, 728, 729},
	{706, 729, 2352},
	{706, 2352, 2353},
	{706, 2353, 2354},
	{706, 2354, 2355},
	{706, 2355, 2356},
	{706, 2356, 2357},
	{706, 2357, 715},
	{707, 720, 721},
	{707, 721, 708},
	{708, 721, 730},
	{708, 730, 709},
	{709, 730, 2507},
	{709, 2507, 718},
	{710, 722, 723},
	{710, 723, 711},
	{735, 748, 749},
	{735, 749, 736},
	{712, 724, 725},
	{712, 725, 713},
	{713, 725, 726},
	{713, 726, 714},
	{2353, 2358, 2359},
	{2353, 2359, 2354},
	{2354, 2359, 2360},
	{2354, 2360, 2355},
	{2355, 2360, 2361},
	{2355, 2361, 2356},
	{740, 754, 2169},
	{740, 2169, 741},
	{719, 2508, 720},
	{719, 720, 707},
	{731, 745, 2154},
	{731, 2154, 732},
	{732, 2154, 2155},
	{732, 2155, 744},
	{733, 746, 747},
	{734, 2477, 2476},
	{737, 2162, 2163},
	{737, 2163, 748},
	{748, 2163, 2164},
	{748, 2164, 749},
	{749, 2164, 2165},
	{749, 2165, 750},
	{738, 764, 2156},
	{738, 2156, 739},
	{739, 2156, 2157},
	{739, 2157, 751},
	{751, 2157, 2158},
	{751, 2158, 752},
	{753, 2170, 2171},
	{753, 2171, 754},
	{754, 2171, 2172},
	{754, 2172, 2169},
	{742, 756, 755},
	{2484, 2485, 743},
	{757, 773, 776},
	{757, 776, 758},
	{758, 776, 779},
	{758, 779, 767},
	{759, 772, 2509},
	{759, 2509, 760},
	{2162, 2166, 2167},
	{2162, 2167, 2163},
	{2163, 2167, 2168},
	{761, 2510, 771},
	{762, 774, 775},
	{762, 775, 763},
	{764, 2159, 2160},
	{764, 2160, 2156},
	{2156, 2160, 2161},
	{2156, 2161, 2157},
	{765, 777, 778},
	{765, 778, 766},
	{768, 2366, 2367},
	{768, 2367, 769},
	{769, 2367, 2368},
	{769, 2368, 770},
	{770, 2368, 773},
	{770, 773, 757},
	{773, 2369, 776},
	{776, 2369, 779},
	{779, 2369, 780},
	{780, 2369, 781},
	{781, 2369, 2362},
	{2362, 2369, 2363},
	{2363, 2369, 2364},
	{2364, 2369, 2365},
	{2365, 2369, 2366},
	{2366, 2369, 2367},
	{2367, 2369, 2368},
	{2368, 2369, 773},
	{782, 786, 787},
	{782, 787, 799},
	{782, 799, 2315},
	{782, 2315, 2316},
	{782, 2316, 2317},
	{782, 2317, 2318},
	{782, 2318, 2319},
	{782, 2319, 2320},
	{782, 2320, 2321},
	{782, 2321, 2322},
	{782, 2322, 2323},
	{782, 2323, 786},
	{784, 808, 809},
	{784, 809, 796},
	{796, 809, 820},
	{796, 820, 807},
	{785, 797, 798},
	{799, 2324, 2315},
	{2315, 2324, 2325},
	{2315, 2325, 2316},
	{2316, 2325, 2326},
	{2316, 2326, 2317},
	{788, 801, 2511},
	{788, 2511, 789},
	{802, 814, 815},
	{802, 815, 812},
	{812, 815, 826},
	{790, 2512, 800},
	{791, 803, 804},
	{791, 804, 792},
	{793, 819, 829},
	{793, 829, 805},
	{805, 829, 830},
	{805, 830, 816},
	{794, 806, 795},
	{794, 795, 783},
	{808, 822, 2433},
	{808, 2433, 809},
	{809, 2433, 2434},
	{809, 2434, 820},
	{820, 2434, 2435},
	{820, 2435, 821},
	{810, 824, 825},
	{810, 825, 811},
	{811, 825, 837},
	{811, 837, 823},
	{823, 837, 849},
	{813, 827, 814},
	{814, 827, 828},
	{814, 828, 815},
	{815, 828, 2456},
	{815, 2456, 826},
	{818, 832, 2414},
	{818, 2414, 819},
	{819, 2414, 2415},
	{819, 2415, 829},
	{829, 2415, 2416},
	{829, 2416, 830},
	{830, 2416, 831},
	{830, 831, 817},
	{833, 853, 854},
	{833, 854, 839},
	{834, 846, 847},
	{834, 847, 835},
	{835, 847, 848},
	{835, 848, 836},
	{824, 2438, 2439},
	{824, 2439, 825},
	{825, 2439, 2440},
	{825, 2440, 837},
	{838, 850, 851},
	{840, 2328, 841},
	{841, 2328, 2329},
	{841, 2329, 842},
	{842, 2329, 2330},
	{842, 2330, 843},
	{843, 2330, 2331},
	{843, 2331, 844},
	{844, 2331, 2332},
	{844, 2332, 845},
	{845, 2332, 2333},
	{845, 2333, 852},
	{852, 2333, 853},
	{852, 853, 833},
	{853, 2334, 854},
	{854, 2334, 855},
	{855, 2334, 856},
	{856, 2334, 857},
	{857, 2334, 2327},
	{2327, 2334, 2328},
	{2328, 2334, 2329},
	{2329, 2334, 2330},
	{2330, 2334, 2331},
	{2331, 2334, 2332},
	{2332, 2334, 2333},
	{2333, 2334, 853},
	{858, 860, 861},
	{858, 861, 862},
	{858, 862, 863},
	{858, 863, 872},
	{858, 872, 873},
	{858, 873, 874},
	{858, 874, 875},
	{858, 875, 880},
	{858, 880, 2381},
	{858, 2381, 2382},
	{858, 2382, 2383},
	{858, 2383, 860},
	{883, 885, 895},
	{883, 895, 884},
	{861, 2384, 2385},
	{861, 2385, 862},
	{862, 2385, 2386},
	{862, 2386, 863},
	{863, 2386, 2387},
	{863, 2387, 872},
	{872, 2387, 2388},
	{872, 2388, 873},
	{864, 876, 877},
	{864, 877, 865},
	{865, 877, 878},
	{865, 878, 866},
	{866, 878, 879},
	{866, 879, 867},
	{880, 2389, 2390},
	{880, 2390, 2381},
	{2381, 2390, 2391},
	{868, 881, 869},
	{891, 905, 906},
	{891, 906, 892},
	{870, 882, 871},
	{870, 871, 859},
	{885, 898, 899},
	{885, 899, 895},
	{895, 899, 2300},
	{895, 2300, 896},
	{896, 2300, 2301},
	{886, 901, 887},
	{887, 901, 902},
	{887, 902, 888},
	{888, 902, 913},
	{888, 913, 900},
	{900, 913, 2188},
	{889, 916, 890},
	{890, 916, 2182},
	{890, 2182, 903},
	{903, 2182, 2183},
	{903, 2183, 904},
	{904, 2183, 2184},
	{893, 908, 894},
	{894, 908, 2313},
	{894, 2313, 905},
	{905, 2313, 2314},
	{905, 2314, 906},
	{906, 2314, 907},
	{897, 898, 885},
	{909, 921, 922},
	{909, 922, 910},
	{911, 2392, 2393},
	{899, 2302, 2300},
	{917, 2393, 2394},
	{917, 2394, 923},
	{912, 925, 926},
	{901, 2189, 902},
	{902, 2189, 2190},
	{902, 2190, 913},
	{924, 2513, 2514},
	{914, 927, 915},
	{916, 2185, 2186},
	{916, 2186, 2182},
	{2182, 2186, 2187},
	{2182, 2187, 2183},
	{928, 2399, 2400},
	{928, 2400, 929},
	{918, 930, 931},
	{2504, 2506, 2505},
	{919, 931, 932},
	{919, 932, 920},
	{920, 932, 921},
	{920, 921, 909},
	{933, 2403, 2392},
	{2392, 2403, 2393},
	{2393, 2403, 2394},
	{2394, 2403, 2395},
	{2395, 2403, 2396},
	{2396, 2403, 2397},
	{2397, 2403, 2398},
	{2398, 2403, 2399},
	{2399, 2403, 2400},
	{2400, 2403, 2401},
	{2401, 2403, 2402},
	{2402, 2403, 933},
	{934, 936, 939},
	{934, 939, 940},
	{934, 940, 941},
	{934, 941, 942},
	{934, 942, 943},
	{934, 943, 944},
	{934, 944, 951},
	{934, 951, 952},
	{934, 952, 953},
	{934, 953, 954},
	{934, 954, 955},
	{934, 955, 936},
	{948, 971, 972},
	{948, 972, 959},
	{959, 972, 973},
	{959, 973, 960},
	{937, 949, 950},
	{937, 950, 938},
	{963, 2406, 2407},
	{963, 2407, 976},
	{942, 956, 957},
	{942, 957, 943},
	{943, 957, 2441},
	{943, 2441, 944},
	{944, 2441, 2442},
	{944, 2442, 951},
	{951, 2442, 2443},
	{951, 2443, 952},
	{952, 2443, 2444},
	{952, 2444, 953},
	{953, 2444, 2445},
	{953, 2445, 954},
	{954, 2445, 2446},
	{945, 958, 946},
	{946, 958, 947},
	{946, 947, 935},
	{971, 986, 2217},
	{971, 2217, 972},
	{972, 2217, 2218},
	{972, 2218, 973},
	{949, 961, 962},
	{949, 962, 950},
	{2406, 2409, 2410},
	{2406, 2410, 2407},
	{2407, 2410, 2411},
	{2407, 2411, 2408},
	{964, 974, 975},
	{964, 975, 965},
	{966, 2304, 2305},
	{966, 2305, 979},
	{979, 2305, 2306},
	{979, 2306, 2303},
	{967, 980, 981},
	{967, 981, 968},
	{968, 981, 982},
	{968, 982, 969},
	{969, 982, 983},
	{969, 983, 970},
	{984, 2219, 986},
	{984, 986, 971},
	{986, 2220, 2221},
	{986, 2221, 2217},
	{2217, 2221, 2222},
	{2217, 2222, 2218},
	{977, 987, 988},
	{977, 988, 978},
	{2409, 2412, 2413},
	{2409, 2413, 2410},
	{989, 1005, 1009},
	{989, 1009, 990},
	{990, 1009, 2426},
	{990, 2426, 991},
	{991, 2426, 2427},
	{991, 2427, 992},
	{992, 2427, 2428},
	{992, 2428, 993},
	{993, 2428, 2429},
	{993, 2429, 998},
	{981, 994, 1006},
	{981, 1006, 982},
	{982, 1006, 1007},
	{995, 999, 996},
	{996, 999, 997},
	{996, 997, 985},
	{1001, 2432, 1002},
	{1002, 2432, 1003},
	{1003, 2432, 1004},
	{1004, 2432, 1005},
	{1005, 2432, 1009},
	{1009, 2432, 2426},
	{2426, 2432, 2427},
	{2427, 2432, 2428},
	{2428, 2432, 2429},
	{2429, 2432, 2430},
	{2430, 2432, 2431},
	{2431, 2432, 1001},
	{1010, 1012, 1015},
	{1010, 1015, 1019},
	{1010, 1019, 1020},
	{1010, 1020, 1021},
	{1010, 1021, 1031},
	{1010, 1031, 1032},
	{1010, 1032, 1033},
	{1010, 1033, 2417},
	{1010, 2417, 2418},
	{1010, 2418, 2419},
	{1010, 2419, 2420},
	{1010, 2420, 1012},
	{1024, 1048, 1049},
	{1024, 1049, 1035},
	{1035, 1049, 1062},
	{1035, 1062, 1036},
	{1000, 1013, 1014},
	{1000, 1014, 1008},
	{1027, 2307, 2308},
	{1027, 2308, 1039},
	{1039, 2308, 2309},
	{1039, 2309, 1052},
	{1016, 1028, 1029},
	{1016, 1029, 1017},
	{2501, 2502, 2503},
	{1017, 1030, 1018},
	{1033, 2421, 2422},
	{1033, 2422, 2417},
	{2417, 2422, 2423},
	{2417, 2423, 2418},
	{2418, 2423, 2424},
	{2418, 2424, 2419},
	{2419, 2424, 2425},
	{2419, 2425, 2420},
	{1022, 1034, 1023},
	{1022, 1023, 1011},
	{1048, 2335, 2336},
	{1048, 2336, 1049},
	{1049, 2336, 2337},
	{1049, 2337, 1062},
	{1013, 1025, 1026},
	{1013, 1026, 1014},
	{2307, 2310, 2311},
	{2307, 2311, 2308},
	{2308, 2311, 2312},
	{2308, 2312, 2309},
	{1028, 1037, 1038},
	{1028, 1038, 1029},
	{1042, 2271, 2272},
	{1042, 2272, 1055},
	{1055, 2272, 2273},
	{1055, 2273, 2270},
	{1040, 1041, 1043},
	{1044, 2494, 2493},
	{1046, 1060, 1071},
	{1046, 1071, 1047},
	{1047, 1071, 2237},
	{1047, 2237, 1058},
	{1058, 2237, 1059},
	{1058, 1059, 1045},
	{2335, 2338, 2339},
	{2335, 2339, 2336},
	{2336, 2339, 2340},
	{2336, 2340, 2337},
	{1050, 1053, 1054},
	{1050, 1054, 1051},
	{1065, 1080, 1081},
	{1065, 1081, 1066},
	{1066, 1081, 1082},
	{1066, 1082, 1067},
	{1067, 1082, 1083},
	{1067, 1083, 1068},
	{1068, 1083, 1085},
	{1068, 1085, 1069},
	{1069, 1085, 2447},
	{1069, 2447, 1070},
	{1070, 2447, 2448},
	{1070, 2448, 1074},
	{1060, 2238, 2239},
	{1060, 2239, 1071},
	{1071, 2239, 2240},
	{1071, 2240, 2237},
	{1057, 1063, 1061},
	{1057, 1061, 1056},
	{1077, 2451, 1078},
	{1078, 2451, 1079},
	{1079, 2451, 1080},
	{1080, 2451, 1081},
	{1081, 2451, 1082},
	{1082, 2451, 1083},
	{1083, 2451, 1085},
	{1085, 2451, 2447},
	{2447, 2451, 2448},
	{2448, 2451, 2449},
	{2449, 2451, 2450},
	{2450, 2451, 1077},
	{1086, 1088, 1087},
	{1086, 1089, 1088},
	{1086, 1090, 1089},
	{1086, 1091, 1090},
	{1086, 1094, 1091},
	{1086, 1095, 1094},
	{1086, 1096, 1095},
	{1086, 1097, 1096},
	{1086, 1098, 1097},
	{1086, 1099, 1098},
	{1086, 1100, 1099},
	{1086, 1087, 1100},
	{1087, 1102, 1101},
	{1087, 1088, 1102},
	{1088, 1103, 1102},
	{1088, 1089, 1103},
	{1089, 1106, 1103},
	{1089, 1090, 1106},
	{1090, 1107, 1106},
	{1090, 1091, 1107},
	{1114, 1141, 1128},
	{1114, 1115, 1141},
	{1064, 1075, 1073},
	{1064, 1072, 1075},
	{1095, 1109, 1108},
	{1095, 1096, 1109},
	{1096, 1110, 1109},
	{1096, 1097, 1110},
	{1097, 2490, 1110},
	{1097, 1098, 2490},
	{1098, 2491, 2490},
	{1098, 1099, 2491},
	{1099, 2492, 2491},
	{1099, 1100, 2492},
	{1100, 1101, 2492},
	{1100, 1087, 1101},
	{1111, 1126, 1125},
	{1111, 1112, 1126},
	{1112, 1138, 1126},
	{1112, 1113, 1138},
	{1113, 2266, 1138},
	{1113, 1124, 2266},
	{1127, 2458, 2457},
	{1127, 1128, 2458},
	{1128, 2459, 2458},
	{1128, 1141, 2459},
	{1073, 1084, 1076},
	{1073, 1075, 1084},
	{1118, 1144, 1132},
	{1118, 1119, 1144},
	{1119, 1278, 1144},
	{1119, 1131, 1278},
	{1121, 1136, 1135},
	{1121, 1122, 1136},
	{1122, 2278, 1136},
	{1122, 1123, 2278},
	{1123, 2279, 2278},
	{1123, 1133, 2279},
	{1133, 1134, 2279},
	{1133, 1120, 1134},
	{1125, 2268, 2267},
	{1125, 1126, 2268},
	{1126, 2269, 2268},
	{1126, 1138, 2269},
	{1092, 1105, 1104},
	{1092, 1093, 1105},
	{2457, 2461, 2460},
	{2457, 2458, 2461},
	{2458, 2462, 2461},
	{2458, 2459, 2462},
	{1116, 1130, 1129},
	{1116, 1117, 1130},
	{1132, 1288, 1279},
	{1132, 1144, 1288},
	{1144, 2370, 1288},
	{1144, 1278, 2370},
	{1145, 2486, 1161},
	{1145, 1146, 2486},
	{1146, 2487, 2486},
	{1146, 1147, 2487},
	{1147, 2488, 2487},
	{1147, 1148, 2488},
	{1148, 1149, 2488},
	{1148, 1137, 1149},
	{1149, 1150, 2489},
	{1150, 1153, 2489},
	{1153, 1156, 2489},
	{1156, 1157, 2489},
	{1157, 1158, 2489},
	{1158, 1159, 2489},
	{1159, 1160, 2489},
	{1160, 1161, 2489},
	{1161, 2486, 2489},
	{2486, 2487, 2489},
	{2487, 2488, 2489},
	{2488, 1149, 2489},
	{1162, 1173, 1167},
	{1162, 1185, 1173},
	{1162, 1186, 1185},
	{1162, 2288, 1186},
	{1162, 2289, 2288},
	{1162, 2290, 2289},
	{1162, 2291, 2290},
	{1162, 2292, 2291},
	{1162, 2293, 2292},
	{1162, 2294, 2293},
	{1162, 2295, 2294},
	{1162, 1167, 2295},
	{1164, 1189, 1188},
	{1164, 1176, 1189},
	{1176, 1200, 1189},
	{1176, 1187, 1200},
	{1139, 1143, 1142},
	{1139, 1140, 1143},
	{1179, 1204, 1203},
	{1179, 1190, 1204},
	{1190, 1205, 1204},
	{1190, 1191, 1205},
	{1151, 1165, 1155},
	{1151, 1152, 1165},
	{1152, 1166, 1165},
	{1152, 1154, 1166},
	{1168, 1172, 1171},
	{1168, 1169, 1172},
	{1169, 1177, 1172},
	{1169, 1170, 1177},
	{2293, 2298, 2297},
	{2293, 2294, 2298},
	{2294, 2299, 2298},
	{2294, 2295, 2299},
	{2295, 2296, 2299},
	{1174, 1163, 1175},
	{1188, 1202, 1201},
	{1188, 1189, 1202},
	{1189, 2404, 1202},
	{1189, 1200, 2404},
	{1192, 2230, 2229},
	{1192, 1203, 2230},
	{1203, 2231, 2230},
	{1203, 1204, 2231},
	{1204, 2232, 2231},
	{1204, 1205, 2232},
	{1205, 2233, 2232},
	{1205, 1217, 2233},
	{1193, 1207, 1206},
	{1193, 1194, 1207},
	{1194, 1208, 1207},
	{1194, 1195, 1208},
	{1195, 1209, 1208},
	{1195, 1196, 1209},
	{1197, 2350, 2349},
	{1197, 1210, 2350},
	{1210, 2351, 2350},
	{1210, 2348, 2351},
	{1180, 1181, 1182},
	{1180, 1178, 1181},
	{1213, 1234, 1229},
	{1213, 1214, 1234},
	{1214, 1235, 1234},
	{1214, 1221, 1235},
	{1183, 1199, 1198},
	{1183, 1184, 1199},
	{2230, 2235, 2234},
	{2230, 2231, 2235},
	{2231, 2236, 2235},
	{2231, 2232, 2236},
	{1211, 1218, 1216},
	{1211, 1212, 1218},
	{1206, 2437, 2436},
	{1206, 1207, 2437},
	{1215, 1220, 1219},
	{1222, 1223, 2283},
	{1223, 2284, 2283},
	{1223, 1224, 2284},
	{1224, 2285, 2284},
	{1224, 1225, 2285},
	{1225, 2286, 2285},
	{1225, 1226, 2286},
	{1226, 1229, 2286},
	{1226, 1213, 1229},
	{1229, 1234, 2287},
	{1234, 1235, 2287},
	{1235, 1236, 2287},
	{1236, 1237, 2287},
	{1237, 2280, 2287},
	{2280, 2281, 2287},
	{2281, 2282, 2287},
	{2282, 2283, 2287},
	{2283, 2284, 2287},
	{2284, 2285, 2287},
	{2285, 2286, 2287},
	{2286, 1229, 2287},
	{1238, 1246, 1242},
	{1238, 1247, 1246},
	{1238, 1248, 1247},
	{1238, 1249, 1248},
	{1238, 1254, 1249},
	{1238, 1258, 1254},
	{1238, 1259, 1258},
	{1238, 1260, 1259},
	{1238, 2207, 1260},
	{1238, 2208, 2207},
	{1238, 2209, 2208},
	{1238, 1242, 2209},
	{1240, 1263, 1253},
	{1240, 1241, 1263},
	{1241, 1264, 1263},
	{1241, 1252, 1264},
	{1247, 2211, 2210},
	{1247, 1248, 2211},
	{1248, 2212, 2211},
	{1248, 1249, 2212},
	{1227, 1232, 1231},
	{1227, 1228, 1232},
	{1228, 1233, 1232},
	{1228, 1230, 1233},
	{1258, 2214, 2213},
	{1258, 1259, 2214},
	{1259, 2215, 2214},
	{1259, 1260, 2215},
	{1260, 2216, 2215},
	{1260, 2207, 2216},
	{1261, 2191, 1287},
	{1261, 1272, 2191},
	{1272, 2192, 2191},
	{1272, 1273, 2192},
	{1243, 1244, 1245},
	{1243, 1239, 1244},
	{1253, 1275, 1274},
	{1253, 1263, 1275},
	{1263, 1276, 1275},
	{1263, 1264, 1276},
	{1264, 1277, 1276},
	{1264, 1265, 1277},
	{1267, 1305, 1293},
	{1267, 1280, 1305},
	{1280, 2274, 1305},
	{1280, 1281, 2274},
	{1281, 2275, 2274},
	{1268, 1269, 1282},
	{1269, 1283, 1282},
	{1269, 1270, 1283},
	{1270, 1284, 1283},
	{1270, 1271, 1284},
	{1271, 1285, 1284},
	{1286, 1287, 2194},
	{1287, 2195, 2194},
	{1287, 2191, 2195},
	{2191, 2196, 2195},
	{2191, 2192, 2196},
	{2192, 2193, 2196},
	{1266, 1253, 1274},
	{1289, 1312, 1304},
	{1289, 1290, 1312},
	{1290, 1313, 1312},
	{1290, 1291, 1313},
	{1291, 2197, 1313},
	{1291, 1292, 2197},
	{1292, 2198, 2197},
	{1292, 1300, 2198},
	{1305, 2277, 2276},
	{1305, 2274, 2277},
	{1250, 1256, 1255},
	{1250, 1251, 1256},
	{1282, 1308, 1296},
	{1282, 1283, 1308},
	{1283, 2341, 1308},
	{1283, 1284, 2341},
	{1257, 1297, 1295},
	{1257, 1262, 1297},
	{1301, 2204, 2203},
	{1262, 1294, 1298},
	{1302, 2205, 2204},
	{1302, 1303, 2205},
	{1303, 1304, 2205},
	{1303, 1289, 1304},
	{1304, 1312, 2206},
	{1312, 1313, 2206},
	{1313, 2197, 2206},
	{2197, 2198, 2206},
	{2198, 2199, 2206},
	{2199, 2200, 2206},
	{2200, 2201, 2206},
	{2201, 2202, 2206},
	{2202, 2203, 2206},
	{2203, 2204, 2206},
	{2204, 2205, 2206},
	{2205, 1304, 2206},
	{1314, 1326, 1320},
	{1314, 1332, 1326},
	{1314, 2252, 1332},
	{1314, 2253, 2252},
	{1314, 2254, 2253},
	{1314, 2255, 2254},
	{1314, 2256, 2255},
	{1314, 2257, 2256},
	{1314, 2258, 2257},
	{1314, 2259, 2258},
	{1314, 2260, 2259},
	{1314, 1320, 2260},
	{1299, 1311, 1310},
	{1299, 1306, 1311},
	{1339, 2452, 1353},
	{1339, 1340, 2452},
	{1307, 1316, 1315},
	{1307, 1309, 1316},
	{1343, 2371, 1356},
	{1317, 1318, 1319},
	{2253, 2263, 2262},
	{2253, 2254, 2263},
	{2254, 2264, 2263},
	{2254, 2255, 2264},
	{1321, 1345, 1344},
	{1321, 1322, 1345},
	{1322, 1346, 1345},
	{1322, 1333, 1346},
	{1323, 1328, 1327},
	{1323, 1324, 1328},
	{1324, 1329, 1328},
	{1324, 1325, 1329},
	{1338, 1351, 1350},
	{2259, 2260, 2265},
	{2260, 2261, 2265},
	{2260, 1320, 2261},
	{1352, 2454, 2453},
	{1352, 1353, 2454},
	{1353, 2455, 2454},
	{1353, 2452, 2455},
	{1330, 1336, 1335},
	{1330, 1331, 1336},
	{1356, 2374, 2373},
	{1356, 2371, 2374},
	{2371, 2375, 2374},
	{2371, 2372, 2375},
	{1334, 1358, 1357},
	{1334, 1344, 1358},
	{1344, 1359, 1358},
	{1344, 1345, 1359},
	{1345, 1360, 1359},
	{1345, 1346, 1360},
	{1346, 2405, 1360},
	{1346, 1347, 2405},
	{1349, 1363, 1362},
	{1349, 1350, 1363},
	{1350, 1364, 1363},
	{1350, 1351, 1364},
	{1351, 1361, 1364},
	{1351, 1348, 1361},
	{1366, 1389, 1385},
	{1366, 1370, 1389},
	{1370, 2241, 1389},
	{1370, 1371, 2241},
	{1341, 1367, 1355},
	{1335, 1336, 1337},
	{1342, 1368, 1367},
	{1342, 1354, 1368},
	{1372, 2244, 2243},
	{1372, 1373, 2244},
	{1373, 2245, 2244},
	{1373, 1378, 2245},
	{1378, 2246, 2245},
	{1378, 1382, 2246},
	{1382, 2247, 2246},
	{1382, 1383, 2247},
	{1383, 2248, 2247},
	{1383, 1384, 2248},
	{1369, 1379, 1377},
	{1369, 1374, 1379},
	{1374, 1380, 1379},
	{1374, 1375, 1380},
	{1375, 1376, 1380},
	{1375, 1365, 1376},
	{1385, 1389, 2251},
	{1389, 2241, 2251},
	{2241, 2242, 2251},
	{2242, 2243, 2251},
	{2243, 2244, 2251},
	{2244, 2245, 2251},
	{2245, 2246, 2251},
	{2246, 2247, 2251},
	{2247, 2248, 2251},
	{2248, 2249, 2251},
	{2249, 2250, 2251},
	{2250, 1385, 2251},
	{1390, 1398, 1395},
	{1390, 1399, 1398},
	{1390, 1400, 1399},
	{1390, 1401, 1400},
	{1390, 1402, 1401},
	{1390, 1410, 1402},
	{1390, 1411, 1410},
	{1390, 1412, 1411},
	{1390, 1413, 1412},
	{1390, 1414, 1413},
	{1390, 2468, 1414},
	{1390, 1395, 2468},
	{1381, 1391, 1388},
	{1381, 1386, 1391},
	{1386, 1392, 1391},
	{1386, 1387, 1392},
	{1393, 1404, 1403},
	{1393, 1394, 1404},
	{1407, 2343, 2342},
	{1407, 1419, 2343},
	{1419, 2344, 2343},
	{1419, 1432, 2344},
	{1396, 1406, 1405},
	{1396, 1397, 1406},
	{1410, 2471, 2470},
	{1410, 1411, 2471},
	{1411, 2472, 2471},
	{1411, 1412, 2472},
	{1412, 2473, 2472},
	{1412, 1413, 2473},
	{1413, 2474, 2473},
	{1413, 1414, 2474},
	{1414, 2475, 2474},
	{1414, 2468, 2475},
	{2468, 2469, 2475},
	{2468, 1395, 2469},
	{1415, 1442, 1441},
	{1415, 1416, 1442},
	{1416, 2177, 1442},
	{1416, 1428, 2177},
	{1430, 2483, 2482},
	{1417, 1418, 1431},
	{2342, 2346, 2345},
	{2342, 2343, 2346},
	{2343, 2347, 2346},
	{2343, 2344, 2347},
	{1405, 1409, 1408},
	{1405, 1406, 1409},
	{1422, 2225, 2224},
	{1422, 1435, 2225},
	{1435, 2226, 2225},
	{1435, 2223, 2226},
	{1436, 2500, 2499},
	{1423, 1424, 1437},
	{1425, 2376, 1451},
	{1425, 1438, 2376},
	{1438, 2377, 2376},
	{1438, 1439, 2377},
	{1429, 1441, 2178},
	{1421, 1420, 1426},
	{1441, 2180, 2179},
	{1441, 1442, 2180},
	{1442, 2181, 2180},
	{1442, 2177, 2181},
	{1443, 1457, 1456},
	{1443, 1444, 1457},
	{1444, 1458, 1457},
	{1444, 1445, 1458},
	{1445, 1459, 1458},
	{1445, 1446, 1459},
	{1446, 1460, 1459},
	{1446, 1447, 1460},
	{2224, 2228, 2227},
	{2224, 2225, 2228},
	{1440, 1452, 1450},
	{1440, 1448, 1452},
	{1448, 1453, 1452},
	{1448, 1449, 1453},
	{1451, 2379, 2378},
	{1451, 2376, 2379},
	{2376, 2380, 2379},
	{2376, 2377, 2380},
	{1427, 1433, 1434},
	{2178, 1441, 2179},
	{1454, 1455, 2467},
	{1455, 1456, 2467},
	{1456, 1457, 2467},
	{1457, 1458, 2467},
	{1458, 1459, 2467},
	{1459, 1460, 2467},
	{1460, 1461, 2467},
	{1461, 2463, 2467},
	{2463, 2464, 2467},
	{2464, 2465, 2467},
	{2465, 2466, 2467},
	{2466, 1454, 2467},
};
