-- cc_int_ent.vhd: Completer Completion interface connection - entity
-- Copyright (C) 2013 CESNET
-- Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity cc_int is
   generic(
      -- Number of items in FIFO for data read from FPGA
      FIFO_SIZE               : integer := 16
   );
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK                     : in  std_logic;
      -- Synchronous reset
      RESET                   : in  std_logic;

      -- Registered values from Completer Request interface -------------------
      REG_CQ_DESCRIPTOR       : in  std_logic_vector(127 downto 0);
      REG_CQ_USER_FIRST_BE    : in  std_logic_vector(3 downto 0);
      REG_CQ_USER_LAST_BE     : in  std_logic_vector(3 downto 0);
      REG_CQ_USER_TPH_PRESENT : in  std_logic;
      REG_CQ_USER_TPH_TYPE    : in  std_logic_vector(1 downto 0);
      REG_CQ_USER_TPH_ST_TAG  : in  std_logic_vector(7 downto 0);

      -- Interface with cq_int component --------------------------------------
      -- Lower part of the address
      DATA_LOWER_ADDR         : in std_logic_vector(4 downto 0);
      -- Length of the payload in Dwords
      DATA_DWORD_COUNT        : in std_logic_vector(10 downto 0);
      -- Byte enable for the first Dword of the payload
      USER_FIRST_BE           : in std_logic_vector(3 downto 0);
      -- Byte enable for the last Dword of the payload
      USER_LAST_BE            : in std_logic_vector(3 downto 0);

      -- Interface with mi_int component --------------------------------------
      -- Read request on CQ interface
      READ_REQ                : in  std_logic;
      -- Unsupported request on CQ interface
      UNSUPPORTED_REQ         : in  std_logic;
      -- End of data read from FPGA (using MI32)
      EOP                     : in  std_logic;
      -- Whole completion has been sent
      COMPLETION_SENT         : out std_logic;
      -- Write interface of FIFO in cc_int component
      DATA                    : in  std_logic_vector(31 downto 0);
      WR                      : in  std_logic;
      FULL                    : out std_logic;

      -- Completer Completion Interface (CC) - reduced version ----------------
      -- Data bus
      CC_DATA                 : out std_logic_vector(255 downto 0);
      -- Indication of the last word of a transaction
      CC_LAST                 : out std_logic;
      -- Indication of valid data
      -- each bit determines validity of different Dword (1 Dword = 4 Bytes)
      CC_KEEP                 : out std_logic_vector(7 downto 0);
      -- Indication of valid data
      -- i.e. user application is ready to send a transaction
      CC_VALID                : out std_logic;
      -- Completer is ready to receive a transaction
      CC_READY                : in std_logic;

      -- Configuration Status Interface - selected parts ----------------------
      -- Max payload size
      MAX_PAYLOAD_SIZE        : in std_logic_vector(2 downto 0)
   );
end entity cc_int;

