-- streaming_debug_probe.vhd: Data streaming interface debug probe.
-- Copyright (C) 2013 CESNET
-- Author(s): Lukas Kekely <kekely@cesnet.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity STREAMING_DEBUG_PROBE is 
  port(
    -- Input interface
    RX_SRC_RDY     : in  std_logic;
    RX_DST_RDY     : out std_logic;
    RX_SOP         : in  std_logic := '0';
    RX_EOP         : in  std_logic := '0';
 
    -- Output interface
    TX_SRC_RDY     : out std_logic;
    TX_DST_RDY     : in  std_logic;
    TX_SOP         : out std_logic := '0';
    TX_EOP         : out std_logic := '0';
         
    -- Debuging interface ---------------------------------------------------
    DEBUG_BLOCK        : in  std_logic := '0';              -- blocks data words on pipe's input interface
    DEBUG_DROP         : in  std_logic := '0';              -- drops data words on pipe's input interface (higher priority than BLOCK)
    DEBUG_SRC_RDY      : out std_logic;                     -- source ready on pipe's input interface
    DEBUG_DST_RDY      : out std_logic;                     -- destination ready on pipe's input interface
    DEBUG_SOP          : out std_logic := '0';              -- start of transaction on pipe's input interface
    DEBUG_EOP          : out std_logic := '0'               -- end of transaction on pipe's input interface
  );
end entity;

architecture full of STREAMING_DEBUG_PROBE is 
begin
  TX_SRC_RDY      <= not DEBUG_DROP and not DEBUG_BLOCK and RX_SRC_RDY;
  RX_DST_RDY      <= DEBUG_DROP or (not DEBUG_BLOCK and TX_DST_RDY);
  DEBUG_SRC_RDY   <= not DEBUG_BLOCK and RX_SRC_RDY;
  DEBUG_DST_RDY   <= DEBUG_DROP or (not DEBUG_BLOCK and TX_DST_RDY); 
  TX_SOP          <= RX_SOP;
  TX_EOP          <= RX_EOP;
  DEBUG_SOP       <= RX_SOP;
  DEBUG_EOP       <= RX_EOP; 
end architecture;

