///////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   /
// /___/  \  /    Vendor: Xilinx
// \   \   \/     Version : 3.0
//  \   \         Application : GT Wizard
//  /   /         Filename : gtz_caui4_v3_0_tx_seq_counter.v
// /___/   /\     
// \   \  /  \ 
//  \___\/\___\
//
//
// Module gtz_caui4_v3_0_tx_seq_counter
// Generated by Xilinx GT Wizard
// 
// 
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`default_nettype wire
`timescale 1ns / 1ps
`define DLY #1


//***************************** Entity Declaration ****************************

module gtz_caui4_v3_0_tx_seq_counter 
   (   
    tx_usrclk_in,
    tx_system_reset_in,    
    tx_sequence_out,
    tx_dataready_out   
   );
   parameter SEQ_CNTR_MAX = 32;
      
   input tx_usrclk_in;
   input tx_system_reset_in;
   
   output [6:0]   tx_sequence_out;
   output         tx_dataready_out;

   reg [5:0] 	       txseq_counter_r;
			   
   //***********************************************************************//
   //                                                                       //
   //--------------------- Logic for 64B66B/67B Encoding--------------------//
   //                                                                       //
   //***********************************************************************//

   //____________________________ TXSEQUENCE counter to GT __________________________    
   always @(posedge tx_usrclk_in)
     if(tx_system_reset_in)
       // txseq_counter_r <=  `DLY    6'd0; !!!!!!!!!!!!!!!!!!!!!!!!!!
          txseq_counter_r <=  `DLY    SEQ_CNTR_MAX;
     else
       if (txseq_counter_r == SEQ_CNTR_MAX)
	       txseq_counter_r <=  `DLY    6'd0;
       else
	       txseq_counter_r <=  `DLY    txseq_counter_r + 6'd1;

     assign tx_sequence_out = {1'b0,txseq_counter_r};
     // assign tx_dataready_out = (txseq_counter_r != (SEQ_CNTR_MAX-1)) && (!tx_system_reset_in);
     assign tx_dataready_out = (txseq_counter_r != (SEQ_CNTR_MAX-1)); 
			   
endmodule

