// gtz_caui4_octal0_wrapper.v: Wrapper for gtz_caui4_OCTAL0_main module
// Copyright (C) 2014 CESNET
// Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in
//    the documentation and/or other materials provided with the
//    distribution.
// 3. Neither the name of the Company nor the names of its contributors
//    may be used to endorse or promote products derived from this
//    software without specific prior written permission.
//
// This software is provided ``as is'', and any express or implied
// warranties, including, but not limited to, the implied warranties of
// merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the company or contributors be liable for any
// direct, indirect, incidental, special, exemplary, or consequential
// damages (including, but not limited to, procurement of substitute
// goods or services; loss of use, data, or profits; or business
// interruption) however caused and on any theory of liability, whether
// in contract, strict liability, or tort (including negligence or
// otherwise) arising in any way out of the use of this software, even
// if advised of the possibility of such damage.
//
// $Id$
//
// TODO:
//


`default_nettype wire

`timescale 1ns / 1ps


//***************************** Entity Declaration ****************************

module gtz_caui4_OCTAL0 # (
   // Simulation attributes
   parameter SIM_GTZRESET_SPEEDUP = "TRUE",      // Set to 1 to speed up sim reset;
   parameter RXUSRCLK_LANE0_VAR   = "RXUSRCLK1",
   parameter RXUSRCLK_LANE1_VAR   = "RXUSRCLK1",
   parameter RXUSRCLK_LANE2_VAR   = "RXUSRCLK1",
   parameter RXUSRCLK_LANE3_VAR   = "RXUSRCLK1",
   parameter RXUSRCLK_LANE4_VAR   = "RXUSRCLK0",
   parameter RXUSRCLK_LANE5_VAR   = "RXUSRCLK0",
   parameter RXUSRCLK_LANE6_VAR   = "RXUSRCLK0",
   parameter RXUSRCLK_LANE7_VAR   = "RXUSRCLK0",
   parameter TXUSRCLK_LANE0_VAR   = "TXUSRCLK0",
   parameter TXUSRCLK_LANE1_VAR   = "TXUSRCLK0",
   parameter TXUSRCLK_LANE2_VAR   = "TXUSRCLK0",
   parameter TXUSRCLK_LANE3_VAR   = "TXUSRCLK0",
   parameter TXUSRCLK_LANE4_VAR   = "TXUSRCLK0",
   parameter TXUSRCLK_LANE5_VAR   = "TXUSRCLK0",
   parameter TXUSRCLK_LANE6_VAR   = "TXUSRCLK0",
   parameter TXUSRCLK_LANE7_VAR   = "TXUSRCLK0",
   parameter SIM_VERSION          = "1.0"
) (
   //----------------------- REFCLK Ports -------------------------------------
   input          gtrefclk0p_in,
   input          gtrefclk0n_in,
   input          gtrefclk1p_in,
   input          gtrefclk1n_in,

   output         rxcoreclk0_out,
   output         rxcoreclk1_out,
   output         rxcoreclk2_out,
   output         rxcoreclk3_out,
   output         txcoreclk0_out,
   output         txcoreclk1_out,

   input          rxusrclk0_in,
   input          rxusrclk1_in,
   input          rxusrclk2_in,
   input          rxusrclk3_in,
   input          rxusrclk4_in,
   input          rxusrclk5_in,
   input          rxusrclk6_in,
   input          rxusrclk7_in,

   input          txusrclk0_in,
   input          txusrclk1_in,
   input          txusrclk2_in,
   input          txusrclk3_in,
   input          txusrclk4_in,
   input          txusrclk5_in,
   input          txusrclk6_in,
   input          txusrclk7_in,

   input          drpclk0_in,
   input          drpclk1_in,
   input          drpclksel_in,

   //-------------------------------- Serial Ports ----------------------------
   output         gtztxp0_out,
   output         gtztxn0_out,
   input          gtzrxp0_in,
   input          gtzrxn0_in,

   output         gtztxp1_out,
   output         gtztxn1_out,
   input          gtzrxp1_in,
   input          gtzrxn1_in,

   output         gtztxp2_out,
   output         gtztxn2_out,
   input          gtzrxp2_in,
   input          gtzrxn2_in,

   output         gtztxp3_out,
   output         gtztxn3_out,
   input          gtzrxp3_in,
   input          gtzrxn3_in,
			      
   // ---------------------------- RX/TX polarity control ---------------------
   input    [3:0] oct0_gtzrxpolarity_in,
   input    [3:0] oct0_gtztxpolarity_in,			      
      
   //----------------------------- BitSlip Ports ------------------------------
   input    [4:0] rxgearboxslip0_in,
   input    [4:0] rxgearboxslip1_in,
   input    [4:0] rxgearboxslip2_in,
   input    [4:0] rxgearboxslip3_in,

   //----------------------------- Clocking Ports -----------------------------
   input          refclksel0_in,
   input          refclksel1_in,
   input          refclksel2_in,
   input          refclksel3_in,
   output         rxoutclk0_out,
   output         rxoutclk1_out,
   output         rxoutclk2_out,
   output         rxoutclk3_out,
   output         txoutclk0_out,
   output         txoutclk1_out,

   //-------------------------- Configuration Ports ---------------------------
   input          gtzinit_in,
   output         gtzinitdoneb_out,
   input          pllrecalen0_in,
   input          pllrecalen1_in,
   input          pllrecalen2_in,
   input          pllrecalen3_in,    
   input          txen0_in,    
   input          txen1_in,    
   input          txen2_in,    
   input          txen3_in,
   input          rxen0_in,    
   input          rxen1_in,    
   input          rxen2_in,    
   input          rxen3_in,

   //------------------------------- DRP Ports --------------------------------
   input   [15:0] drpaddr_in,
   input   [31:0] drpdi_in,
   output  [31:0] drpdo_out,
   input          drpen_in,
   output         drprdy_out,
   output   [2:0] drpstatus_out,
   output         drpwdterr_out,
   input          drpwe_in,

   //---------------------------- FIB Reset Ports -----------------------------
   input          rxfibreset0_in,
   input          rxfibreset1_in,
   input          rxfibreset2_in,
   input          rxfibreset3_in,

   //-------------------------- Latency clock Ports ---------------------------
   input          rxlatclk_in,
   input          txlatclk_in,

   //------------------------------- Loopbacks --------------------------------
   input          nearloopbacken0_in,
   input          nearloopbacken1_in,
   input          nearloopbacken2_in,
   input          nearloopbacken3_in,

   //-------------------------- Rx Fabric Interface ---------------------------
   output [159:0] rxdata0_out,
   output [159:0] rxdata1_out,
   output [159:0] rxdata2_out,
   output [159:0] rxdata3_out,
   output   [4:0] rxdatavalid0_out,
   output   [4:0] rxdatavalid1_out,
   output   [4:0] rxdatavalid2_out,
   output   [4:0] rxdatavalid3_out,
   output   [9:0] rxheader0_out,
   output   [9:0] rxheader1_out,
   output   [9:0] rxheader2_out,
   output   [9:0] rxheader3_out,
   output   [4:0] rxheadervalid0_out,
   output   [4:0] rxheadervalid1_out,
   output   [4:0] rxheadervalid2_out,
   output   [4:0] rxheadervalid3_out,

   //-------------------------- Rx Reset Controller ---------------------------
   input          gtzrxreset0_in,
   input          gtzrxreset1_in,
   input          gtzrxreset2_in,
   input          gtzrxreset3_in,
   output         rxrdy0_out,
   output         rxrdy1_out,
   output         rxrdy2_out,
   output         rxrdy3_out,
   output         rxresetdone0_out,
   output         rxresetdone1_out,
   output         rxresetdone2_out,
   output         rxresetdone3_out,

   //-------------------------- Tx Fabric Interface ---------------------------
   input  [159:0] txdata0_in,
   input  [159:0] txdata1_in,
   input  [159:0] txdata2_in,
   input  [159:0] txdata3_in,
   input    [9:0] txheader0_in,
   input    [9:0] txheader1_in,
   input    [9:0] txheader2_in,
   input    [9:0] txheader3_in,

   //-------------------------- Tx Reset Controller ---------------------------
   input          gtztxreset0_in,
   input          gtztxreset1_in,
   input          gtztxreset2_in,
   input          gtztxreset3_in,
   output         txrdy0_out,
   output         txrdy1_out,
   output         txrdy2_out,
   output         txrdy3_out,
   output         txresetdone0_out,
   output         txresetdone1_out,
   output         txresetdone2_out,
   output         txresetdone3_out,

   //--------------------------- Tx sequence Ports ----------------------------
   input    [6:0] txsequence0_in,
   input    [6:0] txsequence1_in,
   input    [6:0] txsequence2_in,
   input    [6:0] txsequence3_in
);


//************************* Architecture Declaration **************************
              
gtz_caui4_OCTAL0_main #
(
   // Simulation attributes
   .SIM_GTZRESET_SPEEDUP (SIM_GTZRESET_SPEEDUP),
   //pragma translate_off
   .RXUSRCLK_LANE0_VAR   ("RXUSRCLK_LANE0_VAR"),
   .RXUSRCLK_LANE1_VAR   ("RXUSRCLK_LANE1_VAR"),
   .RXUSRCLK_LANE2_VAR   ("RXUSRCLK_LANE2_VAR"),
   .RXUSRCLK_LANE3_VAR   ("RXUSRCLK_LANE3_VAR"),
   .RXUSRCLK_LANE4_VAR   ("RXUSRCLK_LANE4_VAR"),
   .RXUSRCLK_LANE5_VAR   ("RXUSRCLK_LANE5_VAR"),
   .RXUSRCLK_LANE6_VAR   ("RXUSRCLK_LANE6_VAR"),
   .RXUSRCLK_LANE7_VAR   ("RXUSRCLK_LANE7_VAR"),
   .TXUSRCLK_LANE0_VAR   ("TXUSRCLK_LANE0_VAR"),
   .TXUSRCLK_LANE1_VAR   ("TXUSRCLK_LANE1_VAR"),
   .TXUSRCLK_LANE2_VAR   ("TXUSRCLK_LANE2_VAR"),
   .TXUSRCLK_LANE3_VAR   ("TXUSRCLK_LANE3_VAR"),
   .TXUSRCLK_LANE4_VAR   ("TXUSRCLK_LANE4_VAR"),
   .TXUSRCLK_LANE5_VAR   ("TXUSRCLK_LANE5_VAR"),
   .TXUSRCLK_LANE6_VAR   ("TXUSRCLK_LANE6_VAR"),
   .TXUSRCLK_LANE7_VAR   ("TXUSRCLK_LANE7_VAR"),
   //pragma translate_on
   .SIM_VERSION          (SIM_VERSION) 
)
gtz_caui4_octal0_i
(
   //----------------------- REFCLK Ports -------------------------------------
   .gtrefclk0p_in         (gtrefclk0p_in),
   .gtrefclk0n_in         (gtrefclk0n_in),
   .gtrefclk1p_in         (gtrefclk1p_in),
   .gtrefclk1n_in         (gtrefclk1n_in),
   .drpclksel_in          (drpclksel_in),

   //-----------------------User clocks----------------------------------------
   .rxcoreclk0_out        (rxcoreclk0_out),
   .rxcoreclk1_out        (rxcoreclk1_out),
   .rxcoreclk2_out        (rxcoreclk2_out),
   .rxcoreclk3_out        (rxcoreclk3_out),
   .txcoreclk0_out        (txcoreclk0_out),
   .txcoreclk1_out        (txcoreclk1_out),

   .rxusrclk0_in          (rxusrclk0_in),
   .rxusrclk1_in          (rxusrclk1_in),
   .rxusrclk2_in          (rxusrclk2_in),
   .rxusrclk3_in          (rxusrclk3_in),
   .rxusrclk4_in          (rxusrclk4_in),
   .rxusrclk5_in          (rxusrclk5_in),
   .rxusrclk6_in          (rxusrclk6_in),
   .rxusrclk7_in          (rxusrclk7_in),

   .txusrclk0_in          (txusrclk0_in),
   .txusrclk1_in          (txusrclk1_in),
   .txusrclk2_in          (txusrclk2_in),
   .txusrclk3_in          (txusrclk3_in),
   .txusrclk4_in          (txusrclk4_in),
   .txusrclk5_in          (txusrclk5_in),
   .txusrclk6_in          (txusrclk6_in),
   .txusrclk7_in          (txusrclk7_in),

   .drpclk0_in            (drpclk0_in),
   .drpclk1_in            (drpclk1_in),	

   //-------------------------------- Serial Ports ----------------------------
   .gtztxp0_out           (gtztxp0_out),
   .gtztxn0_out           (gtztxn0_out),
   .gtzrxp0_in            (gtzrxp0_in),
   .gtzrxn0_in            (gtzrxn0_in),
   .gtztxp1_out           (gtztxp1_out),
   .gtztxn1_out           (gtztxn1_out),
   .gtzrxp1_in            (gtzrxp1_in),
   .gtzrxn1_in            (gtzrxn1_in),
   .gtztxp2_out           (gtztxp2_out),
   .gtztxn2_out           (gtztxn2_out),
   .gtzrxp2_in            (gtzrxp2_in),
   .gtzrxn2_in            (gtzrxn2_in),
   .gtztxp3_out           (gtztxp3_out),
   .gtztxn3_out           (gtztxn3_out),
   .gtzrxp3_in            (gtzrxp3_in),
   .gtzrxn3_in            (gtzrxn3_in),
   
   // ----------------------------- RX/TX polarity ----------------------------
   .oct0_gtzrxpolarity_in (oct0_gtzrxpolarity_in),
   .oct0_gtztxpolarity_in (oct0_gtztxpolarity_in),        
 
   //----------------------------- BitSlip Ports ------------------------------
   .rxgearboxslip0_in     (rxgearboxslip0_in),
   .rxgearboxslip1_in     (rxgearboxslip1_in),
   .rxgearboxslip2_in     (rxgearboxslip2_in),
   .rxgearboxslip3_in     (rxgearboxslip3_in),

   //----------------------------- Clocking Ports -----------------------------
   .refclksel0_in         (refclksel0_in),
   .refclksel1_in         (refclksel1_in),
   .refclksel2_in         (refclksel2_in),
   .refclksel3_in         (refclksel3_in),
   .rxoutclk0_out         (rxoutclk0_out),
   .rxoutclk1_out         (rxoutclk1_out),
   .rxoutclk2_out         (rxoutclk2_out),
   .rxoutclk3_out         (rxoutclk3_out),
   .txoutclk0_out         (txoutclk0_out),
   .txoutclk1_out         (txoutclk1_out),

   //-------------------------- Configuration Ports ---------------------------
   .gtzinit_in            (gtzinit_in),
   .gtzinitdoneb_out      (gtzinitdoneb_out),
   .pllrecalen0_in        (pllrecalen0_in),
   .pllrecalen1_in        (pllrecalen1_in),
   .pllrecalen2_in        (pllrecalen2_in),
   .pllrecalen3_in        (pllrecalen3_in),
   .txen0_in              (txen0_in),
   .txen1_in              (txen1_in),
   .txen2_in              (txen2_in),
   .txen3_in              (txen3_in),
   .rxen0_in              (rxen0_in),
   .rxen1_in              (rxen1_in),
   .rxen2_in              (rxen2_in),
   .rxen3_in              (rxen3_in),

   //------------------------------- DRP Ports --------------------------------
   .drpaddr_in            (drpaddr_in),
   .drpdi_in              (drpdi_in),
   .drpdo_out             (drpdo_out),
   .drpen_in              (drpen_in),
   .drprdy_out            (drprdy_out),
   .drpstatus_out         (drpstatus_out),
   .drpwdterr_out         (drpwdterr_out),
   .drpwe_in              (drpwe_in),

   //---------------------------- FIB Reset Ports -----------------------------
   .rxfibreset0_in        (rxfibreset0_in),
   .rxfibreset1_in        (rxfibreset1_in),
   .rxfibreset2_in        (rxfibreset2_in),
   .rxfibreset3_in        (rxfibreset3_in),

   //-------------------------- Latency clock Ports ---------------------------
   .rxlatclk_in           (rxlatclk_in),
   .txlatclk_in           (txlatclk_in),

   //------------------------------- Loopbacks --------------------------------
   .nearloopbacken0_in    (nearloopbacken0_in),
   .nearloopbacken1_in    (nearloopbacken1_in),
   .nearloopbacken2_in    (nearloopbacken2_in),
   .nearloopbacken3_in    (nearloopbacken3_in),

   //-------------------------- Rx Fabric Interface ---------------------------
   .rxdata0_out           (rxdata0_out),
   .rxdata1_out           (rxdata1_out),
   .rxdata2_out           (rxdata2_out),
   .rxdata3_out           (rxdata3_out),
   .rxdatavalid0_out      (rxdatavalid0_out),
   .rxdatavalid1_out      (rxdatavalid1_out),
   .rxdatavalid2_out      (rxdatavalid2_out),
   .rxdatavalid3_out      (rxdatavalid3_out),
   .rxheader0_out         (rxheader0_out),
   .rxheader1_out         (rxheader1_out),
   .rxheader2_out         (rxheader2_out),
   .rxheader3_out         (rxheader3_out),
   .rxheadervalid0_out    (rxheadervalid0_out),
   .rxheadervalid1_out    (rxheadervalid1_out),
   .rxheadervalid2_out    (rxheadervalid2_out),
   .rxheadervalid3_out    (rxheadervalid3_out),

   //-------------------------- Rx Reset Controller ---------------------------
   .gtzrxreset0_in        (gtzrxreset0_in),
   .gtzrxreset1_in        (gtzrxreset1_in),
   .gtzrxreset2_in        (gtzrxreset2_in),
   .gtzrxreset3_in        (gtzrxreset3_in),
   .rxrdy0_out            (rxrdy0_out),
   .rxrdy1_out            (rxrdy1_out),
   .rxrdy2_out            (rxrdy2_out),
   .rxrdy3_out            (rxrdy3_out),
   .rxresetdone0_out      (rxresetdone0_out),
   .rxresetdone1_out      (rxresetdone1_out),
   .rxresetdone2_out      (rxresetdone2_out),
   .rxresetdone3_out      (rxresetdone3_out),

   //-------------------------- Tx Fabric Interface ---------------------------
   .txdata0_in            (txdata0_in),
   .txdata1_in            (txdata1_in),
   .txdata2_in            (txdata2_in),
   .txdata3_in            (txdata3_in),
   .txheader0_in          (txheader0_in),
   .txheader1_in          (txheader1_in),
   .txheader2_in          (txheader2_in),
   .txheader3_in          (txheader3_in),

   //-------------------------- Tx Reset Controller ---------------------------
   .gtztxreset0_in        (gtztxreset0_in),
   .gtztxreset1_in        (gtztxreset1_in),
   .gtztxreset2_in        (gtztxreset2_in),
   .gtztxreset3_in        (gtztxreset3_in),
   .txrdy0_out            (txrdy0_out),
   .txrdy1_out            (txrdy1_out),
   .txrdy2_out            (txrdy2_out),
   .txrdy3_out            (txrdy3_out),
   .txresetdone0_out      (txresetdone0_out),
   .txresetdone1_out      (txresetdone1_out),
   .txresetdone2_out      (txresetdone2_out),
   .txresetdone3_out      (txresetdone3_out),

   //--------------------------- Tx sequence Ports ----------------------------
   .txsequence0_in        (txsequence0_in),
   .txsequence1_in        (txsequence1_in),
   .txsequence2_in        (txsequence2_in),
   .txsequence3_in        (txsequence3_in)
);
                      
endmodule
