-- filter_core_ent.vhd: Filtering engine of packet filter
-- Copyright (c) 2013 Brno University of Technology 
-- Author(s): Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: filter_core_ent.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--
-- TODO:
--
--
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use work.math_pack.all;
use work.filter_core_v2_config.all; 

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity AFILTER_CORE_V2 is
  generic (
    RULES_DATA_WIDTH            : integer := 16                                             
  );
  port(
    CLK               : in std_logic;
    RESET             : in std_logic;
      
    -- Data input interface
    IN_SRCIP     : in std_logic_vector(128-1 downto 0);
    IN_DSTIP     : in std_logic_vector(128-1 downto 0);
    IN_SRCPORT   : in std_logic_vector(15 downto 0);
    IN_DSTPORT   : in std_logic_vector(15 downto 0);
    IN_PROTOCOL  : in std_logic_vector(7 downto 0);
    IN_READY     : in std_logic;
    IN_NEXT      : out std_logic;  
      
    -- Output of filtering core
    RESULT            : out std_logic_vector(RULES_DATA_WIDTH*2-1 downto 0);
    FOUND             : out std_logic_vector(2-1 downto 0);
    RESULT_READY      : out std_logic;
    RESULT_NEXT       : in  std_logic;    
      
    -- MI32 configuration interface
    MI_DWR            : in  std_logic_vector(31 downto 0); 
    MI_ADDR           : in  std_logic_vector(31 downto 0); 
    MI_RD             : in  std_logic;                     
    MI_WR             : in  std_logic;                     
    MI_BE             : in  std_logic_vector(3  downto 0); -- UNSUPPORTED !!!!!!!!!!!!!!!!!
    MI_DRD            : out std_logic_vector(31 downto 0); 
    MI_ARDY           : out std_logic;                     
    MI_DRDY           : out std_logic
  );
end entity AFILTER_CORE_V2;
