
################################################################
# This is a generated script based on design: design_1
#
# Though there are limitations about the generated script,
# the main purpose of this utility is to make learning
# IP Integrator Tcl commands easier.
################################################################

################################################################
# Check if script is running in correct Vivado version.
################################################################
set scripts_vivado_version 2014.3
set current_vivado_version [version -short]

if { [string first $scripts_vivado_version $current_vivado_version] == -1 } {
   puts ""
   puts "ERROR: This script was generated using Vivado <$scripts_vivado_version> and is being run in <$current_vivado_version> of Vivado. Please run the script in Vivado <$scripts_vivado_version> then open the design in Vivado <$current_vivado_version>. Upgrade the design by running \"Tools => Report => Report IP Status...\", then run write_bd_tcl to create an updated script."

   return 1
}

################################################################
# START
################################################################

# To test this script, run the following commands from Vivado Tcl console:
# source design_1_script.tcl

# If you do not already have a project created,
# you can create a project using the following command:
#    create_project project_1 myproj -part xc7vh580thcg1931-2


# CHANGE DESIGN NAME HERE
set design_name design_1

# If you do not already have an existing IP Integrator design open,
# you can create a design using the following command:
#    create_bd_design $design_name

# CHECKING IF PROJECT EXISTS
if { [get_projects -quiet] eq "" } {
   puts "ERROR: Please open or create a project!"
   return 1
}


# Creating design if needed
set errMsg ""
set nRet 0

set cur_design [current_bd_design -quiet]
set list_cells [get_bd_cells -quiet]

if { ${design_name} eq "" } {
   # USE CASES:
   #    1) Design_name not set

   set errMsg "ERROR: Please set the variable <design_name> to a non-empty value."
   set nRet 1

} elseif { ${cur_design} ne "" && ${list_cells} eq "" } {
   # USE CASES:
   #    2): Current design opened AND is empty AND names same.
   #    3): Current design opened AND is empty AND names diff; design_name NOT in project.
   #    4): Current design opened AND is empty AND names diff; design_name exists in project.

   if { $cur_design ne $design_name } {
      puts "INFO: Changing value of <design_name> from <$design_name> to <$cur_design> since current design is empty."
      set design_name [get_property NAME $cur_design]
   }
   puts "INFO: Constructing design in IPI design <$cur_design>..."

} elseif { ${cur_design} ne "" && $list_cells ne "" && $cur_design eq $design_name } {
   # USE CASES:
   #    5) Current design opened AND has components AND same names.

   set errMsg "ERROR: Design <$design_name> already exists in your project, please set the variable <design_name> to another value."
   set nRet 1
} elseif { [get_files -quiet ${design_name}.bd] ne "" } {
   # USE CASES: 
   #    6) Current opened design, has components, but diff names, design_name exists in project.
   #    7) No opened design, design_name exists in project.

   set errMsg "ERROR: Design <$design_name> already exists in your project, please set the variable <design_name> to another value."
   set nRet 2

} else {
   # USE CASES:
   #    8) No opened design, design_name not in project.
   #    9) Current opened design, has components, but diff names, design_name not in project.

   puts "INFO: Currently there is no design <$design_name> in project, so creating one..."

   create_bd_design $design_name

   puts "INFO: Making design <$design_name> as current_bd_design."
   current_bd_design $design_name

}

puts "INFO: Currently the variable <design_name> is equal to \"$design_name\"."

if { $nRet != 0 } {
   puts $errMsg
   return $nRet
}

##################################################################
# DESIGN PROCs
##################################################################



# Procedure to create entire design; Provide argument to make
# procedure reusable. If parentCell is "", will use root.
proc create_root_design { parentCell } {

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     puts "ERROR: Unable to find parent cell <$parentCell>!"
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     puts "ERROR: Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports
  set bootfpga [ create_bd_intf_port -mode Master -vlnv cesnet:interface:bootfpga_rtl:1.0 bootfpga ]
  set cfp2_clk [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 cfp2_clk ]
  set cfp2_control [ create_bd_intf_port -mode Master -vlnv cesnet:interface:cfp2_control_rtl:1.0 cfp2_control ]
  set cfp2_data [ create_bd_intf_port -mode Master -vlnv cesnet:interface:cfp2_diff_data_rtl:1.0 cfp2_data ]
  set clk_125 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 clk_125 ]
  set_property -dict [ list CONFIG.FREQ_HZ {125000000}  ] $clk_125
  set leds_interface [ create_bd_intf_port -mode Master -vlnv cesnet:interface:leds_interface_rtl:1.0 leds_interface ]
  set pcie0_clk [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 pcie0_clk ]
  set pcie1_clk [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 pcie1_clk ]
  set pcie1_data_x8 [ create_bd_intf_port -mode Master -vlnv cesnet:interface:pcie_diff_data_x8_rtl:1.0 pcie1_data_x8 ]

  # Create ports
  set PCIE_SYS_RESET_N [ create_bd_port -dir I -type rst PCIE_SYS_RESET_N ]

  # Create instance: eth100g_0, and set properties
  set eth100g_0 [ create_bd_cell -type ip -vlnv cesnet:netcope:eth100g:1.0 eth100g_0 ]

  # Create instance: filter_core_0, and set properties
  set filter_core_0 [ create_bd_cell -type ip -vlnv but:application:filter_core:1.0 filter_core_0 ]

  # Create instance: host_int_0, and set properties
  set host_int_0 [ create_bd_cell -type ip -vlnv cesnet:netcope:host_int:1.0 host_int_0 ]
  set_property -dict [ list CONFIG.PCIE0_DATA_PRESENT {false} CONFIG.SEPARATE_HEADER_IFC {false} CONFIG.USER_MI_PRESENT {true}  ] $host_int_0

  # Create interface connections
  connect_bd_intf_net -intf_net cfp2_clk_1 [get_bd_intf_ports cfp2_clk] [get_bd_intf_pins eth100g_0/cfp2_clk]
  connect_bd_intf_net -intf_net clk_125_1 [get_bd_intf_ports clk_125] [get_bd_intf_pins host_int_0/clk_125]
  connect_bd_intf_net -intf_net eth100g_0_cfp2_control [get_bd_intf_ports cfp2_control] [get_bd_intf_pins eth100g_0/cfp2_control]
  connect_bd_intf_net -intf_net eth100g_0_cfp2_data [get_bd_intf_ports cfp2_data] [get_bd_intf_pins eth100g_0/cfp2_data]
  connect_bd_intf_net -intf_net eth100g_0_leds_interface [get_bd_intf_ports leds_interface] [get_bd_intf_pins eth100g_0/leds_interface]
  connect_bd_intf_net -intf_net eth100g_0_rx_fl [get_bd_intf_pins eth100g_0/rx_fl] [get_bd_intf_pins filter_core_0/rx_fl]
  connect_bd_intf_net -intf_net eth100g_0_rx_flu [get_bd_intf_pins eth100g_0/rx_flu] [get_bd_intf_pins filter_core_0/rx_flu]
  connect_bd_intf_net -intf_net filter_core_0_tx_flu [get_bd_intf_pins filter_core_0/tx_flu] [get_bd_intf_pins host_int_0/rx_flu]
  connect_bd_intf_net -intf_net host_int_0_bootfpga [get_bd_intf_ports bootfpga] [get_bd_intf_pins host_int_0/bootfpga]
  connect_bd_intf_net -intf_net host_int_0_eth_mi [get_bd_intf_pins eth100g_0/eth_mi] [get_bd_intf_pins host_int_0/eth_mi]
  connect_bd_intf_net -intf_net host_int_0_net_mi [get_bd_intf_pins eth100g_0/net_mi] [get_bd_intf_pins host_int_0/net_mi]
  connect_bd_intf_net -intf_net host_int_0_pcie1_data_x8 [get_bd_intf_ports pcie1_data_x8] [get_bd_intf_pins host_int_0/pcie1_data_x8]
  connect_bd_intf_net -intf_net host_int_0_tx_flu [get_bd_intf_pins eth100g_0/tx_flu] [get_bd_intf_pins host_int_0/tx_flu]
  connect_bd_intf_net -intf_net host_int_0_user_mi [get_bd_intf_pins filter_core_0/mi] [get_bd_intf_pins host_int_0/user_mi]
  connect_bd_intf_net -intf_net pcie0_clk_1 [get_bd_intf_ports pcie0_clk] [get_bd_intf_pins host_int_0/pcie0_clk]
  connect_bd_intf_net -intf_net pcie1_clk_1 [get_bd_intf_ports pcie1_clk] [get_bd_intf_pins host_int_0/pcie1_clk]

  # Create port connections
  connect_bd_net -net PCIE_SYS_RESET_N_1 [get_bd_ports PCIE_SYS_RESET_N] [get_bd_pins host_int_0/PCIE_SYS_RESET_N]
  connect_bd_net -net host_int_0_DRPCLK [get_bd_pins eth100g_0/DRPCLK] [get_bd_pins host_int_0/DRPCLK]
  connect_bd_net -net host_int_0_MI_CLK [get_bd_pins eth100g_0/MI_CLK] [get_bd_pins filter_core_0/MI_CLK] [get_bd_pins host_int_0/MI_CLK]
  connect_bd_net -net host_int_0_MI_RESET [get_bd_pins eth100g_0/MI_RESET] [get_bd_pins filter_core_0/MI_RESET] [get_bd_pins host_int_0/MI_RESET]
  connect_bd_net -net host_int_0_RESET [get_bd_pins eth100g_0/RESET] [get_bd_pins host_int_0/RESET]
  connect_bd_net -net host_int_0_USER_CLK [get_bd_pins eth100g_0/RX_CLK] [get_bd_pins eth100g_0/TX_CLK] [get_bd_pins filter_core_0/CLK] [get_bd_pins host_int_0/USER_CLK]
  connect_bd_net -net host_int_0_USER_RESET [get_bd_pins eth100g_0/RX_RESET] [get_bd_pins eth100g_0/TX_RESET] [get_bd_pins filter_core_0/RESET] [get_bd_pins host_int_0/USER_RESET]

  # Create address segments
  

  # Restore current instance
  current_bd_instance $oldCurInst

  save_bd_design
}
# End of create_root_design()


##################################################################
# MAIN FLOW
##################################################################

create_root_design ""


