
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/host_int_v1_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  set Component_Name  [  ipgui::add_param $IPINST -name "Component_Name" -display_name {Component Name}]
  set_property tooltip {Component Name} ${Component_Name}
  #Adding Page
  set Page_0  [  ipgui::add_page $IPINST -name "Page 0" -display_name {Page 0}]
  set_property tooltip {Page 0} ${Page_0}
  set HDR_WIDTH  [  ipgui::add_param $IPINST -name "HDR_WIDTH" -parent ${Page_0} -display_name {HDR_WIDTH} -widget comboBox]
  set_property tooltip {HDR_WIDTH} ${HDR_WIDTH}
  set PROJECT_TEXT  [  ipgui::add_param $IPINST -name "PROJECT_TEXT" -parent ${Page_0} -display_name {PROJECT_TEXT}]
  set_property tooltip {PROJECT_TEXT} ${PROJECT_TEXT}
  set USER_CLK_DIV  [  ipgui::add_param $IPINST -name "USER_CLK_DIV" -parent ${Page_0} -display_name {USER_CLK_DIV}]
  set_property tooltip {USER_CLK_DIV} ${USER_CLK_DIV}
  set USER_FREQ  [  ipgui::add_param $IPINST -name "USER_FREQ" -parent ${Page_0} -display_name {MHz}]
  set_property tooltip {MHz} ${USER_FREQ}
  #Adding Group
  set Interface_presence  [  ipgui::add_group $IPINST -name "Interface presence" -parent ${Page_0} -display_name {Interface presence}]
  set_property tooltip {Interface presence} ${Interface_presence}
  set PCIE0_DATA_PRESENT  [  ipgui::add_param $IPINST -name "PCIE0_DATA_PRESENT" -parent ${Interface_presence} -display_name {PCIE0_DATA_X8}]
  set_property tooltip {PCIE0_DATA_X8} ${PCIE0_DATA_PRESENT}
  set SEPARATE_HEADER_IFC  [  ipgui::add_param $IPINST -name "SEPARATE_HEADER_IFC" -parent ${Interface_presence} -display_name {RX_FL}]
  set_property tooltip {RX_FL} ${SEPARATE_HEADER_IFC}
  set USER_MI_PRESENT  [  ipgui::add_param $IPINST -name "USER_MI_PRESENT" -parent ${Interface_presence} -display_name {USER_MI}]
  set_property tooltip {USER_MI} ${USER_MI_PRESENT}



}

proc update_PARAM_VALUE.RX_HDATA_WIDTH { PARAM_VALUE.RX_HDATA_WIDTH PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to update RX_HDATA_WIDTH when any of the dependent parameters in the arguments change
	
	set RX_HDATA_WIDTH ${PARAM_VALUE.RX_HDATA_WIDTH}
	set HDR_WIDTH ${PARAM_VALUE.HDR_WIDTH}
	set values(HDR_WIDTH) [get_property value $HDR_WIDTH]
	set_property value [gen_USERPARAMETER_RX_HDATA_WIDTH_VALUE $values(HDR_WIDTH)] $RX_HDATA_WIDTH
}

proc validate_PARAM_VALUE.RX_HDATA_WIDTH { PARAM_VALUE.RX_HDATA_WIDTH } {
	# Procedure called to validate RX_HDATA_WIDTH
	return true
}

proc update_PARAM_VALUE.RX_HREM_WIDTH { PARAM_VALUE.RX_HREM_WIDTH PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to update RX_HREM_WIDTH when any of the dependent parameters in the arguments change
	
	set RX_HREM_WIDTH ${PARAM_VALUE.RX_HREM_WIDTH}
	set HDR_WIDTH ${PARAM_VALUE.HDR_WIDTH}
	set values(HDR_WIDTH) [get_property value $HDR_WIDTH]
	set_property value [gen_USERPARAMETER_RX_HREM_WIDTH_VALUE $values(HDR_WIDTH)] $RX_HREM_WIDTH
}

proc validate_PARAM_VALUE.RX_HREM_WIDTH { PARAM_VALUE.RX_HREM_WIDTH } {
	# Procedure called to validate RX_HREM_WIDTH
	return true
}

proc update_PARAM_VALUE.USER_FREQ { PARAM_VALUE.USER_FREQ PARAM_VALUE.USER_CLK_DIV } {
	# Procedure called to update USER_FREQ when any of the dependent parameters in the arguments change
	
	set USER_FREQ ${PARAM_VALUE.USER_FREQ}
	set USER_CLK_DIV ${PARAM_VALUE.USER_CLK_DIV}
	set values(USER_CLK_DIV) [get_property value $USER_CLK_DIV]
	set_property value [gen_USERPARAMETER_USER_FREQ_VALUE $values(USER_CLK_DIV)] $USER_FREQ
}

proc validate_PARAM_VALUE.USER_FREQ { PARAM_VALUE.USER_FREQ } {
	# Procedure called to validate USER_FREQ
	return true
}

proc update_PARAM_VALUE.USER_MI_PRESENT { PARAM_VALUE.USER_MI_PRESENT } {
	# Procedure called to update USER_MI_PRESENT when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.USER_MI_PRESENT { PARAM_VALUE.USER_MI_PRESENT } {
	# Procedure called to validate USER_MI_PRESENT
	return true
}

proc update_PARAM_VALUE.PCIE0_DATA_PRESENT { PARAM_VALUE.PCIE0_DATA_PRESENT } {
	# Procedure called to update PCIE0_DATA_PRESENT when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.PCIE0_DATA_PRESENT { PARAM_VALUE.PCIE0_DATA_PRESENT } {
	# Procedure called to validate PCIE0_DATA_PRESENT
	return true
}

proc update_PARAM_VALUE.HDR_WIDTH { PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to update HDR_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.HDR_WIDTH { PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to validate HDR_WIDTH
	return true
}

proc update_PARAM_VALUE.SEPARATE_HEADER_IFC { PARAM_VALUE.SEPARATE_HEADER_IFC } {
	# Procedure called to update SEPARATE_HEADER_IFC when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.SEPARATE_HEADER_IFC { PARAM_VALUE.SEPARATE_HEADER_IFC } {
	# Procedure called to validate SEPARATE_HEADER_IFC
	return true
}

proc update_PARAM_VALUE.PROJECT_TEXT { PARAM_VALUE.PROJECT_TEXT } {
	# Procedure called to update PROJECT_TEXT when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.PROJECT_TEXT { PARAM_VALUE.PROJECT_TEXT } {
	# Procedure called to validate PROJECT_TEXT
	return true
}

proc update_PARAM_VALUE.USER_CLK_DIV { PARAM_VALUE.USER_CLK_DIV } {
	# Procedure called to update USER_CLK_DIV when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.USER_CLK_DIV { PARAM_VALUE.USER_CLK_DIV } {
	# Procedure called to validate USER_CLK_DIV
	return true
}


proc update_MODELPARAM_VALUE.USER_CLK_DIV { MODELPARAM_VALUE.USER_CLK_DIV PARAM_VALUE.USER_CLK_DIV } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.USER_CLK_DIV}] ${MODELPARAM_VALUE.USER_CLK_DIV}
}

proc update_MODELPARAM_VALUE.PROJECT_TEXT { MODELPARAM_VALUE.PROJECT_TEXT PARAM_VALUE.PROJECT_TEXT } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.PROJECT_TEXT}] ${MODELPARAM_VALUE.PROJECT_TEXT}
}

proc update_MODELPARAM_VALUE.SEPARATE_HEADER_IFC { MODELPARAM_VALUE.SEPARATE_HEADER_IFC PARAM_VALUE.SEPARATE_HEADER_IFC } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.SEPARATE_HEADER_IFC}] ${MODELPARAM_VALUE.SEPARATE_HEADER_IFC}
}

proc update_MODELPARAM_VALUE.HDR_WIDTH { MODELPARAM_VALUE.HDR_WIDTH PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.HDR_WIDTH}] ${MODELPARAM_VALUE.HDR_WIDTH}
}

