--!
--! reset_wrapper.vhd: Wrapper component for reset synchronizer.
--! Copyright (C) 2014 CESNET
--! Author(s): Jiri Matousekl <xmatou06@stud.fit.vutbr.cz>
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!
--! $Id$
--!

library IEEE;	
use IEEE.std_logic_1164.all;	
use IEEE.std_logic_unsigned.all;	
use IEEE.std_logic_arith.all;


-- ----------------------------------------------------------------------------
--                            Entity declaration
-- ----------------------------------------------------------------------------

entity ASYNC_RESET is
generic (
   TWO_REG  : BOOLEAN := false; --! For two reg = true, for three reg = false
   OUT_REG  : BOOLEAN := false; --! Registering of output reset by single normal register in destination clock domain.
   REPLICAS : INTEGER := 1      --! Number of output register replicas (registers actually replicated only when OUT_REG is true).
);    
port (
   CLK         : in  STD_LOGIC;                            --! Clock
   ASYNC_RST   : in  STD_LOGIC;                            --! Asynchronous reset     
   OUT_RST     : out STD_LOGIC_VECTOR(REPLICAS-1 downto 0) --! Output reset
);
end ASYNC_RESET;


-- ----------------------------------------------------------------------------
--                          Architecture declaration
-- ----------------------------------------------------------------------------

architecture FULL of ASYNC_RESET is

begin

   async_reset_i : entity work.ASYNC_RESET_MAIN
   generic map (
      TWO_REG   => TWO_REG,
      OUT_REG   => OUT_REG,
      REPLICAS  => REPLICAS
   )
   port map (
      CLK       => CLK,
      ASYNC_RST => ASYNC_RST,
      OUT_RST   => OUT_RST
   );

end architecture FULL;
