# pcie0.xdc: Constraints for PCI Express core 0 in NetCOPE@FB1CG
# Copyright (C) 2014 CESNET
# Author: Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the Company nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# This software is provided ``as is'', and any express or implied
# warranties, including, but not limited to, the implied warranties of
# merchantability and fitness for a particular purpose are disclaimed.
# In no event shall the company or contributors be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.
#
# $Id$
#


# PCIe 0 clock port placement
###############################################################################

# ports placement
set_property PACKAGE_PIN AC6                 [get_ports {PCIE0_SYS_CLK_P}]
set_property PACKAGE_PIN AC5                 [get_ports {PCIE0_SYS_CLK_N}]

# clock definition
create_clock -name pcie0_sys_clk -period 10 [get_ports {PCIE0_SYS_CLK_P}]


# Placement of GTH transceiver instance of each PCIe lane
###############################################################################

# PCIe lane 0
set_property LOC         GTHE2_CHANNEL_X1Y11 [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[0].gt_wrapper_i/gth_channel.gthe2_channel_i}]

# PCIe lane 1
set_property LOC         GTHE2_CHANNEL_X1Y10 [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[1].gt_wrapper_i/gth_channel.gthe2_channel_i}]

# PCIe lane 2
set_property LOC         GTHE2_CHANNEL_X1Y9  [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[2].gt_wrapper_i/gth_channel.gthe2_channel_i}]

# PCIe lane 3
set_property LOC         GTHE2_CHANNEL_X1Y8  [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[3].gt_wrapper_i/gth_channel.gthe2_channel_i}]

# PCIe lane 4
set_property LOC         GTHE2_CHANNEL_X1Y7  [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[4].gt_wrapper_i/gth_channel.gthe2_channel_i}]

# PCIe lane 5
set_property LOC         GTHE2_CHANNEL_X1Y6  [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[5].gt_wrapper_i/gth_channel.gthe2_channel_i}]

# PCIe lane 6
set_property LOC         GTHE2_CHANNEL_X1Y5  [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[6].gt_wrapper_i/gth_channel.gthe2_channel_i}]

# PCIe lane 7
set_property LOC         GTHE2_CHANNEL_X1Y4  [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[7].gt_wrapper_i/gth_channel.gthe2_channel_i}]


# PCIe block placement
# This constraint selects the PCIe block to be used
###############################################################################

set_property LOC         PCIE3_X0Y0          [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/PCIE_3_0_i}]


# Buffers (BRAM) placement
###############################################################################

# Replay buffer RAMB placement
set_property LOC         RAMB36_X13Y23       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/replay_buffer/U0/RAMB36E1[0].u_buffer}]
set_property LOC         RAMB36_X13Y24       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/replay_buffer/U0/RAMB36E1[1].u_buffer}]

# Non-posted request buffer RAMB placement
set_property LOC         RAMB18_X13Y30       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/req_fifo/U0/RAMB18E1[0].u_fifo}]
set_property LOC         RAMB18_X13Y31       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/req_fifo/U0/RAMB18E1[1].u_fifo}]
set_property LOC         RAMB18_X13Y32       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/req_fifo/U0/RAMB18E1[2].u_fifo}]
set_property LOC         RAMB18_X13Y33       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/req_fifo/U0/RAMB18E1[3].u_fifo}]

# Completion buffer RAMB placement
set_property LOC         RAMB18_X13Y36       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/cpl_fifo/genblk*.CPL_FIFO_16KB.U0/SPEED_500MHz_OR_NO_DECODE_LOGIC.RAMB18E1[0].u_fifo}]
set_property LOC         RAMB18_X13Y37       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/cpl_fifo/genblk*.CPL_FIFO_16KB.U0/SPEED_500MHz_OR_NO_DECODE_LOGIC.RAMB18E1[1].u_fifo}]
set_property LOC         RAMB18_X13Y38       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/cpl_fifo/genblk*.CPL_FIFO_16KB.U0/SPEED_500MHz_OR_NO_DECODE_LOGIC.RAMB18E1[2].u_fifo}]
set_property LOC         RAMB18_X13Y39       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/cpl_fifo/genblk*.CPL_FIFO_16KB.U0/SPEED_500MHz_OR_NO_DECODE_LOGIC.RAMB18E1[3].u_fifo}]
set_property LOC         RAMB18_X13Y40       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/cpl_fifo/genblk*.CPL_FIFO_16KB.U0/SPEED_500MHz_OR_NO_DECODE_LOGIC.RAMB18E1[4].u_fifo}]
set_property LOC         RAMB18_X13Y41       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/cpl_fifo/genblk*.CPL_FIFO_16KB.U0/SPEED_500MHz_OR_NO_DECODE_LOGIC.RAMB18E1[5].u_fifo}]
set_property LOC         RAMB18_X13Y42       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/cpl_fifo/genblk*.CPL_FIFO_16KB.U0/SPEED_500MHz_OR_NO_DECODE_LOGIC.RAMB18E1[6].u_fifo}]
set_property LOC         RAMB18_X13Y43       [get_cells {pcie_i/double_pcie_gen.pcie0_i/inst/pcie_top_i/pcie_7vx_i/pcie_bram_7vx_i/cpl_fifo/genblk*.CPL_FIFO_16KB.U0/SPEED_500MHz_OR_NO_DECODE_LOGIC.RAMB18E1[7].u_fifo}]


# Timing constraints
###############################################################################

create_clock -period 10.000 -name pcie0_gth_txoutclk [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_lane[0].gt_wrapper_i/gth_channel.gthe2_channel_i/TXOUTCLK}]

create_generated_clock -name clk_125mhz_x0y0 [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_clock_int.pipe_clock_i/mmcm_i/CLKOUT0}]
create_generated_clock -name clk_250mhz_x0y0 [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_clock_int.pipe_clock_i/mmcm_i/CLKOUT1}]

create_generated_clock -name clk_125mhz_mux_x0y0 \
   -source [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_clock_int.pipe_clock_i/pclk_i1_bufgctrl.pclk_i1/I0}] \
   -divide_by 1 \
   [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_clock_int.pipe_clock_i/pclk_i1_bufgctrl.pclk_i1/O}]

create_generated_clock -name clk_250mhz_mux_x0y0 \
   -source [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_clock_int.pipe_clock_i/pclk_i1_bufgctrl.pclk_i1/I1}] \
   -divide_by 1 \
   -add -master_clock [get_clocks -of [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_clock_int.pipe_clock_i/pclk_i1_bufgctrl.pclk_i1/I1}]] \
   [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_clock_int.pipe_clock_i/pclk_i1_bufgctrl.pclk_i1/O}]

set_clock_groups -name pcieclkmux_x0y0 -physically_exclusive \
   -group clk_125mhz_mux_x0y0 \
   -group clk_250mhz_mux_x0y0

set_false_path -to [get_pins {pcie_i/double_pcie_gen.pcie0_i/inst/gt_top_i/pipe_wrapper_i/pipe_clock_int.pipe_clock_i/pclk_i1_bufgctrl.pclk_i1/S*}]


# Physical constraints
# GEN3 configurations require 500MHz BRAM interface. Prohibit tools from using
# slices in between to ensure timing closure
###############################################################################

set_property PROHIBIT true [get_sites -range {SLICE_X349Y125 SLICE_X346Y74}]
