-- or.vhd
--!
--! \file
--! \brief Generic OR.
--! \author Lukas Kekely <kekely@cesnet.cz>
--! \date 2012 
--!
--! \section License
--!
--! Copyright (C) 2012 CESNET
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

--! \brief Generic OR entity.
entity GEN_OR is
   generic(
      --! \brief Width of input signal, number of bits to OR.
      --! \details Must be greater than 0.
      OR_WIDTH    : integer  -- or width (number of inputs)
   );
   port(
      --! Input data, vector of bits to OR.
      DI  : in  std_logic_vector(OR_WIDTH-1 downto 0);
      --! Output data, result of OR.
      DO  : out std_logic
   );
end entity;

--! \brief Behavioral implementation of generic OR.
architecture behav of GEN_OR is
begin
  
   --! ORing process
   genorp:process(DI)
      variable o : std_logic;
   begin
      o := '0';
      for i in 0 to OR_WIDTH-1 loop
         o := o or DI(i);
      end loop;
      DO <= o;
   end process;

end architecture;

