-- dma_up_int_ent.vhd: DMA UP interface connection - entity
-- Copyright (C) 2013 CESNET
-- Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity dma_up_int is
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK               : in  std_logic;
      -- Synchronous reset
      RESET             : in  std_logic;

      -- DMA UP Interface (from user application to host system) --------------
      -- Input data
      DMA_UP_DATA       : in  std_logic_vector(255 downto 0);
      ----- Header for input data (valid when SOP is valid) -----
      -- Number of dwords within current transaction
      DMA_UP_HDR_DWORDS : in  std_logic_vector(10 downto 0);
      -- Transaction type (0 = Read Request; 1 = Write Request)
      DMA_UP_HDR_TYPE   : in  std_logic_vector(4 downto 0);
      -- Transaction tag (important only for Read Requests)
      DMA_UP_HDR_TAG    : in  std_logic_vector(7 downto 0);
      -- ID of requesting component
      DMA_UP_HDR_ID     : in  std_logic_vector(7 downto 0);
      -- Address in host RAM
      DMA_UP_HDR_ADDR   : in  std_logic_vector(63 downto 0);
      -- Start of transaction (valid when DMA_UP_SRC_RDY=DMA_UP_DST_RDY='1')
      DMA_UP_SOP        : in  std_logic;
      -- End of transaction (valid when DMA_UP_SRC_RDY = DMA_UP_DST_RDY = '1')
      DMA_UP_EOP        : in  std_logic;
      -- Source is ready to transmit data
      DMA_UP_SRC_RDY    : in  std_logic;
      -- Destination is ready to receive data
      DMA_UP_DST_RDY    : out std_logic;

      -- DMA-like interface to rq_int component -------------------------------
      -- Transaction data
      DMA_DATA          : out std_logic_vector(255 downto 0);
      ----- Parts of transaction header (valid when SOP is valid) -----
      -- Number of dwords in the transaction
      DMA_HDR_DWORDS    : out std_logic_vector(10 downto 0);
      -- Transaction type (Read request or Write Request)
      DMA_HDR_TYPE      : out std_logic;
      -- Address in host RAM
      DMA_HDR_ADDR      : out std_logic_vector(63 downto 0);
      -- Start of transaction (valid when DMA_SRC_RDY = DMA_DST_RDY = 1)
      DMA_SOP           : out std_logic;
      -- End of transaction (valid when DMA_SRC_RDY = DMA_DST_RDY = 1)
      DMA_EOP           : out std_logic;
      -- Source is ready to transmit data
      DMA_SRC_RDY       : out std_logic;
      -- Destination is ready to receive data
      DMA_DST_RDY       : in  std_logic;
      -- Tag for PCIe transaction (valid when SOP is valid)
      PCIE_TAG          : out std_logic_vector(4 downto 0);
      
      -- Interface to tag_manager component -----------------------------------
      -- Free tag offered by the tag_manager
      -- (offered tag is used when TAG_OFFER_VLD = TAG_OFFER_ACCEPT = '1')
      TAG_OFFER         : in  std_logic_vector(4 downto 0);
      -- Offered tag validity (no tag is available when TAG_OFFER_VLD = '0')
      TAG_OFFER_VLD     : in  std_logic;
      -- Acceptation of offered tag
      TAG_OFFER_ACCEPT  : out std_logic;
      -- DMA tag, which is mapped on the accepted PCIe tag
      DMA_HDR_TAG       : out std_logic_vector(7 downto 0);
      -- DMA component ID, which is mapped on the accepted PCIe tag
      DMA_HDR_ID        : out std_logic_vector(7 downto 0)
   );
end entity dma_up_int;

