-- dma_splitter.vhd: DMA Splitter
-- Copyright (C) 2013 CESNET
-- Author(s): Martin Spinler <spinler@cesnet.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

-- -----------------------------------------------------------------------------
--                              Entity declaration
-- -----------------------------------------------------------------------------
entity DMA_SPLITTER is
   generic (
      DATA_WIDTH        : integer := 512;
      HDR_WIDTH         : integer := 32;
      HDR_BIT           : integer
   );
   port (
      -- Common interface
      CLK               : in  std_logic;
      RESET             : in  std_logic;

      DMA_RX_DATA       : in  std_logic_vector(DATA_WIDTH-1 downto 0);
      DMA_RX_HDR        : in  std_logic_vector(HDR_WIDTH-1 downto 0);
      DMA_RX_SOP        : in  std_logic;
      DMA_RX_EOP        : in  std_logic;
      DMA_RX_SRC_RDY    : in  std_logic;
      DMA_RX_DST_RDY    : out std_logic;

      DMA_TX0_DATA      : out std_logic_vector(DATA_WIDTH-1 downto 0);
      DMA_TX0_HDR       : out std_logic_vector(HDR_WIDTH-1 downto 0);
      DMA_TX0_SOP       : out std_logic;
      DMA_TX0_EOP       : out std_logic;
      DMA_TX0_SRC_RDY   : out std_logic;
      DMA_TX0_DST_RDY   : in  std_logic;

      DMA_TX1_DATA      : out std_logic_vector(DATA_WIDTH-1 downto 0);
      DMA_TX1_HDR       : out std_logic_vector(HDR_WIDTH-1 downto 0);
      DMA_TX1_SOP       : out std_logic;
      DMA_TX1_EOP       : out std_logic;
      DMA_TX1_SRC_RDY   : out std_logic;
      DMA_TX1_DST_RDY   : in  std_logic
   );
end entity DMA_SPLITTER;

-- -----------------------------------------------------------------------------
--                           Architecture declaration
-- -----------------------------------------------------------------------------
architecture behavioral of DMA_SPLITTER is

begin

   process(DMA_RX_HDR, DMA_RX_SRC_RDY, DMA_TX0_DST_RDY, DMA_TX1_DST_RDY)
   begin
      if(DMA_RX_HDR(HDR_BIT) = '0') then
         DMA_RX_DST_RDY    <= DMA_TX0_DST_RDY;
         DMA_TX0_SRC_RDY   <= DMA_RX_SRC_RDY;
         DMA_TX1_SRC_RDY   <= '0';
      else
         DMA_RX_DST_RDY    <= DMA_TX1_DST_RDY;
         DMA_TX1_SRC_RDY   <= DMA_RX_SRC_RDY;
         DMA_TX0_SRC_RDY   <= '0';
      end if;
   end process;

   DMA_TX0_DATA   <= DMA_RX_DATA;
   DMA_TX0_HDR    <= DMA_RX_HDR;
   DMA_TX0_SOP    <= DMA_RX_SOP;
   DMA_TX0_EOP    <= DMA_RX_EOP;

   DMA_TX1_DATA   <= DMA_RX_DATA;
   DMA_TX1_HDR    <= DMA_RX_HDR;
   DMA_TX1_SOP    <= DMA_RX_SOP;
   DMA_TX1_EOP    <= DMA_RX_EOP;

end architecture;
