-- obuf_cgmii_ent.vhd: CGMII Output buffer - entity declaration
-- Copyright (C) 2012 CESNET
-- Author(s): Vaclav Hummel <xhumme00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--
library IEEE;
use IEEE.std_logic_1164.all;
use work.math_pack.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity obuf_cgmii is
   generic(
      -- Number of items in Data FIFO
      DFIFO_ITEMS        : integer := 512;
      HFIFO_ITEMS        : integer := 128;
      CNT_DSP            : boolean := true
   );
   port(
      -- CGMII interface -----------------------------------------------------
      -- CGMII Transmit Clock
      CGMII_TXCLK      : in std_logic;
      -- CGMII Transmit reset
      CGMII_TXRESET    : in  std_logic;
      -- CGMII Transmit Data
      CGMII_TXD        : out std_logic_vector(511 downto 0);
      -- CGMII Transmit Control
      CGMII_TXC        : out std_logic_vector(63 downto 0);

      -- FrameLinkUnaligned interface -----------------------------------------
      -- Input clock
      RX_CLK            : in std_logic;
      -- Input reset
      RX_RESET          : in std_logic;
      -- Packet data
      RX_DATA           : in std_logic_vector(511 downto 0);
      -- Position of the start of the packet
      -- valid only if RX_SOP is set to '1'
      RX_SOP_POS        : in std_logic_vector(2 downto 0);
      -- Position of the end of the packet
      -- valid only if RX_EOP is set to '1'
      RX_EOP_POS        : in std_logic_vector(5 downto 0);
      -- Start of the packet
      RX_SOP            : in std_logic;
      -- End of the packet
      RX_EOP            : in std_logic;
      -- Source is ready
      RX_SRC_RDY        : in std_logic;
      -- Destination is ready
      RX_DST_RDY        : out std_logic;

      -- MI32 interface -------------------------------------------------------
      -- Clock signal
      MI_CLK            : in std_logic;
      -- Reset signal
      MI_RESET          : in std_logic;
      -- Input data
      MI_DWR            : in  std_logic_vector(31 downto 0);
      -- Address
      MI_ADDR           : in  std_logic_vector(31 downto 0);
      -- Read request
      MI_RD             : in  std_logic;
      -- Write request
      MI_WR             : in  std_logic;
      -- Byte enable
      MI_BE             : in  std_logic_vector(3  downto 0);
      -- Output data
      MI_DRD            : out std_logic_vector(31 downto 0);
      -- Address ready
      MI_ARDY           : out std_logic;
      -- Data ready
      MI_DRDY           : out std_logic;

      -- Status interface -----------------------------------------------------
      OUTGOING_PACKET   : out std_logic
   );
end entity;
