library ieee;
use ieee.std_logic_1164.all;

entity crc32_fast32_tab is

	port (
		DI : in std_logic_vector(31 downto 0);
		DO : out std_logic_vector(31 downto 0)
	);

end entity;

architecture structural of crc32_fast32_tab is

	signal out1 : std_logic_vector(77 downto 0);

	signal out2 : std_logic_vector(91 downto 0);

	signal out3 : std_logic_vector(65 downto 0);

	signal out4 : std_logic_vector(34 downto 0);

	signal out5 : std_logic_vector(31 downto 0);

begin

	out1(0) <= DI(2) XOR DI(7);
	out1(1) <= DI(1) XOR DI(23);
	out1(2) <= DI(0) XOR DI(22);
	out1(3) <= DI(4) XOR DI(16);
	out1(4) <= DI(3) XOR DI(6);
	out1(5) <= DI(8) XOR DI(20);
	out1(6) <= DI(26);
	out1(7) <= DI(4) XOR DI(5);
	out1(8) <= DI(17) XOR DI(24);
	out1(9) <= DI(9) XOR DI(21);
	out1(10) <= DI(3) XOR DI(8);
	out1(11) <= DI(27);
	out1(12) <= DI(18) XOR DI(25);
	out1(13) <= DI(24) XOR DI(28);
	out1(14) <= DI(2) XOR DI(9);
	out1(15) <= DI(8) XOR DI(10);
	out1(16) <= DI(7) XOR DI(19);
	out1(17) <= DI(10) XOR DI(26);
	out1(18) <= DI(25) XOR DI(29);
	out1(19) <= DI(9) XOR DI(11);
	out1(20) <= DI(11) XOR DI(27);
	out1(21) <= DI(6) XOR DI(30);
	out1(22) <= DI(12) XOR DI(24);
	out1(23) <= DI(12) XOR DI(28);
	out1(24) <= DI(0) XOR DI(31);
	out1(25) <= DI(5) XOR DI(7);
	out1(26) <= DI(8) XOR DI(13);
	out1(27) <= DI(25);
	out1(28) <= DI(13) XOR DI(29);
	out1(29) <= DI(16) XOR DI(23);
	out1(30) <= DI(3) XOR DI(20);
	out1(31) <= DI(0) XOR DI(10);
	out1(32) <= DI(14);
	out1(33) <= DI(14) XOR DI(30);
	out1(34) <= DI(3) XOR DI(21);
	out1(35) <= DI(1) XOR DI(4);
	out1(36) <= DI(10) XOR DI(11);
	out1(37) <= DI(15);
	out1(38) <= DI(15) XOR DI(31);
	out1(39) <= DI(12) XOR DI(16);
	out1(40) <= DI(2) XOR DI(11);
	out1(41) <= DI(12) XOR DI(13);
	out1(42) <= DI(17) XOR DI(19);
	out1(43) <= DI(18) XOR DI(26);
	out1(44) <= DI(13) XOR DI(14);
	out1(45) <= DI(19) XOR DI(27);
	out1(46) <= DI(5) XOR DI(14);
	out1(47) <= DI(15) XOR DI(22);
	out1(48) <= DI(6) XOR DI(20);
	out1(49) <= DI(15) XOR DI(23);
	out1(50) <= DI(0);
	out1(51) <= DI(17) XOR DI(26);
	out1(52) <= DI(9) XOR DI(12);
	out1(53) <= DI(18) XOR DI(31);
	out1(54) <= DI(13);
	out1(55) <= DI(2);
	out1(56) <= DI(0) XOR DI(15);
	out1(57) <= DI(26) XOR DI(30);
	out1(58) <= DI(1) XOR DI(27);
	out1(59) <= DI(31);
	out1(60) <= DI(16) XOR DI(17);
	out1(61) <= DI(28);
	out1(62) <= DI(2) XOR DI(3);
	out1(63) <= DI(5) XOR DI(17);
	out1(64) <= DI(29);
	out1(65) <= DI(22) XOR DI(30);
	out1(66) <= DI(3) XOR DI(23);
	out1(67) <= DI(8) XOR DI(29);
	out1(68) <= DI(20);
	out1(69) <= DI(24) XOR DI(30);
	out1(70) <= DI(19) XOR DI(25);
	out1(71) <= DI(16);
	out1(72) <= DI(6) XOR DI(21);
	out1(73) <= DI(23);
	out1(74) <= DI(4) XOR DI(22);
	out1(75) <= DI(24);
	out1(76) <= DI(1) XOR DI(5);
	out1(77) <= DI(21);

	out2(0) <= out1(0) XOR out1(1);
	out2(1) <= out1(2) XOR out1(3);
	out2(2) <= out1(4) XOR out1(5);
	out2(3) <= out1(6);
	out2(4) <= out1(7) XOR out1(8);
	out2(5) <= out1(9) XOR out1(10);
	out2(6) <= out1(11);
	out2(7) <= out1(4) XOR out1(7);
	out2(8) <= out1(2) XOR out1(12);
	out2(9) <= out1(13) XOR out1(14);
	out2(10) <= out1(15);
	out2(11) <= out1(1) XOR out1(16);
	out2(12) <= out1(17) XOR out1(18);
	out2(13) <= out1(19);
	out2(14) <= out1(17) XOR out1(20);
	out2(15) <= out1(0) XOR out1(7);
	out2(16) <= out1(5) XOR out1(21);
	out2(17) <= out1(22);
	out2(18) <= out1(4) XOR out1(9);
	out2(19) <= out1(20) XOR out1(23);
	out2(20) <= out1(24) XOR out1(25);
	out2(21) <= out1(26) XOR out1(27);
	out2(22) <= out1(23) XOR out1(28);
	out2(23) <= out1(14) XOR out1(29);
	out2(24) <= out1(30) XOR out1(31);
	out2(25) <= out1(32);
	out2(26) <= out1(8) XOR out1(28);
	out2(27) <= out1(33) XOR out1(34);
	out2(28) <= out1(35) XOR out1(36);
	out2(29) <= out1(37);
	out2(30) <= out1(2) XOR out1(38);
	out2(31) <= out1(12) XOR out1(33);
	out2(32) <= out1(7) XOR out1(39);
	out2(33) <= out1(40);
	out2(34) <= out1(5) XOR out1(41);
	out2(35) <= out1(42);
	out2(36) <= out1(2) XOR out1(9);
	out2(37) <= out1(43) XOR out1(44);
	out2(38) <= out1(45) XOR out1(46);
	out2(39) <= out1(1) XOR out1(4);
	out2(40) <= out1(15) XOR out1(47);
	out2(41) <= out1(0) XOR out1(13);
	out2(42) <= out1(3) XOR out1(19);
	out2(43) <= out1(48) XOR out1(49);
	out2(44) <= out1(8) XOR out1(18);
	out2(45) <= out1(15) XOR out1(25);
	out2(46) <= out1(34) XOR out1(39);
	out2(47) <= out1(50);
	out2(48) <= out1(19) XOR out1(21);
	out2(49) <= out1(26) XOR out1(35);
	out2(50) <= out1(51);
	out2(51) <= out1(17) XOR out1(52);
	out2(52) <= out1(53);
	out2(53) <= out1(3) XOR out1(13);
	out2(54) <= out1(47) XOR out1(54);
	out2(55) <= out1(5) XOR out1(29);
	out2(56) <= out1(46) XOR out1(55);
	out2(57) <= out1(8) XOR out1(12);
	out2(58) <= out1(56) XOR out1(57);
	out2(59) <= out1(17) XOR out1(28);
	out2(60) <= out1(16) XOR out1(58);
	out2(61) <= out1(59);
	out2(62) <= out1(20) XOR out1(33);
	out2(63) <= out1(16) XOR out1(60);
	out2(64) <= out1(61);
	out2(65) <= out1(23) XOR out1(43);
	out2(66) <= out1(62) XOR out1(63);
	out2(67) <= out1(64);
	out2(68) <= out1(5) XOR out1(45);
	out2(69) <= out1(0) XOR out1(28);
	out2(70) <= out1(43) XOR out1(65);
	out2(71) <= out1(33) XOR out1(9);
	out2(72) <= out1(24) XOR out1(66);
	out2(73) <= out1(17) XOR out1(38);
	out2(74) <= out1(29) XOR out1(67);
	out2(75) <= out1(1) XOR out1(14);
	out2(76) <= out1(21) XOR out1(68);
	out2(77) <= out1(0) XOR out1(12);
	out2(78) <= out1(23) XOR out1(34);
	out2(79) <= out1(69) XOR out1(59);
	out2(80) <= out1(20) XOR out1(24);
	out2(81) <= out1(48) XOR out1(70);
	out2(82) <= out1(71);
	out2(83) <= out1(8) XOR out1(33);
	out2(84) <= out1(72) XOR out1(73);
	out2(85) <= out1(1) XOR out1(25);
	out2(86) <= out1(38) XOR out1(16);
	out2(87) <= out1(30) XOR out1(74);
	out2(88) <= out1(75);
	out2(89) <= out1(0) XOR out1(4);
	out2(90) <= out1(70) XOR out1(76);
	out2(91) <= out1(77);

	out3(0) <= out2(0) XOR out2(1);
	out3(1) <= out2(2) XOR out2(3);
	out3(2) <= out2(0) XOR out2(4);
	out3(3) <= out2(5) XOR out2(6);
	out3(4) <= out2(7) XOR out2(8);
	out3(5) <= out2(9) XOR out2(10);
	out3(6) <= out2(7) XOR out2(11);
	out3(7) <= out2(12) XOR out2(13);
	out3(8) <= out2(14) XOR out2(15);
	out3(9) <= out2(16) XOR out2(17);
	out3(10) <= out2(18) XOR out2(19);
	out3(11) <= out2(20) XOR out2(21);
	out3(12) <= out2(22) XOR out2(23);
	out3(13) <= out2(24) XOR out2(25);
	out3(14) <= out2(26) XOR out2(27);
	out3(15) <= out2(28) XOR out2(29);
	out3(16) <= out2(30) XOR out2(31);
	out3(17) <= out2(32) XOR out2(33);
	out3(18) <= out2(30) XOR out2(15);
	out3(19) <= out2(34) XOR out2(35);
	out3(20) <= out2(15) XOR out2(36);
	out3(21) <= out2(37);
	out3(22) <= out2(38) XOR out2(39);
	out3(23) <= out2(40);
	out3(24) <= out2(41) XOR out2(42);
	out3(25) <= out2(43);
	out3(26) <= out2(44) XOR out2(45);
	out3(27) <= out2(46) XOR out2(47);
	out3(28) <= out2(8) XOR out2(48);
	out3(29) <= out2(49) XOR out2(50);
	out3(30) <= out2(0) XOR out2(38);
	out3(31) <= out2(51) XOR out2(52);
	out3(32) <= out2(14) XOR out2(11);
	out3(33) <= out2(53) XOR out2(54);
	out3(34) <= out2(44) XOR out2(19);
	out3(35) <= out2(55) XOR out2(56);
	out3(36) <= out2(22) XOR out2(18);
	out3(37) <= out2(57) XOR out2(58);
	out3(38) <= out2(31) XOR out2(1);
	out3(39) <= out2(59) XOR out2(60);
	out3(40) <= out2(61);
	out3(41) <= out2(30) XOR out2(7);
	out3(42) <= out2(62) XOR out2(63);
	out3(43) <= out2(64);
	out3(44) <= out2(30) XOR out2(65);
	out3(45) <= out2(66) XOR out2(67);
	out3(46) <= out2(68) XOR out2(69);
	out3(47) <= out2(70);
	out3(48) <= out2(68) XOR out2(71);
	out3(49) <= out2(72) XOR out2(64);
	out3(50) <= out2(18) XOR out2(41);
	out3(51) <= out2(73) XOR out2(74);
	out3(52) <= out2(14) XOR out2(44);
	out3(53) <= out2(75) XOR out2(76);
	out3(54) <= out2(14) XOR out2(77);
	out3(55) <= out2(78) XOR out2(79);
	out3(56) <= out2(0) XOR out2(22);
	out3(57) <= out2(80) XOR out2(81);
	out3(58) <= out2(82);
	out3(59) <= out2(22) XOR out2(1);
	out3(60) <= out2(83) XOR out2(84);
	out3(61) <= out2(26) XOR out2(85);
	out3(62) <= out2(31) XOR out2(86);
	out3(63) <= out2(87) XOR out2(88);
	out3(64) <= out2(30) XOR out2(89);
	out3(65) <= out2(90) XOR out2(91);

	out4(0) <= out3(0) XOR out3(1);
	out4(1) <= out3(2) XOR out3(3);
	out4(2) <= out3(4) XOR out3(5);
	out4(3) <= out3(6) XOR out3(7);
	out4(4) <= out3(8) XOR out3(9);
	out4(5) <= out3(10) XOR out3(11);
	out4(6) <= out3(12) XOR out3(13);
	out4(7) <= out3(14) XOR out3(15);
	out4(8) <= out3(16) XOR out3(17);
	out4(9) <= out3(18) XOR out3(19);
	out4(10) <= out3(20) XOR out3(21);
	out4(11) <= out3(22) XOR out3(23);
	out4(12) <= out3(24) XOR out3(25);
	out4(13) <= out3(26) XOR out3(27);
	out4(14) <= out3(28) XOR out3(29);
	out4(15) <= out3(30) XOR out3(31);
	out4(16) <= out3(32) XOR out3(33);
	out4(17) <= out3(34) XOR out3(35);
	out4(18) <= out3(36) XOR out3(37);
	out4(19) <= out3(38) XOR out3(39);
	out4(20) <= out3(40);
	out4(21) <= out3(41) XOR out3(42);
	out4(22) <= out3(43);
	out4(23) <= out3(44) XOR out3(45);
	out4(24) <= out3(46) XOR out3(47);
	out4(25) <= out3(48) XOR out3(49);
	out4(26) <= out3(50) XOR out3(51);
	out4(27) <= out3(52) XOR out3(53);
	out4(28) <= out3(54) XOR out3(55);
	out4(29) <= out3(56) XOR out3(57);
	out4(30) <= out3(58);
	out4(31) <= out3(59) XOR out3(60);
	out4(32) <= out3(16) XOR out3(61);
	out4(33) <= out3(62) XOR out3(63);
	out4(34) <= out3(64) XOR out3(65);

	out5(0) <= out4(0);
	out5(1) <= out4(1);
	out5(2) <= out4(2);
	out5(3) <= out4(3);
	out5(4) <= out4(4);
	out5(5) <= out4(5);
	out5(6) <= out4(6);
	out5(7) <= out4(7);
	out5(8) <= out4(8);
	out5(9) <= out4(9);
	out5(10) <= out4(10);
	out5(11) <= out4(11);
	out5(12) <= out4(12);
	out5(13) <= out4(13);
	out5(14) <= out4(14);
	out5(15) <= out4(15);
	out5(16) <= out4(16);
	out5(17) <= out4(17);
	out5(18) <= out4(18);
	out5(19) <= out4(19) XOR out4(20);
	out5(20) <= out4(21) XOR out4(22);
	out5(21) <= out4(23);
	out5(22) <= out4(24);
	out5(23) <= out4(25);
	out5(24) <= out4(26);
	out5(25) <= out4(27);
	out5(26) <= out4(28);
	out5(27) <= out4(29) XOR out4(30);
	out5(28) <= out4(31);
	out5(29) <= out4(32);
	out5(30) <= out4(33);
	out5(31) <= out4(34);

	DO(0) <= out5(0);
	DO(1) <= out5(1);
	DO(2) <= out5(2);
	DO(3) <= out5(3);
	DO(4) <= out5(4);
	DO(5) <= out5(5);
	DO(6) <= out5(6);
	DO(7) <= out5(7);
	DO(8) <= out5(8);
	DO(9) <= out5(9);
	DO(10) <= out5(10);
	DO(11) <= out5(11);
	DO(12) <= out5(12);
	DO(13) <= out5(13);
	DO(14) <= out5(14);
	DO(15) <= out5(15);
	DO(16) <= out5(16);
	DO(17) <= out5(17);
	DO(18) <= out5(18);
	DO(19) <= out5(19);
	DO(20) <= out5(20);
	DO(21) <= out5(21);
	DO(22) <= out5(22);
	DO(23) <= out5(23);
	DO(24) <= out5(24);
	DO(25) <= out5(25);
	DO(26) <= out5(26);
	DO(27) <= out5(27);
	DO(28) <= out5(28);
	DO(29) <= out5(29);
	DO(30) <= out5(30);
	DO(31) <= out5(31);

end architecture;
