-- cgmii_enc_ent.vhd: CGMII_OBUF_ENC entity.
-- Copyright (C) 2012 CESNET
-- Author(s): Vaclav Hummel <xhumme00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
--
--


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
--! CGMII encoder component for CGMII OBUF
entity cgmii_obuf_enc is
   port (
      -----------------------------------------------------
      --! \ name Common interface
      -----------------------------------------------------
      --! Input clock
      CLK         : in std_logic;
      --! Synchronous reset
      RESET       : in std_logic;
      
      -----------------------------------------------------
      --! \name RX input interface 
      -----------------------------------------------------
      --! Read side ready
      RX_DATA        : in std_logic_vector(511 downto 0);
      --! SOP block indication (one-hot)
      RX_SOP_V       : in std_logic_vector(7 downto 0);
      --! EOP block indication (one-hot)
      RX_EOP_V       : in std_logic_vector(7 downto 0);
      --! End in block position
      RX_EOP_POS     : in std_logic_vector(2 downto 0);

      -----------------------------------------------------
      --! \name CRC32 FIFO interface
      -----------------------------------------------------
      --! CRC32 FIFO input
      CRC32_DATA_IN : in std_logic_vector(31 downto 0);
      --! CRC32 FIFO read request
      CRC32_READ_REQ : out std_logic;

      -----------------------------------------------------
      --! \name CGMII output interface
      -----------------------------------------------------
      --! CGMII data bus
      CGMII_TXD     : out std_logic_vector(511 downto 0);
      --! CGMII control bus
      CGMII_TXC     : out std_logic_vector(63 downto 0)
   );
end entity cgmii_obuf_enc;
