--
-- cam_fill_element.vhd: Basic filling element of CAM.
-- Copyright (C) 2005 CESNET
-- Author(s): Martin Kosek <xkosek00@stud.fit.vutbr.cz>
--            Libor Polcak <polcak_l@liberouter.org>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity ibuf_cam_fill_element is
   port(
      CNT_IN         : in std_logic_vector(3 downto 0);
      DATA_IN        : in std_logic_vector(3 downto 0);
      DATA_FILL      : out std_logic
   );
end entity ibuf_cam_fill_element;


-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture ibuf_cam_fill_element_arch of ibuf_cam_fill_element is

-- ------------------ Signals declaration -------------------------------------
   signal cmp_out : std_logic;

begin

-- --------------------------- Comparator -------------------------------------
cmp_outp: process(CNT_IN, DATA_IN)
begin
   if CNT_IN = DATA_IN then
      cmp_out <= '1';
   else
      cmp_out <= '0';
   end if;
end process;

DATA_FILL <= cmp_out;

end architecture ibuf_cam_fill_element_arch;
