-- am_ins.vhd : Alignment marker inserter
--                     
-- Copyright (C) 2010 CESNET
-- Author(s): Stepan Friedl <friedl@liberouter.org>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: comboi10g4_arch.vhd 13948 2010-06-04 15:49:43Z xfried00 $
--
-- NOTES:

library ieee;
use ieee.std_logic_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity am_ins is
   generic (
      NUM_LANES : natural range 0 to 20 := 4
   );
   port (
      RESET : in std_logic; 
      CLK   : in std_logic; 
      EN    : in std_logic; -- Clock enable
      RD    : out std_logic; 
      D     : in std_logic_vector(NUM_LANES*66-1 downto 0);  -- Input data
      Q     : out std_logic_vector(NUM_LANES*66-1 downto 0)  -- Generated marker
   );
end am_ins;

architecture behavioral of am_ins is

attribute keep : string;
attribute max_fanout : integer;

signal q_i        : std_logic_vector(66*NUM_LANES-1 downto 0);
signal am_counter : std_logic_vector(13 downto 0);
signal am : std_logic_vector(66*NUM_LANES-1 downto 0);
signal am_insert : std_logic := '0';
signal ag_reset  : std_logic;
attribute keep of am_insert : signal is "true";
attribute max_fanout of am_insert : signal is 200;

begin

-- Generate alignment marger generators
GEN_AM: for i in 0 to NUM_LANES-1 generate
   MARKER: entity work.am_gen
   generic map (
      LANE => i
   )
   port map (
      RESET => ag_reset,
      CLK   => clk,
      EN    => EN,
      D     => q_i(66*(i+1)-1 downto 66*i),
      M     => am(66*(i+1)-1 downto 66*i)
   );
end generate;

ag_reset <= am_insert or reset;

AM_CNTR: process(CLK, reset)
begin
   if CLK'event and CLK = '1' then
      if reset = '1' then
         am_counter <= (others => '0');
      elsif EN = '1' then
         am_counter <= am_counter + 1;
      end if;
      if (am_counter = X"3FFF") then
         am_insert <= EN;
      elsif (EN = '1') then
         am_insert <= '0';
      end if;
   end if;
end process;

q_i <= D when am_insert ='0' else am;

Q  <= q_i;
RD <= not am_insert;

end behavioral;
