-- crc16_104.vhd: A 16-bit CRC table for processing 104 bits in parallel
-- Copyright (C) 2012 Brno University of Technology
-- Author(s): Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: crc16_104.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity crc16_104 is
   port(
      DI    : in  std_logic_vector(104-1 downto 0);
      DO    : out std_logic_vector(15 downto 0)
   );
end entity;

-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ansi of crc16_104 is
begin
-- 16-bit CRC equations processing 104 bits in parallel (VHDL code)
-- Generator polynomial: 0x18005
   DO(0) <= DI(1) XOR DI(5) XOR DI(33) XOR DI(61) XOR DI(18) XOR DI(3) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(59) XOR DI(74) XOR DI(89) XOR DI(32) XOR DI(17) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(58) XOR DI(73) XOR DI(88) XOR DI(31) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(72) XOR DI(87) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(56) XOR DI(71) XOR DI(86) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(55) XOR DI(70) XOR DI(85) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(54) XOR DI(69) XOR DI(84) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(53) XOR DI(68) XOR DI(83) XOR DI(7) XOR DI(22) XOR DI(37) XOR DI(52) XOR DI(67) XOR DI(82) XOR DI(21) XOR DI(36) XOR DI(51) XOR DI(66) XOR DI(81) XOR DI(35) XOR DI(50) XOR DI(65) XOR DI(80) XOR DI(49) XOR DI(64) XOR DI(79) XOR DI(63) XOR DI(78) XOR DI(77) XOR DI(91) XOR DI(92) XOR DI(93) XOR DI(94) XOR DI(95) XOR DI(96) XOR DI(97) XOR DI(98) XOR DI(99) XOR DI(100) XOR DI(101) XOR DI(102) XOR DI(103);
   DO(1) <= DI(3) XOR DI(17) XOR DI(2) XOR DI(7) XOR DI(6) XOR DI(21) XOR DI(35) XOR DI(34) XOR DI(49) XOR DI(63) XOR DI(62) XOR DI(77) XOR DI(5) XOR DI(1) XOR DI(31) XOR DI(61) XOR DI(19) XOR DI(4) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(60) XOR DI(75) XOR DI(90) XOR DI(91);
   DO(2) <= DI(4) XOR DI(18) XOR DI(3) XOR DI(8) XOR DI(7) XOR DI(22) XOR DI(36) XOR DI(35) XOR DI(50) XOR DI(64) XOR DI(63) XOR DI(78) XOR DI(6) XOR DI(2) XOR DI(32) XOR DI(62) XOR DI(20) XOR DI(5) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(46) XOR DI(61) XOR DI(76) XOR DI(91) XOR DI(92);
   DO(3) <= DI(5) XOR DI(19) XOR DI(4) XOR DI(9) XOR DI(8) XOR DI(23) XOR DI(37) XOR DI(36) XOR DI(51) XOR DI(65) XOR DI(64) XOR DI(79) XOR DI(7) XOR DI(3) XOR DI(33) XOR DI(63) XOR DI(21) XOR DI(6) XOR DI(2) XOR DI(17) XOR DI(32) XOR DI(47) XOR DI(62) XOR DI(77) XOR DI(92) XOR DI(93);
   DO(4) <= DI(6) XOR DI(20) XOR DI(5) XOR DI(10) XOR DI(9) XOR DI(24) XOR DI(38) XOR DI(37) XOR DI(52) XOR DI(66) XOR DI(65) XOR DI(80) XOR DI(8) XOR DI(4) XOR DI(34) XOR DI(64) XOR DI(22) XOR DI(7) XOR DI(3) XOR DI(18) XOR DI(33) XOR DI(48) XOR DI(63) XOR DI(78) XOR DI(93) XOR DI(94);
   DO(5) <= DI(7) XOR DI(21) XOR DI(6) XOR DI(11) XOR DI(10) XOR DI(25) XOR DI(39) XOR DI(38) XOR DI(53) XOR DI(67) XOR DI(66) XOR DI(81) XOR DI(9) XOR DI(5) XOR DI(35) XOR DI(65) XOR DI(23) XOR DI(8) XOR DI(4) XOR DI(19) XOR DI(34) XOR DI(49) XOR DI(64) XOR DI(79) XOR DI(94) XOR DI(95);
   DO(6) <= DI(8) XOR DI(22) XOR DI(7) XOR DI(12) XOR DI(11) XOR DI(26) XOR DI(40) XOR DI(39) XOR DI(54) XOR DI(68) XOR DI(67) XOR DI(82) XOR DI(10) XOR DI(6) XOR DI(36) XOR DI(66) XOR DI(24) XOR DI(9) XOR DI(5) XOR DI(20) XOR DI(35) XOR DI(50) XOR DI(65) XOR DI(80) XOR DI(95) XOR DI(96);
   DO(7) <= DI(9) XOR DI(23) XOR DI(8) XOR DI(13) XOR DI(12) XOR DI(27) XOR DI(41) XOR DI(40) XOR DI(55) XOR DI(69) XOR DI(68) XOR DI(83) XOR DI(11) XOR DI(7) XOR DI(37) XOR DI(67) XOR DI(25) XOR DI(10) XOR DI(6) XOR DI(21) XOR DI(36) XOR DI(51) XOR DI(66) XOR DI(81) XOR DI(96) XOR DI(97);
   DO(8) <= DI(10) XOR DI(24) XOR DI(9) XOR DI(0) XOR DI(14) XOR DI(13) XOR DI(28) XOR DI(42) XOR DI(41) XOR DI(56) XOR DI(70) XOR DI(69) XOR DI(84) XOR DI(12) XOR DI(8) XOR DI(38) XOR DI(68) XOR DI(26) XOR DI(11) XOR DI(7) XOR DI(22) XOR DI(37) XOR DI(52) XOR DI(67) XOR DI(82) XOR DI(97) XOR DI(98);
   DO(9) <= DI(11) XOR DI(25) XOR DI(10) XOR DI(1) XOR DI(15) XOR DI(14) XOR DI(29) XOR DI(43) XOR DI(42) XOR DI(57) XOR DI(71) XOR DI(70) XOR DI(85) XOR DI(13) XOR DI(9) XOR DI(39) XOR DI(69) XOR DI(27) XOR DI(12) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(53) XOR DI(68) XOR DI(83) XOR DI(98) XOR DI(99);
   DO(10) <= DI(12) XOR DI(26) XOR DI(11) XOR DI(2) XOR DI(16) XOR DI(15) XOR DI(30) XOR DI(44) XOR DI(43) XOR DI(58) XOR DI(72) XOR DI(71) XOR DI(86) XOR DI(14) XOR DI(10) XOR DI(40) XOR DI(70) XOR DI(28) XOR DI(13) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(54) XOR DI(69) XOR DI(84) XOR DI(99) XOR DI(100);
   DO(11) <= DI(13) XOR DI(27) XOR DI(12) XOR DI(3) XOR DI(17) XOR DI(16) XOR DI(31) XOR DI(45) XOR DI(44) XOR DI(59) XOR DI(73) XOR DI(72) XOR DI(87) XOR DI(15) XOR DI(11) XOR DI(41) XOR DI(71) XOR DI(29) XOR DI(14) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(55) XOR DI(70) XOR DI(85) XOR DI(100) XOR DI(101);
   DO(12) <= DI(14) XOR DI(28) XOR DI(13) XOR DI(4) XOR DI(18) XOR DI(17) XOR DI(32) XOR DI(46) XOR DI(45) XOR DI(60) XOR DI(74) XOR DI(73) XOR DI(88) XOR DI(16) XOR DI(12) XOR DI(42) XOR DI(72) XOR DI(30) XOR DI(15) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(56) XOR DI(71) XOR DI(86) XOR DI(101) XOR DI(102);
   DO(13) <= DI(15) XOR DI(29) XOR DI(14) XOR DI(5) XOR DI(19) XOR DI(18) XOR DI(33) XOR DI(47) XOR DI(46) XOR DI(61) XOR DI(75) XOR DI(74) XOR DI(89) XOR DI(17) XOR DI(13) XOR DI(43) XOR DI(73) XOR DI(31) XOR DI(16) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(72) XOR DI(87) XOR DI(102) XOR DI(103);
   DO(14) <= DI(3) XOR DI(31) XOR DI(59) XOR DI(16) XOR DI(1) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(72) XOR DI(87) XOR DI(30) XOR DI(15) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(56) XOR DI(71) XOR DI(86) XOR DI(29) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(55) XOR DI(70) XOR DI(85) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(54) XOR DI(69) XOR DI(84) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(53) XOR DI(68) XOR DI(83) XOR DI(7) XOR DI(22) XOR DI(37) XOR DI(52) XOR DI(67) XOR DI(82) XOR DI(6) XOR DI(21) XOR DI(36) XOR DI(51) XOR DI(66) XOR DI(81) XOR DI(5) XOR DI(20) XOR DI(35) XOR DI(50) XOR DI(65) XOR DI(80) XOR DI(19) XOR DI(34) XOR DI(49) XOR DI(64) XOR DI(79) XOR DI(33) XOR DI(48) XOR DI(63) XOR DI(78) XOR DI(47) XOR DI(62) XOR DI(77) XOR DI(61) XOR DI(76) XOR DI(75) XOR DI(89) XOR DI(90) XOR DI(91) XOR DI(92) XOR DI(93) XOR DI(94) XOR DI(95) XOR DI(96) XOR DI(97) XOR DI(98) XOR DI(99) XOR DI(100) XOR DI(101) XOR DI(102);
   DO(15) <= DI(0) XOR DI(4) XOR DI(32) XOR DI(60) XOR DI(17) XOR DI(2) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(58) XOR DI(73) XOR DI(88) XOR DI(31) XOR DI(16) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(72) XOR DI(87) XOR DI(30) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(56) XOR DI(71) XOR DI(86) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(55) XOR DI(70) XOR DI(85) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(54) XOR DI(69) XOR DI(84) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(53) XOR DI(68) XOR DI(83) XOR DI(7) XOR DI(22) XOR DI(37) XOR DI(52) XOR DI(67) XOR DI(82) XOR DI(6) XOR DI(21) XOR DI(36) XOR DI(51) XOR DI(66) XOR DI(81) XOR DI(20) XOR DI(35) XOR DI(50) XOR DI(65) XOR DI(80) XOR DI(34) XOR DI(49) XOR DI(64) XOR DI(79) XOR DI(48) XOR DI(63) XOR DI(78) XOR DI(62) XOR DI(77) XOR DI(76) XOR DI(90) XOR DI(91) XOR DI(92) XOR DI(93) XOR DI(94) XOR DI(95) XOR DI(96) XOR DI(97) XOR DI(98) XOR DI(99) XOR DI(100) XOR DI(101) XOR DI(102) XOR DI(103);
  
end architecture;





-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ccitt of crc16_104 is
begin
-- 16-bit CRC equations processing 104 bits in parallel (VHDL code)
-- Generator polynomial: 0x11021
   DO(0) <= DI(8) XOR DI(24) XOR DI(39) XOR DI(6) XOR DI(53) XOR DI(40) XOR DI(46) XOR DI(55) XOR DI(22) XOR DI(69) XOR DI(77) XOR DI(56) XOR DI(62) XOR DI(0) XOR DI(32) XOR DI(76) XOR DI(84) XOR DI(29) XOR DI(71) XOR DI(27) XOR DI(82) XOR DI(9) XOR DI(38) XOR DI(41) XOR DI(85) XOR DI(93) XOR DI(20) XOR DI(49) XOR DI(18) XOR DI(52) XOR DI(72) XOR DI(23) XOR DI(78) XOR DI(34) XOR DI(37) XOR DI(16) XOR DI(48) XOR DI(30) XOR DI(92) XOR DI(96) XOR DI(100);
   DO(1) <= DI(9) XOR DI(25) XOR DI(40) XOR DI(7) XOR DI(54) XOR DI(41) XOR DI(47) XOR DI(56) XOR DI(23) XOR DI(70) XOR DI(78) XOR DI(57) XOR DI(63) XOR DI(1) XOR DI(33) XOR DI(77) XOR DI(85) XOR DI(30) XOR DI(72) XOR DI(28) XOR DI(83) XOR DI(10) XOR DI(39) XOR DI(42) XOR DI(86) XOR DI(94) XOR DI(21) XOR DI(50) XOR DI(19) XOR DI(53) XOR DI(73) XOR DI(24) XOR DI(79) XOR DI(35) XOR DI(38) XOR DI(17) XOR DI(49) XOR DI(31) XOR DI(93) XOR DI(97) XOR DI(101);
   DO(2) <= DI(10) XOR DI(26) XOR DI(41) XOR DI(8) XOR DI(55) XOR DI(42) XOR DI(48) XOR DI(57) XOR DI(24) XOR DI(71) XOR DI(79) XOR DI(58) XOR DI(64) XOR DI(2) XOR DI(34) XOR DI(78) XOR DI(86) XOR DI(31) XOR DI(73) XOR DI(0) XOR DI(29) XOR DI(84) XOR DI(11) XOR DI(40) XOR DI(43) XOR DI(87) XOR DI(95) XOR DI(22) XOR DI(51) XOR DI(20) XOR DI(54) XOR DI(74) XOR DI(25) XOR DI(80) XOR DI(36) XOR DI(39) XOR DI(18) XOR DI(50) XOR DI(32) XOR DI(94) XOR DI(98) XOR DI(102);
   DO(3) <= DI(11) XOR DI(27) XOR DI(42) XOR DI(9) XOR DI(56) XOR DI(43) XOR DI(49) XOR DI(58) XOR DI(25) XOR DI(72) XOR DI(80) XOR DI(59) XOR DI(65) XOR DI(3) XOR DI(35) XOR DI(79) XOR DI(87) XOR DI(0) XOR DI(32) XOR DI(74) XOR DI(1) XOR DI(30) XOR DI(85) XOR DI(12) XOR DI(41) XOR DI(44) XOR DI(88) XOR DI(96) XOR DI(23) XOR DI(52) XOR DI(21) XOR DI(55) XOR DI(75) XOR DI(26) XOR DI(81) XOR DI(37) XOR DI(40) XOR DI(19) XOR DI(51) XOR DI(33) XOR DI(95) XOR DI(99) XOR DI(103);
   DO(4) <= DI(12) XOR DI(28) XOR DI(43) XOR DI(10) XOR DI(57) XOR DI(44) XOR DI(50) XOR DI(72) XOR DI(59) XOR DI(26) XOR DI(29) XOR DI(73) XOR DI(81) XOR DI(8) XOR DI(37) XOR DI(6) XOR DI(40) XOR DI(60) XOR DI(66) XOR DI(4) XOR DI(36) XOR DI(18) XOR DI(80) XOR DI(84) XOR DI(88) XOR DI(92) XOR DI(1) XOR DI(32) XOR DI(46) XOR DI(33) XOR DI(39) XOR DI(48) XOR DI(62) XOR DI(49) XOR DI(55) XOR DI(69) XOR DI(77) XOR DI(75) XOR DI(2) XOR DI(31) XOR DI(78) XOR DI(86) XOR DI(13) XOR DI(42) XOR DI(45) XOR DI(16) XOR DI(71) XOR DI(30) XOR DI(9) XOR DI(23) XOR DI(85) XOR DI(89) XOR DI(93) XOR DI(97);
   DO(5) <= DI(13) XOR DI(29) XOR DI(44) XOR DI(11) XOR DI(58) XOR DI(45) XOR DI(51) XOR DI(73) XOR DI(60) XOR DI(27) XOR DI(30) XOR DI(74) XOR DI(82) XOR DI(9) XOR DI(38) XOR DI(7) XOR DI(41) XOR DI(61) XOR DI(67) XOR DI(5) XOR DI(37) XOR DI(19) XOR DI(81) XOR DI(85) XOR DI(89) XOR DI(93) XOR DI(2) XOR DI(33) XOR DI(0) XOR DI(47) XOR DI(34) XOR DI(40) XOR DI(49) XOR DI(63) XOR DI(50) XOR DI(56) XOR DI(70) XOR DI(78) XOR DI(76) XOR DI(3) XOR DI(32) XOR DI(79) XOR DI(87) XOR DI(14) XOR DI(43) XOR DI(46) XOR DI(17) XOR DI(72) XOR DI(31) XOR DI(10) XOR DI(24) XOR DI(86) XOR DI(90) XOR DI(94) XOR DI(98);
   DO(6) <= DI(14) XOR DI(30) XOR DI(45) XOR DI(12) XOR DI(59) XOR DI(46) XOR DI(52) XOR DI(74) XOR DI(61) XOR DI(28) XOR DI(31) XOR DI(75) XOR DI(83) XOR DI(10) XOR DI(39) XOR DI(8) XOR DI(42) XOR DI(62) XOR DI(68) XOR DI(6) XOR DI(38) XOR DI(20) XOR DI(82) XOR DI(86) XOR DI(90) XOR DI(94) XOR DI(3) XOR DI(34) XOR DI(1) XOR DI(48) XOR DI(35) XOR DI(41) XOR DI(50) XOR DI(64) XOR DI(51) XOR DI(57) XOR DI(71) XOR DI(79) XOR DI(77) XOR DI(4) XOR DI(33) XOR DI(80) XOR DI(88) XOR DI(15) XOR DI(44) XOR DI(47) XOR DI(18) XOR DI(73) XOR DI(32) XOR DI(11) XOR DI(25) XOR DI(87) XOR DI(91) XOR DI(95) XOR DI(99);
   DO(7) <= DI(15) XOR DI(31) XOR DI(46) XOR DI(13) XOR DI(60) XOR DI(47) XOR DI(53) XOR DI(75) XOR DI(62) XOR DI(0) XOR DI(29) XOR DI(32) XOR DI(76) XOR DI(84) XOR DI(11) XOR DI(40) XOR DI(9) XOR DI(43) XOR DI(63) XOR DI(69) XOR DI(7) XOR DI(39) XOR DI(21) XOR DI(83) XOR DI(87) XOR DI(91) XOR DI(95) XOR DI(4) XOR DI(35) XOR DI(2) XOR DI(49) XOR DI(36) XOR DI(42) XOR DI(51) XOR DI(65) XOR DI(52) XOR DI(58) XOR DI(72) XOR DI(80) XOR DI(78) XOR DI(5) XOR DI(34) XOR DI(81) XOR DI(89) XOR DI(16) XOR DI(45) XOR DI(48) XOR DI(19) XOR DI(74) XOR DI(33) XOR DI(12) XOR DI(26) XOR DI(88) XOR DI(92) XOR DI(96) XOR DI(100);
   DO(8) <= DI(0) XOR DI(16) XOR DI(32) XOR DI(47) XOR DI(14) XOR DI(61) XOR DI(48) XOR DI(54) XOR DI(76) XOR DI(63) XOR DI(1) XOR DI(30) XOR DI(33) XOR DI(77) XOR DI(85) XOR DI(12) XOR DI(41) XOR DI(10) XOR DI(44) XOR DI(64) XOR DI(70) XOR DI(8) XOR DI(40) XOR DI(22) XOR DI(84) XOR DI(88) XOR DI(92) XOR DI(96) XOR DI(5) XOR DI(36) XOR DI(3) XOR DI(50) XOR DI(37) XOR DI(43) XOR DI(52) XOR DI(66) XOR DI(53) XOR DI(59) XOR DI(73) XOR DI(81) XOR DI(79) XOR DI(6) XOR DI(35) XOR DI(82) XOR DI(90) XOR DI(17) XOR DI(46) XOR DI(49) XOR DI(20) XOR DI(75) XOR DI(34) XOR DI(13) XOR DI(27) XOR DI(89) XOR DI(93) XOR DI(97) XOR DI(101);
   DO(9) <= DI(1) XOR DI(17) XOR DI(33) XOR DI(48) XOR DI(15) XOR DI(62) XOR DI(49) XOR DI(55) XOR DI(77) XOR DI(64) XOR DI(2) XOR DI(31) XOR DI(34) XOR DI(78) XOR DI(86) XOR DI(13) XOR DI(42) XOR DI(11) XOR DI(45) XOR DI(65) XOR DI(71) XOR DI(9) XOR DI(41) XOR DI(23) XOR DI(85) XOR DI(89) XOR DI(93) XOR DI(97) XOR DI(6) XOR DI(37) XOR DI(4) XOR DI(51) XOR DI(38) XOR DI(44) XOR DI(53) XOR DI(67) XOR DI(54) XOR DI(60) XOR DI(74) XOR DI(82) XOR DI(80) XOR DI(7) XOR DI(36) XOR DI(83) XOR DI(91) XOR DI(18) XOR DI(47) XOR DI(50) XOR DI(21) XOR DI(76) XOR DI(35) XOR DI(14) XOR DI(28) XOR DI(90) XOR DI(94) XOR DI(98) XOR DI(102);
   DO(10) <= DI(2) XOR DI(18) XOR DI(0) XOR DI(34) XOR DI(49) XOR DI(16) XOR DI(63) XOR DI(50) XOR DI(56) XOR DI(78) XOR DI(65) XOR DI(3) XOR DI(32) XOR DI(35) XOR DI(79) XOR DI(87) XOR DI(14) XOR DI(43) XOR DI(12) XOR DI(46) XOR DI(66) XOR DI(72) XOR DI(10) XOR DI(42) XOR DI(24) XOR DI(86) XOR DI(90) XOR DI(94) XOR DI(98) XOR DI(7) XOR DI(38) XOR DI(5) XOR DI(52) XOR DI(39) XOR DI(45) XOR DI(54) XOR DI(68) XOR DI(55) XOR DI(61) XOR DI(75) XOR DI(83) XOR DI(81) XOR DI(8) XOR DI(37) XOR DI(84) XOR DI(92) XOR DI(19) XOR DI(48) XOR DI(51) XOR DI(22) XOR DI(77) XOR DI(36) XOR DI(15) XOR DI(29) XOR DI(91) XOR DI(95) XOR DI(99) XOR DI(103);
   DO(11) <= DI(3) XOR DI(19) XOR DI(34) XOR DI(1) XOR DI(48) XOR DI(35) XOR DI(41) XOR DI(50) XOR DI(17) XOR DI(64) XOR DI(72) XOR DI(51) XOR DI(57) XOR DI(27) XOR DI(71) XOR DI(79) XOR DI(24) XOR DI(66) XOR DI(22) XOR DI(77) XOR DI(4) XOR DI(33) XOR DI(36) XOR DI(80) XOR DI(88) XOR DI(15) XOR DI(44) XOR DI(13) XOR DI(47) XOR DI(67) XOR DI(18) XOR DI(73) XOR DI(29) XOR DI(32) XOR DI(11) XOR DI(43) XOR DI(25) XOR DI(87) XOR DI(91) XOR DI(95) XOR DI(99);
   DO(12) <= DI(4) XOR DI(20) XOR DI(35) XOR DI(2) XOR DI(49) XOR DI(36) XOR DI(42) XOR DI(51) XOR DI(18) XOR DI(65) XOR DI(73) XOR DI(52) XOR DI(58) XOR DI(28) XOR DI(72) XOR DI(80) XOR DI(25) XOR DI(67) XOR DI(23) XOR DI(78) XOR DI(5) XOR DI(34) XOR DI(37) XOR DI(81) XOR DI(89) XOR DI(16) XOR DI(45) XOR DI(14) XOR DI(48) XOR DI(68) XOR DI(19) XOR DI(74) XOR DI(30) XOR DI(33) XOR DI(12) XOR DI(44) XOR DI(26) XOR DI(88) XOR DI(92) XOR DI(96) XOR DI(100);
   DO(13) <= DI(5) XOR DI(21) XOR DI(36) XOR DI(3) XOR DI(50) XOR DI(37) XOR DI(43) XOR DI(52) XOR DI(19) XOR DI(66) XOR DI(74) XOR DI(53) XOR DI(59) XOR DI(29) XOR DI(73) XOR DI(81) XOR DI(26) XOR DI(68) XOR DI(24) XOR DI(79) XOR DI(6) XOR DI(35) XOR DI(38) XOR DI(82) XOR DI(90) XOR DI(17) XOR DI(46) XOR DI(15) XOR DI(49) XOR DI(69) XOR DI(20) XOR DI(75) XOR DI(31) XOR DI(34) XOR DI(13) XOR DI(45) XOR DI(27) XOR DI(89) XOR DI(93) XOR DI(97) XOR DI(101);
   DO(14) <= DI(6) XOR DI(22) XOR DI(37) XOR DI(4) XOR DI(51) XOR DI(38) XOR DI(44) XOR DI(53) XOR DI(20) XOR DI(67) XOR DI(75) XOR DI(54) XOR DI(60) XOR DI(30) XOR DI(74) XOR DI(82) XOR DI(27) XOR DI(69) XOR DI(25) XOR DI(80) XOR DI(7) XOR DI(36) XOR DI(39) XOR DI(83) XOR DI(91) XOR DI(18) XOR DI(47) XOR DI(16) XOR DI(50) XOR DI(70) XOR DI(21) XOR DI(76) XOR DI(32) XOR DI(35) XOR DI(14) XOR DI(46) XOR DI(28) XOR DI(90) XOR DI(94) XOR DI(98) XOR DI(102);
   DO(15) <= DI(7) XOR DI(23) XOR DI(38) XOR DI(5) XOR DI(52) XOR DI(39) XOR DI(45) XOR DI(54) XOR DI(21) XOR DI(68) XOR DI(76) XOR DI(55) XOR DI(61) XOR DI(31) XOR DI(75) XOR DI(83) XOR DI(28) XOR DI(70) XOR DI(26) XOR DI(81) XOR DI(8) XOR DI(37) XOR DI(40) XOR DI(84) XOR DI(92) XOR DI(19) XOR DI(48) XOR DI(17) XOR DI(51) XOR DI(71) XOR DI(22) XOR DI(77) XOR DI(33) XOR DI(36) XOR DI(15) XOR DI(47) XOR DI(29) XOR DI(91) XOR DI(95) XOR DI(99) XOR DI(103);
  
end architecture;