-- crc16.vhd: A 16-bit CRC table for processing generic number of bits in parallel
-- Copyright (C) 2012 Brno University of Technology
-- Author(s): Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: crc16.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity crc16 is
   generic(
      DATA_WIDTH : integer := 24   -- supported: 24, 32, 48, 56, 104, 128, 152, 296
   );
   port(
      DI    : in  std_logic_vector(DATA_WIDTH-1 downto 0);
      DO    : out std_logic_vector(15 downto 0)
   );
end entity crc16;

-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ansi of crc16 is
begin
   DW24_gen : if DATA_WIDTH = 24 generate
      crc16_i : entity work.crc16_24 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW32_gen : if DATA_WIDTH = 32 generate
      crc16_i : entity work.crc16_32 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW48_gen : if DATA_WIDTH = 48 generate
      crc16_i : entity work.crc16_48 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW56_gen : if DATA_WIDTH = 56 generate
      crc16_i : entity work.crc16_56 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
    DW64_gen : if DATA_WIDTH = 64 generate
      crc16_i : entity work.crc16_64 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW104_gen : if DATA_WIDTH = 104 generate
      crc16_i : entity work.crc16_104 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW128_gen : if DATA_WIDTH = 128 generate
      crc16_i : entity work.crc16_128 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW152_gen : if DATA_WIDTH = 152 generate
      crc16_i : entity work.crc16_152 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW296_gen : if DATA_WIDTH = 296 generate
      crc16_i : entity work.crc16_296 (arch_ansi)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
end architecture;

-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ccitt of crc16 is
begin
   DW24_gen : if DATA_WIDTH = 24 generate
      crc16_i : entity work.crc16_24 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW32_gen : if DATA_WIDTH = 32 generate
      crc16_i : entity work.crc16_32 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
    DW48_gen : if DATA_WIDTH = 48 generate
      crc16_i : entity work.crc16_48 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW56_gen : if DATA_WIDTH = 56 generate
      crc16_i : entity work.crc16_56 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
    DW64_gen : if DATA_WIDTH = 64 generate
      crc16_i : entity work.crc16_64 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW104_gen : if DATA_WIDTH = 104 generate
      crc16_i : entity work.crc16_104 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW128_gen : if DATA_WIDTH = 128 generate
      crc16_i : entity work.crc16_128 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW152_gen : if DATA_WIDTH = 152 generate
      crc16_i : entity work.crc16_152 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
   DW296_gen : if DATA_WIDTH = 296 generate
      crc16_i : entity work.crc16_296 (arch_ccitt)
      port map (
         DI => DI,
         DO => DO);
   end generate;
   
end architecture;