/*!
 * \file write_crc.h
 * \brief Write functions 
 * \author Andrej Hank <xhanka00@liberouter.org>
 * \date 2008
 */
/*
 * Copyright (C) 2008 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

/** @defgroup write Write functions 
 *
 * If user wants to send data, szedata2 packet must be created from sw and hw data.
 * Packet is created in preallocated space in sze handle (ct_tx_buffer).
 * For this purpose serve szedata_prepare_packet/_with_crc functions.
 * Then prepared packet should be written into driver's buffer by szedata_try_write_next.
 * These two steps are be faster and wrapped in one function - szedata_prepare_and_try_write_next
 * which creates szedata2 packet directly into driver's buffer - zero copy.
 * @{
 */

int szedata_burst_write_next_with_crc(struct szedata *sze, unsigned char *hw_data, unsigned int hw_data_len, unsigned char *sw_data, unsigned int sw_data_len, unsigned short iface); 
unsigned char *szedata_prepare_packet_with_crc(struct szedata *sze, unsigned char *hw_data, unsigned int hw_data_len, unsigned char *sw_data, unsigned int sw_data_len, unsigned int *len);

/** @} */

