/*!
 * \file ptm.c
 * \brief PTM card I/O
 * \author Jaroslav Kysela <perex@perex.cz>
 * \date 2005
 *
 * Copyright (C) 2005  CESNET
 */
/* LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#include <sys/ioctl.h>
#include <errno.h>
#include <commlbr.h>
#include "combosix.h"
#include "cs_local.h"
#include <combo6.h>

__RCSID("$Id$");

/**
 * \brief Read PTM registers
 * \param d Combo6 device structure
 * \param ptm PTM structure
 * \return zero on success otherwise a negative error code
 */
int
#ifdef COMBO6_IOC_PTM_READ
cs_ptm_read(cs_device_t *d, cs_ptm_t *ptm)
#else
cs_ptm_read(cs_device_t *d ATTRIBUTE_UNUSED, cs_ptm_t *ptm ATTRIBUTE_UNUSED)
#endif
{
#ifdef COMBO6_IOC_PTM_READ
	if (ioctl(d->dv_file, COMBO6_IOC_PTM_READ, (struct combo6_ptm *)ptm))
		return -errno;
	return 0;
#else
	return -ENXIO;
#endif
}

/**
 * \brief Write PTM registers
 * \param d Combo6 device structure
 * \param ptm PTM structure
 * \return zero on success otherwise a negative error code
 */
int
#ifdef COMBO6_IOC_PTM_WRITE
cs_ptm_write(cs_device_t *d, cs_ptm_t *ptm)
#else
cs_ptm_write(cs_device_t *d ATTRIBUTE_UNUSED, cs_ptm_t *ptm ATTRIBUTE_UNUSED)
#endif
{
#ifdef COMBO6_IOC_PTM_WRITE
	if (ioctl(d->dv_file, COMBO6_IOC_PTM_WRITE, (struct combo6_ptm *)ptm))
		return -errno;
	return 0;
#else
	return -ENXIO;
#endif
}
