/**
 * \file sdramctrl.h
 * \brief SDRAM_CTRL component control routines header file.
 * \author Miroslav Vadkerti <thrix@liberouter.org>
 * \author Petr Springl <xsprin01@liberouter.org>
 * \date 2006, 2007
 */

/*
 * Copyright (C) 2006, 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_SDRAMCTRL_H_
#define _LIBEROUTER_SDRAMCTRL_H_

#include "../combosix.h"

/*!
 * \defgroup sdramctrl_component SDRAM_CTRL component
 * \ingroup components 
 * \{
 *
 * \brief Module for read/write/load mode register of SDRAM_CTRL component.

 * This module implements functions for reading and writing 128 or 144 bit data
 * from specified address (depends on RAM type). The read length can be specified
 * with parameter \e length (must be 128 or 144).
 */

/* Function prototypes */

void
cs_sdramctrl_give_control(cs_device_t *dev, cs_space_t *space);

int
cs_sdramctrl_get_control(cs_device_t *dev, cs_space_t *space);

int
cs_sdramctrl_write(cs_device_t *dev, cs_space_t *space, u_int32_t address, 
		u_int32_t *data, u_int32_t length);

int
cs_sdramctrl_read(cs_device_t *dev, cs_space_t *space, u_int32_t address, 
		u_int32_t *data, u_int32_t length);

int
cs_sdramctrl_load_mode_reg(cs_device_t *dev, cs_space_t *space, u_int32_t reg);

/*! \} */

#endif /* _LIBEROUTER_SDRAMCTRL_H_ */

