/**
 * \file phydevs.h
 * \brief Phyter vendor and model indentifiers.
 * \author Miroslav Vadkerti <thrix@liberouter.org>
 * \date 2007-2008
 */

/*
 * Copyright (C) 2007-2008  CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */


#ifndef _LIBEROUTER_PHYDEVS_H_
#define _LIBEROUTER_PHYDEVS_H_

#define	PHY_OUI_ALTIMA		0x0010a9	/* Altima Communications */
#define	PHY_OUI_AMD		0x00001a	/* Advanced Micro Devices */
#define	PHY_OUI_BROADCOM	0x001018	/* Broadcom Corporation */
#define	PHY_OUI_CICADA		0x0003f1	/* Cicada Semiconductor */
#define	PHY_OUI_DAVICOM		0x00606e	/* Davicom Semiconductor */
#define	PHY_OUI_ICS		0x00a0be	/* Integrated Circuit Systems */
#define	PHY_OUI_INTEL		0x00aa00	/* Intel */
#define	PHY_OUI_JATO		0x00e083	/* Jato Technologies */
#define	PHY_OUI_LEVEL1		0x00207b	/* Level 1 */
#define	PHY_OUI_NATSEMI		0x080017	/* National Semiconductor */
#define	PHY_OUI_QUALSEMI	0x006051	/* Quality Semiconductor */
#define	PHY_OUI_REALTEK		0x000020	/* RealTek Semicondctor */
#define	PHY_OUI_REALTEK2	0x00e04c	/* RealTek Semicondctor */
#define	PHY_OUI_SEEQ		0x00a07d	/* Seeq */
#define	PHY_OUI_SIS		0x00e006	/* Silicon Integrated Systems */
#define	PHY_OUI_TDK		0x00c039	/* TDK */
#define	PHY_OUI_TI		0x080028	/* Texas Instruments */
#define	PHY_OUI_XAQTI		0x00e0ae	/* XaQti Corp. */
#define	PHY_OUI_MARVELL		0x005043	/* Marvell Semiconductor */
#define	PHY_OUI_ICPLUS		0x0090c3	/* IC Plus Corp. */
#define	PHY_OUI_VITESSE		0x0001c1	/* Vitesse Semiconductor */
#define	PHY_OUI_AGILENT		0x0030d3	/* Agilent */
#define	PHY_OUI_NETLOGIC	0x000000	/* NetLogic Microsystems */

/* in the 79c873, AMD uses another OUI (which matches Davicom!) */
#define	PHY_OUI_xxAMD		0x00606e	/* Advanced Micro Devices */

/* Intel 82553 A/B steppings */
#define	PHY_OUI_xxINTEL		0x00f800	/* Intel */

/* some vendors have the bits swapped within bytes
	(ie, ordered as on the wire) */
#define	PHY_OUI_xxALTIMA	0x000895	/* Altima Communications */
#define	PHY_OUI_xxBROADCOM	0x000818	/* Broadcom Corporation */
#define	PHY_OUI_xxICS		0x00057d	/* Integrated Circuit Systems */
#define	PHY_OUI_xxSEEQ		0x0005be	/* Seeq */
#define	PHY_OUI_xxSIS		0x000760	/* Silicon Integrated Systems */
#define	PHY_OUI_xxTI		0x100014	/* Texas Instruments */
#define	PHY_OUI_xxXAQTI		0x350700	/* XaQti Corp. */

/* Level 1 is completely different - from right to left.
	(Two bits get lost in the third OUI byte.) */
#define	PHY_OUI_xxLEVEL1	0x1e0400	/* Level 1 */
#define	PHY_OUI_xxLEVEL1a	0x0004de	/* Level 1 */

/* Don't know what's going on here. */
#define	PHY_OUI_xxDAVICOM	0x006040	/* Davicom Semiconductor */
#define	PHY_OUI_xxBROADCOM2	0x0050ef	/* Broadcom Corporation */

/* This is the OUI of the gigE PHY in the RealTek 8211B/8169S/8110S chips */
#define	PHY_OUI_xxREALTEK	0x000732	/*  */
#define	PHY_OUI_xxMARVELL	0x000ac2	/* Marvell Semiconductor */
#define	PHY_OUI_xxCICADA	0x00c08f	/* Cicada Semiconductor */

/* Vendors of SFP transceivers */
#define PHY_OUI_FINISAR		0x009065	/* Finisar Corporation */

/* NONE vendor */
#define PHY_OUI_NONE		0x0		/* No OUI */

/*
 * List of vendor name strings
 */

#define	PHY_OUI_NAME_ALTIMA		"ALTIMA"	/* Altima Communications */
#define	PHY_OUI_NAME_AMD		"AMD"   	/* Advanced Micro Devices */
#define	PHY_OUI_NAME_BROADCOM		"BROADCOM"	/* Broadcom Corporation */
#define	PHY_OUI_NAME_CICADA		"CICADA"	/* Cicada Semiconductor */
#define	PHY_OUI_NAME_DAVICOM		"DAVICOM"	/* Davicom Semiconductor */
#define	PHY_OUI_NAME_ICS		"ICS"   	/* Integrated Circuit Systems */
#define	PHY_OUI_NAME_INTEL		"INTEL" 	/* Intel */
#define	PHY_OUI_NAME_JATO		"JATO"  	/* Jato Technologies */
#define	PHY_OUI_NAME_LEVEL1		"LEVEL1"	/* Level 1 */
#define	PHY_OUI_NAME_NATSEMI		"NATSEMI"	/* National Semiconductor */
#define	PHY_OUI_NAME_QUALSEMI		"QUALSEMI"	/* Quality Semiconductor */
#define	PHY_OUI_NAME_REALTEK		"REALTEK"	/* RealTek Semicondctor */
#define	PHY_OUI_NAME_REALTEK2		"REALTEK"	/* RealTek Semicondctor */
#define	PHY_OUI_NAME_SEEQ		"SEEQ"  	/* Seeq */
#define	PHY_OUI_NAME_SIS		"SIS"   	/* Silicon Integrated Systems */
#define	PHY_OUI_NAME_TDK		"TDK"   	/* TDK */
#define	PHY_OUI_NAME_TI			"TI"    	/* Texas Instruments */
#define	PHY_OUI_NAME_XAQTI		"XAQTI" 	/* XaQti Corp. */
#define	PHY_OUI_NAME_MARVELL		"MARVELL" 	/* Marvell Semiconductor */
#define	PHY_OUI_NAME_ICPLUS		"ICPLUS"	/* IC Plus Corp. */
#define	PHY_OUI_NAME_VITESSE		"VITESSE"	/* Vitesse Semiconductor */
#define PHY_OUI_NAME_FINISAR		"FINISAR CORP."	/* Finisar corp. */
#define PHY_OUI_NAME_AGILENT		"AGILENT"	/* Agilent */
#define PHY_OUI_NAME_NONE   		"NONE"		/* Agilent */
#define PHY_OUI_NAME_NETLOGIC		"NETLOGIC"	/* NetLogic Microsystems */

/* other unofficial */
#define	PHY_OUI_NAME_xxAMD		"AMD"		/* Advanced Micro Devices */
#define	PHY_OUI_NAME_xxINTEL		"INTEL"  	/* Intel */
#define	PHY_OUI_NAME_xxALTIMA		"ALTIMA"	/* Altima Communications */
#define	PHY_OUI_NAME_xxBROADCOM		"BROADCOM" 	/* Broadcom Corporation */
#define	PHY_OUI_NAME_xxICS		"ICS"   	/* Integrated Circuit Systems */
#define	PHY_OUI_NAME_xxSEEQ		"SEEQ"  	/* Seeq */
#define	PHY_OUI_NAME_xxSIS		"SIS"   	/* Silicon Integrated Systems */
#define	PHY_OUI_NAME_xxTI		"TI"    	/* Texas Instruments */
#define	PHY_OUI_NAME_xxXAQTI		"XAQTI" 	/* XaQti Corp. */
#define	PHY_OUI_NAME_xxLEVEL1		"LEVEL1"	/* Level 1 */
#define	PHY_OUI_NAME_xxLEVEL1a		"LEVEL1"	/* Level 1 */
#define	PHY_OUI_NAME_xxDAVICOM		"DAVIDCOM"	/* Davicom Semiconductor */
#define	PHY_OUI_NAME_xxBROADCOM2	"BROADCOM"	/* Broadcom Corporation */
#define	PHY_OUI_NAME_xxREALTEK		"REALTEK"	/* Realtek */
#define	PHY_OUI_NAME_xxMARVELL		"MARVELL"	/* Marvell Semiconductor */
#define	PHY_OUI_NAME_xxCICADA		"CICADA"	/* Cicada Semiconductor */

/*
 * List of known models.  Grouped by oui.
 */
/* Altima Communications PHYs */
#define	PHY_MODEL_xxALTIMA_AC_UNKNOWN	0x0001
#define	PHY_STR_xxALTIMA_AC_UNKNOWN	"AC_UNKNOWN 10/100 media interface"
#define	PHY_MODEL_xxALTIMA_AC101L	0x0012
#define	PHY_STR_xxALTIMA_AC101L		"AC101L 10/100 media interface"
#define	PHY_MODEL_xxALTIMA_AC101	0x0021
#define	PHY_STR_xxALTIMA_AC101		"AC101 10/100 media interface"
/* AMD Am79C875 have ALTIMA OUI */
#define	PHY_MODEL_xxALTIMA_Am79C875	0x0014
#define	PHY_STR_xxALTIMA_Am79C875	"Am79C875 10/100 media interface"

/* Advanced Micro Devices PHYs */
#define	PHY_MODEL_xxAMD_79C873		0x0000
#define	PHY_STR_xxAMD_79C873		"Am79C873 10/100 media interface"
#define	PHY_MODEL_AMD_79c973phy		0x0036
#define	PHY_STR_AMD_79c973phy		"Am79c973 internal PHY"
#define	PHY_MODEL_AMD_79c978		0x0039
#define	PHY_STR_AMD_79c978		"Am79c978 HomePNA PHY"

/* Broadcom Corp. PHYs. */
#define	PHY_MODEL_BROADCOM_BCM5400	0x0004
#define	PHY_STR_BROADCOM_BCM5400	"BCM5400 1000baseT PHY"
#define	PHY_MODEL_BROADCOM_BCM5401	0x0005
#define	PHY_STR_BROADCOM_BCM5401	"BCM5401 1000baseT PHY"
#define	PHY_MODEL_BROADCOM_BCM5411	0x0007
#define	PHY_STR_BROADCOM_BCM5411	"BCM5411 1000baseT PHY"
#define	PHY_MODEL_BROADCOM_3C905B	0x0012
#define	PHY_STR_BROADCOM_3C905B	"Broadcom 3C905B internal PHY"
#define	PHY_MODEL_BROADCOM_3C905C	0x0017
#define	PHY_STR_BROADCOM_3C905C	"Broadcom 3C905C internal PHY"
#define	PHY_MODEL_BROADCOM_BCM5221	0x001e
#define	PHY_STR_BROADCOM_BCM5221	"BCM5221 100baseTX PHY"
#define	PHY_MODEL_BROADCOM_BCM5201	0x0021
#define	PHY_STR_BROADCOM_BCM5201	"BCM5201 10/100 PHY"
#define	PHY_MODEL_BROADCOM_BCM5214	0x0028
#define	PHY_STR_BROADCOM_BCM5214	"BCM5214 Quad 10/100 PHY"
#define	PHY_MODEL_BROADCOM_BCM5222	0x0032
#define	PHY_STR_BROADCOM_BCM5222	"BCM5222 Dual 10/100 PHY"
#define	PHY_MODEL_BROADCOM_BCM5220	0x0033
#define	PHY_STR_BROADCOM_BCM5220	"BCM5220 10/100 PHY"
#define	PHY_MODEL_BROADCOM_BCM4401	0x0036
#define	PHY_STR_BROADCOM_BCM4401	"BCM4401 10/100baseTX PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5400	0x0004
#define	PHY_STR_xxBROADCOM_BCM5400	"Broadcom 1000baseTX PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5401	0x0005
#define	PHY_STR_xxBROADCOM_BCM5401	"BCM5401 10/100/1000baseTX PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5411	0x0007
#define	PHY_STR_xxBROADCOM_BCM5411	"BCM5411 10/100/1000baseTX PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5462	0x000d
#define	PHY_STR_xxBROADCOM_BCM5462	"BCM5462 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5461	0x000c
#define	PHY_STR_xxBROADCOM_BCM5461	"BCM5461S 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5421	0x000e
#define	PHY_STR_xxBROADCOM_BCM5421	"BCM5421 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5752	0x0010
#define	PHY_STR_xxBROADCOM_BCM5752	"BCM5752 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5701	0x0011
#define	PHY_STR_xxBROADCOM_BCM5701	"BCM5701 10/100/1000baseTX PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5706C	0x0015
#define	PHY_STR_xxBROADCOM_BCM5706C	"BCM5706C 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5703	0x0016
#define	PHY_STR_xxBROADCOM_BCM5703	"BCM5703 10/100/1000baseTX PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5704	0x0019
#define	PHY_STR_xxBROADCOM_BCM5704	"BCM5704 10/100/1000baseTX PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5705	0x001a
#define	PHY_STR_xxBROADCOM_BCM5705	"BCM5705 10/100/1000baseTX PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5750	0x0018
#define	PHY_STR_xxBROADCOM_BCM5750	"BCM5750 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM54K2	0x002e
#define	PHY_STR_xxBROADCOM_BCM54K2	"BCM54K2 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5714	0x0034
#define	PHY_STR_xxBROADCOM_BCM5714	"BCM5714 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5780	0x0035
#define	PHY_STR_xxBROADCOM_BCM5780	"BCM5780 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM_BCM5708C	0x0036
#define	PHY_STR_xxBROADCOM_BCM5708C	"BCM5708C 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM2_BCM5755	0x000c
#define	PHY_STR_xxBROADCOM2_BCM5755	"BCM5755 10/100/1000baseT PHY"
#define	PHY_MODEL_xxBROADCOM2_BCM5787	0x000e
#define	PHY_STR_xxBROADCOM2_BCM5787	"BCM5787 10/100/1000baseT PHY"

/* Cicada Semiconductor PHYs (now owned by Vitesse?) */
#define	PHY_MODEL_CICADA_CS8201		0x0001
#define	PHY_STR_CICADA_CS8201		"CS8201 10/100/1000TX PHY"
#define	PHY_MODEL_CICADA_CS8201A	0x0020
#define	PHY_STR_CICADA_CS8201A		"CS8201 10/100/1000TX PHY"
#define	PHY_MODEL_CICADA_CS8201B	0x0021
#define	PHY_STR_CICADA_CS8201B		"CS8201 10/100/1000TX PHY"
#define	PHY_MODEL_xxCICADA_CS8201	0x0001
#define	PHY_STR_xxCICADA_CS8201		"CS8201 10/100/1000TX PHY"
#define	PHY_MODEL_xxCICADA_CS8201A	0x0020
#define	PHY_STR_xxCICADA_CS8201A	"CS8201 10/100/1000TX PHY"
#define	PHY_MODEL_xxCICADA_CS8201B	0x0021
#define	PHY_STR_xxCICADA_CS8201B	"CS8201 10/100/1000TX PHY"

/* Davicom Semiconductor PHYs */
#define	PHY_MODEL_xxDAVICOM_DM9101	0x0000
#define	PHY_STR_xxDAVICOM_DM9101	"DM9101 10/100 media interface"
#define	PHY_MODEL_DAVICOM_DM9102	0x0004
#define	PHY_STR_DAVICOM_DM9102		"DM9102 10/100 media interface"
#define	PHY_MODEL_DAVICOM_DM9601	0x000c
#define	PHY_STR_DAVICOM_DM9601		"DM9601 10/100 media interface"

/* Integrated Circuit Systems PHYs */
#define	PHY_MODEL_xxICS_1890		0x0002
#define	PHY_STR_xxICS_1890		"ICS1890 10/100 media interface"

/* Intel PHYs */
#define	PHY_MODEL_xxINTEL_I82553AB	0x0000
#define	PHY_STR_xxINTEL_I82553AB	"i83553 10/100 media interface"
#define	PHY_MODEL_INTEL_I82555		0x0015
#define	PHY_STR_INTEL_I82555		"i82555 10/100 media interface"
#define	PHY_MODEL_INTEL_I82562EM	0x0032
#define	PHY_STR_INTEL_I82562EM		"i82562EM 10/100 media interface"
#define	PHY_MODEL_INTEL_I82562ET	0x0033
#define	PHY_STR_INTEL_I82562ET		"i82562ET 10/100 media interface"
#define	PHY_MODEL_INTEL_I82553C		0x0035
#define	PHY_STR_INTEL_I82553C		"i82553 10/100 media interface"

/* Jato Technologies PHYs */
#define	PHY_MODEL_JATO_BASEX		0x0000
#define	PHY_STR_JATO_BASEX		"Jato 1000baseX media interface"

/* Level 1 PHYs */
#define	PHY_MODEL_xxLEVEL1_LXT970	0x0000
#define	PHY_STR_xxLEVEL1_LXT970		"LXT970 10/100 media interface"
#define	PHY_MODEL_xxLEVEL1a_LXT971	0x000e
#define	PHY_STR_xxLEVEL1a_LXT971	"LXT971 10/100 media interface"

/* National Semiconductor PHYs */
#define	PHY_MODEL_NATSEMI_DP83840	0x0000
#define	PHY_STR_NATSEMI_DP83840		"DP83840 10/100 media interface"
#define	PHY_MODEL_NATSEMI_DP83843	0x0001
#define	PHY_STR_NATSEMI_DP83843		"DP83843 10/100 media interface"
#define	PHY_MODEL_NATSEMI_DP83891	0x0005
#define	PHY_STR_NATSEMI_DP83891		"DP83891 10/100/1000 media interface"
#define	PHY_MODEL_NATSEMI_DP83861	0x0006
#define	PHY_STR_NATSEMI_DP83861		"DP83861 10/100/1000 media interface"

/* Quality Semiconductor PHYs */
#define	PHY_MODEL_QUALSEMI_QS6612	0x0000
#define	PHY_STR_QUALSEMI_QS6612		"QS6612 10/100 media interface"

/* RealTek Semiconductor PHYs */
#define	PHY_MODEL_REALTEK_RTL8201L	0x0020
#define	PHY_STR_REALTEK_RTL8201L	"RTL8201L 10/100 media interface"
#define	PHY_MODEL_xxREALTEK_RTL8169S	0x0011
#define	PHY_STR_xxREALTEK_RTL8169S	"8211B/RTL8169S/8110S media interface"
#define	PHY_MODEL_REALTEK2_RTL8169S	0x0011
#define	PHY_STR_REALTEK2_RTL8169S	"RTL8169S/8110S media interface"

/* Seeq PHYs */
#define	PHY_MODEL_xxSEEQ_80220		0x0003
#define	PHY_STR_xxSEEQ_80220		"80220 10/100 media interface"
#define	PHY_MODEL_xxSEEQ_84220		0x0004
#define	PHY_STR_xxSEEQ_84220		"84220 10/100 media interface"

/* Silicon Integrated Systems PHYs */
#define	PHY_MODEL_xxSIS_900		0x0000
#define	PHY_STR_xxSIS_900		"SiS 900 10/100 media interface"

/* TDK */
#define	PHY_MODEL_TDK_78Q2120		0x0014
#define	PHY_STR_TDK_78Q2120		"78Q2120 media interface"

/* Texas Instruments PHYs */
#define	PHY_MODEL_xxTI_TLAN10T		0x0001
#define	PHY_STR_xxTI_TLAN10T		"ThunderLAN 10baseT media interface"
#define	PHY_MODEL_xxTI_100VGPMI		0x0002
#define	PHY_STR_xxTI_100VGPMI		"ThunderLAN 100VG-AnyLan media interface"

/* XaQti Corp. PHYs. */
#define	PHY_MODEL_xxXAQTI_XMACII	0x0000
#define	PHY_STR_xxXAQTI_XMACII		"XMAC II gigabit interface"

/* Marvell Semiconductor PHYs */
#define	PHY_MODEL_MARVELL_E1000		0x0000
#define	PHY_STR_MARVELL_E1000		"88E1000* gigabit PHY"
#define	PHY_MODEL_MARVELL_E1011		0x0002
#define	PHY_STR_MARVELL_E1011		"88E1011 Gigabit PHY"
#define	PHY_MODEL_MARVELL_E1000_3	0x0003
#define	PHY_STR_MARVELL_E1000_3		"88E1000 Gigabit PHY"
#define	PHY_MODEL_MARVELL_E1000_4	0x0004
#define	PHY_STR_MARVELL_E1000_4		"88E1000S Gigabit PHY"
#define	PHY_MODEL_MARVELL_E1000_5	0x0005
#define	PHY_STR_MARVELL_E1000_5		"88E1000 Gigabit PHY"
#define	PHY_MODEL_MARVELL_E1000_6	0x0006
#define	PHY_STR_MARVELL_E1000_6		"88E1000 Gigabit PHY"
#define	PHY_MODEL_MARVELL_E3082		0x0008
#define	PHY_STR_MARVELL_E3082		"88E3082 10/100 PHY"
#define	PHY_MODEL_MARVELL_E1112		0x0009
#define	PHY_STR_MARVELL_E1112		"88E1112 Gigabit PHY"
#define	PHY_MODEL_MARVELL_E1149		0x000b
#define	PHY_STR_MARVELL_E1149		"88E1149 Gigabit PHY"
#define	PHY_MODEL_MARVELL_E1111		0x000c
#define	PHY_STR_MARVELL_E1111		"88E1111 Gigabit PHY"
#define	PHY_MODEL_MARVELL_E1116		0x0021
#define	PHY_STR_MARVELL_E1116		"88E1116 Gigabit PHY"
#define	PHY_MODEL_MARVELL_E1118		0x0022
#define	PHY_STR_MARVELL_E1118		"88E1118 Gigabit PHY"
#define	PHY_MODEL_xxMARVELL_E1000_2	0x0002
#define	PHY_STR_xxMARVELL_E1000_2	"88E1000 Gigabit PHY"
#define	PHY_MODEL_xxMARVELL_E1000_3	0x0003
#define	PHY_STR_xxMARVELL_E1000_3	"88E1000 Gigabit PHY"
#define	PHY_MODEL_xxMARVELL_E1000_5	0x0005
#define	PHY_STR_xxMARVELL_E1000_5	"88E1000 Gigabit PHY"
#define	PHY_MODEL_xxMARVELL_E1111	0x000c
#define	PHY_STR_xxMARVELL_E1111		"88E1111 Gigabit PHY"

/* IC Plus Corp. PHYs */
#define	PHY_MODEL_ICPLUS_IP101		0x0005
#define	PHY_STR_ICPLUS_IP101		"IP101 10/100 PHY"
#define	PHY_MODEL_ICPLUS_IP1000A	0x0008
#define	PHY_STR_ICPLUS_IP1000A		"IC Plus 10/100/1000 media interface"

/* Vitesse Semiconductor PHYs */
#define	PHY_MODEL_VITESSE_VSC8601	0x0002
#define	PHY_STR_VITESSE_VSC8601		"VSC8601 10/100/1000TX PHY"
#define PHY_MODEL_VITESSE_VSC8476	0x0 
#define PHY_STR_VITESSE_VSC8476		"VSC8476 10GbE PHY"
#define PHY_MODEL_VITESSE_VSC8486	0x8486 
#define PHY_STR_VITESSE_VSC8486		"VSC8486 10GbE PHY"

/* NetLogic Microsystems PHYs */
#define PHY_MODEL_NETLOGIC_AEL2005	0x0
#define PHY_STR_NETLOGIC_AEL2005	"AEL2005 10GbE PHY"

/* FINISAR model and vendor */
#define PHY_MODEL_FINISAR_GENERIC	0x0
#define PHY_STR_FINISAR_GENERIC	""

/* AGILENT model and vendor */
#define PHY_MODEL_AGILENT_GENERIC	0x0
#define PHY_STR_AGILENT_GENERIC	""

/* Generic model and vendor */
#define PHY_MODEL_NONE_GENERIC	0x0
#define PHY_STR_NONE_GENERIC	""

#endif /* _LIBEROUTER_PHYDEVS_H_ */
