/*!
 * \file 	obuf.h
 * \brief 	Function prototypes for controlling OBUF
 * \author 	Andrej Hank <xhanka00@liberouter.org>
 * \author	Miroslav Vadkerti <thrix@liberouter.org>
 * \date 	2006, 2007
 */

/*
 * Copyright (C) 2006, 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_OBUF_H_
#define _LIBEROUTER_OBUF_H_

#include "../combosix.h"
#include <stdbool.h>

/*!
 * \defgroup obuf_component OBUF component.
 * \ingroup components
 * \{
 *
 * \brief This module implements functions for controlling OBUF component.
 */

/*!
 * \struct 	cs_obuf_t
 * \brief 	OBUF data structure
 */
typedef struct {
	/*! All packets */
	uint64_t	cnt_packets;
	/*! Received packets */
	uint64_t	cnt_recv;
	/*! Error packets */
	uint64_t	cnt_error;
	/*! Enable/Disable register */
	uint32_t	reg_en;
	/*! MAC address low */
	uint32_t	mac_low;
	/*! MAC address high */
	uint32_t	mac_high;
	/*! OBUF status register */
	uint32_t	obuf_status;
} cs_obuf_t;

/*
 *  Read OBUF counters
 */
cs_obuf_t cs_obuf_read(cs_device_t *dev, cs_space_t *space, bool xgmii);

/*
 * Enable OBUF
 */
void
cs_obuf_enable(cs_device_t *dev, cs_space_t *space);

/*
 * Disable OBUF
 */
void
cs_obuf_disable(cs_device_t *dev, cs_space_t *space);

/*
 * Set OBUF speed
 */
void
cs_obuf_set_speed (cs_device_t *dev, cs_space_t *space, int speed);

/*
 * Reset OBUF
 */
void
cs_obuf_reset (cs_device_t *dev, cs_space_t *space);

/*
 * Set OBUF MAC address
 */
void
cs_obuf_set_mac (cs_device_t *dev, cs_space_t *space, u_int32_t hi, u_int32_t lo);

/*
 * Is OBUF enabled?
 */
int
cs_obuf_is_enabled(cs_device_t *dev, cs_space_t *space);

/*! \} */

#endif

