/**
 * \file mdio.h
 * \brief Component for basic MDIO read/write access.
 * \author Jachym Holecek <freza@liberouter.org>
 * \author Miroslav Vadkerti <thrix@liberouter.org>
 * \date 2004,2007
 */

/*
 * Copyright (C) 2004, 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'', AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COMPANY OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id$
 */

#ifndef _LIBEROUTER_MDIO_H_
#define _LIBEROUTER_MDIO_H_

/* combo include */
#include "../combosix.h"

/*!
 * \defgroup mdio_component MDIO component
 * \ingroup components 
 * \{
 *
 * \brief This module implements basic routines for reading/writing registers
 * of devices connected with MDIO bus. 
 *
 */
void
cs_mdio_write_sdf(cs_device_t *d, cs_space_t *s, u_int phy, u_int reg, u_int32_t data);

u_int32_t
cs_mdio_read_sdf(cs_device_t *d, cs_space_t *s, u_int phy, u_int reg);

u_int32_t
cs_mdio_read_sdf_nowait(cs_device_t *d, cs_space_t *s, u_int phy, u_int reg);


u_int32_t
cs_mdio_read(cs_device_t *d, cs_space_t *s, u_int phy, u_int dev, u_int reg);

void
cs_mdio_write(cs_device_t *d, cs_space_t *s, u_int phy, u_int dev, u_int reg, \
    u_int32_t data);

/*! \} */

#endif /* _LIBEROUTER_MDIO_H_ */
