/**

 * \file i2cms.h
 * \brief Provides interface for i2cms.c.
 * \author Jaroslav Zilak <xzilak00@stud.fit.vutbr.cz>
 * \date 2010
 */

/*
 * Copyright (C) 2010 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef I2C_HRADER
#define I2C_HRADER

#include "../combosix.h"

/* delay between bus read/write operations */
#define I2CMS_DELAY               50000
/* maximal delay iteration */
#define I2CMS_MAX_DELAY           100

/* address lengths */
#define I2CMS_MAX_ADDR_LEN        16
#define I2CMS_MIN_ADDR_LEN        0
#define I2CMS_DEFAULT_ADDR_LEN    16

/* default addresses of i2c master */
#define I2CMS_DEFAULT_DEVICE      0x34

/* 
 * default values of i2c master on second level -
 * upper FPGA of 10g4 card (the first of four masters)
 */
#define I2CMS_2_C_ADDRESS           0x0200
#define I2CMS_2_T_ADDRESS           0x0204

/* command register bits */
#define I2CMS_READING_FLAG        0x00000100
#define I2CMS_START_BIT           0x00000080
#define I2CMS_STOP_BIT            0x00000040
#define I2CMS_READ_FROM_SLAVE_BIT 0x00000020
#define I2CMS_WRITE_TO_SLAVE_BIT  0x00000010
#define I2CMS_ACK_BIT             0x00000008
#define I2CMS_SLAVE_ACK_BIT       0x00000080
#define I2CMS_ARBIT_LOST_BIT      0x00000020
#define I2CMS_TIP                 0x00000002

/* i2c communication parameters */
typedef enum{
	I2CMS_PARAM_ADDR_LEN = 1,
	I2CMS_2_PARAM_ADDR_LEN,
	I2CMS_2_PARAM_C_ADDRESS,
	I2CMS_2_PARAM_T_ADDRESS
} I2CMS_PARAM, *P_I2CMS_PARAM;

int cs_i2cms_init(cs_device_t *device, cs_space_t *space);
int cs_i2cms_2_init(u_int32_t device, u_int32_t c_address, u_int32_t t_address);
int cs_i2cms_set_params(I2CMS_PARAM param, u_int32_t add_len);

int cs_i2cms_write(u_int32_t device_addr, u_int16_t address, u_int8_t *data, u_int16_t size);
int cs_i2cms_write_8b(u_int32_t device_addr, u_int16_t address, u_int8_t data);
int cs_i2cms_write_16b(u_int32_t device_addr, u_int16_t address, u_int16_t data);
int cs_i2cms_write_32b(u_int32_t device_addr, u_int16_t address, u_int32_t data);
int cs_i2cms_write_64b(u_int32_t device_addr, u_int16_t address, u_int64_t data);

int cs_i2cms_2_write(u_int32_t device_addr, u_int16_t address, u_int8_t *data, u_int16_t size);
int cs_i2cms_2_write_8b(u_int32_t device_addr, u_int16_t address, u_int8_t data);
int cs_i2cms_2_write_16b(u_int32_t device_addr, u_int16_t address, u_int16_t data);
int cs_i2cms_2_write_32b(u_int32_t device_addr, u_int16_t address, u_int32_t data);
int cs_i2cms_2_write_64b(u_int32_t device_addr, u_int16_t address, u_int64_t data);

int cs_i2cms_read(u_int32_t device_addr, u_int16_t address, u_int8_t *data, u_int16_t size);
u_int8_t cs_i2cms_read_8b(u_int32_t device_addr, u_int16_t address);
u_int16_t cs_i2cms_read_16b(u_int32_t device_addr, u_int16_t address);
u_int32_t cs_i2cms_read_32b(u_int32_t device_addr, u_int16_t address);
u_int64_t cs_i2cms_read_64b(u_int32_t device_addr, u_int16_t address);

int cs_i2cms_2_read(u_int32_t device_addr, u_int16_t address, u_int8_t *data, u_int16_t size);
u_int8_t cs_i2cms_2_read_8b(u_int32_t device_addr, u_int16_t address);
u_int16_t cs_i2cms_2_read_16b(u_int32_t device_addr, u_int16_t address);
u_int32_t cs_i2cms_2_read_32b(u_int32_t device_addr, u_int16_t address);
u_int64_t cs_i2cms_2_read_64b(u_int32_t device_addr, u_int16_t address);

#endif
