/*
 *  pcrdma_ops.c: Designs compatible with Cesnet PCI bridge and PPC
 *  Copyright (c) 2006 CESNET
 *  Author(s): Jaroslav Kysela <perex@perex.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

static const struct combo_device_id pcrdma_ids[] = {
	{
		.id_lsw = 0xabcdef02,
		.id_hsw = 0xabcdef02,
	}, {
		.id_lsw	= 0x4f1c0000,
		.id_hsw = 0x4f1c0000,
		.id_text = "NIFIC_1Gbps",
	}, {
		.id_lsw	= 0x4f1c0000,
		.id_hsw = 0x4f1c0000,
		.id_text = "Nific4_1Gb_COMBO6X",
	}, {
		.id_lsw	= 0x4f1c0101,
		.id_hsw = 0x4f1c01ff,
		.id_text = "Liberouter (4-NIC filtration)",
	}, {
		.id_lsw	= 0x4f1c0100,
		.id_hsw = 0x4f1c01ff,
		.id_text = "NIFIC_NetCOPE",
	}, {
		.id_lsw	= 0x41c10200,
		.id_hsw = 0x41c102ff,
		.id_text = "NIC_NetCOPE",
	}, {
		.id_lsw	= 0xf1010001,
		.id_hsw = 0xf10102ff,
		.id_text = "NETFLOW_1Gbps_Probe",
		.intfs  = 1,
		.driver_data = PCRDMA_LIMIT_BLOCKS,
	}, {
		.id_lsw	= 0x5ca20001,
		.id_hsw = 0x5ca20001,
		.id_text = "SCAMPI 10Gbps Monitoring adapter",
	}, {
		.id_lsw	= 0x1d510001,
		.id_hsw = 0x1d510001,
		.id_text = "IDS_1Gbps_Traffic_Scanner",
	}, {
		.id_lsw	= 0x1d510200,
		.id_hsw = 0x1d510200,
		.id_text = "IDS_1Gbps_Traffic_Scanner",
		.intfs  = 1,
	}, {
	}
};

static struct combo_driver pcrdma_ops = {
	.drv = {
		.owner  = THIS_MODULE,
		.name	= "pcr",
	},
	.dhw	= DHW_COMBO6X,
	.id_table = pcrdma_ids,
	.attach	= pcrdma_attach,
	.detach	= pcrdma_detach,
	.interrupt = pcrdma_interrupt,
};
