/*
 * cv3.h: Driver for the ComboV3 card - definitions
 * Copyright (c) 2013-2014 CESNET
 * Author(s): Martin Spinler <spinler@cesnet.cz>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#ifndef __COMBOV3_H
#define __COMBOV3_H

#include <linux/types.h>

#include <asm/io.h>

#include "combo6.h"
#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>

/*
 * FPGA space defines
 */

#define COMBOV3_ID_NEG		0x00
#define COMBOV3_ID_SW		0x04
#define COMBOV3_ID_HW		0x08
#define COMBOV3_ID_TEXT		0x20
#define COMBOV3_ID_CHANNELS	0x40
#define COMBOV3_ID_ID_VER	0x48
#define COMBOV3_ID_NETCOPE_VER	0x4A
#define COMBOV3_ID_IRQSTAT	0x54
#define  COMBOV3_IRQS_RX	0x00000001
#define  COMBOV3_IRQS_TX	0x00000002
#define  COMBOV3_IRQS_SYSMON	0x00000004
#define  COMBOV3_IRQS_LINK_CHG	0x00000008
#define COMBOV3_ID_IRQMASKAND	0x78
#define COMBOV3_ID_IRQMASKOR	0x7C

#define COMBOV3_BOOT_BASE 0x2000

#define ID32_TO_STR(strptr, val32) \
	*((strptr)+1) = (val32) & 0xff; \
	*((strptr)+0) = ((val32) >> 8) & 0xff; \
	*((strptr)+3) = ((val32) >> 16) & 0xff; \
	*((strptr)+2) = ((val32) >> 24) & 0xff;

int __devinit combov3_probe(struct pci_dev *pci,  const struct pci_device_id *id);
void __devexit combov3_remove(struct pci_dev *pci);

#endif /* __COMBO6V2_H */

