#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "space.h"

int main(int argc, char *argv) {
	int fd, r;
	int addr, i;
	const int BUFSIZE = 512;
	const int bio_len = 0x40;
	char buff[BUFSIZE];	
	
	fd = open("/dev/space", 0);
	if(fd < 0) {
		fprintf(stderr, "Unable to open device\n");
		return 1;
	}
	addr = ioctl(fd, SPACE_IOC_GETPHYSADDR, 0);
	printf("%X\n", addr);
	
	//writing
	t_transaction t;
/*
	sprintf(buff, "aadffasfhaf\0");

	t.pos = 0; //position in allocated space (the beginning)
	t.data = buff;
	t.len = 10;

	r = ioctl(fd, SPACE_IOC_WRITE, &t);
	if(r < 0) {
		fprintf(stderr, "write error\n");
		return 1;
	}

	//reading
	t.pos = 0; //position in allocated space (the beginning)
	t.data = buff;
	t.len = 10;

	r = ioctl(fd, SPACE_IOC_READ, &t);
	if(r < 0) {
		fprintf(stderr, "read error(%i)\n", r);
		return 1;
	}
	
	printf("%s\n", buff);
*/
	memset(buff, '\0', BUFSIZE);
	printf("Initial state: >%s<\n", buff);
	/* Burst I/O */
	t_biotransaction t_bio; /* burst io transaction */

	// burst reading from hw to buff
	t_bio.addr = (void*)0x100000; // phys addr of data in hw
	t_bio.len = bio_len; // transfer length -- transfer is devided into 256B bursts
	t_bio.data = buff; // destination buffer
	r = ioctl(fd, SPACE_IOC_BIOREAD, &t_bio);
	if(r < 0) {
		fprintf(stderr, "burst read error(%i)\n", r);
		return 1;
	}
	printf("First read: >%s<\n", buff);

	for (i = 0; i < BUFSIZE; i++)
		buff[i]++;
	// burst writing from buff to hw
	t_bio.addr = (void*)0x100000; // phys addr of destination in hw
	t_bio.len = bio_len; // transfer length -- transfer is devided into 256B bursts
	t_bio.data = buff; // source buffer
	r = ioctl(fd, SPACE_IOC_BIOWRITE, &t_bio);
	if(r < 0) {
		fprintf(stderr, "burst write error(%i)\n", r);
		return 1;
	}
	memset(buff, '\0', BUFSIZE);
	// burst reading from hw to buff
	t_bio.addr = (void*)0x100000; // phys addr of data in hw
	t_bio.len = bio_len; // transfer length -- transfer is devided into 256B bursts
	t_bio.data = buff; // destination buffer
	r = ioctl(fd, SPACE_IOC_BIOREAD, &t_bio);
	if(r < 0) {
		fprintf(stderr, "burst read error(%i)\n", r);
		return 1;
	}
	printf("Second read: >%s<\n", buff);

	close(fd);
	
	return 0;
}
