-- sysmon_ent.vhd
--!
--! @file
--! \brief System monitor with MI32 interface entity
--! \author Lukas Kekely <kekely@cesnet.cz>
--! \date 2012 
--!
--! @section License
--!
--! Copyright (C) 2012 CESNET
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
--! Part of IEEE standard library.
use IEEE.numeric_std.all;

--! \brief System monitor with MI32 interface entity.
--! \details Connects component SYSMON for different FPGAs to MI32 interface.
entity SYSMON_MI32 is
  generic (
    --! \brief Enable sysmon instantion
    SYSMON_EN      : boolean := true
  );
  port (
    --! \name Basic signals
    
    --! Global clock.
    --! \brief Global clock.
    --! \details For Virtex-5 the clock frequency must be in range from 2 Mhz to 200 MHz. \n
    --! For Virtex-6 the clock frequency must be in range from 2 MHz to 80 MHz. Note that initial 250 MHz maximum has been changed (see http://www.xilinx.com/support/answers/36642.htm).
    CLK            : in std_logic;
    --! Global reset.
    RESET          : in std_logic;

    --! name Sysmon direct signals 
    
    --! Bank select for sysmon
    BANK          : in std_logic_vector(1 downto 0);    
    --! Sysmon raised alarm, as programmed by SW
    ALARM         : out std_logic;
    
    --! \name MI32 interface
    
    --! Data to write.
    MI_DWR        : in  std_logic_vector(31 downto 0);
    --! Read/write address.
    MI_ADDR       : in  std_logic_vector(31 downto 0);
    --! Read valid.
    MI_RD         : in  std_logic;
    --! Write valid.
    MI_WR         : in  std_logic;
    --! Write data byte enable (not supported).
    MI_BE         : in  std_logic_vector(3 downto 0); 
    --! Read data.
    MI_DRD        : out std_logic_vector(31 downto 0);
    --! Read/write address ready.
    MI_ARDY       : out std_logic;
    --! Read data ready.
    MI_DRDY       : out std_logic
  );
end entity;
