// pcie3_7x_v3_0_wrapper.v: generic wrapper for gen3 PCIe cores v3.0
//                          (either X0Y0 or X0Y1)
// Copyright (C) 2014 CESNET
// Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in
//    the documentation and/or other materials provided with the
//    distribution.
// 3. Neither the name of the Company nor the names of its contributors
//    may be used to endorse or promote products derived from this
//    software without specific prior written permission.
//
// This software is provided ``as is'', and any express or implied
// warranties, including, but not limited to, the implied warranties of
// merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the company or contributors be liable for any
// direct, indirect, incidental, special, exemplary, or consequential
// damages (including, but not limited to, procurement of substitute
// goods or services; loss of use, data, or profits; or business
// interruption) however caused and on any theory of liability, whether
// in contract, strict liability, or tort (including negligence or
// otherwise) arising in any way out of the use of this software, even
// if advised of the possibility of such damage.
//
// $Id$
//


module pcie3_7x_v3_0 # (
  parameter [15:0] VENDOR_ID     = 16'h18EC,
  parameter [15:0] DEVICE_ID     = 16'hFBC0,
  parameter [15:0] SUB_VENDOR_ID = 16'h18EC,
  parameter [15:0] SUB_DEVICE_ID = 16'hFBC0,
  parameter        PCIE_CORE     = 0
  ) (
  pci_exp_txn,
  pci_exp_txp,
  pci_exp_rxn,
  pci_exp_rxp,
  user_clk,
  user_reset,
  user_lnk_up,
  user_app_rdy,
  s_axis_rq_tlast,
  s_axis_rq_tdata,
  s_axis_rq_tuser,
  s_axis_rq_tkeep,
  s_axis_rq_tready,
  s_axis_rq_tvalid,
  m_axis_rc_tdata,
  m_axis_rc_tuser,
  m_axis_rc_tlast,
  m_axis_rc_tkeep,
  m_axis_rc_tvalid,
  m_axis_rc_tready,
  m_axis_cq_tdata,
  m_axis_cq_tuser,
  m_axis_cq_tlast,
  m_axis_cq_tkeep,
  m_axis_cq_tvalid,
  m_axis_cq_tready,
  s_axis_cc_tdata,
  s_axis_cc_tuser,
  s_axis_cc_tlast,
  s_axis_cc_tkeep,
  s_axis_cc_tvalid,
  s_axis_cc_tready,
  pcie_rq_seq_num,
  pcie_rq_seq_num_vld,
  pcie_rq_tag,
  pcie_rq_tag_vld,
  pcie_cq_np_req,
  pcie_cq_np_req_count,
  cfg_phy_link_down,
  cfg_phy_link_status,
  cfg_negotiated_width,
  cfg_current_speed,
  cfg_max_payload,
  cfg_max_read_req,
  cfg_function_status,
  cfg_function_power_state,
  cfg_vf_status,
  cfg_vf_power_state,
  cfg_link_power_state,
  cfg_err_cor_out,
  cfg_err_nonfatal_out,
  cfg_err_fatal_out,
  cfg_ltr_enable,
  cfg_ltssm_state,
  cfg_rcb_status,
  cfg_dpa_substate_change,
  cfg_obff_enable,
  cfg_pl_status_change,
  cfg_tph_requester_enable,
  cfg_tph_st_mode,
  cfg_vf_tph_requester_enable,
  cfg_vf_tph_st_mode,
  cfg_interrupt_int,
  cfg_interrupt_pending,
  cfg_interrupt_sent,
  cfg_interrupt_msi_enable,
  cfg_interrupt_msi_vf_enable,
  cfg_interrupt_msi_mmenable,
  cfg_interrupt_msi_mask_update,
  cfg_interrupt_msi_data,
  cfg_interrupt_msi_select,
  cfg_interrupt_msi_int,
  cfg_interrupt_msi_pending_status,
  cfg_interrupt_msi_sent,
  cfg_interrupt_msi_fail,
  cfg_interrupt_msi_attr,
  cfg_interrupt_msi_tph_present,
  cfg_interrupt_msi_tph_type,
  cfg_interrupt_msi_tph_st_tag,
  cfg_interrupt_msi_function_number,
  sys_clk,
  sys_reset
);


output wire [7 : 0]   pci_exp_txn;
output wire [7 : 0]   pci_exp_txp;
 input wire [7 : 0]   pci_exp_rxn;
 input wire [7 : 0]   pci_exp_rxp;
output wire           user_clk;
output wire           user_reset;
output wire           user_lnk_up;
output wire           user_app_rdy;
 input wire           s_axis_rq_tlast;
 input wire [255 : 0] s_axis_rq_tdata;
 input wire [59 : 0]  s_axis_rq_tuser;
 input wire [7 : 0]   s_axis_rq_tkeep;
output wire [3 : 0]   s_axis_rq_tready;
 input wire           s_axis_rq_tvalid;
output wire [255 : 0] m_axis_rc_tdata;
output wire [74 : 0]  m_axis_rc_tuser;
output wire           m_axis_rc_tlast;
output wire [7 : 0]   m_axis_rc_tkeep;
output wire           m_axis_rc_tvalid;
 input wire [21 : 0]  m_axis_rc_tready;
output wire [255 : 0] m_axis_cq_tdata;
output wire [84 : 0]  m_axis_cq_tuser;
output wire           m_axis_cq_tlast;
output wire [7 : 0]   m_axis_cq_tkeep;
output wire           m_axis_cq_tvalid;
 input wire [21 : 0]  m_axis_cq_tready;
 input wire [255 : 0] s_axis_cc_tdata;
 input wire [32 : 0]  s_axis_cc_tuser;
 input wire           s_axis_cc_tlast;
 input wire [7 : 0]   s_axis_cc_tkeep;
 input wire           s_axis_cc_tvalid;
output wire [3 : 0]   s_axis_cc_tready;
output wire [3 : 0]   pcie_rq_seq_num;
output wire           pcie_rq_seq_num_vld;
output wire [5 : 0]   pcie_rq_tag;
output wire           pcie_rq_tag_vld;
 input wire           pcie_cq_np_req;
output wire [5 : 0]   pcie_cq_np_req_count;
output wire           cfg_phy_link_down;
output wire [1 : 0]   cfg_phy_link_status;
output wire [3 : 0]   cfg_negotiated_width;
output wire [2 : 0]   cfg_current_speed;
output wire [2 : 0]   cfg_max_payload;
output wire [2 : 0]   cfg_max_read_req;
output wire [7 : 0]   cfg_function_status;
output wire [5 : 0]   cfg_function_power_state;
output wire [11 : 0]  cfg_vf_status;
output wire [17 : 0]  cfg_vf_power_state;
output wire [1 : 0]   cfg_link_power_state;
output wire           cfg_err_cor_out;
output wire           cfg_err_nonfatal_out;
output wire           cfg_err_fatal_out;
output wire           cfg_ltr_enable;
output wire [5 : 0]   cfg_ltssm_state;
output wire [1 : 0]   cfg_rcb_status;
output wire [1 : 0]   cfg_dpa_substate_change;
output wire [1 : 0]   cfg_obff_enable;
output wire           cfg_pl_status_change;
output wire [1 : 0]   cfg_tph_requester_enable;
output wire [5 : 0]   cfg_tph_st_mode;
output wire [5 : 0]   cfg_vf_tph_requester_enable;
output wire [17 : 0]  cfg_vf_tph_st_mode;
 input wire [3 : 0]   cfg_interrupt_int;
 input wire [1 : 0]   cfg_interrupt_pending;
output wire           cfg_interrupt_sent;
output wire [1 : 0]   cfg_interrupt_msi_enable;
output wire [5 : 0]   cfg_interrupt_msi_vf_enable;
output wire [5 : 0]   cfg_interrupt_msi_mmenable;
output wire           cfg_interrupt_msi_mask_update;
output wire [31 : 0]  cfg_interrupt_msi_data;
 input wire [3 : 0]   cfg_interrupt_msi_select;
 input wire [31 : 0]  cfg_interrupt_msi_int;
 input wire [63 : 0]  cfg_interrupt_msi_pending_status;
output wire           cfg_interrupt_msi_sent;
output wire           cfg_interrupt_msi_fail;
 input wire [2 : 0]   cfg_interrupt_msi_attr;
 input wire           cfg_interrupt_msi_tph_present;
 input wire [1 : 0]   cfg_interrupt_msi_tph_type;
 input wire [8 : 0]   cfg_interrupt_msi_tph_st_tag;
 input wire [2 : 0]   cfg_interrupt_msi_function_number;
 input wire           sys_clk;
 input wire           sys_reset;

 
  pcie3_7x_v3_0_pcie_3_0_7vx #(
    .PL_LINK_CAP_MAX_LINK_SPEED(4),
    .PL_LINK_CAP_MAX_LINK_WIDTH(8),
    .USER_CLK2_FREQ(4),
    .PF0_LINK_CAP_ASPM_SUPPORT(0),
    .C_DATA_WIDTH(256),
    .REF_CLK_FREQ(0),
    .PCIE_LINK_SPEED(3),
    .KEEP_WIDTH(8),
    .ARI_CAP_ENABLE("FALSE"),
    .PF0_ARI_CAP_NEXT_FUNC('H0),
    .AXISTEN_IF_CC_ALIGNMENT_MODE("FALSE"),
    .AXISTEN_IF_CQ_ALIGNMENT_MODE("FALSE"),
    .AXISTEN_IF_RC_ALIGNMENT_MODE("FALSE"),
    .AXISTEN_IF_RC_STRADDLE("FALSE"),
    .AXISTEN_IF_RQ_ALIGNMENT_MODE("FALSE"),
    .PF0_AER_CAP_ECRC_CHECK_CAPABLE("FALSE"),
    .PF0_AER_CAP_ECRC_GEN_CAPABLE("FALSE"),
    .PF0_AER_CAP_NEXTPTR('H300),
    .PF0_ARI_CAP_NEXTPTR('H000),
    .VF0_ARI_CAP_NEXTPTR('H000),
    .VF1_ARI_CAP_NEXTPTR('H000),
    .VF2_ARI_CAP_NEXTPTR('H000),
    .VF3_ARI_CAP_NEXTPTR('H000),
    .VF4_ARI_CAP_NEXTPTR('H000),
    .VF5_ARI_CAP_NEXTPTR('H000),
    .PF0_BAR0_APERTURE_SIZE('B10100),
    .PF0_BAR0_CONTROL('B110),
    .PF0_BAR1_APERTURE_SIZE('B00000),
    .PF0_BAR1_CONTROL('B000),
    .PF0_BAR2_APERTURE_SIZE('B10100),
    .PF0_BAR2_CONTROL('B110),
    .PF0_BAR3_APERTURE_SIZE('B00000),
    .PF0_BAR3_CONTROL('B000),
    .PF0_BAR4_APERTURE_SIZE('B00000),
    .PF0_BAR4_CONTROL('B000),
    .PF0_BAR5_APERTURE_SIZE('B00000),
    .PF0_BAR5_CONTROL('B000),
    .PF0_CAPABILITY_POINTER('H80),
    .PF0_CLASS_CODE('H020000),
    .PF0_VENDOR_ID(VENDOR_ID),
    .PF0_DEVICE_ID(DEVICE_ID),
    .PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT("FALSE"),
    .PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT("FALSE"),
    .PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT("FALSE"),
    .PF0_DEV_CAP2_LTR_SUPPORT("FALSE"),
    .PF0_DEV_CAP2_OBFF_SUPPORT('D0),
    .PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT("FALSE"),
    .PF0_DEV_CAP_EXT_TAG_SUPPORTED("FALSE"),
    .PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE("FALSE"),
    .PF0_DEV_CAP_MAX_PAYLOAD_SIZE('B011),
    .PF0_DPA_CAP_NEXTPTR('H300),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0('H00),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1('H00),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2('H00),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3('H00),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4('H00),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5('H00),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6('H00),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7('H00),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0('H00),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1('H00),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2('H00),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3('H00),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4('H00),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5('H00),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6('H00),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7('H00),
    .PF0_DSN_CAP_NEXTPTR('H300),
    .PF0_EXPANSION_ROM_APERTURE_SIZE('B00000),
    .PF0_EXPANSION_ROM_ENABLE("FALSE"),
    .PF0_INTERRUPT_PIN('H00),
    .PF0_LINK_STATUS_SLOT_CLOCK_CONFIG("TRUE"),
    .PF0_LTR_CAP_NEXTPTR('H300),
    .PF0_MSIX_CAP_NEXTPTR('H00),
    .PF0_MSIX_CAP_PBA_BIR(0),
    .PF0_MSIX_CAP_PBA_OFFSET('H00000000),
    .PF0_MSIX_CAP_TABLE_BIR(0),
    .PF0_MSIX_CAP_TABLE_OFFSET('H00000000),
    .PF0_MSIX_CAP_TABLE_SIZE('H000),
    .PF0_MSI_CAP_MULTIMSGCAP(0),
    .PF0_MSI_CAP_NEXTPTR('HC0),
    .PF0_PB_CAP_NEXTPTR('H274),
    .PF0_PM_CAP_NEXTPTR('H90),
    .PF0_PM_CAP_PMESUPPORT_D0("FALSE"),
    .PF0_PM_CAP_PMESUPPORT_D1("FALSE"),
    .PF0_PM_CAP_PMESUPPORT_D3HOT("FALSE"),
    .PF0_PM_CAP_SUPP_D1_STATE("FALSE"),
    .PF0_RBAR_CAP_ENABLE("FALSE"),
    .PF0_RBAR_CAP_NEXTPTR('H300),
    .PF0_RBAR_CAP_SIZE0('H00000),
    .PF0_RBAR_CAP_SIZE1('H00000),
    .PF0_RBAR_CAP_SIZE2('H00000),
    .PF1_RBAR_CAP_SIZE0('H00000),
    .PF1_RBAR_CAP_SIZE1('H00000),
    .PF1_RBAR_CAP_SIZE2('H00000),
    .PF0_REVISION_ID('H00),
    .PF0_SRIOV_BAR0_APERTURE_SIZE('B00000),
    .PF0_SRIOV_BAR0_CONTROL('B000),
    .PF0_SRIOV_BAR1_APERTURE_SIZE('B00000),
    .PF0_SRIOV_BAR1_CONTROL('B000),
    .PF0_SRIOV_BAR2_APERTURE_SIZE('B00000),
    .PF0_SRIOV_BAR2_CONTROL('B000),
    .PF0_SRIOV_BAR3_APERTURE_SIZE('B00000),
    .PF0_SRIOV_BAR3_CONTROL('B000),
    .PF0_SRIOV_BAR4_APERTURE_SIZE('B00000),
    .PF0_SRIOV_BAR4_CONTROL('B000),
    .PF0_SRIOV_BAR5_APERTURE_SIZE('B00000),
    .PF0_SRIOV_BAR5_CONTROL('B000),
    .PF0_SRIOV_CAP_INITIAL_VF('H0000),
    .PF0_SRIOV_CAP_NEXTPTR('H300),
    .PF0_SRIOV_CAP_TOTAL_VF('H0000),
    .PF0_SRIOV_CAP_VER('H0),
    .PF0_SRIOV_FIRST_VF_OFFSET('H0000),
    .PF0_SRIOV_FUNC_DEP_LINK('H0000),
    .PF0_SRIOV_SUPPORTED_PAGE_SIZE('H00000553),
    .PF0_SRIOV_VF_DEVICE_ID('H0000),
    .PF0_SUBSYSTEM_VENDOR_ID(SUB_VENDOR_ID),
    .PF0_SUBSYSTEM_ID(SUB_DEVICE_ID),
    .PF0_TPHR_CAP_ENABLE("FALSE"),
    .PF0_TPHR_CAP_NEXTPTR('H300),
    .VF0_TPHR_CAP_NEXTPTR('H000),
    .VF1_TPHR_CAP_NEXTPTR('H000),
    .VF2_TPHR_CAP_NEXTPTR('H000),
    .VF3_TPHR_CAP_NEXTPTR('H000),
    .VF4_TPHR_CAP_NEXTPTR('H000),
    .VF5_TPHR_CAP_NEXTPTR('H000),
    .PF0_TPHR_CAP_ST_MODE_SEL('H0),
    .PF0_TPHR_CAP_ST_TABLE_LOC('H0),
    .PF0_TPHR_CAP_ST_TABLE_SIZE('H000),
    .PF0_TPHR_CAP_VER('H1),
    .PF1_TPHR_CAP_ST_MODE_SEL('H0),
    .PF1_TPHR_CAP_ST_TABLE_LOC('H0),
    .PF1_TPHR_CAP_ST_TABLE_SIZE('H000),
    .PF1_TPHR_CAP_VER('H1),
    .VF0_TPHR_CAP_ST_MODE_SEL('H0),
    .VF0_TPHR_CAP_ST_TABLE_LOC('H0),
    .VF0_TPHR_CAP_ST_TABLE_SIZE('H000),
    .VF0_TPHR_CAP_VER('H1),
    .VF1_TPHR_CAP_ST_MODE_SEL('H0),
    .VF1_TPHR_CAP_ST_TABLE_LOC('H0),
    .VF1_TPHR_CAP_ST_TABLE_SIZE('H000),
    .VF1_TPHR_CAP_VER('H1),
    .VF2_TPHR_CAP_ST_MODE_SEL('H0),
    .VF2_TPHR_CAP_ST_TABLE_LOC('H0),
    .VF2_TPHR_CAP_ST_TABLE_SIZE('H000),
    .VF2_TPHR_CAP_VER('H1),
    .VF3_TPHR_CAP_ST_MODE_SEL('H0),
    .VF3_TPHR_CAP_ST_TABLE_LOC('H0),
    .VF3_TPHR_CAP_ST_TABLE_SIZE('H000),
    .VF3_TPHR_CAP_VER('H1),
    .VF4_TPHR_CAP_ST_MODE_SEL('H0),
    .VF4_TPHR_CAP_ST_TABLE_LOC('H0),
    .VF4_TPHR_CAP_ST_TABLE_SIZE('H000),
    .VF4_TPHR_CAP_VER('H1),
    .VF5_TPHR_CAP_ST_MODE_SEL('H0),
    .VF5_TPHR_CAP_ST_TABLE_LOC('H0),
    .VF5_TPHR_CAP_ST_TABLE_SIZE('H000),
    .VF5_TPHR_CAP_VER('H1),
    .PF0_TPHR_CAP_DEV_SPECIFIC_MODE("TRUE"),
    .PF0_TPHR_CAP_INT_VEC_MODE("FALSE"),
    .PF1_TPHR_CAP_DEV_SPECIFIC_MODE("TRUE"),
    .PF1_TPHR_CAP_INT_VEC_MODE("FALSE"),
    .VF0_TPHR_CAP_DEV_SPECIFIC_MODE("TRUE"),
    .VF0_TPHR_CAP_INT_VEC_MODE("FALSE"),
    .VF1_TPHR_CAP_DEV_SPECIFIC_MODE("TRUE"),
    .VF1_TPHR_CAP_INT_VEC_MODE("FALSE"),
    .VF2_TPHR_CAP_DEV_SPECIFIC_MODE("TRUE"),
    .VF2_TPHR_CAP_INT_VEC_MODE("FALSE"),
    .VF3_TPHR_CAP_DEV_SPECIFIC_MODE("TRUE"),
    .VF3_TPHR_CAP_INT_VEC_MODE("FALSE"),
    .VF4_TPHR_CAP_DEV_SPECIFIC_MODE("TRUE"),
    .VF4_TPHR_CAP_INT_VEC_MODE("FALSE"),
    .VF5_TPHR_CAP_DEV_SPECIFIC_MODE("TRUE"),
    .VF5_TPHR_CAP_INT_VEC_MODE("FALSE"),
    .PF0_VC_CAP_NEXTPTR('H000),
    .SPARE_WORD1('H00),
    .PF1_AER_CAP_ECRC_CHECK_CAPABLE("FALSE"),
    .PF1_AER_CAP_ECRC_GEN_CAPABLE("FALSE"),
    .PF1_AER_CAP_NEXTPTR('H000),
    .PF1_ARI_CAP_NEXTPTR('H000),
    .PF1_BAR0_APERTURE_SIZE('B00000),
    .PF1_BAR0_CONTROL('B000),
    .PF1_BAR1_APERTURE_SIZE('B00000),
    .PF1_BAR1_CONTROL('B000),
    .PF1_BAR2_APERTURE_SIZE('B00000),
    .PF1_BAR2_CONTROL('B000),
    .PF1_BAR3_APERTURE_SIZE('B00000),
    .PF1_BAR3_CONTROL('B000),
    .PF1_BAR4_APERTURE_SIZE('B00000),
    .PF1_BAR4_CONTROL('B000),
    .PF1_BAR5_APERTURE_SIZE('B00000),
    .PF1_BAR5_CONTROL('B000),
    .PF1_CAPABILITY_POINTER('H80),
    .PF1_CLASS_CODE('H058000),
    .PF1_DEVICE_ID('H7011),
    .PF1_DEV_CAP_MAX_PAYLOAD_SIZE('B010),
    .PF1_DPA_CAP_NEXTPTR('H000),
    .PF1_DSN_CAP_NEXTPTR('H000),
    .PF1_EXPANSION_ROM_APERTURE_SIZE('B00000),
    .PF1_EXPANSION_ROM_ENABLE("FALSE"),
    .PF1_INTERRUPT_PIN('H00),
    .PF1_MSIX_CAP_NEXTPTR('H00),
    .PF1_MSIX_CAP_PBA_BIR(0),
    .PF1_MSIX_CAP_PBA_OFFSET('H00000000),
    .PF1_MSIX_CAP_TABLE_BIR(0),
    .PF1_MSIX_CAP_TABLE_OFFSET('H00000000),
    .PF1_MSIX_CAP_TABLE_SIZE('H000),
    .PF1_MSI_CAP_MULTIMSGCAP(0),
    .PF1_MSI_CAP_NEXTPTR('H00),
    .PF1_PB_CAP_NEXTPTR('H000),
    .PF1_PM_CAP_NEXTPTR('H00),
    .PF1_RBAR_CAP_ENABLE("FALSE"),
    .PF1_RBAR_CAP_NEXTPTR('H000),
    .PF1_REVISION_ID('H00),
    .PF1_SRIOV_BAR0_APERTURE_SIZE('B00000),
    .PF1_SRIOV_BAR0_CONTROL('B000),
    .PF1_SRIOV_BAR1_APERTURE_SIZE('B00000),
    .PF1_SRIOV_BAR1_CONTROL('B000),
    .PF1_SRIOV_BAR2_APERTURE_SIZE('B00000),
    .PF1_SRIOV_BAR2_CONTROL('B000),
    .PF1_SRIOV_BAR3_APERTURE_SIZE('B00000),
    .PF1_SRIOV_BAR3_CONTROL('B000),
    .PF1_SRIOV_BAR4_APERTURE_SIZE('B00000),
    .PF1_SRIOV_BAR4_CONTROL('B000),
    .PF1_SRIOV_BAR5_APERTURE_SIZE('B00000),
    .PF1_SRIOV_BAR5_CONTROL('B000),
    .PF1_SRIOV_CAP_INITIAL_VF('H0000),
    .PF1_SRIOV_CAP_NEXTPTR('H000),
    .PF1_SRIOV_CAP_TOTAL_VF('H0000),
    .PF1_SRIOV_CAP_VER('H0),
    .PF1_SRIOV_FIRST_VF_OFFSET('H0000),
    .PF1_SRIOV_FUNC_DEP_LINK('H0001),
    .PF1_SRIOV_SUPPORTED_PAGE_SIZE('H00000553),
    .PF1_SRIOV_VF_DEVICE_ID('H0000),
    .PF1_SUBSYSTEM_ID('H0007),
    .PF1_TPHR_CAP_ENABLE("FALSE"),
    .PF1_TPHR_CAP_NEXTPTR('H000),
    .PL_UPSTREAM_FACING("TRUE"),
    .SRIOV_CAP_ENABLE("FALSE"),
    .TL_CREDITS_CD('H000),
    .TL_CREDITS_CH('H00),
    .TL_CREDITS_NPD('H28),
    .TL_CREDITS_NPH('H20),
    .TL_CREDITS_PD('H198),
    .TL_CREDITS_PH('H20),
    .TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE("FALSE"),
    .TL_LEGACY_MODE_ENABLE("FALSE"),
    .TL_PF_ENABLE_REG("FALSE"),
    .VF0_CAPABILITY_POINTER('H80),
    .VF0_MSIX_CAP_PBA_BIR(0),
    .VF0_MSIX_CAP_PBA_OFFSET('H00000000),
    .VF0_MSIX_CAP_TABLE_BIR(0),
    .VF0_MSIX_CAP_TABLE_OFFSET('H00000000),
    .VF0_MSIX_CAP_TABLE_SIZE('H000),
    .VF0_MSI_CAP_MULTIMSGCAP(0),
    .VF0_PM_CAP_NEXTPTR('B00000000),
    .VF1_MSIX_CAP_PBA_BIR(0),
    .VF1_MSIX_CAP_PBA_OFFSET('H00000000),
    .VF1_MSIX_CAP_TABLE_BIR(0),
    .VF1_MSIX_CAP_TABLE_OFFSET('H00000000),
    .VF1_MSIX_CAP_TABLE_SIZE('H000),
    .VF1_MSI_CAP_MULTIMSGCAP(0),
    .VF1_PM_CAP_NEXTPTR('B00000000),
    .VF2_MSIX_CAP_PBA_BIR(0),
    .VF2_MSIX_CAP_PBA_OFFSET('H00000000),
    .VF2_MSIX_CAP_TABLE_BIR(0),
    .VF2_MSIX_CAP_TABLE_OFFSET('H00000000),
    .VF2_MSIX_CAP_TABLE_SIZE('H000),
    .VF2_MSI_CAP_MULTIMSGCAP(0),
    .VF2_PM_CAP_NEXTPTR('B00000000),
    .VF3_MSIX_CAP_PBA_BIR(0),
    .VF3_MSIX_CAP_PBA_OFFSET('H00000000),
    .VF3_MSIX_CAP_TABLE_BIR(0),
    .VF3_MSIX_CAP_TABLE_OFFSET('H00000000),
    .VF3_MSIX_CAP_TABLE_SIZE('H000),
    .VF3_MSI_CAP_MULTIMSGCAP(0),
    .VF3_PM_CAP_NEXTPTR('B00000000),
    .VF4_MSIX_CAP_PBA_BIR(0),
    .VF4_MSIX_CAP_PBA_OFFSET('H00000000),
    .VF4_MSIX_CAP_TABLE_BIR(0),
    .VF4_MSIX_CAP_TABLE_OFFSET('H00000000),
    .VF4_MSIX_CAP_TABLE_SIZE('H000),
    .VF4_MSI_CAP_MULTIMSGCAP(0),
    .VF4_PM_CAP_NEXTPTR('B00000000),
    .VF5_MSIX_CAP_PBA_BIR(0),
    .VF5_MSIX_CAP_PBA_OFFSET('H00000000),
    .VF5_MSIX_CAP_TABLE_BIR(0),
    .VF5_MSIX_CAP_TABLE_OFFSET('H00000000),
    .VF5_MSIX_CAP_TABLE_SIZE('H000),
    .VF5_MSI_CAP_MULTIMSGCAP(0),
    .VF5_PM_CAP_NEXTPTR('B00000000),
    .COMPLETION_SPACE("16KB"),
    .gen_x0y0_ucf(1-PCIE_CORE),
    .gen_x0y3_ucf(0),
    .gen_x0y2_ucf(0),
    .gen_x0y1_ucf(PCIE_CORE),
    .silicon_revision("Production"),
    .xlnx_ref_board(0),
    .pcie_blk_locn(PCIE_CORE),
    .SHARED_LOGIC_IN_CORE("FALSE"),
    .PIPE_SIM("FALSE"),
    .MSI_EN("TRUE"),
    .MSIX_EN("FALSE"),
    .PCIE_EXT_CLK("FALSE"),
    .PCIE_EXT_GT_COMMON("FALSE"),
    .EXT_CH_GT_DRP("FALSE"),
    .CFG_STATUS_IF("TRUE"),
    .TX_FC_IF("FALSE"),
    .CFG_EXT_IF("FALSE"),
    .CFG_FC_IF("FALSE"),
    .PER_FUNC_STATUS_IF("FALSE"),
    .CFG_MGMT_IF("FALSE"),
    .RCV_MSG_IF("FALSE"),
    .CFG_TX_MSG_IF("FALSE"),
    .CFG_CTL_IF("FALSE"),
    .PCIE_DRP("FALSE"),
    .TRANSCEIVER_CTRL_STATUS_PORTS("FALSE"),
    .AXISTEN_IF_ENABLE_CLIENT_TAG("TRUE"),
    .PCIE_USE_MODE("2.1"),
    .PCIE_FAST_CONFIG("NONE"),
    .EXT_STARTUP_PRIMITIVE("FALSE"),
    .EXT_PIPE_INTERFACE("FALSE")
  ) inst (
    .pci_exp_txn(pci_exp_txn),
    .pci_exp_txp(pci_exp_txp),
    .pci_exp_rxn(pci_exp_rxn),
    .pci_exp_rxp(pci_exp_rxp),
    .int_pclk_out_slave(),
    .int_pipe_rxusrclk_out(),
    .int_rxoutclk_out(),
    .int_dclk_out(),
    .int_userclk1_out(),
    .int_userclk2_out(),
    .int_oobclk_out(),
    .int_qplllock_out(),
    .int_qplloutclk_out(),
    .int_qplloutrefclk_out(),
    .int_pclk_sel_slave(8'B0),
    .pipe_pclk_in(1'B0),
    .pipe_rxusrclk_in(1'B0),
    .pipe_rxoutclk_in(8'B0),
    .pipe_dclk_in(1'B0),
    .pipe_userclk1_in(1'B0),
    .pipe_userclk2_in(1'B0),
    .pipe_oobclk_in(1'B0),
    .pipe_mmcm_lock_in(1'B1),
    .pipe_txoutclk_out(),
    .pipe_rxoutclk_out(),
    .pipe_pclk_sel_out(),
    .pipe_gen3_out(),
    .pipe_mmcm_rst_n(1'B1),
    .user_clk(user_clk),
    .user_reset(user_reset),
    .user_lnk_up(user_lnk_up),
    .user_app_rdy(user_app_rdy),
    .s_axis_rq_tlast(s_axis_rq_tlast),
    .s_axis_rq_tdata(s_axis_rq_tdata),
    .s_axis_rq_tuser(s_axis_rq_tuser),
    .s_axis_rq_tkeep(s_axis_rq_tkeep),
    .s_axis_rq_tready(s_axis_rq_tready),
    .s_axis_rq_tvalid(s_axis_rq_tvalid),
    .m_axis_rc_tdata(m_axis_rc_tdata),
    .m_axis_rc_tuser(m_axis_rc_tuser),
    .m_axis_rc_tlast(m_axis_rc_tlast),
    .m_axis_rc_tkeep(m_axis_rc_tkeep),
    .m_axis_rc_tvalid(m_axis_rc_tvalid),
    .m_axis_rc_tready(m_axis_rc_tready),
    .m_axis_cq_tdata(m_axis_cq_tdata),
    .m_axis_cq_tuser(m_axis_cq_tuser),
    .m_axis_cq_tlast(m_axis_cq_tlast),
    .m_axis_cq_tkeep(m_axis_cq_tkeep),
    .m_axis_cq_tvalid(m_axis_cq_tvalid),
    .m_axis_cq_tready(m_axis_cq_tready),
    .s_axis_cc_tdata(s_axis_cc_tdata),
    .s_axis_cc_tuser(s_axis_cc_tuser),
    .s_axis_cc_tlast(s_axis_cc_tlast),
    .s_axis_cc_tkeep(s_axis_cc_tkeep),
    .s_axis_cc_tvalid(s_axis_cc_tvalid),
    .s_axis_cc_tready(s_axis_cc_tready),
    .pcie_rq_seq_num(pcie_rq_seq_num),
    .pcie_rq_seq_num_vld(pcie_rq_seq_num_vld),
    .pcie_rq_tag(pcie_rq_tag),
    .pcie_rq_tag_vld(pcie_rq_tag_vld),
    .pcie_tfc_nph_av(),
    .pcie_tfc_npd_av(),
    .pcie_cq_np_req(pcie_cq_np_req),
    .pcie_cq_np_req_count(pcie_cq_np_req_count),
    .cfg_phy_link_down(cfg_phy_link_down),
    .cfg_phy_link_status(cfg_phy_link_status),
    .cfg_negotiated_width(cfg_negotiated_width),
    .cfg_current_speed(cfg_current_speed),
    .cfg_max_payload(cfg_max_payload),
    .cfg_max_read_req(cfg_max_read_req),
    .cfg_function_status(cfg_function_status),
    .cfg_function_power_state(cfg_function_power_state),
    .cfg_vf_status(cfg_vf_status),
    .cfg_vf_power_state(cfg_vf_power_state),
    .cfg_link_power_state(cfg_link_power_state),
    .cfg_mgmt_addr(19'B0),
    .cfg_mgmt_write(1'B0),
    .cfg_mgmt_write_data(32'B0),
    .cfg_mgmt_byte_enable(4'B0),
    .cfg_mgmt_read(1'B0),
    .cfg_mgmt_read_data(),
    .cfg_mgmt_read_write_done(),
    .cfg_mgmt_type1_cfg_reg_access(1'B0),
    .cfg_err_cor_out(cfg_err_cor_out),
    .cfg_err_nonfatal_out(cfg_err_nonfatal_out),
    .cfg_err_fatal_out(cfg_err_fatal_out),
    .cfg_ltr_enable(cfg_ltr_enable),
    .cfg_ltssm_state(cfg_ltssm_state),
    .cfg_rcb_status(cfg_rcb_status),
    .cfg_dpa_substate_change(cfg_dpa_substate_change),
    .cfg_obff_enable(cfg_obff_enable),
    .cfg_pl_status_change(cfg_pl_status_change),
    .cfg_tph_requester_enable(cfg_tph_requester_enable),
    .cfg_tph_st_mode(cfg_tph_st_mode),
    .cfg_vf_tph_requester_enable(cfg_vf_tph_requester_enable),
    .cfg_vf_tph_st_mode(cfg_vf_tph_st_mode),
    .cfg_msg_received(),
    .cfg_msg_received_data(),
    .cfg_msg_received_type(),
    .cfg_msg_transmit(1'B0),
    .cfg_msg_transmit_type(3'B0),
    .cfg_msg_transmit_data(32'B0),
    .cfg_msg_transmit_done(),
    .cfg_fc_ph(),
    .cfg_fc_pd(),
    .cfg_fc_nph(),
    .cfg_fc_npd(),
    .cfg_fc_cplh(),
    .cfg_fc_cpld(),
    .cfg_fc_sel(3'B0),
    .cfg_per_func_status_control(3'B0),
    .cfg_per_func_status_data(),
    .cfg_per_function_number(3'B0),
    .cfg_per_function_output_request(1'B0),
    .cfg_per_function_update_done(),
    .cfg_subsys_vend_id(16'H18EC),
    .cfg_dsn(64'B0),
    .cfg_power_state_change_ack(1'B0),
    .cfg_power_state_change_interrupt(),
    .cfg_err_cor_in(1'B0),
    .cfg_err_uncor_in(1'B0),
    .cfg_flr_in_process(),
    .cfg_flr_done(2'B0),
    .cfg_vf_flr_in_process(),
    .cfg_vf_flr_done(6'B0),
    .cfg_link_training_enable(1'B1),
    .cfg_ext_read_received(),
    .cfg_ext_write_received(),
    .cfg_ext_register_number(),
    .cfg_ext_function_number(),
    .cfg_ext_write_data(),
    .cfg_ext_write_byte_enable(),
    .cfg_ext_read_data(32'B0),
    .cfg_ext_read_data_valid(1'B0),
    .cfg_interrupt_int(cfg_interrupt_int),
    .cfg_interrupt_pending(cfg_interrupt_pending),
    .cfg_interrupt_sent(cfg_interrupt_sent),
    .cfg_interrupt_msi_enable(cfg_interrupt_msi_enable),
    .cfg_interrupt_msi_vf_enable(cfg_interrupt_msi_vf_enable),
    .cfg_interrupt_msi_mmenable(cfg_interrupt_msi_mmenable),
    .cfg_interrupt_msi_mask_update(cfg_interrupt_msi_mask_update),
    .cfg_interrupt_msi_data(cfg_interrupt_msi_data),
    .cfg_interrupt_msi_select(cfg_interrupt_msi_select),
    .cfg_interrupt_msi_int(cfg_interrupt_msi_int),
    .cfg_interrupt_msi_pending_status(cfg_interrupt_msi_pending_status),
    .cfg_interrupt_msi_sent(cfg_interrupt_msi_sent),
    .cfg_interrupt_msi_fail(cfg_interrupt_msi_fail),
    .cfg_interrupt_msix_enable(),
    .cfg_interrupt_msix_mask(),
    .cfg_interrupt_msix_vf_enable(),
    .cfg_interrupt_msix_vf_mask(),
    .cfg_interrupt_msix_data(32'B0),
    .cfg_interrupt_msix_address(64'B0),
    .cfg_interrupt_msix_int(1'B0),
    .cfg_interrupt_msix_sent(),
    .cfg_interrupt_msix_fail(),
    .cfg_interrupt_msi_attr(cfg_interrupt_msi_attr),
    .cfg_interrupt_msi_tph_present(cfg_interrupt_msi_tph_present),
    .cfg_interrupt_msi_tph_type(cfg_interrupt_msi_tph_type),
    .cfg_interrupt_msi_tph_st_tag(cfg_interrupt_msi_tph_st_tag),
    .cfg_interrupt_msi_function_number(cfg_interrupt_msi_function_number),
    .cfg_hot_reset_out(),
    .cfg_config_space_enable(1'B1),
    .cfg_req_pm_transition_l23_ready(1'B0),
    .cfg_hot_reset_in(1'B0),
    .cfg_ds_port_number(8'B0),
    .cfg_ds_bus_number(8'B0),
    .cfg_ds_device_number(5'B0),
    .cfg_ds_function_number(3'B0),
    .user_tph_stt_address(5'B0),
    .user_tph_function_num(3'B0),
    .user_tph_stt_read_data(),
    .user_tph_stt_read_data_valid(),
    .user_tph_stt_read_enable(1'B0),
    .sys_clk(sys_clk),
    .sys_reset(sys_reset),
    .qpll_drp_crscode(12'B0),
    .qpll_drp_fsm(18'B0),
    .qpll_drp_done(2'B0),
    .qpll_drp_reset(2'B0),
    .qpll_qplllock(2'B0),
    .qpll_qplloutclk(2'B0),
    .qpll_qplloutrefclk(2'B0),
    .qpll_qplld(),
    .qpll_qpllreset(),
    .qpll_drp_clk(),
    .qpll_drp_rst_n(),
    .qpll_drp_ovrd(),
    .qpll_drp_gen3(),
    .qpll_drp_start(),
    .pipe_txprbssel(3'B0),
    .pipe_rxprbssel(3'B0),
    .pipe_txprbsforceerr(1'B0),
    .pipe_rxprbscntreset(1'B0),
    .pipe_loopback(3'B0),
    .pipe_rxprbserr(),
    .pipe_rst_fsm(),
    .pipe_qrst_fsm(),
    .pipe_rate_fsm(),
    .pipe_sync_fsm_tx(),
    .pipe_sync_fsm_rx(),
    .pipe_drp_fsm(),
    .pipe_rst_idle(),
    .pipe_qrst_idle(),
    .pipe_rate_idle(),
    .pipe_eyescandataerror(),
    .pipe_rxstatus(),
    .pipe_dmonitorout(),
    .pipe_cpll_lock(),
    .pipe_qpll_lock(),
    .pipe_rxpmaresetdone(),
    .pipe_rxbufstatus(),
    .pipe_txphaligndone(),
    .pipe_txphinitdone(),
    .pipe_txdlysresetdone(),
    .pipe_rxphaligndone(),
    .pipe_rxdlysresetdone(),
    .pipe_rxsyncdone(),
    .pipe_rxdisperr(),
    .pipe_rxnotintable(),
    .pipe_rxcommadet(),
    .gt_ch_drp_rdy(),
    .pipe_debug_0(),
    .pipe_debug_1(),
    .pipe_debug_2(),
    .pipe_debug_3(),
    .pipe_debug_4(),
    .pipe_debug_5(),
    .pipe_debug_6(),
    .pipe_debug_7(),
    .pipe_debug_8(),
    .pipe_debug_9(),
    .pipe_debug(),
    .ext_ch_gt_drpclk(),
    .ext_ch_gt_drpaddr(72'B0),
    .ext_ch_gt_drpen(8'B0),
    .ext_ch_gt_drpdi(128'B0),
    .ext_ch_gt_drpwe(8'B0),
    .ext_ch_gt_drpdo(),
    .ext_ch_gt_drprdy(),
    .icap_clk(1'B0),
    .icap_csib(1'B1),
    .icap_rdwrb(1'B1),
    .icap_i(32'D4294967295),
    .icap_o(),
    .startup_eos_in(1'B0),
    .startup_cfgclk(),
    .startup_cfgmclk(),
    .startup_eos(),
    .startup_preq(),
    .startup_clk(1'B0),
    .startup_gsr(1'B0),
    .startup_gts(1'B0),
    .startup_keyclearb(1'B1),
    .startup_pack(1'B0),
    .startup_usrcclko(1'B0),
    .startup_usrcclkts(1'B1),
    .startup_usrdoneo(1'B0),
    .startup_usrdonets(1'B1),
    .pcie_drp_clk(1'B1),
    .pcie_drp_en(1'B0),
    .pcie_drp_we(1'B0),
    .pcie_drp_addr(11'B0),
    .pcie_drp_di(16'B0),
    .pcie_drp_do(),
    .pcie_drp_rdy(),
    .common_commands_in(26'B0),
    .pipe_rx_0_sigs(84'B0),
    .pipe_rx_1_sigs(84'B0),
    .pipe_rx_2_sigs(84'B0),
    .pipe_rx_3_sigs(84'B0),
    .pipe_rx_4_sigs(84'B0),
    .pipe_rx_5_sigs(84'B0),
    .pipe_rx_6_sigs(84'B0),
    .pipe_rx_7_sigs(84'B0),
    .common_commands_out(),
    .pipe_tx_0_sigs(),
    .pipe_tx_1_sigs(),
    .pipe_tx_2_sigs(),
    .pipe_tx_3_sigs(),
    .pipe_tx_4_sigs(),
    .pipe_tx_5_sigs(),
    .pipe_tx_6_sigs(),
    .pipe_tx_7_sigs()
  );
endmodule
