-- dma_down_int_ent.vhd: DMA DOWN interface connection - entity
-- Copyright (C) 2013 CESNET
-- Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity dma_down_int is
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK              : in  std_logic;
      -- Synchronous reset
      RESET            : in  std_logic;

      -- DMA DOWN Interface (from host system to user application) ------------
      -- Output data
      DMA_DOWN_DATA    : out std_logic_vector(255 downto 0);
      -- Header for output data (valid when SOP is valid)
      DMA_DOWN_HDR     : out std_logic_vector(31 downto 0);
      -- Start of transaction (valid when DMA_UP_SRC_RDY=DMA_UP_DST_RDY='1')
      DMA_DOWN_SOP     : out std_logic;
      -- End of transaction (valid when DMA_UP_SRC_RDY = DMA_UP_DST_RDY = '1')
      DMA_DOWN_EOP     : out std_logic;
      -- Source is ready to transmit data
      DMA_DOWN_SRC_RDY : out std_logic;
      -- Destination is ready to receive data
      DMA_DOWN_DST_RDY : in  std_logic;

      -- DMA-like interface from rc_int component -----------------------------
      -- Transaction data
      DMA_DATA         : in  std_logic_vector(255 downto 0);
      ----- Parts of transaction header (valid when SOP is valid) -----
      -- Number of dwords in the transaction
      DMA_HDR_DWORDS   : in  std_logic_vector(10 downto 0);
      -- Start of transaction (valid when DMA_SRC_RDY = DMA_DST_RDY = 1)
      DMA_SOP          : in  std_logic;
      -- End of transaction (valid when DMA_SRC_RDY = DMA_DST_RDY = 1)
      DMA_EOP          : in  std_logic;
      -- Source is ready to transmit data
      DMA_SRC_RDY      : in  std_logic;
      -- Destination is ready to receive data
      DMA_DST_RDY      : out std_logic;
      -- PCIe transaction tag (valid when SOP is valid)
      PCIE_TAG         : in  std_logic_vector(4 downto 0);
      -- Release command for PCIe tag mapping in tag_manager component
      -- (valid when SOP is valid)
      PCIE_TAG_RELEASE : in  std_logic;
      
      -- Interface to tag_manager component -----------------------------------
      -- PCIe tag of completion transaction
      TAG              : out std_logic_vector(4 downto 0);
      -- Release command for current tag mapping
      -- (specified by value on the TAG port)
      TAG_RELEASE      : out std_logic;
      -- DMA tag corresponding to PCIe tag
      DMA_DOWN_HDR_TAG : in  std_logic_vector(7 downto 0);
      -- DMA component ID corresponding to PCIe tag
      DMA_DOWN_HDR_ID  : in  std_logic_vector(7 downto 0)
   );
end entity dma_down_int;
