-- tag_manager_ent.vhd: Tag manager component - entity
-- Copyright (C) 2013 CESNET
-- Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity tag_manager is
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK              : in  std_logic;
      -- Synchronous reset
      RESET            : in  std_logic;

      -- Interface to dma_up_int component ------------------------------------
      -- Offered free tag
      -- (offer is accepted when TAG_OFFER_VLD = TAG_OFFER_ACCEPT = '1')
      TAG_OFFER        : out std_logic_vector(4 downto 0);
      -- Offered tag validity (no tag is available when TAG_OFFER_VLD = '0')
      TAG_OFFER_VLD    : out std_logic;
      -- Acceptation of offered tag
      TAG_OFFER_ACCEPT : in  std_logic;
      -- DMA tag, which is mapped on the accepted PCIe tag
      DMA_UP_HDR_TAG   : in  std_logic_vector(7 downto 0);
      -- DMA component ID, which is mapped on the accepted PCIe tag
      DMA_UP_HDR_ID    : in  std_logic_vector(7 downto 0);

      -- Interface to dma_down_int component ----------------------------------
      -- PCIe tag of completion transaction
      TAG              : in  std_logic_vector(4 downto 0);
      -- Release command for current tag mapping
      -- (specified by value on the TAG port)
      TAG_RELEASE      : in std_logic;
      -- DMA tag corresponding to PCIe tag
      DMA_DOWN_HDR_TAG : out std_logic_vector(7 downto 0);
      -- DMA component ID corresponding to PCIe tag
      DMA_DOWN_HDR_ID  : out std_logic_vector(7 downto 0)
   );
end entity tag_manager;
