//-----------------------------------------------------------------------------
//
// (c) Copyright 2012-2012 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
//-----------------------------------------------------------------------------
//
// Project    : Virtex-7 FPGA Gen3 Integrated Block for PCI Express
// File       : pcie3_7x_v3_0_pcie_7vx.v
// Version    : 3.0
//----------------------------------------------------------------------------//
// Project      : Virtex-7 FPGA Gen3 Integrated Block for PCI Express         //
// Filename     : pcie3_7x_v3_0_pcie_3_0_7vx.v                                              //
// Description  : Instantiates the GEN3 PCI Express Integrated Block. Also    //
//                connects up the GEN3 PCIe Integrated Block to the BRAM      //
//                receieve and replay buffers                                 //
//                                                                            //
//---------- PIPE Wrapper Hierarchy ------------------------------------------//
//  pcie_7vx.v                                                                //
//      PCIE_3_0                                                              //
//      pcie_bram_7vx.v                                                       //
//          pcie_bram_7vx_rep.v                                               //
//              pcie_bram_7vx_rep_8k.v                                        //
//          pcie_bram_7vx_req.v                                               //
//              pcie_bram_7vx_8k.v                                            //
//          pcie_bram_7vx_cpl.v                                               //
//              pcie_bram_7vx_8k.v                                            //
//              pcie_bram_7vx_16k.v                                           //
//----------------------------------------------------------------------------//

`timescale 1ps/1ps

module pcie3_7x_v3_0_pcie_7vx #(
  parameter         ARI_CAP_ENABLE = "FALSE",
  parameter         AXISTEN_IF_CC_ALIGNMENT_MODE = "FALSE",
  parameter         AXISTEN_IF_CC_PARITY_CHK = "TRUE",
  parameter         AXISTEN_IF_CQ_ALIGNMENT_MODE = "FALSE",
  parameter         AXISTEN_IF_ENABLE_CLIENT_TAG = "FALSE",
  parameter [17:0]  AXISTEN_IF_ENABLE_MSG_ROUTE = 18'h00000,
  parameter         AXISTEN_IF_ENABLE_RX_MSG_INTFC = "FALSE",
  parameter         AXISTEN_IF_RC_ALIGNMENT_MODE = "FALSE",
  parameter         AXISTEN_IF_RC_STRADDLE = "FALSE",
  parameter         AXISTEN_IF_RQ_ALIGNMENT_MODE = "FALSE",
  parameter         AXISTEN_IF_RQ_PARITY_CHK = "TRUE",
  parameter  [1:0]  AXISTEN_IF_WIDTH = 2'h2,
  parameter         CRM_CORE_CLK_FREQ_500 = "TRUE",
  parameter  [1:0]  CRM_USER_CLK_FREQ = 2'h2,
  parameter  [7:0]  DNSTREAM_LINK_NUM = 8'h00,
  parameter  [1:0]  GEN3_PCS_AUTO_REALIGN = 2'h1,
  parameter         GEN3_PCS_RX_ELECIDLE_INTERNAL = "TRUE",
  parameter  [8:0]  LL_ACK_TIMEOUT = 9'h000,
  parameter         LL_ACK_TIMEOUT_EN = "FALSE",
  parameter integer LL_ACK_TIMEOUT_FUNC = 0,
  parameter [15:0]  LL_CPL_FC_UPDATE_TIMER = 16'h0000,
  parameter         LL_CPL_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0]  LL_FC_UPDATE_TIMER = 16'h0000,
  parameter         LL_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0]  LL_NP_FC_UPDATE_TIMER = 16'h0000,
  parameter         LL_NP_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0]  LL_P_FC_UPDATE_TIMER = 16'h0000,
  parameter         LL_P_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter  [8:0]  LL_REPLAY_TIMEOUT = 9'h000,
  parameter         LL_REPLAY_TIMEOUT_EN = "FALSE",
  parameter integer LL_REPLAY_TIMEOUT_FUNC = 0,
  parameter  [9:0]  LTR_TX_MESSAGE_MINIMUM_INTERVAL = 10'h0FA,
  parameter         LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE = "FALSE",
  parameter         LTR_TX_MESSAGE_ON_LTR_ENABLE = "FALSE",
  parameter         PF0_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter         PF0_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0]  PF0_AER_CAP_NEXTPTR = 12'h000,
  parameter [11:0]  PF0_ARI_CAP_NEXTPTR = 12'h000,
  parameter  [7:0]  PF0_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter  [3:0]  PF0_ARI_CAP_VER = 4'h1,
  parameter  [4:0]  PF0_BAR0_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_BAR0_CONTROL = 3'h4,
  parameter  [4:0]  PF0_BAR1_APERTURE_SIZE = 5'h00,
  parameter  [2:0]  PF0_BAR1_CONTROL = 3'h0,
  parameter  [4:0]  PF0_BAR2_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_BAR2_CONTROL = 3'h4,
  parameter  [4:0]  PF0_BAR3_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_BAR3_CONTROL = 3'h0,
  parameter  [4:0]  PF0_BAR4_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_BAR4_CONTROL = 3'h4,
  parameter  [4:0]  PF0_BAR5_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_BAR5_CONTROL = 3'h0,
  parameter  [7:0]  PF0_BIST_REGISTER = 8'h00,
  parameter  [7:0]  PF0_CAPABILITY_POINTER = 8'h50,
  parameter [23:0]  PF0_CLASS_CODE = 24'h000000,
  parameter [15:0]  PF0_DEVICE_ID = 16'h0000,
  parameter         PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter         PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter         PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter         PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE = "TRUE",
  parameter         PF0_DEV_CAP2_LTR_SUPPORT = "TRUE",
  parameter  [1:0]  PF0_DEV_CAP2_OBFF_SUPPORT = 2'h0,
  parameter         PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT = "FALSE",
  parameter integer PF0_DEV_CAP_ENDPOINT_L0S_LATENCY = 0,
  parameter integer PF0_DEV_CAP_ENDPOINT_L1_LATENCY = 0,
  parameter         PF0_DEV_CAP_EXT_TAG_SUPPORTED = "TRUE",
  parameter         PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE = "TRUE",
  parameter  [2:0]  PF0_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [11:0]  PF0_DPA_CAP_NEXTPTR = 12'h000,
  parameter [11:0]  VF0_ARI_CAP_NEXTPTR = 12'h000,
  parameter [11:0]  VF1_ARI_CAP_NEXTPTR = 12'h000,
  parameter [11:0]  VF2_ARI_CAP_NEXTPTR = 12'h000,
  parameter [11:0]  VF3_ARI_CAP_NEXTPTR = 12'h000,
  parameter [11:0]  VF4_ARI_CAP_NEXTPTR = 12'h000,
  parameter [11:0]  VF5_ARI_CAP_NEXTPTR = 12'h000,
  parameter VF0_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF0_TPHR_CAP_ENABLE = "FALSE",
  parameter VF0_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF0_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF0_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF0_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF0_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF0_TPHR_CAP_VER = 4'h1,
  parameter VF1_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF1_TPHR_CAP_ENABLE = "FALSE",
  parameter VF1_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF1_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF1_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF1_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF1_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF1_TPHR_CAP_VER = 4'h1,
  parameter VF2_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF2_TPHR_CAP_ENABLE = "FALSE",
  parameter VF2_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF2_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF2_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF2_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF2_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF2_TPHR_CAP_VER = 4'h1,
  parameter VF3_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF3_TPHR_CAP_ENABLE = "FALSE",
  parameter VF3_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF3_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF3_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF3_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF3_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF3_TPHR_CAP_VER = 4'h1,
  parameter VF4_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF4_TPHR_CAP_ENABLE = "FALSE",
  parameter VF4_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF4_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF4_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF4_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF4_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF4_TPHR_CAP_VER = 4'h1,
  parameter VF5_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF5_TPHR_CAP_ENABLE = "FALSE",
  parameter VF5_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF5_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF5_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF5_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF5_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF5_TPHR_CAP_VER = 4'h1,
  parameter  [4:0]  PF0_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter         PF0_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter  [7:0]  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter  [7:0]  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter  [7:0]  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter  [7:0]  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter  [7:0]  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter  [7:0]  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter  [7:0]  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter  [7:0]  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter  [3:0]  PF0_DPA_CAP_VER = 4'h1,
  parameter [11:0]  PF0_DSN_CAP_NEXTPTR = 12'h10C,
  parameter  [4:0]  PF0_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter         PF0_EXPANSION_ROM_ENABLE = "FALSE",
  parameter  [7:0]  PF0_INTERRUPT_LINE = 8'h00,
  parameter  [2:0]  PF0_INTERRUPT_PIN = 3'h1,
  parameter integer PF0_LINK_CAP_ASPM_SUPPORT = 0,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3 = 7,
  parameter         PF0_LINK_STATUS_SLOT_CLOCK_CONFIG = "TRUE",
  parameter  [9:0]  PF0_LTR_CAP_MAX_NOSNOOP_LAT = 10'h000,
  parameter  [9:0]  PF0_LTR_CAP_MAX_SNOOP_LAT = 10'h000,
  parameter [11:0]  PF0_LTR_CAP_NEXTPTR = 12'h000,
  parameter  [3:0]  PF0_LTR_CAP_VER = 4'h1,
  parameter  [7:0]  PF0_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF0_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0]  PF0_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF0_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0]  PF0_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0]  PF0_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter integer PF0_MSI_CAP_MULTIMSGCAP = 0,
  parameter  [7:0]  PF0_MSI_CAP_NEXTPTR = 8'h00,
  parameter [11:0]  PF0_PB_CAP_NEXTPTR = 12'h000,
  parameter         PF0_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter  [3:0]  PF0_PB_CAP_VER = 4'h1,
  parameter  [7:0]  PF0_PM_CAP_ID = 8'h01,
  parameter  [7:0]  PF0_PM_CAP_NEXTPTR = 8'h00,
  parameter         PF0_PM_CAP_PMESUPPORT_D0 = "TRUE",
  parameter         PF0_PM_CAP_PMESUPPORT_D1 = "TRUE",
  parameter         PF0_PM_CAP_PMESUPPORT_D3HOT = "TRUE",
  parameter         PF0_PM_CAP_SUPP_D1_STATE = "TRUE",
  parameter  [2:0]  PF0_PM_CAP_VER_ID = 3'h3,
  parameter         PF0_PM_CSR_NOSOFTRESET = "TRUE",
  parameter         PF0_RBAR_CAP_ENABLE = "FALSE",
  parameter  [2:0]  PF0_RBAR_CAP_INDEX0 = 3'h0,
  parameter  [2:0]  PF0_RBAR_CAP_INDEX1 = 3'h0,
  parameter  [2:0]  PF0_RBAR_CAP_INDEX2 = 3'h0,
  parameter [11:0]  PF0_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0]  PF0_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0]  PF0_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0]  PF0_RBAR_CAP_SIZE2 = 20'h00000,
  parameter  [3:0]  PF0_RBAR_CAP_VER = 4'h1,
  parameter  [2:0]  PF0_RBAR_NUM = 3'h1,
  parameter  [7:0]  PF0_REVISION_ID = 8'h00,
  parameter  [4:0]  PF0_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_SRIOV_BAR0_CONTROL = 3'h4,
  parameter  [4:0]  PF0_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter  [2:0]  PF0_SRIOV_BAR1_CONTROL = 3'h0,
  parameter  [4:0]  PF0_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_SRIOV_BAR2_CONTROL = 3'h4,
  parameter  [4:0]  PF0_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_SRIOV_BAR3_CONTROL = 3'h0,
  parameter  [4:0]  PF0_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_SRIOV_BAR4_CONTROL = 3'h4,
  parameter  [4:0]  PF0_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF0_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0]  PF0_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0]  PF0_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0]  PF0_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter  [3:0]  PF0_SRIOV_CAP_VER = 4'h1,
  parameter [15:0]  PF0_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0]  PF0_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0]  PF0_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0]  PF0_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0]  PF0_SUBSYSTEM_ID = 16'h0000,
  parameter         PF0_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter         PF0_TPHR_CAP_ENABLE = "FALSE",
  parameter         PF0_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0]  PF0_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  [2:0]  PF0_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  [1:0]  PF0_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0]  PF0_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  [3:0]  PF0_TPHR_CAP_VER = 4'h1,
  parameter [11:0]  PF0_VC_CAP_NEXTPTR = 12'h000,
  parameter  [3:0]  PF0_VC_CAP_VER = 4'h1,
  parameter         PF1_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter         PF1_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0]  PF1_AER_CAP_NEXTPTR = 12'h000,
  parameter [11:0]  PF1_ARI_CAP_NEXTPTR = 12'h000,
  parameter  [7:0]  PF1_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter  [4:0]  PF1_BAR0_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_BAR0_CONTROL = 3'h4,
  parameter  [4:0]  PF1_BAR1_APERTURE_SIZE = 5'h00,
  parameter  [2:0]  PF1_BAR1_CONTROL = 3'h0,
  parameter  [4:0]  PF1_BAR2_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_BAR2_CONTROL = 3'h4,
  parameter  [4:0]  PF1_BAR3_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_BAR3_CONTROL = 3'h0,
  parameter  [4:0]  PF1_BAR4_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_BAR4_CONTROL = 3'h4,
  parameter  [4:0]  PF1_BAR5_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_BAR5_CONTROL = 3'h0,
  parameter  [7:0]  PF1_BIST_REGISTER = 8'h00,
  parameter  [7:0]  PF1_CAPABILITY_POINTER = 8'h50,
  parameter [23:0]  PF1_CLASS_CODE = 24'h000000,
  parameter [15:0]  PF1_DEVICE_ID = 16'h0000,
  parameter  [2:0]  PF1_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [11:0]  PF1_DPA_CAP_NEXTPTR = 12'h000,
  parameter  [4:0]  PF1_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter         PF1_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter  [7:0]  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter  [7:0]  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter  [7:0]  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter  [7:0]  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter  [7:0]  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter  [7:0]  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter  [7:0]  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter  [7:0]  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter  [3:0]  PF1_DPA_CAP_VER = 4'h1,
  parameter [11:0]  PF1_DSN_CAP_NEXTPTR = 12'h10C,
  parameter  [4:0]  PF1_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter         PF1_EXPANSION_ROM_ENABLE = "FALSE",
  parameter  [7:0]  PF1_INTERRUPT_LINE = 8'h00,
  parameter  [2:0]  PF1_INTERRUPT_PIN = 3'h1,
  parameter  [7:0]  PF1_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF1_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0]  PF1_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF1_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0]  PF1_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0]  PF1_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter integer PF1_MSI_CAP_MULTIMSGCAP = 0,
  parameter  [7:0]  PF1_MSI_CAP_NEXTPTR = 8'h00,
  parameter [11:0]  PF1_PB_CAP_NEXTPTR = 12'h000,
  parameter         PF1_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter  [3:0]  PF1_PB_CAP_VER = 4'h1,
  parameter  [7:0]  PF1_PM_CAP_ID = 8'h01,
  parameter  [7:0]  PF1_PM_CAP_NEXTPTR = 8'h00,
  parameter  [2:0]  PF1_PM_CAP_VER_ID = 3'h3,
  parameter         PF1_RBAR_CAP_ENABLE = "FALSE",
  parameter  [2:0]  PF1_RBAR_CAP_INDEX0 = 3'h0,
  parameter  [2:0]  PF1_RBAR_CAP_INDEX1 = 3'h0,
  parameter  [2:0]  PF1_RBAR_CAP_INDEX2 = 3'h0,
  parameter [11:0]  PF1_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0]  PF1_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0]  PF1_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0]  PF1_RBAR_CAP_SIZE2 = 20'h00000,
  parameter  [3:0]  PF1_RBAR_CAP_VER = 4'h1,
  parameter  [2:0]  PF1_RBAR_NUM = 3'h1,
  parameter  [7:0]  PF1_REVISION_ID = 8'h00,
  parameter  [4:0]  PF1_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_SRIOV_BAR0_CONTROL = 3'h4,
  parameter  [4:0]  PF1_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter  [2:0]  PF1_SRIOV_BAR1_CONTROL = 3'h0,
  parameter  [4:0]  PF1_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_SRIOV_BAR2_CONTROL = 3'h4,
  parameter  [4:0]  PF1_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_SRIOV_BAR3_CONTROL = 3'h0,
  parameter  [4:0]  PF1_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_SRIOV_BAR4_CONTROL = 3'h4,
  parameter  [4:0]  PF1_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter  [2:0]  PF1_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0]  PF1_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0]  PF1_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0]  PF1_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter  [3:0]  PF1_SRIOV_CAP_VER = 4'h1,
  parameter [15:0]  PF1_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0]  PF1_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0]  PF1_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0]  PF1_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0]  PF1_SUBSYSTEM_ID = 16'h0000,
  parameter         PF1_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter         PF1_TPHR_CAP_ENABLE = "FALSE",
  parameter         PF1_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0]  PF1_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  [2:0]  PF1_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  [1:0]  PF1_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0]  PF1_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  [3:0]  PF1_TPHR_CAP_VER = 4'h1,
  parameter         PL_DISABLE_EI_INFER_IN_L0 = "FALSE",
  parameter         PL_DISABLE_GEN3_DC_BALANCE = "FALSE",
  parameter         PL_DISABLE_SCRAMBLING = "FALSE",
  parameter         PL_DISABLE_UPCONFIG_CAPABLE = "FALSE",
  parameter         PL_EQ_ADAPT_DISABLE_COEFF_CHECK = "FALSE",
  parameter         PL_EQ_ADAPT_DISABLE_PRESET_CHECK = "FALSE",
  parameter  [4:0]  PL_EQ_ADAPT_ITER_COUNT = 5'h02,
  parameter  [1:0]  PL_EQ_ADAPT_REJECT_RETRY_COUNT = 2'h1,
  parameter         PL_EQ_BYPASS_PHASE23 = "FALSE",
  parameter         PL_EQ_SHORT_ADAPT_PHASE = "FALSE",
  parameter [15:0]  PL_LANE0_EQ_CONTROL = 16'h3F00,
  parameter [15:0]  PL_LANE1_EQ_CONTROL = 16'h3F00,
  parameter [15:0]  PL_LANE2_EQ_CONTROL = 16'h3F00,
  parameter [15:0]  PL_LANE3_EQ_CONTROL = 16'h3F00,
  parameter [15:0]  PL_LANE4_EQ_CONTROL = 16'h3F00,
  parameter [15:0]  PL_LANE5_EQ_CONTROL = 16'h3F00,
  parameter [15:0]  PL_LANE6_EQ_CONTROL = 16'h3F00,
  parameter [15:0]  PL_LANE7_EQ_CONTROL = 16'h3F00,
  parameter  [2:0]  PL_LINK_CAP_MAX_LINK_SPEED = 3'h4,
  parameter  [3:0]  PL_LINK_CAP_MAX_LINK_WIDTH = 4'h8,
  parameter integer PL_N_FTS_COMCLK_GEN1 = 255,
  parameter integer PL_N_FTS_COMCLK_GEN2 = 255,
  parameter integer PL_N_FTS_COMCLK_GEN3 = 255,
  parameter integer PL_N_FTS_GEN1 = 255,
  parameter integer PL_N_FTS_GEN2 = 255,
  parameter integer PL_N_FTS_GEN3 = 255,
  parameter         PL_SIM_FAST_LINK_TRAINING = "FALSE",
  parameter         PL_UPSTREAM_FACING = "TRUE",
  parameter [15:0]  PM_ASPML0S_TIMEOUT = 16'h05DC,
  parameter [19:0]  PM_ASPML1_ENTRY_DELAY = 20'h00000,
  parameter         PM_ENABLE_SLOT_POWER_CAPTURE = "TRUE",
  parameter [31:0]  PM_L1_REENTRY_DELAY = 32'h00000000,
  parameter [19:0]  PM_PME_SERVICE_TIMEOUT_DELAY = 20'h186A0,
  parameter [15:0]  PM_PME_TURNOFF_ACK_DELAY = 16'h0064,
  parameter         SIM_VERSION = "1.0",
  parameter integer SPARE_BIT0 = 0,
  parameter integer SPARE_BIT1 = 0,
  parameter integer SPARE_BIT2 = 0,
  parameter integer SPARE_BIT3 = 0,
  parameter integer SPARE_BIT4 = 0,
  parameter integer SPARE_BIT5 = 0,
  parameter integer SPARE_BIT6 = 0,
  parameter integer SPARE_BIT7 = 0,
  parameter integer SPARE_BIT8 = 0,
  parameter  [7:0]  SPARE_BYTE0 = 8'h00,
  parameter  [7:0]  SPARE_BYTE1 = 8'h00,
  parameter  [7:0]  SPARE_BYTE2 = 8'h00,
  parameter  [7:0]  SPARE_BYTE3 = 8'h00,
  parameter [31:0]  SPARE_WORD0 = 32'h00000000,
  parameter [31:0]  SPARE_WORD1 = 32'h00000000,
  parameter [31:0]  SPARE_WORD2 = 32'h00000000,
  parameter [31:0]  SPARE_WORD3 = 32'h00000000,
  parameter         SRIOV_CAP_ENABLE = "FALSE",
  parameter [23:0]  TL_COMPL_TIMEOUT_REG0 = 24'hBEBC20,
  parameter [27:0]  TL_COMPL_TIMEOUT_REG1 = 28'h0000000,
  parameter [11:0]  TL_CREDITS_CD = 12'h3E0,
  parameter  [7:0]  TL_CREDITS_CH = 8'h20,
  parameter [11:0]  TL_CREDITS_NPD = 12'h028,
  parameter  [7:0]  TL_CREDITS_NPH = 8'h20,
  parameter [11:0]  TL_CREDITS_PD = 12'h198,
  parameter  [7:0]  TL_CREDITS_PH = 8'h20,
  parameter         TL_ENABLE_MESSAGE_RID_CHECK_ENABLE = "TRUE",
  parameter         TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE = "FALSE",
  parameter         TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE = "FALSE",
  parameter         TL_LEGACY_MODE_ENABLE = "FALSE",
  parameter         TL_PF_ENABLE_REG = "FALSE",
  parameter         TL_TAG_MGMT_ENABLE = "TRUE",
  parameter  [7:0]  VF0_CAPABILITY_POINTER = 8'h50,
  parameter integer VF0_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0]  VF0_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF0_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0]  VF0_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0]  VF0_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter integer VF0_MSI_CAP_MULTIMSGCAP = 0,
  parameter  [7:0]  VF0_PM_CAP_ID = 8'h01,
  parameter  [7:0]  VF0_PM_CAP_NEXTPTR = 8'h00,
  parameter  [2:0]  VF0_PM_CAP_VER_ID = 3'h3,
  parameter integer VF1_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0]  VF1_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF1_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0]  VF1_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0]  VF1_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter integer VF1_MSI_CAP_MULTIMSGCAP = 0,
  parameter  [7:0]  VF1_PM_CAP_ID = 8'h01,
  parameter  [7:0]  VF1_PM_CAP_NEXTPTR = 8'h00,
  parameter  [2:0]  VF1_PM_CAP_VER_ID = 3'h3,
  parameter integer VF2_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0]  VF2_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF2_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0]  VF2_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0]  VF2_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter integer VF2_MSI_CAP_MULTIMSGCAP = 0,
  parameter  [7:0]  VF2_PM_CAP_ID = 8'h01,
  parameter  [7:0]  VF2_PM_CAP_NEXTPTR = 8'h00,
  parameter  [2:0]  VF2_PM_CAP_VER_ID = 3'h3,
  parameter integer VF3_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0]  VF3_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF3_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0]  VF3_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0]  VF3_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter integer VF3_MSI_CAP_MULTIMSGCAP = 0,
  parameter  [7:0]  VF3_PM_CAP_ID = 8'h01,
  parameter  [7:0]  VF3_PM_CAP_NEXTPTR = 8'h00,
  parameter  [2:0]  VF3_PM_CAP_VER_ID = 3'h3,
  parameter integer VF4_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0]  VF4_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF4_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0]  VF4_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0]  VF4_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter integer VF4_MSI_CAP_MULTIMSGCAP = 0,
  parameter  [7:0]  VF4_PM_CAP_ID = 8'h01,
  parameter  [7:0]  VF4_PM_CAP_NEXTPTR = 8'h00,
  parameter  [2:0]  VF4_PM_CAP_VER_ID = 3'h3,
  parameter integer VF5_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0]  VF5_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF5_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0]  VF5_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0]  VF5_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter integer VF5_MSI_CAP_MULTIMSGCAP = 0,
  parameter  [7:0]  VF5_PM_CAP_ID = 8'h01,
  parameter  [7:0]  VF5_PM_CAP_NEXTPTR = 8'h00,
  parameter  [2:0]  VF5_PM_CAP_VER_ID = 3'h3,
  parameter         IMPL_TARGET = "HARD",
  parameter         NO_DECODE_LOGIC = "TRUE",
  parameter         INTERFACE_SPEED = "500 MHZ",
  parameter         COMPLETION_SPACE = "16KB"
) (
  output         CFGERRCOROUT,
  output         CFGERRFATALOUT,
  output         CFGERRNONFATALOUT,
  output         CFGEXTREADRECEIVED,
  output         CFGEXTWRITERECEIVED,
  output         CFGHOTRESETOUT,
  output         CFGINPUTUPDATEDONE,
  output         CFGINTERRUPTAOUTPUT,
  output         CFGINTERRUPTBOUTPUT,
  output         CFGINTERRUPTCOUTPUT,
  output         CFGINTERRUPTDOUTPUT,
  output         CFGINTERRUPTMSIFAIL,
  output         CFGINTERRUPTMSIMASKUPDATE,
  output         CFGINTERRUPTMSISENT,
  output         CFGINTERRUPTMSIXFAIL,
  output         CFGINTERRUPTMSIXSENT,
  output         CFGINTERRUPTSENT,
  output         CFGLOCALERROR,
  output         CFGLTRENABLE,
  output         CFGMCUPDATEDONE,
  output         CFGMGMTREADWRITEDONE,
  output         CFGMSGRECEIVED,
  output         CFGMSGTRANSMITDONE,
  output         CFGPERFUNCTIONUPDATEDONE,
  output         CFGPHYLINKDOWN,
  output         CFGPLSTATUSCHANGE,
  output         CFGPOWERSTATECHANGEINTERRUPT,
  output         CFGTPHSTTREADENABLE,
  output         CFGTPHSTTWRITEENABLE,
  output         DRPRDY,
  output         MAXISCQTLAST,
  output         MAXISCQTVALID,
  output         MAXISRCTLAST,
  output         MAXISRCTVALID,
  output         PCIERQSEQNUMVLD,
  output         PCIERQTAGVLD,
  output         PIPERX0POLARITY,
  output         PIPERX1POLARITY,
  output         PIPERX2POLARITY,
  output         PIPERX3POLARITY,
  output         PIPERX4POLARITY,
  output         PIPERX5POLARITY,
  output         PIPERX6POLARITY,
  output         PIPERX7POLARITY,
  output         PIPETX0COMPLIANCE,
  output         PIPETX0DATAVALID,
  output         PIPETX0ELECIDLE,
  output         PIPETX0STARTBLOCK,
  output         PIPETX1COMPLIANCE,
  output         PIPETX1DATAVALID,
  output         PIPETX1ELECIDLE,
  output         PIPETX1STARTBLOCK,
  output         PIPETX2COMPLIANCE,
  output         PIPETX2DATAVALID,
  output         PIPETX2ELECIDLE,
  output         PIPETX2STARTBLOCK,
  output         PIPETX3COMPLIANCE,
  output         PIPETX3DATAVALID,
  output         PIPETX3ELECIDLE,
  output         PIPETX3STARTBLOCK,
  output         PIPETX4COMPLIANCE,
  output         PIPETX4DATAVALID,
  output         PIPETX4ELECIDLE,
  output         PIPETX4STARTBLOCK,
  output         PIPETX5COMPLIANCE,
  output         PIPETX5DATAVALID,
  output         PIPETX5ELECIDLE,
  output         PIPETX5STARTBLOCK,
  output         PIPETX6COMPLIANCE,
  output         PIPETX6DATAVALID,
  output         PIPETX6ELECIDLE,
  output         PIPETX6STARTBLOCK,
  output         PIPETX7COMPLIANCE,
  output         PIPETX7DATAVALID,
  output         PIPETX7ELECIDLE,
  output         PIPETX7STARTBLOCK,
  output         PIPETXDEEMPH,
  output         PIPETXRCVRDET,
  output         PIPETXRESET,
  output         PIPETXSWING,
  output         PLEQINPROGRESS,
  output  [11:0] CFGFCCPLD,
  output  [11:0] CFGFCNPD,
  output  [11:0] CFGFCPD,
  output  [11:0] CFGVFSTATUS,
  output  [15:0] CFGPERFUNCSTATUSDATA,
  output  [15:0] DBGDATAOUT,
  output  [15:0] DRPDO,
  output  [17:0] CFGVFPOWERSTATE,
  output  [17:0] CFGVFTPHSTMODE,
  output   [1:0] CFGDPASUBSTATECHANGE,
  output   [1:0] CFGFLRINPROCESS,
  output   [1:0] CFGINTERRUPTMSIENABLE,
  output   [1:0] CFGINTERRUPTMSIXENABLE,
  output   [1:0] CFGINTERRUPTMSIXMASK,
  output   [1:0] CFGLINKPOWERSTATE,
  output   [1:0] CFGOBFFENABLE,
  output   [1:0] CFGPHYLINKSTATUS,
  output   [1:0] CFGRCBSTATUS,
  output   [1:0] CFGTPHREQUESTERENABLE,
  output   [1:0] PCIETFCNPDAV,
  output   [1:0] PCIETFCNPHAV,
  output   [1:0] PIPERX0EQCONTROL,
  output   [1:0] PIPERX1EQCONTROL,
  output   [1:0] PIPERX2EQCONTROL,
  output   [1:0] PIPERX3EQCONTROL,
  output   [1:0] PIPERX4EQCONTROL,
  output   [1:0] PIPERX5EQCONTROL,
  output   [1:0] PIPERX6EQCONTROL,
  output   [1:0] PIPERX7EQCONTROL,
  output   [1:0] PIPETX0CHARISK,
  output   [1:0] PIPETX0EQCONTROL,
  output   [1:0] PIPETX0POWERDOWN,
  output   [1:0] PIPETX0SYNCHEADER,
  output   [1:0] PIPETX1CHARISK,
  output   [1:0] PIPETX1EQCONTROL,
  output   [1:0] PIPETX1POWERDOWN,
  output   [1:0] PIPETX1SYNCHEADER,
  output   [1:0] PIPETX2CHARISK,
  output   [1:0] PIPETX2EQCONTROL,
  output   [1:0] PIPETX2POWERDOWN,
  output   [1:0] PIPETX2SYNCHEADER,
  output   [1:0] PIPETX3CHARISK,
  output   [1:0] PIPETX3EQCONTROL,
  output   [1:0] PIPETX3POWERDOWN,
  output   [1:0] PIPETX3SYNCHEADER,
  output   [1:0] PIPETX4CHARISK,
  output   [1:0] PIPETX4EQCONTROL,
  output   [1:0] PIPETX4POWERDOWN,
  output   [1:0] PIPETX4SYNCHEADER,
  output   [1:0] PIPETX5CHARISK,
  output   [1:0] PIPETX5EQCONTROL,
  output   [1:0] PIPETX5POWERDOWN,
  output   [1:0] PIPETX5SYNCHEADER,
  output   [1:0] PIPETX6CHARISK,
  output   [1:0] PIPETX6EQCONTROL,
  output   [1:0] PIPETX6POWERDOWN,
  output   [1:0] PIPETX6SYNCHEADER,
  output   [1:0] PIPETX7CHARISK,
  output   [1:0] PIPETX7EQCONTROL,
  output   [1:0] PIPETX7POWERDOWN,
  output   [1:0] PIPETX7SYNCHEADER,
  output   [1:0] PIPETXRATE,
  output   [1:0] PLEQPHASE,
  output [255:0] MAXISCQTDATA,
  output [255:0] MAXISRCTDATA,
  output   [2:0] CFGCURRENTSPEED,
  output   [2:0] CFGMAXPAYLOAD,
  output   [2:0] CFGMAXREADREQ,
  output   [2:0] CFGTPHFUNCTIONNUM,
  output   [2:0] PIPERX0EQPRESET,
  output   [2:0] PIPERX1EQPRESET,
  output   [2:0] PIPERX2EQPRESET,
  output   [2:0] PIPERX3EQPRESET,
  output   [2:0] PIPERX4EQPRESET,
  output   [2:0] PIPERX5EQPRESET,
  output   [2:0] PIPERX6EQPRESET,
  output   [2:0] PIPERX7EQPRESET,
  output   [2:0] PIPETXMARGIN,
  output  [31:0] CFGEXTWRITEDATA,
  output  [31:0] CFGINTERRUPTMSIDATA,
  output  [31:0] CFGMGMTREADDATA,
  output  [31:0] CFGTPHSTTWRITEDATA,
  output  [31:0] PIPETX0DATA,
  output  [31:0] PIPETX1DATA,
  output  [31:0] PIPETX2DATA,
  output  [31:0] PIPETX3DATA,
  output  [31:0] PIPETX4DATA,
  output  [31:0] PIPETX5DATA,
  output  [31:0] PIPETX6DATA,
  output  [31:0] PIPETX7DATA,
  output   [3:0] CFGEXTWRITEBYTEENABLE,
  output   [3:0] CFGNEGOTIATEDWIDTH,
  output   [3:0] CFGTPHSTTWRITEBYTEVALID,
  output   [3:0] PCIERQSEQNUM,
  output   [3:0] PIPERX0EQLPTXPRESET,
  output   [3:0] PIPERX1EQLPTXPRESET,
  output   [3:0] PIPERX2EQLPTXPRESET,
  output   [3:0] PIPERX3EQLPTXPRESET,
  output   [3:0] PIPERX4EQLPTXPRESET,
  output   [3:0] PIPERX5EQLPTXPRESET,
  output   [3:0] PIPERX6EQLPTXPRESET,
  output   [3:0] PIPERX7EQLPTXPRESET,
  output   [3:0] PIPETX0EQPRESET,
  output   [3:0] PIPETX1EQPRESET,
  output   [3:0] PIPETX2EQPRESET,
  output   [3:0] PIPETX3EQPRESET,
  output   [3:0] PIPETX4EQPRESET,
  output   [3:0] PIPETX5EQPRESET,
  output   [3:0] PIPETX6EQPRESET,
  output   [3:0] PIPETX7EQPRESET,
  output   [3:0] SAXISCCTREADY,
  output   [3:0] SAXISRQTREADY,
  output   [4:0] CFGMSGRECEIVEDTYPE,
  output   [4:0] CFGTPHSTTADDRESS,
  output   [5:0] CFGFUNCTIONPOWERSTATE,
  output   [5:0] CFGINTERRUPTMSIMMENABLE,
  output   [5:0] CFGINTERRUPTMSIVFENABLE,
  output   [5:0] CFGINTERRUPTMSIXVFENABLE,
  output   [5:0] CFGINTERRUPTMSIXVFMASK,
  output   [5:0] CFGLTSSMSTATE,
  output   [5:0] CFGTPHSTMODE,
  output   [5:0] CFGVFFLRINPROCESS,
  output   [5:0] CFGVFTPHREQUESTERENABLE,
  output   [5:0] PCIECQNPREQCOUNT,
  output   [5:0] PCIERQTAG,
  output   [5:0] PIPERX0EQLPLFFS,
  output   [5:0] PIPERX1EQLPLFFS,
  output   [5:0] PIPERX2EQLPLFFS,
  output   [5:0] PIPERX3EQLPLFFS,
  output   [5:0] PIPERX4EQLPLFFS,
  output   [5:0] PIPERX5EQLPLFFS,
  output   [5:0] PIPERX6EQLPLFFS,
  output   [5:0] PIPERX7EQLPLFFS,
  output   [5:0] PIPETX0EQDEEMPH,
  output   [5:0] PIPETX1EQDEEMPH,
  output   [5:0] PIPETX2EQDEEMPH,
  output   [5:0] PIPETX3EQDEEMPH,
  output   [5:0] PIPETX4EQDEEMPH,
  output   [5:0] PIPETX5EQDEEMPH,
  output   [5:0] PIPETX6EQDEEMPH,
  output   [5:0] PIPETX7EQDEEMPH,
  output  [74:0] MAXISRCTUSER,
  output   [7:0] CFGEXTFUNCTIONNUMBER,
  output   [7:0] CFGFCCPLH,
  output   [7:0] CFGFCNPH,
  output   [7:0] CFGFCPH,
  output   [7:0] CFGFUNCTIONSTATUS,
  output   [7:0] CFGMSGRECEIVEDDATA,
  output   [7:0] MAXISCQTKEEP,
  output   [7:0] MAXISRCTKEEP,
  output   [7:0] PLGEN3PCSRXSLIDE,
  output  [84:0] MAXISCQTUSER,
  output   [9:0] CFGEXTREGISTERNUMBER,
  input          CFGCONFIGSPACEENABLE,
  input          CFGERRCORIN,
  input          CFGERRUNCORIN,
  input          CFGEXTREADDATAVALID,
  input          CFGHOTRESETIN,
  input          CFGINPUTUPDATEREQUEST,
  input          CFGINTERRUPTMSITPHPRESENT,
  input          CFGINTERRUPTMSIXINT,
  input          CFGLINKTRAININGENABLE,
  input          CFGMCUPDATEREQUEST,
  input          CFGMGMTREAD,
  input          CFGMGMTTYPE1CFGREGACCESS,
  input          CFGMGMTWRITE,
  input          CFGMSGTRANSMIT,
  input          CFGPERFUNCTIONOUTPUTREQUEST,
  input          CFGPOWERSTATECHANGEACK,
  input          CFGREQPMTRANSITIONL23READY,
  input          CFGTPHSTTREADDATAVALID,
  input          CORECLK,
  input          CORECLKMICOMPLETIONRAML,
  input          CORECLKMICOMPLETIONRAMU,
  input          CORECLKMIREPLAYRAM,
  input          CORECLKMIREQUESTRAM,
  input          DRPCLK,
  input          DRPEN,
  input          DRPWE,
  input          MGMTRESETN,
  input          MGMTSTICKYRESETN,
  input          PCIECQNPREQ,
  input          PIPECLK,
  input          PIPERESETN,
  input          PIPERX0DATAVALID,
  input          PIPERX0ELECIDLE,
  input          PIPERX0EQDONE,
  input          PIPERX0EQLPADAPTDONE,
  input          PIPERX0EQLPLFFSSEL,
  input          PIPERX0PHYSTATUS,
  input          PIPERX0STARTBLOCK,
  input          PIPERX0VALID,
  input          PIPERX1DATAVALID,
  input          PIPERX1ELECIDLE,
  input          PIPERX1EQDONE,
  input          PIPERX1EQLPADAPTDONE,
  input          PIPERX1EQLPLFFSSEL,
  input          PIPERX1PHYSTATUS,
  input          PIPERX1STARTBLOCK,
  input          PIPERX1VALID,
  input          PIPERX2DATAVALID,
  input          PIPERX2ELECIDLE,
  input          PIPERX2EQDONE,
  input          PIPERX2EQLPADAPTDONE,
  input          PIPERX2EQLPLFFSSEL,
  input          PIPERX2PHYSTATUS,
  input          PIPERX2STARTBLOCK,
  input          PIPERX2VALID,
  input          PIPERX3DATAVALID,
  input          PIPERX3ELECIDLE,
  input          PIPERX3EQDONE,
  input          PIPERX3EQLPADAPTDONE,
  input          PIPERX3EQLPLFFSSEL,
  input          PIPERX3PHYSTATUS,
  input          PIPERX3STARTBLOCK,
  input          PIPERX3VALID,
  input          PIPERX4DATAVALID,
  input          PIPERX4ELECIDLE,
  input          PIPERX4EQDONE,
  input          PIPERX4EQLPADAPTDONE,
  input          PIPERX4EQLPLFFSSEL,
  input          PIPERX4PHYSTATUS,
  input          PIPERX4STARTBLOCK,
  input          PIPERX4VALID,
  input          PIPERX5DATAVALID,
  input          PIPERX5ELECIDLE,
  input          PIPERX5EQDONE,
  input          PIPERX5EQLPADAPTDONE,
  input          PIPERX5EQLPLFFSSEL,
  input          PIPERX5PHYSTATUS,
  input          PIPERX5STARTBLOCK,
  input          PIPERX5VALID,
  input          PIPERX6DATAVALID,
  input          PIPERX6ELECIDLE,
  input          PIPERX6EQDONE,
  input          PIPERX6EQLPADAPTDONE,
  input          PIPERX6EQLPLFFSSEL,
  input          PIPERX6PHYSTATUS,
  input          PIPERX6STARTBLOCK,
  input          PIPERX6VALID,
  input          PIPERX7DATAVALID,
  input          PIPERX7ELECIDLE,
  input          PIPERX7EQDONE,
  input          PIPERX7EQLPADAPTDONE,
  input          PIPERX7EQLPLFFSSEL,
  input          PIPERX7PHYSTATUS,
  input          PIPERX7STARTBLOCK,
  input          PIPERX7VALID,
  input          PIPETX0EQDONE,
  input          PIPETX1EQDONE,
  input          PIPETX2EQDONE,
  input          PIPETX3EQDONE,
  input          PIPETX4EQDONE,
  input          PIPETX5EQDONE,
  input          PIPETX6EQDONE,
  input          PIPETX7EQDONE,
  input          PLDISABLESCRAMBLER,
  input          PLEQRESETEIEOSCOUNT,
  input          PLGEN3PCSDISABLE,
  input          RECCLK,
  input          RESETN,
  input          SAXISCCTLAST,
  input          SAXISCCTVALID,
  input          SAXISRQTLAST,
  input          SAXISRQTVALID,
  input          USERCLK,
  input   [10:0] DRPADDR,
  input   [15:0] CFGDEVID,
  input   [15:0] CFGSUBSYSID,
  input   [15:0] CFGSUBSYSVENDID,
  input   [15:0] CFGVENDID,
  input   [15:0] DRPDI,
  input   [17:0] PIPERX0EQLPNEWTXCOEFFORPRESET,
  input   [17:0] PIPERX1EQLPNEWTXCOEFFORPRESET,
  input   [17:0] PIPERX2EQLPNEWTXCOEFFORPRESET,
  input   [17:0] PIPERX3EQLPNEWTXCOEFFORPRESET,
  input   [17:0] PIPERX4EQLPNEWTXCOEFFORPRESET,
  input   [17:0] PIPERX5EQLPNEWTXCOEFFORPRESET,
  input   [17:0] PIPERX6EQLPNEWTXCOEFFORPRESET,
  input   [17:0] PIPERX7EQLPNEWTXCOEFFORPRESET,
  input   [17:0] PIPETX0EQCOEFF,
  input   [17:0] PIPETX1EQCOEFF,
  input   [17:0] PIPETX2EQCOEFF,
  input   [17:0] PIPETX3EQCOEFF,
  input   [17:0] PIPETX4EQCOEFF,
  input   [17:0] PIPETX5EQCOEFF,
  input   [17:0] PIPETX6EQCOEFF,
  input   [17:0] PIPETX7EQCOEFF,
  input   [18:0] CFGMGMTADDR,
  input    [1:0] CFGFLRDONE,
  input    [1:0] CFGINTERRUPTMSITPHTYPE,
  input    [1:0] CFGINTERRUPTPENDING,
  input    [1:0] PIPERX0CHARISK,
  input    [1:0] PIPERX0SYNCHEADER,
  input    [1:0] PIPERX1CHARISK,
  input    [1:0] PIPERX1SYNCHEADER,
  input    [1:0] PIPERX2CHARISK,
  input    [1:0] PIPERX2SYNCHEADER,
  input    [1:0] PIPERX3CHARISK,
  input    [1:0] PIPERX3SYNCHEADER,
  input    [1:0] PIPERX4CHARISK,
  input    [1:0] PIPERX4SYNCHEADER,
  input    [1:0] PIPERX5CHARISK,
  input    [1:0] PIPERX5SYNCHEADER,
  input    [1:0] PIPERX6CHARISK,
  input    [1:0] PIPERX6SYNCHEADER,
  input    [1:0] PIPERX7CHARISK,
  input    [1:0] PIPERX7SYNCHEADER,
  input   [21:0] MAXISCQTREADY,
  input   [21:0] MAXISRCTREADY,
  input  [255:0] SAXISCCTDATA,
  input  [255:0] SAXISRQTDATA,
  input    [2:0] CFGDSFUNCTIONNUMBER,
  input    [2:0] CFGFCSEL,
  input    [2:0] CFGINTERRUPTMSIATTR,
  input    [2:0] CFGINTERRUPTMSIFUNCTIONNUMBER,
  input    [2:0] CFGMSGTRANSMITTYPE,
  input    [2:0] CFGPERFUNCSTATUSCONTROL,
  input    [2:0] CFGPERFUNCTIONNUMBER,
  input    [2:0] PIPERX0STATUS,
  input    [2:0] PIPERX1STATUS,
  input    [2:0] PIPERX2STATUS,
  input    [2:0] PIPERX3STATUS,
  input    [2:0] PIPERX4STATUS,
  input    [2:0] PIPERX5STATUS,
  input    [2:0] PIPERX6STATUS,
  input    [2:0] PIPERX7STATUS,
  input   [31:0] CFGEXTREADDATA,
  input   [31:0] CFGINTERRUPTMSIINT,
  input   [31:0] CFGINTERRUPTMSIXDATA,
  input   [31:0] CFGMGMTWRITEDATA,
  input   [31:0] CFGMSGTRANSMITDATA,
  input   [31:0] CFGTPHSTTREADDATA,
  input   [31:0] PIPERX0DATA,
  input   [31:0] PIPERX1DATA,
  input   [31:0] PIPERX2DATA,
  input   [31:0] PIPERX3DATA,
  input   [31:0] PIPERX4DATA,
  input   [31:0] PIPERX5DATA,
  input   [31:0] PIPERX6DATA,
  input   [31:0] PIPERX7DATA,
  input   [32:0] SAXISCCTUSER,
  input    [3:0] CFGINTERRUPTINT,
  input    [3:0] CFGINTERRUPTMSISELECT,
  input    [3:0] CFGMGMTBYTEENABLE,
  input    [4:0] CFGDSDEVICENUMBER,
  input   [59:0] SAXISRQTUSER,
  input    [5:0] CFGVFFLRDONE,
  input    [5:0] PIPEEQFS,
  input    [5:0] PIPEEQLF,
  input   [63:0] CFGDSN,
  input   [63:0] CFGINTERRUPTMSIPENDINGSTATUS,
  input   [63:0] CFGINTERRUPTMSIXADDRESS,
  input    [7:0] CFGDSBUSNUMBER,
  input    [7:0] CFGDSPORTNUMBER,
  input    [7:0] CFGREVID,
  input    [7:0] PLGEN3PCSRXSYNCDONE,
  input    [7:0] SAXISCCTKEEP,
  input    [7:0] SAXISRQTKEEP,
  input    [8:0] CFGINTERRUPTMSITPHSTTAG
);

  //wire [1:0]   MIREPLAYRAMREADENABLE;
  wire [1:0]   MIREPLAYRAMWRITEENABLE;
  wire [3:0]   MICOMPLETIONRAMREADENABLEL;
  wire [3:0]   MICOMPLETIONRAMREADENABLEU;
  wire [3:0]   MICOMPLETIONRAMWRITEENABLEL;
  wire [3:0]   MICOMPLETIONRAMWRITEENABLEU;
  wire [3:0]   MIREQUESTRAMREADENABLE;
  wire [3:0]   MIREQUESTRAMWRITEENABLE;
  wire [71:0]  MICOMPLETIONRAMWRITEDATAL;
  wire [71:0]  MICOMPLETIONRAMWRITEDATAU;
  wire [8:0]   MIREPLAYRAMADDRESS;
  wire [8:0]   MIREQUESTRAMREADADDRESSA;
  wire [8:0]   MIREQUESTRAMREADADDRESSB;
  wire [8:0]   MIREQUESTRAMWRITEADDRESSA;
  wire [8:0]   MIREQUESTRAMWRITEADDRESSB;
  wire [9:0]   MICOMPLETIONRAMREADADDRESSAL;
  wire [9:0]   MICOMPLETIONRAMREADADDRESSAU;
  wire [9:0]   MICOMPLETIONRAMREADADDRESSBL;
  wire [9:0]   MICOMPLETIONRAMREADADDRESSBU;
  wire [9:0]   MICOMPLETIONRAMWRITEADDRESSAL;
  wire [9:0]   MICOMPLETIONRAMWRITEADDRESSAU;
  wire [9:0]   MICOMPLETIONRAMWRITEADDRESSBL;
  wire [9:0]   MICOMPLETIONRAMWRITEADDRESSBU;

//-------wires (for connections required for timing closure)-------

(* S="TRUE" *)   wire [143:0] MICOMPLETIONRAMWRITEDATA;
(* S="TRUE" *)   wire [143:0] MIREPLAYRAMWRITEDATA;
(* S="TRUE" *)   wire [143:0] MIREQUESTRAMWRITEDATA;

(* S="TRUE" *)   wire [143:0] MICOMPLETIONRAMREADDATA;
(* S="TRUE" *)   wire [143:0] MIREPLAYRAMREADDATA;
(* S="TRUE" *)   wire [143:0] MIREQUESTRAMREADDATA;

  wire [15:0] mim_cpl_wdip;
  wire [15:0] mim_rep_wdip;
  wire [15:0] mim_req_wdip;
  wire [15:0] mim_cpl_rdop;
  wire [15:0] mim_rep_rdop;
  wire [15:0] mim_req_rdop;

  wire [127:0] mim_cpl_wdata;
  wire [127:0] mim_rep_wdata;
  wire [127:0] mim_req_wdata;

  wire [127:0] mim_cpl_rdata;
  wire [127:0] mim_rep_rdata;
  wire [127:0] mim_req_rdata;


//----------------Connections required for timing closure----------------

//----------------rep-------------------------------------

assign  MIREPLAYRAMREADDATA =  {mim_rep_rdop[15], mim_rep_rdata[127:120],
                                mim_rep_rdop[14], mim_rep_rdata[119:112],
                                mim_rep_rdop[13], mim_rep_rdata[111:104],
                                mim_rep_rdop[12], mim_rep_rdata[103:96],
                                mim_rep_rdop[11], mim_rep_rdata[95:88],
                                mim_rep_rdop[10], mim_rep_rdata[87:80],
                                mim_rep_rdop[9], mim_rep_rdata[79:72],
                                mim_rep_rdop[8], mim_rep_rdata[71:64],
                                mim_rep_rdop[7], mim_rep_rdata[63:56],
                                mim_rep_rdop[6], mim_rep_rdata[55:48],
                                mim_rep_rdop[5], mim_rep_rdata[47:40],
                                mim_rep_rdop[4], mim_rep_rdata[39:32],
                                mim_rep_rdop[3], mim_rep_rdata[31:24],
                                mim_rep_rdop[2], mim_rep_rdata[23:16],
                                mim_rep_rdop[1], mim_rep_rdata[15:8],
                                mim_rep_rdop[0], mim_rep_rdata[7:0]};


assign mim_rep_wdip =    {MIREPLAYRAMWRITEDATA[143],
                          MIREPLAYRAMWRITEDATA[134],
                          MIREPLAYRAMWRITEDATA[125],
                          MIREPLAYRAMWRITEDATA[116],
                          MIREPLAYRAMWRITEDATA[107],
                          MIREPLAYRAMWRITEDATA[98],
                          MIREPLAYRAMWRITEDATA[89],
                          MIREPLAYRAMWRITEDATA[80],
                          MIREPLAYRAMWRITEDATA[71],
                          MIREPLAYRAMWRITEDATA[62],
                          MIREPLAYRAMWRITEDATA[53],
                          MIREPLAYRAMWRITEDATA[44],
                          MIREPLAYRAMWRITEDATA[35],
                          MIREPLAYRAMWRITEDATA[26],
                          MIREPLAYRAMWRITEDATA[17],
                          MIREPLAYRAMWRITEDATA[8]};


assign mim_rep_wdata =   {MIREPLAYRAMWRITEDATA[142:135],
                          MIREPLAYRAMWRITEDATA[133:126],
                          MIREPLAYRAMWRITEDATA[124:117],
                          MIREPLAYRAMWRITEDATA[115:108],
                          MIREPLAYRAMWRITEDATA[106:99],
                          MIREPLAYRAMWRITEDATA[97:90],
                          MIREPLAYRAMWRITEDATA[88:81],
                          MIREPLAYRAMWRITEDATA[79:72],
                          MIREPLAYRAMWRITEDATA[70:63],
                          MIREPLAYRAMWRITEDATA[61:54],
                          MIREPLAYRAMWRITEDATA[52:45],
                          MIREPLAYRAMWRITEDATA[43:36],
                          MIREPLAYRAMWRITEDATA[34:27],
                          MIREPLAYRAMWRITEDATA[25:18],
                          MIREPLAYRAMWRITEDATA[16:9],
                          MIREPLAYRAMWRITEDATA[7:0]};


//----------------req-------------------------------------

assign  MIREQUESTRAMREADDATA =  {mim_req_rdop[15], mim_req_rdata[127:120],
                                 mim_req_rdop[14], mim_req_rdata[119:112],
                                 mim_req_rdop[13], mim_req_rdata[111:104],
                                 mim_req_rdop[12], mim_req_rdata[103:96],
                                 mim_req_rdop[11], mim_req_rdata[95:88],
                                 mim_req_rdop[10], mim_req_rdata[87:80],
                                 mim_req_rdop[9], mim_req_rdata[79:72],
                                 mim_req_rdop[8], mim_req_rdata[71:64],
                                 mim_req_rdop[7], mim_req_rdata[63:56],
                                 mim_req_rdop[6], mim_req_rdata[55:48],
                                 mim_req_rdop[5], mim_req_rdata[47:40],
                                 mim_req_rdop[4], mim_req_rdata[39:32],
                                 mim_req_rdop[3], mim_req_rdata[31:24],
                                 mim_req_rdop[2], mim_req_rdata[23:16],
                                 mim_req_rdop[1], mim_req_rdata[15:8],
                                 mim_req_rdop[0], mim_req_rdata[7:0]};

assign mim_req_wdip =   {MIREQUESTRAMWRITEDATA[143],
                         MIREQUESTRAMWRITEDATA[134],
                         MIREQUESTRAMWRITEDATA[125],
                         MIREQUESTRAMWRITEDATA[116],
                         MIREQUESTRAMWRITEDATA[107],
                         MIREQUESTRAMWRITEDATA[98],
                         MIREQUESTRAMWRITEDATA[89],
                         MIREQUESTRAMWRITEDATA[80],
                         MIREQUESTRAMWRITEDATA[71],
                         MIREQUESTRAMWRITEDATA[62],
                         MIREQUESTRAMWRITEDATA[53],
                         MIREQUESTRAMWRITEDATA[44],
                         MIREQUESTRAMWRITEDATA[35],
                         MIREQUESTRAMWRITEDATA[26],
                         MIREQUESTRAMWRITEDATA[17],
                         MIREQUESTRAMWRITEDATA[8]};

assign mim_req_wdata =  {MIREQUESTRAMWRITEDATA[142:135],
                         MIREQUESTRAMWRITEDATA[133:126],
                         MIREQUESTRAMWRITEDATA[124:117],
                         MIREQUESTRAMWRITEDATA[115:108],
                         MIREQUESTRAMWRITEDATA[106:99],
                         MIREQUESTRAMWRITEDATA[97:90],
                         MIREQUESTRAMWRITEDATA[88:81],
                         MIREQUESTRAMWRITEDATA[79:72],
                         MIREQUESTRAMWRITEDATA[70:63],
                         MIREQUESTRAMWRITEDATA[61:54],
                         MIREQUESTRAMWRITEDATA[52:45],
                         MIREQUESTRAMWRITEDATA[43:36],
                         MIREQUESTRAMWRITEDATA[34:27],
                         MIREQUESTRAMWRITEDATA[25:18],
                         MIREQUESTRAMWRITEDATA[16:9],
                         MIREQUESTRAMWRITEDATA[7:0]};


//----------------cpl-------------------------------------

assign  MICOMPLETIONRAMREADDATA =  {mim_cpl_rdop[15], mim_cpl_rdata[127:120],
                                    mim_cpl_rdop[14], mim_cpl_rdata[119:112],
                                    mim_cpl_rdop[13], mim_cpl_rdata[111:104],
                                    mim_cpl_rdop[12], mim_cpl_rdata[103:96],
                                    mim_cpl_rdop[11], mim_cpl_rdata[95:88],
                                    mim_cpl_rdop[10], mim_cpl_rdata[87:80],
                                    mim_cpl_rdop[9], mim_cpl_rdata[79:72],
                                    mim_cpl_rdop[8], mim_cpl_rdata[71:64],
                                    mim_cpl_rdop[7], mim_cpl_rdata[63:56],
                                    mim_cpl_rdop[6], mim_cpl_rdata[55:48],
                                    mim_cpl_rdop[5], mim_cpl_rdata[47:40],
                                    mim_cpl_rdop[4], mim_cpl_rdata[39:32],
                                    mim_cpl_rdop[3], mim_cpl_rdata[31:24],
                                    mim_cpl_rdop[2], mim_cpl_rdata[23:16],
                                    mim_cpl_rdop[1], mim_cpl_rdata[15:8],
                                    mim_cpl_rdop[0], mim_cpl_rdata[7:0]};


assign MICOMPLETIONRAMWRITEDATA =    {MICOMPLETIONRAMWRITEDATAU[71:0], MICOMPLETIONRAMWRITEDATAL[71:0]};

assign mim_cpl_wdip =   {MICOMPLETIONRAMWRITEDATA[143],
                         MICOMPLETIONRAMWRITEDATA[134],
                         MICOMPLETIONRAMWRITEDATA[125],
                         MICOMPLETIONRAMWRITEDATA[116],
                         MICOMPLETIONRAMWRITEDATA[107],
                         MICOMPLETIONRAMWRITEDATA[98],
                         MICOMPLETIONRAMWRITEDATA[89],
                         MICOMPLETIONRAMWRITEDATA[80],
                         MICOMPLETIONRAMWRITEDATA[71],
                         MICOMPLETIONRAMWRITEDATA[62],
                         MICOMPLETIONRAMWRITEDATA[53],
                         MICOMPLETIONRAMWRITEDATA[44],
                         MICOMPLETIONRAMWRITEDATA[35],
                         MICOMPLETIONRAMWRITEDATA[26],
                         MICOMPLETIONRAMWRITEDATA[17],
                         MICOMPLETIONRAMWRITEDATA[8]};


assign mim_cpl_wdata =  {MICOMPLETIONRAMWRITEDATA[142:135],
                         MICOMPLETIONRAMWRITEDATA[133:126],
                         MICOMPLETIONRAMWRITEDATA[124:117],
                         MICOMPLETIONRAMWRITEDATA[115:108],
                         MICOMPLETIONRAMWRITEDATA[106:99],
                         MICOMPLETIONRAMWRITEDATA[97:90],
                         MICOMPLETIONRAMWRITEDATA[88:81],
                         MICOMPLETIONRAMWRITEDATA[79:72],
                         MICOMPLETIONRAMWRITEDATA[70:63],
                         MICOMPLETIONRAMWRITEDATA[61:54],
                         MICOMPLETIONRAMWRITEDATA[52:45],
                         MICOMPLETIONRAMWRITEDATA[43:36],
                         MICOMPLETIONRAMWRITEDATA[34:27],
                         MICOMPLETIONRAMWRITEDATA[25:18],
                         MICOMPLETIONRAMWRITEDATA[16:9],
                         MICOMPLETIONRAMWRITEDATA[7:0]};

reg reset_sync0;
reg reset_sync1;

always @(posedge CORECLK or negedge RESETN )   // Synchronize RESETN to CORECLK
begin
   if (!RESETN) begin
      reset_sync0 <= 1'b1;
      reset_sync1 <= 1'b1;
   end else begin
      reset_sync0 <= 1'b0;
      reset_sync1 <= reset_sync0;
   end
end



  // {{{ PCIE_3_0 i
  //--------------------------------------------
  PCIE_3_0
    #(.ARI_CAP_ENABLE                                     (ARI_CAP_ENABLE),
      .AXISTEN_IF_CC_ALIGNMENT_MODE                       (AXISTEN_IF_CC_ALIGNMENT_MODE),
      .AXISTEN_IF_CC_PARITY_CHK                           (AXISTEN_IF_CC_PARITY_CHK),
      .AXISTEN_IF_CQ_ALIGNMENT_MODE                       (AXISTEN_IF_CQ_ALIGNMENT_MODE),
      .AXISTEN_IF_ENABLE_CLIENT_TAG                       (AXISTEN_IF_ENABLE_CLIENT_TAG),
      .AXISTEN_IF_ENABLE_MSG_ROUTE                        (AXISTEN_IF_ENABLE_MSG_ROUTE),
      .AXISTEN_IF_ENABLE_RX_MSG_INTFC                     (AXISTEN_IF_ENABLE_RX_MSG_INTFC),
      .AXISTEN_IF_RC_ALIGNMENT_MODE                       (AXISTEN_IF_RC_ALIGNMENT_MODE),
      .AXISTEN_IF_RC_STRADDLE                             (AXISTEN_IF_RC_STRADDLE),
      .AXISTEN_IF_RQ_ALIGNMENT_MODE                       (AXISTEN_IF_RQ_ALIGNMENT_MODE),
      .AXISTEN_IF_RQ_PARITY_CHK                           (AXISTEN_IF_RQ_PARITY_CHK),
      .AXISTEN_IF_WIDTH                                   (AXISTEN_IF_WIDTH),
      .CRM_CORE_CLK_FREQ_500                              (CRM_CORE_CLK_FREQ_500),
      .CRM_USER_CLK_FREQ                                  (CRM_USER_CLK_FREQ),
      .DNSTREAM_LINK_NUM                                  (DNSTREAM_LINK_NUM),
      .LL_ACK_TIMEOUT                                     (LL_ACK_TIMEOUT),
      .LL_ACK_TIMEOUT_EN                                  (LL_ACK_TIMEOUT_EN),
      .LL_ACK_TIMEOUT_FUNC                                (LL_ACK_TIMEOUT_FUNC),
      .LL_CPL_FC_UPDATE_TIMER                             (LL_CPL_FC_UPDATE_TIMER),
      .LL_CPL_FC_UPDATE_TIMER_OVERRIDE                    (LL_CPL_FC_UPDATE_TIMER_OVERRIDE),
      .LL_FC_UPDATE_TIMER                                 (LL_FC_UPDATE_TIMER),
      .LL_FC_UPDATE_TIMER_OVERRIDE                        (LL_FC_UPDATE_TIMER_OVERRIDE),
      .LL_NP_FC_UPDATE_TIMER                              (LL_NP_FC_UPDATE_TIMER),
      .LL_NP_FC_UPDATE_TIMER_OVERRIDE                     (LL_NP_FC_UPDATE_TIMER_OVERRIDE),
      .LL_P_FC_UPDATE_TIMER                               (LL_P_FC_UPDATE_TIMER),
      .LL_P_FC_UPDATE_TIMER_OVERRIDE                      (LL_P_FC_UPDATE_TIMER_OVERRIDE),
      .LL_REPLAY_TIMEOUT                                  (LL_REPLAY_TIMEOUT),
      .LL_REPLAY_TIMEOUT_EN                               (LL_REPLAY_TIMEOUT_EN),
      .LL_REPLAY_TIMEOUT_FUNC                             (LL_REPLAY_TIMEOUT_FUNC),
      .LTR_TX_MESSAGE_MINIMUM_INTERVAL                    (LTR_TX_MESSAGE_MINIMUM_INTERVAL),
      .LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE          (LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE),
      .LTR_TX_MESSAGE_ON_LTR_ENABLE                       (LTR_TX_MESSAGE_ON_LTR_ENABLE),
      .PF0_AER_CAP_ECRC_CHECK_CAPABLE                     (PF0_AER_CAP_ECRC_CHECK_CAPABLE),
      .PF0_AER_CAP_ECRC_GEN_CAPABLE                       (PF0_AER_CAP_ECRC_GEN_CAPABLE),
      .PF0_AER_CAP_NEXTPTR                                (PF0_AER_CAP_NEXTPTR),
      .PF0_ARI_CAP_NEXTPTR                                (PF0_ARI_CAP_NEXTPTR),
      .PF0_ARI_CAP_NEXT_FUNC                              (PF0_ARI_CAP_NEXT_FUNC),
      .PF0_ARI_CAP_VER                                    (PF0_ARI_CAP_VER),
      .PF0_BAR0_APERTURE_SIZE                             (PF0_BAR0_APERTURE_SIZE),
      .PF0_BAR0_CONTROL                                   (PF0_BAR0_CONTROL),
      .PF0_BAR1_APERTURE_SIZE                             (PF0_BAR1_APERTURE_SIZE),
      .PF0_BAR1_CONTROL                                   (PF0_BAR1_CONTROL),
      .PF0_BAR2_APERTURE_SIZE                             (PF0_BAR2_APERTURE_SIZE),
      .PF0_BAR2_CONTROL                                   (PF0_BAR2_CONTROL),
      .PF0_BAR3_APERTURE_SIZE                             (PF0_BAR3_APERTURE_SIZE),
      .PF0_BAR3_CONTROL                                   (PF0_BAR3_CONTROL),
      .PF0_BAR4_APERTURE_SIZE                             (PF0_BAR4_APERTURE_SIZE),
      .PF0_BAR4_CONTROL                                   (PF0_BAR4_CONTROL),
      .PF0_BAR5_APERTURE_SIZE                             (PF0_BAR5_APERTURE_SIZE),
      .PF0_BAR5_CONTROL                                   (PF0_BAR5_CONTROL),
      .PF0_BIST_REGISTER                                  (PF0_BIST_REGISTER),
      .PF0_CAPABILITY_POINTER                             (PF0_CAPABILITY_POINTER),
      .PF0_CLASS_CODE                                     (PF0_CLASS_CODE),
      .PF0_DEVICE_ID                                      (PF0_DEVICE_ID),
      .PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT     (PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT),
      .PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT          (PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT),
      .PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT          (PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT),
      .PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE                   (PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE),
      .PF0_DEV_CAP2_LTR_SUPPORT                           (PF0_DEV_CAP2_LTR_SUPPORT),
      .PF0_DEV_CAP2_OBFF_SUPPORT                          (PF0_DEV_CAP2_OBFF_SUPPORT),
      .PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT                 (PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT),
      .PF0_DEV_CAP_ENDPOINT_L0S_LATENCY                   (PF0_DEV_CAP_ENDPOINT_L0S_LATENCY),
      .PF0_DEV_CAP_ENDPOINT_L1_LATENCY                    (PF0_DEV_CAP_ENDPOINT_L1_LATENCY),
      .PF0_DEV_CAP_EXT_TAG_SUPPORTED                      (PF0_DEV_CAP_EXT_TAG_SUPPORTED),
      .PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE           (PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE),
      .PF0_DEV_CAP_MAX_PAYLOAD_SIZE                       (PF0_DEV_CAP_MAX_PAYLOAD_SIZE),
      .PF0_DPA_CAP_NEXTPTR                                (PF0_DPA_CAP_NEXTPTR),
      .VF0_ARI_CAP_NEXTPTR (VF0_ARI_CAP_NEXTPTR ),
      .VF1_ARI_CAP_NEXTPTR (VF1_ARI_CAP_NEXTPTR ),
      .VF2_ARI_CAP_NEXTPTR (VF2_ARI_CAP_NEXTPTR ),
      .VF3_ARI_CAP_NEXTPTR (VF3_ARI_CAP_NEXTPTR ),
      .VF4_ARI_CAP_NEXTPTR (VF4_ARI_CAP_NEXTPTR ),
      .VF5_ARI_CAP_NEXTPTR (VF5_ARI_CAP_NEXTPTR ),
      .VF0_TPHR_CAP_DEV_SPECIFIC_MODE (VF0_TPHR_CAP_DEV_SPECIFIC_MODE),
      .VF0_TPHR_CAP_ENABLE (VF0_TPHR_CAP_ENABLE),
      .VF0_TPHR_CAP_INT_VEC_MODE (VF0_TPHR_CAP_INT_VEC_MODE),
      .VF0_TPHR_CAP_NEXTPTR (VF0_TPHR_CAP_NEXTPTR),
      .VF0_TPHR_CAP_ST_MODE_SEL (VF0_TPHR_CAP_ST_MODE_SEL),
      .VF0_TPHR_CAP_ST_TABLE_LOC (VF0_TPHR_CAP_ST_TABLE_LOC),
      .VF0_TPHR_CAP_ST_TABLE_SIZE (VF0_TPHR_CAP_ST_TABLE_SIZE),
      .VF0_TPHR_CAP_VER (VF0_TPHR_CAP_VER),
      .VF1_TPHR_CAP_DEV_SPECIFIC_MODE (VF1_TPHR_CAP_DEV_SPECIFIC_MODE),
      .VF1_TPHR_CAP_ENABLE (VF1_TPHR_CAP_ENABLE),
      .VF1_TPHR_CAP_INT_VEC_MODE (VF1_TPHR_CAP_INT_VEC_MODE),
      .VF1_TPHR_CAP_NEXTPTR (VF1_TPHR_CAP_NEXTPTR),
      .VF1_TPHR_CAP_ST_MODE_SEL (VF1_TPHR_CAP_ST_MODE_SEL),
      .VF1_TPHR_CAP_ST_TABLE_LOC (VF1_TPHR_CAP_ST_TABLE_LOC),
      .VF1_TPHR_CAP_ST_TABLE_SIZE (VF1_TPHR_CAP_ST_TABLE_SIZE),
      .VF1_TPHR_CAP_VER (VF1_TPHR_CAP_VER),
      .VF2_TPHR_CAP_DEV_SPECIFIC_MODE (VF2_TPHR_CAP_DEV_SPECIFIC_MODE),
      .VF2_TPHR_CAP_ENABLE (VF2_TPHR_CAP_ENABLE),
      .VF2_TPHR_CAP_INT_VEC_MODE (VF2_TPHR_CAP_INT_VEC_MODE),
      .VF2_TPHR_CAP_NEXTPTR (VF2_TPHR_CAP_NEXTPTR),
      .VF2_TPHR_CAP_ST_MODE_SEL (VF2_TPHR_CAP_ST_MODE_SEL),
      .VF2_TPHR_CAP_ST_TABLE_LOC (VF2_TPHR_CAP_ST_TABLE_LOC),
      .VF2_TPHR_CAP_ST_TABLE_SIZE (VF2_TPHR_CAP_ST_TABLE_SIZE),
      .VF2_TPHR_CAP_VER (VF2_TPHR_CAP_VER),
      .VF3_TPHR_CAP_DEV_SPECIFIC_MODE (VF3_TPHR_CAP_DEV_SPECIFIC_MODE),
      .VF3_TPHR_CAP_ENABLE (VF3_TPHR_CAP_ENABLE),
      .VF3_TPHR_CAP_INT_VEC_MODE (VF3_TPHR_CAP_INT_VEC_MODE),
      .VF3_TPHR_CAP_NEXTPTR (VF3_TPHR_CAP_NEXTPTR),
      .VF3_TPHR_CAP_ST_MODE_SEL (VF3_TPHR_CAP_ST_MODE_SEL),
      .VF3_TPHR_CAP_ST_TABLE_LOC (VF3_TPHR_CAP_ST_TABLE_LOC),
      .VF3_TPHR_CAP_ST_TABLE_SIZE (VF3_TPHR_CAP_ST_TABLE_SIZE),
      .VF3_TPHR_CAP_VER (VF3_TPHR_CAP_VER),
      .VF4_TPHR_CAP_DEV_SPECIFIC_MODE (VF4_TPHR_CAP_DEV_SPECIFIC_MODE),
      .VF4_TPHR_CAP_ENABLE (VF4_TPHR_CAP_ENABLE),
      .VF4_TPHR_CAP_INT_VEC_MODE (VF4_TPHR_CAP_INT_VEC_MODE),
      .VF4_TPHR_CAP_NEXTPTR (VF4_TPHR_CAP_NEXTPTR),
      .VF4_TPHR_CAP_ST_MODE_SEL (VF4_TPHR_CAP_ST_MODE_SEL),
      .VF4_TPHR_CAP_ST_TABLE_LOC (VF4_TPHR_CAP_ST_TABLE_LOC),
      .VF4_TPHR_CAP_ST_TABLE_SIZE (VF4_TPHR_CAP_ST_TABLE_SIZE),
      .VF4_TPHR_CAP_VER (VF4_TPHR_CAP_VER),
      .VF5_TPHR_CAP_DEV_SPECIFIC_MODE (VF5_TPHR_CAP_DEV_SPECIFIC_MODE),
      .VF5_TPHR_CAP_ENABLE (VF5_TPHR_CAP_ENABLE),
      .VF5_TPHR_CAP_INT_VEC_MODE (VF5_TPHR_CAP_INT_VEC_MODE),
      .VF5_TPHR_CAP_NEXTPTR (VF5_TPHR_CAP_NEXTPTR),
      .VF5_TPHR_CAP_ST_MODE_SEL (VF5_TPHR_CAP_ST_MODE_SEL),
      .VF5_TPHR_CAP_ST_TABLE_LOC (VF5_TPHR_CAP_ST_TABLE_LOC),
      .VF5_TPHR_CAP_ST_TABLE_SIZE (VF5_TPHR_CAP_ST_TABLE_SIZE),
      .VF5_TPHR_CAP_VER (VF5_TPHR_CAP_VER),
      .PF0_DPA_CAP_SUB_STATE_CONTROL                      (PF0_DPA_CAP_SUB_STATE_CONTROL),
      .PF0_DPA_CAP_SUB_STATE_CONTROL_EN                   (PF0_DPA_CAP_SUB_STATE_CONTROL_EN),
      .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0            (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
      .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1            (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
      .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2            (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
      .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3            (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
      .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4            (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
      .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5            (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
      .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6            (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
      .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7            (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
      .PF0_DPA_CAP_VER                                    (PF0_DPA_CAP_VER),
      .PF0_DSN_CAP_NEXTPTR                                (PF0_DSN_CAP_NEXTPTR),
      .PF0_EXPANSION_ROM_APERTURE_SIZE                    (PF0_EXPANSION_ROM_APERTURE_SIZE),
      .PF0_EXPANSION_ROM_ENABLE                           (PF0_EXPANSION_ROM_ENABLE),
      .PF0_INTERRUPT_LINE                                 (PF0_INTERRUPT_LINE),
      .PF0_INTERRUPT_PIN                                  (PF0_INTERRUPT_PIN),
      .PF0_LINK_CAP_ASPM_SUPPORT                          (PF0_LINK_CAP_ASPM_SUPPORT),
      .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1          (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1),
      .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2          (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2),
      .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3          (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3),
      .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1                 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1),
      .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2                 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2),
      .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3                 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3),
      .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1           (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1),
      .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2           (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2),
      .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3           (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3),
      .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1                  (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1),
      .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2                  (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2),
      .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3                  (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3),
      .PF0_LINK_STATUS_SLOT_CLOCK_CONFIG                  (PF0_LINK_STATUS_SLOT_CLOCK_CONFIG),
      .PF0_LTR_CAP_MAX_NOSNOOP_LAT                        (PF0_LTR_CAP_MAX_NOSNOOP_LAT),
      .PF0_LTR_CAP_MAX_SNOOP_LAT                          (PF0_LTR_CAP_MAX_SNOOP_LAT),
      .PF0_LTR_CAP_NEXTPTR                                (PF0_LTR_CAP_NEXTPTR),
      .PF0_LTR_CAP_VER                                    (PF0_LTR_CAP_VER),
      .PF0_MSIX_CAP_NEXTPTR                               (PF0_MSIX_CAP_NEXTPTR),
      .PF0_MSIX_CAP_PBA_BIR                               (PF0_MSIX_CAP_PBA_BIR),
      .PF0_MSIX_CAP_PBA_OFFSET                            (PF0_MSIX_CAP_PBA_OFFSET),
      .PF0_MSIX_CAP_TABLE_BIR                             (PF0_MSIX_CAP_TABLE_BIR),
      .PF0_MSIX_CAP_TABLE_OFFSET                          (PF0_MSIX_CAP_TABLE_OFFSET),
      .PF0_MSIX_CAP_TABLE_SIZE                            (PF0_MSIX_CAP_TABLE_SIZE),
      .PF0_MSI_CAP_MULTIMSGCAP                            (PF0_MSI_CAP_MULTIMSGCAP),
      .PF0_MSI_CAP_NEXTPTR                                (PF0_MSI_CAP_NEXTPTR),
      .PF0_PB_CAP_NEXTPTR                                 (PF0_PB_CAP_NEXTPTR),
      .PF0_PB_CAP_SYSTEM_ALLOCATED                        (PF0_PB_CAP_SYSTEM_ALLOCATED),
      .PF0_PB_CAP_VER                                     (PF0_PB_CAP_VER),
      .PF0_PM_CAP_ID                                      (PF0_PM_CAP_ID),
      .PF0_PM_CAP_NEXTPTR                                 (PF0_PM_CAP_NEXTPTR),
      .PF0_PM_CAP_PMESUPPORT_D0                           (PF0_PM_CAP_PMESUPPORT_D0),
      .PF0_PM_CAP_PMESUPPORT_D1                           (PF0_PM_CAP_PMESUPPORT_D1),
      .PF0_PM_CAP_PMESUPPORT_D3HOT                        (PF0_PM_CAP_PMESUPPORT_D3HOT),
      .PF0_PM_CAP_SUPP_D1_STATE                           (PF0_PM_CAP_SUPP_D1_STATE),
      .PF0_PM_CAP_VER_ID                                  (PF0_PM_CAP_VER_ID),
      .PF0_PM_CSR_NOSOFTRESET                             (PF0_PM_CSR_NOSOFTRESET),
      .PF0_RBAR_CAP_ENABLE                                (PF0_RBAR_CAP_ENABLE),
      .PF0_RBAR_CAP_INDEX0                                (PF0_RBAR_CAP_INDEX0),
      .PF0_RBAR_CAP_INDEX1                                (PF0_RBAR_CAP_INDEX1),
      .PF0_RBAR_CAP_INDEX2                                (PF0_RBAR_CAP_INDEX2),
      .PF0_RBAR_CAP_NEXTPTR                               (PF0_RBAR_CAP_NEXTPTR),
      .PF0_RBAR_CAP_SIZE0                                 (PF0_RBAR_CAP_SIZE0),
      .PF0_RBAR_CAP_SIZE1                                 (PF0_RBAR_CAP_SIZE1),
      .PF0_RBAR_CAP_SIZE2                                 (PF0_RBAR_CAP_SIZE2),
      .PF0_RBAR_CAP_VER                                   (PF0_RBAR_CAP_VER),
      .PF0_RBAR_NUM                                       (PF0_RBAR_NUM),
      .PF0_REVISION_ID                                    (PF0_REVISION_ID),
      .PF0_SRIOV_BAR0_APERTURE_SIZE                       (PF0_SRIOV_BAR0_APERTURE_SIZE),
      .PF0_SRIOV_BAR0_CONTROL                             (PF0_SRIOV_BAR0_CONTROL),
      .PF0_SRIOV_BAR1_APERTURE_SIZE                       (PF0_SRIOV_BAR1_APERTURE_SIZE),
      .PF0_SRIOV_BAR1_CONTROL                             (PF0_SRIOV_BAR1_CONTROL),
      .PF0_SRIOV_BAR2_APERTURE_SIZE                       (PF0_SRIOV_BAR2_APERTURE_SIZE),
      .PF0_SRIOV_BAR2_CONTROL                             (PF0_SRIOV_BAR2_CONTROL),
      .PF0_SRIOV_BAR3_APERTURE_SIZE                       (PF0_SRIOV_BAR3_APERTURE_SIZE),
      .PF0_SRIOV_BAR3_CONTROL                             (PF0_SRIOV_BAR3_CONTROL),
      .PF0_SRIOV_BAR4_APERTURE_SIZE                       (PF0_SRIOV_BAR4_APERTURE_SIZE),
      .PF0_SRIOV_BAR4_CONTROL                             (PF0_SRIOV_BAR4_CONTROL),
      .PF0_SRIOV_BAR5_APERTURE_SIZE                       (PF0_SRIOV_BAR5_APERTURE_SIZE),
      .PF0_SRIOV_BAR5_CONTROL                             (PF0_SRIOV_BAR5_CONTROL),
      .PF0_SRIOV_CAP_INITIAL_VF                           (PF0_SRIOV_CAP_INITIAL_VF),
      .PF0_SRIOV_CAP_NEXTPTR                              (PF0_SRIOV_CAP_NEXTPTR),
      .PF0_SRIOV_CAP_TOTAL_VF                             (PF0_SRIOV_CAP_TOTAL_VF),
      .PF0_SRIOV_CAP_VER                                  (PF0_SRIOV_CAP_VER),
      .PF0_SRIOV_FIRST_VF_OFFSET                          (PF0_SRIOV_FIRST_VF_OFFSET),
      .PF0_SRIOV_FUNC_DEP_LINK                            (PF0_SRIOV_FUNC_DEP_LINK),
      .PF0_SRIOV_SUPPORTED_PAGE_SIZE                      (PF0_SRIOV_SUPPORTED_PAGE_SIZE),
      .PF0_SRIOV_VF_DEVICE_ID                             (PF0_SRIOV_VF_DEVICE_ID),
      .PF0_SUBSYSTEM_ID                                   (PF0_SUBSYSTEM_ID),
      .PF0_TPHR_CAP_DEV_SPECIFIC_MODE                     (PF0_TPHR_CAP_DEV_SPECIFIC_MODE),
      .PF0_TPHR_CAP_ENABLE                                (PF0_TPHR_CAP_ENABLE),
      .PF0_TPHR_CAP_INT_VEC_MODE                          (PF0_TPHR_CAP_INT_VEC_MODE),
      .PF0_TPHR_CAP_NEXTPTR                               (PF0_TPHR_CAP_NEXTPTR),
      .PF0_TPHR_CAP_ST_MODE_SEL                           (PF0_TPHR_CAP_ST_MODE_SEL),
      .PF0_TPHR_CAP_ST_TABLE_LOC                          (PF0_TPHR_CAP_ST_TABLE_LOC),
      .PF0_TPHR_CAP_ST_TABLE_SIZE                         (PF0_TPHR_CAP_ST_TABLE_SIZE),
      .PF0_TPHR_CAP_VER                                   (PF0_TPHR_CAP_VER),
      .PF0_VC_CAP_NEXTPTR                                 (PF0_VC_CAP_NEXTPTR),
      .PF0_VC_CAP_VER                                     (PF0_VC_CAP_VER),
      .PF1_AER_CAP_ECRC_CHECK_CAPABLE                     (PF1_AER_CAP_ECRC_CHECK_CAPABLE),
      .PF1_AER_CAP_ECRC_GEN_CAPABLE                       (PF1_AER_CAP_ECRC_GEN_CAPABLE),
      .PF1_AER_CAP_NEXTPTR                                (PF1_AER_CAP_NEXTPTR),
      .PF1_ARI_CAP_NEXTPTR                                (PF1_ARI_CAP_NEXTPTR),
      .PF1_ARI_CAP_NEXT_FUNC                              (PF1_ARI_CAP_NEXT_FUNC),
      .PF1_BAR0_APERTURE_SIZE                             (PF1_BAR0_APERTURE_SIZE),
      .PF1_BAR0_CONTROL                                   (PF1_BAR0_CONTROL),
      .PF1_BAR1_APERTURE_SIZE                             (PF1_BAR1_APERTURE_SIZE),
      .PF1_BAR1_CONTROL                                   (PF1_BAR1_CONTROL),
      .PF1_BAR2_APERTURE_SIZE                             (PF1_BAR2_APERTURE_SIZE),
      .PF1_BAR2_CONTROL                                   (PF1_BAR2_CONTROL),
      .PF1_BAR3_APERTURE_SIZE                             (PF1_BAR3_APERTURE_SIZE),
      .PF1_BAR3_CONTROL                                   (PF1_BAR3_CONTROL),
      .PF1_BAR4_APERTURE_SIZE                             (PF1_BAR4_APERTURE_SIZE),
      .PF1_BAR4_CONTROL                                   (PF1_BAR4_CONTROL),
      .PF1_BAR5_APERTURE_SIZE                             (PF1_BAR5_APERTURE_SIZE),
      .PF1_BAR5_CONTROL                                   (PF1_BAR5_CONTROL),
      .PF1_BIST_REGISTER                                  (PF1_BIST_REGISTER),
      .PF1_CAPABILITY_POINTER                             (PF1_CAPABILITY_POINTER),
      .PF1_CLASS_CODE                                     (PF1_CLASS_CODE),
      .PF1_DEVICE_ID                                      (PF1_DEVICE_ID),
      .PF1_DEV_CAP_MAX_PAYLOAD_SIZE                       (PF1_DEV_CAP_MAX_PAYLOAD_SIZE),
      .PF1_DPA_CAP_NEXTPTR                                (PF1_DPA_CAP_NEXTPTR),
      .PF1_DPA_CAP_SUB_STATE_CONTROL                      (PF1_DPA_CAP_SUB_STATE_CONTROL),
      .PF1_DPA_CAP_SUB_STATE_CONTROL_EN                   (PF1_DPA_CAP_SUB_STATE_CONTROL_EN),
      .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0            (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
      .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1            (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
      .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2            (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
      .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3            (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
      .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4            (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
      .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5            (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
      .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6            (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
      .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7            (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
      .PF1_DPA_CAP_VER                                    (PF1_DPA_CAP_VER),
      .PF1_DSN_CAP_NEXTPTR                                (PF1_DSN_CAP_NEXTPTR),
      .PF1_EXPANSION_ROM_APERTURE_SIZE                    (PF1_EXPANSION_ROM_APERTURE_SIZE),
      .PF1_EXPANSION_ROM_ENABLE                           (PF1_EXPANSION_ROM_ENABLE),
      .PF1_INTERRUPT_LINE                                 (PF1_INTERRUPT_LINE),
      .PF1_INTERRUPT_PIN                                  (PF1_INTERRUPT_PIN),
      .PF1_MSIX_CAP_NEXTPTR                               (PF1_MSIX_CAP_NEXTPTR),
      .PF1_MSIX_CAP_PBA_BIR                               (PF1_MSIX_CAP_PBA_BIR),
      .PF1_MSIX_CAP_PBA_OFFSET                            (PF1_MSIX_CAP_PBA_OFFSET),
      .PF1_MSIX_CAP_TABLE_BIR                             (PF1_MSIX_CAP_TABLE_BIR),
      .PF1_MSIX_CAP_TABLE_OFFSET                          (PF1_MSIX_CAP_TABLE_OFFSET),
      .PF1_MSIX_CAP_TABLE_SIZE                            (PF1_MSIX_CAP_TABLE_SIZE),
      .PF1_MSI_CAP_MULTIMSGCAP                            (PF1_MSI_CAP_MULTIMSGCAP),
      .PF1_MSI_CAP_NEXTPTR                                (PF1_MSI_CAP_NEXTPTR),
      .PF1_PB_CAP_NEXTPTR                                 (PF1_PB_CAP_NEXTPTR),
      .PF1_PB_CAP_SYSTEM_ALLOCATED                        (PF1_PB_CAP_SYSTEM_ALLOCATED),
      .PF1_PB_CAP_VER                                     (PF1_PB_CAP_VER),
      .PF1_PM_CAP_ID                                      (PF1_PM_CAP_ID),
      .PF1_PM_CAP_NEXTPTR                                 (PF1_PM_CAP_NEXTPTR),
      .PF1_PM_CAP_VER_ID                                  (PF1_PM_CAP_VER_ID),
      .PF1_RBAR_CAP_ENABLE                                (PF1_RBAR_CAP_ENABLE),
      .PF1_RBAR_CAP_INDEX0                                (PF1_RBAR_CAP_INDEX0),
      .PF1_RBAR_CAP_INDEX1                                (PF1_RBAR_CAP_INDEX1),
      .PF1_RBAR_CAP_INDEX2                                (PF1_RBAR_CAP_INDEX2),
      .PF1_RBAR_CAP_NEXTPTR                               (PF1_RBAR_CAP_NEXTPTR),
      .PF1_RBAR_CAP_SIZE0                                 (PF1_RBAR_CAP_SIZE0),
      .PF1_RBAR_CAP_SIZE1                                 (PF1_RBAR_CAP_SIZE1),
      .PF1_RBAR_CAP_SIZE2                                 (PF1_RBAR_CAP_SIZE2),
      .PF1_RBAR_CAP_VER                                   (PF1_RBAR_CAP_VER),
      .PF1_RBAR_NUM                                       (PF1_RBAR_NUM),
      .PF1_REVISION_ID                                    (PF1_REVISION_ID),
      .PF1_SRIOV_BAR0_APERTURE_SIZE                       (PF1_SRIOV_BAR0_APERTURE_SIZE),
      .PF1_SRIOV_BAR0_CONTROL                             (PF1_SRIOV_BAR0_CONTROL),
      .PF1_SRIOV_BAR1_APERTURE_SIZE                       (PF1_SRIOV_BAR1_APERTURE_SIZE),
      .PF1_SRIOV_BAR1_CONTROL                             (PF1_SRIOV_BAR1_CONTROL),
      .PF1_SRIOV_BAR2_APERTURE_SIZE                       (PF1_SRIOV_BAR2_APERTURE_SIZE),
      .PF1_SRIOV_BAR2_CONTROL                             (PF1_SRIOV_BAR2_CONTROL),
      .PF1_SRIOV_BAR3_APERTURE_SIZE                       (PF1_SRIOV_BAR3_APERTURE_SIZE),
      .PF1_SRIOV_BAR3_CONTROL                             (PF1_SRIOV_BAR3_CONTROL),
      .PF1_SRIOV_BAR4_APERTURE_SIZE                       (PF1_SRIOV_BAR4_APERTURE_SIZE),
      .PF1_SRIOV_BAR4_CONTROL                             (PF1_SRIOV_BAR4_CONTROL),
      .PF1_SRIOV_BAR5_APERTURE_SIZE                       (PF1_SRIOV_BAR5_APERTURE_SIZE),
      .PF1_SRIOV_BAR5_CONTROL                             (PF1_SRIOV_BAR5_CONTROL),
      .PF1_SRIOV_CAP_INITIAL_VF                           (PF1_SRIOV_CAP_INITIAL_VF),
      .PF1_SRIOV_CAP_NEXTPTR                              (PF1_SRIOV_CAP_NEXTPTR),
      .PF1_SRIOV_CAP_TOTAL_VF                             (PF1_SRIOV_CAP_TOTAL_VF),
      .PF1_SRIOV_CAP_VER                                  (PF1_SRIOV_CAP_VER),
      .PF1_SRIOV_FIRST_VF_OFFSET                          (PF1_SRIOV_FIRST_VF_OFFSET),
      .PF1_SRIOV_FUNC_DEP_LINK                            (PF1_SRIOV_FUNC_DEP_LINK),
      .PF1_SRIOV_SUPPORTED_PAGE_SIZE                      (PF1_SRIOV_SUPPORTED_PAGE_SIZE),
      .PF1_SRIOV_VF_DEVICE_ID                             (PF1_SRIOV_VF_DEVICE_ID),
      .PF1_SUBSYSTEM_ID                                   (PF1_SUBSYSTEM_ID),
      .PF1_TPHR_CAP_DEV_SPECIFIC_MODE                     (PF1_TPHR_CAP_DEV_SPECIFIC_MODE),
      .PF1_TPHR_CAP_ENABLE                                (PF1_TPHR_CAP_ENABLE),
      .PF1_TPHR_CAP_INT_VEC_MODE                          (PF1_TPHR_CAP_INT_VEC_MODE),
      .PF1_TPHR_CAP_NEXTPTR                               (PF1_TPHR_CAP_NEXTPTR),
      .PF1_TPHR_CAP_ST_MODE_SEL                           (PF1_TPHR_CAP_ST_MODE_SEL),
      .PF1_TPHR_CAP_ST_TABLE_LOC                          (PF1_TPHR_CAP_ST_TABLE_LOC),
      .PF1_TPHR_CAP_ST_TABLE_SIZE                         (PF1_TPHR_CAP_ST_TABLE_SIZE),
      .PF1_TPHR_CAP_VER                                   (PF1_TPHR_CAP_VER),
      .PL_DISABLE_EI_INFER_IN_L0                          (PL_DISABLE_EI_INFER_IN_L0),
      .PL_DISABLE_GEN3_DC_BALANCE                         (PL_DISABLE_GEN3_DC_BALANCE),
      .PL_DISABLE_SCRAMBLING                              (PL_DISABLE_SCRAMBLING),
      .PL_DISABLE_UPCONFIG_CAPABLE                        (PL_DISABLE_UPCONFIG_CAPABLE),
      .PL_EQ_ADAPT_DISABLE_COEFF_CHECK                    (PL_EQ_ADAPT_DISABLE_COEFF_CHECK),
      .PL_EQ_ADAPT_DISABLE_PRESET_CHECK                   (PL_EQ_ADAPT_DISABLE_PRESET_CHECK),
      .PL_EQ_ADAPT_ITER_COUNT                             (PL_EQ_ADAPT_ITER_COUNT),
      .PL_EQ_ADAPT_REJECT_RETRY_COUNT                     (PL_EQ_ADAPT_REJECT_RETRY_COUNT),
      .PL_EQ_BYPASS_PHASE23                               (PL_EQ_BYPASS_PHASE23),
      .PL_EQ_SHORT_ADAPT_PHASE                            (PL_EQ_SHORT_ADAPT_PHASE),
      .PL_LANE0_EQ_CONTROL                                (PL_LANE0_EQ_CONTROL),
      .PL_LANE1_EQ_CONTROL                                (PL_LANE1_EQ_CONTROL),
      .PL_LANE2_EQ_CONTROL                                (PL_LANE2_EQ_CONTROL),
      .PL_LANE3_EQ_CONTROL                                (PL_LANE3_EQ_CONTROL),
      .PL_LANE4_EQ_CONTROL                                (PL_LANE4_EQ_CONTROL),
      .PL_LANE5_EQ_CONTROL                                (PL_LANE5_EQ_CONTROL),
      .PL_LANE6_EQ_CONTROL                                (PL_LANE6_EQ_CONTROL),
      .PL_LANE7_EQ_CONTROL                                (PL_LANE7_EQ_CONTROL),
      .PL_LINK_CAP_MAX_LINK_SPEED                         (PL_LINK_CAP_MAX_LINK_SPEED),
      .PL_LINK_CAP_MAX_LINK_WIDTH                         (PL_LINK_CAP_MAX_LINK_WIDTH),
      .PL_N_FTS_COMCLK_GEN1                               (PL_N_FTS_COMCLK_GEN1),
      .PL_N_FTS_COMCLK_GEN2                               (PL_N_FTS_COMCLK_GEN2),
      .PL_N_FTS_COMCLK_GEN3                               (PL_N_FTS_COMCLK_GEN3),
      .PL_N_FTS_GEN1                                      (PL_N_FTS_GEN1),
      .PL_N_FTS_GEN2                                      (PL_N_FTS_GEN2),
      .PL_N_FTS_GEN3                                      (PL_N_FTS_GEN3),
      .PL_SIM_FAST_LINK_TRAINING                          (PL_SIM_FAST_LINK_TRAINING),
      .PL_UPSTREAM_FACING                                 (PL_UPSTREAM_FACING),
      .PM_ASPML0S_TIMEOUT                                 (PM_ASPML0S_TIMEOUT),
      .PM_ASPML1_ENTRY_DELAY                              (PM_ASPML1_ENTRY_DELAY),
      .PM_ENABLE_SLOT_POWER_CAPTURE                       (PM_ENABLE_SLOT_POWER_CAPTURE),
      .PM_L1_REENTRY_DELAY                                (PM_L1_REENTRY_DELAY),
      .PM_PME_SERVICE_TIMEOUT_DELAY                       (PM_PME_SERVICE_TIMEOUT_DELAY),
      .PM_PME_TURNOFF_ACK_DELAY                           (PM_PME_TURNOFF_ACK_DELAY),
      .SIM_VERSION                                        (SIM_VERSION),
      .SPARE_BIT0                                         (SPARE_BIT0),
      .SPARE_BIT1                                         (SPARE_BIT1),
      .SPARE_BIT2                                         (SPARE_BIT2),
      .SPARE_BIT3                                         (SPARE_BIT3),
      .SPARE_BIT4                                         (SPARE_BIT4),
      .SPARE_BIT5                                         (SPARE_BIT5),
      .SPARE_BIT6                                         (SPARE_BIT6),
      .SPARE_BIT7                                         (SPARE_BIT7),
      .SPARE_BIT8                                         (SPARE_BIT8),
      .SPARE_BYTE0                                        (SPARE_BYTE0),
      .SPARE_BYTE1                                        (SPARE_BYTE1),
      .SPARE_BYTE2                                        (SPARE_BYTE2),
      .SPARE_BYTE3                                        (SPARE_BYTE3),
      .SPARE_WORD0                                        (SPARE_WORD0),
      .SPARE_WORD1                                        (SPARE_WORD1),
      .SPARE_WORD2                                        (SPARE_WORD2),
      .SPARE_WORD3                                        (SPARE_WORD3),
      .SRIOV_CAP_ENABLE                                   (SRIOV_CAP_ENABLE),
      .TL_COMPL_TIMEOUT_REG0                              (TL_COMPL_TIMEOUT_REG0),
      .TL_COMPL_TIMEOUT_REG1                              (TL_COMPL_TIMEOUT_REG1),
      .TL_CREDITS_CD                                      (TL_CREDITS_CD),
      .TL_CREDITS_CH                                      (TL_CREDITS_CH),
      .TL_CREDITS_NPD                                     (TL_CREDITS_NPD),
      .TL_CREDITS_NPH                                     (TL_CREDITS_NPH),
      .TL_CREDITS_PD                                      (TL_CREDITS_PD),
      .TL_CREDITS_PH                                      (TL_CREDITS_PH),
      .TL_ENABLE_MESSAGE_RID_CHECK_ENABLE                 (TL_ENABLE_MESSAGE_RID_CHECK_ENABLE),
      .TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE            (TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE),
      .TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE              (TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE),
      .TL_LEGACY_MODE_ENABLE                              (TL_LEGACY_MODE_ENABLE),
      .TL_PF_ENABLE_REG                                   (TL_PF_ENABLE_REG),
      .TL_TAG_MGMT_ENABLE                                 (TL_TAG_MGMT_ENABLE),
      .VF0_CAPABILITY_POINTER                             (VF0_CAPABILITY_POINTER),
      .VF0_MSIX_CAP_PBA_BIR                               (VF0_MSIX_CAP_PBA_BIR),
      .VF0_MSIX_CAP_PBA_OFFSET                            (VF0_MSIX_CAP_PBA_OFFSET),
      .VF0_MSIX_CAP_TABLE_BIR                             (VF0_MSIX_CAP_TABLE_BIR),
      .VF0_MSIX_CAP_TABLE_OFFSET                          (VF0_MSIX_CAP_TABLE_OFFSET),
      .VF0_MSIX_CAP_TABLE_SIZE                            (VF0_MSIX_CAP_TABLE_SIZE),
      .VF0_MSI_CAP_MULTIMSGCAP                            (VF0_MSI_CAP_MULTIMSGCAP),
      .VF0_PM_CAP_ID                                      (VF0_PM_CAP_ID),
      .VF0_PM_CAP_NEXTPTR                                 (VF0_PM_CAP_NEXTPTR),
      .VF0_PM_CAP_VER_ID                                  (VF0_PM_CAP_VER_ID),
      .VF1_MSIX_CAP_PBA_BIR                               (VF1_MSIX_CAP_PBA_BIR),
      .VF1_MSIX_CAP_PBA_OFFSET                            (VF1_MSIX_CAP_PBA_OFFSET),
      .VF1_MSIX_CAP_TABLE_BIR                             (VF1_MSIX_CAP_TABLE_BIR),
      .VF1_MSIX_CAP_TABLE_OFFSET                          (VF1_MSIX_CAP_TABLE_OFFSET),
      .VF1_MSIX_CAP_TABLE_SIZE                            (VF1_MSIX_CAP_TABLE_SIZE),
      .VF1_MSI_CAP_MULTIMSGCAP                            (VF1_MSI_CAP_MULTIMSGCAP),
      .VF1_PM_CAP_ID                                      (VF1_PM_CAP_ID),
      .VF1_PM_CAP_NEXTPTR                                 (VF1_PM_CAP_NEXTPTR),
      .VF1_PM_CAP_VER_ID                                  (VF1_PM_CAP_VER_ID),
      .VF2_MSIX_CAP_PBA_BIR                               (VF2_MSIX_CAP_PBA_BIR),
      .VF2_MSIX_CAP_PBA_OFFSET                            (VF2_MSIX_CAP_PBA_OFFSET),
      .VF2_MSIX_CAP_TABLE_BIR                             (VF2_MSIX_CAP_TABLE_BIR),
      .VF2_MSIX_CAP_TABLE_OFFSET                          (VF2_MSIX_CAP_TABLE_OFFSET),
      .VF2_MSIX_CAP_TABLE_SIZE                            (VF2_MSIX_CAP_TABLE_SIZE),
      .VF2_MSI_CAP_MULTIMSGCAP                            (VF2_MSI_CAP_MULTIMSGCAP),
      .VF2_PM_CAP_ID                                      (VF2_PM_CAP_ID),
      .VF2_PM_CAP_NEXTPTR                                 (VF2_PM_CAP_NEXTPTR),
      .VF2_PM_CAP_VER_ID                                  (VF2_PM_CAP_VER_ID),
      .VF3_MSIX_CAP_PBA_BIR                               (VF3_MSIX_CAP_PBA_BIR),
      .VF3_MSIX_CAP_PBA_OFFSET                            (VF3_MSIX_CAP_PBA_OFFSET),
      .VF3_MSIX_CAP_TABLE_BIR                             (VF3_MSIX_CAP_TABLE_BIR),
      .VF3_MSIX_CAP_TABLE_OFFSET                          (VF3_MSIX_CAP_TABLE_OFFSET),
      .VF3_MSIX_CAP_TABLE_SIZE                            (VF3_MSIX_CAP_TABLE_SIZE),
      .VF3_MSI_CAP_MULTIMSGCAP                            (VF3_MSI_CAP_MULTIMSGCAP),
      .VF3_PM_CAP_ID                                      (VF3_PM_CAP_ID),
      .VF3_PM_CAP_NEXTPTR                                 (VF3_PM_CAP_NEXTPTR),
      .VF3_PM_CAP_VER_ID                                  (VF3_PM_CAP_VER_ID),
      .VF4_MSIX_CAP_PBA_BIR                               (VF4_MSIX_CAP_PBA_BIR),
      .VF4_MSIX_CAP_PBA_OFFSET                            (VF4_MSIX_CAP_PBA_OFFSET),
      .VF4_MSIX_CAP_TABLE_BIR                             (VF4_MSIX_CAP_TABLE_BIR),
      .VF4_MSIX_CAP_TABLE_OFFSET                          (VF4_MSIX_CAP_TABLE_OFFSET),
      .VF4_MSIX_CAP_TABLE_SIZE                            (VF4_MSIX_CAP_TABLE_SIZE),
      .VF4_MSI_CAP_MULTIMSGCAP                            (VF4_MSI_CAP_MULTIMSGCAP),
      .VF4_PM_CAP_ID                                      (VF4_PM_CAP_ID),
      .VF4_PM_CAP_NEXTPTR                                 (VF4_PM_CAP_NEXTPTR),
      .VF4_PM_CAP_VER_ID                                  (VF4_PM_CAP_VER_ID),
      .VF5_MSIX_CAP_PBA_BIR                               (VF5_MSIX_CAP_PBA_BIR),
      .VF5_MSIX_CAP_PBA_OFFSET                            (VF5_MSIX_CAP_PBA_OFFSET),
      .VF5_MSIX_CAP_TABLE_BIR                             (VF5_MSIX_CAP_TABLE_BIR),
      .VF5_MSIX_CAP_TABLE_OFFSET                          (VF5_MSIX_CAP_TABLE_OFFSET),
      .VF5_MSIX_CAP_TABLE_SIZE                            (VF5_MSIX_CAP_TABLE_SIZE),
      .VF5_MSI_CAP_MULTIMSGCAP                            (VF5_MSI_CAP_MULTIMSGCAP),
      .VF5_PM_CAP_ID                                      (VF5_PM_CAP_ID),
      .VF5_PM_CAP_NEXTPTR                                 (VF5_PM_CAP_NEXTPTR),
      .VF5_PM_CAP_VER_ID                                  (VF5_PM_CAP_VER_ID))
    PCIE_3_0_i
     (.CFGERRCOROUT                                       (CFGERRCOROUT),
      .CFGERRFATALOUT                                     (CFGERRFATALOUT),
      .CFGERRNONFATALOUT                                  (CFGERRNONFATALOUT),
      .CFGEXTREADRECEIVED                                 (CFGEXTREADRECEIVED),
      .CFGEXTWRITERECEIVED                                (CFGEXTWRITERECEIVED),
      .CFGHOTRESETOUT                                     (CFGHOTRESETOUT),
      .CFGINPUTUPDATEDONE                                 (CFGINPUTUPDATEDONE),
      .CFGINTERRUPTAOUTPUT                                (CFGINTERRUPTAOUTPUT),
      .CFGINTERRUPTBOUTPUT                                (CFGINTERRUPTBOUTPUT),
      .CFGINTERRUPTCOUTPUT                                (CFGINTERRUPTCOUTPUT),
      .CFGINTERRUPTDOUTPUT                                (CFGINTERRUPTDOUTPUT),
      .CFGINTERRUPTMSIFAIL                                (CFGINTERRUPTMSIFAIL),
      .CFGINTERRUPTMSIMASKUPDATE                          (CFGINTERRUPTMSIMASKUPDATE),
      .CFGINTERRUPTMSISENT                                (CFGINTERRUPTMSISENT),
      .CFGINTERRUPTMSIXFAIL                               (CFGINTERRUPTMSIXFAIL),
      .CFGINTERRUPTMSIXSENT                               (CFGINTERRUPTMSIXSENT),
      .CFGINTERRUPTSENT                                   (CFGINTERRUPTSENT),
      .CFGLOCALERROR                                      (CFGLOCALERROR),
      .CFGLTRENABLE                                       (CFGLTRENABLE),
      .CFGMCUPDATEDONE                                    (CFGMCUPDATEDONE),
      .CFGMGMTREADWRITEDONE                               (CFGMGMTREADWRITEDONE),
      .CFGMSGRECEIVED                                     (CFGMSGRECEIVED),
      .CFGMSGTRANSMITDONE                                 (CFGMSGTRANSMITDONE),
      .CFGPERFUNCTIONUPDATEDONE                           (CFGPERFUNCTIONUPDATEDONE),
      .CFGPHYLINKDOWN                                     (CFGPHYLINKDOWN),
      .CFGPLSTATUSCHANGE                                  (CFGPLSTATUSCHANGE),
      .CFGPOWERSTATECHANGEINTERRUPT                       (CFGPOWERSTATECHANGEINTERRUPT),
      .CFGTPHSTTREADENABLE                                (CFGTPHSTTREADENABLE),
      .CFGTPHSTTWRITEENABLE                               (CFGTPHSTTWRITEENABLE),
      .DRPRDY                                             (DRPRDY),
      .MAXISCQTLAST                                       (MAXISCQTLAST),
      .MAXISCQTVALID                                      (MAXISCQTVALID),
      .MAXISRCTLAST                                       (MAXISRCTLAST),
      .MAXISRCTVALID                                      (MAXISRCTVALID),
      .PCIERQSEQNUMVLD                                    (PCIERQSEQNUMVLD),
      .PCIERQTAGVLD                                       (PCIERQTAGVLD),
      .PIPERX0POLARITY                                    (PIPERX0POLARITY),
      .PIPERX1POLARITY                                    (PIPERX1POLARITY),
      .PIPERX2POLARITY                                    (PIPERX2POLARITY),
      .PIPERX3POLARITY                                    (PIPERX3POLARITY),
      .PIPERX4POLARITY                                    (PIPERX4POLARITY),
      .PIPERX5POLARITY                                    (PIPERX5POLARITY),
      .PIPERX6POLARITY                                    (PIPERX6POLARITY),
      .PIPERX7POLARITY                                    (PIPERX7POLARITY),
      .PIPETX0COMPLIANCE                                  (PIPETX0COMPLIANCE),
      .PIPETX0DATAVALID                                   (PIPETX0DATAVALID),
      .PIPETX0ELECIDLE                                    (PIPETX0ELECIDLE),
      .PIPETX0STARTBLOCK                                  (PIPETX0STARTBLOCK),
      .PIPETX1COMPLIANCE                                  (PIPETX1COMPLIANCE),
      .PIPETX1DATAVALID                                   (PIPETX1DATAVALID),
      .PIPETX1ELECIDLE                                    (PIPETX1ELECIDLE),
      .PIPETX1STARTBLOCK                                  (PIPETX1STARTBLOCK),
      .PIPETX2COMPLIANCE                                  (PIPETX2COMPLIANCE),
      .PIPETX2DATAVALID                                   (PIPETX2DATAVALID),
      .PIPETX2ELECIDLE                                    (PIPETX2ELECIDLE),
      .PIPETX2STARTBLOCK                                  (PIPETX2STARTBLOCK),
      .PIPETX3COMPLIANCE                                  (PIPETX3COMPLIANCE),
      .PIPETX3DATAVALID                                   (PIPETX3DATAVALID),
      .PIPETX3ELECIDLE                                    (PIPETX3ELECIDLE),
      .PIPETX3STARTBLOCK                                  (PIPETX3STARTBLOCK),
      .PIPETX4COMPLIANCE                                  (PIPETX4COMPLIANCE),
      .PIPETX4DATAVALID                                   (PIPETX4DATAVALID),
      .PIPETX4ELECIDLE                                    (PIPETX4ELECIDLE),
      .PIPETX4STARTBLOCK                                  (PIPETX4STARTBLOCK),
      .PIPETX5COMPLIANCE                                  (PIPETX5COMPLIANCE),
      .PIPETX5DATAVALID                                   (PIPETX5DATAVALID),
      .PIPETX5ELECIDLE                                    (PIPETX5ELECIDLE),
      .PIPETX5STARTBLOCK                                  (PIPETX5STARTBLOCK),
      .PIPETX6COMPLIANCE                                  (PIPETX6COMPLIANCE),
      .PIPETX6DATAVALID                                   (PIPETX6DATAVALID),
      .PIPETX6ELECIDLE                                    (PIPETX6ELECIDLE),
      .PIPETX6STARTBLOCK                                  (PIPETX6STARTBLOCK),
      .PIPETX7COMPLIANCE                                  (PIPETX7COMPLIANCE),
      .PIPETX7DATAVALID                                   (PIPETX7DATAVALID),
      .PIPETX7ELECIDLE                                    (PIPETX7ELECIDLE),
      .PIPETX7STARTBLOCK                                  (PIPETX7STARTBLOCK),
      .PIPETXDEEMPH                                       (PIPETXDEEMPH),
      .PIPETXRCVRDET                                      (PIPETXRCVRDET),
      .PIPETXRESET                                        (PIPETXRESET),
      .PIPETXSWING                                        (PIPETXSWING),
      .PLEQINPROGRESS                                     (PLEQINPROGRESS),
      .CFGFCCPLD                                          (CFGFCCPLD),
      .CFGFCNPD                                           (CFGFCNPD),
      .CFGFCPD                                            (CFGFCPD),
      .CFGVFSTATUS                                        (CFGVFSTATUS),
      .MIREPLAYRAMWRITEDATA                               (MIREPLAYRAMWRITEDATA),
      .MIREQUESTRAMWRITEDATA                              (MIREQUESTRAMWRITEDATA),
      .CFGPERFUNCSTATUSDATA                               (CFGPERFUNCSTATUSDATA),
      .DBGDATAOUT                                         (DBGDATAOUT),
      .DRPDO                                              (DRPDO),
      .CFGVFPOWERSTATE                                    (CFGVFPOWERSTATE),
      .CFGVFTPHSTMODE                                     (CFGVFTPHSTMODE),
      .CFGDPASUBSTATECHANGE                               (CFGDPASUBSTATECHANGE),
      .CFGFLRINPROCESS                                    (CFGFLRINPROCESS),
      .CFGINTERRUPTMSIENABLE                              (CFGINTERRUPTMSIENABLE),
      .CFGINTERRUPTMSIXENABLE                             (CFGINTERRUPTMSIXENABLE),
      .CFGINTERRUPTMSIXMASK                               (CFGINTERRUPTMSIXMASK),
      .CFGLINKPOWERSTATE                                  (CFGLINKPOWERSTATE),
      .CFGOBFFENABLE                                      (CFGOBFFENABLE),
      .CFGPHYLINKSTATUS                                   (CFGPHYLINKSTATUS),
      .CFGRCBSTATUS                                       (CFGRCBSTATUS),
      .CFGTPHREQUESTERENABLE                              (CFGTPHREQUESTERENABLE),
      .MIREPLAYRAMREADENABLE                              (),
      .MIREPLAYRAMWRITEENABLE                             (MIREPLAYRAMWRITEENABLE),
      .PCIERQTAGAV                                        ( ),  // Deprecated
      .PCIETFCNPDAV                                       (PCIETFCNPDAV),
      .PCIETFCNPHAV                                       (PCIETFCNPHAV),
      .PIPERX0EQCONTROL                                   (PIPERX0EQCONTROL),
      .PIPERX1EQCONTROL                                   (PIPERX1EQCONTROL),
      .PIPERX2EQCONTROL                                   (PIPERX2EQCONTROL),
      .PIPERX3EQCONTROL                                   (PIPERX3EQCONTROL),
      .PIPERX4EQCONTROL                                   (PIPERX4EQCONTROL),
      .PIPERX5EQCONTROL                                   (PIPERX5EQCONTROL),
      .PIPERX6EQCONTROL                                   (PIPERX6EQCONTROL),
      .PIPERX7EQCONTROL                                   (PIPERX7EQCONTROL),
      .PIPETX0CHARISK                                     (PIPETX0CHARISK),
      .PIPETX0EQCONTROL                                   (PIPETX0EQCONTROL),
      .PIPETX0POWERDOWN                                   (PIPETX0POWERDOWN),
      .PIPETX0SYNCHEADER                                  (PIPETX0SYNCHEADER),
      .PIPETX1CHARISK                                     (PIPETX1CHARISK),
      .PIPETX1EQCONTROL                                   (PIPETX1EQCONTROL),
      .PIPETX1POWERDOWN                                   (PIPETX1POWERDOWN),
      .PIPETX1SYNCHEADER                                  (PIPETX1SYNCHEADER),
      .PIPETX2CHARISK                                     (PIPETX2CHARISK),
      .PIPETX2EQCONTROL                                   (PIPETX2EQCONTROL),
      .PIPETX2POWERDOWN                                   (PIPETX2POWERDOWN),
      .PIPETX2SYNCHEADER                                  (PIPETX2SYNCHEADER),
      .PIPETX3CHARISK                                     (PIPETX3CHARISK),
      .PIPETX3EQCONTROL                                   (PIPETX3EQCONTROL),
      .PIPETX3POWERDOWN                                   (PIPETX3POWERDOWN),
      .PIPETX3SYNCHEADER                                  (PIPETX3SYNCHEADER),
      .PIPETX4CHARISK                                     (PIPETX4CHARISK),
      .PIPETX4EQCONTROL                                   (PIPETX4EQCONTROL),
      .PIPETX4POWERDOWN                                   (PIPETX4POWERDOWN),
      .PIPETX4SYNCHEADER                                  (PIPETX4SYNCHEADER),
      .PIPETX5CHARISK                                     (PIPETX5CHARISK),
      .PIPETX5EQCONTROL                                   (PIPETX5EQCONTROL),
      .PIPETX5POWERDOWN                                   (PIPETX5POWERDOWN),
      .PIPETX5SYNCHEADER                                  (PIPETX5SYNCHEADER),
      .PIPETX6CHARISK                                     (PIPETX6CHARISK),
      .PIPETX6EQCONTROL                                   (PIPETX6EQCONTROL),
      .PIPETX6POWERDOWN                                   (PIPETX6POWERDOWN),
      .PIPETX6SYNCHEADER                                  (PIPETX6SYNCHEADER),
      .PIPETX7CHARISK                                     (PIPETX7CHARISK),
      .PIPETX7EQCONTROL                                   (PIPETX7EQCONTROL),
      .PIPETX7POWERDOWN                                   (PIPETX7POWERDOWN),
      .PIPETX7SYNCHEADER                                  (PIPETX7SYNCHEADER),
      .PIPETXRATE                                         (PIPETXRATE),
      .PLEQPHASE                                          (PLEQPHASE),
      .MAXISCQTDATA                                       (MAXISCQTDATA),
      .MAXISRCTDATA                                       (MAXISRCTDATA),
      .CFGCURRENTSPEED                                    (CFGCURRENTSPEED),
      .CFGMAXPAYLOAD                                      (CFGMAXPAYLOAD),
      .CFGMAXREADREQ                                      (CFGMAXREADREQ),
      .CFGTPHFUNCTIONNUM                                  (CFGTPHFUNCTIONNUM),
      .PIPERX0EQPRESET                                    (PIPERX0EQPRESET),
      .PIPERX1EQPRESET                                    (PIPERX1EQPRESET),
      .PIPERX2EQPRESET                                    (PIPERX2EQPRESET),
      .PIPERX3EQPRESET                                    (PIPERX3EQPRESET),
      .PIPERX4EQPRESET                                    (PIPERX4EQPRESET),
      .PIPERX5EQPRESET                                    (PIPERX5EQPRESET),
      .PIPERX6EQPRESET                                    (PIPERX6EQPRESET),
      .PIPERX7EQPRESET                                    (PIPERX7EQPRESET),
      .PIPETXMARGIN                                       (PIPETXMARGIN),
      .CFGEXTWRITEDATA                                    (CFGEXTWRITEDATA),
      .CFGINTERRUPTMSIDATA                                (CFGINTERRUPTMSIDATA),
      .CFGMGMTREADDATA                                    (CFGMGMTREADDATA),
      .CFGTPHSTTWRITEDATA                                 (CFGTPHSTTWRITEDATA),
      .PIPETX0DATA                                        (PIPETX0DATA),
      .PIPETX1DATA                                        (PIPETX1DATA),
      .PIPETX2DATA                                        (PIPETX2DATA),
      .PIPETX3DATA                                        (PIPETX3DATA),
      .PIPETX4DATA                                        (PIPETX4DATA),
      .PIPETX5DATA                                        (PIPETX5DATA),
      .PIPETX6DATA                                        (PIPETX6DATA),
      .PIPETX7DATA                                        (PIPETX7DATA),
      .CFGEXTWRITEBYTEENABLE                              (CFGEXTWRITEBYTEENABLE),
      .CFGNEGOTIATEDWIDTH                                 (CFGNEGOTIATEDWIDTH),
      .CFGTPHSTTWRITEBYTEVALID                            (CFGTPHSTTWRITEBYTEVALID),
      .MICOMPLETIONRAMREADENABLEL                         (MICOMPLETIONRAMREADENABLEL),
      .MICOMPLETIONRAMREADENABLEU                         (MICOMPLETIONRAMREADENABLEU),
      .MICOMPLETIONRAMWRITEENABLEL                        (MICOMPLETIONRAMWRITEENABLEL),
      .MICOMPLETIONRAMWRITEENABLEU                        (MICOMPLETIONRAMWRITEENABLEU),
      .MIREQUESTRAMREADENABLE                             (MIREQUESTRAMREADENABLE),
      .MIREQUESTRAMWRITEENABLE                            (MIREQUESTRAMWRITEENABLE),
      .PCIERQSEQNUM                                       (PCIERQSEQNUM),
      .PIPERX0EQLPTXPRESET                                (PIPERX0EQLPTXPRESET),
      .PIPERX1EQLPTXPRESET                                (PIPERX1EQLPTXPRESET),
      .PIPERX2EQLPTXPRESET                                (PIPERX2EQLPTXPRESET),
      .PIPERX3EQLPTXPRESET                                (PIPERX3EQLPTXPRESET),
      .PIPERX4EQLPTXPRESET                                (PIPERX4EQLPTXPRESET),
      .PIPERX5EQLPTXPRESET                                (PIPERX5EQLPTXPRESET),
      .PIPERX6EQLPTXPRESET                                (PIPERX6EQLPTXPRESET),
      .PIPERX7EQLPTXPRESET                                (PIPERX7EQLPTXPRESET),
      .PIPETX0EQPRESET                                    (PIPETX0EQPRESET),
      .PIPETX1EQPRESET                                    (PIPETX1EQPRESET),
      .PIPETX2EQPRESET                                    (PIPETX2EQPRESET),
      .PIPETX3EQPRESET                                    (PIPETX3EQPRESET),
      .PIPETX4EQPRESET                                    (PIPETX4EQPRESET),
      .PIPETX5EQPRESET                                    (PIPETX5EQPRESET),
      .PIPETX6EQPRESET                                    (PIPETX6EQPRESET),
      .PIPETX7EQPRESET                                    (PIPETX7EQPRESET),
      .SAXISCCTREADY                                      (SAXISCCTREADY),
      .SAXISRQTREADY                                      (SAXISRQTREADY),
      .CFGMSGRECEIVEDTYPE                                 (CFGMSGRECEIVEDTYPE),
      .CFGTPHSTTADDRESS                                   (CFGTPHSTTADDRESS),
      .CFGFUNCTIONPOWERSTATE                              (CFGFUNCTIONPOWERSTATE),
      .CFGINTERRUPTMSIMMENABLE                            (CFGINTERRUPTMSIMMENABLE),
      .CFGINTERRUPTMSIVFENABLE                            (CFGINTERRUPTMSIVFENABLE),
      .CFGINTERRUPTMSIXVFENABLE                           (CFGINTERRUPTMSIXVFENABLE),
      .CFGINTERRUPTMSIXVFMASK                             (CFGINTERRUPTMSIXVFMASK),
      .CFGLTSSMSTATE                                      (CFGLTSSMSTATE),
      .CFGTPHSTMODE                                       (CFGTPHSTMODE),
      .CFGVFFLRINPROCESS                                  (CFGVFFLRINPROCESS),
      .CFGVFTPHREQUESTERENABLE                            (CFGVFTPHREQUESTERENABLE),
      .PCIECQNPREQCOUNT                                   (PCIECQNPREQCOUNT),
      .PCIERQTAG                                          (PCIERQTAG),
      .PIPERX0EQLPLFFS                                    (PIPERX0EQLPLFFS),
      .PIPERX1EQLPLFFS                                    (PIPERX1EQLPLFFS),
      .PIPERX2EQLPLFFS                                    (PIPERX2EQLPLFFS),
      .PIPERX3EQLPLFFS                                    (PIPERX3EQLPLFFS),
      .PIPERX4EQLPLFFS                                    (PIPERX4EQLPLFFS),
      .PIPERX5EQLPLFFS                                    (PIPERX5EQLPLFFS),
      .PIPERX6EQLPLFFS                                    (PIPERX6EQLPLFFS),
      .PIPERX7EQLPLFFS                                    (PIPERX7EQLPLFFS),
      .PIPETX0EQDEEMPH                                    (PIPETX0EQDEEMPH),
      .PIPETX1EQDEEMPH                                    (PIPETX1EQDEEMPH),
      .PIPETX2EQDEEMPH                                    (PIPETX2EQDEEMPH),
      .PIPETX3EQDEEMPH                                    (PIPETX3EQDEEMPH),
      .PIPETX4EQDEEMPH                                    (PIPETX4EQDEEMPH),
      .PIPETX5EQDEEMPH                                    (PIPETX5EQDEEMPH),
      .PIPETX6EQDEEMPH                                    (PIPETX6EQDEEMPH),
      .PIPETX7EQDEEMPH                                    (PIPETX7EQDEEMPH),
      .MICOMPLETIONRAMWRITEDATAL                          (MICOMPLETIONRAMWRITEDATAL),
      .MICOMPLETIONRAMWRITEDATAU                          (MICOMPLETIONRAMWRITEDATAU),
      .MAXISRCTUSER                                       (MAXISRCTUSER),
      .CFGEXTFUNCTIONNUMBER                               (CFGEXTFUNCTIONNUMBER),
      .CFGFCCPLH                                          (CFGFCCPLH),
      .CFGFCNPH                                           (CFGFCNPH),
      .CFGFCPH                                            (CFGFCPH),
      .CFGFUNCTIONSTATUS                                  (CFGFUNCTIONSTATUS),
      .CFGMSGRECEIVEDDATA                                 (CFGMSGRECEIVEDDATA),
      .MAXISCQTKEEP                                       (MAXISCQTKEEP),
      .MAXISRCTKEEP                                       (MAXISRCTKEEP),
      .PLGEN3PCSRXSLIDE                                   (PLGEN3PCSRXSLIDE),
      .MAXISCQTUSER                                       (MAXISCQTUSER),
      .MIREPLAYRAMADDRESS                                 (MIREPLAYRAMADDRESS),
      .MIREQUESTRAMREADADDRESSA                           (MIREQUESTRAMREADADDRESSA),
      .MIREQUESTRAMREADADDRESSB                           (MIREQUESTRAMREADADDRESSB),
      .MIREQUESTRAMWRITEADDRESSA                          (MIREQUESTRAMWRITEADDRESSA),
      .MIREQUESTRAMWRITEADDRESSB                          (MIREQUESTRAMWRITEADDRESSB),
      .CFGEXTREGISTERNUMBER                               (CFGEXTREGISTERNUMBER),
      .MICOMPLETIONRAMREADADDRESSAL                       (MICOMPLETIONRAMREADADDRESSAL),
      .MICOMPLETIONRAMREADADDRESSAU                       (MICOMPLETIONRAMREADADDRESSAU),
      .MICOMPLETIONRAMREADADDRESSBL                       (MICOMPLETIONRAMREADADDRESSBL),
      .MICOMPLETIONRAMREADADDRESSBU                       (MICOMPLETIONRAMREADADDRESSBU),
      .MICOMPLETIONRAMWRITEADDRESSAL                      (MICOMPLETIONRAMWRITEADDRESSAL),
      .MICOMPLETIONRAMWRITEADDRESSAU                      (MICOMPLETIONRAMWRITEADDRESSAU),
      .MICOMPLETIONRAMWRITEADDRESSBL                      (MICOMPLETIONRAMWRITEADDRESSBL),
      .MICOMPLETIONRAMWRITEADDRESSBU                      (MICOMPLETIONRAMWRITEADDRESSBU),
      .CFGCONFIGSPACEENABLE                               (CFGCONFIGSPACEENABLE),
      .CFGERRCORIN                                        (CFGERRCORIN),
      .CFGERRUNCORIN                                      (CFGERRUNCORIN),
      .CFGEXTREADDATAVALID                                (CFGEXTREADDATAVALID),
      .CFGHOTRESETIN                                      (CFGHOTRESETIN),
      .CFGINPUTUPDATEREQUEST                              (CFGINPUTUPDATEREQUEST),
      .CFGINTERRUPTMSITPHPRESENT                          (CFGINTERRUPTMSITPHPRESENT),
      .CFGINTERRUPTMSIXINT                                (CFGINTERRUPTMSIXINT),
      .CFGLINKTRAININGENABLE                              (CFGLINKTRAININGENABLE),
      .CFGMCUPDATEREQUEST                                 (CFGMCUPDATEREQUEST),
      .CFGMGMTREAD                                        (CFGMGMTREAD),
      .CFGMGMTTYPE1CFGREGACCESS                           (CFGMGMTTYPE1CFGREGACCESS),
      .CFGMGMTWRITE                                       (CFGMGMTWRITE),
      .CFGMSGTRANSMIT                                     (CFGMSGTRANSMIT),
      .CFGPERFUNCTIONOUTPUTREQUEST                        (CFGPERFUNCTIONOUTPUTREQUEST),
      .CFGPOWERSTATECHANGEACK                             (CFGPOWERSTATECHANGEACK),
      .CFGREQPMTRANSITIONL23READY                         (CFGREQPMTRANSITIONL23READY),
      .CFGTPHSTTREADDATAVALID                             (CFGTPHSTTREADDATAVALID),
      .CORECLK                                            (CORECLK),
      .CORECLKMICOMPLETIONRAML                            (CORECLKMICOMPLETIONRAML),
      .CORECLKMICOMPLETIONRAMU                            (CORECLKMICOMPLETIONRAMU),
      .CORECLKMIREPLAYRAM                                 (CORECLKMIREPLAYRAM),
      .CORECLKMIREQUESTRAM                                (CORECLKMIREQUESTRAM),
      .DRPCLK                                             (DRPCLK),
      .DRPEN                                              (DRPEN),
      .DRPWE                                              (DRPWE),
      .MGMTRESETN                                         (MGMTRESETN),
      .MGMTSTICKYRESETN                                   (MGMTSTICKYRESETN),
      .PCIECQNPREQ                                        (PCIECQNPREQ),
      .PIPECLK                                            (PIPECLK),
      .PIPERESETN                                         (PIPERESETN),
      .PIPERX0DATAVALID                                   (PIPERX0DATAVALID),
      .PIPERX0ELECIDLE                                    (PIPERX0ELECIDLE),
      .PIPERX0EQDONE                                      (PIPERX0EQDONE),
      .PIPERX0EQLPADAPTDONE                               (PIPERX0EQLPADAPTDONE),
      .PIPERX0EQLPLFFSSEL                                 (PIPERX0EQLPLFFSSEL),
      .PIPERX0PHYSTATUS                                   (PIPERX0PHYSTATUS),
      .PIPERX0STARTBLOCK                                  (PIPERX0STARTBLOCK),
      .PIPERX0VALID                                       (PIPERX0VALID),
      .PIPERX1DATAVALID                                   (PIPERX1DATAVALID),
      .PIPERX1ELECIDLE                                    (PIPERX1ELECIDLE),
      .PIPERX1EQDONE                                      (PIPERX1EQDONE),
      .PIPERX1EQLPADAPTDONE                               (PIPERX1EQLPADAPTDONE),
      .PIPERX1EQLPLFFSSEL                                 (PIPERX1EQLPLFFSSEL),
      .PIPERX1PHYSTATUS                                   (PIPERX1PHYSTATUS),
      .PIPERX1STARTBLOCK                                  (PIPERX1STARTBLOCK),
      .PIPERX1VALID                                       (PIPERX1VALID),
      .PIPERX2DATAVALID                                   (PIPERX2DATAVALID),
      .PIPERX2ELECIDLE                                    (PIPERX2ELECIDLE),
      .PIPERX2EQDONE                                      (PIPERX2EQDONE),
      .PIPERX2EQLPADAPTDONE                               (PIPERX2EQLPADAPTDONE),
      .PIPERX2EQLPLFFSSEL                                 (PIPERX2EQLPLFFSSEL),
      .PIPERX2PHYSTATUS                                   (PIPERX2PHYSTATUS),
      .PIPERX2STARTBLOCK                                  (PIPERX2STARTBLOCK),
      .PIPERX2VALID                                       (PIPERX2VALID),
      .PIPERX3DATAVALID                                   (PIPERX3DATAVALID),
      .PIPERX3ELECIDLE                                    (PIPERX3ELECIDLE),
      .PIPERX3EQDONE                                      (PIPERX3EQDONE),
      .PIPERX3EQLPADAPTDONE                               (PIPERX3EQLPADAPTDONE),
      .PIPERX3EQLPLFFSSEL                                 (PIPERX3EQLPLFFSSEL),
      .PIPERX3PHYSTATUS                                   (PIPERX3PHYSTATUS),
      .PIPERX3STARTBLOCK                                  (PIPERX3STARTBLOCK),
      .PIPERX3VALID                                       (PIPERX3VALID),
      .PIPERX4DATAVALID                                   (PIPERX4DATAVALID),
      .PIPERX4ELECIDLE                                    (PIPERX4ELECIDLE),
      .PIPERX4EQDONE                                      (PIPERX4EQDONE),
      .PIPERX4EQLPADAPTDONE                               (PIPERX4EQLPADAPTDONE),
      .PIPERX4EQLPLFFSSEL                                 (PIPERX4EQLPLFFSSEL),
      .PIPERX4PHYSTATUS                                   (PIPERX4PHYSTATUS),
      .PIPERX4STARTBLOCK                                  (PIPERX4STARTBLOCK),
      .PIPERX4VALID                                       (PIPERX4VALID),
      .PIPERX5DATAVALID                                   (PIPERX5DATAVALID),
      .PIPERX5ELECIDLE                                    (PIPERX5ELECIDLE),
      .PIPERX5EQDONE                                      (PIPERX5EQDONE),
      .PIPERX5EQLPADAPTDONE                               (PIPERX5EQLPADAPTDONE),
      .PIPERX5EQLPLFFSSEL                                 (PIPERX5EQLPLFFSSEL),
      .PIPERX5PHYSTATUS                                   (PIPERX5PHYSTATUS),
      .PIPERX5STARTBLOCK                                  (PIPERX5STARTBLOCK),
      .PIPERX5VALID                                       (PIPERX5VALID),
      .PIPERX6DATAVALID                                   (PIPERX6DATAVALID),
      .PIPERX6ELECIDLE                                    (PIPERX6ELECIDLE),
      .PIPERX6EQDONE                                      (PIPERX6EQDONE),
      .PIPERX6EQLPADAPTDONE                               (PIPERX6EQLPADAPTDONE),
      .PIPERX6EQLPLFFSSEL                                 (PIPERX6EQLPLFFSSEL),
      .PIPERX6PHYSTATUS                                   (PIPERX6PHYSTATUS),
      .PIPERX6STARTBLOCK                                  (PIPERX6STARTBLOCK),
      .PIPERX6VALID                                       (PIPERX6VALID),
      .PIPERX7DATAVALID                                   (PIPERX7DATAVALID),
      .PIPERX7ELECIDLE                                    (PIPERX7ELECIDLE),
      .PIPERX7EQDONE                                      (PIPERX7EQDONE),
      .PIPERX7EQLPADAPTDONE                               (PIPERX7EQLPADAPTDONE),
      .PIPERX7EQLPLFFSSEL                                 (PIPERX7EQLPLFFSSEL),
      .PIPERX7PHYSTATUS                                   (PIPERX7PHYSTATUS),
      .PIPERX7STARTBLOCK                                  (PIPERX7STARTBLOCK),
      .PIPERX7VALID                                       (PIPERX7VALID),
      .PIPETX0EQDONE                                      (PIPETX0EQDONE),
      .PIPETX1EQDONE                                      (PIPETX1EQDONE),
      .PIPETX2EQDONE                                      (PIPETX2EQDONE),
      .PIPETX3EQDONE                                      (PIPETX3EQDONE),
      .PIPETX4EQDONE                                      (PIPETX4EQDONE),
      .PIPETX5EQDONE                                      (PIPETX5EQDONE),
      .PIPETX6EQDONE                                      (PIPETX6EQDONE),
      .PIPETX7EQDONE                                      (PIPETX7EQDONE),
      .PLDISABLESCRAMBLER                                 (PLDISABLESCRAMBLER),
      .PLEQRESETEIEOSCOUNT                                (PLEQRESETEIEOSCOUNT),
      .PLGEN3PCSDISABLE                                   (PLGEN3PCSDISABLE),
      .RECCLK                                             (RECCLK),
      .RESETN                                             (RESETN),
      .SAXISCCTLAST                                       (SAXISCCTLAST),
      .SAXISCCTVALID                                      (SAXISCCTVALID),
      .SAXISRQTLAST                                       (SAXISRQTLAST),
      .SAXISRQTVALID                                      (SAXISRQTVALID),
      .USERCLK                                            (USERCLK),
      .DRPADDR                                            (DRPADDR),
      .MICOMPLETIONRAMREADDATA                            (MICOMPLETIONRAMREADDATA),
      .MIREPLAYRAMREADDATA                                (MIREPLAYRAMREADDATA),
      .MIREQUESTRAMREADDATA                               (MIREQUESTRAMREADDATA),
      .CFGDEVID                                           (CFGDEVID),
      .CFGSUBSYSID                                        (CFGSUBSYSID),
      .CFGSUBSYSVENDID                                    (CFGSUBSYSVENDID),
      .CFGVENDID                                          (CFGVENDID),
      .DRPDI                                              (DRPDI),
      .PIPERX0EQLPNEWTXCOEFFORPRESET                      (PIPERX0EQLPNEWTXCOEFFORPRESET),
      .PIPERX1EQLPNEWTXCOEFFORPRESET                      (PIPERX1EQLPNEWTXCOEFFORPRESET),
      .PIPERX2EQLPNEWTXCOEFFORPRESET                      (PIPERX2EQLPNEWTXCOEFFORPRESET),
      .PIPERX3EQLPNEWTXCOEFFORPRESET                      (PIPERX3EQLPNEWTXCOEFFORPRESET),
      .PIPERX4EQLPNEWTXCOEFFORPRESET                      (PIPERX4EQLPNEWTXCOEFFORPRESET),
      .PIPERX5EQLPNEWTXCOEFFORPRESET                      (PIPERX5EQLPNEWTXCOEFFORPRESET),
      .PIPERX6EQLPNEWTXCOEFFORPRESET                      (PIPERX6EQLPNEWTXCOEFFORPRESET),
      .PIPERX7EQLPNEWTXCOEFFORPRESET                      (PIPERX7EQLPNEWTXCOEFFORPRESET),
      .PIPETX0EQCOEFF                                     (PIPETX0EQCOEFF),
      .PIPETX1EQCOEFF                                     (PIPETX1EQCOEFF),
      .PIPETX2EQCOEFF                                     (PIPETX2EQCOEFF),
      .PIPETX3EQCOEFF                                     (PIPETX3EQCOEFF),
      .PIPETX4EQCOEFF                                     (PIPETX4EQCOEFF),
      .PIPETX5EQCOEFF                                     (PIPETX5EQCOEFF),
      .PIPETX6EQCOEFF                                     (PIPETX6EQCOEFF),
      .PIPETX7EQCOEFF                                     (PIPETX7EQCOEFF),
      .CFGMGMTADDR                                        (CFGMGMTADDR),
      .CFGFLRDONE                                         (CFGFLRDONE),
      .CFGINTERRUPTMSITPHTYPE                             (CFGINTERRUPTMSITPHTYPE),
      .CFGINTERRUPTPENDING                                (CFGINTERRUPTPENDING),
      .PIPERX0CHARISK                                     (PIPERX0CHARISK),
      .PIPERX0SYNCHEADER                                  (PIPERX0SYNCHEADER),
      .PIPERX1CHARISK                                     (PIPERX1CHARISK),
      .PIPERX1SYNCHEADER                                  (PIPERX1SYNCHEADER),
      .PIPERX2CHARISK                                     (PIPERX2CHARISK),
      .PIPERX2SYNCHEADER                                  (PIPERX2SYNCHEADER),
      .PIPERX3CHARISK                                     (PIPERX3CHARISK),
      .PIPERX3SYNCHEADER                                  (PIPERX3SYNCHEADER),
      .PIPERX4CHARISK                                     (PIPERX4CHARISK),
      .PIPERX4SYNCHEADER                                  (PIPERX4SYNCHEADER),
      .PIPERX5CHARISK                                     (PIPERX5CHARISK),
      .PIPERX5SYNCHEADER                                  (PIPERX5SYNCHEADER),
      .PIPERX6CHARISK                                     (PIPERX6CHARISK),
      .PIPERX6SYNCHEADER                                  (PIPERX6SYNCHEADER),
      .PIPERX7CHARISK                                     (PIPERX7CHARISK),
      .PIPERX7SYNCHEADER                                  (PIPERX7SYNCHEADER),
      .MAXISCQTREADY                                      (MAXISCQTREADY),
      .MAXISRCTREADY                                      (MAXISRCTREADY),
      .SAXISCCTDATA                                       (SAXISCCTDATA),
      .SAXISRQTDATA                                       (SAXISRQTDATA),
      .CFGDSFUNCTIONNUMBER                                (CFGDSFUNCTIONNUMBER),
      .CFGFCSEL                                           (CFGFCSEL),
      .CFGINTERRUPTMSIATTR                                (CFGINTERRUPTMSIATTR),
      .CFGINTERRUPTMSIFUNCTIONNUMBER                      (CFGINTERRUPTMSIFUNCTIONNUMBER),
      .CFGMSGTRANSMITTYPE                                 (CFGMSGTRANSMITTYPE),
      .CFGPERFUNCSTATUSCONTROL                            (CFGPERFUNCSTATUSCONTROL),
      .CFGPERFUNCTIONNUMBER                               (CFGPERFUNCTIONNUMBER),
      .PIPERX0STATUS                                      (PIPERX0STATUS),
      .PIPERX1STATUS                                      (PIPERX1STATUS),
      .PIPERX2STATUS                                      (PIPERX2STATUS),
      .PIPERX3STATUS                                      (PIPERX3STATUS),
      .PIPERX4STATUS                                      (PIPERX4STATUS),
      .PIPERX5STATUS                                      (PIPERX5STATUS),
      .PIPERX6STATUS                                      (PIPERX6STATUS),
      .PIPERX7STATUS                                      (PIPERX7STATUS),
      .CFGEXTREADDATA                                     (CFGEXTREADDATA),
      .CFGINTERRUPTMSIINT                                 (CFGINTERRUPTMSIINT),
      .CFGINTERRUPTMSIXDATA                               (CFGINTERRUPTMSIXDATA),
      .CFGMGMTWRITEDATA                                   (CFGMGMTWRITEDATA),
      .CFGMSGTRANSMITDATA                                 (CFGMSGTRANSMITDATA),
      .CFGTPHSTTREADDATA                                  (CFGTPHSTTREADDATA),
      .PIPERX0DATA                                        (PIPERX0DATA),
      .PIPERX1DATA                                        (PIPERX1DATA),
      .PIPERX2DATA                                        (PIPERX2DATA),
      .PIPERX3DATA                                        (PIPERX3DATA),
      .PIPERX4DATA                                        (PIPERX4DATA),
      .PIPERX5DATA                                        (PIPERX5DATA),
      .PIPERX6DATA                                        (PIPERX6DATA),
      .PIPERX7DATA                                        (PIPERX7DATA),
      .SAXISCCTUSER                                       (SAXISCCTUSER),
      .CFGINTERRUPTINT                                    (CFGINTERRUPTINT),
      .CFGINTERRUPTMSISELECT                              (CFGINTERRUPTMSISELECT),
      .CFGMGMTBYTEENABLE                                  (CFGMGMTBYTEENABLE),
      .CFGDSDEVICENUMBER                                  (CFGDSDEVICENUMBER),
      .SAXISRQTUSER                                       (SAXISRQTUSER),
      .CFGVFFLRDONE                                       (CFGVFFLRDONE),
      .PIPEEQFS                                           (PIPEEQFS),
      .PIPEEQLF                                           (PIPEEQLF),
      .CFGDSN                                             (CFGDSN),
      .CFGINTERRUPTMSIPENDINGSTATUS                       (CFGINTERRUPTMSIPENDINGSTATUS),
      .CFGINTERRUPTMSIXADDRESS                            (CFGINTERRUPTMSIXADDRESS),
      .CFGDSBUSNUMBER                                     (CFGDSBUSNUMBER),
      .CFGDSPORTNUMBER                                    (CFGDSPORTNUMBER),
      .CFGREVID                                           (CFGREVID),
      .PLGEN3PCSRXSYNCDONE                                (PLGEN3PCSRXSYNCDONE),
      .SAXISCCTKEEP                                       (SAXISCCTKEEP),
      .SAXISRQTKEEP                                       (SAXISRQTKEEP),
      .CFGINTERRUPTMSITPHSTTAG                            (CFGINTERRUPTMSITPHSTTAG));
   // }}} end PCIE_3_0 i



  // {{{ pcie_bram_7vx i
  //--------------------------------------------
  pcie3_7x_v3_0_pcie_bram_7vx
    #(.IMPL_TARGET               (IMPL_TARGET),
      .NO_DECODE_LOGIC           (NO_DECODE_LOGIC),
      .INTERFACE_SPEED           (INTERFACE_SPEED),
      .COMPLETION_SPACE          (COMPLETION_SPACE))
    pcie_bram_7vx_i
     (.clk_i                     (CORECLK),
      .reset_i                   (reset_sync1),
      .mi_rep_addr_i             (MIREPLAYRAMADDRESS),
      .mi_rep_wdata_i            (mim_rep_wdata[127:0]),
      .mi_rep_wdip_i             (mim_rep_wdip[15:0]),
      .mi_rep_wen0_i             (MIREPLAYRAMWRITEENABLE[0]),
      .mi_rep_wen1_i             (MIREPLAYRAMWRITEENABLE[1]),
      .mi_rep_rdata_o            (mim_rep_rdata[127:0]),
      .mi_rep_rdop_o             (mim_rep_rdop[15:0]),
      .mi_req_waddr0_i           (MIREQUESTRAMWRITEADDRESSA),
      .mi_req_waddr1_i           (MIREQUESTRAMWRITEADDRESSB),
      .mi_req_wdata_i            (mim_req_wdata[127:0]),
      .mi_req_wdip_i             (mim_req_wdip[15:0]),
      .mi_req_wen0_i             (MIREQUESTRAMWRITEENABLE[0]),
      .mi_req_wen1_i             (MIREQUESTRAMWRITEENABLE[1]),
      .mi_req_wen2_i             (MIREQUESTRAMWRITEENABLE[2]),
      .mi_req_wen3_i             (MIREQUESTRAMWRITEENABLE[3]),
      .mi_req_raddr0_i           (MIREQUESTRAMREADADDRESSA),
      .mi_req_raddr1_i           (MIREQUESTRAMREADADDRESSB),
      .mi_req_rdata_o            (mim_req_rdata[127:0]),
      .mi_req_rdop_o             (mim_req_rdop[15:0]),
      .mi_req_ren0_i             (MIREQUESTRAMREADENABLE[0]),
      .mi_req_ren1_i             (MIREQUESTRAMREADENABLE[1]),
      .mi_req_ren2_i             (MIREQUESTRAMREADENABLE[2]),
      .mi_req_ren3_i             (MIREQUESTRAMREADENABLE[3]),
      .mi_cpl_waddr0_i           (MICOMPLETIONRAMWRITEADDRESSAL),
      .mi_cpl_waddr1_i           (MICOMPLETIONRAMWRITEADDRESSBL),
      .mi_cpl_waddr2_i           (MICOMPLETIONRAMWRITEADDRESSAU),
      .mi_cpl_waddr3_i           (MICOMPLETIONRAMWRITEADDRESSBU),
      .mi_cpl_wdata_i            (mim_cpl_wdata[127:0]),
      .mi_cpl_wdip_i             (mim_cpl_wdip[15:0]),
      .mi_cpl_wen0_i             (MICOMPLETIONRAMWRITEENABLEL[0]),
      .mi_cpl_wen1_i             (MICOMPLETIONRAMWRITEENABLEL[1]),
      .mi_cpl_wen2_i             (MICOMPLETIONRAMWRITEENABLEL[2]),
      .mi_cpl_wen3_i             (MICOMPLETIONRAMWRITEENABLEL[3]),
      .mi_cpl_wen4_i             (MICOMPLETIONRAMWRITEENABLEU[0]),
      .mi_cpl_wen5_i             (MICOMPLETIONRAMWRITEENABLEU[1]),
      .mi_cpl_wen6_i             (MICOMPLETIONRAMWRITEENABLEU[2]),
      .mi_cpl_wen7_i             (MICOMPLETIONRAMWRITEENABLEU[3]),
      .mi_cpl_raddr0_i           (MICOMPLETIONRAMREADADDRESSAL),
      .mi_cpl_raddr1_i           (MICOMPLETIONRAMREADADDRESSBL),
      .mi_cpl_raddr2_i           (MICOMPLETIONRAMREADADDRESSAU),
      .mi_cpl_raddr3_i           (MICOMPLETIONRAMREADADDRESSBU),
      .mi_cpl_rdata_o            (mim_cpl_rdata[127:0]),
      .mi_cpl_rdop_o             (mim_cpl_rdop[15:0]),
      .mi_cpl_ren0_i             (MICOMPLETIONRAMREADENABLEL[0]),
      .mi_cpl_ren1_i             (MICOMPLETIONRAMREADENABLEL[1]),
      .mi_cpl_ren2_i             (MICOMPLETIONRAMREADENABLEL[2]),
      .mi_cpl_ren3_i             (MICOMPLETIONRAMREADENABLEL[3]),
      .mi_cpl_ren4_i             (MICOMPLETIONRAMREADENABLEU[0]),
      .mi_cpl_ren5_i             (MICOMPLETIONRAMREADENABLEU[1]),
      .mi_cpl_ren6_i             (MICOMPLETIONRAMREADENABLEU[2]),
      .mi_cpl_ren7_i             (MICOMPLETIONRAMREADENABLEU[3]));
   // }}} end pcie_bram_7vx i



endmodule
