-- netcope_adc_ent.vhd
--!
--! \file
--! \brief NetCOPE MI32 addressing infrastructure entity.
--! \author Lukas Kekely <kekely@cesnet.cz>
--! \date 2013 
--!
--! \section License
--!
--! Copyright (C) 2013 CESNET
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!

library IEEE;
use IEEE.std_logic_1164.all;

--! \brief NetCOPE MI32 addressing infrastructure entity. 
entity NETCOPE_ADC is
  generic (
    --! \brief Use pipe on input MI interface.
    IN_PIPE      : boolean := false;
    --! \brief Use pipe on output to ID component.
    ID_PIPE      : boolean := false;
    --! \brief Use pipe on output to BootFPGA component.
    BOOT_PIPE    : boolean := false;
    --! \brief Use pipe on output to Timestamp Unit.
    TSU_PIPE     : boolean := false;
    --! \brief Use pipe on output to Network Module.
    NET_PIPE     : boolean := false;
    --! \brief Use pipe on output to DMA module.
    DMA_PIPE     : boolean := false;
    --! \brief Use pipe on output to Physical Ethernet interface.
    ETH_PIPE     : boolean := false;
    --! \brief Use pipe on output to User Address Space.
    USER_PIPE    : boolean := false
  );
  port(
    --! \name Basic signals
    CLK            : in std_logic;
    RESET          : in std_logic;
      
    --! \name Input MI32 interface from PCI-Express bus.
    IN_MI_DWR        : in  std_logic_vector(31 downto 0);
    IN_MI_ADDR       : in  std_logic_vector(31 downto 0);
    IN_MI_RD         : in  std_logic;
    IN_MI_WR         : in  std_logic;
    IN_MI_BE         : in  std_logic_vector(3 downto 0);
    IN_MI_DRD        : out std_logic_vector(31 downto 0);
    IN_MI_ARDY       : out std_logic;
    IN_MI_DRDY       : out std_logic;
  
    --! \name Output MI32 interface to Identification Component (0x0000:0000-0x0000:1FFF)
    ID_MI_DWR        : out std_logic_vector(31 downto 0);
    ID_MI_ADDR       : out std_logic_vector(31 downto 0);
    ID_MI_RD         : out std_logic;
    ID_MI_WR         : out std_logic;
    ID_MI_BE         : out std_logic_vector(3 downto 0);
    ID_MI_DRD        : in  std_logic_vector(31 downto 0);
    ID_MI_ARDY       : in  std_logic;
    ID_MI_DRDY       : in  std_logic;

    --! \name Output MI32 interface to BootFPGA Component (0x0000:2000-0x0000:3FFF)
    BOOT_MI_DWR      : out std_logic_vector(31 downto 0);
    BOOT_MI_ADDR     : out std_logic_vector(31 downto 0);
    BOOT_MI_RD       : out std_logic;
    BOOT_MI_WR       : out std_logic;
    BOOT_MI_BE       : out std_logic_vector(3 downto 0);
    BOOT_MI_DRD      : in  std_logic_vector(31 downto 0);
    BOOT_MI_ARDY     : in  std_logic;
    BOOT_MI_DRDY     : in  std_logic;
    
    --! \name Output MI32 interface to Timestamp Unit (0x0000:4000-0x0000:7FFF)
    TSU_MI_DWR       : out std_logic_vector(31 downto 0);
    TSU_MI_ADDR      : out std_logic_vector(31 downto 0);
    TSU_MI_RD        : out std_logic;
    TSU_MI_WR        : out std_logic;
    TSU_MI_BE        : out std_logic_vector(3 downto 0);
    TSU_MI_DRD       : in  std_logic_vector(31 downto 0);
    TSU_MI_ARDY      : in  std_logic;
    TSU_MI_DRDY      : in  std_logic;
    
    --! \name Output MI32 interface to Network Module (0x0000:8000-0x0000:BFFF)
    NET_MI_DWR       : out std_logic_vector(31 downto 0);
    NET_MI_ADDR      : out std_logic_vector(31 downto 0);
    NET_MI_RD        : out std_logic;
    NET_MI_WR        : out std_logic;
    NET_MI_BE        : out std_logic_vector(3 downto 0);
    NET_MI_DRD       : in  std_logic_vector(31 downto 0);
    NET_MI_ARDY      : in  std_logic;
    NET_MI_DRDY      : in  std_logic;
    
    --! \name Output MI32 interface to DMA Module (0x0000:C000-0x0000:FFFF)
    DMA_MI_DWR       : out std_logic_vector(31 downto 0);
    DMA_MI_ADDR      : out std_logic_vector(31 downto 0);
    DMA_MI_RD        : out std_logic;
    DMA_MI_WR        : out std_logic;
    DMA_MI_BE        : out std_logic_vector(3 downto 0);
    DMA_MI_DRD       : in  std_logic_vector(31 downto 0);
    DMA_MI_ARDY      : in  std_logic;
    DMA_MI_DRDY      : in  std_logic;
    
    --! \name Output MI32 interface for Physical Ethernet Layer (0x0080:0000-0x00FF:FFFF)
    ETH_MI_DWR      : out std_logic_vector(31 downto 0);
    ETH_MI_ADDR     : out std_logic_vector(31 downto 0);
    ETH_MI_RD       : out std_logic;
    ETH_MI_WR       : out std_logic;
    ETH_MI_BE       : out std_logic_vector(3 downto 0);
    ETH_MI_DRD      : in  std_logic_vector(31 downto 0);
    ETH_MI_ARDY     : in  std_logic;
    ETH_MI_DRDY     : in  std_logic;
    
    --! \name Output MI32 interface to User Application (0x0200:0000-0x03FF:FFFF)
    USER_MI_DWR      : out std_logic_vector(31 downto 0);
    USER_MI_ADDR     : out std_logic_vector(31 downto 0);
    USER_MI_RD       : out std_logic;
    USER_MI_WR       : out std_logic;
    USER_MI_BE       : out std_logic_vector(3 downto 0);
    USER_MI_DRD      : in  std_logic_vector(31 downto 0);
    USER_MI_ARDY     : in  std_logic;
    USER_MI_DRDY     : in  std_logic
  );
end entity;
