-- mi_int_ent.vhd: MI32 interface connection - entity declaration
-- Copyright (C) 2013 CESNET
-- Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity pci_mi_int is
   generic(
      -- BAR0 base address for PCIE->MI32 transalation
      BAR0_BASE_ADDR    : std_logic_vector(31 downto 0) := X"01000000";
      -- BAR1 base address for PCIE->MI32 transalation
      BAR1_BASE_ADDR    : std_logic_vector(31 downto 0) := X"02000000";
      -- BAR2 base address for PCIE->MI32 transalation
      BAR2_BASE_ADDR    : std_logic_vector(31 downto 0) := X"03000000";
      -- BAR3 base address for PCIE->MI32 transalation
      BAR3_BASE_ADDR    : std_logic_vector(31 downto 0) := X"04000000";
      -- BAR4 base address for PCIE->MI32 transalation
      BAR4_BASE_ADDR    : std_logic_vector(31 downto 0) := X"05000000";
      -- BAR5 base address for PCIE->MI32 transalation
      BAR5_BASE_ADDR    : std_logic_vector(31 downto 0) := X"06000000";
      -- Expansion ROM base address for PCIE->MI32 transalation
      EXP_ROM_BASE_ADDR : std_logic_vector(31 downto 0) := X"0A000000"
   );
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK                     : in  std_logic;
      -- Synchronous reset
      RESET                   : in  std_logic;

      -- Registered values from Completer Request interface -------------------
      REG_CQ_DATA             : in  std_logic_vector(255 downto 0);
      REG_CQ_USER_FIRST_BE    : in  std_logic_vector(3 downto 0);
      REG_CQ_USER_LAST_BE     : in  std_logic_vector(3 downto 0);

      -- Interface with cq_int component --------------------------------------
      -- Start of a transaction
      SOP                     : in  std_logic;
      -- Transaction data is valid
      VALID                   : in  std_logic;
      -- Receiver is ready to receive a transaction data
      READY                   : out std_logic;
      -- Type of request (extracted from transaction descriptor)
      REQ_TYPE                : in  std_logic_vector(3 downto 0);
      -- Request address (extracted from transaction descriptor)
      ADDR                    : in  std_logic_vector(63 downto 0);
      -- Size of data to be processed (extracted from transaction descriptor)
      DWORD_COUNT             : in  std_logic_vector(10 downto 0);
      -- ID of the corresponding BAR (extracted from transaction descriptor)
      BAR_ID                  : in  std_logic_vector(2 downto 0);
      -- Significant part of address (extracted from transaction descriptor)
      BAR_APERTURE            : in  std_logic_vector(5 downto 0);

      -- MI32 interface -------------------------------------------------------
      -- Output data
      MI_DWR                  : out std_logic_vector(31 downto 0);
      -- Address bus
      MI_ADDR                 : out std_logic_vector(31 downto 0);
      -- Byte enable signals      
      MI_BE                   : out std_logic_vector(3 downto 0);
      -- Read request
      MI_RD                   : out std_logic;
      -- Write request
      MI_WR                   : out std_logic;
      -- Input data
      MI_DRD                  : in  std_logic_vector(31 downto 0);
      -- Address ready
      MI_ARDY                 : in  std_logic;
      -- Input data ready
      MI_DRDY                 : in  std_logic;
 
      -- Interface with cc_int component --------------------------------------
      -- Read request on CQ interface
      READ_REQ                : out std_logic;
      -- Unsupported request on CQ interface
      UNSUPPORTED_REQ         : out std_logic;
      -- End of data read from FPGA (using MI32)
      EOP                     : out std_logic;
      -- Whole completion has been sent
      COMPLETION_SENT         : in  std_logic;
      -- Write interface of FIFO in cc_int component
      DATA                    : out std_logic_vector(31 downto 0);
      WR                      : out std_logic;
      FULL                    : in  std_logic
   );
end entity pci_mi_int;

