-- cq_int_ent.vhd: Completer Request interface connection - entity
-- Copyright (C) 2013 CESNET
-- Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity cq_int is
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK                     : in std_logic;
      -- Synchronous reset
      RESET                   : in  std_logic;

      -- Completer Request Interface (CQ) - reduced version -------------------
      -- Data bus
      CQ_DATA                 : in std_logic_vector(255 downto 0);
      -- Byte enable for the first Dword of the payload
      CQ_USER_FIRST_BE        : in std_logic_vector(3 downto 0);
      -- Byte enable for the last Dword of the payload
      CQ_USER_LAST_BE         : in std_logic_vector(3 downto 0);
      -- Start of a transaction
      CQ_USER_SOP             : in std_logic;
      -- Transaction processing hint signals 
      CQ_USER_TPH_PRESENT     : in std_logic;
      CQ_USER_TPH_TYPE        : in std_logic_vector(1 downto 0);
      CQ_USER_TPH_ST_TAG      : in std_logic_vector(7 downto 0);
      -- Data on Completer Request interface is valid
      CQ_VALID                : in std_logic;
      -- User application is ready to receive a transaction
      CQ_READY                : out std_logic;

      -- Registered values from Completer Request interface -------------------
      REG_CQ_DATA             : out std_logic_vector(255 downto 0);
      REG_CQ_USER_FIRST_BE    : out std_logic_vector(3 downto 0);
      REG_CQ_USER_LAST_BE     : out std_logic_vector(3 downto 0);
      REG_CQ_USER_TPH_PRESENT : out std_logic;
      REG_CQ_USER_TPH_TYPE    : out std_logic_vector(1 downto 0);
      REG_CQ_USER_TPH_ST_TAG  : out std_logic_vector(7 downto 0);

      -- Interface with mi_int component --------------------------------------
      -- Start of a transaction
      SOP                     : out std_logic;
      -- Transaction data is valid
      VALID                   : out std_logic;
      -- Receiver is ready to receive a transaction data
      READY                   : in std_logic;
      -- Type of request (extracted from transaction descriptor)
      REQ_TYPE                : out std_logic_vector(3 downto 0);
      -- Request address (extracted from transaction descriptor)
      ADDR                    : out std_logic_vector(63 downto 0);
      -- Size of data to be processed (extracted from transaction descriptor)
      DWORD_COUNT             : out std_logic_vector(10 downto 0);
      -- ID of the corresponding BAR (extracted from transaction descriptor)
      BAR_ID                  : out std_logic_vector(2 downto 0);
      -- Significant part of address (extracted from transaction descriptor)
      BAR_APERTURE            : out std_logic_vector(5 downto 0);

      -- Interface with cc_int component --------------------------------------
      -- Lower part of the address
      DATA_LOWER_ADDR         : out std_logic_vector(4 downto 0);
      -- Length of the payload in Dwords
      DATA_DWORD_COUNT        : out std_logic_vector(10 downto 0);
      -- Byte enable for the first Dword of the payload
      USER_FIRST_BE           : out std_logic_vector(3 downto 0);
      -- Byte enable for the last Dword of the payload
      USER_LAST_BE            : out std_logic_vector(3 downto 0)
   );
end entity cq_int;

