
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/eth100g_v1_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  set Component_Name  [  ipgui::add_param $IPINST -name "Component_Name" -display_name {Component Name}]
  set_property tooltip {Component Name} ${Component_Name}
  #Adding Group
  set dsad  [  ipgui::add_group $IPINST -name "dsad" -display_name {IBUF buffer size} -layout horizontal]
  set_property tooltip {Size of FIFO within IBUF} ${dsad}
  set IBUF_DFIFO_BYTES  [  ipgui::add_param $IPINST -name "IBUF_DFIFO_BYTES" -parent ${dsad} -display_name {IBUF_DFIFO_BYTES} -show_label false -show_range false -widget comboBox]
  set_property tooltip {Select IBUF FIFO size} ${IBUF_DFIFO_BYTES}
  set IBUF_DFIFO_BYTES_VALUE  [  ipgui::add_param $IPINST -name "IBUF_DFIFO_BYTES_VALUE" -parent ${dsad} -display_name {IBUF_DFIFO_BYTES_VALUE} -show_label false -show_range false]
  set_property tooltip {IBUF_DFIFO_BYTES} ${IBUF_DFIFO_BYTES_VALUE}

  #Adding Group
  set IBF  [  ipgui::add_group $IPINST -name "IBF" -display_name {Other IBUF settings}]
  set_property tooltip {Other IBUF settings} ${IBF}
  set HDR_WIDTH  [  ipgui::add_param $IPINST -name "HDR_WIDTH" -parent ${IBF} -display_name {HDR_WIDTH} -widget comboBox]
  set_property tooltip {HDR_WIDTH} ${HDR_WIDTH}
  set IBUF_MAC_COUNT  [  ipgui::add_param $IPINST -name "IBUF_MAC_COUNT" -parent ${IBF} -display_name {IBUF_MAC_COUNT}]
  set_property tooltip {IBUF_MAC_COUNT} ${IBUF_MAC_COUNT}
  set INBANDFCS  [  ipgui::add_param $IPINST -name "INBANDFCS" -parent ${IBF} -display_name {INBANDFCS}]
  set_property tooltip {INBANDFCS} ${INBANDFCS}

  #Adding Group
  set OBUF  [  ipgui::add_group $IPINST -name "OBUF" -display_name {OBUF buffer size} -layout horizontal]
  set_property tooltip {Size of FIFO within OBUF} ${OBUF}
  set OBUF_DFIFO_BYTES  [  ipgui::add_param $IPINST -name "OBUF_DFIFO_BYTES" -parent ${OBUF} -display_name {OBUF_DFIFO_BYTES} -show_label false -show_range false -widget comboBox]
  set_property tooltip {Select OBUF FIFO size} ${OBUF_DFIFO_BYTES}
  set OBUF_DFIFO_BYTES_VALUE  [  ipgui::add_param $IPINST -name "OBUF_DFIFO_BYTES_VALUE" -parent ${OBUF} -display_name {OBUF_DFIFO_BYTES_VALUE} -show_label false -show_range false]
  set_property tooltip {OBUF_DFIFO_BYTES} ${OBUF_DFIFO_BYTES_VALUE}

  #Adding Group
  set Other_settings  [  ipgui::add_group $IPINST -name "Other settings" -display_name {Other settings}]
  set_property tooltip {Others settings} ${Other_settings}
  set LED_CTRL_CNTR_SIZE  [  ipgui::add_param $IPINST -name "LED_CTRL_CNTR_SIZE" -parent ${Other_settings} -display_name {LED_CTRL_CNTR_SIZE}]
  set_property tooltip {LED_CTRL_CNTR_SIZE} ${LED_CTRL_CNTR_SIZE}


}

proc update_PARAM_VALUE.IBUF_DFIFO_BYTES_VALUE { PARAM_VALUE.IBUF_DFIFO_BYTES_VALUE PARAM_VALUE.IBUF_DFIFO_BYTES } {
	# Procedure called to update IBUF_DFIFO_BYTES_VALUE when any of the dependent parameters in the arguments change
	
	set IBUF_DFIFO_BYTES_VALUE ${PARAM_VALUE.IBUF_DFIFO_BYTES_VALUE}
	set IBUF_DFIFO_BYTES ${PARAM_VALUE.IBUF_DFIFO_BYTES}
	set values(IBUF_DFIFO_BYTES) [get_property value $IBUF_DFIFO_BYTES]
	set_property value [gen_USERPARAMETER_IBUF_DFIFO_BYTES_VALUE_VALUE $values(IBUF_DFIFO_BYTES)] $IBUF_DFIFO_BYTES_VALUE
}

proc validate_PARAM_VALUE.IBUF_DFIFO_BYTES_VALUE { PARAM_VALUE.IBUF_DFIFO_BYTES_VALUE } {
	# Procedure called to validate IBUF_DFIFO_BYTES_VALUE
	return true
}

proc update_PARAM_VALUE.OBUF_DFIFO_BYTES_VALUE { PARAM_VALUE.OBUF_DFIFO_BYTES_VALUE PARAM_VALUE.OBUF_DFIFO_BYTES } {
	# Procedure called to update OBUF_DFIFO_BYTES_VALUE when any of the dependent parameters in the arguments change
	
	set OBUF_DFIFO_BYTES_VALUE ${PARAM_VALUE.OBUF_DFIFO_BYTES_VALUE}
	set OBUF_DFIFO_BYTES ${PARAM_VALUE.OBUF_DFIFO_BYTES}
	set values(OBUF_DFIFO_BYTES) [get_property value $OBUF_DFIFO_BYTES]
	set_property value [gen_USERPARAMETER_OBUF_DFIFO_BYTES_VALUE_VALUE $values(OBUF_DFIFO_BYTES)] $OBUF_DFIFO_BYTES_VALUE
}

proc validate_PARAM_VALUE.OBUF_DFIFO_BYTES_VALUE { PARAM_VALUE.OBUF_DFIFO_BYTES_VALUE } {
	# Procedure called to validate OBUF_DFIFO_BYTES_VALUE
	return true
}

proc update_PARAM_VALUE.RX_HREM_WIDTH { PARAM_VALUE.RX_HREM_WIDTH PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to update RX_HREM_WIDTH when any of the dependent parameters in the arguments change
	
	set RX_HREM_WIDTH ${PARAM_VALUE.RX_HREM_WIDTH}
	set HDR_WIDTH ${PARAM_VALUE.HDR_WIDTH}
	set values(HDR_WIDTH) [get_property value $HDR_WIDTH]
	set_property value [gen_USERPARAMETER_RX_HREM_WIDTH_VALUE $values(HDR_WIDTH)] $RX_HREM_WIDTH
}

proc validate_PARAM_VALUE.RX_HREM_WIDTH { PARAM_VALUE.RX_HREM_WIDTH } {
	# Procedure called to validate RX_HREM_WIDTH
	return true
}

proc update_PARAM_VALUE.LED_CTRL_CNTR_SIZE { PARAM_VALUE.LED_CTRL_CNTR_SIZE } {
	# Procedure called to update LED_CTRL_CNTR_SIZE when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.LED_CTRL_CNTR_SIZE { PARAM_VALUE.LED_CTRL_CNTR_SIZE } {
	# Procedure called to validate LED_CTRL_CNTR_SIZE
	return true
}

proc update_PARAM_VALUE.OBUF_DFIFO_BYTES { PARAM_VALUE.OBUF_DFIFO_BYTES } {
	# Procedure called to update OBUF_DFIFO_BYTES when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.OBUF_DFIFO_BYTES { PARAM_VALUE.OBUF_DFIFO_BYTES } {
	# Procedure called to validate OBUF_DFIFO_BYTES
	return true
}

proc update_PARAM_VALUE.INBANDFCS { PARAM_VALUE.INBANDFCS } {
	# Procedure called to update INBANDFCS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.INBANDFCS { PARAM_VALUE.INBANDFCS } {
	# Procedure called to validate INBANDFCS
	return true
}

proc update_PARAM_VALUE.IBUF_MAC_COUNT { PARAM_VALUE.IBUF_MAC_COUNT } {
	# Procedure called to update IBUF_MAC_COUNT when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.IBUF_MAC_COUNT { PARAM_VALUE.IBUF_MAC_COUNT } {
	# Procedure called to validate IBUF_MAC_COUNT
	return true
}

proc update_PARAM_VALUE.HDR_WIDTH { PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to update HDR_WIDTH when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.HDR_WIDTH { PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to validate HDR_WIDTH
	return true
}

proc update_PARAM_VALUE.IBUF_DFIFO_BYTES { PARAM_VALUE.IBUF_DFIFO_BYTES } {
	# Procedure called to update IBUF_DFIFO_BYTES when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.IBUF_DFIFO_BYTES { PARAM_VALUE.IBUF_DFIFO_BYTES } {
	# Procedure called to validate IBUF_DFIFO_BYTES
	return true
}


proc update_MODELPARAM_VALUE.IBUF_DFIFO_BYTES { MODELPARAM_VALUE.IBUF_DFIFO_BYTES PARAM_VALUE.IBUF_DFIFO_BYTES } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IBUF_DFIFO_BYTES}] ${MODELPARAM_VALUE.IBUF_DFIFO_BYTES}
}

proc update_MODELPARAM_VALUE.IBUF_HFIFO_BYTES { MODELPARAM_VALUE.IBUF_HFIFO_BYTES PARAM_VALUE.IBUF_DFIFO_BYTES PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	
	set IBUF_HFIFO_BYTES ${MODELPARAM_VALUE.IBUF_HFIFO_BYTES}
	set IBUF_DFIFO_BYTES ${PARAM_VALUE.IBUF_DFIFO_BYTES}
	set HDR_WIDTH ${PARAM_VALUE.HDR_WIDTH}
	set values(IBUF_DFIFO_BYTES) [get_property value $IBUF_DFIFO_BYTES]
	set values(HDR_WIDTH) [get_property value $HDR_WIDTH]
	set_property value [gen_HDLPARAMETER_IBUF_HFIFO_BYTES_VALUE $values(IBUF_DFIFO_BYTES) $values(HDR_WIDTH)] $IBUF_HFIFO_BYTES
}

proc update_MODELPARAM_VALUE.HDR_WIDTH { MODELPARAM_VALUE.HDR_WIDTH PARAM_VALUE.HDR_WIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.HDR_WIDTH}] ${MODELPARAM_VALUE.HDR_WIDTH}
}

proc update_MODELPARAM_VALUE.IBUF_MAC_COUNT { MODELPARAM_VALUE.IBUF_MAC_COUNT PARAM_VALUE.IBUF_MAC_COUNT } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.IBUF_MAC_COUNT}] ${MODELPARAM_VALUE.IBUF_MAC_COUNT}
}

proc update_MODELPARAM_VALUE.INBANDFCS { MODELPARAM_VALUE.INBANDFCS PARAM_VALUE.INBANDFCS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.INBANDFCS}] ${MODELPARAM_VALUE.INBANDFCS}
}

proc update_MODELPARAM_VALUE.OBUF_DFIFO_BYTES { MODELPARAM_VALUE.OBUF_DFIFO_BYTES PARAM_VALUE.OBUF_DFIFO_BYTES } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.OBUF_DFIFO_BYTES}] ${MODELPARAM_VALUE.OBUF_DFIFO_BYTES}
}

proc update_MODELPARAM_VALUE.OBUF_HFIFO_BYTES { MODELPARAM_VALUE.OBUF_HFIFO_BYTES PARAM_VALUE.OBUF_DFIFO_BYTES } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	
	set OBUF_HFIFO_BYTES ${MODELPARAM_VALUE.OBUF_HFIFO_BYTES}
	set OBUF_DFIFO_BYTES ${PARAM_VALUE.OBUF_DFIFO_BYTES}
	set values(OBUF_DFIFO_BYTES) [get_property value $OBUF_DFIFO_BYTES]
	set_property value [gen_HDLPARAMETER_OBUF_HFIFO_BYTES_VALUE $values(OBUF_DFIFO_BYTES)] $OBUF_HFIFO_BYTES
}

proc update_MODELPARAM_VALUE.LED_CTRL_CNTR_SIZE { MODELPARAM_VALUE.LED_CTRL_CNTR_SIZE PARAM_VALUE.LED_CTRL_CNTR_SIZE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.LED_CTRL_CNTR_SIZE}] ${MODELPARAM_VALUE.LED_CTRL_CNTR_SIZE}
}

