-- cgmii_dec_ent.vhd: CGMII_dec unit of CGMII Input buffer - entity
--                    declaration
-- Copyright (C) 2012 CESNET
-- Author(s): Jan Kucera <xkucer73@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;

-- ----------------------------------------------------------------------------
--                           Entity declaration
-- ----------------------------------------------------------------------------

entity cgmii_dec is
   generic(
   	-- Length of link error timeout counter (number of counter bits)
      CNT_ERROR_LENGTH  : integer := 5;
      -- Synthesise design without resets, default values of registers are set
      -- by initialization of signals
      RESET_BY_INIT     : boolean := false
   );
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal (CGMII Receive Clock)
      CLK               : in  std_logic;
      -- Reset signal (CGMII Receive Reset)
      RESET             : in  std_logic;

      -- Input CGMII interface -----------------------------------------------
      -- Data
      RXD               : in  std_logic_vector(511 downto 0);
      -- Control
      RXC               : in  std_logic_vector(63 downto 0);
      
      -- Output FLU-like interface --------------------------------------------
      -- Packet data
      TX_DATA        : out std_logic_vector(511 downto 0);
      -- Start of the packet, active in '1'
      TX_SOP         : out std_logic;
      -- Position of the start of the packet, valid only if SOP is set to '1'.
      TX_SOP_POS     : out std_logic_vector(2 downto 0);
      -- End of the packet, active in '1'.
      TX_EOP         : out std_logic;
      -- Position of the end of the packet, valid only if EOP is set to '1'.
      TX_EOP_POS     : out std_logic_vector(5 downto 0);
      -- Error inside the packet was detected, active in '1'.
      TX_ERR         : out std_logic;

      -- Link status interface ------------------------------------------------
      -- Active when link is up
      LINK_UP           : out std_logic;
      -- Active when a packet is being received
      INCOMING_PACKET	: out std_logic
   );
end entity cgmii_dec;

