# leds.xdc: Constraints for LED ports on FB1CG
# Copyright (C) 2014 CESNET
# Author: Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the Company nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# This software is provided ``as is'', and any express or implied
# warranties, including, but not limited to, the implied warranties of
# merchantability and fitness for a particular purpose are disclaimed.
# In no event shall the company or contributors be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.
#
# $Id$
#


# LED constraints
# Schematic names are:
#    LEDL10 -> LEDL80 for green
#    LEDL11 -> LEDL81 for red
###############################################################################

# ports placement
set_property PACKAGE_PIN P36          [get_ports {LED_GREEN[0]}]
set_property PACKAGE_PIN T35          [get_ports {LED_GREEN[1]}]
set_property PACKAGE_PIN R37          [get_ports {LED_GREEN[2]}]
set_property PACKAGE_PIN T36          [get_ports {LED_GREEN[3]}]
set_property PACKAGE_PIN P9           [get_ports {LED_GREEN[4]}]
set_property PACKAGE_PIN R11          [get_ports {LED_GREEN[5]}]
set_property PACKAGE_PIN V10          [get_ports {LED_GREEN[6]}]
set_property PACKAGE_PIN Y11          [get_ports {LED_GREEN[7]}]
set_property PACKAGE_PIN W37          [get_ports {LED_RED[0]}]
set_property PACKAGE_PIN V37          [get_ports {LED_RED[1]}]
set_property PACKAGE_PIN V35          [get_ports {LED_RED[2]}]
set_property PACKAGE_PIN U37          [get_ports {LED_RED[3]}]
set_property PACKAGE_PIN P10          [get_ports {LED_RED[4]}]
set_property PACKAGE_PIN W11          [get_ports {LED_RED[6]}]
set_property PACKAGE_PIN R12          [get_ports {LED_RED[5]}]
set_property PACKAGE_PIN V12          [get_ports {LED_RED[7]}]

# ports I/O standard
set_property IOSTANDARD  LVCMOS12     [get_ports {LED_GREEN[*]}]
set_property IOSTANDARD  LVCMOS12     [get_ports {LED_RED[*]}]

# ports drive
set_property DRIVE       8            [get_ports {LED_GREEN[*]}]
set_property DRIVE       8            [get_ports {LED_RED[*]}]
